/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCollection;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.app.PurInAlgorithmForInfo;
import com.kingdee.eas.scm.nsrm.app.fromeip.impl.IerpToInwareReceive;
import com.kingdee.eas.scm.nsrm.app.util.QtyChangeCalUtil;
import com.kingdee.eas.scm.nsrm.app.util.SrmCommonUtil;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IerpToInwareUtil {
    private static Logger logger = Logger.getLogger(IerpToInwareReceive.class);
    private final String SAVE = "1";
    private final String SUBMIT = "2";
    private final String AUDIT = "3";
    private final String TOINWARE = "toInware";
    private static IerpToInwareUtil single = null;

    private Map<String, Object> getMultiMap(Context ctx, Map<String, Object> ierpEntryMap, Map<String, PurOrderEntryInfo> orderEntryMap, Map<String, MeasureUnitInfo> unitMap) throws BOSException {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("SELECT MATERIAL.ID,MEASUREUNIT.ID,BASECONVSRATE   ");
        strBuilder.append("where ");
        int count = 0;
        for (String ierpEntryId : ierpEntryMap.keySet()) {
            Map entrymap = (Map)ierpEntryMap.get(ierpEntryId);
            String entryId = ConvertUtil.convertObj2Str(entrymap.get("entryId"));
            String baseunit = ConvertUtil.convertObj2Str(entrymap.get("basicUnit"));
            MeasureUnitInfo baseunitinfo = unitMap.get(baseunit);
            PurOrderEntryInfo entry = orderEntryMap.get(entryId);
            strBuilder.append("(");
            strBuilder.append("MATERIAL.ID = '");
            strBuilder.append(entry.getMaterial().getId());
            strBuilder.append("' and ");
            strBuilder.append("MEASUREUNIT.ID = '");
            strBuilder.append(baseunitinfo.getId().toString());
            strBuilder.append("') ");
            if (++count == ierpEntryMap.keySet().size()) continue;
            strBuilder.append(" or ");
        }
        HashMap<String, Object> multiMap = new HashMap<String, Object>();
        MultiMeasureUnitCollection multiMeasureUnitCollection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(strBuilder.toString());
        for (int i = 0; i < multiMeasureUnitCollection.size(); ++i) {
            MultiMeasureUnitInfo info = multiMeasureUnitCollection.get(i);
            multiMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info);
        }
        return multiMap;
    }

    public Map<String, MeasureUnitInfo> getUnitMap(Context ctx, Set<String> baseUnitNumberSet) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo unitev = ConvertUtil.convertNumSet2EVI(baseUnitNumberSet);
        MeasureUnitCollection measureUnitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(unitev);
        for (int i = 0; i < measureUnitCollection.size(); ++i) {
            MeasureUnitInfo info = measureUnitCollection.get(i);
            unitMap.put(info.getNumber().toString(), info);
        }
        return unitMap;
    }

    private Object getBotpNumber(Map<String, Object> dataMap, Map<String, Map<String, String>> msgMap) {
        if (null == dataMap.get("botpNumber")) {
            HashMap<String, String> errMap = new HashMap<String, String>();
            errMap.put("error", "\u6ca1\u6709\u5bf9\u5e94\u7684BOTP\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5");
            errMap.put("billtype", "");
            errMap.put("billnumber", "");
            errMap.put("billstatus", "");
            msgMap.put("error", errMap);
            return null;
        }
        return dataMap.get("botpNumber");
    }

    private void dealEntryDetailData(Map<String, Map<String, Object>> entryDetailMap, Map<String, Object> map) {
        for (String entryId : map.keySet()) {
            Map entrymap = (Map)map.get(entryId);
            entryDetailMap.put(entryId, entrymap);
        }
    }

    private void dealData(List<Map<String, Set<String>>> dataList, PurOrderEntryInfo oldEntry, PurOrderInfo info, List<Map<String, Map<String, Object>>> dataEntryList, Map<String, Object> entrymap, List<Map<String, PurOrderInfo>> dataBillList, Map<String, Map<String, Set<String>>> ierpIdMap, List<Map<String, String>> ierpAandOrderIDLsit) {
        PurOrderEntryInfo entry = (PurOrderEntryInfo)oldEntry.clone();
        String billid = info.getId().toString();
        String ierpId = ConvertUtil.convertObj2Str(entrymap.get("srcBillId"));
        String ierpEntryid = ConvertUtil.convertObj2Str(entrymap.get("srcEntryId"));
        if (dataList != null && dataList.size() > 0) {
            for (int i = 0; i < dataList.size(); ++i) {
                String newIerpid = "";
                if (ierpAandOrderIDLsit.get(i).get(billid) != null) {
                    newIerpid = ierpAandOrderIDLsit.get(i).get(billid).split(":")[1];
                }
                if (dataList.get(i).get(billid) == null) {
                    HashSet<String> entryIdSet = new HashSet<String>();
                    entryIdSet.add(entry.getId().toString());
                    dataList.get(i).put(billid, entryIdSet);
                    HashMap<String, Map<String, Object>> entryDataMap = new HashMap<String, Map<String, Object>>();
                    entryDataMap.put(entry.getId().toString(), entrymap);
                    dataEntryList.get(i).put(billid, entryDataMap);
                    info.getEntries().clear();
                    PurOrderInfo newInfo = (PurOrderInfo)info.clone();
                    newInfo.getEntries().add(entry);
                    dataBillList.get(i).put(newInfo.getId().toString(), newInfo);
                    ierpAandOrderIDLsit.get(i).put(billid, billid + ":" + ierpId);
                } else if (!dataList.get(i).get(billid).contains(entry.getId().toString()) && ierpIdMap.get(newIerpid).get(billid).contains(ierpEntryid)) {
                    dataList.get(i).get(billid).add(entry.getId().toString());
                    dataEntryList.get(i).get(billid).put(entry.getId().toString(), entrymap);
                    dataBillList.get(i).get(billid).getEntries().add(entry);
                    ierpAandOrderIDLsit.get(i).put(billid, billid + ":" + ierpId);
                } else {
                    if (i != dataList.size() - 1) continue;
                    HashMap billDataMap = new HashMap();
                    HashSet<String> entryIdSet = new HashSet<String>();
                    entryIdSet.add(entry.getId().toString());
                    billDataMap.put(billid, entryIdSet);
                    dataList.add(billDataMap);
                    HashMap entryDataMap = new HashMap();
                    HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>();
                    entryMap.put(entry.getId().toString(), entrymap);
                    entryDataMap.put(billid, entryMap);
                    dataEntryList.add(entryDataMap);
                    info.getEntries().clear();
                    PurOrderInfo newInfo = (PurOrderInfo)info.clone();
                    newInfo.getEntries().add(entry);
                    HashMap<String, PurOrderInfo> dataBillMap = new HashMap<String, PurOrderInfo>();
                    dataBillMap.put(newInfo.getId().toString(), newInfo);
                    dataBillList.add(dataBillMap);
                    HashMap<String, String> orderIdMap = new HashMap<String, String>();
                    orderIdMap.put(billid, billid + ":" + ierpId);
                    ierpAandOrderIDLsit.add(orderIdMap);
                }
                break;
            }
        } else {
            HashMap billDataMap = new HashMap();
            HashSet<String> entryIdSet = new HashSet<String>();
            entryIdSet.add(entry.getId().toString());
            billDataMap.put(billid, entryIdSet);
            dataList.add(billDataMap);
            HashMap entryDataMap = new HashMap();
            HashMap<String, Map<String, Object>> entryMap = new HashMap<String, Map<String, Object>>();
            entryMap.put(entry.getId().toString(), entrymap);
            entryDataMap.put(billid, entryMap);
            dataEntryList.add(entryDataMap);
            info.getEntries().clear();
            PurOrderInfo newInfo = (PurOrderInfo)info.clone();
            newInfo.getEntries().add(entry);
            HashMap<String, PurOrderInfo> dataBillMap = new HashMap<String, PurOrderInfo>();
            dataBillMap.put(newInfo.getId().toString(), newInfo);
            dataBillList.add(dataBillMap);
            HashMap<String, String> orderIdMap = new HashMap<String, String>();
            orderIdMap.put(billid, billid + ":" + ierpId);
            ierpAandOrderIDLsit.add(orderIdMap);
        }
    }

    public void addPurOrderEntry(PurOrderEntryCollection entrycol, PurOrderEntryInfo entry) {
        if (EntryBaseStatusEnum.AUDITED == entry.getBaseStatus()) {
            entrycol.add(entry);
        }
    }

    private BTPTransformResult buidNewPurInWare(Context ctx, IObjectCollection col, String botpnumber) throws BOSException, EASBizException, UuidException, SQLException {
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection cbc = new CoreBillBaseCollection();
        cbc.addObjectCollection(col);
        String purQuotBosType = "783061E3";
        StringBuffer sb = new StringBuffer();
        sb.append("select mapping.fid fid, ext.FIsEffected FIsEffected from T_BOT_MAPPING mapping ").append(" left outer join T_BOT_ExtMapping ext on mapping.FExtMappingID = ext.fid").append(" where mapping.fName = '").append(botpnumber).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
        boolean hasRule = false;
        boolean isEffected = false;
        String botpID = null;
        try {
            if (rs.next()) {
                botpID = rs.getString("fid");
                isEffected = rs.getBoolean("FIsEffected");
                hasRule = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        if (!hasRule) {
            logger.error((Object)"@@@@PurSaloutStocktoInwareHandle,errorMsg:\u6ca1\u6709\u5b9a\u4e49BOTP\u89c4\u5219");
            return null;
        }
        if (!isEffected) {
            logger.error((Object)"@@@@PurSaloutStocktoInwareHandle,errorMsg:BOTP\u89c4\u5219\u672a\u542f\u7528");
        }
        return iBTPManager.transformForBotp(cbc, purQuotBosType, (IObjectPK)new ObjectUuidPK(botpID));
    }

    public void updateBill(Context ctx, IObjectCollection col, Map<String, Map<String, Object>> entryDetailMap, String botpnumber, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws BOSException, EASBizException {
        String entryId;
        Map<String, Object> entryMap;
        int i;
        BTPTransformResult btpTransformResult = new BTPTransformResult();
        try {
            long startTime = System.currentTimeMillis();
            BTPTransformResult newBtpTransformResult = this.buidNewPurInWare(ctx, col, botpnumber);
            long currentTime = System.currentTimeMillis();
            logger.debug((Object)("PurSaloutStocktoInwareHandle.updateBill() botp\u8017\u65f6" + (currentTime - startTime)));
            if (newBtpTransformResult == null) {
                logger.debug((Object)"@@@@PurSaloutStocktoInwareHandle.updateBill():errorMsg:BOTP\u8f6c\u6362\u5931\u8d25");
                this.setPurOrderReturnMsg(entryDetailMap, "BOTP\u8f6c\u6362\u5931\u8d25", "", "", "", msgMap);
            } else {
                IObjectCollection iObjectCollection = newBtpTransformResult.getBills();
                btpTransformResult.addBills(iObjectCollection);
            }
        }
        catch (Exception e) {
            logger.error((Object)("@@@@PurSaloutStocktoInwareHandle.buidNewPurReceival():errorMsg:" + e.getMessage()));
            this.setPurOrderReturnMsg(entryDetailMap, e.getMessage(), "", "", "", msgMap);
        }
        if (btpTransformResult == null || btpTransformResult.getBills() == null || btpTransformResult.getBills().size() <= 0) {
            return;
        }
        long startTime1 = System.currentTimeMillis();
        HashMap<String, Map<String, Object>> datatomap = new HashMap<String, Map<String, Object>>();
        HashSet<String> warehouseSet = new HashSet<String>();
        HashSet<String> projectSet = new HashSet<String>();
        HashSet<String> locationSet = new HashSet<String>();
        HashSet<String> trackSet = new HashSet<String>();
        HashMap<String, String> idwarehouseMap = new HashMap<String, String>();
        HashMap<String, String> idprojectMap = new HashMap<String, String>();
        HashMap<String, String> idlocationMap = new HashMap<String, String>();
        HashMap<String, String> idtrackMap = new HashMap<String, String>();
        Set<String> entryidSet = entryDetailMap.keySet();
        for (String key : entryidSet) {
            Map<String, Object> entryMap2 = entryDetailMap.get(key);
            String entryId2 = entryMap2.get("entryId").toString();
            if (entryMap2.get("warehouse") != null) {
                warehouseSet.add(entryMap2.get("warehouse").toString());
            }
            if (entryMap2.get("location") != null) {
                locationSet.add(entryMap2.get("location").toString());
            }
            if (entryMap2.get("project") != null) {
                projectSet.add(entryMap2.get("project").toString());
            }
            if (entryMap2.get("trace") == null) continue;
            trackSet.add(entryMap2.get("trace").toString());
        }
        HashMap<String, Object> warehouseMap = new HashMap<String, Object>();
        HashMap<String, String> projectMap = new HashMap<String, String>();
        HashMap<String, String> locationMap = new HashMap<String, String>();
        HashMap<String, Object> trackMap = new HashMap<String, Object>();
        EntityViewInfo warehouseev = ConvertUtil.convertNumSet2EVI(warehouseSet);
        EntityViewInfo projectev = ConvertUtil.convertNumSet2EVI(projectSet);
        EntityViewInfo locationev = ConvertUtil.convertNumSet2EVI(locationSet);
        EntityViewInfo trackev = ConvertUtil.convertNumSet2EVI(trackSet);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        warehouseev.setSelector(sic);
        projectev.setSelector(sic);
        locationev.setSelector(sic);
        trackev.setSelector(sic);
        WarehouseCollection warehouseCollection = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseCollection(warehouseev);
        ProjectCollection projectCollection = ProjectFactory.getLocalInstance((Context)ctx).getProjectCollection(projectev);
        LocationCollection locationCollection = LocationFactory.getLocalInstance((Context)ctx).getLocationCollection(locationev);
        TrackNumberCollection trackNumberCollection = TrackNumberFactory.getLocalInstance((Context)ctx).getTrackNumberCollection(trackev);
        for (i = 0; i < warehouseCollection.size(); ++i) {
            WarehouseInfo warehouseInfo = warehouseCollection.get(i);
            warehouseMap.put(warehouseInfo.getId().toString(), warehouseInfo);
            warehouseMap.put(warehouseInfo.getNumber().toString(), warehouseInfo.getId().toString());
        }
        for (i = 0; i < projectCollection.size(); ++i) {
            ProjectInfo projectInfo = projectCollection.get(i);
            projectMap.put(projectInfo.getNumber().toString(), projectInfo.getId().toString());
            projectMap.put(projectInfo.getId().toString(), (String)projectInfo);
        }
        for (i = 0; i < locationCollection.size(); ++i) {
            LocationInfo locationInfo = locationCollection.get(i);
            locationMap.put(locationInfo.getNumber().toString(), locationInfo.getId().toString());
            locationMap.put(locationInfo.getId().toString(), (String)locationInfo);
        }
        for (i = 0; i < trackNumberCollection.size(); ++i) {
            TrackNumberInfo trackNumberInfo = trackNumberCollection.get(i);
            trackMap.put(trackNumberInfo.getNumber().toString(), trackNumberInfo.getId());
            trackMap.put(trackNumberInfo.getId().toString(), trackNumberInfo);
        }
        Map objectMap = new HashMap();
        for (String key : entryidSet) {
            Object exp;
            Object mfg;
            String id;
            String number;
            entryMap = entryDetailMap.get(key);
            entryId = ConvertUtil.convertObj2Str(entryMap.get("entryId"));
            if (entryMap.get("warehouse") != null && warehouseMap.get(entryMap.get("warehouse")) != null) {
                objectMap = (Map)warehouseMap.clone();
                number = ConvertUtil.convertObj2Str(entryMap.get("warehouse"));
                id = warehouseMap.get(number).toString();
                entryMap.put("warehouse", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("location") != null && locationMap.get(entryMap.get("location")) != null) {
                number = entryMap.get("location").toString();
                objectMap = (Map)locationMap.clone();
                id = locationMap.get(number).toString();
                entryMap.put("location", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("project") != null && projectMap.get(entryMap.get("project")) != null) {
                number = entryMap.get("project").toString();
                objectMap = (Map)projectMap.clone();
                id = projectMap.get(number).toString();
                entryMap.put("project", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("trace") != null && trackMap.get(entryMap.get("trace")) != null) {
                objectMap = (Map)trackMap.clone();
                number = entryMap.get("trace").toString();
                id = trackMap.get(number).toString();
                entryMap.put("trace", id);
                objectMap.remove(number);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, objectMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(objectMap);
                }
            }
            if (entryMap.get("lot") != null) {
                HashMap<String, String> lotMap = new HashMap<String, String>();
                lotMap.put("lot", entryMap.get("lot").toString());
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, lotMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(lotMap);
                }
            }
            if ((mfg = entryMap.get("mfg")) != null) {
                HashMap<String, Date> mfgMap = new HashMap<String, Date>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                try {
                    date = simpleDateFormat.parse(mfg.toString());
                }
                catch (ParseException e) {
                    logger.error((Object)("\u751f\u4ea7\u65e5\u671f" + mfg + " \u65f6\u95f4\u89e3\u6790\u9519\u8bef"), (Throwable)e);
                }
                mfgMap.put("mfg", date);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, mfgMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(mfgMap);
                }
            }
            if ((exp = entryMap.get("exp")) != null) {
                HashMap<String, Date> expMap = new HashMap<String, Date>();
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                Date date = null;
                try {
                    date = simpleDateFormat.parse(exp.toString());
                }
                catch (ParseException e) {
                    logger.error((Object)("\u5230\u671f\u65e5\u671f\uff1a" + exp + " \u65f6\u95f4\u89e3\u6790\u9519\u8bef"), (Throwable)e);
                }
                expMap.put("exp", date);
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, expMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(expMap);
                }
            }
            if (entryMap.get("supplierlot") != null) {
                HashMap<String, String> supplierlotMap = new HashMap<String, String>();
                supplierlotMap.put("supplierlot", entryMap.get("supplierlot").toString());
                if (datatomap.get(entryId) == null) {
                    datatomap.put(entryId, supplierlotMap);
                } else {
                    ((Map)datatomap.get(entryId)).putAll(supplierlotMap);
                }
            }
            entryDetailMap.put(key, entryMap);
        }
        for (String key : entryidSet) {
            entryMap = entryDetailMap.get(key);
            entryId = entryMap.get("entryId").toString();
            if (entryMap.get("warehouse") != null) {
                idwarehouseMap.put(entryId, entryMap.get("warehouse").toString());
            }
            if (entryMap.get("location") != null) {
                idlocationMap.put(entryId, entryMap.get("location").toString());
            }
            if (entryMap.get("project") != null) {
                idprojectMap.put(entryId, entryMap.get("project").toString());
            }
            if (entryMap.get("trace") == null) continue;
            idtrackMap.put(entryId, entryMap.get("trace").toString());
        }
        HashMap<String, Map<String, String>> parmsMap = new HashMap<String, Map<String, String>>();
        parmsMap.put("warehouse", idwarehouseMap);
        parmsMap.put("location", idlocationMap);
        parmsMap.put("trace", idtrackMap);
        parmsMap.put("project", idprojectMap);
        long currentTime1 = System.currentTimeMillis();
        logger.debug((Object)("PurSaloutStocktoInwareHandle.updateBill() \u4fdd\u5b58\u4f20\u503c\u8fc7\u6765\u57fa\u7840\u8d44\u6599\u8017\u65f6" + (currentTime1 - startTime1)));
        PurInWarehsBillCollection purInWarehsBillCollection = (PurInWarehsBillCollection)btpTransformResult.getBills();
        this.createBillAfterDeal(ctx, purInWarehsBillCollection, parmsMap, entryDetailMap, datatomap, msgMap, billstatus, billstatus1);
        long currentTime2 = System.currentTimeMillis();
        logger.debug((Object)("PurSaloutStocktoInwareHandle.updateBill() \u751f\u6210\u65b0\u5355\u636e\u64cd\u4f5c\u8017\u65f6" + (currentTime2 - currentTime1)));
    }

    private void createBillAfterDeal(Context ctx, PurInWarehsBillCollection purInWarehsBillCollection, Map<String, Map<String, String>> parmsMap, Map<String, Map<String, Object>> entryDetailMap, Map<String, Map<String, Object>> datatomap, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws EASBizException, BOSException {
        Map<String, Object> detailDataMap = null;
        ArrayList<String> headExtFieldList = null;
        HashMap<String, ICoreBase> iCoreMap = new HashMap();
        ArrayList<String> extFieldList = null;
        Map<String, ICoreBase> headICoreMap = new HashMap<String, ICoreBase>();
        for (int i = 0; i < purInWarehsBillCollection.size(); ++i) {
            PurInWarehsBillInfo purInWarehsBillInfo = purInWarehsBillCollection.get(i);
            for (int j = 0; j < purInWarehsBillInfo.getEntries().size(); ++j) {
                Object srcBillNum;
                PurInWarehsEntryInfo entry = purInWarehsBillInfo.getEntry().get(j);
                String orderentryid = entry.getSourceBillEntryId().toString();
                String warehousenum = parmsMap.get("warehouse").get(orderentryid);
                String locationnum = parmsMap.get("location").get(orderentryid);
                String projectnum = parmsMap.get("project").get(orderentryid);
                String tracknum = parmsMap.get("trace").get(orderentryid);
                detailDataMap = entryDetailMap.get(entry.getSourceBillEntryId().toString());
                if (extFieldList == null) {
                    extFieldList = (ArrayList<String>)detailDataMap.get("extFieldSet");
                    if (extFieldList == null) {
                        extFieldList = new ArrayList<String>();
                    } else {
                        iCoreMap = SrmCommonUtil.getExtICoreMap(ctx, extFieldList, entry.getBOSType().toString());
                    }
                }
                String srcEntryId = detailDataMap.get("srcEntryId").toString();
                String srcbillId = detailDataMap.get("srcBillId").toString();
                String unitQtyStr = ConvertUtil.convertObj2Str(detailDataMap.get("qty"));
                BigDecimal unitQty = BigDecimal.ZERO;
                BigDecimal baseunitQty = BigDecimal.ZERO;
                if (unitQtyStr != null) {
                    unitQty = new BigDecimal(unitQtyStr);
                    entry.setQty(unitQty);
                    if (null != entry.getMaterial()) {
                        String materialId = entry.getMaterial().getId().toString();
                        String baseUnitId = entry.getBaseUnit().getId().toString();
                        String unitId = entry.getUnit().getId().toString();
                        baseunitQty = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialId, unitId, baseUnitId, entry.getQty());
                        entry.setBaseQty(baseunitQty);
                    } else {
                        entry.setBaseQty(entry.getQty());
                    }
                }
                if ((srcBillNum = detailDataMap.get("srcBillNum")) != null) {
                    entry.put("salOutStockNum", (Object)srcBillNum.toString());
                }
                entry.put("saloutstockEntryID", (Object)srcEntryId);
                entry.put("saloutstockID", (Object)srcbillId);
                logger.debug((Object)("\u534f\u540c\u9500\u552e\u53d1\u8d27\u5355\u5206\u5f55ID" + srcEntryId));
                logger.debug((Object)("\u534f\u540c\u9500\u552e\u53d1\u8d27\u5355ID" + srcbillId));
                if (detailDataMap.get("note") != null) {
                    String note = detailDataMap.get("note").toString();
                    entry.setRemark(note);
                }
                if (datatomap.get(orderentryid) == null || entryDetailMap.size() <= 0) continue;
                if (warehousenum != null && datatomap.get(orderentryid).get(warehousenum) != null) {
                    WarehouseInfo warehouseInfo = (WarehouseInfo)datatomap.get(orderentryid).get(warehousenum);
                    entry.setWarehouse(warehouseInfo);
                }
                if (locationnum != null && datatomap.get(orderentryid).get(locationnum) != null) {
                    LocationInfo locationInfo = (LocationInfo)datatomap.get(orderentryid).get(locationnum);
                    entry.setLocation(locationInfo);
                    logger.debug((Object)("\u5e93\u4f4d\u7684\u5355\u636e\u7f16\u7801" + locationInfo.getNumber()));
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("lot") != null) {
                    entry.setLot(datatomap.get(orderentryid).get("lot").toString());
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("mfg") != null) {
                    entry.setMfg((Date)datatomap.get(orderentryid).get("mfg"));
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("exp") != null) {
                    entry.setExp((Date)datatomap.get(orderentryid).get("exp"));
                }
                if (datatomap.get(orderentryid) != null && datatomap.get(orderentryid).get("supplierlot") != null) {
                    entry.setSupplierLotNo(datatomap.get(orderentryid).get("supplierlot").toString());
                }
                if (projectnum != null && datatomap.get(orderentryid).get(projectnum) != null) {
                    ProjectInfo projectInfo = (ProjectInfo)datatomap.get(orderentryid).get(projectnum);
                    entry.setProject(projectInfo);
                }
                if (tracknum != null && datatomap.get(orderentryid).get(tracknum) != null) {
                    TrackNumberInfo trackNumberInfo = (TrackNumberInfo)datatomap.get(orderentryid).get(tracknum);
                    entry.setTrackNumber(trackNumberInfo);
                }
                if (entry.getAssistUnit() != null && entry.getAssistUnit().getId() != null) {
                    if (null != entry.getMaterial()) {
                        String materialId = entry.getMaterial().getId().toString();
                        String assistUnitId = entry.getAssistUnit().getId().toString();
                        String unitId = entry.getUnit().getId().toString();
                        BigDecimal assist = QtyChangeCalUtil.getBaseUnitQty1(ctx, materialId, unitId, assistUnitId, entry.getQty());
                        entry.setAssistQty(assist);
                    } else {
                        entry.setAssistQty(entry.getQty());
                    }
                }
                SrmCommonUtil.setExtFiledValue(extFieldList, iCoreMap, (CoreBaseInfo)entry, detailDataMap);
            }
            if (headExtFieldList == null) {
                headExtFieldList = (ArrayList<String>)detailDataMap.get("extFieldSet");
                if (headExtFieldList == null) {
                    headExtFieldList = new ArrayList<String>();
                } else {
                    headICoreMap = SrmCommonUtil.getExtICoreMap(ctx, headExtFieldList, purInWarehsBillInfo.getBOSType().toString());
                }
            }
            SrmCommonUtil.setExtFiledValue((List<String>)headExtFieldList, headICoreMap, (CoreBaseInfo)purInWarehsBillInfo, detailDataMap);
            PurInAlgorithmForInfo cal = new PurInAlgorithmForInfo(purInWarehsBillInfo, ctx);
            cal.revalue();
            this.afterDealNewBill(ctx, purInWarehsBillInfo, entryDetailMap, msgMap, billstatus, billstatus1);
        }
    }

    private void afterDealNewBill(Context ctx, PurInWarehsBillInfo purInWarehsBillInfo, Map<String, Map<String, Object>> entryDetailMap, Map<String, Map<String, String>> msgMap, Object billstatus, Object billstatus1) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entry.sourceBillEntryId"));
        IPurInWarehsBill iPurInWarehsBill = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
        String status = null;
        if (null != billstatus1) {
            if (billstatus1 instanceof Map) {
                Map billstatusMap = (Map)billstatus1;
                status = (String)billstatusMap.get(purInWarehsBillInfo.getStorageOrgUnit().getNumber());
            } else {
                status = String.valueOf(billstatus1);
            }
        }
        try {
            PurInWarehsBillInfo newInfo;
            iPurInWarehsBill.save((CoreBaseInfo)purInWarehsBillInfo);
            if (null != status && "B".equals(status)) {
                iPurInWarehsBill.submit((CoreBaseInfo)purInWarehsBillInfo);
                newInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(purInWarehsBillInfo.getId()), sic);
                this.setPurInReturnMsg(entryDetailMap, "", "toInware", purInWarehsBillInfo.getNumber().toString(), newInfo.getBaseStatus().getValue() == 4 ? "3" : "2", newInfo, msgMap);
            }
            if ("".equals(status) || null == status || null != status && "C".equals(status)) {
                iPurInWarehsBill.submit((CoreBaseInfo)purInWarehsBillInfo);
                newInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(purInWarehsBillInfo.getId()), sic);
                IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
                if (service.billIsInProcessQueueOrHasProcessInst(purInWarehsBillInfo.getId().toString())) {
                    this.setPurInReturnMsg(entryDetailMap, "\u5355\u636e\u5df2\u7ecf\u8fdb\u5165\u5de5\u4f5c\u6d41", "toInware", purInWarehsBillInfo.getNumber().toString(), "2", newInfo, msgMap);
                } else {
                    if (4 != newInfo.getBaseStatus().getValue()) {
                        iPurInWarehsBill.audit((IObjectPK)new ObjectUuidPK(purInWarehsBillInfo.getId()));
                    }
                    this.setPurInReturnMsg(entryDetailMap, "", "toInware", purInWarehsBillInfo.getNumber().toString(), "3", newInfo, msgMap);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("@@@@PurSaloutStocktoInwareHandle.updateBill()errorMsg:" + e.getMessage()));
            PurInWarehsBillInfo newInfo = iPurInWarehsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(purInWarehsBillInfo.getId()), sic);
            String error = e.getMessage().replace("\n", "").replace(newInfo.getNumber(), "");
            error = error.replace("\\", "");
            if (newInfo.getBaseStatus().getValue() == 2) {
                this.setPurInReturnMsg(entryDetailMap, error, "toInware", purInWarehsBillInfo.getNumber().toString(), "", newInfo, msgMap);
            } else if (newInfo.getBaseStatus().getValue() == 1) {
                this.setPurInReturnMsg(entryDetailMap, error, "toInware", purInWarehsBillInfo.getNumber().toString(), "", newInfo, msgMap);
            }
            iPurInWarehsBill.delete((IObjectPK)new ObjectUuidPK(purInWarehsBillInfo.getId()));
        }
    }

    private void deleteOtherPurInwarehs(Context ctx, PurInWarehsBillInfo newInfo, String id) throws BOSException, EASBizException {
        HashSet<Integer> statusList = new HashSet<Integer>();
        statusList.add(1);
        statusList.add(2);
        StringBuilder strId = new StringBuilder();
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            String srcId = newInfo.getEntry().getObject(i).get("sourceBillEntryId").toString();
            strId.append(srcId);
            if (i == newInfo.getEntries().size() - 1) continue;
            strId.append(",");
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("parent.id"));
        filter.getFilterItems().add(new FilterItemInfo("sourceBillEntryId", (Object)strId.toString(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("parent.baseStatus", statusList, CompareType.INCLUDE));
        evi.setFilter(filter);
        evi.setSelector(sic);
        PurInWarehsEntryCollection purInWarehsEntryCollection = PurInWarehsEntryFactory.getLocalInstance((Context)ctx).getPurInWarehsEntryCollection(evi);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < purInWarehsEntryCollection.size(); ++i) {
            PurInWarehsEntryInfo info = purInWarehsEntryCollection.get(i);
            idSet.add(info.getParent().getId().toString());
        }
        idSet.remove(id);
        IObjectPK[] arrayPK = new IObjectPK[idSet.size()];
        int n = 0;
        for (String key : idSet) {
            arrayPK[n] = new ObjectUuidPK(BOSUuid.read((String)key));
            ++n;
        }
        PurInWarehsBillFactory.getLocalInstance((Context)ctx).delete(arrayPK);
    }

    public void setEntryReturnMsg(Map<String, Object> returnMsgMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        HashMap<String, String> errMap = new HashMap<String, String>();
        errMap.put("error", error);
        errMap.put("billtype", billtype);
        errMap.put("billnumber", number);
        errMap.put("billstatus", billstatus);
        String srcEntryId = returnMsgMap.get("srcEntryId").toString();
        msgMap.put(srcEntryId, errMap);
    }

    public void setPurOrderReturnMsg(Map<String, Map<String, Object>> entryDetailMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        for (String entryid : entryDetailMap.keySet()) {
            this.setPurInReturnMsg(entryDetailMap.get(entryid), error, billtype, number, billstatus, msgMap);
        }
    }

    public void setPurInReturnMsg(Map<String, Map<String, Object>> entryDetailMap, String error, String billtype, String number, String billstatus, PurInWarehsBillInfo newInfo, Map<String, Map<String, String>> msgMap) {
        for (int i = 0; i < newInfo.getEntries().size(); ++i) {
            Map<String, Object> obj;
            PurInWarehsEntryInfo entry = newInfo.getEntry().get(i);
            if (entryDetailMap.keySet().contains(entry.getSourceBillEntryId().toString())) {
                obj = entryDetailMap.get(entry.getSourceBillEntryId().toString());
                this.setPurInReturnMsg(obj, error, billtype, number, billstatus, msgMap);
                continue;
            }
            if (entry.get("saloutstockEntryID") == null || !entryDetailMap.keySet().contains(entry.get("saloutstockEntryID").toString())) continue;
            obj = entryDetailMap.get(entry.get("saloutstockEntryID").toString());
            this.setPurInReturnMsg(obj, error, billtype, number, billstatus, msgMap);
        }
    }

    public void setPurInReturnMsg(Object entryMap, String error, String billtype, String number, String billstatus, Map<String, Map<String, String>> msgMap) {
        Map returnMsgMap = (Map)entryMap;
        HashMap<String, String> errMap = new HashMap<String, String>();
        errMap.put("error", error);
        errMap.put("billtype", billtype);
        errMap.put("billnumber", number);
        errMap.put("billstatus", billstatus);
        String srcEntryId = returnMsgMap.get("srcEntryId").toString();
        msgMap.put(srcEntryId, errMap);
    }

    private IerpToInwareUtil() {
    }

    public static IerpToInwareUtil getInstance() {
        if (single == null) {
            single = new IerpToInwareUtil();
        }
        return single;
    }
}

