/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;

public class SaloutQtyUpdateUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void updateSaloutQtyByOeidAdd(Context ctx, Map<String, Object> statusMap) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("saloutQty"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", statusMap.keySet(), CompareType.INCLUDE));
        view.setFilter(filter);
        PurOrderEntryCollection purCol = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(view);
        PurOrderEntryInfo entry = null;
        BigDecimal saloutqty = BigDecimal.ZERO;
        for (int i = 0; i < purCol.size(); ++i) {
            entry = purCol.get(i);
            if (null != entry.getBigDecimal("saloutQty")) {
                saloutqty = entry.getBigDecimal("saloutQty");
            }
            BigDecimal srmqty = new BigDecimal(String.valueOf(statusMap.get(entry.getId().toString())));
            statusMap.put(entry.getId().toString(), srmqty.add(saloutqty));
        }
        Connection con = null;
        PreparedStatement updateStatement = null;
        con = SaloutQtyUpdateUtil.getConnection(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("update T_SM_PurOrderEntry set ").append("CFSaloutQty").append(" =  ? where fid = ? ");
        try {
            updateStatement = con.prepareStatement(strBuffer.toString());
            for (String id : statusMap.keySet()) {
                BigDecimal qty = new BigDecimal(String.valueOf(statusMap.get(id)));
                updateStatement.setBigDecimal(1, qty);
                updateStatement.setString(2, id);
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup((Statement)updateStatement);
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateStatement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void updateSaloutQtyByOeidSup(Context ctx, Map<String, Object> statusMap) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("saloutQty"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", statusMap.keySet(), CompareType.INCLUDE));
        view.setFilter(filter);
        PurOrderEntryCollection purCol = PurOrderEntryFactory.getLocalInstance((Context)ctx).getPurOrderEntryCollection(view);
        PurOrderEntryInfo entry = null;
        BigDecimal saloutqty = BigDecimal.ZERO;
        for (int i = 0; i < purCol.size(); ++i) {
            entry = purCol.get(i);
            if (null != entry.getBigDecimal("saloutQty")) {
                saloutqty = entry.getBigDecimal("saloutQty");
            }
            BigDecimal srmqty = new BigDecimal(String.valueOf(statusMap.get(entry.getId().toString())));
            statusMap.put(entry.getId().toString(), saloutqty.subtract(srmqty));
        }
        Connection con = null;
        PreparedStatement updateStatement = null;
        con = SaloutQtyUpdateUtil.getConnection(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("update T_SM_PurOrderEntry set ").append("CFSaloutQty").append(" =  ? where fid = ? ");
        try {
            updateStatement = con.prepareStatement(strBuffer.toString());
            for (String id : statusMap.keySet()) {
                BigDecimal qty = new BigDecimal(String.valueOf(statusMap.get(id)));
                updateStatement.setBigDecimal(1, qty);
                updateStatement.setString(2, id);
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup((Statement)updateStatement);
            catch (Throwable throwable) {
                SQLUtils.cleanup(updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)updateStatement);
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }
}

