/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SrmProgressUpdateUtil {
    private static Logger logger = Logger.getLogger(SrmProgressUpdateUtil.class);

    public static void updateExecuteStatusForCol(Context ctx, IObjectCollection billCol, String srmProgress) throws BOSException {
        if (billCol != null && billCol.size() > 0) {
            StringBuffer ids = ConvertUtil.objCol2StrBuf(billCol);
            StringBuffer sql = new StringBuffer();
            String tableField = "CFSrmProgress";
            sql.append("update T_SM_PurOrder set ").append(tableField).append(" = ").append(srmProgress == null ? "null" : srmProgress);
            sql.append("  where ").append("FID").append(ids);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static void updateSrmProgressForField(Context ctx, List<String> list, String field, String srmProgress) throws BOSException {
        if (list != null && list.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String tableField = "CFSrmProgress";
            sql.append("update T_SM_PurOrder set ").append(tableField).append(" = ").append(srmProgress == null ? "null" : srmProgress);
            sql.append(" where ").append(field).append(ConvertUtil.list2StrBuf(list));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    public static void updateSrmProgressForStr(Context ctx, String billno, String field, String srmProgress) throws BOSException {
        Connection con = null;
        con = SrmProgressUpdateUtil.getConnection(ctx);
        StringBuffer sql = new StringBuffer();
        String tableField = "CFSrmProgress";
        sql.append("update T_SM_PurOrder set ").append(tableField).append(" = ").append(srmProgress == null ? "null" : srmProgress);
        sql.append(" where ").append(field).append("='").append(billno).append("'");
        Statement statement = null;
        try {
            statement = con.createStatement();
            statement.execute(sql.toString());
        }
        catch (SQLException exc) {
            throw new BOSException("Sql1 execute exception : " + sql, (Throwable)exc);
        }
        finally {
            SQLUtils.cleanup((Statement)statement, (Connection)con);
        }
    }

    public static void updateSrmProgressForSet(Context ctx, Set<String> idSet, String srmProgress) throws BOSException {
        if (idSet != null && idSet.size() > 0) {
            StringBuffer sql = new StringBuffer();
            String tableField = "CFSrmProgress";
            sql.append("update T_SM_PurOrder set ").append(tableField).append(" = ").append(srmProgress == null ? "null" : srmProgress);
            sql.append(" where ").append("FID").append(ConvertUtil.set2StrBuf(idSet));
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateInvoiceIdForMap(Context ctx, Map<String, String> idMap) throws BOSException {
        Connection con = null;
        PreparedStatement updateStatement = null;
        con = SrmProgressUpdateUtil.getConnection(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("update T_AP_OtherBill set ").append("CFInvoiceID").append(" =  ? where fnumber = ? ");
        try {
            updateStatement = con.prepareStatement(strBuffer.toString());
            for (String invoiceID : idMap.keySet()) {
                String srmProgress = idMap.get(invoiceID);
                updateStatement.setString(1, srmProgress);
                updateStatement.setString(2, invoiceID);
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Statement)updateStatement, (Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSrmProgressForMap(Context ctx, Map<String, String> statusMap) throws BOSException {
        Connection con = null;
        PreparedStatement updateStatement = null;
        con = SrmProgressUpdateUtil.getConnection(ctx);
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("update T_SM_PurOrder set ").append("CFSrmProgress").append(" =  ? where fid = ? ");
        try {
            updateStatement = con.prepareStatement(strBuffer.toString());
            for (String id : statusMap.keySet()) {
                String srmProgress = statusMap.get(id);
                updateStatement.setString(1, srmProgress);
                updateStatement.setString(2, id);
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
        }
        catch (SQLException sQLException) {
        }
        finally {
            SQLUtils.cleanup((Statement)updateStatement, (Connection)con);
        }
    }

    private static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static String getsrmProgress(String status) {
        if ("A".equals(status)) {
            return "4";
        }
        if ("B".equals(status)) {
            return "5";
        }
        if ("C".equals(status)) {
            return "6";
        }
        if ("D".equals(status)) {
            return "7";
        }
        if ("E".equals(status)) {
            return "8";
        }
        if ("F".equals(status)) {
            return "9";
        }
        if ("G".equals(status)) {
            return "10";
        }
        if (status == null || "".equals(status)) {
            return "1";
        }
        return null;
    }

    public static void updateStatusByQty(Context ctx, PurOrderCollection newBillCol, Boolean NotOrderSend) throws BOSException {
        PurOrderInfo info = null;
        PurOrderEntryInfo entry = null;
        boolean ispartRecive = false;
        boolean ispartInware = false;
        boolean ispartSalout = false;
        boolean isAllSalout = false;
        boolean isAllRecive = false;
        boolean isAllInware = false;
        boolean label1 = false;
        boolean label2 = false;
        boolean label3 = false;
        int countInware = 0;
        int countReceive = 0;
        int countSalout = 0;
        HashMap<String, String> id_statusMap = new HashMap<String, String>();
        for (int i = 0; i < newBillCol.size(); ++i) {
            ispartRecive = false;
            ispartInware = false;
            isAllRecive = false;
            isAllInware = false;
            ispartRecive = false;
            ispartInware = false;
            countInware = 0;
            countReceive = 0;
            countSalout = 0;
            info = newBillCol.get(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entry = info.getEntries().get(j);
                if (entry.getQty().compareTo(BigDecimal.ZERO) == 0) {
                    ++countInware;
                    ++countReceive;
                    ++countSalout;
                    continue;
                }
                if (entry.getTotalReceiptQty().compareTo(BigDecimal.ZERO) != 0) {
                    if (entry.getTotalReceiptQty().subtract(entry.getTotalSupplyStockQty()).compareTo(entry.getQty()) == -1) {
                        ispartInware = true;
                        continue;
                    }
                    isAllInware = true;
                    ++countInware;
                    continue;
                }
                label1 = true;
                if (entry.getTotalReceiveQty().compareTo(BigDecimal.ZERO) != 0) {
                    if (entry.getTotalReceiveQty().compareTo(entry.getQty()) == -1) {
                        ispartRecive = true;
                        continue;
                    }
                    isAllRecive = true;
                    ++countReceive;
                    continue;
                }
                label2 = true;
                BigDecimal saloutqty = entry.getBigDecimal("saloutQty");
                if (null == saloutqty) {
                    saloutqty = BigDecimal.ZERO;
                }
                if (saloutqty.compareTo(BigDecimal.ZERO) != 0) {
                    if (saloutqty.compareTo(entry.getQty()) == -1) {
                        ispartSalout = true;
                        continue;
                    }
                    isAllSalout = true;
                    ++countSalout;
                    continue;
                }
                label3 = true;
            }
            if (ispartInware || isAllInware && countInware < info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "9");
                continue;
            }
            if (isAllInware && countInware == info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "10");
                continue;
            }
            if (ispartRecive || isAllRecive && countReceive < info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "7");
                continue;
            }
            if (isAllRecive && countReceive == info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "8");
                continue;
            }
            if (ispartSalout || isAllSalout && countSalout < info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "5");
                continue;
            }
            if (isAllSalout && countSalout == info.getEntries().size()) {
                id_statusMap.put(info.getId().toString(), "6");
                continue;
            }
            if (!label1 || !label2 || !label3 || !NotOrderSend.booleanValue()) continue;
            id_statusMap.put(info.getId().toString(), "4");
        }
        if (newBillCol.size() > 0 && id_statusMap.keySet().size() > 0) {
            SrmProgressUpdateUtil.updateSrmProgressForMap(ctx, id_statusMap);
        }
    }
}

