/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.nsrm.FetchFacadeFactory;
import com.kingdee.eas.scm.nsrm.NSRMBizException;
import com.kingdee.eas.scm.nsrm.model.IerpUrlModel;
import com.kingdee.eas.scm.nsrm.util.ConvertUtil;
import com.kingdee.eas.scm.nsrm.util.SrmSettingUtil;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class OpenIERPHelper {
    private static Logger logger = Logger.getLogger(OpenIERPHelper.class);

    public static IerpUrlModel getOpen2IERPParam(Context ctx) throws EASBizException, BOSException {
        IerpUrlModel urlModel = new IerpUrlModel();
        Map retMap = new HashMap();
        retMap = ctx == null ? FetchFacadeFactory.getRemoteInstance().getOpenParam(null) : FetchFacadeFactory.getLocalInstance(ctx).getOpenParam(null);
        String paramValue = String.valueOf(retMap.get("paramValue"));
        if ("1".equals(paramValue)) {
            urlModel.setUser(ConvertUtil.convertObj2Str(retMap.get("user")));
            urlModel.setToken(ConvertUtil.convertObj2Str(retMap.get("token")));
            Map<String, String> map = SrmSettingUtil.getWSServiceURL(ctx);
            urlModel.setUrl(map.get("url"));
            urlModel.setTenantId(map.get("tenantId"));
            urlModel.setAccountId(map.get("accountId"));
        } else {
            urlModel.setUser(ConvertUtil.convertObj2Str(retMap.get("user1")));
            urlModel.setToken(ConvertUtil.convertObj2Str(retMap.get("token1")));
            urlModel.setUrl(String.valueOf(retMap.get("ierp_server_url")));
            urlModel.setTenantId(String.valueOf(retMap.get("tenantid")));
            urlModel.setAccountId(String.valueOf(retMap.get("accountId")));
        }
        if (urlModel.getUser() == null) {
            throw new NSRMBizException(NSRMBizException.LOGIN_PHONE_ISNULL);
        }
        return urlModel;
    }

    public static String constructOpenUrl(IerpUrlModel urlModel) throws EASBizException, BOSException {
        String user = urlModel.getUser();
        String token = urlModel.getToken();
        String url = urlModel.getUrl();
        String tenantId = urlModel.getTenantId();
        String appNumber = urlModel.getAppNumber();
        String type = urlModel.getType();
        String formId = urlModel.getFormId();
        String billFormId = urlModel.getBillFormId();
        String customfilter = urlModel.getCustomfilter();
        String accountId = urlModel.getAccountId();
        StringBuffer urlGet = new StringBuffer();
        if ("/kingdee/scm/mainpagenew/mainpage.html#/".equals(formId)) {
            urlGet.append(url).append(formId);
        } else {
            urlGet.append(url).append("/auth/ltpaTokenLogin.do?");
            urlGet.append("tenantId");
            urlGet.append("=").append(tenantId).append("&").append("accountId").append("=").append(accountId).append("&");
            urlGet.append("user").append("=");
            urlGet.append(user).append("&").append("token").append("=").append(token).append("&redirect=").append(url).append("/index.html#/dform?");
            urlGet.append("appNumber").append("=").append(appNumber);
            if (!ConvertUtil.isEmpty(formId)) {
                urlGet.append("&").append("formId").append("=").append(formId);
            }
            if (!ConvertUtil.isEmpty(billFormId)) {
                urlGet.append("&").append("billFormId").append("=").append(billFormId);
            }
            if (!ConvertUtil.isEmpty(type)) {
                urlGet.append("&").append("type").append("=").append(type);
            }
            if (!ConvertUtil.isEmpty(customfilter)) {
                urlGet.append("&").append("customfilter").append("=").append(customfilter);
            }
        }
        return urlGet.toString();
    }

    public static boolean openURL4Get(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser != null) {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getConstructOpenUrl(Context ctx, Map map) throws EASBizException, BOSException {
        if (map == null) {
            return null;
        }
        String appNumber = ConvertUtil.convertObj2Str(map.get("appNumber"));
        String formId = ConvertUtil.convertObj2Str(map.get("formId"));
        String billFormId = ConvertUtil.convertObj2Str(map.get("billFormId"));
        String type = ConvertUtil.convertObj2Str(map.get("type"));
        String customfilter = ConvertUtil.convertObj2Str(map.get("customfilter"));
        IerpUrlModel urlModel = new IerpUrlModel();
        urlModel = OpenIERPHelper.getOpen2IERPParam(ctx);
        urlModel.setFormId(formId);
        urlModel.setBillFormId(billFormId);
        urlModel.setType(type);
        urlModel.setCustomfilter(customfilter);
        urlModel.setAppNumber(appNumber == null ? "pur" : appNumber);
        String urlGet = OpenIERPHelper.constructOpenUrl(urlModel);
        return urlGet;
    }

    public static void openIERP(Context ctx, Map map) throws EASBizException, BOSException {
        if (map == null) {
            return;
        }
        String urlGet = OpenIERPHelper.getConstructOpenUrl(ctx, map);
        OpenIERPHelper.openURL4Get(urlGet);
    }
}

