/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.nsrm.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.nsrm.SrmParamCollection;
import com.kingdee.eas.scm.nsrm.SrmParamFactory;
import com.kingdee.eas.scm.nsrm.SrmParamInfo;
import com.kingdee.eas.scm.nsrm.SrmParamItemCollection;
import com.kingdee.eas.scm.nsrm.SrmParamItemFactory;
import com.kingdee.eas.scm.nsrm.SrmParamItemInfo;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class SrmParamUtil {
    private static Logger logger = Logger.getLogger(SrmParamUtil.class);

    public static String getSrmParamValue(String number, CtrlUnitInfo cuInfo) throws BOSException, EASBizException {
        if (number == null || cuInfo == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(SrmParamUtil.getSrmParamItemSelector());
        SrmParamItemCollection col = SrmParamItemFactory.getRemoteInstance().getSrmParamItemCollection(view);
        if (col != null && col.size() > 0) {
            return col.get(0).getItemValue();
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(SrmParamUtil.getSrmParamSelector());
        SrmParamCollection paramCol = SrmParamFactory.getRemoteInstance().getSrmParamCollection(view);
        SrmParamUtil.initParamItem(cuInfo);
        return paramCol == null ? null : paramCol.get(0).getDefaultValue();
    }

    public static void initParamItem(CtrlUnitInfo cuInfo) throws BOSException, EASBizException {
        if (cuInfo == null) {
            return;
        }
        String cuId = cuInfo.getId().toString();
        SrmParamCollection srmParamCol = SrmParamFactory.getRemoteInstance().getSrmParamCollection();
        if (srmParamCol == null) {
            return;
        }
        HashMap<String, SrmParamInfo> needAddMap = new HashMap<String, SrmParamInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuId, CompareType.EQUALS));
        view.setFilter(filter);
        SrmParamItemCollection srmParamItemCol = SrmParamItemFactory.getRemoteInstance().getSrmParamItemCollection(view);
        String keyId = null;
        ArrayList<String> itemList = new ArrayList<String>();
        int size = srmParamItemCol.size();
        for (int i = 0; i < size; ++i) {
            keyId = srmParamItemCol.get(i).getKeyID().getId().toString();
            itemList.add(keyId);
        }
        String id = null;
        SrmParamInfo srmParamInfo = null;
        int size2 = srmParamCol.size();
        for (int i = 0; i < size2; ++i) {
            srmParamInfo = srmParamCol.get(i);
            id = srmParamInfo.getId().toString();
            if (itemList != null && itemList.contains(id)) continue;
            needAddMap.put(id, srmParamInfo);
        }
        SrmParamItemInfo itemInfo = null;
        srmParamInfo = null;
        if (needAddMap == null || needAddMap.size() <= 0) {
            return;
        }
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)SysContext.getSysContext().getCurrentUserInfo().getId().toString()));
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        for (String i : needAddMap.keySet()) {
            srmParamInfo = (SrmParamInfo)needAddMap.get(i);
            itemInfo = new SrmParamItemInfo();
            itemInfo.setCU(cuInfo);
            itemInfo.setKeyID(srmParamInfo);
            itemInfo.setItemValue(srmParamInfo.getDefaultValue());
            itemInfo.setCreator(userInfo);
            itemInfo.setCreateTime(ts);
            itemInfo.setLastUpdateUser(userInfo);
            itemInfo.setLastUpdateTime(ts);
            SrmParamItemFactory.getRemoteInstance().addnew((CoreBaseInfo)itemInfo);
        }
    }

    public static SelectorItemCollection getSrmParamItemSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("itemValue"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateUser.number"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("keyID.id"));
        sic.add(new SelectorItemInfo("keyID.number"));
        sic.add(new SelectorItemInfo("keyID.name"));
        sic.add(new SelectorItemInfo("keyID.description"));
        sic.add(new SelectorItemInfo("keyID.defaultValue"));
        sic.add(new SelectorItemInfo("keyID.dataType"));
        sic.add(new SelectorItemInfo("keyID.isShow"));
        return sic;
    }

    public static SelectorItemCollection getSrmParamSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("defaultValue"));
        sic.add(new SelectorItemInfo("dataType"));
        sic.add(new SelectorItemInfo("isShow"));
        return sic;
    }
}

