/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.etl;

import com.kingdee.bos.Context;
import com.kingdee.bos.util.XMLParser;
import com.kingdee.eas.util.app.DbUtil;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class PurReportXMLProcess {
    private static String DW_FACT_SM_PURRECEIVED_RULE = "period";
    private static String DW_FACT_SM_PURORDER_RULE = "period";
    private static String DW_FACT_SM_PURCOST_RULE = "period";
    private static String CONFIG_PATH = "purreportsql.xml";
    private static String DW_FACT_SM_PURRECEIVED_TABLENAME = "DW_FACT_SM_PurReceived";
    private static String DW_FACT_SM_PURORDER_TABLENAME = "DW_FACT_SM_PurOrder";
    private static String DW_FACT_SM_PURCOST_TABLENAME = "DW_FACT_SM_PurCost";
    private static String DW_DIM_ORG_PURCHASE_TABLENAME = "DW_Dim_Org_Purchase";
    private static Map sqlOverWriteMap = new HashMap();
    private static Map sqlInsertMap = new HashMap();
    private static PurReportXMLProcess process = null;
    private static String SQL_POLICY_OVERWRITE = "overwrite";
    private static String SQL_POLICY_INSERT = "insert";

    public PurReportXMLProcess() throws Exception {
        this.initXML();
    }

    private void initXML() throws Exception {
        Element root;
        InputStream inputStream = PurReportXMLProcess.class.getResourceAsStream(CONFIG_PATH);
        try {
            root = XMLParser.parseXML((InputStream)inputStream).getRootElement();
        }
        finally {
            if (null != inputStream) {
                inputStream.close();
            }
        }
        List childrens = root.getChildren();
        int size = childrens.size();
        for (int i = 0; i < size; ++i) {
            Element ruleelement;
            Element element = (Element)childrens.get(i);
            String tableName = element.getAttributeValue("id");
            List ruleList = element.getChildren();
            int num = ruleList.size();
            for (int j = 0; j < num && (ruleelement = (Element)ruleList.get(j)).getAttributeValue("id").equalsIgnoreCase(DW_FACT_SM_PURRECEIVED_RULE) && ruleelement.getAttributeValue("id").equalsIgnoreCase(DW_FACT_SM_PURORDER_RULE) && ruleelement.getAttributeValue("id").equalsIgnoreCase(DW_FACT_SM_PURCOST_RULE); ++j) {
                List sqlList = ruleelement.getChildren();
                int count = sqlList.size();
                for (int k = 0; k < count; ++k) {
                    Element elementSql = (Element)sqlList.get(k);
                    if (elementSql.getAttributeValue("policy").equalsIgnoreCase(SQL_POLICY_OVERWRITE)) {
                        sqlOverWriteMap.put(tableName, elementSql.getText());
                    }
                    if (!elementSql.getAttributeValue("policy").equalsIgnoreCase(SQL_POLICY_INSERT)) continue;
                    sqlInsertMap.put(tableName, elementSql.getText());
                }
            }
        }
    }

    public static PurReportXMLProcess getInstance() throws Exception {
        if (process == null) {
            process = new PurReportXMLProcess();
        }
        return process;
    }

    public void executeDumpData(Context ctx, String tableName, String policy) throws Exception {
        if (policy.equalsIgnoreCase(SQL_POLICY_OVERWRITE)) {
            if (sqlOverWriteMap != null) {
                String sql = sqlOverWriteMap.get(tableName).toString();
                if (tableName.equalsIgnoreCase(DW_FACT_SM_PURORDER_TABLENAME) || tableName.equalsIgnoreCase(DW_DIM_ORG_PURCHASE_TABLENAME)) {
                    StringBuffer truncateSql = new StringBuffer();
                    truncateSql.append(" truncate table ").append(tableName);
                    DbUtil.execute((Context)ctx, (String)truncateSql.toString());
                }
                DbUtil.execute((Context)ctx, (String)sql);
            }
        } else if (policy.equalsIgnoreCase(SQL_POLICY_INSERT) && sqlInsertMap != null) {
            String sql = sqlInsertMap.get(tableName).toString();
            DbUtil.execute((Context)ctx, (String)sql);
        }
    }
}

