/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.core.IEASBillEntryInfo;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.scm.common.app.util.SCMServerUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashSet;

public class PurOrderDisposer
implements IPaymentDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal apAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        IEASBillHeadInfo paymentBillInfo;
        if (action.getDestBill() != null && action.getDestBill().getBOSType().toString().equals("40284E81") && (paymentBillInfo = (IEASBillHeadInfo)action.getDestBill()).getId() != null) {
            String paymentBillId = paymentBillInfo.getId().toString();
            String orderId = null;
            IObjectCollection paymentEntryNum = paymentBillInfo.getEntries();
            orderId = this.makeOrderIdBy(paymentEntryNum);
            if (orderId != null && orderId.trim().length() != 0 && paymentBillId != null && paymentBillId.trim().length() != 0) {
                SCMServerUtil.addSQLLock((Context)ctx, (Object)orderId);
                String sp = " \r\n";
                StringBuffer strSQL = new StringBuffer();
                if (action.getActionType().getValue() == 7) {
                    this.checkAdvance(paymentBillInfo, ctx, orderId, paymentBillId);
                    this.checkPrepaid(ctx, paymentBillId, orderId);
                    strSQL.setLength(0);
                    strSQL.append("SELECT FSourceBillEntryId FROM t_cas_PaymentBillEntry");
                    strSQL.append(" WHERE FPaymentBillID = ? ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{paymentBillId});
                    StringBuffer srcEntryIDs = new StringBuffer("'',");
                    try {
                        while (rs.next()) {
                            srcEntryIDs.append("'").append(rs.getString("FSourceBillEntryId")).append("',");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                    srcEntryIDs.deleteCharAt(srcEntryIDs.length() - 1);
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SM_PurOrderEntry").append(sp);
                    strSQL.append(" SET (FPreReceived, FUnPrereceivedAm)=").append(sp);
                    strSQL.append(" (SELECT IsNull(T_SM_PurOrderEntry.FPreReceived,0) +IsNull(rbe.FAmount, 0) ").append(sp);
                    strSQL.append(" AS FPrepaymentd, ").append(sp);
                    strSQL.append(" T_SM_PurOrderEntry.FPrepayment - (IsNull(T_SM_PurOrderEntry.FPreReceived,0) +IsNull(rbe.FAmount, 0)) ").append(sp);
                    strSQL.append(" AS FUnPrereceivedAm").append(sp);
                    strSQL.append(" FROM t_cas_PaymentBillEntry rbe").append(sp);
                    strSQL.append(" WHERE rbe.FSourceBillEntryId =T_SM_PurOrderEntry.FID AND rbe.FPaymentBillID = '").append(paymentBillId).append("')").append(sp);
                    strSQL.append(" WHERE T_SM_PurOrderEntry.FID IN (").append(srcEntryIDs.toString()).append(")");
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                    this.writeBackOrderHead(ctx, orderId);
                    this.handleOrderHeadingWritingBack(ctx, paymentBillId, orderId, true);
                } else if (action.getActionType().getValue() == 8) {
                    strSQL.setLength(0);
                    strSQL.append("SELECT FSourceBillEntryId FROM t_cas_PaymentBillEntry");
                    strSQL.append(" WHERE FPaymentBillID = ? ");
                    IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{paymentBillId});
                    StringBuffer srcEntryIDs = new StringBuffer("'',");
                    try {
                        while (rs.next()) {
                            srcEntryIDs.append("'").append(rs.getString("FSourceBillEntryId")).append("',");
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                    srcEntryIDs.deleteCharAt(srcEntryIDs.length() - 1);
                    strSQL.setLength(0);
                    strSQL.append("UPDATE T_SM_PurOrderEntry").append(sp);
                    strSQL.append(" SET (FPreReceived, FUnPrereceivedAm) =").append(sp);
                    strSQL.append(" (SELECT T_SM_PurOrderEntry.FPreReceived - IsNull(rbe.FAmount, 0) ").append(sp);
                    strSQL.append(" AS FPrepaymentd, ").append(sp);
                    strSQL.append(" T_SM_PurOrderEntry.FUnPrereceivedAm + IsNull(rbe.FAmount, 0) ").append(sp);
                    strSQL.append(" AS FUnPrereceivedAm").append(sp);
                    strSQL.append(" FROM t_cas_PaymentBillEntry rbe").append(sp);
                    strSQL.append(" WHERE rbe.FSourceBillEntryId = T_SM_PurOrderEntry.FID AND rbe.FPaymentBillID = '").append(paymentBillId).append("')").append(sp);
                    strSQL.append(" WHERE T_SM_PurOrderEntry.FID IN (").append(srcEntryIDs.toString()).append(")");
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    strSQL.setLength(0);
                    this.writeBackOrderHead(ctx, orderId);
                    this.handleOrderHeadingWritingBack(ctx, paymentBillId, orderId, false);
                } else if (action.getActionType().getValue() == 3) {
                    strSQL.setLength(0);
                    Timestamp currTime = new Timestamp(System.currentTimeMillis());
                    strSQL.append("update T_SM_PurOrder set FPrepaymentDate = {ts'" + DateTimeUtils.format((Date)currTime).toString() + "'}");
                    strSQL.append(" where FID in (").append(orderId).append(")");
                    try {
                        DbUtil.execute((Context)ctx, (String)strSQL.toString());
                        strSQL.setLength(0);
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
        }
    }

    private String makeOrderIdBy(IObjectCollection paymentEntryNum) {
        if (paymentEntryNum == null || paymentEntryNum.size() <= 0) {
            return null;
        }
        StringBuffer sourceOrderId = new StringBuffer();
        IEASBillEntryInfo receivingEntryInfo = null;
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < paymentEntryNum.size(); ++i) {
            receivingEntryInfo = (IEASBillEntryInfo)paymentEntryNum.getObject(i);
            if (receivingEntryInfo == null || receivingEntryInfo.getSourceBillId() == null) continue;
            idSet.add(receivingEntryInfo.getSourceBillId().toString());
        }
        Object[] ids = idSet.toArray();
        for (int i = 0; i < ids.length; ++i) {
            if (i == 0) {
                sourceOrderId.append("'").append(ids[i].toString()).append("'");
                continue;
            }
            sourceOrderId.append(",").append("'").append(ids[i].toString()).append("'");
        }
        return sourceOrderId.toString();
    }

    private void handleOrderHeadingWritingBack(Context ctx, String receivingBillId, String orderId, boolean isPayment) throws BOSException {
        StringBuffer sql = new StringBuffer();
        String plusOrMinus = null;
        plusOrMinus = isPayment ? "+" : "-";
        sql.append("update t_sm_purorder as t1 set  fprepaid = ( ");
        sql.append("select t2.ftotalamount from ( ");
        sql.append("select fparentid,sum(IsNull(FPreReceived,0)) ftotalamount ");
        sql.append("from t_sm_purorderentry ");
        sql.append("where fparentid in( ").append(orderId).append(") ");
        sql.append("group by fparentid ) t2 ");
        sql.append("where t1.fid = t2.fparentid ) ");
        sql.append("where  t1.fid in (").append(orderId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void checkPrepaid(Context ctx, String receivingBillId, String orderId) throws EASBizException, BOSException {
        try {
            IRowSet rs = this.getRefundmentRowSetBy(ctx, receivingBillId, orderId);
            this.isPrePaidGreaterThanPrepaymentWhenRefund(rs);
        }
        catch (SQLException exc) {
            throw new BOSException("Sql222 execute exception : " + exc);
        }
    }

    private IRowSet getRefundmentRowSetBy(Context ctx, String billId, String orderId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(IsNull(b.FAmount,0)),sum(IsNull(c.FPrepaid,0)) from t_sm_purorderentry a ").append(" inner join T_CAS_PaymentBillEntry b on a.fid=b.fsourcebillentryid").append(" inner join t_sm_purorder c on c.fid=b.fsourcebillid").append(" where b.fpaymentBillID='").append(billId).append("' and c.fid in(").append(orderId).append(")").append(" group by b.fsourcebillid,c.FPrepaid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    private void checkAdvance(IEASBillHeadInfo receivingBillInfo, Context ctx, String orderId, String billId) throws EASBizException, BOSException {
        try {
            boolean allowed = this.getParamValue(receivingBillInfo, ctx);
            IRowSet rs = null;
            if (!allowed) {
                rs = this.getRowSetBy(ctx, billId, orderId);
                this.isPrePaidGreaterThanPrepayment(rs);
            }
        }
        catch (SQLException exc) {
            throw new BOSException("Sql222 execute exception : " + exc);
        }
    }

    private void isPrePaidGreaterThanPrepayment(IRowSet rs) throws PurOrderException, BOSException, SQLException {
        BigDecimal beenPaid = null;
        BigDecimal shouldPaid = null;
        while (rs.next()) {
            beenPaid = rs.getBigDecimal(1);
            shouldPaid = rs.getBigDecimal(2).subtract(rs.getBigDecimal(3));
            if (beenPaid == null || shouldPaid == null || beenPaid.signum() <= 0 || beenPaid.compareTo(shouldPaid) <= 0) continue;
            throw new PurOrderException(PurOrderException.PREPAID_CANNNOT_GREATER_THAN_PREPAYMENT);
        }
    }

    private void isPrePaidGreaterThanPrepaymentWhenRefund(IRowSet rs) throws PurOrderException, BOSException, SQLException {
        BigDecimal beenPaid = null;
        BigDecimal shouldPaid = null;
        while (rs.next()) {
            beenPaid = rs.getBigDecimal(1);
            shouldPaid = rs.getBigDecimal(2);
            if (beenPaid == null || shouldPaid == null || beenPaid.signum() >= 0 || beenPaid.negate().compareTo(shouldPaid) <= 0) continue;
            throw new PurOrderException(PurOrderException.AMOUNT_REFUND_NOTGREATER_BEENPAID);
        }
    }

    private boolean getParamValue(IEASBillHeadInfo receivingBillInfo, Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)receivingBillInfo.getObjectValue("company");
        ObjectUuidPK pk = new ObjectUuidPK(companyInfo.getId());
        String param = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)pk, "ORDERPAYMENT");
        boolean allowed = true;
        if (param != null && param.length() != 0) {
            allowed = Boolean.valueOf(param);
        }
        return allowed;
    }

    private IRowSet getRowSetBy(Context ctx, String billId, String orderId) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select sum(b.FAmount) as amount,sum(isnull(c.FPrepayment,0)) as prepaymen,sum(isnull(c.FPrepaid,0)) as prepaid from t_sm_purorderentry a ").append(" inner join T_CAS_PaymentBillEntry b on a.fid=b.fsourcebillentryid").append(" inner join t_sm_purorder c on c.fid=b.fsourcebillid").append(" where b.fpaymentBillID='").append(billId).append("' and c.fid in (").append(orderId).append(")").append(" group by b.fsourcebillid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    private void writeBackOrderHead(Context ctx, String orderId) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SM_PurOrder po set FUnPrepaidAmount=");
        sql.append(" (select sum(ISNULL(poe.FUnPrereceivedAm,0)) from T_SM_PurOrderEntry poe ");
        sql.append(" where poe.FParentID=po.FID) ");
        sql.append(" where FID in (").append(orderId).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

