/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.config.client.ConfigServiceUtils;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceQueryTypeEnum;
import com.kingdee.eas.scm.sm.pur.client.PurPriceCtrlStrategy;
import com.kingdee.eas.scm.sm.pur.client.PurPriceQueryUI;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;

public class QueryPurPriceAssistor
extends JPanel
implements KeyListener,
FocusListener {
    private Popup popup;
    private ICell currentCell;
    private KDTabbedPane kdTMain;
    private CoreUI parent;
    private KDTable assistorTable = new KDTable();
    private KDTable table = null;
    int pixX;
    int pixY;
    int rightX;
    int leftX;
    int selectRow;
    private PurPriceCtrlStrategy purPriceCtrlStrategy = null;
    private final String NAME = "name";
    private final String PRICE = "price";
    private final String DISCOUNT_RATE = "discountRate";
    private final String SUPPLIER = "supplier";
    private final String SUPPLIER_ID = "supplierID";
    private PurPriceQueryUI purPriceQueryUI = null;
    private PurchaseOrgUnitInfo purOrgUnitInfo = null;
    private final BigDecimal ZERO = new BigDecimal("0.00");
    private final BigDecimal ONE = new BigDecimal("1.00");
    protected BigDecimal hundrud = new BigDecimal("100.00");
    private static final String resClassName = "com.kingdee.eas.basedata.scm.sm.srm.PriceStrategyAssignResource";
    private boolean isTaxPrice = false;
    private BigDecimal taxRate = null;

    public void setIsTaxPrice(boolean isTaxPrice) {
        this.isTaxPrice = isTaxPrice;
    }

    public PurchaseOrgUnitInfo getPurOrgUnitInfo() {
        return this.purOrgUnitInfo;
    }

    public void setPurOrgUnitInfo(PurchaseOrgUnitInfo purOrgUnitInfo) {
        this.purOrgUnitInfo = purOrgUnitInfo;
    }

    public int getPixX() {
        return this.pixX;
    }

    public void setPixX(int pixX) {
        this.pixX = pixX;
    }

    public int getPixY() {
        return this.pixY;
    }

    public void setPixY(int pixY) {
        this.pixY = pixY;
    }

    public void setRightX(int rightX) {
        this.rightX = rightX;
    }

    public void setLeftX(int leftX) {
        this.leftX = leftX;
    }

    public ICell getCurrentCell() {
        return this.currentCell;
    }

    public void setCurrentCell(ICell currentCell) {
        this.currentCell = currentCell;
    }

    public void setSelectRow(int selectRow) {
        this.selectRow = selectRow;
    }

    public void setTable(KDTable table) {
        this.table = table;
    }

    private String getResource(String key) {
        return EASResource.getString((String)resClassName, (String)key);
    }

    public QueryPurPriceAssistor(ICell cell, CoreUI parent, PurPriceCtrlStrategy purPriceCtrlStrategy, KDTable table, int selectRow) throws Exception {
        this.currentCell = cell;
        this.parent = parent;
        parent.setFocusable(true);
        this.purPriceCtrlStrategy = purPriceCtrlStrategy;
        this.table = table;
        this.selectRow = selectRow;
        this.setLayout(new BorderLayout(300, 300));
        this.kdTMain = new KDTabbedPane();
        this.kdTMain.setFocusable(false);
        this.kdTMain.setName("kdTMain");
        this.kdTMain.setSize(100, 100);
        this.initAssistorControls();
    }

    public void getPurprice() throws EASBizException, BOSException {
        PurPriceInfoCollection col = null;
        PurPriceParamCollection paramCols = null;
        PurPriceParam paramInfo = null;
        paramInfo = this.purPriceCtrlStrategy.getBillTypeId().equals("aErYRJ8ShO3gQKjACw4w8MtHWDQ=") ? this.purPriceCtrlStrategy.getPurPriceParam() : this.purPriceCtrlStrategy.getParamInfo(this.selectRow);
        if (paramInfo.getPurOrgUnitId() != null && paramInfo.getUnitId() != null && paramInfo.getCurrencyId() != null) {
            try {
                paramCols = this.initQueryParam();
                col = this.purPriceCtrlStrategy.getPurPriceInfoCollection(this.selectRow, paramCols);
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
            this.fillHistroryTable(col);
        }
    }

    private PurPriceParamCollection initQueryParam() throws Exception {
        if (this.purPriceQueryUI == null) {
            this.purPriceQueryUI = new PurPriceQueryUI();
        }
        PurPriceParamCollection paramCols = new PurPriceParamCollection();
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String queryPrice = ConfigServiceUtils.getUserConfigData((String)("kdsQueryPrice" + userID), (CoreUI)this.purPriceQueryUI);
        String latestPrice = ConfigServiceUtils.getUserConfigData((String)("kdsLatestPrice" + userID), (CoreUI)this.purPriceQueryUI);
        String supplierPrice = ConfigServiceUtils.getUserConfigData((String)("kdsSupplierPrice" + userID), (CoreUI)this.purPriceQueryUI);
        if (queryPrice != null) {
            paramCols.put("queryPriceDate", Integer.valueOf(queryPrice));
        } else {
            paramCols.put("queryPriceDate", 12);
        }
        if (supplierPrice != null) {
            paramCols.put("SupplierPriceQty", Integer.valueOf(supplierPrice));
        } else {
            paramCols.put("SupplierPriceQty", 3);
        }
        if (latestPrice != null) {
            paramCols.put("latestPriceQty", Integer.valueOf(latestPrice));
        } else {
            paramCols.put("latestPriceQty", 1);
        }
        paramCols.put("isByBillType", new Boolean(false));
        if (this.purPriceCtrlStrategy.TB_TAXPRICE != null) {
            paramCols.put("isTaxPrice", new Boolean(this.isTaxPrice));
        } else {
            paramCols.put("isTaxPrice", null);
        }
        if (this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_TAXRATE) != null) {
            this.taxRate = (BigDecimal)this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_TAXRATE).getValue();
        }
        paramCols.put("billTypeid", this.purPriceCtrlStrategy.getBillTypeId());
        return paramCols;
    }

    private void fillHistroryTable(PurPriceInfoCollection col) throws EASBizException, BOSException {
        this.assistorTable.removeRows();
        IRow row = null;
        boolean isShowSPrice = true;
        this.assistorTable.checkParsed();
        PurPriceInfo info = null;
        if (col != null && col.size() == 0) {
            return;
        }
        int discountPrecision = 2;
        discountPrecision = this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_DISCOUNTRATE) != null ? (this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_DISCOUNTRATE).getEditor() == null ? 2 : ((KDFormattedTextField)this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_DISCOUNTRATE).getEditor().getComponent()).getPrecision()) : PurUtil.getDiscountRatePrecision(null);
        for (int i = 0; i < col.size(); ++i) {
            info = col.getPurPriceInfo(i);
            row = this.assistorTable.addRow();
            PurPriceQueryTypeEnum type = (PurPriceQueryTypeEnum)((Object)info.get("priceType"));
            if (type.equals((Object)PurPriceQueryTypeEnum.LATEST_CONTRACT_PRICE) || type.equals((Object)PurPriceQueryTypeEnum.LATEST_ORDER_PRICE) || type.equals((Object)PurPriceQueryTypeEnum.LATEST_SETTLE_PRICE)) {
                row.getCell("name").setValue((Object)this.getResource("THE_LATEST_PRICE"));
            } else if (type.equals((Object)PurPriceQueryTypeEnum.LOWEST_CONTRACT_PRICE) || type.equals((Object)PurPriceQueryTypeEnum.LOWEST_ORDER_PRICE) || type.equals((Object)PurPriceQueryTypeEnum.LOWEST_SETTLE_PRICE)) {
                row.getCell("name").setValue((Object)this.getResource("BOTTOM_PRICE"));
            } else if (isShowSPrice) {
                row.getCell("name").setValue((Object)this.getResource("SUPPLY_PRICE"));
                isShowSPrice = false;
            }
            BigDecimal comparePrice = (BigDecimal)info.get("comparePrice");
            if (info.get("isSupplierPrice") != null) {
                Boolean isTaxPrice = (Boolean)info.get("isSupplierPrice");
                if (((Boolean)info.get("isTaxPrice")).booleanValue()) {
                    if (!isTaxPrice.booleanValue()) {
                        comparePrice = this.purPriceCtrlStrategy.calEntryTaxPricebyPrice(comparePrice, this.taxRate, info);
                    }
                } else if (isTaxPrice.booleanValue()) {
                    comparePrice = this.purPriceCtrlStrategy.calEntryPriceByTaxPrice(comparePrice, this.taxRate, info);
                }
            }
            row.getCell("price").setValue((Object)(comparePrice.setScale(info.getPricePrecision(), 4).toPlainString() + ","));
            if (info.getDiscountRate() != null && info.getDiscountRate().compareTo(this.ZERO) != 0) {
                row.getCell("discountRate").setValue((Object)("-" + info.getDiscountRate().setScale(discountPrecision, 4).toString() + "%,"));
            } else {
                row.getCell("discountRate").setValue((Object)"-0.00%,");
            }
            if (info.get("supplier.simpleName") != null) {
                row.getCell("supplier").setValue((Object)("(" + info.get("supplier.simpleName").toString() + ")"));
            } else if (info.get("supplier").toString().length() > 6) {
                row.getCell("supplier").setValue((Object)("(" + info.get("supplier").toString().substring(0, 3) + "...)"));
            } else {
                row.getCell("supplier").setValue((Object)("(" + info.get("supplier").toString() + ")"));
            }
            row.getCell("supplierID").setValue(info.get("supplierID"));
        }
        row = this.assistorTable.addRow();
        row.getCell("name").setValue((Object)this.getResource("MORE_AND_MORE"));
        if (this.assistorTable.getRow(0) != null) {
            this.assistorTable.getSelectManager().select(0, -1);
            KDTableHelper.autoFitColumnWidth((KDTable)this.assistorTable, (int)1);
            int columnCount = this.assistorTable.getColumnCount();
            for (int i = 0; i < columnCount; ++i) {
                KDTableHelper.autoFitColumnWidth((KDTable)this.assistorTable, (int)i);
            }
        }
        this.showPop(true);
    }

    private void initAssistorControls() {
        this.assistorTable.setScrollStateHorizon(1);
        this.assistorTable.setScrollStateVertical(1);
        this.assistorTable.setBackground(Color.WHITE);
        this.assistorTable.getSelectManager().setSelectMode(2);
        this.assistorTable.getStyleAttributes().setLocked(true);
        this.assistorTable.setGridLineColor(Color.WHITE);
        IColumn col = this.assistorTable.addColumn();
        col.setKey("name");
        col.setWidth(70);
        col.getStyleAttributes().setHided(false);
        col = this.assistorTable.addColumn();
        col.setKey("price");
        col.setWidth(80);
        col.getStyleAttributes().setHided(false);
        col = this.assistorTable.addColumn();
        col.setKey("discountRate");
        col.setWidth(80);
        col.getStyleAttributes().setHided(false);
        col = this.assistorTable.addColumn();
        col.setKey("supplier");
        col.setWidth(80);
        col.getStyleAttributes().setHided(false);
        col = this.assistorTable.addColumn();
        col.setKey("supplierID");
        col.setWidth(80);
        col.getStyleAttributes().setHided(true);
        this.assistorTable.checkParsed(true);
        this.add((Component)this.assistorTable, "Center");
        this.assistorTable.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getType() == 1 && e.getRowIndex() == QueryPurPriceAssistor.this.assistorTable.getRowCount() - 1) {
                    QueryPurPriceAssistor.this.showPop(false);
                    UIContext uiContext = new UIContext((Object)this);
                    String uiClassName = "com.kingdee.eas.scm.sm.pur.client.PurPriceQueryUI";
                    MaterialInfo materialInfo = (MaterialInfo)QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_MATERIAL).getValue();
                    if (materialInfo == null) {
                        MsgBox.showInfo((String)QueryPurPriceAssistor.this.getResource("MATERIAL_CANNOT_NULL"));
                        return;
                    }
                    uiContext.put("material", materialInfo);
                    uiContext.put("purOrgUnit", QueryPurPriceAssistor.this.purOrgUnitInfo);
                    uiContext.put("purPriceCtrlStrategy", QueryPurPriceAssistor.this.purPriceCtrlStrategy);
                    uiContext.put("selectRow", new Integer(QueryPurPriceAssistor.this.selectRow));
                    if (((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXPRICE != null) {
                        uiContext.put("isTaxPrice", new Boolean(QueryPurPriceAssistor.this.isTaxPrice));
                    } else {
                        uiContext.put("isTaxPrice", null);
                    }
                    uiContext.put("editCell", QueryPurPriceAssistor.this.currentCell);
                    if (((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXRATE != null && QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXRATE) != null) {
                        uiContext.put("taxRate", QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXRATE).getValue());
                        uiContext.put("taxRateCell", QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXRATE));
                    } else {
                        uiContext.put("taxRate", null);
                    }
                    uiContext.put("discountCell", QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_DISCOUNTRATE));
                    if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(QueryPurPriceAssistor.this.purPriceCtrlStrategy.getBillTypeId())) {
                        uiContext.put("supplierCell", QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_SUPPLIER));
                    }
                    IUIWindow uiWindow = null;
                    try {
                        uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
                        uiWindow.show();
                    }
                    catch (UIException e1) {
                        ExceptionHandler.handle((Throwable)e1);
                    }
                    return;
                }
                if (e.getClickCount() == 2 && e.getType() == 1) {
                    QueryPurPriceAssistor.this.commitSelection();
                    QueryPurPriceAssistor.this.showPop(false);
                }
            }
        });
        this.assistorTable.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                boolean i = false;
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (QueryPurPriceAssistor.this.popup != null) {
                    QueryPurPriceAssistor.this.popup.hide();
                    QueryPurPriceAssistor.this.popup = null;
                }
            }
        });
        this.assistorTable.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
            }
        });
        this.assistorTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    QueryPurPriceAssistor.this.showPop(false);
                } else if (e.getKeyCode() == 10) {
                    int selectRowIndex = QueryPurPriceAssistor.this.assistorTable.getSelectManager().getActiveRowIndex();
                    if (selectRowIndex == QueryPurPriceAssistor.this.assistorTable.getRowCount() - 1) {
                        QueryPurPriceAssistor.this.showPop(false);
                        UIContext uiContext = new UIContext((Object)this);
                        String uiClassName = "com.kingdee.eas.scm.sm.pur.client.PurPriceQueryUI";
                        MaterialInfo materialInfo = (MaterialInfo)QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell("materialNum").getValue();
                        uiContext.put("material", materialInfo);
                        uiContext.put("purOrgUnit", QueryPurPriceAssistor.this.purOrgUnitInfo);
                        uiContext.put("purPriceCtrlStrategy", QueryPurPriceAssistor.this.purPriceCtrlStrategy);
                        uiContext.put("selectRow", new Integer(QueryPurPriceAssistor.this.selectRow));
                        uiContext.put("isTaxPrice", new Boolean(QueryPurPriceAssistor.this.isTaxPrice));
                        uiContext.put("editCell", QueryPurPriceAssistor.this.currentCell);
                        uiContext.put("table", QueryPurPriceAssistor.this.table);
                        uiContext.put("taxRate", QueryPurPriceAssistor.this.table.getRow(QueryPurPriceAssistor.this.selectRow).getCell(((QueryPurPriceAssistor)QueryPurPriceAssistor.this).purPriceCtrlStrategy.TB_TAXRATE).getValue());
                        IUIWindow uiWindow = null;
                        try {
                            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClassName, (Map)uiContext, null, OprtState.VIEW);
                            uiWindow.show();
                        }
                        catch (UIException e1) {
                            ExceptionHandler.handle((Throwable)e1);
                        }
                        return;
                    }
                    QueryPurPriceAssistor.this.commitSelection();
                    QueryPurPriceAssistor.this.showPop(false);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    public void commitSelection() {
        BigDecimal discountRate = this.getSelectedItem("discountRate");
        if (this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_DISCOUNTRATE) != null) {
            this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_DISCOUNTRATE).setValue((Object)(discountRate == null ? this.ZERO : discountRate));
        }
        BigDecimal result = this.getSelectedItem("price");
        if ("50957179-0105-1000-e006-6152c0a812fd463ED552".equals(this.purPriceCtrlStrategy.getBillTypeId()) && null != discountRate && discountRate.compareTo(this.ZERO) > 0) {
            discountRate = discountRate.divide(this.hundrud, 4, 4);
            result = result.multiply(this.ONE.subtract(discountRate));
        }
        if (result != null && result.compareTo(this.ZERO) != 0) {
            this.currentCell.getEditor().setValue((Object)result);
        } else {
            this.currentCell.getEditor().setValue((Object)this.ZERO);
        }
        if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(this.purPriceCtrlStrategy.getBillTypeId())) {
            this.table.getRow(this.selectRow).getCell(this.purPriceCtrlStrategy.TB_SUPPLIER).setValue((Object)this.getSelectedSupplier());
        }
    }

    private BigDecimal getSelectedItem(String mainKey) {
        BigDecimal selectedItem = this.getSelectedHistoryItem(mainKey);
        return selectedItem;
    }

    private BigDecimal getSelectedHistoryItem(String mainKey) {
        BigDecimal selectedItem = null;
        KDTSelectManager sm = this.assistorTable.getSelectManager();
        int size = sm.size();
        ArrayList datas = new ArrayList();
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.assistorTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                String[] discount;
                Object v;
                IRow row = this.assistorTable.getRow(j);
                if (row == null || row.getCell(mainKey) == null || (v = row.getCell(mainKey).getValue()) == null) continue;
                if (mainKey.equals("discountRate")) {
                    discount = v.toString().split("%");
                    v = new BigDecimal(discount[0].substring(1, discount[0].length()));
                }
                if (mainKey.equals("price")) {
                    discount = v.toString().split(",");
                    v = new BigDecimal(discount[0]);
                }
                selectedItem = (BigDecimal)v;
                return selectedItem;
            }
        }
        return selectedItem;
    }

    private SupplierInfo getSelectedSupplier() {
        KDTSelectManager sm = this.assistorTable.getSelectManager();
        int size = sm.size();
        if (size <= 0) {
            return null;
        }
        for (int i = 0; i < size; ++i) {
            KDTSelectBlock sb = sm.get(i);
            int top = 0;
            int bottom = 0;
            if (sb.getMode() == 8) {
                bottom = this.assistorTable.getRowCount3();
            } else {
                top = sb.getTop() >= 0 ? sb.getTop() : 0;
                bottom = sb.getBottom() >= 0 ? sb.getBottom() : 0;
            }
            for (int j = top; j <= bottom; ++j) {
                String supplierID;
                IRow row = this.assistorTable.getRow(j);
                if (row == null || row.getCell("supplierID") == null || (supplierID = (String)row.getCell("supplierID").getValue()) == null) continue;
                try {
                    return SupplierFactory.getRemoteInstance().getSupplierInfo((IObjectPK)new ObjectUuidPK(supplierID));
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        return null;
    }

    public void showPop(boolean isShow) {
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
        int width = 0;
        for (int i = 0; i < this.assistorTable.getColumnCount(); ++i) {
            IColumn column = this.assistorTable.getColumn(i);
            if (column.getStyleAttributes().isHided()) continue;
            if (column.getWidth() == -1) {
                width += this.assistorTable.getDefaultColumnWidth();
                continue;
            }
            width += column.getWidth();
        }
        int x = this.pixX + (width += 45) / 2;
        if ((x = this.rightX < x ? this.rightX - width : this.pixX - width / 2) < this.leftX) {
            x = this.leftX;
        }
        if (isShow) {
            this.popup = PopupFactory.getSharedInstance().getPopup((Component)this.table, this, x, this.pixY + 20);
            this.assistorTable.setFocusable(false);
            this.popup.show();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.showPop(false);
        } else if (e.getKeyCode() == 38 && e.isAltDown()) {
            this.showPop(false);
        } else if (e.getKeyCode() == 40 && e.isAltDown()) {
            this.showPop(false);
        } else if (e.getKeyCode() == 40) {
            int selectRowIndex = this.assistorTable.getSelectManager().getActiveRowIndex();
            int rowCount = this.assistorTable.getRowCount();
            int currentIndex = 0;
            if (rowCount < 0 || selectRowIndex < rowCount) {
                currentIndex = selectRowIndex + 1;
                this.assistorTable.getSelectManager().select(currentIndex, -1);
                this.assistorTable.scrollToVisible(currentIndex, -1);
            }
        } else if (e.getKeyCode() == 38) {
            int selectRowIndex = this.assistorTable.getSelectManager().getActiveRowIndex();
            int currentIndex = 0;
            if (selectRowIndex > 0) {
                currentIndex = selectRowIndex - 1;
                this.assistorTable.getSelectManager().select(currentIndex, -1);
                this.assistorTable.scrollToVisible(currentIndex, -1);
            }
        } else if (e.getKeyCode() == 10) {
            this.commitSelection();
            this.showPop(false);
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.popup.hide();
        this.popup = null;
    }
}

