/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.OrderAlgorithm;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class PurAlgorithmForPurOrder
extends OrderAlgorithm {
    private static final Logger logger = CoreUIObject.getLogger(PurAlgorithmForPurOrder.class);
    private PurOrderInfo info;
    private int amountPrecision;
    private int localAmountPrecision;
    private PurchaseOrgUnitInfo pou = null;
    private CompanyOrgUnitInfo cou = null;

    public PurAlgorithmForPurOrder(PurOrderInfo info, Context ctx) {
        this.info = info;
        this.ctx = ctx;
    }

    public void revalue() throws EASBizException, BOSException {
        this.pou = this.info.getPurchaseOrgUnit();
        if (this.pou == null) {
            this.pou = (PurchaseOrgUnitInfo)ContextUtil.getCurrentOrgUnit((Context)this.ctx, (OrgType)OrgType.Purchase);
        }
        this.cou = null;
        if (this.pou != null) {
            this.cou = this.getCompany(this.ctx, this.pou);
        } else if (this.info.getEntries().get(0).getCompanyOrgUnit() != null) {
            this.cou = this.info.getEntries().get(0).getCompanyOrgUnit();
        }
        if (this.cou == null) {
            throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, new String[]{PurUtil.getUIResource("ORDER_FIELD_COMPANYORGUNIT")});
        }
        String oql = "SELECT id, baseCurrency.precision WHERE id ='" + this.cou.getId().toString() + "'";
        this.cou = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo(oql);
        this.localAmountPrecision = this.cou.getBaseCurrency().getPrecision();
        this.amountPrecision = 2;
        if (this.info.getCurrency() != null) {
            CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.info.getCurrency().getId().toString()));
            if (currency != null) {
                this.info.setCurrency(currency);
            }
            this.amountPrecision = this.info.getCurrency().getPrecision();
        }
        this.reCalEntryFields();
    }

    public void calByQty() throws EASBizException, BOSException {
        for (int i = 0; i < this.getEntrySize(); ++i) {
            this.calBaseQtyByQty(i);
            this.calAssistQtyByQty(i);
            this.calTaxAmount(i);
            this.calTax(i);
            this.calAmount(i);
            this.calActualPrice(i);
            this.calActualTaxPrice(i);
            this.calDiscountAmount(i);
            this.calTotalFields();
            this.calLocalAmount(i);
            this.calLocalTaxAmount(i);
            this.calLocalTax(i);
        }
    }

    protected BigDecimal getActualPrice(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getActualPrice());
    }

    protected BigDecimal getAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getAmount());
    }

    protected int getAmountPrecision() {
        return this.amountPrecision;
    }

    protected MeasureUnitInfo getAssistUnit(int i) {
        return this.info.getEntries().get(i).getAssistUnit();
    }

    protected MeasureUnitInfo getBaseUnit(int i) {
        return this.info.getEntries().get(i).getBaseUnit();
    }

    protected BigDecimal getBaseQty(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getBaseQty());
    }

    protected ConvertModeEnum getConvertMode() {
        return this.info.getConvertMode();
    }

    protected BigDecimal getDiscountAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getDiscountAmount());
    }

    protected BigDecimal getDiscountRate(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getDiscountRate());
    }

    protected int getEntriesSize() {
        return this.info.getEntries().size();
    }

    protected BigDecimal getExchangeRate() {
        return this.nullToZero(this.info.getExchangeRate());
    }

    protected BigDecimal getLocalAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalAmount());
    }

    protected BigDecimal getLocalTax(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalTax());
    }

    protected BigDecimal getLocalTaxAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getLocalTaxAmount());
    }

    protected MaterialInfo getMaterial(int i) {
        return this.info.getEntries().get(i).getMaterial();
    }

    protected BigDecimal getPrice(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getPrice());
    }

    protected int getPricePrecision(int i) {
        int precision = 8;
        if (this.info.getEntries().get(i).getRowType() != null) {
            RowTypeInfo rowType = null;
            MaterialInfo material = null;
            if (this.info.getEntries().get(i).getRowType().getId() != null) {
                rowType = this.info.getEntries().get(i).getRowType();
                if (rowType.isIsHasMaterialNumber()) {
                    if (this.info.getEntries().get(i).getMaterial() != null && this.info.getEntries().get(i).getMaterial().getId() != null) {
                        material = this.info.getEntries().get(i).getMaterial();
                        precision = material != null && material.getPricePrecision() != 0 ? material.getPricePrecision() : 8;
                    }
                } else {
                    precision = rowType.getPrecision();
                }
            }
        }
        return precision;
    }

    protected BigDecimal getQty(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getQty());
    }

    protected BigDecimal getTax(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTax());
    }

    protected BigDecimal getTaxAmount(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxAmount());
    }

    protected BigDecimal getTaxPrice(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxPrice());
    }

    protected BigDecimal getTaxRate(int i) {
        return this.nullToZero(this.info.getEntries().get(i).getTaxRate());
    }

    protected MeasureUnitInfo getUnit(int i) {
        return this.info.getEntries().get(i).getUnit();
    }

    protected boolean isInTax() {
        return this.info.isIsInTax();
    }

    protected boolean isIsPresent(int i) {
        return this.info.getEntries().get(i).isIsPresent();
    }

    protected boolean isPriceInTax() {
        return this.info.isIsPriceInTax();
    }

    protected void setActualPrice(BigDecimal price, int i) {
        this.info.getEntries().get(i).setActualPrice(price);
    }

    protected void setActualTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntries().get(i).setActualTaxPrice(taxPrice);
    }

    protected void setAmount(BigDecimal bigzero, int i) {
        this.info.getEntries().get(i).setAmount(bigzero);
    }

    protected void setAssistQty(BigDecimal assistQty, int i) {
        this.info.getEntries().get(i).setAssistQty(assistQty);
    }

    protected void setAssociateQty(BigDecimal associateQty, int i) {
        this.info.getEntries().get(i).setAssociateQty(associateQty);
    }

    protected void setBaseQty(BigDecimal baseQty, int i) {
        this.info.getEntries().get(i).setBaseQty(baseQty);
    }

    protected void setCompanyOrgUnit(CompanyOrgUnitInfo cou, int i) {
        this.info.getEntries().get(i).setCompanyOrgUnit(cou);
    }

    protected void setDiscountAmount(BigDecimal discountAmount, int i) {
        this.info.getEntries().get(i).setDiscountAmount(discountAmount);
    }

    protected void setLocalAmount(BigDecimal localAmount, int i) {
        this.info.getEntries().get(i).setLocalAmount(localAmount);
    }

    protected void setLocalTax(BigDecimal setScale, int i) {
        this.info.getEntries().get(i).setLocalTax(setScale);
    }

    protected void setLocalTaxAmount(BigDecimal setScale, int i) {
        this.info.getEntries().get(i).setLocalTaxAmount(setScale);
    }

    protected void setPrice(BigDecimal price, int i) {
        this.info.getEntries().get(i).setPrice(price);
    }

    protected void setQty(BigDecimal qty, int i) {
        this.info.getEntries().get(i).setQty(qty);
    }

    protected void setTax(BigDecimal tax, int i) {
        this.info.getEntries().get(i).setTax(tax);
    }

    protected void setTaxAmount(BigDecimal taxAmount, int i) {
        this.info.getEntries().get(i).setTaxAmount(taxAmount);
    }

    protected void setTaxPrice(BigDecimal taxPrice, int i) {
        this.info.getEntries().get(i).setTaxPrice(taxPrice);
    }

    protected void setTotalAmount(BigDecimal totalAmount) {
        this.info.setTotalAmount(totalAmount);
    }

    protected void setTotalTax(BigDecimal totalTax) {
        this.info.setTotalTax(totalTax);
    }

    protected void setTotalTaxAmount(BigDecimal totalTaxAmount) {
        this.info.setTotalTaxAmount(totalTaxAmount);
    }

    protected int getLocalAmountPrecision() {
        return this.localAmountPrecision;
    }

    protected void setLocalTotalAmount(BigDecimal localTotalAmount) {
        this.info.setLocalTotalAmount(localTotalAmount);
    }

    protected void setLocalTotalTax(BigDecimal localTotalTax) {
    }

    protected void setLocalTotalTaxAmount(BigDecimal localTotalTaxAmount) {
        this.info.setLocalTotalTaxAmount(localTotalTaxAmount);
    }

    public CompanyOrgUnitInfo getCompany(Context ctx, PurchaseOrgUnitInfo pou) throws BOSException, EASBizException {
        if (pou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(pou.getId().toString(), 3, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(pou.getId().toString(), 3, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        if (ret != null) {
            String oql = "SELECT id, baseCurrency.precision WHERE id ='" + ret.getId().toString() + "'";
            ret = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
        }
        return ret;
    }

    protected int getEntrySize() {
        return this.info.getEntries().size();
    }

    protected void calTotalLocalAmount() {
        BigDecimal localTotalAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            localTotalAmount = localTotalAmount.add(this.getLocalAmount(i));
        }
        this.setLocalTotalAmount(localTotalAmount);
    }

    protected void calTotalLocalTax() {
        BigDecimal localTotalTax = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            localTotalTax = localTotalTax.add(this.getLocalTax(i));
        }
        this.setLocalTotalTax(localTotalTax);
    }

    protected void calTotallocalTaxAmount() {
        BigDecimal localTotalTaxAmount = SysConstant.BIGZERO;
        for (int i = 0; i < this.getEntrySize(); ++i) {
            localTotalTaxAmount = localTotalTaxAmount.add(this.getLocalTaxAmount(i));
        }
        this.setLocalTotalTaxAmount(localTotalTaxAmount);
    }
}

