/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.IPurExpenseInvoice;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceException;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurExpenseInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurExpenseInvoiceControllerBean;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class PurExpenseInvoiceControllerBean
extends AbstractPurExpenseInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurExpenseInvoiceControllerBean");

    @Override
    protected void _audit(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, model);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (info.getId() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 2) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.AUDIT_NEED_SUBMITED);
        }
        if (this.isCheckCloseAccount() && this.isCloseAccount(ctx, model)) {
            throw new SCMBillException(SCMBillException.CLOSEACCOUNT_AUDIT);
        }
        info.setAuditor(user);
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        super.update(ctx, model, (CoreBaseInfo)info);
    }

    @Override
    protected void _createOtherBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        for (IObjectPK aPK : pks) {
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ID);
            }
            if (info.getBaseStatus().getValue() != 4) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.UNAUDIT_NEED_AUDIT);
            }
            info.setAuditor(null);
            info.setAuditTime(null);
            info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, pk);
        if (info.getId() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 2) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CANCEL_NEED_SUBMIT);
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        super.update(ctx, pk, (CoreBaseInfo)info);
        if (info.isIsReversed()) {
            PurExpenseInvoiceInfo srcInfo = (PurExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            srcInfo.setIsReversed(false);
            srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        this.canCancel(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)values[i];
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            info.setReasonCode(reasonCodeInfo);
            super.update(ctx, aPK, (CoreBaseInfo)info);
            if (!info.isIsReversed()) continue;
            PurExpenseInvoiceInfo srcInfo = (PurExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            srcInfo.setIsReversed(false);
            srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            super.cancelWithLog(ctx, srcInfo);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
        }
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canFreeze(ctx, pk);
        for (IObjectPK aPK : pk) {
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            super.freezeWithLog(ctx, info);
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    private void canFreeze(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            if (info.isIsReversed()) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CANNOT_FREEZE_REVERSE);
            }
            if (info.getBaseStatus().getValue() == 4) continue;
            if (n > 1) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.PART_CANNOT_FREEZE);
            }
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.BLOCK_NEED_AUDIT);
        }
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canUnFreeze(ctx, pk);
        for (IObjectPK aPK : pk) {
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            info.setReasonCode(null);
            super.unFreezeWithLog(ctx, info);
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    private void canUnFreeze(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            if (info.getBaseStatus().getValue() == 6) continue;
            if (n > 1) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.PART_CANNOT_UNFREEZE);
            }
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.UNBLOCK_NEED_BLOCK);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo purExpenseInvoiceInfo = (PurExpenseInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = this.isAddNew(ctx, (IObjectValue)purExpenseInvoiceInfo);
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(purExpenseInvoiceInfo.getId());
            this.canEditUpdate(ctx, (IObjectPK)pk);
        }
        this.addNewCheck(ctx, model);
        purExpenseInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        PurExpenseInvoiceEntryCollection entryInfos = purExpenseInvoiceInfo.getEntries();
        PurExpenseInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            this.setZero(entry);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (SCMServerUtils.isAuditAfterSubmitPurInv((Context)ctx, (String)purExpenseInvoiceInfo.getCompanyOrgUnit().getId().toString())) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    private void canEditUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo purExpenseInvoiceInfo = this.getPurExpenseInvoiceInfo(ctx, pk);
        if (purExpenseInvoiceInfo.isIsReversed()) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CANNOT_EDIT_REVERSE);
        }
        if (purExpenseInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.AUDITED_CANNOTUPDATE);
        }
        if (purExpenseInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.DELETED_CANNOTUPDATE);
        }
        if (purExpenseInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CLOSED_CANNOTUPDATE);
        }
        super._canUpdate(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo purExpenseInvoiceInfo = (PurExpenseInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = this.isAddNew(ctx, (IObjectValue)purExpenseInvoiceInfo);
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(purExpenseInvoiceInfo.getId());
            this.canTempSave(ctx, (IObjectPK)pk);
            this.canEditUpdate(ctx, (IObjectPK)pk);
        }
        this.checkNumber(ctx, isAddNew, purExpenseInvoiceInfo);
        purExpenseInvoiceInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        PurExpenseInvoiceEntryCollection entryInfos = purExpenseInvoiceInfo.getEntries();
        PurExpenseInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            this.setZero(entry);
        }
        return super._save(ctx, model);
    }

    private void setZero(PurExpenseInvoiceEntryInfo entry) {
        String[] fields = new String[]{"qty", "price", "amount", "localAmount", "taxRate", "tax", "localTax", "nonTaxAmount", "localNonTaxAmount"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(PurExpenseInvoiceEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = PurExpenseInvoiceEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = PurExpenseInvoiceEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    private void canTempSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo PurExpenseInvoiceInfo2 = this.getPurExpenseInvoiceInfo(ctx, pk);
        if (PurExpenseInvoiceInfo2.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.SUBMITED_CANNOTTEMPSAVE);
        }
    }

    private void checkNumber(Context ctx, boolean isAddNew, PurExpenseInvoiceInfo purExpenseInvoiceInfo) throws BOSException, EASBizException {
        if (!(this.isRuleAutoNumber(ctx, purExpenseInvoiceInfo, null) || purExpenseInvoiceInfo.getNumber() != null && purExpenseInvoiceInfo.getNumber().trim().length() != 0)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NUMBER_NOTSET);
        }
    }

    private void addNewCheck(Context ctx, IObjectValue model) throws PurExpenseInvoiceException {
        PurExpenseInvoiceInfo pInfo = (PurExpenseInvoiceInfo)model;
        if (pInfo.getInvoiceDate() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_INVOICEDATE);
        }
        if (pInfo.getCompanyOrgUnit() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_COMPANYORGUIT);
        }
        if (pInfo.getPurchaseOrgUnit() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_PURCHASEORGUNIT);
        }
        if (pInfo.getSupplier() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_SUPPLIER);
        }
        if (pInfo.getCurrency() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_CURRENCY);
        }
        if (pInfo.getExchangeRate() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_EXCHANGE);
        }
        if (pInfo.getBaseStatus() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_BASESTATE);
        }
        if (pInfo.getSettlementType() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_SETTELMENT);
        }
        if (pInfo.getPaymentType() == null) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_PAYMENT);
        }
        PurExpenseInvoiceEntryCollection pEntryCollection = pInfo.getEntries();
        int entryRow = pInfo.getEntries().size();
        if (entryRow <= 0) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ENTRY);
        }
        for (int row = 0; row < entryRow; ++row) {
            PurExpenseInvoiceEntryInfo pEntryInfo = pEntryCollection.get(row);
            if (pEntryInfo.getExpenseItem() == null) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_EXPENSEITEM);
            }
            if (pEntryInfo.getQty() == null) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ENTRY_QUANTITY);
            }
            if (pEntryInfo.getPrice() != null) continue;
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.NULL_ENTRY_PRICE);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.canAudit(ctx, pks);
        IPurExpenseInvoice iPurExpenseInvoice = PurExpenseInvoiceFactory.getLocalInstance(ctx);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            iPurExpenseInvoice.audit(pks[i]);
        }
    }

    private void canAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            if (info.getBaseStatus().getValue() == 2) continue;
            if (n > 1) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.PART_CANNOT_AUDIT);
            }
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.AUDIT_NEED_SUBMITED);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.canCancel(ctx, pks);
        for (IObjectPK aPK : pks) {
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            super.update(ctx, aPK, (CoreBaseInfo)info);
            if (!info.isIsReversed()) continue;
            PurExpenseInvoiceInfo srcInfo = (PurExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            srcInfo.setIsReversed(false);
            srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
        }
    }

    private void canCancel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) continue;
            if (n > 1) {
                throw new PurExpenseInvoiceException(PurExpenseInvoiceException.PART_CANNOT_CANCEL);
            }
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CANCEL_NEED_SUBMIT);
        }
    }

    @Override
    protected void _freezeWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        this.canFreeze(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            ReasonCodeInfo rInfo = (ReasonCodeInfo)values[i];
            PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, aPK);
            info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            info.setReasonCode(rInfo);
            super.freezeWithLog(ctx, info);
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    public static boolean isInvoiceSettled(PurExpenseInvoiceInfo purExpenseInvoiceInfo) {
        boolean isSettled = false;
        if (purExpenseInvoiceInfo != null) {
            PurExpenseInvoiceEntryCollection collection = purExpenseInvoiceInfo.getEntries();
            PurExpenseInvoiceEntryInfo entryInfo = null;
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = collection.get(i);
            }
        }
        return isSettled;
    }

    private void canReverse(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.REVERSE_NEED_AUDIT);
        }
        if (PurExpenseInvoiceControllerBean.isInvoiceSettled(info)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.REVERSE_NEED_UNSETTL);
        }
        if (info.getReversingStatus().equals((Object)ReversingStateEnum.REVERSED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.CANNOT_REVERSE);
        }
        if (info.isIsReversed()) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.REVERSE_NEED_BLUE);
        }
    }

    @Override
    protected IObjectPK[] _createReverse(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo srcInfo = null;
        PurExpenseInvoiceInfo destInfo = null;
        IObjectPK[] newPKs = new IObjectPK[pks.length];
        for (int i = 0; i < pks.length; ++i) {
            srcInfo = this.getPurExpenseInvoiceInfo(ctx, pks[i]);
            this.canReverse(ctx, pks[i]);
            destInfo = (PurExpenseInvoiceInfo)srcInfo.clone();
            String oldnumber = srcInfo.getNumber();
            destInfo.setId(null);
            destInfo.setNumber(oldnumber + "-R");
            if (this.isSameNumber(ctx, pks[i], (IObjectValue)destInfo)) {
                destInfo.setNumber(oldnumber + "-R-1");
            }
            destInfo.setIsReversed(true);
            destInfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
            if (destInfo.getTotalAmount() != null) {
                destInfo.setTotalAmount(destInfo.getTotalAmount().negate());
            }
            if (destInfo.getTotalTax() != null) {
                destInfo.setTotalTax(destInfo.getTotalTax().negate());
            }
            if (destInfo.getTotalNonTaxAmount() != null) {
                destInfo.setTotalNonTaxAmount(destInfo.getTotalNonTaxAmount().negate());
            }
            destInfo.setSourceBillId(srcInfo.getId().toString());
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            destInfo.setSourceBillType(billTypeInfo);
            destInfo.setAuditor(null);
            destInfo.setAuditTime(null);
            destInfo.setModifier(null);
            destInfo.setModificationTime(null);
            destInfo.setLastUpdateUser(null);
            destInfo.setLastUpdateTime(null);
            destInfo.setCreator(null);
            destInfo.setCreateTime(null);
            PurExpenseInvoiceEntryCollection collection = destInfo.getEntries();
            PurExpenseInvoiceEntryCollection srccollection = srcInfo.getEntries();
            PurExpenseInvoiceEntryInfo entryInfo = null;
            PurExpenseInvoiceEntryInfo srcentryInfo = null;
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                srcentryInfo = srccollection.get(j);
                entryInfo.setId(null);
                entryInfo.setParent(null);
                if (entryInfo.getQty() != null) {
                    entryInfo.setQty(entryInfo.getQty().negate());
                }
                if (entryInfo.getAmount() != null) {
                    entryInfo.setAmount(entryInfo.getAmount().negate());
                }
                if (entryInfo.getLocalAmount() != null) {
                    entryInfo.setLocalAmount(entryInfo.getLocalAmount().negate());
                }
                if (entryInfo.getLocalNonTaxAmount() != null) {
                    entryInfo.setLocalNonTaxAmount(entryInfo.getLocalNonTaxAmount().negate());
                }
                if (entryInfo.getTax() != null) {
                    entryInfo.setTax(entryInfo.getTax().negate());
                }
                if (entryInfo.getLocalTax() != null) {
                    entryInfo.setLocalTax(entryInfo.getLocalTax().negate());
                }
                if (entryInfo.getNonTaxAmount() == null) continue;
                entryInfo.setNonTaxAmount(entryInfo.getNonTaxAmount().negate());
            }
            IPurExpenseInvoice ip = PurExpenseInvoiceFactory.getLocalInstance(ctx);
            newPKs[i] = ip.submit((CoreBaseInfo)destInfo);
            srcInfo.setIsReversed(true);
            srcInfo.setReversingStatus(ReversingStateEnum.REVERSED);
            this._update(ctx, pks[i], (IObjectValue)srcInfo);
            super.createReverseWithLog(ctx, srcInfo);
            String strid = newPKs[i].toString();
            String bosType = strid.substring(strid.length() - 8);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(pks[i].toString());
            info.setDestEntityID(bosType);
            info.setSrcEntityID(bosType);
            info.setDestObjectID(strid);
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        return newPKs;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.canDelete(ctx, pk);
        PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, pk);
        super._delete(ctx, pk);
        if (info.isIsReversed()) {
            PurExpenseInvoiceInfo srcInfo = (PurExpenseInvoiceInfo)this.getValue(ctx, (IObjectPK)new ObjectUuidPK(info.getSourceBillId()));
            srcInfo.setIsReversed(false);
            srcInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            super._update(ctx, (IObjectPK)new ObjectUuidPK(srcInfo.getId()), (IObjectValue)srcInfo);
        }
    }

    private void canDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo info = (PurExpenseInvoiceInfo)this.getValue(ctx, pk);
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new PurExpenseInvoiceException(PurExpenseInvoiceException.DELETE_NEED_SUBMIT);
        }
    }

    @Override
    protected void _verify(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("companyOrgUnit.*"));
        PurExpenseInvoiceInfo info = this.getPurExpenseInvoiceInfo(ctx, pk, selectors);
        return info.getCompanyOrgUnit();
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurExpenseInvoiceInfo purExpInvoiceInfo = (PurExpenseInvoiceInfo)model;
        if (purExpInvoiceInfo.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo info = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(purExpInvoiceInfo.getCompanyOrgUnit().getId()));
            return info;
        }
        return null;
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    @Override
    protected void _cancelWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _freezeWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _unFreezeWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _createReverseWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurExpenseInvoiceInfo)model).getCompanyOrgUnit()) != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (botRelation != null && !"2652E01E".equals(botRelation.getDestEntityID())) {
            super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
            return;
        }
        if (BOTBillOperStateEnum.ADDNEW.equals((Object)bOTBillOperStateEnum)) {
            PurExpenseInvoiceInfo purExpInvInfo = (PurExpenseInvoiceInfo)srcBillVO;
            IVoucher iv = VoucherFactory.getLocalInstance((Context)ctx);
            VoucherInfo vinfo = (VoucherInfo)iv.getValue((IObjectPK)new ObjectStringPK(botRelation.getDestObjectID()));
            purExpInvInfo.setVoucherNumber(vinfo.getNumber());
            purExpInvInfo.setFiVouchered(true);
        } else if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
            PurExpenseInvoiceInfo purExpInvInfo = (PurExpenseInvoiceInfo)srcBillVO;
            purExpInvInfo.setVoucherNumber(null);
            purExpInvInfo.setFiVouchered(false);
        }
        super._reverseSave(ctx, srcBillPK, srcBillVO, bOTBillOperStateEnum, bOTRelationInfo);
    }

    private boolean isAPRelationSCM(Context ctx, String companyID) throws BOSException, EASBizException {
        return false;
    }
}

