/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeCollection;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.PaymentItemTypeEnum;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.InitializeInvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.InvoiceTypeEnum;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.BlockedStatusEnum;
import com.kingdee.eas.framework.CheckOffStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.cal.CalculateFacadeFactory;
import com.kingdee.eas.scm.cal.ICalculateFacade;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.RedBlueEnum;
import com.kingdee.eas.scm.common.ReversingStateEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsBill;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.IPurReceivalEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsBillInfo;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryCollection;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryCollection;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryFactory;
import com.kingdee.eas.scm.im.inv.PurReceivalEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurInvoice;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurReturns;
import com.kingdee.eas.scm.sm.pur.IPurReturnsEntry;
import com.kingdee.eas.scm.sm.pur.PurInvBizException;
import com.kingdee.eas.scm.sm.pur.PurInvPaymentPlanCollection;
import com.kingdee.eas.scm.sm.pur.PurInvPaymentPlanInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceCollection;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceFactory;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurInvoiceControllerBean;
import com.kingdee.eas.scm.sm.pur.util.PurInvoiceUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurInvoiceControllerBean
extends AbstractPurInvoiceControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurInvoiceControllerBean");

    protected void checkValid(IObjectValue model) throws PurInvBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        if (purInvoiceInfo.getBizType() == null) {
            throw new PurInvBizException(PurInvBizException.BIZTYPE_NOTSET);
        }
        if (purInvoiceInfo.getCompanyOrgUnit() == null) {
            throw new PurInvBizException(PurInvBizException.COMPORG_NOTSET);
        }
        if (purInvoiceInfo.getPurchaseOrgUnit() == null) {
            throw new PurInvBizException(PurInvBizException.PURORG_NOTSET);
        }
        if (purInvoiceInfo.getSupplier() == null) {
            throw new PurInvBizException(PurInvBizException.SUPPLIER_NOTSET);
        }
        if (purInvoiceInfo.getCurrency() == null) {
            throw new PurInvBizException(PurInvBizException.CURRENCY_NOTSET);
        }
        if (purInvoiceInfo.getSettlementType() == null) {
            throw new PurInvBizException(PurInvBizException.SETTLETYPE_NOTSET);
        }
        if (purInvoiceInfo.getPaymentType() == null) {
            throw new PurInvBizException(PurInvBizException.PAYMENTTYPE_NOTSET);
        }
        if (purInvoiceInfo.getEntries() != null) {
            this.checkEntriesValid(purInvoiceInfo.getEntries());
        } else if (purInvoiceInfo.getEntries() == null) {
            throw new PurInvBizException(PurInvBizException.NOENTRYERROR);
        }
    }

    private void checkEntriesValid(PurInvoiceEntryCollection purInvoiceEntryCollection) throws PurInvBizException {
        int num = purInvoiceEntryCollection.size();
        if (num == 0) {
            throw new PurInvBizException(PurInvBizException.NOENTRYERROR);
        }
        for (int i = 0; i < num; ++i) {
            PurInvoiceEntryInfo entryInfo = purInvoiceEntryCollection.get(i);
            if (entryInfo.getSeq() <= 0) {
                throw new PurInvBizException(PurInvBizException.LINENUMBER_NOTSET);
            }
            if (entryInfo.getMaterial() == null) {
                throw new PurInvBizException(PurInvBizException.MATERIAL_NOTSET, new Object[]{String.valueOf(entryInfo.getSeq())});
            }
            if (entryInfo.getUnit() == null) {
                throw new PurInvBizException(PurInvBizException.UNIT_NOTSET, new Object[]{String.valueOf(entryInfo.getSeq())});
            }
            if (entryInfo.getPrice() == null) {
                throw new PurInvBizException(PurInvBizException.PRICE_NOTSET, new Object[]{String.valueOf(entryInfo.getSeq())});
            }
            if (entryInfo.getTaxPrice() != null) continue;
            throw new PurInvBizException(PurInvBizException.TAXPRICE_NOTSET, new Object[]{String.valueOf(entryInfo.getSeq())});
        }
    }

    private void checkNumber(Context ctx, boolean isAddNew, PurInvoiceInfo purInvoiceInfo) throws BOSException, EASBizException {
        if (!(this.isRuleAutoNumber(ctx, purInvoiceInfo, null) || purInvoiceInfo.getNumber() != null && purInvoiceInfo.getNumber().trim().length() != 0)) {
            throw new PurInvBizException(PurInvBizException.INVNUMBER_NOTSET);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = purInvoiceInfo.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()));
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(purInvoiceInfo.getId());
            this.canManualUpdate(ctx, (IObjectPK)pk);
        }
        this.checkValid(model);
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (purInvoiceInfo.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            purInvoiceInfo.setBillType(billType);
        }
        PurInvoiceEntryCollection entryInfos = purInvoiceInfo.getEntries();
        PurInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        if ((purInvoiceInfo.getBizType().getId().toString().equals("d8e80652-0107-1000-e000-04c5c0a812202407435C") || purInvoiceInfo.getRedBlueType().equals((Object)RedBlueEnum.RED)) && !purInvoiceInfo.isIsReversed()) {
            purInvoiceInfo = PurUtil.getNagtiveAmountInfo(purInvoiceInfo);
            purInvoiceInfo.setRedBlueType(RedBlueEnum.RED);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (SCMServerUtils.isAuditAfterSubmitPurInv((Context)ctx, (String)purInvoiceInfo.getCompanyOrgUnit().getId().toString())) {
            this._audit(ctx, pk);
        }
        return pk;
    }

    private void canManualUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurInvBizException(PurInvBizException.AUDITED_CANNOTUPDATE);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurInvBizException(PurInvBizException.DELETED_CANNOTUPDATE);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PurInvBizException(PurInvBizException.CLOSED_CANNOTUPDATE);
        }
        super._canUpdate(ctx, pk);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        boolean isAddNew = true;
        isAddNew = purInvoiceInfo.getId() == null || !this._exists(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()));
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(purInvoiceInfo.getId());
            this.canTempSave(ctx, (IObjectPK)pk);
            this.canManualUpdate(ctx, (IObjectPK)pk);
        }
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (purInvoiceInfo.getBillType() == null) {
            BillTypeInfo billType = new BillTypeInfo();
            billType.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            purInvoiceInfo.setBillType(billType);
        }
        PurInvoiceEntryCollection entryInfos = purInvoiceInfo.getEntries();
        PurInvoiceEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    private void canTempSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new PurInvBizException(PurInvBizException.SUBMITED_CANNOTTEMPSAVE);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        this.canCancel(purInvoiceInfo);
        if (purInvoiceInfo.isIsReversed()) {
            this.resetReversedInv(ctx, purInvoiceInfo);
        }
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        this.update(ctx, pk, (CoreBaseInfo)purInvoiceInfo);
    }

    private void resetReversedInv(Context ctx, PurInvoiceInfo purInvoiceInfo) throws BOSException, EASBizException {
        if (purInvoiceInfo.isIsReversed() && purInvoiceInfo.getSourceBillId() != null) {
            ObjectStringPK srcpk = new ObjectStringPK(purInvoiceInfo.getSourceBillId());
            PurInvoiceInfo srcPurInvInfo = this.getPurInvoiceInfo(ctx, (IObjectPK)new ObjectStringPK(purInvoiceInfo.getSourceBillId()));
            srcPurInvInfo.setReverseInvNumber(null);
            srcPurInvInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            srcPurInvInfo.setIsReversed(false);
            this.update(ctx, (IObjectPK)srcpk, (CoreBaseInfo)srcPurInvInfo);
        }
    }

    private void canCancel(PurInvoiceInfo purInvoiceInfo) throws BOSException, EASBizException {
        InitializeInvoiceTypeEnum initialType = purInvoiceInfo.getInitializeInvoiceType();
        if (!initialType.equals((Object)InitializeInvoiceTypeEnum.GENERAL)) {
            throw new PurInvBizException(PurInvBizException.INITINVCANNOTCANCEL);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurInvBizException(PurInvBizException.ADUITED_CANNOTCANCEL);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PurInvBizException(PurInvBizException.CLOSED_CANNOTCANCEL);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurInvBizException(PurInvBizException.CANCELED_CANNOTCANCEL);
        }
        if (purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new PurInvBizException(PurInvBizException.TEMPSAVED_CANNOTCANCEL);
        }
        if (!purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new PurInvBizException(PurInvBizException.CANNOTCANCEL);
        }
    }

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.newAudit(ctx, pk);
    }

    protected void newAudit(Context ctx, IObjectPK model) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection cn;
        block6: {
            super._audit(ctx, model);
            cn = null;
            pstmt = null;
            rs = null;
            try {
                cn = this.getConnection(ctx);
                pstmt = cn.prepareStatement("select FSourceBillID,FSourceBillTypeID,FisReversed,FInitializeInvoiceType,FBaseStatus from T_SM_PurInvoice where fid=?");
                pstmt.setString(1, model.toString());
                rs = pstmt.executeQuery();
                int initialType = 0;
                int state = 0;
                boolean isReversed = false;
                String sourceBillId = null;
                String sourcebillTypeId = null;
                if (!rs.next()) {
                    throw new EASBizException(EASBizException.CHECKEXIST);
                }
                initialType = rs.getInt("FInitializeInvoiceType");
                state = rs.getInt("FBaseStatus");
                isReversed = rs.getBoolean("FisReversed");
                sourceBillId = rs.getString("FSourceBillID");
                sourcebillTypeId = rs.getString("FSourceBillTypeID");
                this.checkCanAudit(initialType, state);
                StringBuffer updateSql = new StringBuffer("update T_SM_PurInvoice set FBaseStatus=");
                updateSql.append(BillBaseStatusEnum.AUDITED.getValue()).append(" , FAuditorId='").append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString()).append("',FAuditTime = getDate() where fid='").append(model.toString()).append("'");
                DbUtil.execute((Context)ctx, (String)updateSql.toString());
                if (isReversed) {
                    this.auditReverseInvoice(ctx, cn, model, sourceBillId);
                    break block6;
                }
                this.auditNormalInvoice(ctx, cn, model, sourcebillTypeId);
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)cn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditNormalInvoice(Context ctx, Connection cn, IObjectPK invPk, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        IRowSet rs = null;
        PurInvoiceInfo purInvoiceInfo = new PurInvoiceInfo();
        purInvoiceInfo.setId(BOSUuid.read((String)invPk.toString()));
        try {
            String sql = "select FRedBlueType,FBaseStatus,FCompanyOrgUnitID,FSourceBillID,FSourceBillTypeID,FisReversed from T_SM_PurInvoice where fid='" + invPk.toString() + "'";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.next()) {
                purInvoiceInfo.setRedBlueType(RedBlueEnum.getEnum((int)rs.getInt("FRedBlueType")));
                purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.getEnum((int)rs.getInt("FBaseStatus")));
                CompanyOrgUnitInfo companyInfo = new CompanyOrgUnitInfo();
                companyInfo.setId(BOSUuid.read((String)rs.getString("FCompanyOrgUnitID")));
                purInvoiceInfo.setCompanyOrgUnit(companyInfo);
                purInvoiceInfo.setSourceBillId(rs.getString("FSourceBillID"));
                BillTypeInfo billTypeInfo = new BillTypeInfo();
                billTypeInfo.setId(BOSUuid.read((String)rs.getString("FSourceBillTypeID")));
                purInvoiceInfo.setSourceBillType(billTypeInfo);
                purInvoiceInfo.setIsReversed(rs.getBoolean("FisReversed"));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
        this.writeBackPreBill(ctx, cn, invPk, true, sourceBillTypeId);
        this.autoCheckOff(ctx, purInvoiceInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auditReverseInvoice(Context ctx, Connection cn, IObjectPK invPk, String srcBillidstr) throws BOSException, EASBizException, SQLException {
        IRowSet rs = null;
        try {
            String sourceBillTypeId = null;
            StringBuffer updateSql = new StringBuffer("update T_SM_PurInvoice set FReversingStatus=");
            updateSql.append(ReversingStateEnum.REVERSED.getValue()).append("where fid='").append(srcBillidstr).append("'");
            DbUtil.execute((Context)ctx, (String)updateSql.toString());
            rs = DbUtil.executeQuery((Context)ctx, (String)("select FSourceBillTypeID from T_SM_PurInvoice where fid='" + srcBillidstr + "'"));
            if (rs.next()) {
                sourceBillTypeId = rs.getString("FSourceBillTypeID");
            }
            this.writeBackPreBill(ctx, cn, (IObjectPK)new ObjectStringPK(srcBillidstr), false, sourceBillTypeId);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rs);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rs);
    }

    private void writeBackPreBill(Context ctx, PurInvoiceInfo purInvoiceInfo, boolean isAdd) throws BOSException, EASBizException {
        if (purInvoiceInfo.getSourceBillType() != null && purInvoiceInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            this.writeBackOrder(ctx, purInvoiceInfo, isAdd);
        } else if (purInvoiceInfo.getSourceBillType() != null && purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            this.writeBackPurInWarehsBill(ctx, purInvoiceInfo, isAdd);
            this.writeBackOrder(ctx, purInvoiceInfo, isAdd);
            this.writeBackPurReturnBill(ctx, purInvoiceInfo, isAdd);
        } else if (purInvoiceInfo.getSourceBillType() != null && purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
            this.writeBackPurReturnBill(ctx, purInvoiceInfo, isAdd);
        }
    }

    private void writeBackPreBill(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        if (sourceBillTypeId != null && sourceBillTypeId.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            this.writeBackOrder(ctx, cn, invPk, isAdd, sourceBillTypeId);
        } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            this.writeBackPurInWarehsBill(ctx, cn, invPk, isAdd, sourceBillTypeId);
            this.writeBackOrder(ctx, cn, invPk, isAdd, sourceBillTypeId);
            this.writeBackPurReturnBill(ctx, cn, invPk, isAdd, sourceBillTypeId);
        } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
            this.writeBackPurReturnBill(ctx, cn, invPk, isAdd, sourceBillTypeId);
        }
    }

    private void writeBackPurReturnBill(Context ctx, PurInvoiceInfo purInvoiceInfo, boolean isAdd) throws BOSException, EASBizException {
        block22: {
            block21: {
                if (purInvoiceInfo.getSourceBillType() == null || !purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) break block21;
                IPurReturnsEntry ipurReturnEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
                PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
                IPurReturns ipurReturns = null;
                PurInvoiceEntryInfo entryInfo = null;
                PurReturnsEntryInfo purReturnEntryInfo = null;
                int num = collection.size();
                for (int i = 0; i < num; ++i) {
                    BigDecimal unInvoicedQty;
                    entryInfo = collection.get(i);
                    ObjectStringPK purReturnentryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId());
                    purReturnEntryInfo = ipurReturnEntry.getPurReturnsEntryInfo((IObjectPK)purReturnentryPK);
                    BigDecimal invoicedqty = purReturnEntryInfo.getInvoicedQty();
                    BigDecimal invoiceBaseQty = purReturnEntryInfo.getInvoicedBaseQty();
                    BigDecimal invoiceAmount = purReturnEntryInfo.getInvoicedAmount();
                    BigDecimal deltaBaseQty = entryInfo.getBaseQty().abs();
                    BigDecimal deltaQty = null;
                    deltaQty = purReturnEntryInfo.getUnit().getId().toString().equals(entryInfo.getUnit().getId().toString()) ? entryInfo.getQty().abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)purReturnEntryInfo.getMaterial().getId().toString(), (String)purReturnEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)entryInfo.getUnit().getId().toString());
                    if (isAdd) {
                        unInvoicedQty = null;
                        if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                            unInvoicedQty = purReturnEntryInfo.getReturnedQty().subtract(invoicedqty);
                            if (unInvoicedQty != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                                if (ipurReturns == null) {
                                    ipurReturns = PurReturnsFactory.getLocalInstance(ctx);
                                }
                                SelectorItemCollection sic = new SelectorItemCollection();
                                sic.add(new SelectorItemInfo("number"));
                                PurReturnsInfo purReturnsInfo = ipurReturns.getPurReturnsInfo((IObjectPK)new ObjectUuidPK(purReturnEntryInfo.getParent().getId()), sic);
                                throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purReturnsInfo.getNumber(), new Integer(purReturnEntryInfo.getSeq())});
                            }
                        } else if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED) && (unInvoicedQty = purReturnEntryInfo.getQty().subtract(invoicedqty)) != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                            if (ipurReturns == null) {
                                ipurReturns = PurReturnsFactory.getLocalInstance(ctx);
                            }
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("number"));
                            PurReturnsInfo purReturnsInfo = ipurReturns.getPurReturnsInfo((IObjectPK)new ObjectUuidPK(purReturnEntryInfo.getParent().getId()), sic);
                            throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purReturnsInfo.getNumber(), new Integer(purReturnEntryInfo.getSeq())});
                        }
                        purReturnEntryInfo.setInvoicedQty(invoicedqty.add(deltaQty));
                        purReturnEntryInfo.setInvoicedBaseQty(invoiceBaseQty.add(deltaBaseQty));
                        purReturnEntryInfo.setUnInvoicedQty(unInvoicedQty);
                        purReturnEntryInfo.setUninvoicedBaseQty(purReturnEntryInfo.getUninvoicedBaseQty().subtract(deltaBaseQty));
                        purReturnEntryInfo.setInvoicedAmount(invoiceAmount.add(entryInfo.getTaxAmount().abs()));
                    } else {
                        unInvoicedQty = null;
                        if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                            unInvoicedQty = purReturnEntryInfo.getReturnedQty().add(invoicedqty);
                        } else if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
                            unInvoicedQty = purReturnEntryInfo.getQty().add(invoicedqty);
                        }
                        purReturnEntryInfo.setInvoicedQty(invoicedqty.subtract(deltaQty));
                        purReturnEntryInfo.setInvoicedBaseQty(invoiceBaseQty.subtract(deltaBaseQty));
                        purReturnEntryInfo.setUnInvoicedQty(unInvoicedQty);
                        purReturnEntryInfo.setUninvoicedBaseQty(purReturnEntryInfo.getUninvoicedBaseQty().add(deltaBaseQty));
                        purReturnEntryInfo.setInvoicedAmount(invoiceAmount.subtract(entryInfo.getTaxAmount().abs()));
                    }
                    ipurReturnEntry.update((IObjectPK)purReturnentryPK, (CoreBaseInfo)purReturnEntryInfo);
                }
                break block22;
            }
            if (purInvoiceInfo.getSourceBillType() == null || !purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) break block22;
            IPurReturnsEntry ipurReturnEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
            PurInvoiceEntryInfo entryInfo = null;
            PurReturnsEntryInfo purReturnEntryInfo = null;
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                BigDecimal unInvoicedQty;
                entryInfo = collection.get(i);
                if (entryInfo.getCoreBillType() == null || !entryInfo.getCoreBillType().getId().toString().equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) continue;
                ObjectStringPK purReturnentryPK = new ObjectStringPK(entryInfo.getPurOrderEntry());
                purReturnEntryInfo = ipurReturnEntry.getPurReturnsEntryInfo((IObjectPK)purReturnentryPK);
                BigDecimal invoicedqty = purReturnEntryInfo.getInvoicedQty();
                BigDecimal invoiceBaseQty = purReturnEntryInfo.getInvoicedBaseQty();
                BigDecimal invoiceAmount = purReturnEntryInfo.getInvoicedAmount();
                BigDecimal deltaBaseQty = entryInfo.getBaseQty().abs();
                BigDecimal deltaQty = null;
                deltaQty = purReturnEntryInfo.getUnit().getId().toString().equals(entryInfo.getUnit().getId().toString()) ? entryInfo.getQty().abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)purReturnEntryInfo.getMaterial().getId().toString(), (String)purReturnEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)entryInfo.getUnit().getId().toString());
                if (isAdd) {
                    unInvoicedQty = null;
                    if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                        unInvoicedQty = purReturnEntryInfo.getReturnedQty().add(invoicedqty);
                    } else if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
                        unInvoicedQty = purReturnEntryInfo.getQty().add(invoicedqty);
                    }
                    purReturnEntryInfo.setInvoicedQty(invoicedqty.add(deltaQty));
                    purReturnEntryInfo.setInvoicedBaseQty(invoiceBaseQty.add(deltaBaseQty));
                    purReturnEntryInfo.setUnInvoicedQty(unInvoicedQty);
                    purReturnEntryInfo.setUninvoicedBaseQty(purReturnEntryInfo.getUninvoicedBaseQty().subtract(deltaBaseQty));
                    purReturnEntryInfo.setInvoicedAmount(invoiceAmount.add(entryInfo.getTaxAmount().abs()));
                } else {
                    unInvoicedQty = null;
                    if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                        unInvoicedQty = purReturnEntryInfo.getReturnedQty().add(invoicedqty);
                    } else if (purReturnEntryInfo.getBaseStatus() != null && purReturnEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
                        unInvoicedQty = purReturnEntryInfo.getQty().add(invoicedqty);
                    }
                    purReturnEntryInfo.setInvoicedQty(invoicedqty.subtract(deltaQty));
                    purReturnEntryInfo.setInvoicedBaseQty(invoiceBaseQty.subtract(deltaBaseQty));
                    purReturnEntryInfo.setUnInvoicedQty(unInvoicedQty);
                    purReturnEntryInfo.setUninvoicedBaseQty(purReturnEntryInfo.getUninvoicedBaseQty().add(deltaBaseQty));
                    purReturnEntryInfo.setInvoicedAmount(invoiceAmount.subtract(entryInfo.getTaxAmount().abs()));
                }
                ipurReturnEntry.update((IObjectPK)purReturnentryPK, (CoreBaseInfo)purReturnEntryInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPurReturnBill(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        PreparedStatement selectpstmt = null;
        PreparedStatement updateStatement = null;
        HashMap returnentryPKInvNumberMap = new HashMap();
        ResultSet rs = null;
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select purInv.fnumber \"purInv.fnumber\",");
                sql.append("purInvEntry.fseq \"purInvEntry.fseq\",");
                sql.append("purInvEntry.fqty \"purInvEntry.fqty\",");
                sql.append("purInvEntry.fbaseQty \"purInvEntry.fbaseQty\",");
                sql.append("purInvEntry.fUnitid  \"purInvEntry.fUnitid\",");
                sql.append("purInvEntry.fBaseUnitid \"purInvEntry.fBaseUnitid\",");
                sql.append("purInvEntry.FTaxAmount \"purInvEntry.taxAmount\",");
                sql.append("purReturn.fid  \"purReturn.fid\",");
                sql.append("purReturn.fnumber  \"purReturn.fnumber\",");
                sql.append("purRetEntry.fid \"purRetEntry.fid\",");
                sql.append("purRetEntry.fseq \"purRetEntry.fseq\",");
                sql.append("purRetEntry.fBaseStatus \"purRetEntry.baseStatus\",");
                sql.append("purRetEntry.fqty \"purRetEntry.fqty\",");
                sql.append("purRetEntry.fbaseQty \"purRetEntry.fbaseQty\",");
                sql.append("purRetEntry.fInvoicedQty \"purRetEntry.invQty\",");
                sql.append("purRetEntry.FInvoicedBaseQty \"purRetEntry.invBaseQty\",");
                sql.append("purRetEntry.FUninvoicedBaseQty \"purRetEntry.unInvBaseQty\",");
                sql.append("purRetEntry.FInvoicedAmount \"purRetEntry.invAmount\",");
                sql.append("purRetEntry.FReturnedQty \"purRetEntry.returnQty\",");
                sql.append("purRetEntry.FReturnedBaseQty \"purRetEntry.returnBaseQty\",");
                sql.append("purRetEntry.fUnitid \"purRetEntry.fUnitid\",");
                sql.append("purRetEntry.fBaseUnitid \"purRetEntry.fBaseUnitid\", ");
                sql.append("purRetEntry.fMaterialid \"purRetEntry.fMaterialid\" ");
                sql.append("from t_SM_PurInvoice purInv ");
                sql.append("inner join t_SM_PurInvoiceEntry purInvEntry on purInv.fid=purInvEntry.fparentid ");
                sql.append("inner join T_SM_PurReturnsEntry  purRetEntry on purInvEntry.FSourceBillEntryID=purRetEntry.fid ");
                sql.append("inner join T_SM_PurReturns purReturn on purReturn.fid=purRetEntry.fparentid ");
                sql.append("where purInv.fid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                rs = selectpstmt.executeQuery();
                String updateSql = "update T_SM_PurReturnsEntry set FInvoicedQty = ?,FInvoicedBaseQty=?,FUninvoicedQty=?,FUninvoicedBaseQty=?,FInvoicedAmount=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal temp;
                    BigDecimal unInvoicedQty;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("purRetEntry.invQty");
                    BigDecimal invoiceBaseQty = rs.getBigDecimal("purRetEntry.invBaseQty");
                    BigDecimal invoiceAmount = rs.getBigDecimal("purRetEntry.invAmount");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("purInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("purRetEntry.fUnitid").equals(rs.getString("purInvEntry.fUnitid")) ? rs.getBigDecimal("purInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purRetEntry.fMaterialid"), (String)rs.getString("purRetEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("purRetEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal unInvoiceBaseQey;
                        if (!returnentryPKInvNumberMap.containsKey(rs.getString("purRetEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            map.put("uninvoiceBaseQty", rs.getBigDecimal("purRetEntry.unInvBaseQty"));
                            map.put("invoiceAmount", invoiceAmount);
                            returnentryPKInvNumberMap.put(rs.getString("purRetEntry.fid"), map);
                        }
                        numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("purRetEntry.fid"));
                        invoicedqty = (BigDecimal)numberMap.get("invoiceQty");
                        invoiceBaseQty = (BigDecimal)numberMap.get("invoiceBaseQty");
                        unInvoicedQty = null;
                        if (rs.getInt("purRetEntry.baseStatus") == 7) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").subtract(invoicedqty);
                            unInvoiceBaseQey = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purRetEntry.returnBaseQty")).subtract(invoiceBaseQty);
                            if (unInvoiceBaseQey != null && deltaBaseQty.compareTo(unInvoiceBaseQey) > 0) {
                                throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purReturn.fnumber"), rs.getString("purRetEntry.fseq")});
                            }
                        } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").subtract(invoicedqty);
                            unInvoiceBaseQey = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purRetEntry.fbaseQty")).subtract(invoiceBaseQty);
                            if (unInvoiceBaseQey != null && deltaBaseQty.compareTo(unInvoiceBaseQey) > 0) {
                                throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purReturn.fnumber"), rs.getString("purRetEntry.fseq")});
                            }
                        }
                        temp = ((BigDecimal)numberMap.get("invoiceQty")).add(deltaQty);
                        numberMap.put("invoiceQty", temp);
                        if (rs.getInt("purRetEntry.baseStatus") == 7) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").subtract(temp);
                        } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").subtract(temp);
                        }
                        temp = ((BigDecimal)numberMap.get("invoiceBaseQty")).add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", temp);
                        numberMap.put("uninvoiceQty", unInvoicedQty);
                        temp = ((BigDecimal)numberMap.get("uninvoiceBaseQty")).subtract(deltaBaseQty);
                        numberMap.put("uninvoiceBaseQty", temp);
                        temp = ((BigDecimal)numberMap.get("invoiceAmount")).add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        numberMap.put("invoiceAmount", temp);
                        continue;
                    }
                    if (!returnentryPKInvNumberMap.containsKey(rs.getString("purRetEntry.fid"))) {
                        map = new HashMap();
                        map.put("invoiceQty", invoicedqty);
                        map.put("invoiceBaseQty", invoiceBaseQty);
                        map.put("uninvoiceBaseQty", rs.getBigDecimal("purRetEntry.unInvBaseQty"));
                        map.put("invoiceAmount", invoiceAmount);
                        returnentryPKInvNumberMap.put(rs.getString("purRetEntry.fid"), map);
                    }
                    numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("purRetEntry.fid"));
                    invoicedqty = (BigDecimal)numberMap.get("invoiceQty");
                    unInvoicedQty = null;
                    temp = ((BigDecimal)numberMap.get("invoiceQty")).subtract(deltaQty);
                    numberMap.put("invoiceQty", temp);
                    if (rs.getInt("purRetEntry.baseStatus") == 7) {
                        unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").add(temp);
                    } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                        unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").add(temp);
                    }
                    temp = ((BigDecimal)numberMap.get("invoiceBaseQty")).subtract(deltaBaseQty);
                    numberMap.put("invoiceBaseQty", temp);
                    numberMap.put("uninvoiceQty", unInvoicedQty);
                    temp = ((BigDecimal)numberMap.get("uninvoiceBaseQty")).add(deltaBaseQty);
                    numberMap.put("uninvoiceBaseQty", temp);
                    temp = ((BigDecimal)numberMap.get("invoiceAmount")).subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    numberMap.put("invoiceAmount", temp);
                }
                if (batchNum > 0) {
                    for (String id : returnentryPKInvNumberMap.keySet()) {
                        if (!BOSUuid.isValid((String)id, (boolean)true)) continue;
                        Map numberMap = (Map)returnentryPKInvNumberMap.get(id);
                        updateStatement.setBigDecimal(1, (BigDecimal)numberMap.get("invoiceQty"));
                        updateStatement.setBigDecimal(2, (BigDecimal)numberMap.get("invoiceBaseQty"));
                        updateStatement.setBigDecimal(3, (BigDecimal)numberMap.get("uninvoiceQty"));
                        updateStatement.setBigDecimal(4, (BigDecimal)numberMap.get("uninvoiceBaseQty"));
                        updateStatement.setBigDecimal(5, (BigDecimal)numberMap.get("invoiceAmount"));
                        updateStatement.setString(6, id);
                        updateStatement.addBatch();
                    }
                    updateStatement.executeBatch();
                }
            } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select purInv.fnumber \"purInv.fnumber\",");
                sql.append("purInvEntry.fseq \"purInvEntry.fseq\",");
                sql.append("purInvEntry.fqty \"purInvEntry.fqty\",");
                sql.append("purInvEntry.fbaseQty \"purInvEntry.fbaseQty\",");
                sql.append("purInvEntry.fUnitid  \"purInvEntry.fUnitid\",");
                sql.append("purInvEntry.fBaseUnitid \"purInvEntry.fBaseUnitid\",");
                sql.append("purInvEntry.FTaxAmount \"purInvEntry.taxAmount\",");
                sql.append("purReturn.fid  \"purReturn.fid\",");
                sql.append("purReturn.fnumber  \"purReturn.fnumber\",");
                sql.append("purRetEntry.fid \"purRetEntry.fid\",");
                sql.append("purRetEntry.fseq \"purRetEntry.fseq\",");
                sql.append("purRetEntry.fBaseStatus \"purRetEntry.baseStatus\",");
                sql.append("purRetEntry.fqty \"purRetEntry.fqty\",");
                sql.append("purRetEntry.fbaseQty \"purRetEntry.fbaseQty\",");
                sql.append("purRetEntry.fInvoicedQty \"purRetEntry.invQty\",");
                sql.append("purRetEntry.FInvoicedBaseQty \"purRetEntry.invBaseQty\",");
                sql.append("purRetEntry.FUninvoicedBaseQty \"purRetEntry.unInvBaseQty\",");
                sql.append("purRetEntry.FInvoicedAmount \"purRetEntry.invAmount\",");
                sql.append("purRetEntry.FReturnedQty \"purRetEntry.returnQty\",");
                sql.append("purRetEntry.FReturnedBaseQty \"purRetEntry.returnBaseQty\",");
                sql.append("purRetEntry.fUnitid \"purRetEntry.fUnitid\",");
                sql.append("purRetEntry.fBaseUnitid \"purRetEntry.fBaseUnitid\", ");
                sql.append("purRetEntry.fMaterialid \"purRetEntry.fMaterialid\" ");
                sql.append("from t_SM_PurInvoice purInv ");
                sql.append("inner join t_SM_PurInvoiceEntry purInvEntry on purInv.fid=purInvEntry.fparentid ");
                sql.append("inner join T_SM_PurReturnsEntry  purRetEntry on purInvEntry.FPurOrderEntryID=purRetEntry.fid ");
                sql.append("inner join T_SM_PurReturns purReturn on purReturn.fid=purRetEntry.fparentid ");
                sql.append("where purInv.fid=? and purInvEntry.fcorebillTypeid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                selectpstmt.setString(2, "50957179-0105-1000-e006-6152c0a812fd463ED552");
                rs = selectpstmt.executeQuery();
                String updateSql = "update T_SM_PurReturnsEntry set FInvoicedQty = ?,FInvoicedBaseQty=?,FUninvoicedQty=?,FUninvoicedBaseQty=?,FInvoicedAmount=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal temp;
                    BigDecimal unInvoicedQty;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("purRetEntry.invQty");
                    BigDecimal invoiceBaseQty = rs.getBigDecimal("purRetEntry.invBaseQty");
                    BigDecimal invoiceAmount = rs.getBigDecimal("purRetEntry.invAmount");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("purInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("purRetEntry.fUnitid").equals(rs.getString("purInvEntry.fUnitid")) ? rs.getBigDecimal("purInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purRetEntry.fMaterialid"), (String)rs.getString("purRetEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("purRetEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal unInvoiceBaseQey;
                        if (!returnentryPKInvNumberMap.containsKey(rs.getString("purRetEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", invoiceBaseQty);
                            map.put("uninvoiceBaseQty", rs.getBigDecimal("purRetEntry.unInvBaseQty"));
                            map.put("invoiceAmount", invoiceAmount);
                            returnentryPKInvNumberMap.put(rs.getString("purRetEntry.fid"), map);
                        }
                        numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("purRetEntry.fid"));
                        invoicedqty = (BigDecimal)numberMap.get("invoiceQty");
                        invoiceBaseQty = (BigDecimal)numberMap.get("invoiceBaseQty");
                        unInvoicedQty = null;
                        if (rs.getInt("purRetEntry.baseStatus") == 7) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").subtract(invoicedqty);
                            unInvoiceBaseQey = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purRetEntry.returnBaseQty")).subtract(invoiceBaseQty);
                            if (unInvoiceBaseQey != null && deltaBaseQty.compareTo(unInvoiceBaseQey) > 0) {
                                throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purReturn.fnumber"), rs.getString("purRetEntry.fseq")});
                            }
                        } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").subtract(invoicedqty);
                            unInvoiceBaseQey = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purRetEntry.fbaseQty")).subtract(invoiceBaseQty);
                            if (unInvoiceBaseQey != null && deltaBaseQty.compareTo(unInvoiceBaseQey) > 0) {
                                throw new PurInvBizException(PurInvBizException.WRITEPURRETURNSERROR, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purReturn.fnumber"), rs.getString("purRetEntry.fseq")});
                            }
                        }
                        temp = ((BigDecimal)numberMap.get("invoiceQty")).add(deltaQty);
                        numberMap.put("invoiceQty", temp);
                        if (rs.getInt("purRetEntry.baseStatus") == 7) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").subtract(temp);
                        } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                            unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").subtract(temp);
                        }
                        temp = ((BigDecimal)numberMap.get("invoiceBaseQty")).add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", temp);
                        numberMap.put("uninvoiceQty", unInvoicedQty);
                        temp = ((BigDecimal)numberMap.get("uninvoiceBaseQty")).subtract(deltaBaseQty);
                        numberMap.put("uninvoiceBaseQty", temp);
                        temp = ((BigDecimal)numberMap.get("invoiceAmount")).add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        numberMap.put("invoiceAmount", temp);
                        continue;
                    }
                    if (!returnentryPKInvNumberMap.containsKey(rs.getString("purRetEntry.fid"))) {
                        map = new HashMap();
                        map.put("invoiceQty", invoicedqty);
                        map.put("invoiceBaseQty", invoiceBaseQty);
                        map.put("uninvoiceBaseQty", rs.getBigDecimal("purRetEntry.unInvBaseQty"));
                        map.put("invoiceAmount", invoiceAmount);
                        returnentryPKInvNumberMap.put(rs.getString("purRetEntry.fid"), map);
                    }
                    numberMap = (Map)returnentryPKInvNumberMap.get(rs.getString("purRetEntry.fid"));
                    invoicedqty = (BigDecimal)numberMap.get("invoiceQty");
                    unInvoicedQty = null;
                    temp = ((BigDecimal)numberMap.get("invoiceQty")).subtract(deltaQty);
                    numberMap.put("invoiceQty", temp);
                    if (rs.getInt("purRetEntry.baseStatus") == 7) {
                        unInvoicedQty = rs.getBigDecimal("purRetEntry.returnQty").add(temp);
                    } else if (rs.getInt("purRetEntry.baseStatus") == 4) {
                        unInvoicedQty = rs.getBigDecimal("purRetEntry.fqty").add(temp);
                    }
                    temp = ((BigDecimal)numberMap.get("invoiceBaseQty")).subtract(deltaBaseQty);
                    numberMap.put("invoiceBaseQty", temp);
                    numberMap.put("uninvoiceQty", unInvoicedQty);
                    temp = ((BigDecimal)numberMap.get("uninvoiceBaseQty")).add(deltaBaseQty);
                    numberMap.put("uninvoiceBaseQty", temp);
                    temp = ((BigDecimal)numberMap.get("invoiceAmount")).subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    numberMap.put("invoiceAmount", temp);
                }
                if (batchNum > 0) {
                    for (String id : returnentryPKInvNumberMap.keySet()) {
                        if (!BOSUuid.isValid((String)id, (boolean)true)) continue;
                        Map numberMap = (Map)returnentryPKInvNumberMap.get(id);
                        updateStatement.setBigDecimal(1, (BigDecimal)numberMap.get("invoiceQty"));
                        updateStatement.setBigDecimal(2, (BigDecimal)numberMap.get("invoiceBaseQty"));
                        updateStatement.setBigDecimal(3, (BigDecimal)numberMap.get("uninvoiceQty"));
                        updateStatement.setBigDecimal(4, (BigDecimal)numberMap.get("uninvoiceBaseQty"));
                        updateStatement.setBigDecimal(5, (BigDecimal)numberMap.get("invoiceAmount"));
                        updateStatement.setString(6, id);
                        updateStatement.addBatch();
                    }
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    private void writeBackPurInWarehsBill(Context ctx, PurInvoiceInfo purInvoiceInfo, boolean isAdd) throws BOSException, EASBizException {
        if (purInvoiceInfo.getSourceBillType() != null && purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            IPurInWarehsEntry ipurInWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
            PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
            IPurInWarehsBill ipurInWareshsBill = null;
            PurInvoiceEntryInfo entryInfo = null;
            PurInWarehsEntryInfo purInWarehsEntryInfo = null;
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = collection.get(i);
                ObjectStringPK purInwarehsentryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId());
                purInWarehsEntryInfo = ipurInWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)purInwarehsentryPK);
                BigDecimal invoicedqty = purInWarehsEntryInfo.getDrewQty();
                BigDecimal deltaBaseQty = entryInfo.getBaseQty();
                BigDecimal deltaQty = null;
                deltaQty = purInWarehsEntryInfo.getUnit().getId().toString().equals(entryInfo.getUnit().getId().toString()) ? entryInfo.getQty() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)purInWarehsEntryInfo.getMaterial().getId().toString(), (String)purInWarehsEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)entryInfo.getUnit().getId().toString());
                if (isAdd) {
                    BigDecimal unInvoicedQty = purInWarehsEntryInfo.getQty().subtract(invoicedqty);
                    if (unInvoicedQty != null && deltaQty.abs().compareTo(unInvoicedQty.abs()) > 0) {
                        if (ipurInWareshsBill == null) {
                            ipurInWareshsBill = PurInWarehsBillFactory.getLocalInstance((Context)ctx);
                        }
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("number"));
                        PurInWarehsBillInfo warehsBillInfo = ipurInWareshsBill.getPurInWarehsBillInfo((IObjectPK)new ObjectUuidPK(purInWarehsEntryInfo.getParent().getId()), sic);
                        throw new PurInvBizException(PurInvBizException.WRITEPURINWAREHSBILLERROR, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), warehsBillInfo.getNumber(), new Integer(purInWarehsEntryInfo.getSeq())});
                    }
                    purInWarehsEntryInfo.setDrewQty(invoicedqty.add(deltaQty));
                    purInWarehsEntryInfo.setAssociateQty(purInWarehsEntryInfo.getQty().subtract(purInWarehsEntryInfo.getDrewQty()));
                } else {
                    purInWarehsEntryInfo.setDrewQty(invoicedqty.subtract(deltaQty));
                    purInWarehsEntryInfo.setAssociateQty(purInWarehsEntryInfo.getQty().subtract(purInWarehsEntryInfo.getDrewQty()));
                }
                ipurInWarehsEntry.update((IObjectPK)purInwarehsentryPK, (CoreBaseInfo)purInWarehsEntryInfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackPurInWarehsBill(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        PreparedStatement selectpstmt = null;
        PreparedStatement updateStatement = null;
        HashMap inwentryPKInvNumberMap = new HashMap();
        ResultSet rs = null;
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select purInv.fnumber \"purInv.fnumber\",");
                sql.append("purInvEntry.fseq \"purInvEntry.fseq\",");
                sql.append("purInvEntry.fqty \"purInvEntry.fqty\",");
                sql.append("purInvEntry.fbaseQty \"purInvEntry.fbaseQty\",");
                sql.append("purInvEntry.fUnitid  \"purInvEntry.fUnitid\",");
                sql.append("purInvEntry.fBaseUnitid \"purInvEntry.fBaseUnitid\",");
                sql.append("purInWarehs.fid  \"purInWarehs.fid\",");
                sql.append("purInWarehs.fnumber  \"purInWarehs.fnumber\",");
                sql.append("purInWEntry.fid \"purInWEntry.fid\",");
                sql.append("purInWEntry.fseq \"purInWEntry.fseq\",");
                sql.append("purInWEntry.fqty \"purInWEntry.fqty\",");
                sql.append("purInWEntry.fbaseQty \"purInWEntry.fbaseQty\",");
                sql.append("purInWEntry.FDrewQty \"purInWEntry.drewQty\",");
                sql.append("purInWEntry.fUnitid \"purInWEntry.fUnitid\",");
                sql.append("purInWEntry.fBaseUnitid \"purInWEntry.fBaseUnitid\", ");
                sql.append("purInWEntry.fMaterialid \"purInWEntry.fMaterialid\" ");
                sql.append("from t_SM_PurInvoice purInv ");
                sql.append("inner join t_SM_PurInvoiceEntry purInvEntry on purInv.fid=purInvEntry.fparentid ");
                sql.append("inner join T_IM_PurInWarehsEntry  purInWEntry on purInvEntry.FSourceBillEntryID=purInWEntry.fid ");
                sql.append("inner join T_IM_PurInWarehsBill purInWarehs on purInWarehs.fid=purInWEntry.fparentid ");
                sql.append("where purInv.fid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                rs = selectpstmt.executeQuery();
                String updateSql = "update T_IM_PurInWarehsEntry set FDrewQty = ?,FAssociateQty=? where Fid = ?";
                updateStatement = cn.prepareStatement(updateSql);
                int batchNum = 0;
                while (rs.next()) {
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("purInWEntry.drewQty");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("purInvEntry.fbaseQty");
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("purInWEntry.fUnitid").equals(rs.getString("purInvEntry.fUnitid")) ? rs.getBigDecimal("purInvEntry.fqty") : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purInWEntry.fMaterialid"), (String)rs.getString("purInWEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("purInWEntry.fUnitid"));
                    if (isAdd) {
                        if (!inwentryPKInvNumberMap.containsKey(rs.getString("purInWEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purInWEntry.fMaterialid"), (String)rs.getString("purInWEntry.fUnitid"), (BigDecimal)invoicedqty, (String)rs.getString("purInWEntry.fBaseUnitid")));
                            inwentryPKInvNumberMap.put(rs.getString("purInWEntry.fid"), map);
                        }
                        numberMap = (Map)inwentryPKInvNumberMap.get(rs.getString("purInWEntry.fid"));
                        invoicedqty = (BigDecimal)numberMap.get("invoiceBaseQty");
                        BigDecimal unInvoicedQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purInWEntry.fbaseQty")).subtract(invoicedqty);
                        if (unInvoicedQty != null && SCMUtils.effectualNumeric((BigDecimal)deltaBaseQty).abs().compareTo(unInvoicedQty.abs()) > 0) {
                            throw new PurInvBizException(PurInvBizException.WRITEPURINWAREHSBILLERROR, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purInWarehs.fnumber"), rs.getString("purInWEntry.fseq")});
                        }
                        BigDecimal newInvQty = ((BigDecimal)numberMap.get("invoiceQty")).add(deltaQty);
                        numberMap.put("invoiceQty", newInvQty);
                        updateStatement.setBigDecimal(1, newInvQty);
                        updateStatement.setBigDecimal(2, rs.getBigDecimal("purInWEntry.fqty").subtract(newInvQty));
                        updateStatement.setString(3, rs.getString("purInWEntry.fid"));
                    } else {
                        if (!inwentryPKInvNumberMap.containsKey(rs.getString("purInWEntry.fid"))) {
                            map = new HashMap();
                            map.put("invoiceQty", invoicedqty);
                            inwentryPKInvNumberMap.put(rs.getString("purInWEntry.fid"), map);
                        }
                        numberMap = (Map)inwentryPKInvNumberMap.get(rs.getString("purInWEntry.fid"));
                        BigDecimal newInvQty = ((BigDecimal)numberMap.get("invoiceQty")).subtract(deltaQty);
                        numberMap.put("invoiceQty", newInvQty);
                        updateStatement.setBigDecimal(1, newInvQty);
                        updateStatement.setBigDecimal(2, rs.getBigDecimal("purInWEntry.fqty").subtract(newInvQty));
                        updateStatement.setString(3, rs.getString("purInWEntry.fid"));
                    }
                    updateStatement.addBatch();
                }
                if (batchNum > 0) {
                    updateStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(rs);
        }
    }

    private void writeBackOrder(Context ctx, PurInvoiceInfo purInvoiceInfo, boolean isAdd) throws BOSException, EASBizException {
        block41: {
            block40: {
                if (purInvoiceInfo.getSourceBillType() == null || !purInvoiceInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) break block40;
                IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
                PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
                IPurOrder ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                PurInvoiceEntryInfo entryInfo = null;
                PurOrderEntryInfo orderEntryInfo = null;
                HashMap<ObjectStringPK, PurOrderInfo> orderPKInfoMap = new HashMap<ObjectStringPK, PurOrderInfo>();
                int num = collection.size();
                for (int i = 0; i < num; ++i) {
                    PurOrderInfo purorderInfo;
                    PurOrderInfo orderInfo;
                    SelectorItemCollection selectors;
                    ObjectStringPK orderPK;
                    entryInfo = collection.get(i);
                    ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getPurOrderEntry());
                    orderEntryInfo = ipurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
                    BigDecimal invoicedqty = orderEntryInfo.getTotalInvoicedQty();
                    BigDecimal baseQty = orderEntryInfo.getTotalInvoicedBaseQty();
                    BigDecimal amount = orderEntryInfo.getTotalInvoicedAmount();
                    BigDecimal deltaBaseQty = entryInfo.getBaseQty().abs();
                    BigDecimal deltaQty = null;
                    deltaQty = orderEntryInfo.getUnit().getId().toString().equals(entryInfo.getUnit().getId().toString()) ? entryInfo.getQty().abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)entryInfo.getUnit().getId().toString());
                    if (isAdd) {
                        PurOrderInfo purOrderInfo;
                        SelectorItemCollection sic;
                        BigDecimal unInvoicedQty;
                        if (orderEntryInfo.getBaseStatus() != null && orderEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                            unInvoicedQty = orderEntryInfo.getTotalReceiptQty().subtract(invoicedqty);
                            if (unInvoicedQty != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                                if (ipurOrder == null) {
                                    ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                                }
                                sic = new SelectorItemCollection();
                                sic.add(new SelectorItemInfo("number"));
                                purOrderInfo = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic);
                                throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo.getNumber(), new Integer(orderEntryInfo.getSeq())});
                            }
                        } else if (orderEntryInfo.getBaseStatus() != null && orderEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
                            if (!orderEntryInfo.isQuantityUnCtrl()) {
                                BigDecimal unInvoicedQty2;
                                BigDecimal overRate = orderEntryInfo.getReceiveOverRate();
                                if (overRate == null) {
                                    overRate = new BigDecimal("0.00");
                                }
                                if ((unInvoicedQty2 = orderEntryInfo.getQty().multiply(overRate.add(new BigDecimal("1.00"))).subtract(invoicedqty)) != null && deltaQty.compareTo(unInvoicedQty2) > 0) {
                                    if (ipurOrder == null) {
                                        ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                                    }
                                    SelectorItemCollection sic2 = new SelectorItemCollection();
                                    sic2.add(new SelectorItemInfo("number"));
                                    PurOrderInfo purOrderInfo2 = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic2);
                                    throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo2.getNumber(), new Integer(orderEntryInfo.getSeq())});
                                }
                            } else {
                                unInvoicedQty = orderEntryInfo.getTotalReceiptQty().subtract(invoicedqty);
                                if (unInvoicedQty != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                                    if (ipurOrder == null) {
                                        ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                                    }
                                    sic = new SelectorItemCollection();
                                    sic.add(new SelectorItemInfo("number"));
                                    purOrderInfo = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic);
                                    throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGISSUEQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo.getNumber(), new Integer(orderEntryInfo.getSeq())});
                                }
                            }
                        }
                        if (!orderPKInfoMap.containsKey(orderPK = new ObjectStringPK(entryInfo.getPurOrder()))) {
                            if (ipurOrder == null) {
                                ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                            }
                            selectors = new SelectorItemCollection();
                            selectors.add(new SelectorItemInfo("*"));
                            orderInfo = ipurOrder.getPurOrderInfo((IObjectPK)orderPK, selectors);
                            orderPKInfoMap.put(orderPK, orderInfo);
                        }
                        purorderInfo = (PurOrderInfo)orderPKInfoMap.get(orderPK);
                        purorderInfo.setInvoicedAmount(purorderInfo.getInvoicedAmount().add(entryInfo.getTaxAmount().abs()));
                        orderEntryInfo.setTotalInvoicedQty(invoicedqty.add(deltaQty));
                        orderEntryInfo.setTotalInvoicedBaseQty(baseQty.add(deltaBaseQty));
                        orderEntryInfo.setTotalInvoicedAmount(amount.add(entryInfo.getTaxAmount().abs()));
                        orderEntryInfo.setAssociateQty(orderEntryInfo.getBaseQty().subtract(orderEntryInfo.getTotalInvoicedBaseQty()));
                    } else {
                        orderPK = new ObjectStringPK(entryInfo.getPurOrder());
                        if (!orderPKInfoMap.containsKey(orderPK)) {
                            if (ipurOrder == null) {
                                ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                            }
                            selectors = new SelectorItemCollection();
                            selectors.add(new SelectorItemInfo("*"));
                            orderInfo = ipurOrder.getPurOrderInfo((IObjectPK)orderPK, selectors);
                            orderPKInfoMap.put(orderPK, orderInfo);
                        }
                        purorderInfo = (PurOrderInfo)orderPKInfoMap.get(orderPK);
                        purorderInfo.setInvoicedAmount(purorderInfo.getInvoicedAmount().subtract(entryInfo.getTaxAmount().abs()));
                        orderEntryInfo.setTotalInvoicedQty(invoicedqty.subtract(deltaQty));
                        orderEntryInfo.setTotalInvoicedBaseQty(baseQty.subtract(deltaBaseQty));
                        orderEntryInfo.setTotalInvoicedAmount(amount.subtract(entryInfo.getTaxAmount().abs()));
                        orderEntryInfo.setAssociateQty(orderEntryInfo.getBaseQty().subtract(orderEntryInfo.getTotalInvoicedBaseQty()));
                    }
                    ipurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
                }
                for (IObjectPK pk : orderPKInfoMap.keySet()) {
                    PurOrderInfo info = (PurOrderInfo)orderPKInfoMap.get(pk);
                    ipurOrder.update(pk, (CoreBaseInfo)info);
                }
                break block41;
            }
            if (purInvoiceInfo.getSourceBillType() == null || !purInvoiceInfo.getSourceBillType().getId().toString().equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) break block41;
            IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
            PurInvoiceEntryInfo entryInfo = null;
            PurOrderEntryInfo orderEntryInfo = null;
            HashMap<ObjectStringPK, PurOrderInfo> orderPKInfoMap = new HashMap<ObjectStringPK, PurOrderInfo>();
            IPurOrder ipurOrder = PurOrderFactory.getLocalInstance(ctx);
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                PurOrderInfo purorderInfo;
                PurOrderInfo orderInfo;
                SelectorItemCollection selectors;
                ObjectStringPK orderPK;
                entryInfo = collection.get(i);
                if (entryInfo.getCoreBillType() == null || !entryInfo.getCoreBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) continue;
                ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getPurOrderEntry());
                orderEntryInfo = ipurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
                BigDecimal invoicedqty = orderEntryInfo.getTotalInvoicedQty();
                BigDecimal baseQty = orderEntryInfo.getTotalInvoicedBaseQty();
                BigDecimal amount = orderEntryInfo.getTotalInvoicedAmount();
                BigDecimal deltaBaseQty = entryInfo.getBaseQty().abs();
                BigDecimal deltaQty = null;
                deltaQty = orderEntryInfo.getUnit().getId().toString().equals(entryInfo.getUnit().getId().toString()) ? entryInfo.getQty().abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)deltaBaseQty, (String)entryInfo.getUnit().getId().toString());
                if (isAdd) {
                    PurOrderInfo purOrderInfo;
                    SelectorItemCollection sic;
                    BigDecimal unInvoicedQty;
                    if (orderEntryInfo.getBaseStatus() != null && orderEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                        unInvoicedQty = orderEntryInfo.getTotalReceiptQty().subtract(invoicedqty);
                        if (unInvoicedQty != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                            if (ipurOrder == null) {
                                ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                            }
                            sic = new SelectorItemCollection();
                            sic.add(new SelectorItemInfo("number"));
                            purOrderInfo = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic);
                            throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo.getNumber(), new Integer(orderEntryInfo.getSeq())});
                        }
                    } else if (orderEntryInfo.getBaseStatus() != null && orderEntryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
                        if (!orderEntryInfo.isQuantityUnCtrl()) {
                            BigDecimal unInvoicedQty3;
                            BigDecimal overRate = orderEntryInfo.getReceiveOverRate();
                            if (overRate == null) {
                                overRate = new BigDecimal("0.00");
                            }
                            if ((unInvoicedQty3 = orderEntryInfo.getQty().multiply(overRate.add(new BigDecimal("1.00"))).subtract(invoicedqty)) != null && deltaQty.compareTo(unInvoicedQty3) > 0) {
                                if (ipurOrder == null) {
                                    ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                                }
                                SelectorItemCollection sic3 = new SelectorItemCollection();
                                sic3.add(new SelectorItemInfo("number"));
                                PurOrderInfo purOrderInfo3 = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic3);
                                throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo3.getNumber(), new Integer(orderEntryInfo.getSeq())});
                            }
                        } else {
                            unInvoicedQty = orderEntryInfo.getQty().subtract(invoicedqty);
                            if (unInvoicedQty != null && deltaQty.compareTo(unInvoicedQty) > 0) {
                                if (ipurOrder == null) {
                                    ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                                }
                                sic = new SelectorItemCollection();
                                sic.add(new SelectorItemInfo("number"));
                                purOrderInfo = ipurOrder.getPurOrderInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getParent().getId()), sic);
                                throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{purInvoiceInfo.getNumber(), new Integer(entryInfo.getSeq()), purOrderInfo.getNumber(), new Integer(orderEntryInfo.getSeq())});
                            }
                        }
                    }
                    if (!orderPKInfoMap.containsKey(orderPK = new ObjectStringPK(entryInfo.getPurOrder()))) {
                        if (ipurOrder == null) {
                            ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                        }
                        selectors = new SelectorItemCollection();
                        selectors.add(new SelectorItemInfo("*"));
                        orderInfo = ipurOrder.getPurOrderInfo((IObjectPK)orderPK, selectors);
                        orderPKInfoMap.put(orderPK, orderInfo);
                    }
                    purorderInfo = (PurOrderInfo)orderPKInfoMap.get(orderPK);
                    purorderInfo.setInvoicedAmount(purorderInfo.getInvoicedAmount().add(entryInfo.getTaxAmount().abs()));
                    orderEntryInfo.setTotalInvoicedQty(invoicedqty.add(deltaQty));
                    orderEntryInfo.setTotalInvoicedBaseQty(baseQty.add(deltaBaseQty));
                    orderEntryInfo.setTotalInvoicedAmount(amount.add(entryInfo.getTaxAmount().abs()));
                } else {
                    orderPK = new ObjectStringPK(entryInfo.getPurOrder());
                    if (!orderPKInfoMap.containsKey(orderPK)) {
                        if (ipurOrder == null) {
                            ipurOrder = PurOrderFactory.getLocalInstance(ctx);
                        }
                        selectors = new SelectorItemCollection();
                        selectors.add(new SelectorItemInfo("*"));
                        orderInfo = ipurOrder.getPurOrderInfo((IObjectPK)orderPK, selectors);
                        orderPKInfoMap.put(orderPK, orderInfo);
                    }
                    purorderInfo = (PurOrderInfo)orderPKInfoMap.get(orderPK);
                    purorderInfo.setInvoicedAmount(purorderInfo.getInvoicedAmount().subtract(entryInfo.getTaxAmount().abs()));
                    orderEntryInfo.setTotalInvoicedQty(invoicedqty.subtract(deltaQty));
                    orderEntryInfo.setTotalInvoicedBaseQty(baseQty.subtract(deltaBaseQty));
                    orderEntryInfo.setTotalInvoicedAmount(amount.subtract(entryInfo.getTaxAmount().abs()));
                }
                ipurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
            }
            for (IObjectPK pk : orderPKInfoMap.keySet()) {
                PurOrderInfo info = (PurOrderInfo)orderPKInfoMap.get(pk);
                ipurOrder.update(pk, (CoreBaseInfo)info);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBackOrder(Context ctx, Connection cn, IObjectPK invPk, boolean isAdd, String sourceBillTypeId) throws BOSException, EASBizException, SQLException {
        PreparedStatement selectpstmt = null;
        PreparedStatement updateStatement = null;
        PreparedStatement updateHeadStatement = null;
        ResultSet rs = null;
        HashMap<String, BigDecimal> orderPKAmountMap = new HashMap<String, BigDecimal>();
        HashMap orderentryPKInvNumberMap = new HashMap();
        try {
            if (sourceBillTypeId != null && sourceBillTypeId.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select purInv.fnumber \"purInv.fnumber\",");
                sql.append("purInv.FCompanyOrgUnitID \"purInvEntry.FCompanyOrgUnitID\",");
                sql.append("purInvEntry.fseq \"purInvEntry.fseq\",");
                sql.append("purInvEntry.fqty \"purInvEntry.fqty\",");
                sql.append("purInvEntry.fbaseQty \"purInvEntry.fbaseQty\",");
                sql.append("purInvEntry.fUnitid  \"purInvEntry.fUnitid\",");
                sql.append("purInvEntry.fBaseUnitid \"purInvEntry.fBaseUnitid\",");
                sql.append("purInvEntry.fTaxAmount \"purInvEntry.taxAmount\",");
                sql.append("purOrder.fid  \"purOrder.fid\",");
                sql.append("purOrder.fnumber  \"purOrder.fnumber\",");
                sql.append("purOrderEntry.fid \"purOrderEntry.fid\",");
                sql.append("purOrderEntry.fseq \"purOrderEntry.fseq\",");
                sql.append("purOrderEntry.fBaseStatus \"purOrderEntry.fBaseStatus\",");
                sql.append("purOrderEntry.fqty \"purOrderEntry.fqty\",");
                sql.append("purOrderEntry.fbaseQty \"purOrderEntry.fbaseQty\",");
                sql.append("purOrderEntry.FTotalReceiptQty \"purOrderEntry.tolReceiQty\",");
                sql.append("purOrderEntry.FTotalReceiptBaseQty \"purOrderEntry.tolReceiBQty\",");
                sql.append("purOrderEntry.FTotalInvoicedQty \"purOrderEntry.tolInvQty\",");
                sql.append("purOrderEntry.FTotalInvoicedBaseQty \"purOrderEntry.tolInvBaseQty\",");
                sql.append("purOrderEntry.FTotalInvoicedAmount \"purOrderEntry.tolInvAmount\",");
                sql.append("purOrderEntry.fUnitid \"purOrderEntry.fUnitid\",");
                sql.append("purOrderEntry.fBaseUnitid \"purOrderEntry.fBaseUnitid\", ");
                sql.append("purOrderEntry.fMaterialid \"purOrderEntry.fMaterialid\", ");
                sql.append("purOrderEntry.fIsQuantityUnCtrl \"purOrderEntry.isQtyUnCtrl\",");
                sql.append("purOrderEntry.fReceiveOverRate \"purOrderEntry.recOverRate\" ");
                sql.append("from t_SM_PurInvoice purInv ");
                sql.append("inner join t_SM_PurInvoiceEntry purInvEntry on purInv.fid=purInvEntry.fparentid ");
                sql.append("inner join t_SM_PurOrderEntry  purOrderEntry on purInvEntry.FPurOrderEntryID=purOrderEntry.fid ");
                sql.append("inner join t_SM_PurOrder purOrder on purOrder.fid=purOrderEntry.fparentid ");
                sql.append("where purInv.fid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                rs = selectpstmt.executeQuery();
                String updateOrderSql = "update t_SM_PurOrderEntry set FTotalInvoicedQty = ?,FTotalInvoicedBaseQty=?,FTotalInvoicedAmount=?,FAssociateQty=? where Fid = ?";
                String updateOrderHeadSql = "update t_SM_PurOrder set FInvoicedAmount = ? where Fid =?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                updateHeadStatement = cn.prepareStatement(updateOrderHeadSql);
                int batchNum = 0;
                boolean isCreateFromPurInwarehs = false;
                while (rs.next()) {
                    BigDecimal temp;
                    BigDecimal invoiceAmount;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    String p;
                    String companyId;
                    if (batchNum == 0 && (companyId = rs.getString("purInvEntry.FCompanyOrgUnitID")) != null && companyId.trim().length() != 0 && (p = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectStringPK(companyId), (String)"PURSUP006")) != null && p.trim().length() != 0) {
                        isCreateFromPurInwarehs = p.equalsIgnoreCase("true");
                    }
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("purOrderEntry.tolInvQty");
                    BigDecimal baseQty = rs.getBigDecimal("purOrderEntry.tolInvBaseQty");
                    BigDecimal amount = rs.getBigDecimal("purOrderEntry.tolInvAmount");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("purInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("purOrderEntry.fUnitid").equals(rs.getString("purInvEntry.fUnitid")) ? rs.getBigDecimal("purInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purOrderEntry.fMaterialid"), (String)rs.getString("purOrderEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("purOrderEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal unInvoicedQty;
                        if (!orderPKAmountMap.containsKey(rs.getString("purOrder.fid"))) {
                            orderPKAmountMap.put(rs.getString("purOrder.fid"), new BigDecimal("0.00"));
                        }
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("purOrderEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", baseQty);
                            map.put("invoiceAmount", amount);
                            orderentryPKInvNumberMap.put(rs.getString("purOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("purOrderEntry.fid"));
                        invoiceAmount = (BigDecimal)orderPKAmountMap.get(rs.getString("purOrder.fid"));
                        invoiceAmount = invoiceAmount.add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        orderPKAmountMap.put(rs.getString("purOrder.fid"), invoiceAmount);
                        invoicedqty = temp = (BigDecimal)numberMap.get("invoiceQty");
                        temp = temp.add(deltaQty);
                        numberMap.put("invoiceQty", temp);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        temp = temp.add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", temp);
                        temp = rs.getBigDecimal("purOrderEntry.fbaseQty").subtract(temp);
                        numberMap.put("associateQty", temp);
                        temp = (BigDecimal)numberMap.get("invoiceAmount");
                        temp = temp.add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        numberMap.put("invoiceAmount", temp);
                        if (rs.getInt("purOrderEntry.fBaseStatus") == 7) {
                            unInvoicedQty = rs.getBigDecimal("purOrderEntry.tolReceiBQty").subtract(baseQty);
                            if (unInvoicedQty == null || deltaBaseQty.compareTo(unInvoicedQty) <= 0) continue;
                            throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                        }
                        if (rs.getInt("purOrderEntry.fBaseStatus") != 4) continue;
                        if (!rs.getBoolean("purOrderEntry.isQtyUnCtrl")) {
                            BigDecimal overRate = rs.getBigDecimal("purOrderEntry.recOverRate");
                            if (overRate == null) {
                                overRate = new BigDecimal("0.00");
                            }
                            BigDecimal unInvoicedQty2 = SysConstant.BIGZERO;
                            unInvoicedQty2 = isCreateFromPurInwarehs ? rs.getBigDecimal("purOrderEntry.tolReceiBQty").multiply(overRate.add(new BigDecimal("1.00"))).subtract(baseQty) : rs.getBigDecimal("purOrderEntry.fbaseQty").multiply(overRate.add(new BigDecimal("1.00"))).subtract(baseQty);
                            if (unInvoicedQty2 == null || deltaBaseQty.compareTo(unInvoicedQty2) <= 0) continue;
                            throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                        }
                        unInvoicedQty = SysConstant.BIGZERO;
                        unInvoicedQty = isCreateFromPurInwarehs ? rs.getBigDecimal("purOrderEntry.tolReceiBQty").subtract(baseQty) : rs.getBigDecimal("purOrderEntry.fbaseQty").subtract(baseQty);
                        if (unInvoicedQty == null || deltaBaseQty.compareTo(unInvoicedQty) <= 0) continue;
                        throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                    }
                    if (!orderPKAmountMap.containsKey(rs.getString("purOrder.fid"))) {
                        orderPKAmountMap.put(rs.getString("purOrder.fid"), new BigDecimal("0.00"));
                    }
                    if (!orderentryPKInvNumberMap.containsKey(rs.getString("purOrderEntry.fid"))) {
                        map = new HashMap();
                        map.put("invoiceQty", invoicedqty);
                        map.put("invoiceBaseQty", baseQty);
                        map.put("invoiceAmount", amount);
                        orderentryPKInvNumberMap.put(rs.getString("purOrderEntry.fid"), map);
                    }
                    numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("purOrderEntry.fid"));
                    invoiceAmount = (BigDecimal)orderPKAmountMap.get(rs.getString("purOrder.fid"));
                    invoiceAmount = invoiceAmount.subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    orderPKAmountMap.put(rs.getString("purOrder.fid"), invoiceAmount);
                    temp = (BigDecimal)numberMap.get("invoiceQty");
                    temp = temp.subtract(deltaQty);
                    numberMap.put("invoiceQty", temp);
                    temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                    temp = temp.subtract(deltaBaseQty);
                    numberMap.put("invoiceBaseQty", temp);
                    temp = rs.getBigDecimal("purOrderEntry.fbaseQty").subtract(temp);
                    numberMap.put("associateQty", temp);
                    temp = (BigDecimal)numberMap.get("invoiceAmount");
                    temp = temp.subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    numberMap.put("invoiceAmount", temp);
                }
                if (batchNum > 0) {
                    for (String id : orderentryPKInvNumberMap.keySet()) {
                        if (!BOSUuid.isValid((String)id, (boolean)true)) continue;
                        Map numberMap = (Map)orderentryPKInvNumberMap.get(id);
                        updateStatement.setBigDecimal(1, (BigDecimal)numberMap.get("invoiceQty"));
                        updateStatement.setBigDecimal(2, (BigDecimal)numberMap.get("invoiceBaseQty"));
                        updateStatement.setBigDecimal(3, (BigDecimal)numberMap.get("invoiceAmount"));
                        updateStatement.setBigDecimal(4, (BigDecimal)numberMap.get("associateQty"));
                        updateStatement.setString(5, id);
                        updateStatement.addBatch();
                    }
                    updateStatement.executeBatch();
                }
                Iterator iter = orderPKAmountMap.keySet().iterator();
                int idnum = 0;
                while (iter.hasNext()) {
                    String orderid = (String)iter.next();
                    if (!BOSUuid.isValid((String)orderid, (boolean)true)) continue;
                    ++idnum;
                    BigDecimal invoiceAmount = (BigDecimal)orderPKAmountMap.get(orderid);
                    updateHeadStatement.setBigDecimal(1, invoiceAmount);
                    updateHeadStatement.setString(2, orderid);
                    updateHeadStatement.addBatch();
                }
                if (idnum > 0) {
                    updateHeadStatement.executeBatch();
                }
            } else if (sourceBillTypeId != null && sourceBillTypeId.equals("50957179-0105-1000-e000-015fc0a812fd463ED552")) {
                StringBuffer sql = new StringBuffer();
                sql.append("select purInv.fnumber \"purInv.fnumber\",");
                sql.append("purInvEntry.fseq \"purInvEntry.fseq\",");
                sql.append("purInvEntry.fqty \"purInvEntry.fqty\",");
                sql.append("purInvEntry.fbaseQty \"purInvEntry.fbaseQty\",");
                sql.append("purInvEntry.fUnitid  \"purInvEntry.fUnitid\",");
                sql.append("purInvEntry.fBaseUnitid \"purInvEntry.fBaseUnitid\",");
                sql.append("purInvEntry.fTaxAmount \"purInvEntry.taxAmount\",");
                sql.append("purOrder.fid  \"purOrder.fid\",");
                sql.append("purOrder.fnumber  \"purOrder.fnumber\",");
                sql.append("purOrderEntry.fid \"purOrderEntry.fid\",");
                sql.append("purOrderEntry.fseq \"purOrderEntry.fseq\",");
                sql.append("purOrderEntry.fBaseStatus \"purOrderEntry.fBaseStatus\",");
                sql.append("purOrderEntry.fqty \"purOrderEntry.fqty\",");
                sql.append("purOrderEntry.fbaseQty \"purOrderEntry.fbaseQty\",");
                sql.append("purOrderEntry.FTotalReceiptQty \"purOrderEntry.tolReceiQty\",");
                sql.append("purOrderEntry.FTotalReceiptBaseQty \"purOrderEntry.receiptBsQty\",");
                sql.append("purOrderEntry.FTotalInvoicedQty \"purOrderEntry.tolInvQty\",");
                sql.append("purOrderEntry.FTotalInvoicedBaseQty \"purOrderEntry.tolInvBaseQty\",");
                sql.append("purOrderEntry.FTotalInvoicedAmount \"purOrderEntry.tolInvAmount\",");
                sql.append("purOrderEntry.fUnitid \"purOrderEntry.fUnitid\",");
                sql.append("purOrderEntry.fBaseUnitid \"purOrderEntry.fBaseUnitid\", ");
                sql.append("purOrderEntry.fMaterialid \"purOrderEntry.fMaterialid\", ");
                sql.append("purOrderEntry.fIsQuantityUnCtrl \"purOrderEntry.isQtyUnCtrl\",");
                sql.append("purOrderEntry.fReceiveOverRate \"purOrderEntry.recOverRate\" ");
                sql.append("from t_SM_PurInvoice purInv ");
                sql.append("inner join t_SM_PurInvoiceEntry purInvEntry on purInv.fid=purInvEntry.fparentid ");
                sql.append("inner join t_SM_PurOrderEntry  purOrderEntry on purInvEntry.FPurOrderEntryID=purOrderEntry.fid ");
                sql.append("inner join t_SM_PurOrder purOrder on purOrder.fid=purOrderEntry.fparentid ");
                sql.append("where purInv.fid=?");
                sql.append(" and purInvEntry.fcorebillTypeid=?");
                selectpstmt = cn.prepareStatement(sql.toString());
                selectpstmt.setString(1, invPk.toString());
                selectpstmt.setString(2, "510b6503-0105-1000-e000-010bc0a812fd463ED552");
                rs = selectpstmt.executeQuery();
                String updateOrderSql = "update t_SM_PurOrderEntry set FTotalInvoicedQty = ?,FTotalInvoicedBaseQty=?,FTotalInvoicedAmount=?,FAssociateQty=? where Fid = ?";
                String updateOrderHeadSql = "update t_SM_PurOrder set FInvoicedAmount = ? where Fid =?";
                updateStatement = cn.prepareStatement(updateOrderSql);
                updateHeadStatement = cn.prepareStatement(updateOrderHeadSql);
                int batchNum = 0;
                while (rs.next()) {
                    BigDecimal temp;
                    BigDecimal invoiceAmount;
                    Map numberMap;
                    HashMap<String, BigDecimal> map;
                    ++batchNum;
                    BigDecimal invoicedqty = rs.getBigDecimal("purOrderEntry.tolInvQty");
                    BigDecimal baseQty = rs.getBigDecimal("purOrderEntry.tolInvBaseQty");
                    BigDecimal amount = rs.getBigDecimal("purOrderEntry.tolInvAmount");
                    BigDecimal deltaBaseQty = rs.getBigDecimal("purInvEntry.fbaseQty").abs();
                    BigDecimal deltaQty = null;
                    deltaQty = rs.getString("purOrderEntry.fUnitid").equals(rs.getString("purInvEntry.fUnitid")) ? rs.getBigDecimal("purInvEntry.fqty").abs() : SCMUtils.getExchangeQtyForServer((Context)ctx, (String)rs.getString("purOrderEntry.fMaterialid"), (String)rs.getString("purOrderEntry.fBaseUnitid"), (BigDecimal)deltaBaseQty, (String)rs.getString("purOrderEntry.fUnitid"));
                    if (isAdd) {
                        BigDecimal unInvoicedQty;
                        if (!orderPKAmountMap.containsKey(rs.getString("purOrder.fid"))) {
                            orderPKAmountMap.put(rs.getString("purOrder.fid"), new BigDecimal("0.00"));
                        }
                        if (!orderentryPKInvNumberMap.containsKey(rs.getString("purOrderEntry.fid"))) {
                            map = new HashMap<String, BigDecimal>();
                            map.put("invoiceQty", invoicedqty);
                            map.put("invoiceBaseQty", baseQty);
                            map.put("invoiceAmount", amount);
                            orderentryPKInvNumberMap.put(rs.getString("purOrderEntry.fid"), map);
                        }
                        numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("purOrderEntry.fid"));
                        invoiceAmount = (BigDecimal)orderPKAmountMap.get(rs.getString("purOrder.fid"));
                        invoiceAmount = invoiceAmount.add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        orderPKAmountMap.put(rs.getString("purOrder.fid"), invoiceAmount);
                        invoicedqty = temp = (BigDecimal)numberMap.get("invoiceQty");
                        temp = temp.add(deltaQty);
                        numberMap.put("invoiceQty", temp);
                        temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                        temp = temp.add(deltaBaseQty);
                        numberMap.put("invoiceBaseQty", temp);
                        temp = rs.getBigDecimal("purOrderEntry.fbaseQty").subtract(temp);
                        numberMap.put("associateQty", temp);
                        temp = (BigDecimal)numberMap.get("invoiceAmount");
                        temp = temp.add(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                        numberMap.put("invoiceAmount", temp);
                        if (rs.getInt("purOrderEntry.fBaseStatus") == 7) {
                            unInvoicedQty = SCMUtils.effectualNumeric((BigDecimal)rs.getBigDecimal("purOrderEntry.receiptBsQty")).subtract(SCMUtils.effectualNumeric((BigDecimal)baseQty));
                            if (unInvoicedQty == null || SCMUtils.effectualNumeric((BigDecimal)deltaBaseQty).compareTo(unInvoicedQty) <= 0) continue;
                            throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                        }
                        if (rs.getInt("purOrderEntry.fBaseStatus") != 4) continue;
                        if (!rs.getBoolean("purOrderEntry.isQtyUnCtrl")) {
                            BigDecimal unInvoicedQty3;
                            BigDecimal overRate = rs.getBigDecimal("purOrderEntry.recOverRate");
                            if (overRate == null) {
                                overRate = new BigDecimal("0.00");
                            }
                            if ((unInvoicedQty3 = rs.getBigDecimal("purOrderEntry.fbaseQty").multiply(overRate.add(new BigDecimal("1.00"))).subtract(baseQty)) == null || SCMUtils.effectualNumeric((BigDecimal)deltaBaseQty).compareTo(unInvoicedQty3) <= 0) continue;
                            throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                        }
                        unInvoicedQty = rs.getBigDecimal("purOrderEntry.receiptBsQty").subtract(SCMUtils.effectualNumeric((BigDecimal)baseQty));
                        if (unInvoicedQty == null || SCMUtils.effectualNumeric((BigDecimal)deltaBaseQty).compareTo(unInvoicedQty) <= 0) continue;
                        throw new PurInvBizException(PurInvBizException.WRITEBACKORDERERROR_BIGQTY, new Object[]{rs.getString("purInv.fnumber"), rs.getString("purInvEntry.fseq"), rs.getString("purOrder.fnumber"), rs.getString("purOrderEntry.fseq")});
                    }
                    if (!orderPKAmountMap.containsKey(rs.getString("purOrder.fid"))) {
                        orderPKAmountMap.put(rs.getString("purOrder.fid"), new BigDecimal("0.00"));
                    }
                    if (!orderentryPKInvNumberMap.containsKey(rs.getString("purOrderEntry.fid"))) {
                        map = new HashMap();
                        map.put("invoiceQty", invoicedqty);
                        map.put("invoiceBaseQty", baseQty);
                        map.put("invoiceAmount", amount);
                        orderentryPKInvNumberMap.put(rs.getString("purOrderEntry.fid"), map);
                    }
                    numberMap = (Map)orderentryPKInvNumberMap.get(rs.getString("purOrderEntry.fid"));
                    invoiceAmount = (BigDecimal)orderPKAmountMap.get(rs.getString("purOrder.fid"));
                    invoiceAmount = invoiceAmount.subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    orderPKAmountMap.put(rs.getString("purOrder.fid"), invoiceAmount);
                    temp = (BigDecimal)numberMap.get("invoiceQty");
                    temp = temp.subtract(deltaQty);
                    numberMap.put("invoiceQty", temp);
                    temp = (BigDecimal)numberMap.get("invoiceBaseQty");
                    temp = temp.subtract(deltaBaseQty);
                    numberMap.put("invoiceBaseQty", temp);
                    temp = rs.getBigDecimal("purOrderEntry.fbaseQty").subtract(temp);
                    numberMap.put("associateQty", temp);
                    temp = (BigDecimal)numberMap.get("invoiceAmount");
                    temp = temp.subtract(rs.getBigDecimal("purInvEntry.taxAmount").abs());
                    numberMap.put("invoiceAmount", temp);
                }
                if (batchNum > 0) {
                    for (String id : orderentryPKInvNumberMap.keySet()) {
                        if (!BOSUuid.isValid((String)id, (boolean)true)) continue;
                        Map numberMap = (Map)orderentryPKInvNumberMap.get(id);
                        updateStatement.setBigDecimal(1, (BigDecimal)numberMap.get("invoiceQty"));
                        updateStatement.setBigDecimal(2, (BigDecimal)numberMap.get("invoiceBaseQty"));
                        updateStatement.setBigDecimal(3, (BigDecimal)numberMap.get("invoiceAmount"));
                        updateStatement.setBigDecimal(4, (BigDecimal)numberMap.get("associateQty"));
                        updateStatement.setString(5, id);
                        updateStatement.addBatch();
                    }
                    updateStatement.executeBatch();
                }
                Iterator iter = orderPKAmountMap.keySet().iterator();
                int idnum = 0;
                while (iter.hasNext()) {
                    String orderid = (String)iter.next();
                    if (!BOSUuid.isValid((String)orderid, (boolean)true)) continue;
                    ++idnum;
                    BigDecimal invoiceAmount = (BigDecimal)orderPKAmountMap.get(orderid);
                    updateHeadStatement.setBigDecimal(1, invoiceAmount);
                    updateHeadStatement.setString(2, orderid);
                    updateHeadStatement.addBatch();
                }
                if (idnum > 0) {
                    updateHeadStatement.executeBatch();
                }
            }
        }
        finally {
            SQLUtils.cleanup(selectpstmt);
            SQLUtils.cleanup(updateStatement);
            SQLUtils.cleanup(updateHeadStatement);
            SQLUtils.cleanup(rs);
        }
    }

    private void autoCheckOff(Context ctx, PurInvoiceInfo purInvoiceInfo) throws BOSException, EASBizException {
        if (!this.isRelateCreate(purInvoiceInfo)) {
            return;
        }
        ICalculateFacade iCalculateFacade = CalculateFacadeFactory.getLocalInstance((Context)ctx);
        iCalculateFacade.calculate((CoreBillBaseInfo)purInvoiceInfo);
    }

    private void canAudit(PurInvoiceInfo purInvoiceInfo) throws PurInvBizException {
        BillBaseStatusEnum state = purInvoiceInfo.getBaseStatus();
        InitializeInvoiceTypeEnum initialType = purInvoiceInfo.getInitializeInvoiceType();
        if (!initialType.equals((Object)InitializeInvoiceTypeEnum.GENERAL)) {
            throw new PurInvBizException(PurInvBizException.INITINVCANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurInvBizException(PurInvBizException.DELETED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PurInvBizException(PurInvBizException.CLOSED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new PurInvBizException(PurInvBizException.TEMPSAVED_CANNOTAUDIT);
        }
        if (state.equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurInvBizException(PurInvBizException.AUDITED_CANNOTAUDIT);
        }
        if (!state.equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new PurInvBizException(PurInvBizException.ONLYSAVEDCANAUDIT);
        }
    }

    private void checkCanAudit(int initialType, int state) throws PurInvBizException, SQLException {
        if (initialType != InitializeInvoiceTypeEnum.GENERAL.getValue()) {
            throw new PurInvBizException(PurInvBizException.INITINVCANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.DELETED.getValue()) {
            throw new PurInvBizException(PurInvBizException.DELETED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.CLOSED.getValue()) {
            throw new PurInvBizException(PurInvBizException.CLOSED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.TEMPORARILYSAVED.getValue()) {
            throw new PurInvBizException(PurInvBizException.TEMPSAVED_CANNOTAUDIT);
        }
        if (state == BillBaseStatusEnum.AUDITED.getValue()) {
            throw new PurInvBizException(PurInvBizException.AUDITED_CANNOTAUDIT);
        }
        if (state != BillBaseStatusEnum.SUBMITED.getValue()) {
            throw new PurInvBizException(PurInvBizException.ONLYSAVEDCANAUDIT);
        }
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        try {
            PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
            BillBaseStatusEnum state = purInvoiceInfo.getBaseStatus();
            if (state.equals((Object)BillBaseStatusEnum.AUDITED)) {
                throw new PurInvBizException(PurInvBizException.AUDITED_CANNOTDELETE);
            }
            if (state.equals((Object)BillBaseStatusEnum.DELETED)) {
                throw new PurInvBizException(PurInvBizException.CANCELED_CANNOTDELETE);
            }
            if (state.equals((Object)BillBaseStatusEnum.CLOSED)) {
                throw new PurInvBizException(PurInvBizException.CLOSED_CANNOTDELETE);
            }
            if (!state.equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && !state.equals((Object)BillBaseStatusEnum.SUBMITED)) {
                throw new PurInvBizException(PurInvBizException.CANNOTDELETE);
            }
        }
        catch (BOSException bosex) {
            throw new CanNotDeleteException(bosex.getMessage(), (Throwable)bosex);
        }
        catch (EASBizException easex) {
            throw new CanNotDeleteException(easex.getMessage(), (Throwable)easex);
        }
        super._canDelete(ctx, pk, cn);
    }

    @Override
    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            this._audit(ctx, (IObjectPK)pk);
        }
    }

    @Override
    protected void _cancel(Context ctx, String[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(ids[i]);
            this._cancel(ctx, (IObjectPK)pk);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            this._canDelete(ctx, pk, null);
            PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
            if (purInvoiceInfo.isIsReversed()) {
                this.deleteReverseInv(ctx, purInvoiceInfo);
            } else {
                super._delete(ctx, pk);
            }
        }
        catch (BOSException bex) {
            if (bex instanceof CanNotDeleteException && bex.getCause() instanceof PurInvBizException) {
                throw (PurInvBizException)((Object)bex.getCause());
            }
            throw bex;
        }
    }

    private void deleteReverseInv(Context ctx, PurInvoiceInfo purInvoiceInfo) throws BOSException, EASBizException {
        this.resetReversedInv(ctx, purInvoiceInfo);
        super._delete(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()));
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        this.update(ctx, pk, (CoreBaseInfo)purInvoiceInfo);
    }

    @Override
    protected void _endInitialize(Context ctx) throws BOSException, PurInvBizException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("initializeInvoiceType", (Object)InitializeInvoiceTypeEnum.BUSINESSINVOICE, CompareType.EQUALS));
        viewInfo.getFilter().setMaskString("#0");
        PurInvoiceCollection purInvoiceCollection = this.getPurInvoiceCollection(ctx, viewInfo);
        PurInvoiceInfo purInvoiceInfo = null;
        int num = purInvoiceCollection.size();
        for (int i = 0; i < num; ++i) {
            purInvoiceInfo = purInvoiceCollection.get(i);
            purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            purInvoiceInfo.setFiVouchered(true);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()), (CoreBaseInfo)purInvoiceInfo);
        }
    }

    @Override
    protected void _unInitialize(Context ctx) throws BOSException, PurInvBizException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("initializeInvoiceType", (Object)InitializeInvoiceTypeEnum.BUSINESSINVOICE, CompareType.EQUALS));
        viewInfo.getFilter().setMaskString("#0");
        PurInvoiceCollection purInvoiceCollection = this.getPurInvoiceCollection(ctx, viewInfo);
        PurInvoiceInfo purInvoiceInfo = null;
        int num = purInvoiceCollection.size();
        for (int i = 0; i < num; ++i) {
            purInvoiceInfo = purInvoiceCollection.get(i);
            purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            purInvoiceInfo.setFiVouchered(false);
            this.update(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()), (CoreBaseInfo)purInvoiceInfo);
        }
    }

    protected boolean _checkIsVouchered(Context ctx, IObjectValue model, boolean isOk) throws EASBizException, BOSException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        if (isOk) {
            if (purInvoiceInfo.isFiVouchered()) {
                throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDOK, new Object[]{purInvoiceInfo.getNumber(), ""});
            }
        } else if (!purInvoiceInfo.isFiVouchered()) {
            throw new SCMBillException(SCMBillException.CHECKISVOUCHEREDNOTOK, new Object[]{purInvoiceInfo.getNumber(), ""});
        }
        return true;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        PurInvoiceInfo info = this.getPurInvoiceInfo(ctx, sourceBillPk);
        info.setVoucher(null);
        info.setVoucherNumber(null);
        this.update(ctx, sourceBillPk, (CoreBaseInfo)info);
        return super._deleteVoucher(ctx, sourceBillPk);
    }

    private boolean isRelateCreate(PurInvoiceInfo purInvoiceInfo) {
        return purInvoiceInfo.getSourceBillType() != null;
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk, ReasonCodeInfo reasonCode) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        this.checkCanFreeze(purInvoiceInfo);
        purInvoiceInfo.setReason(reasonCode.getName());
        purInvoiceInfo.setBlockedStatus(BlockedStatusEnum.BLOCKED);
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.BLOCKED);
        this.update(ctx, pk, (CoreBaseInfo)purInvoiceInfo);
    }

    @Override
    protected void _freeze(Context ctx, IObjectPK pk, String reasonCode) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        this.checkCanFreeze(purInvoiceInfo);
        purInvoiceInfo.setReason(reasonCode);
        purInvoiceInfo.setBlockedStatus(BlockedStatusEnum.BLOCKED);
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.BLOCKED);
        this.update(ctx, pk, (CoreBaseInfo)purInvoiceInfo);
    }

    private void checkCanFreeze(PurInvoiceInfo purInvoiceInfo) throws PurInvBizException {
        if (!purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurInvBizException(PurInvBizException.CANNOTFREEZE);
        }
    }

    @Override
    protected void _unFreeze(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = this.getPurInvoiceInfo(ctx, pk);
        this.checkCanUnFreeze(purInvoiceInfo);
        purInvoiceInfo.setReasonCode(null);
        purInvoiceInfo.setBlockedStatus(BlockedStatusEnum.UNBLOCKED);
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        this.update(ctx, pk, (CoreBaseInfo)purInvoiceInfo);
    }

    private void checkCanUnFreeze(PurInvoiceInfo purInvoiceInfo) throws PurInvBizException {
        if (!purInvoiceInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED) || !purInvoiceInfo.getBlockedStatus().equals((Object)BlockedStatusEnum.BLOCKED)) {
            throw new PurInvBizException(PurInvBizException.CANNOTUNFREEZE);
        }
    }

    @Override
    protected IObjectPK[] _createReverseInv(Context ctx, IObjectPK[] sourceInvPKs) throws BOSException, PurInvBizException, EASBizException {
        PurInvoiceInfo srcInvInfo = null;
        PurInvoiceInfo destInvInfo = null;
        IObjectPK[] newPKs = new IObjectPK[sourceInvPKs.length];
        for (int i = 0; i < sourceInvPKs.length; ++i) {
            srcInvInfo = this.getPurInvoiceInfo(ctx, sourceInvPKs[i]);
            this.checkCanReverse(ctx, srcInvInfo);
            destInvInfo = (PurInvoiceInfo)srcInvInfo.clone();
            String oldnumber = srcInvInfo.getNumber();
            destInvInfo.setId(null);
            destInvInfo.setNumber(oldnumber + "-R");
            if (this.isSameNumber(ctx, sourceInvPKs[i], (IObjectValue)destInvInfo)) {
                destInvInfo.setNumber(oldnumber + "-R-1");
            }
            destInvInfo = PurUtil.getReverseAmountInfo(destInvInfo);
            destInvInfo.setInvoiceDate(new Timestamp(System.currentTimeMillis()));
            destInvInfo.setIsReversed(true);
            destInvInfo.setSourceBillId(srcInvInfo.getId().toString());
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            destInvInfo.setSourceBillType(billTypeInfo);
            destInvInfo.setAuditor(null);
            destInvInfo.setAuditTime(null);
            destInvInfo.setLastUpdateUser(null);
            destInvInfo.setLastUpdateTime(null);
            destInvInfo.setCreator(null);
            destInvInfo.setCreateTime(null);
            PurInvoiceEntryCollection collection = destInvInfo.getEntries();
            PurInvoiceEntryCollection srccollection = srcInvInfo.getEntries();
            PurInvoiceEntryInfo entryInfo = null;
            PurInvoiceEntryInfo srcentryInfo = null;
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                srcentryInfo = srccollection.get(j);
                entryInfo.setId(null);
                entryInfo.setParent(null);
            }
            PurInvPaymentPlanCollection payPlanCollection = destInvInfo.getPaymentPlans();
            PurInvPaymentPlanInfo payPlanInfo = null;
            int num2 = payPlanCollection.size();
            for (int j = 0; j < num2; ++j) {
                payPlanInfo = payPlanCollection.get(j);
                payPlanInfo.setId(null);
                payPlanInfo.setParent(null);
            }
            IPurInvoice ipurInvoice = PurInvoiceFactory.getLocalInstance(ctx);
            newPKs[i] = ipurInvoice.submit((CoreBaseInfo)destInvInfo);
            destInvInfo.setId(BOSUuid.read((String)newPKs[i].toString()));
            srcInvInfo.setReverseInvNumber(destInvInfo.getNumber());
            srcInvInfo.setReversingStatus(ReversingStateEnum.UNREVERSED);
            srcInvInfo.setIsReversed(true);
            this._update(ctx, sourceInvPKs[i], (IObjectValue)srcInvInfo);
            String strid = newPKs[i].toString();
            String bosType = strid.substring(strid.length() - 8);
            BOTRelationInfo info = new BOTRelationInfo();
            info.setSrcObjectID(sourceInvPKs[i].toString());
            info.setDestEntityID(bosType);
            info.setSrcEntityID(bosType);
            info.setDestObjectID(strid);
            info.setOperatorID("unknown");
            info.setType(0);
            BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
        }
        return newPKs;
    }

    private void checkCanReverse(Context ctx, PurInvoiceInfo srcpurInvoiceInfo) throws PurInvBizException, BOSException {
    }

    @Override
    protected Date _getNewPayPlanDate(Context ctx, IObjectPK[] orderEntryPKs, BOSUuid bizTypeID, int day) throws BOSException, PurInvBizException, EASBizException {
        Date d = new Date();
        if (orderEntryPKs != null && orderEntryPKs.length > 0) {
            Object rs = null;
            IBizType ibizType = BizTypeFactory.getLocalInstance((Context)ctx);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("bizCategory.*"));
            BizTypeInfo bizTypeInfo = ibizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeID), sic);
            if (bizTypeInfo.getBizCategory().getNumber().equals("110") || bizTypeInfo.getBizCategory().getNumber().equals("120")) {
                StringBuffer orderEntrys = new StringBuffer();
                orderEntrys.append(orderEntryPKs[0].toString());
                for (int i = 1; i < orderEntryPKs.length; ++i) {
                    orderEntrys.append(",").append(orderEntryPKs[i].toString());
                }
                IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orderEntrys.toString(), CompareType.INCLUDE));
                entityView.setFilter(filterInfo);
                PurOrderEntryCollection orderentrys = ipurOrderEntry.getPurOrderEntryCollection(entityView);
                int closedEntryNum = 0;
                BigDecimal totolStorageQty = new BigDecimal("0.00");
                int size = orderentrys.size();
                for (int i = 0; i < size; ++i) {
                    PurOrderEntryInfo orderentryInfo = orderentrys.get(i);
                    if (orderentryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                        ++closedEntryNum;
                    }
                    totolStorageQty = totolStorageQty.add(orderentryInfo.getTotalReceiptQty());
                }
                if (closedEntryNum == size || totolStorageQty.compareTo(new BigDecimal("0.00")) > 0) {
                    StringBuffer destEntryids = this.getDestEntryIDs(ctx, orderEntryPKs);
                    IPurInWarehsEntry ipurInWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
                    entityView = new EntityViewInfo();
                    entityView.getSelector().add(new SelectorItemInfo("*"));
                    entityView.getSelector().add(new SelectorItemInfo("purInWarehsBill.bizDate"));
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)destEntryids.toString(), CompareType.INCLUDE));
                    entityView.setFilter(filterInfo);
                    PurInWarehsEntryCollection purInWarehsEntryCollection = ipurInWarehsEntry.getPurInWarehsEntryCollection(entityView);
                    PurInWarehsEntryInfo purinwareEntryInfo = null;
                    Date tempdate = new Date();
                    int entryinfossize = purInWarehsEntryCollection.size();
                    if (entryinfossize > 0) {
                        tempdate = purInWarehsEntryCollection.get(0).getParent().getBizDate();
                        for (int i = 1; i < entryinfossize; ++i) {
                            purinwareEntryInfo = purInWarehsEntryCollection.get(i);
                            if (!tempdate.before(purinwareEntryInfo.getParent().getBizDate())) continue;
                            tempdate = purinwareEntryInfo.getParent().getBizDate();
                        }
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(tempdate);
                    calendar.add(5, day);
                    d = calendar.getTime();
                } else if (totolStorageQty.compareTo(new BigDecimal("0.00")) == 0) {
                    d = new Date();
                }
            } else if (bizTypeInfo.getBizCategory().getNumber().equals("130") || bizTypeInfo.getBizCategory().getNumber().equals("140") || bizTypeInfo.getBizCategory().getNumber().equals("150")) {
                StringBuffer orderEntrys = new StringBuffer();
                orderEntrys.append(orderEntryPKs[0].toString());
                for (int i = 1; i < orderEntryPKs.length; ++i) {
                    orderEntrys.append(",").append(orderEntryPKs[i].toString());
                }
                IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
                EntityViewInfo entityView = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)orderEntrys.toString(), CompareType.INCLUDE));
                entityView.setFilter(filterInfo);
                PurOrderEntryCollection orderentrys = ipurOrderEntry.getPurOrderEntryCollection(entityView);
                int closedEntryNum = 0;
                BigDecimal totolReceiveQty = new BigDecimal("0.00");
                int size = orderentrys.size();
                for (int i = 0; i < size; ++i) {
                    PurOrderEntryInfo orderentryInfo = orderentrys.get(i);
                    if (orderentryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
                        ++closedEntryNum;
                    }
                    totolReceiveQty = totolReceiveQty.add(orderentryInfo.getTotalReceiveQty());
                }
                if (closedEntryNum == size || totolReceiveQty.compareTo(new BigDecimal("0.00")) > 0) {
                    StringBuffer destEntryids = this.getDestEntryIDs(ctx, orderEntryPKs);
                    entityView = new EntityViewInfo();
                    entityView.getSelector().add(new SelectorItemInfo("*"));
                    entityView.getSelector().add(new SelectorItemInfo("purReceivalBill.bizDate"));
                    filterInfo = new FilterInfo();
                    filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)destEntryids.toString(), CompareType.INCLUDE));
                    entityView.setFilter(filterInfo);
                    IPurReceivalEntry ipurReceivalEntry = PurReceivalEntryFactory.getLocalInstance((Context)ctx);
                    PurReceivalEntryCollection collection = ipurReceivalEntry.getPurReceivalEntryCollection(entityView);
                    PurReceivalEntryInfo purReceEntryInfo = null;
                    Date tempdate = null;
                    int entryinfossize = collection.size();
                    if (entryinfossize > 0) {
                        tempdate = collection.get(0).getParent().getBizDate();
                        for (int i = 1; i < entryinfossize; ++i) {
                            purReceEntryInfo = collection.get(i);
                            if (!tempdate.before(purReceEntryInfo.getParent().getBizDate())) continue;
                            tempdate = purReceEntryInfo.getParent().getBizDate();
                        }
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(tempdate);
                        calendar.add(5, day);
                        d = calendar.getTime();
                    }
                } else if (totolReceiveQty.compareTo(new BigDecimal("0.00")) == 0) {
                    d = new Date();
                }
            }
        }
        return d;
    }

    private StringBuffer getDestEntryIDs(Context ctx, IObjectPK[] orderEntryPKs) throws BOSException {
        StringBuffer sql = new StringBuffer("select distinct(a.FDestEntryID) from T_BOT_RelationEntry a inner join T_BOT_Relation b on a.fkeyid=b.fid  where FSrcEntryID in(?");
        Object[] ids = new Object[orderEntryPKs.length];
        ids[0] = orderEntryPKs[0].toString();
        for (int i = 1; i < orderEntryPKs.length; ++i) {
            sql.append(",?");
            ids[i] = orderEntryPKs[i].toString();
        }
        sql.append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])ids);
        StringBuffer destEntryids = new StringBuffer();
        try {
            if (rs.next()) {
                destEntryids.append(rs.getString("FDestEntryID"));
            }
            while (rs.next()) {
                destEntryids.append(",").append(rs.getString("FDestEntryID"));
            }
        }
        catch (SQLException sqlex) {
            logger.error((Object)sqlex);
        }
        return destEntryids;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        if (purInvoiceInfo.getCompanyOrgUnit() != null) {
            ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitInfo info = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(purInvoiceInfo.getCompanyOrgUnit().getId()));
            return info;
        }
        return null;
    }

    @Override
    protected int[] _getAlertPlan(Context ctx, BOSUuid purInvID, int perAlertDays) throws BOSException, PurInvBizException, EASBizException {
        int[] palnSeqs = null;
        return palnSeqs;
    }

    private boolean isAlterDate(Date paymentDate, int preAlterDays) throws BOSException, PurInvBizException, EASBizException {
        boolean ret = false;
        Date currentDate = new Date();
        paymentDate = PurUtil.getBeginDate(paymentDate);
        currentDate = PurUtil.getBeginDate(currentDate);
        Calendar c = Calendar.getInstance();
        c.setTime(currentDate);
        if (currentDate.before(paymentDate)) {
            c.add(5, preAlterDays);
            if (c.getTime().before(paymentDate)) {
                ret = true;
            }
        }
        return ret;
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        this.canCancel(purInvoiceInfo);
        PurInvoiceInfo storedInvInfo = this.getPurInvoiceInfo(ctx, pk);
        if (storedInvInfo.isIsReversed()) {
            this.resetReversedInv(ctx, storedInvInfo);
        }
        purInvoiceInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        this.update(ctx, (IObjectPK)new ObjectUuidPK(purInvoiceInfo.getId()), (CoreBaseInfo)purInvoiceInfo);
    }

    @Override
    protected void _createPaymentBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    @Override
    protected void _createOtherBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
    }

    private boolean isNormalPur(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("bizType.*"));
        PurInvoiceInfo purInvInfo = this.getPurInvoiceInfo(ctx, pk, selectors);
        return purInvInfo != null && purInvInfo.getBizType() != null && purInvInfo.getBizType().getBizCategory() != null && purInvInfo.getBizType().getBizCategory().getId().toString().equals("88a7587a-e010-497b-9f86-b8f00ab2fe72A9389020");
    }

    @Override
    protected IObjectValue _initRelateCreateInvoiceInfo(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurInvoiceInfo purInvoiceInfo = (PurInvoiceInfo)model;
        if (purInvoiceInfo != null) {
            purInvoiceInfo.setInvoiceType(InvoiceTypeEnum.VALUEADDEDTAX);
            purInvoiceInfo.setBizDate(new Date());
            BillTypeInfo billTypeInfo = new BillTypeInfo();
            billTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010fc0a812fd463ED552"));
            purInvoiceInfo.setBillType(billTypeInfo);
            Timestamp timestamp = new Timestamp(new Date().getTime());
            purInvoiceInfo.setInvoiceDate(timestamp);
            CompanyOrgUnitInfo companyOrgInfo = null;
            CurrencyInfo baseCurrInfo = null;
            if (purInvoiceInfo.getCompanyOrgUnit() != null) {
                ICompanyOrgUnit icompanyOrg = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                companyOrgInfo = icompanyOrg.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(purInvoiceInfo.getCompanyOrgUnit().getId()));
                baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
                purInvoiceInfo.setCompanyOrgUnit(companyOrgInfo);
            } else {
                companyOrgInfo = ContextUtil.getCurrentFIUnit((Context)ctx);
                purInvoiceInfo.setCompanyOrgUnit(companyOrgInfo);
                baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgInfo.getBaseCurrency().getId()));
            }
            ExchangeRateInfo exchangeRateinfo = null;
            if (purInvoiceInfo.getCurrency() == null) {
                purInvoiceInfo.setCurrency(baseCurrInfo);
                exchangeRateinfo = this.getDefaultExchangeRateInfo();
            } else {
                exchangeRateinfo = this.getExchangeRate(ctx, companyOrgInfo, purInvoiceInfo.getCurrency(), baseCurrInfo);
                SelectorItemCollection selectors = new SelectorItemCollection();
                selectors.add(new SelectorItemInfo("*"));
                ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                purInvoiceInfo.setCurrency(icurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(purInvoiceInfo.getCurrency().getId()), selectors));
            }
            if (purInvoiceInfo.getCurrency() == null) {
                purInvoiceInfo.setExchangeRate(new BigDecimal("1.00"));
            } else if (exchangeRateinfo != null && exchangeRateinfo.getConvertRate() != null) {
                purInvoiceInfo.setExchangeRate(exchangeRateinfo.getConvertRate());
            }
            this.calculateAmountForRelateCreate(ctx, purInvoiceInfo, exchangeRateinfo, baseCurrInfo.getPrecision(), purInvoiceInfo.getCurrency().getPrecision());
            this.initOtherRelateDateForEntries(purInvoiceInfo);
            PurchaseOrgUnitInfo purchaseOrgInfo = purInvoiceInfo.getPurchaseOrgUnit();
            if (purchaseOrgInfo == null) {
                purchaseOrgInfo = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
            }
            if (purchaseOrgInfo != null && purInvoiceInfo.getSupplier() != null && purInvoiceInfo.getTotalTaxAmount() != null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("type"));
                sic.add(new SelectorItemInfo("day"));
                sic.add(new SelectorItemInfo("month"));
                ISupplierPurchaseInfo iSupplierpurchase = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK supplierpk = new ObjectUuidPK(purInvoiceInfo.getSupplier().getId());
                SupplierPurchaseInfoInfo supplierPurInfoinfo = iSupplierpurchase.getPurChaseInfo((IObjectPK)supplierpk, (IObjectPK)new ObjectUuidPK(purchaseOrgInfo.getId()), sic);
                purInvoiceInfo.getPaymentPlans().clear();
                purInvoiceInfo.getPaymentPlans().add(this.createDefaultPlanForRelateCreate(ctx, purInvoiceInfo, exchangeRateinfo, purInvoiceInfo.getTotalTaxAmount(), supplierPurInfoinfo, purInvoiceInfo.getBizType()));
            }
            if (purInvoiceInfo.getSettlementType() == null) {
                this.setDefaultSettleType(purInvoiceInfo, ctx);
            }
            if (purInvoiceInfo.getPaymentType() == null) {
                this.setDefaultPaymentType(purInvoiceInfo, ctx);
            }
            this.calculateBaseAndAssistQtyForRelateCreate(ctx, purInvoiceInfo);
            PurInvoiceUtil.storeDefaultValues(purInvoiceInfo, exchangeRateinfo);
        }
        return purInvoiceInfo;
    }

    private void initOtherRelateDateForEntries(PurInvoiceInfo newData) {
        PurInvoiceEntryCollection collection = newData.getEntries();
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            PurInvoiceEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getWriteOffStatus() != null) continue;
            entryInfo.setWriteOffStatus(CheckOffStatusEnum.UNCHECKOFF);
        }
    }

    private void calculateBaseAndAssistQtyForRelateCreate(Context ctx, PurInvoiceInfo newData) throws BOSException, EASBizException {
        PurInvoiceEntryCollection collection = newData.getEntries();
        PurInvoiceEntryInfo entryInfo = null;
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = collection.get(i);
            BigDecimal qty = entryInfo.getQty();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (qty != null && unitInfo != null && assistUnitInfo != null) {
                entryInfo.setAssistQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty));
            }
            if (qty == null || unitInfo == null || baseunitInfo == null) continue;
            entryInfo.setBaseQty(SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseunitInfo, (BigDecimal)qty));
        }
    }

    public PurInvPaymentPlanInfo createDefaultPlanForRelateCreate(Context ctx, PurInvoiceInfo purInvInfo, ExchangeRateInfo exchangeRateinfo, BigDecimal totalTaxPrice, SupplierPurchaseInfoInfo supplierPurchaseInfo, BizTypeInfo bizType) throws BOSException, EASBizException {
        PurInvPaymentPlanInfo purInvPaymentPlanInfo = new PurInvPaymentPlanInfo();
        purInvPaymentPlanInfo.setPaymentDate(this.getRecieveDateForRelateCreate(ctx, purInvInfo, supplierPurchaseInfo, bizType));
        purInvPaymentPlanInfo.setPaymentAmount(totalTaxPrice);
        purInvPaymentPlanInfo.setLocalPaymentAmount(PurInvoiceUtil.calculateLocalAmount(totalTaxPrice, exchangeRateinfo));
        return purInvPaymentPlanInfo;
    }

    public Date getRecieveDateForRelateCreate(Context ctx, PurInvoiceInfo purInvInfo, SupplierPurchaseInfoInfo supplierPurchaseInfo, BizTypeInfo bizType) throws BOSException, EASBizException {
        Date d = new Date();
        if (supplierPurchaseInfo != null && supplierPurchaseInfo.getType() != null) {
            if (supplierPurchaseInfo.getType().equals((Object)PaymentItemTypeEnum.BALANCE)) {
                int month = supplierPurchaseInfo.getMonth();
                int day = supplierPurchaseInfo.getDay();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(d);
                calendar.add(2, month);
                Date firstDayofMonth = PurInvoiceUtil.getFirstDayofMonth(calendar.getTime());
                calendar.setTime(firstDayofMonth);
                calendar.add(5, day);
                d = calendar.getTime();
            } else if (supplierPurchaseInfo.getType().equals((Object)PaymentItemTypeEnum.DELIVERY) && bizType != null) {
                PurInvoiceEntryCollection collection = purInvInfo.getEntries();
                IObjectPK[] orderEntryPKs = new IObjectPK[collection.size()];
                for (int i = 0; i < orderEntryPKs.length; ++i) {
                    orderEntryPKs[i] = new ObjectUuidPK(collection.get(i).getSourceBillEntryId());
                }
                d = this._getNewPayPlanDate(ctx, orderEntryPKs, bizType.getId(), supplierPurchaseInfo.getDay());
            }
        }
        return d;
    }

    private void calculateAmountForRelateCreate(Context ctx, PurInvoiceInfo newData, ExchangeRateInfo exchangeRateinfo, int baseCurrPrecision, int sourceCurrPrecision) throws BOSException, EASBizException {
        PurInvoiceEntryCollection collection = newData.getEntries();
        PurInvoiceEntryInfo entryInfo = null;
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal totalTax = new BigDecimal("0.00");
        BigDecimal totalTaxPrice = new BigDecimal("0.00");
        InvoiceTypeEnum invoiceType = newData.getInvoiceType();
        IMaterial imaterial = null;
        int num = collection.size();
        for (int i = 0; i < num; ++i) {
            BigDecimal entryLocalTotalTaxPrice;
            BigDecimal entrylocalTax;
            BigDecimal entrylocalAmount;
            BigDecimal entryTax;
            BigDecimal dealPrice;
            BigDecimal discountAmount;
            entryInfo = collection.get(i);
            entryInfo.setSeq(i + 1);
            BigDecimal price = entryInfo.getPrice();
            BigDecimal taxPrice = entryInfo.getTaxPrice();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal discountRate = entryInfo.getDiscountRate();
            BigDecimal taxRate = entryInfo.getTaxRate();
            MaterialInfo materialInfo = entryInfo.getMaterial();
            if (materialInfo.getPricePrecision() <= 0) {
                try {
                    if (imaterial == null) {
                        imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                    }
                    SelectorItemCollection selectors = new SelectorItemCollection();
                    selectors.add(new SelectorItemInfo("id"));
                    selectors.add(new SelectorItemInfo("name"));
                    selectors.add(new SelectorItemInfo("number"));
                    selectors.add(new SelectorItemInfo("pricePrecision"));
                    materialInfo = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()), selectors);
                    entryInfo.setMaterial(materialInfo);
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
            int pricePrecision = materialInfo.getPricePrecision();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo baseUnitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (unitInfo != null && materialInfo != null && baseUnitInfo != null) {
                entryInfo.setBaseQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)baseUnitInfo, (BigDecimal)qty));
            }
            if (unitInfo != null && materialInfo != null && assistUnitInfo != null) {
                entryInfo.setAssistQty(SCMUtils.getExchangeQtyForServer((Context)ctx, (String)materialInfo.getId().toString(), (MeasureUnitInfo)unitInfo, (MeasureUnitInfo)assistUnitInfo, (BigDecimal)qty));
            }
            if (invoiceType.equals((Object)InvoiceTypeEnum.GENERAL)) {
                if (taxPrice != null && price == null) {
                    price = PurInvoiceUtil.calculatePrice(taxRate, taxPrice, invoiceType).setScale(pricePrecision, 4);
                    entryInfo.setPrice(price);
                } else if (price != null && taxPrice == null) {
                    taxPrice = PurInvoiceUtil.calculateTaxPrice(taxRate, price, invoiceType).setScale(pricePrecision, 4);
                    entryInfo.setTaxPrice(taxPrice);
                }
                discountAmount = null;
                discountAmount = PurInvoiceUtil.calculateDiscountAmount(taxPrice, qty, discountRate);
                entryInfo.setDiscountAmount(discountAmount);
                dealPrice = null;
                dealPrice = PurInvoiceUtil.calculateDealPrice(taxPrice, discountRate).setScale(pricePrecision, 4);
                entryInfo.setActualPrice(dealPrice);
                BigDecimal entrytotalTaxPrice = null;
                entrytotalTaxPrice = PurInvoiceUtil.calculateTotalTaxPriceForGeneral(dealPrice, qty).setScale(sourceCurrPrecision, 4);
                entryInfo.setTaxAmount(entrytotalTaxPrice);
                totalTaxPrice = totalTaxPrice.add(entrytotalTaxPrice);
                entryTax = PurInvoiceUtil.calculateTaxForGeneral(totalTaxPrice, taxRate).setScale(sourceCurrPrecision, 4);
                entryInfo.setTax(entryTax);
                totalTax = totalTax.add(entryTax);
                BigDecimal amount = PurInvoiceUtil.calculateAmountForGeneral(totalTaxPrice, entryTax).setScale(sourceCurrPrecision, 4);
                entryInfo.setAmount(amount);
                totalAmount = totalAmount.add(amount);
                entrylocalAmount = PurInvoiceUtil.calculateLocalAmount(amount, exchangeRateinfo).setScale(baseCurrPrecision, 4);
                entryInfo.setLocalAmount(entrylocalAmount);
                entrylocalTax = PurInvoiceUtil.calculateLocalAmount(entryTax, exchangeRateinfo).setScale(baseCurrPrecision, 4);
                entryInfo.setLocalTax(entrylocalTax);
                entryLocalTotalTaxPrice = PurInvoiceUtil.calculateLocalAmount(entrytotalTaxPrice, exchangeRateinfo).setScale(baseCurrPrecision, 4);
                entryInfo.setLocalTaxAmount(entryLocalTotalTaxPrice);
                continue;
            }
            if (!invoiceType.equals((Object)InvoiceTypeEnum.VALUEADDEDTAX)) continue;
            if (price != null && taxPrice == null) {
                taxPrice = PurInvoiceUtil.calculateTaxPrice(taxRate, price, invoiceType).setScale(pricePrecision, 4);
                entryInfo.setTaxPrice(taxPrice);
            } else if (taxPrice != null && price == null) {
                price = PurInvoiceUtil.calculatePrice(taxRate, taxPrice, invoiceType).setScale(pricePrecision, 4);
                entryInfo.setPrice(price);
            }
            discountAmount = null;
            discountAmount = PurInvoiceUtil.calculateDiscountAmount(taxPrice, qty, discountRate);
            entryInfo.setDiscountAmount(discountAmount);
            dealPrice = PurInvoiceUtil.calculateDealPrice(taxPrice, discountRate).setScale(pricePrecision, 4);
            entryInfo.setActualPrice(dealPrice);
            BigDecimal amount = PurInvoiceUtil.calculateAmount(price, qty, discountRate, pricePrecision).setScale(sourceCurrPrecision, 4);
            entryInfo.setAmount(amount);
            totalAmount = totalAmount.add(amount);
            entryTax = PurInvoiceUtil.calculateTax(amount, taxRate).setScale(sourceCurrPrecision, 4);
            entryInfo.setTax(entryTax);
            totalTax = totalTax.add(entryTax);
            BigDecimal entrytotalTaxPrice = PurInvoiceUtil.calculateTotalTaxPrice(amount, entryTax).setScale(sourceCurrPrecision, 4);
            entryInfo.setTaxAmount(entrytotalTaxPrice);
            totalTaxPrice = totalTaxPrice.add(entrytotalTaxPrice);
            entrylocalAmount = PurInvoiceUtil.calculateLocalAmount(amount, exchangeRateinfo).setScale(baseCurrPrecision, 4);
            entryInfo.setLocalAmount(entrylocalAmount);
            entrylocalTax = PurInvoiceUtil.calculateLocalAmount(entryTax, exchangeRateinfo).setScale(baseCurrPrecision, 4);
            entryInfo.setLocalTax(entrylocalTax);
            entryLocalTotalTaxPrice = PurInvoiceUtil.calculateLocalAmount(entrytotalTaxPrice, exchangeRateinfo).setScale(baseCurrPrecision, 4);
            entryInfo.setLocalTaxAmount(entryLocalTotalTaxPrice);
        }
        newData.setTotalAmount(totalAmount);
        newData.setTotalTax(totalTax);
        newData.setTotalTaxAmount(totalTaxPrice);
    }

    private ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo ficompanyOrgInfo, CurrencyInfo sourceCurr, CurrencyInfo destCurr) throws BOSException, EASBizException {
        ExchangeRateInfo exchangeRateinfo = null;
        if (sourceCurr != null && destCurr != null) {
            if (sourceCurr.getId().equals((Object)destCurr.getId())) {
                exchangeRateinfo = this.getDefaultExchangeRateInfo();
            } else {
                ObjectUuidPK excTablepk = null;
                ObjectUuidPK sourceCurrPK = null;
                ObjectUuidPK destCurrPK = null;
                ExchangeTableInfo exchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
                if (exchangeTableInfo == null) {
                    throw new PurInvBizException(PurInvBizException.EXCHANGETABLENULL);
                }
                excTablepk = new ObjectUuidPK(ficompanyOrgInfo.getBaseExchangeTable().getId());
                sourceCurrPK = new ObjectUuidPK(sourceCurr.getId());
                destCurrPK = new ObjectUuidPK(destCurr.getId());
                IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("*"));
                sic.add(new SelectorItemInfo("exchangeAux.*"));
                ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                exchangeRateinfo = tempexrateinfo != null ? iexchangRate.getExchangeRateInfo((IObjectPK)new ObjectUuidPK(tempexrateinfo.getId()), sic) : this.getDefaultExchangeRateInfo();
            }
        }
        return exchangeRateinfo;
    }

    private ExchangeRateInfo getDefaultExchangeRateInfo() {
        ExchangeRateInfo innerexchangeRateinfo = new ExchangeRateInfo();
        innerexchangeRateinfo.setConvertRate(new BigDecimal("1.00"));
        ExchangeAuxInfo exAux = new ExchangeAuxInfo();
        exAux.setPrecision(2);
        exAux.setConvertMode(ConvertModeEnum.DIRECTEXCHANGERATE);
        innerexchangeRateinfo.setExchangeAux(exAux);
        return innerexchangeRateinfo;
    }

    private void setDefaultSettleType(PurInvoiceInfo newData, Context ctx) throws BOSException, EASBizException {
        ISettlementType isettlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        SettlementTypeCollection settlementCollection = isettlementType.getSettlementTypeCollection(viewInfo);
        if (settlementCollection != null && settlementCollection.size() > 0) {
            newData.setSettlementType(settlementCollection.get(0));
        }
    }

    private void setDefaultPaymentType(PurInvoiceInfo newData, Context ctx) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5", CompareType.EQUALS));
        filter.setMaskString("#0");
        viewInfo.setFilter(filter);
        IPaymentType ipaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PaymentTypeCollection collection = ipaymentType.getPaymentTypeCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            newData.setPaymentType(collection.get(0));
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("companyOrgUnit.*"));
        PurInvoiceInfo info = this.getPurInvoiceInfo(ctx, pk, selectors);
        return info.getCompanyOrgUnit();
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return true;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurInvoiceInfo)model).getCompanyOrgUnit()) != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }
}

