/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CashDiscountCollection;
import com.kingdee.eas.basedata.assistant.CashDiscountFactory;
import com.kingdee.eas.basedata.assistant.CashDiscountInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICashDiscount;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.helper.PurImportHandlingHelper;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.AbstractPurOrderInfo;
import com.kingdee.eas.scm.sm.pur.IPurContract;
import com.kingdee.eas.scm.sm.pur.PurContractCollection;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.FilterSqlUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurOrderDataImport
extends SCMDataImport {
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate", "FPrepaymentRate", "FPrepayment"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "prepaymentRate", "prepayment"};
    String[] STRING_FIELDS = new String[]{"FSupplierOrderNumber", "FDescription", "FDeliveryAddress"};
    String[] STRING_OBJS = new String[]{"supplierOrderNumber", "description", "deliveryAddress"};
    String[] DATE_FIELDS = new String[]{"FCreatTime", "FBizDate"};
    String[] DATE_OBJS = new String[]{"creatTime", "bizDate"};
    String[] BOOLEAN_FIELDS = new String[]{"FIsInTax", "FIsQuicken", "FIsPriceInTax"};
    String[] BOOLEAN_OBJS = new String[]{"isInTax", "isQuicken", "isPriceInTax"};
    Map paramMap = new HashMap();
    String[] INTEGER_FIELDS = new String[0];
    String[] INTEGER_OBJS = new String[0];
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FAssistQty", "FDiscountRate", "FQty", "FTaxRate", "FAmount", "FActualTaxPrice", "FTax", "FTaxAmount", "FDiscountAmount", "FReceiveOverRate", "FReceiveOwingRate", "FExchangeRate", "FTaxRate", "FDeliverAdvanceDay", "FDeliverDeferralDay", "FLocalTax", "FLocalTaxAmount", "FLocalAmount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"assistQty", "discountRate", "qty", "taxRate", "amount", "actualTaxPrice", "tax", "taxAmount", "discountAmount", "receiveOverRate", "receiveOwingRate", "exchangeRate", "taxRate", "deliverAdvanceDay", "deliverDeferralDay", "localTax", "localTaxAmount", "localAmount"};
    String[] STRING_FIELDS_EN = new String[]{"FRemark", "FDeliveryAddress", "FMaterialName"};
    String[] STRING_OBJS_EN = new String[]{"remark", "deliveryAddress", "materialName"};
    String[] DATE_FIELDS_EN = new String[]{"FDeliveryDate"};
    String[] DATE_OBJS_EN = new String[]{"deliveryDate"};
    String[] BOOLEAN_FIELDS_EN = new String[]{"FIsPresent", "FIsQuantityUnCtrl", "FIsTimeUnCtrl"};
    String[] BOOLEAN_OBJS_EN = new String[]{"isPresent", "quantityUnCtrl", "timeUnCtrl"};
    private BigDecimal zero = new BigDecimal("0.0");
    private BigDecimal totalTaxAmt = new BigDecimal("0.0");
    private int discountRatePrePrecision = 6;
    ImportDataCache dataPool = new ImportDataCache();
    private static final String RESOURCE = "com.kingdee.eas.scm.sm.pur.PurImportExportResource";
    private Map<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
    private Map<String, AdminOrgUnitInfo> adminOrgMap = new HashMap<String, AdminOrgUnitInfo>();
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, CurrencyInfo> basecurrencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, CompanyOrgUnitInfo> companyByPurOrderMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, CompanyOrgUnitInfo> companyBystorageMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, SettlementTypeInfo> settlementTypeMap = new HashMap<String, SettlementTypeInfo>();
    private Map<String, PayConditionInfo> payConditionMap = new HashMap<String, PayConditionInfo>();
    private Map<String, CashDiscountInfo> cashDiscountMap = new HashMap<String, CashDiscountInfo>();
    private Map<String, PurContractInfo> purContracetMap = new HashMap<String, PurContractInfo>();
    private Map<String, WarehouseInfo> warehouseMap = new HashMap<String, WarehouseInfo>();
    private PurImportHandlingHelper importHandlingHelper = new PurImportHandlingHelper();
    ExchangeRateInfo exchangeRateInfo = null;
    Map<String, String> numberMap = new HashMap<String, String>();
    private static Logger logger = Logger.getLogger(PurOrderDataImport.class);
    private static final BigDecimal hundred = BigDecimal.valueOf(100L);

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurOrderFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    private Object getData(String key, Map lineData) {
        return ((DataToken)lineData.get((Object)key)).data;
    }

    public CoreBaseInfo transmit(Map hsData, Context ctx) throws TaskExternalException {
        TaskExternalException tex = new TaskExternalException("");
        AbstractPurOrderInfo purOrderInfo = null;
        for (int i = 0; i < hsData.size(); ++i) {
            Map lineData = (Map)hsData.get(new Integer(i));
            if (i == 0) {
                try {
                    purOrderInfo = this.transmitHead(lineData, ctx);
                    this.afterBuildHead(ctx, purOrderInfo, lineData);
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, purOrderInfo);
                    break;
                }
                if (purOrderInfo == null) {
                    return null;
                }
            }
            PurOrderEntryCollection entryCollection = purOrderInfo.getEntries();
            PurOrderEntryInfo entryInfo = new PurOrderEntryInfo();
            if (this.getData("FSeq", lineData) != null && !StringUtil.isEmpty((String)this.getData("FSeq", lineData).toString())) {
                entryInfo.setSeq(Integer.parseInt(this.getData("FSeq", lineData).toString()));
            } else {
                entryInfo.setSeq(i + 1);
            }
            entryInfo.setParent((PurOrderInfo)purOrderInfo);
            try {
                this.handleEntry((PurOrderInfo)purOrderInfo, entryInfo, lineData, ctx);
            }
            catch (TaskExternalException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                if (tex.getEntryErrorReasons().size() != 1) continue;
                this.recycleNumber(ctx, purOrderInfo);
                continue;
            }
            entryCollection.add(entryInfo);
            this.calEntryNew(ctx, (PurOrderInfo)purOrderInfo, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        if (purOrderInfo != null && tex.getEntryErrorReasons().size() == 0) {
            this.checkPrepaymentValid((PurOrderInfo)purOrderInfo, ctx);
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return purOrderInfo;
    }

    private void checkPrepaymentValid(PurOrderInfo purOrderInfo, Context ctx) throws TaskExternalException {
        BigDecimal prepayment = purOrderInfo.getPrepayment();
        BigDecimal prepaymentRate = purOrderInfo.getPrepaymentRate();
        BigDecimal calPrepayment = BigDecimal.ZERO;
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if (!(calPrepayment = this.totalTaxAmt.multiply(prepaymentRate.multiply(new BigDecimal("0.01"))).setScale(currencyPrecision, 4)).equals(prepayment.setScale(currencyPrecision))) {
            BigDecimal rate = prepayment.divide(this.totalTaxAmt, 4, 1).multiply(new BigDecimal("100")).setScale(2);
            this.totalTaxAmt = BigDecimal.ZERO;
            this.fail(ctx, "PrepaymentInvalid", new String[]{purOrderInfo.getNumber(), prepaymentRate.toString(), rate.toString()});
        }
        this.totalTaxAmt = BigDecimal.ZERO;
    }

    private PurOrderInfo transmitHead(Map lineData, Context ctx) throws TaskExternalException {
        PurOrderInfo purOrderInfo = new PurOrderInfo();
        try {
            this.discountRatePrePrecision = Integer.parseInt(ParamManager.getParamValue((Context)ctx, null, (String)"DISCOUNTRATEPRECISION"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.doDecimalFields(ctx, lineData, purOrderInfo);
        this.doDateFields(ctx, lineData, purOrderInfo);
        this.doBooleanFields(ctx, lineData, purOrderInfo);
        this.doStringFields(lineData, purOrderInfo);
        this.doIntegerFields(lineData, purOrderInfo);
        try {
            this.doPurchaseOrgUnit(purOrderInfo, lineData, ctx);
            this.doCreator(ctx, lineData, purOrderInfo);
            this.doBiztype(ctx, lineData, purOrderInfo);
            this.doPurchaseGroup(ctx, lineData, purOrderInfo);
            this.doPurchasePerson(ctx, lineData, purOrderInfo);
            this.doSupplier(ctx, lineData, purOrderInfo);
            this.doAdminOrgUnit(ctx, lineData, purOrderInfo);
            CurrencyInfo localCurrency = this.getLocalCurrency(ctx, purOrderInfo);
            this.doCurrcency(ctx, lineData, purOrderInfo, localCurrency);
            this.doExchangeRate(ctx, lineData, purOrderInfo, localCurrency);
            this.doSettlementType(ctx, lineData, purOrderInfo);
            this.doPaymentType(ctx, lineData, purOrderInfo);
            this.doPaymentCondition(ctx, lineData, purOrderInfo);
            this.doCashDiscount(ctx, lineData, purOrderInfo);
            purOrderInfo.setTotalAmount(BigDecimal.ZERO);
            purOrderInfo.setTotalTax(BigDecimal.ZERO);
            purOrderInfo.setTotalTaxAmount(BigDecimal.ZERO);
            purOrderInfo.setLocalTotalAmount(BigDecimal.ZERO);
            purOrderInfo.setLocalTotalTaxAmount(BigDecimal.ZERO);
            String importOption = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sm.pur.client.PurOrderListUI", "importOption");
            if (importOption != null && !"0".equals(importOption)) {
                purOrderInfo.setPrepayment(BigDecimal.ZERO);
            }
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        this.doHeaderDefaultValue(lineData, purOrderInfo);
        return purOrderInfo;
    }

    private void doHeaderDefaultValue(Map lineData, PurOrderInfo purOrderInfo) {
        Object data = ((DataToken)lineData.get((Object)"FIsPriceInTax")).data;
        if ("".equals(data)) {
            purOrderInfo.setIsInTax(false);
        }
        if (purOrderInfo != null && !purOrderInfo.isIsPriceInTax()) {
            purOrderInfo.setIsInTax(true);
        }
        purOrderInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        purOrderInfo.setCU(purOrderInfo.getPurchaseOrgUnit().getCU());
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010bc0a812fd463ED552"));
        purOrderInfo.setBillType(billtype);
    }

    private void doSupplier(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FSupplier_Number")).data;
        if (null == data || StringUtils.isEmpty((String)data.toString())) {
            this.fail(ctx, "supplierNumberNotNull");
        }
        SupplierInfo suppLierInfo = this.getSupplier(ctx, "number", data);
        this.checkSupplierEnableThrow(ctx, suppLierInfo, data.toString());
        purOrderInfo.setSupplier(suppLierInfo);
    }

    private void doPurchasePerson(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        PurchaseGroupInfo purGourpInfo = purOrderInfo.getPurchaseGroup();
        Object data = ((DataToken)lineData.get((Object)"FPurchasePerson_Number")).data;
        PersonInfo purchasePerson = this.getPurchasePerson(ctx, "number", purGourpInfo, data);
        purOrderInfo.setPurchasePerson(purchasePerson);
    }

    private PurchaseGroupInfo doPurchaseGroup(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPurchaseGroup_Number")).data;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purOrderInfo.getPurchaseOrgUnit();
        PurchaseGroupInfo purGroupInfo = this.getPurchaseGroup(ctx, "number", purchaseOrgUnitInfo, data, false);
        if (!this.isEmpty(data) && purGroupInfo == null) {
            this.fail(ctx, "PUR_GROUP_NOT_EXISTE_BY_PUR_ORG", new String[]{purchaseOrgUnitInfo.getNumber(), data.toString()});
        }
        purOrderInfo.setPurchaseGroup(purGroupInfo);
        return purGroupInfo;
    }

    private void doBiztype(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FBizType_Number")).data;
        BizTypeInfo bizType = this.getBizType(ctx, "510b6503-0105-1000-e000-010bc0a812fd463ED552", "number", data);
        purOrderInfo.setBizType(bizType);
    }

    private void doCreator(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FCreator_Number")).data;
        UserInfo userInfo = this.getCreator(ctx, data);
        purOrderInfo.setCreator(userInfo);
    }

    private void doCashDiscount(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FCashDiscount")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.cashDiscountMap.containsKey(str)) {
                purOrderInfo.setCashDiscount(this.cashDiscountMap.get(str));
            } else {
                ICashDiscount iCashDiscount = CashDiscountFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                CashDiscountCollection collection = iCashDiscount.getCashDiscountCollection(this.getFilter(data.toString().trim(), sic));
                if (collection != null && collection.size() > 0) {
                    CashDiscountInfo info = collection.get(0);
                    if (info != null) {
                        purOrderInfo.setCashDiscount(info);
                        this.cashDiscountMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"CashDiscountNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doPaymentCondition(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPaymentCondition_Number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.payConditionMap.containsKey(str)) {
                purOrderInfo.setPaymentCondition(this.payConditionMap.get(str));
                purOrderInfo.setPrepaymentRate(this.payConditionMap.get(str).getPrepayRate());
            } else {
                IPayCondition iPayCondition = PayConditionFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("prepayRate"));
                PayConditionCollection collection = iPayCondition.getPayConditionCollection(this.getFilter(data.toString().trim(), sic));
                if (collection != null && collection.size() > 0) {
                    PayConditionInfo info = collection.get(0);
                    if (info != null) {
                        purOrderInfo.setPaymentCondition(info);
                        if (null != info.getPrepayRate()) {
                            purOrderInfo.setPrepaymentRate(info.getPrepayRate());
                        }
                        this.payConditionMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PaymentConditionNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doPaymentType(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FPaymentType_Number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            PaymentTypeInfo info = this.getPaymentType(ctx, "number", data, null);
            if (null == info) {
                throw new TaskExternalException(data.toString() + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PaymentTypeNotExists", (Context)ctx));
            }
            purOrderInfo.setPaymentType(info);
        } else {
            this.fail(ctx, "paymentTypeNotNull");
        }
    }

    private void doSettlementType(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FSettlementType_Number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (this.settlementTypeMap.containsKey(str)) {
                purOrderInfo.setSettlementType(this.settlementTypeMap.get(str));
            } else {
                ISettlementType isettlementType = SettlementTypeFactory.getLocalInstance((Context)ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                SettlementTypeCollection collection = isettlementType.getSettlementTypeCollection(this.getFilter(str.trim(), sic));
                if (collection != null && collection.size() > 0) {
                    SettlementTypeInfo info = collection.get(0);
                    if (info != null) {
                        purOrderInfo.setSettlementType(info);
                        this.settlementTypeMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"SettlementTypeNotExists", (Context)ctx));
                }
            }
        }
    }

    private void doExchangeRate(Context ctx, Map lineData, PurOrderInfo purOrderInfo, CurrencyInfo localCurrency) throws TaskExternalException, EASBizException, BOSException {
        String str = ((DataToken)lineData.get((Object)"FExchangeRate")).data.toString();
        this.exchangeRateInfo = null;
        if (purOrderInfo.getCurrency().getId().toString().equals(localCurrency.getId().toString())) {
            purOrderInfo.setExchangeRate(BigDecimal.ONE);
        } else {
            try {
                if (StringUtil.isEmpty((String)str) || new BigDecimal(str).compareTo(BigDecimal.ZERO) == 0) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ExchangeRateNotExists", (Context)ctx));
                }
                ExchangeRateInfo exchangeRateInfo = this.getExchangeRate(ctx, purOrderInfo.getCompanyOrgUnit(), (IObjectPK)new ObjectUuidPK(localCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(purOrderInfo.getCurrency().getId().toString()));
                int precision = purOrderInfo.getCurrency().getPrecision();
                if (exchangeRateInfo != null) {
                    purOrderInfo.setConvertMode(exchangeRateInfo.getConvertMode());
                    precision = exchangeRateInfo.getPrecision();
                    this.exchangeRateInfo = exchangeRateInfo;
                }
                purOrderInfo.setExchangeRate(new BigDecimal(str).setScale(precision, RoundingMode.HALF_UP));
            }
            catch (NumberFormatException e) {
                this.fail(ctx, "invalidBigDecimalFormat");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCurrcency(Context ctx, Map lineData, PurOrderInfo purOrderInfo, CurrencyInfo localCurrency) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FCurrency_Number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            if (str != null && str.length() > 0) {
                if (this.currencyMap.containsKey(str)) {
                    purOrderInfo.setCurrency(this.currencyMap.get(str));
                    return;
                } else {
                    ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    CurrencyCollection collection = icurrency.getCurrencyCollection(this.getFilter(data.toString().trim()));
                    if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"CurrencyNotExists", (Context)ctx));
                    CurrencyInfo info = collection.get(0);
                    if (info == null) return;
                    purOrderInfo.setCurrency(info);
                    this.currencyMap.put(str, info);
                }
                return;
            } else {
                purOrderInfo.setCurrency(localCurrency);
                purOrderInfo.setExchangeRate(BigDecimal.ONE);
            }
            return;
        } else {
            purOrderInfo.setCurrency(localCurrency);
            purOrderInfo.setExchangeRate(BigDecimal.ONE);
        }
    }

    private CurrencyInfo getLocalCurrency(Context ctx, PurOrderInfo purOrderInfo) throws BOSException {
        CurrencyInfo localCurrency = null;
        PurchaseOrgUnitInfo purInfo = purOrderInfo.getPurchaseOrgUnit();
        if (purInfo != null) {
            if (this.basecurrencyMap.containsKey(purInfo.getId().toString())) {
                localCurrency = this.basecurrencyMap.get(purInfo.getId().toString());
                purOrderInfo.setCompanyOrgUnit(this.companyByPurOrderMap.get(purInfo.getId().toString()));
            } else {
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)purInfo.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)3));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
                ev.setFilter(fi);
                IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
                if (relationCol != null && relationCol.size() > 0) {
                    String toUnitId = relationCol.get(0).getToUnit().getId().toString();
                    ev = new EntityViewInfo();
                    fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("id", (Object)toUnitId));
                    SelectorItemCollection si = new SelectorItemCollection();
                    si.add(new SelectorItemInfo("id"));
                    si.add(new SelectorItemInfo("baseCurrency.*"));
                    ev.setFilter(fi);
                    ev.setSelector(si);
                    ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection(ev);
                    if (comCol != null && comCol.size() > 0) {
                        CompanyOrgUnitInfo comInfo = comCol.get(0);
                        localCurrency = comInfo.getBaseCurrency();
                        this.basecurrencyMap.put(purInfo.getId().toString(), localCurrency);
                        purOrderInfo.setCompanyOrgUnit(comInfo);
                        this.companyByPurOrderMap.put(purInfo.getId().toString(), comInfo);
                    }
                }
            }
        }
        return localCurrency;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doAdminOrgUnit(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws BOSException, EASBizException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnit_Number")).data;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (purOrderInfo.getPurchasePerson() != null) {
            if (!this.paramMap.containsValue("PURORDER001")) {
                this.paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(new String[]{"PURORDER001"}, purOrderInfo.getPurchaseOrgUnit().getId().toString());
            }
            if (this.isIntPurParam("PURORDER001", 0, 0, this.paramMap)) {
                if (!this.adminOrgMap.containsKey(purOrderInfo.getPurchasePerson().getId().toString())) {
                    IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                    adminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(purOrderInfo.getPurchasePerson().getId());
                    this.adminOrgMap.put(purOrderInfo.getPurchasePerson().getId().toString(), adminOrgUnitInfo);
                }
                adminOrgUnitInfo = this.adminOrgMap.get(purOrderInfo.getPurchasePerson().getId().toString());
                purOrderInfo.setAdminOrgUnit(adminOrgUnitInfo);
            } else {
                purOrderInfo.setAdminOrgUnit(null);
                if (!this.adminOrgMap.containsKey(purOrderInfo.getPurchaseOrgUnit().getId().toString() + data)) {
                    IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    OrgUnitCollection ioc = iour.getToUnit(purOrderInfo.getPurchaseOrgUnit().getId().toString(), 3, 0);
                    if (ioc != null && ioc.size() > 0) {
                        adminOrgUnitInfo = (AdminOrgUnitInfo)ioc.get(0);
                        for (int i = 0; i < ioc.size(); ++i) {
                            if (!ioc.get(i).getNumber().toString().equals(data)) continue;
                            adminOrgUnitInfo = (AdminOrgUnitInfo)ioc.get(i);
                            break;
                        }
                    }
                    this.adminOrgMap.put(purOrderInfo.getPurchaseOrgUnit().getId().toString() + data, adminOrgUnitInfo);
                }
                adminOrgUnitInfo = this.adminOrgMap.get(purOrderInfo.getPurchaseOrgUnit().getId().toString() + data);
                purOrderInfo.setAdminOrgUnit(adminOrgUnitInfo);
            }
        }
        if (data == null || StringUtil.isEmpty((String)data.toString()) || purOrderInfo.getAdminOrgUnit() != null) return;
        String str = data.toString();
        if (this.adminOrgMap.containsKey(str)) {
            purOrderInfo.setAdminOrgUnit(this.adminOrgMap.get(str));
            return;
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(purOrderInfo.getPurchaseOrgUnit().getId().toString(), 3, 0);
            HashSet<String> orgIdSet = new HashSet<String>();
            if (orgUnitCollection == null || orgUnitCollection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"purRelationAdmin", (Context)ctx));
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                orgIdSet.add(orgUnitCollection.get(i).getId().toString());
            }
            IAdminOrgUnit iadminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection collection = iadminOrgUnit.getAdminOrgUnitCollection(this.getFilterForAdmin(data.toString().trim(), orgIdSet));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"AdminOrgUnitNotExists", (Context)ctx));
            AdminOrgUnitInfo info = collection.get(0);
            if (info == null) return;
            purOrderInfo.setAdminOrgUnit(info);
            this.adminOrgMap.put(str, info);
        }
    }

    private void doIntegerFields(Map lineData, PurOrderInfo purOrderInfo) {
        for (int i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.INTEGER_FIELDS[i])).data;
            if (o == null || o.toString().equals("")) continue;
            Integer value = new Integer(o.toString());
            purOrderInfo.setInt(this.INTEGER_OBJS[i], value);
        }
    }

    private void doStringFields(Map lineData, PurOrderInfo purOrderInfo) {
        for (int i = 0; i < this.STRING_FIELDS.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            String value = o.toString();
            if (value.length() > 255) {
                value = value.substring(0, 255);
            }
            purOrderInfo.setString(this.STRING_OBJS[i], value);
        }
    }

    private void doBooleanFields(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        for (int i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            purOrderInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue(value, this.BOOLEAN_OBJS[i], ctx));
        }
    }

    private void doDecimalFields(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        Object o = null;
        for (int i = 0; i < this.BIGDECIMAL_FIELDS.length; ++i) {
            try {
                o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = new BigDecimal(o.toString());
                    if (this.BIGDECIMAL_FIELDS[i].equalsIgnoreCase("FPrepaymentRate")) {
                        this.checkRateValid(ctx, value, "prepaymentRate");
                    }
                    if (value == null) continue;
                    purOrderInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], value);
                    continue;
                }
                purOrderInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i], BigDecimal.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex);
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"numberFormatError", (Context)ctx));
            }
        }
    }

    private void doDateFields(Context ctx, Map lineData, PurOrderInfo purOrderInfo) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            Date value;
            Object o = ((DataToken)lineData.get((Object)this.DATE_FIELDS[i])).data;
            if (o != null && o.toString().length() > 0) {
                try {
                    o = df.parse(o.toString());
                }
                catch (ParseException pex) {
                    logger.error((Object)pex);
                    this.fail(ctx, "InvalidDateFormat");
                }
                if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
                purOrderInfo.setDate(this.DATE_OBJS[i], value);
                continue;
            }
            if ("bizDate".equals(this.DATE_OBJS[i])) {
                this.fail(ctx, "orderDateNotNull");
            }
            value = new Date();
            purOrderInfo.setDate(this.DATE_OBJS[i], value);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doPurchaseOrgUnit(PurOrderInfo purOrderInfo, Map lineData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)lineData.get((Object)"FPurchaseOrgUnit_Number")).data;
        if (souData == null) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PURQUOTATION_PUSCHORIG_NOTNULL", (Context)ctx));
        if (souData.toString().trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PURQUOTATION_PUSCHORIG_NOTNULL", (Context)ctx));
        PurchaseOrgUnitInfo info = this.getPurchaseOrgUnit(ctx, "number", souData);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        try {
            if (userInfoID != null) {
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(info.getId().toString()), "purorder_addnew");
            }
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
        purOrderInfo.setPurchaseOrgUnit(info);
    }

    private void handleEntry(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        this.doEntryDateFields(entryInfo, lineData, ctx);
        this.doEntryBooleanFields(entryInfo, lineData, ctx);
        this.doEntryStringFields(entryInfo, lineData);
        try {
            this.doPiceFields(purOrderInfo, entryInfo, lineData, ctx);
            this.doRowType(purOrderInfo, entryInfo, lineData, ctx);
            this.doStorageOrgUnit(entryInfo, lineData, ctx);
            this.doMaterialInfo(purOrderInfo, entryInfo, lineData, ctx);
            this.doUnit(entryInfo, lineData, ctx);
            this.doEntryDecimalFields(entryInfo, lineData, ctx);
            this.doRequestOrgUnit(entryInfo, lineData, ctx);
            this.doAssitProperty(entryInfo, lineData, ctx);
            this.doBaseUnitAndBaseQty(entryInfo, ctx);
            this.doEntryAdminOrg(purOrderInfo, entryInfo, lineData, ctx);
            this.doWarehouse(entryInfo, lineData, ctx);
            this.doPurContract(entryInfo, lineData, ctx);
            this.doProjectNumber(entryInfo, lineData, ctx);
            this.doTrackNumber(entryInfo, lineData, ctx);
            entryInfo.setBizDate(purOrderInfo.getBizDate());
            entryInfo.setPurchaseOrgUnit(purOrderInfo.getPurchaseOrgUnit().getId().toString());
        }
        catch (EASBizException ex) {
            throw new TaskExternalException(ex.getMessage());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void doTrackNumber(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FTrackNumber")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getStorageOrgUnit() != null) {
            TrackNumberInfo info = this.getTrackNumber(ctx, data, entryInfo.getStorageOrgUnit().getCU());
            if (entryInfo.getProject() != null) {
                ProjectCarCollection pjc = entryInfo.getProject().getCarNumberRange();
                if (pjc != null) {
                    boolean isFound = false;
                    int size = pjc.size();
                    for (int i = 0; i < size; ++i) {
                        String tr_proj;
                        ProjectCarInfo pci = pjc.get(i);
                        if (pci.getTrackNumber() == null || !(tr_proj = pci.getTrackNumber().getId().toString()).equals(info.getId().toString())) continue;
                        entryInfo.setTrackNo(info);
                        isFound = true;
                        break;
                    }
                    if (!isFound) {
                        this.fail(ctx, "trackNumberNotInProject");
                    }
                }
            } else {
                entryInfo.setTrackNo(info);
            }
        }
    }

    private void doProjectNumber(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FProject")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getMaterial() != null && entryInfo.getStorageOrgUnit() != null) {
            ProjectInfo pro = this.getProject(ctx, data, entryInfo.getStorageOrgUnit().getCU());
            MaterialPlanInfo mpInfo = this.getMaterialPlan(ctx, entryInfo.getMaterial(), entryInfo.getStorageOrgUnit(), null, null);
            if (mpInfo != null) {
                HashSet<String> set = new HashSet<String>();
                set.add("MTO20");
                set.add("ATO20");
                ManufactureStrategyInfo strategy = mpInfo.getManufactureStrategy();
                if (strategy == null || !set.contains(strategy.getNumber())) {
                    entryInfo.setProject(pro);
                }
            } else {
                entryInfo.setProject(pro);
            }
        }
    }

    private void doPurContract(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)lineData.get((Object)"FPurContract_Number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            if (!this.purContracetMap.containsKey(str)) {
                IPurContract iPurContract = PurContractFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                PurContractCollection collection = iPurContract.getPurContractCollection(this.getFilter(str.trim(), sic));
                if (collection != null && collection.size() > 0) {
                    PurContractInfo info = collection.get(0);
                    if (info != null) {
                        this.purContracetMap.put(str, info);
                    }
                } else {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PurContractNotExists", (Context)ctx));
                }
            }
            entryInfo.setPurContractID(this.purContracetMap.get(str));
        }
    }

    private void doWarehouse(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data;
        MaterialInfo material = entryInfo.getMaterial();
        StorageOrgUnitInfo receiveOrgInfo = entryInfo.getStorageOrgUnit();
        if (material != null && receiveOrgInfo != null && (data = ((DataToken)lineData.get((Object)"FWareHouse_Number")).data) != null && !StringUtil.isEmpty((String)data.toString()) && (str = data.toString()) != null && str.length() > 0) {
            if (!this.warehouseMap.containsKey(receiveOrgInfo.getId().toString() + str)) {
                EntityViewInfo accreditEV = new EntityViewInfo();
                FilterInfo accreditF = new FilterInfo();
                SelectorItemCollection accreditSic = new SelectorItemCollection();
                accreditF.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)receiveOrgInfo.getId().toString(), CompareType.EQUALS));
                accreditF.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                accreditSic.add(new SelectorItemInfo("warehouse"));
                accreditEV.setSelector(accreditSic);
                accreditEV.setFilter(accreditF);
                SOAccreditWHCollection isoCol = SOAccreditWHFactory.getLocalInstance((Context)ctx).getSOAccreditWHCollection(accreditEV);
                HashSet<String> warehouseIdSet = new HashSet<String>();
                SOAccreditWHInfo sOAccreditWHInfo = null;
                for (int i = 0; i < isoCol.size(); ++i) {
                    sOAccreditWHInfo = isoCol.get(i);
                    if (null == sOAccreditWHInfo || null == sOAccreditWHInfo.getWarehouse()) continue;
                    warehouseIdSet.add(sOAccreditWHInfo.getWarehouse());
                }
                EntityViewInfo ev = this.getFilter(data.toString().trim());
                FilterInfo f = ev.getFilter();
                f.getFilterItems().add(new FilterItemInfo("id", warehouseIdSet, CompareType.INCLUDE));
                f.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                ev.setSelector(sic);
                IWarehouse iHouse = WarehouseFactory.getLocalInstance((Context)ctx);
                WarehouseCollection collection = iHouse.getWarehouseCollection(ev);
                if (collection != null && collection.size() > 0) {
                    WarehouseInfo info = collection.get(0);
                    if (info != null) {
                        this.warehouseMap.put(receiveOrgInfo.getId().toString() + str, info);
                    }
                } else {
                    this.fail(ctx, "WarehouseNotExistOrInvalid");
                }
            }
            entryInfo.setWareHouse(this.warehouseMap.get(receiveOrgInfo.getId().toString() + str));
        }
    }

    private void doEntryAdminOrg(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        PurchaseOrgUnitInfo purOrg;
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType != null && rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT) && (purOrg = purOrderInfo.getPurchaseOrgUnit()) != null) {
            Object data = ((DataToken)lineData.get((Object)"FAdminOrgUnitNumber_Entry")).data;
            if (data != null && !StringUtil.isEmpty((String)data.toString())) {
                AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", data);
                EntityViewInfo ev = new EntityViewInfo();
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)info.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)purOrg.getId().toString()));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)0));
                fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)3));
                ev.setFilter(fi);
                IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
                if (relationCol != null && relationCol.size() > 0) {
                    entryInfo.setAdminOrgUnit(info);
                } else {
                    this.fail(ctx, "AdminOrgNotDelegatePurOrg");
                }
            } else {
                this.fail(ctx, "adminOrgUnitNotNull");
            }
        }
    }

    private void doBaseUnitAndBaseQty(PurOrderEntryInfo entryInfo, Context ctx) throws BOSException, EASBizException, TaskExternalException {
        if (entryInfo.getRowType() != null && entryInfo.getRowType().isIsHasMaterialNumber()) {
            if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getBaseUnit().getId() != null) {
                entryInfo.setBaseUnit(entryInfo.getMaterial().getBaseUnit());
                if (entryInfo.getUnit() != null && entryInfo.getQty() != null) {
                    BigDecimal baseUnitQty = this.getExchangePrecisionQty(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit(), entryInfo.getBaseUnit(), entryInfo.getQty());
                    entryInfo.setBaseQty(baseUnitQty);
                    MultiMeasureUnitInfo multiUnifInfo = this.getMultiMeasureUnitInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
                    BigDecimal qty = entryInfo.getQty().setScale(multiUnifInfo.getQtyPrecision(), 4);
                    entryInfo.setQty(qty);
                }
            }
        } else {
            if (entryInfo.getUnit() != null) {
                entryInfo.setBaseUnit(entryInfo.getUnit());
            }
            if (entryInfo.getQty() != null) {
                entryInfo.setBaseQty(entryInfo.getQty());
            }
        }
    }

    private void doAssitProperty(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        Object data;
        MaterialInfo material = entryInfo.getMaterial();
        if (material != null && material.getAssistAttr() != null && (data = ((DataToken)lineData.get((Object)"FAssistProperty_Number")).data) != null) {
            AsstAttrValueInfo info = this.getAsstAttr(ctx, data, material.getAssistAttr());
            entryInfo.setAssistProperty(info);
        }
    }

    private void doRequestOrgUnit(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.STORAGEORGUNIT)) {
            Object data = ((DataToken)lineData.get((Object)"FRequestOrgUnit_Number")).data;
            if (data != null && !StringUtil.isEmpty((String)data.toString())) {
                StorageOrgUnitInfo info = this.getStorageOrgUnit(ctx, "number", data);
                entryInfo.setRequestOrgUnit(info);
            } else {
                this.fail(ctx, "RequestOrgNotNull");
            }
        }
    }

    private void doStorageOrgUnit(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FStorageOrgUnit_Number")).data;
        if (data != null && !StringUtil.isEmpty((String)data.toString())) {
            String str = data.toString();
            StorageOrgUnitInfo info = this.getStorageOrgUnit(ctx, "number", data);
            entryInfo.setStorageOrgUnit(info);
            CompanyOrgUnitInfo companyInfo = this.getCompanyInfoByStorage(entryInfo, ctx, str, info);
            entryInfo.setCompanyOrgUnit(companyInfo);
        } else {
            this.fail(ctx, "receiveOrgUnitNotNull");
        }
    }

    private CompanyOrgUnitInfo getCompanyInfoByStorage(PurOrderEntryInfo entryInfo, Context ctx, String str, StorageOrgUnitInfo info) throws BOSException {
        if (this.companyBystorageMap.containsKey(str)) {
            return this.companyBystorageMap.get(str);
        }
        if (info != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)info.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)4));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            ev.setFilter(fi);
            IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
            if (relationCol != null && relationCol.size() > 0) {
                String toUnitId = relationCol.get(0).getToUnit().getId().toString();
                ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection("where id = '" + toUnitId + "'");
                if (comCol != null && comCol.size() > 0) {
                    this.companyBystorageMap.put(str, comCol.get(0));
                    return comCol.get(0);
                }
            }
        }
        return null;
    }

    private void doUnit(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException, BOSException {
        Object data = ((DataToken)lineData.get((Object)"FUnit_Number")).data;
        if (null != data && !StringUtils.isEmpty((String)data.toString())) {
            MaterialInfo material = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = null;
            if (entryInfo.getMaterial() != null) {
                unitInfo = this.getMeasureUnit(ctx, data, material);
                entryInfo.setUnit(unitInfo);
            } else if (entryInfo.getMaterialName() != null) {
                unitInfo = this.getMeasureUnitByNumber(ctx, data.toString());
                entryInfo.setUnit(unitInfo);
            }
        } else {
            this.fail(ctx, "unitNotNull");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MaterialInfo doMaterialInfo(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        MaterialInfo material = null;
        RowTypeInfo rowType = entryInfo.getRowType();
        if (rowType == null) return material;
        if (rowType.isIsHasMaterialNumber()) {
            Object data = ((DataToken)lineData.get((Object)"FMaterial_Number")).data;
            if (data == null || StringUtil.isEmpty((String)data.toString())) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_NULL", (Context)ctx));
            String str = data.toString().trim();
            if (str == null || str.length() <= 0) return material;
            material = this.getMaterial(ctx, "number", str, new OrgUnitInfo[]{purOrderInfo.getCompanyOrgUnit(), purOrderInfo.getPurchaseOrgUnit(), entryInfo.getStorageOrgUnit()});
            if (null != material && !UsedStatusEnum.APPROVED.equals((Object)material.getStatus())) {
                throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurBizResource", "MATERIAL_NOT_APPROVED", new String[]{str}, ctx));
            }
            entryInfo.setMaterial(material);
            entryInfo.setMaterialName(material.getName());
            entryInfo.setNoNumMaterialModel(material.getModel());
            entryInfo.setAssistUnit(material.getAssistUnit());
            return material;
        } else {
            String materialName = ((DataToken)lineData.get((Object)"FMaterialName")).data.toString().trim();
            if (StringUtil.isEmpty((String)materialName)) {
                this.fail(ctx, "materialNameNotNull");
            }
            String model = ((DataToken)lineData.get((Object)"FModel")).data.toString().trim();
            entryInfo.setMaterialName(materialName);
            entryInfo.setNoNumMaterialModel(model);
        }
        return material;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doRowType(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws BOSException, TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FRowType_Number")).data;
        if (data == null || "".equals(data)) throw new TaskExternalException(" " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"RowTypeNotExists", (Context)ctx));
        String str = data.toString();
        if (this.rowTypeMap.containsKey(str)) {
            entryInfo.setRowType(this.rowTypeMap.get(str));
            entryInfo.setDestinationType(this.rowTypeMap.get(str).getDestinationType());
            return;
        } else {
            RowTypeCollection collection;
            IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
            String bizTypeid = null;
            if (purOrderInfo.getBizType() != null) {
                bizTypeid = purOrderInfo.getBizType().getId().toString();
            }
            if ((collection = iRowType.getRowTypeCollection(this.getFilter(data.toString().trim()))) == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"RowTypeNotExists", (Context)ctx));
            RowTypeInfo info = collection.get(0);
            if (info == null || bizTypeid == null) return;
            if (!this.checkRowType(ctx, bizTypeid, info.getId().toString())) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"BizTypeNotRelationRowType", (Context)ctx));
            }
            entryInfo.setRowType(info);
            entryInfo.setDestinationType(info.getDestinationType());
            this.rowTypeMap.put(str, info);
        }
    }

    private void doPiceFields(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        BigDecimal zero = BigDecimal.ZERO;
        boolean isPresent = entryInfo.isIsPresent();
        BigDecimal price = zero;
        BigDecimal taxPrice = zero;
        BigDecimal taxRate = zero;
        boolean isInTax = purOrderInfo.isIsInTax();
        boolean isPriceInTax = purOrderInfo.isIsPriceInTax();
        boolean isvmi = false;
        String importOption = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sm.pur.client.PurOrderListUI", "importOption");
        boolean isCalEntryByAmt = "2".equals(importOption);
        BizTypeInfo bizTypeInfo = purOrderInfo.getBizType();
        if (null != bizTypeInfo && "LAdiD6Y5Sim6q6bmixITqSQHQ1w=".equals(bizTypeInfo.getId().toString()) || "3IS1Qaa0R32+3JPxlVZg5iQHQ1w=".equals(bizTypeInfo.getId().toString())) {
            isvmi = true;
        }
        try {
            String taxRateStr = ((DataToken)lineData.get((Object)"FTaxRate")).data.toString();
            if (StringUtil.isEmpty((String)taxRateStr)) {
                taxRateStr = "0";
            }
            if ((taxRate = this.getUnPercentedRate(taxRateStr)).compareTo(zero) < 0) {
                this.fail(ctx, "taxRateCannotNegative");
            }
            if (isPresent) {
                entryInfo.setPrice(zero);
                entryInfo.setTaxPrice(zero);
                entryInfo.setTaxRate(zero);
                entryInfo.setDiscountRate(zero);
                entryInfo.setAmount(zero);
                entryInfo.setTaxAmount(zero);
                entryInfo.setDiscountAmount(zero);
                entryInfo.setDiscountRate(zero);
            } else {
                if (!isCalEntryByAmt) {
                    if (isInTax && !isvmi) {
                        String taxPriceStr = ((DataToken)lineData.get((Object)"FTaxPrice")).data.toString();
                        if (StringUtil.isEmpty((String)taxPriceStr) && !isvmi) {
                            this.fail(ctx, "taxPriceNotNull");
                        }
                        if (StringUtil.isEmpty((String)taxPriceStr) && isvmi) {
                            taxPriceStr = "0.0";
                        }
                        if ((taxPrice = new BigDecimal(taxPriceStr)).compareTo(zero) == 0 && !isvmi) {
                            this.fail(ctx, "taxPriceNotNull");
                        }
                        if (taxPrice.compareTo(zero) < 0) {
                            this.fail(ctx, "taxPriceCannotNegative");
                        }
                        price = isPriceInTax ? taxPrice.divide(BigDecimal.ONE.add(taxRate), 2, 4) : taxPrice.multiply(BigDecimal.ONE.subtract(taxRate));
                    } else {
                        String priceStr = ((DataToken)lineData.get((Object)"FPrice")).data.toString();
                        if (StringUtil.isEmpty((String)priceStr) && !isvmi) {
                            this.fail(ctx, "PriceNotNull");
                        }
                        if (StringUtil.isEmpty((String)priceStr) && isvmi) {
                            priceStr = "0.0";
                        }
                        if ((price = new BigDecimal(priceStr)).compareTo(zero) == 0 && !isvmi) {
                            this.fail(ctx, "PriceNotNull");
                        }
                        if (price.compareTo(zero) < 0) {
                            this.fail(ctx, "priceCannotNegative");
                        }
                        taxPrice = price.multiply(BigDecimal.ONE.add(taxRate));
                    }
                } else if (isInTax || !isPriceInTax) {
                    String taxAmountStr = ((DataToken)lineData.get((Object)"FTaxAmount")).data.toString();
                    if (StringUtil.isEmpty((String)taxAmountStr)) {
                        this.fail(ctx, "taxAmountNotNull");
                    }
                } else {
                    String amountStr = ((DataToken)lineData.get((Object)"FAmount")).data.toString();
                    if (StringUtil.isEmpty((String)amountStr)) {
                        this.fail(ctx, "amountNotNull");
                    }
                }
                entryInfo.setPrice(price);
                entryInfo.setTaxPrice(taxPrice);
                entryInfo.setTaxRate(new BigDecimal(taxRateStr));
            }
        }
        catch (NumberFormatException e) {
            this.fail(ctx, "invalidBigDecimalFormat");
        }
    }

    private void doEntryStringFields(PurOrderEntryInfo entryInfo, Map lineData) {
        for (int i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            Object o = ((DataToken)lineData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            String value = o.toString();
            if (value.length() > 255) {
                value = value.substring(0, 255);
            }
            entryInfo.setString(this.STRING_OBJS_EN[i], value);
        }
    }

    private void doEntryBooleanFields(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        for (int i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
            String value;
            Object o = ((DataToken)lineData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue(value, this.BOOLEAN_OBJS_EN[i], ctx));
        }
    }

    private void doEntryDateFields(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            Date value;
            Object o = ((DataToken)lineData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if ("FDeliveryDate".equals(this.DATE_FIELDS_EN[i]) && (null == o || StringUtils.isEmpty((String)o.toString()))) {
                this.fail(ctx, "DeliveryDateNotNull");
            }
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                logger.error((Object)pex);
                this.fail(ctx, "InvalidDateFormat");
            }
            if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            entryInfo.setDate(this.DATE_OBJS_EN[i], value);
        }
    }

    private BigDecimal doEntryDecimalFields(PurOrderEntryInfo entryInfo, Map lineData, Context ctx) throws TaskExternalException {
        BigDecimal zero = BigDecimal.ZERO;
        for (int i = 0; i < this.BIGDECIMAL_FIELDS_EN.length; ++i) {
            try {
                Object o = ((DataToken)lineData.get((Object)this.BIGDECIMAL_FIELDS_EN[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    RowTypeInfo rowType;
                    BigDecimal value = new BigDecimal(o.toString());
                    if (value == null) continue;
                    if ("FDiscountRate".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                        this.checkRateValid(ctx, value, "DiscountRate");
                    }
                    if ("FTaxRate".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                        this.checkRateValid(ctx, value, "TaxRate");
                    }
                    if ("FReceiveOwingRate".equalsIgnoreCase(this.BIGDECIMAL_FIELDS_EN[i])) {
                        this.checkRateValid(ctx, value, "ReceiveOwingRate");
                    }
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                    if ("baseQty".equals(this.BIGDECIMAL_OBJ_EN[i])) {
                        entryInfo.setBigDecimal("totalUnReceiveBaseQty", value);
                    }
                    if ("qty".equals(this.BIGDECIMAL_OBJ_EN[i])) {
                        entryInfo.setBigDecimal("totalUnReceiveQty", value);
                    }
                    if ((rowType = entryInfo.getRowType()) == null) continue;
                    if (rowType.isIsHasMaterialNumber()) {
                        if (!"FAssistQty".equals(this.BIGDECIMAL_FIELDS_EN[i]) || null != entryInfo.getMaterial().getAssistUnit()) continue;
                        entryInfo.setAssistQty(zero);
                        continue;
                    }
                    entryInfo.setAssistQty(zero);
                    continue;
                }
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], BigDecimal.ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                logger.error((Object)nex);
                this.fail(ctx, "invalidBigDecimalFormat");
            }
        }
        return zero;
    }

    private EntityViewInfo getFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getFilterByName(String name, String purchaseGroupid) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.number", (Object)name, CompareType.EQUALS));
        if (purchaseGroupid != null) {
            filter.getFilterItems().add(new FilterItemInfo("purGroup.id", (Object)purchaseGroupid, CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private boolean checkRowType(Context ctx, String bizType, String rowType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        viewInfo.setSelector(sic);
        filterInfo.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)bizType, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("rowType.id", (Object)rowType, CompareType.INCLUDE));
        viewInfo.setFilter(filterInfo);
        CoreBaseCollection bizTypeCollection = RowBizTypeFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return !bizTypeCollection.isEmpty() && bizTypeCollection.size() > 0;
    }

    private boolean getBooleanValue(String value, String key, Context ctx) throws TaskExternalException {
        return (value = value.trim()).equals(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx)) || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private String getBooleanText(Context ctx, boolean value) {
        if (value) {
            return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx);
        }
        return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "not", ctx);
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private void calEntry(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        boolean isInTax = purOrderInfo.isIsInTax();
        if (isInTax) {
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryPriceByTaxPrice(purOrderInfo, entryInfo);
            this.calEntryTotalTaxAmount(purOrderInfo, entryInfo);
            this.calEntryTax(purOrderInfo, entryInfo);
            this.calEntryAmount(purOrderInfo, entryInfo);
            this.calEntryActualPrice(purOrderInfo, entryInfo);
            this.calEntryActualTaxPrice(purOrderInfo, entryInfo);
            this.calEntryDiscountAmount(purOrderInfo, entryInfo);
        } else {
            entryInfo.setPrice(entryInfo.getPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryTaxPricebyPrice(purOrderInfo, entryInfo);
            this.calEntryDiscountAmount(purOrderInfo, entryInfo);
            this.calEntryAmount(purOrderInfo, entryInfo);
            this.calEntryActualPrice(purOrderInfo, entryInfo);
            this.calEntryTax(purOrderInfo, entryInfo);
            this.calEntryTotalTaxAmount(purOrderInfo, entryInfo);
            this.calEntryActualTaxPrice(purOrderInfo, entryInfo);
        }
        this.calEntryLocalValue(purOrderInfo, entryInfo);
        this.calTotalAmount(purOrderInfo);
        this.calTotalTax(purOrderInfo);
        this.calTotalTaxAmount(purOrderInfo);
        this.calTotalValue(purOrderInfo);
        this.calPrepayment(purOrderInfo, entryInfo);
    }

    public void calTotalValue(PurOrderInfo purOrderInfo) {
        BigDecimal localTotalAmount = new BigDecimal("0.00");
        BigDecimal localTotalTaxAmount = new BigDecimal("0.00");
        int count = purOrderInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purOrderInfo.getEntries().get(index).getAmount() != null) {
                localTotalAmount = localTotalAmount.add(purOrderInfo.getEntries().get(index).getAmount());
            }
            if (purOrderInfo.getEntries().get(index).getTaxAmount() == null) continue;
            localTotalTaxAmount = localTotalTaxAmount.add(purOrderInfo.getEntries().get(index).getTaxAmount());
        }
        purOrderInfo.setLocalTotalAmount(localTotalAmount);
        purOrderInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
    }

    public void calEntryLocalValue(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        BigDecimal entryLocalAmount = new BigDecimal("0.00");
        BigDecimal entryLocalTax = new BigDecimal("0.00");
        BigDecimal entryLocalTaxAmount = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal exchangeRate = purOrderInfo.getExchangeRate();
        ConvertModeEnum convertMode = purOrderInfo.getConvertMode();
        if (amount != null && SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
            if (convertMode != null && convertMode == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryLocalAmount = amount.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTax = tax.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
            } else if (SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
                entryLocalAmount = amount.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTax = tax.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.divide(exchangeRate, currencyPrecision, 4);
            }
        }
        entryInfo.setLocalAmount(entryLocalAmount);
        entryInfo.setLocalTax(entryLocalTax);
        entryInfo.setLocalTaxAmount(entryLocalTaxAmount);
    }

    public void calPrepayment(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        BigDecimal taxAmount;
        BigDecimal prepaymentRate;
        BigDecimal prepaymentAmount = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if ((prepaymentRate = purOrderInfo.getPrepaymentRate()) != null && (taxAmount = entryInfo.getTaxAmount()) != null) {
            prepaymentAmount = taxAmount.multiply(prepaymentRate).divide(new BigDecimal("100")).setScale(currencyPrecision, 4);
        }
        entryInfo.setPrepayment(prepaymentAmount);
        entryInfo.setUnPrereceivedAm(prepaymentAmount);
    }

    public void calTotalAmount(PurOrderInfo purOrderInfo) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        int count = purOrderInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purOrderInfo.getEntries().get(index).getAmount() == null) continue;
            totalAmount = totalAmount.add(purOrderInfo.getEntries().get(index).getAmount());
        }
        purOrderInfo.setTotalAmount(totalAmount);
    }

    public void calTotalTax(PurOrderInfo purOrderInfo) {
        BigDecimal totalTax = new BigDecimal("0.00");
        int count = purOrderInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purOrderInfo.getEntries().get(index).getTax() == null) continue;
            totalTax = totalTax.add(purOrderInfo.getEntries().get(index).getTax());
        }
        purOrderInfo.setTotalTax(totalTax);
    }

    public void calTotalTaxAmount(PurOrderInfo purOrderInfo) {
        BigDecimal totalTaxAmount = new BigDecimal("0.00");
        int count = purOrderInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purOrderInfo.getEntries().get(index).getTaxAmount() == null) continue;
            totalTaxAmount = totalTaxAmount.add(purOrderInfo.getEntries().get(index).getTaxAmount());
        }
        purOrderInfo.setTotalTaxAmount(totalTaxAmount);
        this.totalTaxAmt = totalTaxAmount;
    }

    public void calEntryTaxPricebyPrice(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)materialPricePrecision);
        entryInfo.setTaxPrice(taxPrice);
    }

    private void calEntryPriceByTaxPrice(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        boolean isInTax = purOrderInfo.isIsInTax();
        boolean isPriceInTax = purOrderInfo.isIsPriceInTax();
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = 4;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        } else if (entryInfo.getRowType() != null) {
            materialPricePrecision = entryInfo.getRowType().getPrecision();
        }
        if (isInTax) {
            price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)materialPricePrecision);
            if (!isPriceInTax) {
                price = CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)materialPricePrecision);
            }
        }
        entryInfo.setPrice(price);
    }

    private int getPricePre(PurOrderEntryInfo entryInfo) {
        int materialPricePrecision = 4;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        } else if (entryInfo.getRowType() != null) {
            materialPricePrecision = entryInfo.getRowType().getPrecision();
        }
        return materialPricePrecision;
    }

    private void calEntryTotalTaxAmount(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        boolean isInTax = purOrderInfo.isIsInTax();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal discount = entryInfo.getDiscountRate();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            qty = qty == null ? this.zero : qty;
            taxPrice = taxPrice == null ? this.zero : taxPrice;
            discount = discount == null ? this.zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            BigDecimal discountAmount = new BigDecimal("0.00");
            if (taxPrice != null && discount != null && qty != null) {
                discountAmount = taxPrice.multiply(qty).multiply(discount).divide(oneHundred, 10, 4);
                actualPrice = taxPrice.multiply(qty).subtract(discountAmount).divide(one, currencyPrecision, 4);
                entryInfo.setTaxAmount(actualPrice);
            }
        } else {
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            BigDecimal tax = entryInfo.getTax();
            BigDecimal totalTaxAmount = SysConstant.BIGZERO;
            if (tax != null) {
                totalTaxAmount = amount.add(tax);
            }
            entryInfo.setTaxAmount(totalTaxAmount);
        }
    }

    public void calEntryTax(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        boolean isInTax = purOrderInfo.isIsInTax();
        boolean isPriceInTax = purOrderInfo.isIsPriceInTax();
        BigDecimal taxAmount = new BigDecimal("0.00");
        BigDecimal taxRate = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal one = new BigDecimal("1.0");
            if (entryInfo.getTaxAmount() != null) {
                taxAmount = entryInfo.getTaxAmount();
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (!isPriceInTax) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(currencyPrecision, 4);
            }
            entryInfo.setTax(tax);
        } else {
            BigDecimal tax;
            BigDecimal amount = entryInfo.getAmount();
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if (entryInfo.getTaxRate() != null) {
                taxRate = entryInfo.getTaxRate();
            }
            if ((tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)currencyPrecision)) != null) {
                entryInfo.setTax(tax);
            } else {
                entryInfo.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public void calEntryAmount(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        boolean isInTax = purOrderInfo.isIsInTax();
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if (isInTax) {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal tax = entryInfo.getTax();
            entryInfo.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(currencyPrecision, 4);
                entryInfo.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entryInfo.getPrice();
            BigDecimal discount = entryInfo.getDiscountRate();
            BigDecimal qty = entryInfo.getQty();
            BigDecimal actualPrice = null;
            discount = discount == null ? this.zero : discount;
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (price != null && discount != null) {
                actualPrice = price.multiply(one.subtract(discount.divide(oneHundred, 10, 4)));
            }
            BigDecimal amount = CalculateUtils.calAmount((BigDecimal)qty, actualPrice, (int)currencyPrecision);
            entryInfo.setAmount(amount);
        }
    }

    public void calEntryActualPrice(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal qty = entryInfo.getQty();
        entryInfo.setActualPrice(SysConstant.BIGZERO);
        if (amount != null && qty != null && qty.compareTo(this.zero) > 0) {
            BigDecimal actualTaxPrice = amount.divide(qty, materialPricePrecision, 4);
            entryInfo.setActualPrice(actualTaxPrice);
        }
    }

    public void calEntryActualTaxPrice(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal actualTaxPrice = SysConstant.BIGZERO;
        if (taxAmount != null && qty != null && qty.compareTo(this.zero) > 0) {
            actualTaxPrice = taxAmount.divide(qty, materialPricePrecision, 4);
        }
        entryInfo.setActualTaxPrice(actualTaxPrice);
    }

    public void calEntryDiscountAmount(PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) {
        BigDecimal discount = entryInfo.getDiscountRate();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        taxPrice = taxPrice == null ? this.zero : taxPrice;
        BigDecimal hundred = new BigDecimal("100");
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        if (qty == null) {
            entryInfo.setDiscountAmount(null);
            return;
        }
        if (entryInfo.getDiscountRate() != null && entryInfo.getDiscountRate().compareTo(this.zero) > 0 && taxPrice.compareTo(this.zero) > 0) {
            BigDecimal discountAmount = CalculateUtils.calDiscountAmountByPercent((BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (int)currencyPrecision);
            entryInfo.setDiscountAmount(discountAmount);
            if (entryInfo.getDiscountRate().compareTo(new BigDecimal("100.00")) > 0) {
                entryInfo.setDiscountRate(new BigDecimal("100.00"));
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(currencyPrecision, RoundingMode.HALF_UP));
            }
        } else if (entryInfo.getDiscountAmount() != null && entryInfo.getDiscountAmount().compareTo(this.zero) > 0 && taxPrice.compareTo(this.zero) > 0) {
            BigDecimal discountRate = entryInfo.getDiscountAmount().divide(entryInfo.getQty().multiply(taxPrice), this.discountRatePrePrecision, 4).multiply(hundred);
            entryInfo.setDiscountRate(discountRate);
            if (discountRate.compareTo(new BigDecimal("100.00")) > 0) {
                entryInfo.setDiscountRate(new BigDecimal("100.00"));
                entryInfo.setDiscountAmount(entryInfo.getQty().multiply(taxPrice).setScale(currencyPrecision, RoundingMode.HALF_UP));
            }
        }
    }

    private EntityViewInfo getFilterForAdmin(String number, Set orgIdSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.app.PurOrderQueryImport";
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = null;
        try {
            result = new Hashtable();
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FBizType_Number", rs.getString("bizType.number"));
            this.putTable(result, "FSupplier_Number", rs.getString("supplier.number"));
            this.putTable(result, "FSupplier_Name", rs.getString("supplier.name"));
            this.putTable(result, "FIsInTax", this.getBooleanText(ctx, rs.getBoolean("isInTax")));
            this.putTable(result, "FIsPriceInTax", this.getBooleanText(ctx, rs.getBoolean("isPriceInTax")));
            this.putTable(result, "FIsQuicken", this.getBooleanText(ctx, rs.getBoolean("isQuicken")));
            this.putTable(result, "FPurchaseOrgUnit_Number", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FPurchaseOrgUnit_Name", rs.getString("purchaseOrgUnit.name"));
            this.putTable(result, "FPurchaseGroup_Number", rs.getString("purchaseGroup.number"));
            this.putTable(result, "FPurchasePerson_Number", rs.getString("purchasePerson.number"));
            this.putTable(result, "FCurrency_Number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FSupplierOrderNumber", rs.getString("supplierOrderNumber"));
            this.putTable(result, "FPaymentType_Number", rs.getString("paymentType.number"));
            this.putTable(result, "FAdminOrgUnit_Number", rs.getString("adminOrgUnit1.number"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FPaymentCondition_Number", rs.getString("paymentCondition.number"));
            this.putTable(result, "FSettlementType_Number", rs.getString("settlementType.number"));
            this.putTable(result, "FCashDiscount", rs.getString("cashDiscount.number"));
            this.putTable(result, "FPrepaymentRate", rs.getBigDecimal("prepaymentRate"));
            this.putTable(result, "FPrepayment", rs.getString("prepayment"));
            this.putTable(result, "FSeq", rs.getString("entries.seq"));
            this.putTable(result, "FRowType_Number", rs.getString("rowType.number"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterialName", rs.getString("material.name"));
            this.putTable(result, "FModel", rs.getString("material.model"));
            this.putTable(result, "FAssistProperty_Number", rs.getString("assistProperty.number"));
            this.putTable(result, "FIsPresent", this.getBooleanText(ctx, rs.getBoolean("entries.isPresent")));
            this.putTable(result, "FUnit_Number", rs.getString("unit.number"));
            this.putTable(result, "FAssisUnit_Number", rs.getString("assistUnit.number"));
            this.putTable(result, "FQty", rs.getString("entries.qty"));
            this.putTable(result, "FAssistQty", rs.getString("entries.assistQty"));
            this.putTable(result, "FRequestOrgUnit_Number", rs.getString("requestStorageOrgUnit.number"));
            this.putTable(result, "FStorageOrgUnit_Number", rs.getString("receivedStorageOrgUnit.number"));
            this.putTable(result, "FAdminOrgUnitNumber_Entry", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FDeliveryAddress", rs.getString("entries.deliveryAddress"));
            this.putTable(result, "FDeliveryDate", rs.getString("entries.deliveryDate"));
            this.putTable(result, "FPrice", rs.getString("entries.price"));
            this.putTable(result, "FDiscountRate", rs.getBigDecimal("entries.discountRate"));
            this.putTable(result, "FTaxRate", rs.getBigDecimal("entries.taxRate"));
            this.putTable(result, "FTaxPrice", rs.getString("entries.taxPrice"));
            this.putTable(result, "FActualTaxPrice", rs.getString("entries.actualTaxPrice"));
            this.putTable(result, "FDiscountAmount", rs.getString("entries.discountAmount"));
            this.putTable(result, "FAmount", rs.getString("entries.amount"));
            this.putTable(result, "FLocalAmount", rs.getString("entries.localAmount"));
            this.putTable(result, "FTax", rs.getString("entries.tax"));
            this.putTable(result, "FTaxAmount", rs.getString("entries.taxAmount"));
            this.putTable(result, "FTotalExpense", rs.getString("entries.totalExpense"));
            this.putTable(result, "FLocalTax", rs.getString("entries.localTax"));
            this.putTable(result, "FLocalTaxAmount", rs.getString("entries.localTaxAmount"));
            this.putTable(result, "FProject", rs.getString("project.number"));
            this.putTable(result, "FTrackNumber", rs.getString("trackNumber.number"));
            this.putTable(result, "FPurContract_Number", rs.getString("purContract.number"));
            this.putTable(result, "FIsQuantityUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.quantityUnCtrl")));
            this.putTable(result, "FIsTimeUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.timeUnCtrl")));
            this.putTable(result, "FDeliverAdvanceDay", rs.getString("entries.deliverAdvanceDay"));
            this.putTable(result, "FDeliverDeferralDay", rs.getString("entries.deliverDeferralDay"));
            this.putTable(result, "FReceiveOverRate", rs.getBigDecimal("entries.receiveOverRate"));
            this.putTable(result, "FReceiveOwingRate", rs.getBigDecimal("entries.receiveOwingRate"));
            this.putTable(result, "FWareHouse_Number", rs.getString("wareHouse.number"));
            this.putTable(result, "FRemark", rs.getString("entries.remark"));
            this.putTable(result, "FCreator_Number", rs.getString("creator.number"));
            this.putTable(result, "FCreatTime", rs.getString("createTime"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getMessage(Context ctx, String key) {
        return PurUtil.getServerResource(RESOURCE, key, ctx);
    }

    private String getMessage(Context ctx, String key, String[] params) {
        return PurUtil.getServerResource(RESOURCE, key, params, ctx);
    }

    private void fail(Context ctx, String key) throws TaskExternalException {
        throw new TaskExternalException(this.getMessage(ctx, key));
    }

    private void fail(Context ctx, String key, String[] params) throws TaskExternalException {
        throw new TaskExternalException(this.getMessage(ctx, key, params));
    }

    private void checkRateValid(Context ctx, BigDecimal val, String key) throws TaskExternalException {
        if (val.compareTo(BigDecimal.ZERO) < 0 || val.compareTo(hundred) > 0) {
            this.fail(ctx, "invalidRateData", new String[]{this.getMessage(ctx, key)});
        }
    }

    private BigDecimal getUnPercentedRate(String str) {
        BigDecimal val = new BigDecimal(str);
        return val.divide(hundred, 2, 4);
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isIntPurParam(String key, int defaultValue, int trueValue, Map<String, String> paramMap) {
        String strPurParam = paramMap.get(key);
        if (strPurParam != null && strPurParam.trim().length() != 0) {
            int value = Integer.parseInt(strPurParam);
            return value == trueValue;
        }
        return defaultValue == trueValue;
    }

    public ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterItmesStr = (String)this.getContextMap().get("filterItems");
        if (filterItmesStr != null) {
            FilterInfo filterInfo = null;
            SqlExpr sqlExpr = null;
            try {
                if (filterItmesStr.contains("{\"subject\"")) {
                    String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                    filterInfo = new FilterInfo(filterItems);
                } else {
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                return filterInfo;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (cuInfo == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1 or #2");
            Object parameter = this.getContextParameter("entries.id");
            if (parameter == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", parameter, CompareType.INCLUDE));
            return filterInfo;
        }
        return null;
    }

    private EntityViewInfo getbizTypeFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select FBizTypeID from T_SCM_BillBizType where FBillTypeID ='510b6503-0105-1000-e000-010bc0a812fd463ED552'", CompareType.INNER));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void loadMaterialOtherInfo(Context ctx, PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) throws BOSException, TaskExternalException {
        CompanyOrgUnitInfo cou = purOrderInfo.getCompanyOrgUnit();
        PurchaseOrgUnitInfo sou = purOrderInfo.getPurchaseOrgUnit();
        if (sou == null || cou == null) {
            return;
        }
        String mID = entryInfo.getMaterial().getId().toString();
        String compayID = cou.getId().toString();
        String ckey = mID + compayID;
        if (this.dataPool.getMaterialCompanyInfoInfo(ckey) == null) {
            Map cmap = InvServerUtils.getMatCompanyInfoCollection((Context)ctx, (String[])new String[]{mID}, (String[])new String[]{compayID});
            if (cmap != null && cmap.size() > 0) {
                MaterialCompanyInfoInfo cInfo = (MaterialCompanyInfoInfo)cmap.get(ckey);
                this.dataPool.setMaterialCompanyInfoInfo(ckey, cInfo);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_COMPANY_NOT_NULL", (Context)ctx));
            }
        }
        String invID = sou.getId().toString();
        String invKey = mID + invID;
        if (this.dataPool.getMaterialPurchaseInfoMap(invKey) == null) {
            Map purMap = PurUtil.getMatPurchasingInfoCollection(ctx, new String[]{mID}, new String[]{invID});
            if (purMap != null && purMap.size() > 0) {
                MaterialPurchasingInfo invInfo = (MaterialPurchasingInfo)purMap.get(invKey);
                this.dataPool.setMaterialPurchaseInfoMap(invKey, invInfo);
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"MATERIAL_STORAGE_NOT_NULL", (Context)ctx));
            }
        }
    }

    private void calEntryNew(Context ctx, PurOrderInfo purOrderInfo, PurOrderEntryInfo entryInfo) throws TaskExternalException {
        String importOption = this.getSMSDBillConfig(ctx, "com.kingdee.eas.scm.sm.pur.client.PurOrderListUI", "importOption");
        if (importOption == null || "0".equals(importOption)) {
            this.calEntry(purOrderInfo, entryInfo);
            return;
        }
        int pricePrecision = entryInfo.getMaterial().getPricePrecision();
        boolean isInTax = purOrderInfo.isIsInTax();
        boolean isPriceInTax = purOrderInfo.isIsPriceInTax();
        BigDecimal exchangeRate = purOrderInfo.getExchangeRate();
        int currencyPrecision = 2;
        if (purOrderInfo.getCurrency() != null) {
            currencyPrecision = purOrderInfo.getCurrency().getPrecision();
        }
        int baseCurrencyPrecision = 2;
        CurrencyInfo baseCurrency = this.basecurrencyMap.get(purOrderInfo.getPurchaseOrgUnit().getId().toString());
        if (baseCurrency != null) {
            baseCurrencyPrecision = baseCurrency.getPrecision();
        }
        if ("1".equals(importOption) && (!isPriceInTax || isInTax)) {
            this.importHandlingHelper.calEntryByTaxPrice((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, this.exchangeRateInfo, isPriceInTax);
        } else if ("1".equals(importOption) && !isInTax) {
            this.importHandlingHelper.calEntryByPrice((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, this.exchangeRateInfo, isPriceInTax);
        } else if ("2".equals(importOption) && (!isPriceInTax || isInTax)) {
            this.importHandlingHelper.calEntryByTaxAmount((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, this.exchangeRateInfo, isPriceInTax);
        } else if ("2".equals(importOption) && !isInTax) {
            this.importHandlingHelper.calEntryByAmount((SCMBillEntryBaseInfo)entryInfo, isInTax, currencyPrecision, baseCurrencyPrecision, pricePrecision, exchangeRate, this.exchangeRateInfo, isPriceInTax);
        }
        BigDecimal totalTax = purOrderInfo.getTotalTax();
        BigDecimal totalAmount = purOrderInfo.getTotalAmount();
        BigDecimal prepayment = purOrderInfo.getPrepayment();
        totalTax = totalTax.add(entryInfo.getTax());
        totalAmount = totalAmount.add(entryInfo.getAmount());
        this.totalTaxAmt = totalAmount.add(totalTax);
        entryInfo.setPrepayment(entryInfo.getTaxAmount().multiply(purOrderInfo.getPrepaymentRate().divide(new BigDecimal("100"))).setScale(currencyPrecision, 4));
        prepayment = prepayment.add(entryInfo.getPrepayment());
        purOrderInfo.setTotalAmount(totalAmount);
        purOrderInfo.setTotalTax(totalTax);
        purOrderInfo.setPrepayment(prepayment);
        purOrderInfo.setTotalTaxAmount(this.totalTaxAmt);
        purOrderInfo.setLocalTotalAmount(purOrderInfo.getLocalTotalAmount().add(entryInfo.getLocalAmount()));
        purOrderInfo.setLocalTotalTaxAmount(purOrderInfo.getLocalTotalTaxAmount().add(entryInfo.getLocalTaxAmount()));
    }
}

