/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import java.math.BigDecimal;

public final class PurOrderUtils {
    public static final int WRITEBACK_HANDLETYPE_ADD = 1;
    public static final int WRITEBACK_HANDLETYPE_SUBTRACT = 2;
    public static final int WRITEBACK_WRITETYPE_AUDIT = 1;
    public static final int WRITEBACK_WRITETYPE_ALERT = 2;
    public static final int WRITEBACK_WRITETYPE_HANDLECLOSE = 3;

    private PurOrderUtils() {
    }

    public static PurRequestEntryInfo handleWritebackInfo(Context ctx, PurRequestEntryInfo purReqEntryInfo, PurOrderEntryInfo purOrderEInfo, int writebackType, int handleType) throws EASBizException, BOSException {
        BigDecimal zero = new BigDecimal("0.0");
        BigDecimal totalOrderedQty = purReqEntryInfo.getOrderedQty();
        totalOrderedQty = totalOrderedQty == null ? zero : totalOrderedQty;
        BigDecimal writebackQty = null;
        MeasureUnitInfo sourceUnitInfo = purOrderEInfo.getUnit();
        MeasureUnitInfo destUnitInfo = purReqEntryInfo.getUnit();
        switch (writebackType) {
            case 1: 
            case 2: {
                writebackQty = purOrderEInfo.getQty();
                break;
            }
            case 3: {
                if (handleType == 1) {
                    writebackQty = purOrderEInfo.getTotalReceiptQty();
                    break;
                }
                if (handleType != 2) break;
                writebackQty = purOrderEInfo.getQty();
            }
        }
        BigDecimal bigDecimal = writebackQty = writebackQty == null ? zero : writebackQty;
        if (!sourceUnitInfo.getId().toString().equalsIgnoreCase(destUnitInfo.getId().toString())) {
            writebackQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)purOrderEInfo.getMaterial().getId().toString(), (MeasureUnitInfo)sourceUnitInfo, (MeasureUnitInfo)destUnitInfo, (BigDecimal)writebackQty);
        }
        switch (handleType) {
            case 1: {
                totalOrderedQty = totalOrderedQty.add(writebackQty);
                break;
            }
            case 2: {
                totalOrderedQty = totalOrderedQty.subtract(writebackQty);
            }
        }
        purReqEntryInfo.setOrderedQty(totalOrderedQty);
        return purReqEntryInfo;
    }

    public static boolean isPurSyn(Context ctx) throws BOSException, EASBizException {
        boolean isPurParam = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String strPurParam = ipc.getParamValue(null, "ESC_IS_PURCHASE_COOPERATION");
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public static boolean isSupplierPurSyn(Context ctx, String supplierID, String purchaseOrgUnitID) throws BOSException, EASBizException {
        boolean isPurParam = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (supplierID != null && purchaseOrgUnitID != null) {
            SupplierPurchaseInfoInfo supplierPurchasingInfo;
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgUnitID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierID, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            SupplierPurchaseInfoCollection supplierPurchasingColl = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).getSupplierPurchaseInfoCollection(viewInfo);
            if (supplierPurchasingColl != null && supplierPurchasingColl.size() > 0 && (supplierPurchasingInfo = supplierPurchasingColl.get(0)) != null) {
                isPurParam = supplierPurchasingInfo.isIsPurColl();
            }
        }
        return isPurParam;
    }
}

