/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowBizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.EditCtrlStrategyEnum;
import com.kingdee.eas.basedata.scm.sm.srm.FetchPriceRuleCollection;
import com.kingdee.eas.basedata.scm.sm.srm.FetchPriceRuleInfo;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyCollection;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyFactory;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.BizCollUtil;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurOrderWebFacadeControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurOrderWebFacadeControllerBean
extends AbstractPurOrderWebFacadeControllerBean {
    private static final long serialVersionUID = -7674954414883202668L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurOrderWebFacadeControllerBean");

    @Override
    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)oprtState) || StringUtils.isEmpty((String)id)) {
            return null;
        }
        if (OprtStateConstant.EDIT.equalsIgnoreCase(oprtState)) {
            PurOrderInfo info = this.getBillInfoById(ctx, id);
            this.cachePrecision(ctx, map, info);
            HashMap paramMap = this.batchGetParamValue(ctx, info.getPurchaseOrgUnit().getId().toString(), info);
            map.put("paramMap", paramMap);
        } else if (OprtStateConstant.VIEW.equalsIgnoreCase(oprtState)) {
            ExchangeRateInfo tempexrateinfo;
            PurOrderInfo info = this.getBillInfoById(ctx, id);
            this.cachePrecision(ctx, map, info);
            CompanyOrgUnitInfo company = this.getCompanyByPurchaseOrgUnit(ctx, (OrgUnitInfo)info.getPurchaseOrgUnit());
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
            map.put("baseCurrency", currencyInfo);
            if (null != info.getCurrency() && (tempexrateinfo = this.getExchange(company.getId().toString(), info.getCurrency().getId().toString(), currencyInfo.getId().toString())) != null) {
                map.put("exchangerateprecision", tempexrateinfo.getExchangeAux().getPrecision());
            }
        }
        return map;
    }

    private void cachePrecision(Context ctx, Map<String, Object> cacheData, PurOrderInfo info) throws BOSException, EASBizException {
        String discountRatePrecision;
        if (info == null) {
            return;
        }
        PurOrderEntryCollection entryCol = info.getEntries();
        PurOrderEntryInfo entryInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        HashMap<String, Object> precisionMap = new HashMap<String, Object>();
        HashMap<String, Object> mmuConvsRate = new HashMap<String, Object>();
        if (info.getCompanyOrgUnit() != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()), sic);
            precisionMap.put(companyOrgUnitInfo.getBaseCurrency().getId().toString(), companyOrgUnitInfo.getBaseCurrency().getPrecision());
            info.setCompanyOrgUnit(companyOrgUnitInfo);
        }
        if (info.getCurrency() != null) {
            precisionMap.put(info.getCurrency().getId().toString(), info.getCurrency().getPrecision());
        }
        if (entryCol != null && entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                if (entryInfo.getMaterial() != null) {
                    materialSet.add(entryInfo.getMaterial().getId().toString());
                    precisionMap.put(entryInfo.getMaterial().getId().toString(), entryInfo.getMaterial().getPricePrecision());
                }
                if (entryInfo.getUnit() != null) {
                    unitSet.add(entryInfo.getUnit().getId().toString());
                }
                if (entryInfo.getBaseUnit() != null) {
                    unitSet.add(entryInfo.getBaseUnit().getId().toString());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                unitSet.add(entryInfo.getAssistUnit().getId().toString());
            }
        }
        if (materialSet.size() > 0 && unitSet.size() > 0) {
            this.setMeasureUnitPrecision(ctx, materialSet, unitSet, precisionMap, mmuConvsRate);
        }
        if (entryCol != null && entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                if (entryInfo.getMaterial() != null) continue;
                if (entryInfo.getUnit() != null) {
                    precisionMap.put(entryInfo.getUnit().getId().toString(), entryInfo.getUnit().getQtyPrecision());
                }
                if (entryInfo.getBaseUnit() != null) {
                    precisionMap.put(entryInfo.getBaseUnit().getId().toString(), entryInfo.getBaseUnit().getQtyPrecision());
                }
                if (entryInfo.getRowType() == null || entryInfo.getRowType().isIsHasMaterialNumber()) continue;
                precisionMap.put("noMaterial" + entryInfo.getRowType().getId().toString(), entryInfo.getRowType().getPrecision());
            }
        }
        if (null != (discountRatePrecision = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(info.getPurchaseOrgUnit().getId()), "DISCOUNTRATEPRECISION"))) {
            precisionMap.put("DISCOUNTRATEPRECISION", Integer.valueOf(discountRatePrecision));
        }
        cacheData.put("precisionMap", precisionMap);
        cacheData.put("mmuConvsRate", mmuConvsRate);
    }

    private void setMeasureUnitPrecision(Context ctx, Set materialSet, Set unitSet, Map<String, Object> precisionMap, Map<String, Object> mmuConvsRate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.pricePrecision"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        MultiMeasureUnitInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                precisionMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getQtyPrecision());
                precisionMap.put(info.getMaterial().getId().toString(), info.getMaterial().getPricePrecision());
                mmuConvsRate.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getBaseConvsRate());
            }
        }
    }

    private CompanyOrgUnitInfo getCompanyByPurchaseOrgUnit(Context ctx, OrgUnitInfo purInfo) throws BOSException {
        if (purInfo != null) {
            OrgUnitCollection orgUnitCollection = null;
            CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
            try {
                IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                orgUnitCollection = iOrgUnitRelation.getToUnit(purInfo.getId().toString(), 3, 1);
                if (orgUnitCollection.size() > 0) {
                    company = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            return company;
        }
        return null;
    }

    private PurOrderInfo getBillInfoById(Context ctx, String billID) throws EASBizException, BOSException {
        return PurOrderFactory.getLocalInstance(ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelctorItemCollection());
    }

    private SelectorItemCollection getSelctorItemCollection() {
        SelectorItemCollection sic = SCMSelectorFactory.getPurOrderSelector((boolean)true);
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("entries.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("entries.rowType.destinationType"));
        sic.add(new SelectorItemInfo("entries.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("entries.rowType.precision"));
        sic.add(new SelectorItemInfo("entries.rowType.id"));
        sic.add(new SelectorItemInfo("entries.rowType.number"));
        sic.add(new SelectorItemInfo("entries.rowType.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.requestCompanyOrgUnit.number"));
        return sic;
    }

    private String getPurOrgFilter(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Purchase, null, "purorder_addnew");
        OrgUnitCollection purOrgColl = new OrgUnitCollection();
        for (int i = 0; i < fullCompanyColl.size(); ++i) {
            purOrgColl.add((OrgUnitInfo)fullCompanyColl.get(i));
        }
        return this.getOrgFilterStr(ctx, (AbstractObjectCollection)purOrgColl);
    }

    private String getOrgFilterStr(Context ctx, AbstractObjectCollection orgCollection) throws BOSException, EASBizException {
        if (orgCollection == null || orgCollection.size() == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < orgCollection.size(); ++i) {
            sb.append("'").append(orgCollection.getObject(i).get("id").toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    private OrgUnitCollection getOrgUnitColl(Context ctx, String orgId, OrgType formOrgType, OrgType toOrgType) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitCollection = null;
        orgUnitCollection = formOrgType.equals((Object)OrgType.Admin) && toOrgType.equals((Object)OrgType.Purchase) ? iOrgUnitRelation.getFromUnit(orgId, toOrgType.getValue(), formOrgType.getValue()) : (toOrgType.equals((Object)OrgType.Storage) ? iOrgUnitRelation.getFromUnit(orgId, formOrgType.getValue(), toOrgType.getValue()) : iOrgUnitRelation.getToUnit(orgId, formOrgType.getValue(), toOrgType.getValue()));
        if (orgUnitCollection != null && orgUnitCollection.size() > 0 && (toOrgType.equals((Object)OrgType.Storage) || toOrgType.equals((Object)OrgType.Admin))) {
            OrgUnitCollection orgColl = new OrgUnitCollection();
            OrgUnitInfo orgUnitInfo = null;
            StorageOrgUnitInfo storageOrgInfo = null;
            AdminOrgUnitInfo adminOrgInfo = null;
            int size = orgUnitCollection.size();
            for (int i = 0; i < size; ++i) {
                orgUnitInfo = orgUnitCollection.get(i);
                if (toOrgType.equals((Object)OrgType.Storage) && orgUnitInfo.isIsStorageOrgUnit()) {
                    storageOrgInfo = (StorageOrgUnitInfo)orgUnitInfo;
                    if (storageOrgInfo.isIsSealUp()) continue;
                    orgColl.add(orgUnitInfo);
                    continue;
                }
                if (!toOrgType.equals((Object)OrgType.Admin) || !orgUnitInfo.isIsAdminOrgUnit() || (adminOrgInfo = (AdminOrgUnitInfo)orgUnitInfo).isIsSealUp()) continue;
                orgColl.add(orgUnitInfo);
            }
            return orgColl;
        }
        return orgUnitCollection;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("precision"));
        currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        return currencyInfo;
    }

    @Override
    protected Map _requsetOrgChanged(Context ctx, String orgId) throws BOSException, EASBizException {
        int i;
        CompanyOrgUnitInfo couInfo;
        int i2;
        HashMap<String, Object> map = new HashMap<String, Object>();
        OrgUnitCollection orgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Company);
        CompanyOrgUnitInfo cou = null;
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            cou = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        if (cou != null) {
            CurrencyInfo currencyInfo = cou.getBaseCurrency();
            if (currencyInfo != null && StringUtils.isEmpty((String)currencyInfo.getNumber())) {
                currencyInfo = this.getCurrencyInfo(ctx, currencyInfo.getId().toString());
            }
            cou.setBaseCurrency(currencyInfo);
        }
        map.put("companyOrgUnit", cou);
        OrgUnitCollection adminOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Admin, OrgType.Purchase);
        map.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)adminOrgUnitCollection));
        map.put("headAdminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)adminOrgUnitCollection));
        OrgUnitCollection storageOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Storage);
        map.put("storageOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)storageOrgUnitCollection));
        StorageOrgUnitInfo orgInfo = null;
        StorageOrgUnitInfo currentOrgInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        for (i2 = 0; i2 < storageOrgUnitCollection.size(); ++i2) {
            if (!orgId.equals(storageOrgUnitCollection.get(i2).getId().toString())) continue;
            orgInfo = (StorageOrgUnitInfo)storageOrgUnitCollection.get(i2);
            if (!orgInfo.isIsSealUp()) break;
            orgInfo = null;
            break;
        }
        if (orgInfo == null) {
            for (i2 = 0; i2 < storageOrgUnitCollection.size(); ++i2) {
                if (!currentOrgInfo.getId().toString().equals(storageOrgUnitCollection.get(i2).getId().toString())) continue;
                orgInfo = (StorageOrgUnitInfo)storageOrgUnitCollection.get(i2);
                if (!orgInfo.isIsSealUp()) break;
                orgInfo = null;
                break;
            }
        }
        if (orgInfo == null) {
            OrgUtils.getSortData((OrgUnitCollection)storageOrgUnitCollection);
            for (i2 = 0; i2 < storageOrgUnitCollection.size() && (orgInfo = (StorageOrgUnitInfo)storageOrgUnitCollection.get(i2)).isIsSealUp(); ++i2) {
            }
        }
        map.put("storageOrgInfo", orgInfo);
        if (orgInfo != null && (couInfo = this.getEntryCompanyOrgUnit(ctx, orgInfo.getId().toString())) != null) {
            map.put("e_companyOrgUnit", couInfo);
            if (cou != null && !cou.getId().toString().equals(couInfo.getId().toString())) {
                map.put("isBetweenCompanyRec", true);
            } else {
                map.put("isBetweenCompanyRec", false);
            }
        }
        map.put("paramMap", this.batchGetParamValue(ctx, orgId, null));
        AdminOrgUnitInfo adminorgInfo = null;
        for (i = 0; i < adminOrgUnitCollection.size(); ++i) {
            if (!orgId.equals(adminOrgUnitCollection.get(i).getId().toString())) continue;
            adminorgInfo = (AdminOrgUnitInfo)adminOrgUnitCollection.get(i);
            if (!adminorgInfo.isIsSealUp()) break;
            adminorgInfo = null;
            break;
        }
        if (adminorgInfo == null) {
            for (i = 0; i < adminOrgUnitCollection.size(); ++i) {
                if (!currentOrgInfo.getId().toString().equals(adminOrgUnitCollection.get(i).getId().toString())) continue;
                adminorgInfo = (AdminOrgUnitInfo)adminOrgUnitCollection.get(i);
                if (!adminorgInfo.isIsSealUp()) break;
                adminorgInfo = null;
                break;
            }
        }
        if (orgInfo == null) {
            OrgUtils.getSortData((OrgUnitCollection)adminOrgUnitCollection);
            for (i = 0; i < adminOrgUnitCollection.size() && (adminorgInfo = (AdminOrgUnitInfo)adminOrgUnitCollection.get(i)).isIsSealUp(); ++i) {
            }
        }
        map.put("adminOrgUnit", adminorgInfo);
        return map;
    }

    private RuleStatus getCodeRuleStatus(Context ctx, IObjectValue model, String mainOrgId) throws BOSException, EASBizException {
        if (model != null && !StringUtils.isEmpty((String)mainOrgId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = codingRuleManager.getRuleStatus(model, mainOrgId);
            return ruleStatus;
        }
        return null;
    }

    @Override
    protected Map _getSupplierByApproved(Context ctx, String materialStr, String purOrgId) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        IRowSet rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid as FSupplierID,t1.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" as FSupplierName,t1.fnumber as FSupplierNumber,t2.fnumber as FMaterialNumber,t2.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" as FMaterialName,t.FLeadtime,t.FQtyOrderTop,t.FQtyOrderBottom,t.FMinPackingQty,t.FTaxRate,t4.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" as FQuotaPolicyName from T_SM_ApprovedSupplier t ");
        sql.append(" inner join T_BD_Supplier t1 on t1.fid=t.FSupplierID ");
        sql.append(" inner join T_BD_Material t2 on t2.fid=t.FMaterialItemID");
        sql.append(" LEFT OUTER JOIN T_BD_MaterialPurchasing AS t3 ON t.FMaterialItemID = t3.FMaterialID AND t.FPurchaseOrgID = t3.FOrgUnit");
        sql.append(" LEFT OUTER JOIN T_bd_QuotaPolicy AS t4 ON t3.FQuotaPolicyId = t4.FID");
        sql.append(" where t.FPurchaseOrgID = '" + purOrgId + "' ");
        sql.append(" and t.FMaterialItemID in (" + materialStr + ")");
        sql.append(" and t.FIsUseable = 1 and t.FMaterialAttr = 0");
        try {
            ArrayList list = new ArrayList();
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                HashMap<String, String> tempMap = new HashMap<String, String>();
                tempMap.put("supplierId", rowSet.getString("FSupplierID"));
                tempMap.put("supplierName", rowSet.getString("FSupplierName"));
                tempMap.put("supplierNumber", rowSet.getString("FSupplierNumber"));
                tempMap.put("materialNumber", rowSet.getString("FMaterialNumber"));
                tempMap.put("materialName", rowSet.getString("FMaterialName"));
                tempMap.put("purLeadTime", rowSet.getString("FLeadtime"));
                tempMap.put("qtyOrderTop", rowSet.getString("FQtyOrderTop"));
                tempMap.put("qtyOrderBottom", rowSet.getString("FQtyOrderBottom"));
                tempMap.put("minPackingQty", rowSet.getString("FMinPackingQty"));
                tempMap.put("taxRate", rowSet.getString("FTaxRate"));
                tempMap.put("quotaPolicy", rowSet.getString("FQuotaPolicyName"));
                list.add(tempMap);
            }
            map.put("data", list);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowSet);
        return map;
    }

    @Override
    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PurOrderInfo purOrderInfo = (PurOrderInfo)info;
        com.kingdee.eas.scm.util.SCMUtil.checkSupplierEnable((Context)ctx, (IObjectValue)info);
        PurOrderEntryCollection orderEntryCollection = purOrderInfo.getEntries();
        HashSet<String> rowTypeIdSet = new HashSet<String>();
        for (int i = 0; i < orderEntryCollection.size(); ++i) {
            if (orderEntryCollection.get(i).getRowType() == null) continue;
            rowTypeIdSet.add(orderEntryCollection.get(i).getRowType().getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("requestOrgType"));
        sic.add(new SelectorItemInfo("precision"));
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", rowTypeIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        RowTypeCollection rowTypeCollection = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeCollection(view);
        HashMap<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
        for (int i = 0; i < rowTypeCollection.size(); ++i) {
            rowTypeMap.put(rowTypeCollection.get(i).getId().toString(), rowTypeCollection.get(i));
        }
        String rowTypeId = null;
        for (int i = 0; i < orderEntryCollection.size(); ++i) {
            if (orderEntryCollection.get(i).getRowType() == null || !rowTypeMap.containsKey(rowTypeId = orderEntryCollection.get(i).getRowType().getId().toString())) continue;
            orderEntryCollection.get(i).setRowType((RowTypeInfo)rowTypeMap.get(rowTypeId));
        }
        this.cachePrecision(ctx, map, purOrderInfo);
        map.put("paramMap", this.batchGetParamValue(ctx, purOrderInfo.getPurchaseOrgUnit().getId().toString(), purOrderInfo));
        return map;
    }

    @Override
    protected Map _getApprovedSupplierColl(Context ctx, String materialStr, String purOrgId, String supplierId) throws BOSException, EASBizException {
        String[] materialArr = materialStr.split(",");
        HashSet<String> materialIdSet = new HashSet<String>();
        HashMap<String, ApprovedSupplierInfo> matAppSupMap = new HashMap<String, ApprovedSupplierInfo>();
        for (int i = 0; i < materialArr.length; ++i) {
            materialIdSet.add(materialArr[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("materialItem.id", materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purOrgId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialAttr", (Object)Integer.valueOf("0"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)Integer.valueOf("1"), CompareType.EQUALS));
        view.setFilter(filter);
        ApprovedSupplierCollection collection = ApprovedSupplierFactory.getLocalInstance((Context)ctx).getApprovedSupplierCollection(view);
        ApprovedSupplierInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = collection.get(i);
            matAppSupMap.put(info.getMaterialItem().getId().toString(), info);
        }
        return matAppSupMap;
    }

    @Override
    protected Map _createToReceival(Context ctx, Map idMap) throws BOSException, EASBizException {
        return this.createToBill(ctx, idMap, "15F2BD83");
    }

    @Override
    protected Map _createToPay(Context ctx, Map idMap) throws BOSException, EASBizException {
        return this.createToBill(ctx, idMap, "D001019A");
    }

    @Override
    protected Map _createToReturns(Context ctx, Map idMap) throws BOSException, EASBizException {
        return this.createToBill(ctx, idMap, "256D05E2");
    }

    private BOTMappingCollection getBTPMappingCollection(Context ctx, String id, String destBosTypeID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("cu.id"));
        PurOrderInfo info = PurOrderFactory.getLocalInstance(ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(id), selector);
        if (info != null && info.getCU() != null) {
            BOSObjectType sourceBosType = new BOSObjectType("3171BFAD");
            BOSObjectType destBosType = new BOSObjectType(destBosTypeID);
            String cuID = info.getCU().getId().toString();
            BOTMappingCollection botMappingCol = com.kingdee.eas.scm.util.SCMUtil.getBotpMappingCollection(null, (BOSObjectType)sourceBosType, (BOSObjectType)destBosType, (String)cuID);
            if (botMappingCol == null || botMappingCol.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            return botMappingCol;
        }
        return null;
    }

    private Map createToBill(Context ctx, Map idMap, String destBosTypeID) throws BOSException, EASBizException {
        String billId = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (idMap == null || idMap.size() == 0) {
            return null;
        }
        try {
            BOTMappingCollection botColl;
            Iterator iterator = idMap.keySet().iterator();
            if (iterator.hasNext()) {
                billId = iterator.next().toString();
            }
            if ((botColl = this.getBTPMappingCollection(ctx, billId, destBosTypeID)) == null || botColl.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            String[] idList = new String[idMap.size()];
            ArrayList<String> entryids = new ArrayList<String>();
            iterator = idMap.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                idList[i] = billId = iterator.next().toString();
                String entryId = idMap.get(billId).toString();
                String[] strIds = entryId.split(",");
                int count = strIds.length;
                for (int j = 0; j < count; ++j) {
                    entryids.add(strIds[j]);
                }
                ++i;
            }
            if (botColl.size() == 1) {
                BOTMappingInfo mappingInfo = botColl.get(0);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(idList, new String[]{"entries"}, entryids, null, mappingInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), mappingInfo.getSrcEntityName());
                IObjectCollection objColl = btpResult.getBills();
                StringBuilder billNumber = new StringBuilder();
                int size = objColl.size();
                for (int j = 0; j < size; ++j) {
                    billNumber.append(objColl.getObject(j).getString("number"));
                    if (j >= size - 1) continue;
                    if (ctx.getLocale() == LocaleUtils.locale_L2) {
                        billNumber.append("\u3001");
                        continue;
                    }
                    billNumber.append(",");
                }
                map.put("billNumber", billNumber.toString());
            } else {
                map.put("botMapColl", botColl);
                map.put("billIds", idList);
                map.put("entryIds", entryids);
            }
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
        }
        return map;
    }

    private CompanyOrgUnitInfo getEntryCompanyOrgUnit(Context ctx, String sid) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)sid)) {
            return null;
        }
        OrgUnitCollection orgUnitCollection = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(sid, 4, 1);
        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
            CompanyOrgUnitInfo cou = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
            return cou;
        }
        return null;
    }

    private String setBillStorageUnitF7(Context ctx, String couId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)couId)) {
            return null;
        }
        OrgUnitCollection orgColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(couId, 1, 4);
        if (orgColl == null || orgColl.size() == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        int size = orgColl.size();
        for (int i = 0; i < size; ++i) {
            idSet.add(orgColl.get(i).getId().toString());
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        OrgViewType ovt = NewOrgViewHelper.convert((OrgType)OrgType.Storage);
        IObjectPK userPK = ctx.getCaller();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)ovt));
        HashMap hm = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)userPK, (OrgViewType)ovt, (IObjectPK)treePK, null, null);
        if (hm.size() != 0) {
            fi.getFilterItems().add(new FilterItemInfo("id", hm.keySet(), CompareType.INCLUDE));
        }
        return fi.toSql();
    }

    private HashMap batchGetParamValue(Context ctx, String orgId, PurOrderInfo info) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        String[] numbers = new String[]{"PURORDER003", "PURSUP001", "PURSUP004", "PURJICHU001", "PURORDER006", "PURFIELD001", "DISCOUNTRATEPRECISION", "PURORDERALTER", "PURORDERALTER3", "REPURORDERALTER3", "PURORDER100", "PURORDER001"};
        HashMap paramMap = ParamManager.getParamHashMap((Context)ctx, (String[])numbers, (String)orgId);
        if (null != info && null != paramMap) {
            boolean botpBillAllowAddEntry = SCMUtil.getBotpBillAllowAddEntry((Context)ctx, (SCMBillBaseInfo)info, (OrgType)OrgType.Purchase, (BOSUuid)info.getPurchaseOrgUnit().getId());
            paramMap.put("botpBillAllowAddEntry", botpBillAllowAddEntry);
        }
        return paramMap;
    }

    @Override
    protected Map _createBill(Context ctx, String mainorgid, boolean isMultiOrg) throws EASBizException, BOSException {
        HashMap<String, PurOrderInfo> map = new HashMap<String, PurOrderInfo>();
        PurOrderInfo info = (PurOrderInfo)PurOrderFactory.getLocalInstance(ctx).createNewData(false);
        PurchaseOrgUnitInfo orgInfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainorgid));
        info.setPurchaseOrgUnit(orgInfo);
        if (orgInfo != null && orgInfo.getId() != null) {
            IOrgUnitRelation iour;
            OrgUnitCollection ioc;
            IParamControl paramControl;
            String param;
            OrgUnitCollection companyOrgUnitCollection = this.getOrgUnitColl(ctx, orgInfo.getId().toString(), OrgType.Purchase, OrgType.Company);
            if (companyOrgUnitCollection != null && companyOrgUnitCollection.size() > 0) {
                CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)companyOrgUnitCollection.get(0);
                info.setCompanyOrgUnit(companyOrgUnitInfo);
                CurrencyInfo currencyInfo = companyOrgUnitInfo.getBaseCurrency();
                if (currencyInfo != null) {
                    currencyInfo = this.getCurrencyInfo(ctx, currencyInfo.getId().toString());
                }
                companyOrgUnitInfo.setBaseCurrency(currencyInfo);
                info.setCurrency(currencyInfo);
                info.put("baseCurrency", currencyInfo);
                info.setExchangeRate(new BigDecimal("1.00"));
            }
            if (!"0".equals(param = (paramControl = ParamControlFactory.getLocalInstance((Context)ctx)).getParamValue((IObjectPK)new ObjectUuidPK(mainorgid), "PURORDER001")) && (ioc = (iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(orgInfo.getId().toString(), 3, 0)).size() >= 1) {
                info.setAdminOrgUnit((AdminOrgUnitInfo)ioc.get(0));
            }
            info.setCU(orgInfo.getCU());
        }
        UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        info.setCreator(userInfo);
        info.getEntries().clear();
        for (int i = 0; i < 5; ++i) {
            PurOrderEntryInfo entryInfo = info.getBizType() == null ? this.getDefaultEntryInfo(ctx, null, mainorgid, info.getCompanyOrgUnit().getId().toString()) : this.getDefaultEntryInfo(ctx, info.getBizType().getId().toString(), mainorgid, info.getCompanyOrgUnit().getId().toString());
            if (entryInfo.getRowType() != null) {
                RowTypeInfo rowType = entryInfo.getRowType();
                DestinationTypeEnum destinationType = rowType.getDestinationType();
                if (destinationType.getValue().equals("20")) {
                    entryInfo.setRequestOrgUnit(null);
                }
                if (destinationType.getValue().equals("10")) {
                    entryInfo.setAdminOrgUnit(null);
                }
            }
            info.getEntries().add(entryInfo);
            info.put("defaultEntryMap", entryInfo);
        }
        info.put("paramMap", this.batchGetParamValue(ctx, info.getPurchaseOrgUnit().getId().toString(), info));
        map.put("bill", info);
        return map;
    }

    public String getSaleOrgF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        OrgUnitCollection companyOrgUnitCollection = null;
        OrgUnitCollection saleOrgUnitCollection = null;
        String orgFilterStr = "";
        companyOrgUnitCollection = OrgUtils.getToOrgUnitColl((Context)ctx, (String)orgid, (OrgType)OrgType.Purchase, (OrgType)OrgType.Company);
        if (companyOrgUnitCollection.size() > 0) {
            saleOrgUnitCollection = OrgUtils.getFromOrgUnitColl((Context)ctx, (String)companyOrgUnitCollection.get(0).getId().toString(), (OrgType)OrgType.Company, (OrgType)OrgType.Sale);
            orgFilterStr = "id in " + OrgUtils.getOrgFilterStr((Context)ctx, (OrgUnitCollection)saleOrgUnitCollection);
        }
        return orgFilterStr;
    }

    public String getPurContractNumberF7Filer(Context ctx, String orgid) {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(4);
        set.add(7);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", set, CompareType.INCLUDE));
        return filterInfo.toString();
    }

    public Map<String, String> getUseAdminOrgUnitF7Filter(Context ctx, Map paramMap) throws EASBizException, BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        String filter = null;
        Object adminOrgUnit = paramMap.get("adminOrgUnitId");
        Object storageOrgUnit = paramMap.get("storageOrgUnitId");
        String adminOrgUnitID = adminOrgUnit == null ? null : adminOrgUnit.toString();
        String storageOrgUnitID = storageOrgUnit == null ? null : storageOrgUnit.toString();
        filter = PurOrderFactory.getLocalInstance(ctx).getUseAdminOrgUnitF7Filter(adminOrgUnitID, storageOrgUnitID);
        map.put("useAdminOrgUnitF7Filter", filter);
        return map;
    }

    public Boolean getPurPriceStrategy(Context ctx, String bizType, String orgId, Map map) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("ruleEntries.billType.id"));
        sic.add(new SelectorItemInfo("ruleEntries.bizType.id"));
        sic.add(new SelectorItemInfo("ruleEntries.editCtrlStrategy"));
        viewInfo.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)orgId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)1, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        PurPriceStrategyCollection purPriceCollection = null;
        purPriceCollection = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getPurPriceStrategyCollection(viewInfo);
        if (purPriceCollection != null) {
            map.put("havePurPriceStrategy", true);
            for (PurPriceStrategyInfo info : purPriceCollection) {
                FetchPriceRuleCollection priceInfoCol = info.getRuleEntries();
                for (FetchPriceRuleInfo ruleInfo : priceInfoCol) {
                    if (bizType == null || ruleInfo.getBizType().getId() == null || !ruleInfo.getBizType().getId().toString().equalsIgnoreCase(bizType) || !ruleInfo.getBillType().getId().toString().equalsIgnoreCase("510b6503-0105-1000-e000-010bc0a812fd463ED552") || !EditCtrlStrategyEnum.EDIT_FORBIDDEN.equals((Object)ruleInfo.getEditCtrlStrategy())) continue;
                    return true;
                }
            }
        } else {
            map.put("havePurPriceStrategy", false);
        }
        return false;
    }

    public String getDeliverAddF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = AddressFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        return filterInfo.toString();
    }

    public String gettrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    @Override
    protected Map _getF7FilterAndEdit(Context ctx, Map params) throws BOSException, EASBizException {
        String companyOrgid = (String)params.get("companyOrgid");
        String orgId = (String)params.get("purorgid");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String biztypeid = (String)params.get("bizTypeid");
        boolean isaddnew = Boolean.parseBoolean(params.get("isaddnew").toString());
        PurchaseOrgUnitInfo purOrgInfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        map.put("saleOrgF7Filter", this.getSaleOrgF7Filter(ctx, orgId));
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, orgId));
        map.put("trackNumberF7Filter", this.gettrackNumberF7Filter(ctx, orgId));
        map.put("purContractNumberF7Filter", this.getPurContractNumberF7Filer(ctx, purOrgInfo.getCU().getId().toString()));
        map.put("deliveryaddrF7Filter", this.getDeliverAddF7Filter(ctx, orgId));
        map.put("isPriceEdit", this.getPurPriceStrategy(ctx, biztypeid, orgId, map));
        map.put("bizTypeF7Filter", "billType.number = '220' and status=1");
        String paymentTypeF7Filter = "id ='2fa35444-5a23-43fb-99ee-6d4fa5f260da6BCA0AB5' or id = '40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5'";
        map.put("paymentTypeF7Filter", paymentTypeF7Filter);
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Purchase, null, "purorder_addnew");
        map.put("purOrgF7Filter", " isBizUnit = 1 and id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)fullCompanyColl));
        OrgUnitCollection adminOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Admin, OrgType.Purchase);
        map.put("adminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)adminOrgUnitCollection));
        map.put("headAdminOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)adminOrgUnitCollection));
        OrgUnitCollection requestOrgUnitCollection = this.getOrgUnitColl(ctx, orgId, OrgType.Purchase, OrgType.Storage);
        map.put("requestOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)requestOrgUnitCollection));
        map.put("paramMap", this.batchGetParamValue(ctx, orgId, null));
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (!StringUtils.isEmpty((String)companyOrgid)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("longNumber"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgid), sic);
            map.put("expenseTypeF7Filter", BizCollUtil.getExpenseTypeF7CommonFilter((CompanyOrgUnitInfo)companyOrgUnitInfo, (String)"PurOrder", (boolean)false).toString());
        }
        SettlementTypeInfo staticSettlementTypeInfo = this.getSettlementType(ctx);
        map.put("defaultStaticSettlementType", staticSettlementTypeInfo);
        if (isaddnew) {
            return map;
        }
        boolean isIsCentralBalance = false;
        if (params.get("isIsCentralBalance") != null) {
            isIsCentralBalance = Boolean.parseBoolean(params.get("isIsCentralBalance").toString());
        }
        if (companyOrgUnitInfo != null) {
            String currencyid;
            ExchangeRateInfo tempexrateinfo;
            CurrencyInfo currencyInfo = companyOrgUnitInfo.getBaseCurrency();
            map.put("baseCurrency", currencyInfo);
            if (isIsCentralBalance) {
                map.put("storageOrg_f7", this.setBillStorageUnitF7(ctx, companyOrgUnitInfo.getId().toString()));
            }
            if ((tempexrateinfo = this.getExchange(companyOrgid, currencyid = (String)params.get("currencyid"), currencyInfo.getId().toString())) != null) {
                map.put("convertmode", tempexrateinfo.getExchangeAux().getConvertMode());
                map.put("exchangerateprecision", tempexrateinfo.getExchangeAux().getPrecision());
            }
        }
        map.put("defaultEntryMap", this.getDefaultEntryInfo(ctx, biztypeid, orgId, companyOrgid));
        return map;
    }

    public SettlementTypeInfo getSettlementType(Context ctx) throws BOSException {
        SettlementTypeInfo staticSettlementTypeInfo = null;
        SettlementTypeInfo cashSettlementTypeInfo = null;
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("isDefault"));
        sic.add(new SelectorItemInfo("deletedStatus"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1));
        view.setSelector(sic);
        view.setFilter(filter);
        SettlementTypeCollection settlementTypeCollection = SettlementTypeFactory.getLocalInstance((Context)ctx).getSettlementTypeCollection(view);
        if (settlementTypeCollection.size() > 0) {
            SettlementTypeInfo settlementTypeInfo = null;
            for (int j = 0; j < settlementTypeCollection.size(); ++j) {
                settlementTypeInfo = settlementTypeCollection.get(j);
                if (settlementTypeInfo.isIsDefault()) {
                    staticSettlementTypeInfo = settlementTypeInfo;
                    break;
                }
                if (!"e09a62cd-00fd-1000-e000-0b32c0a8100dE96B2B8E".equals(settlementTypeInfo.getId().toString())) continue;
                cashSettlementTypeInfo = settlementTypeInfo;
            }
        }
        if (staticSettlementTypeInfo == null) {
            staticSettlementTypeInfo = cashSettlementTypeInfo;
        }
        return staticSettlementTypeInfo;
    }

    private PurOrderEntryInfo getDefaultEntryInfo(Context ctx, String biztypeid, String purordid, String companyOrgid) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou;
        PurOrderEntryInfo entryInfo = new PurOrderEntryInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (biztypeid != null) {
            filter.getFilterItems().add(new FilterItemInfo("bizType.id", (Object)biztypeid, CompareType.INCLUDE));
        }
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("rowType.number"));
        view.setSorter(sort);
        view.setSelector(sic);
        CoreBaseCollection rowBizTypeCollection = RowBizTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (rowBizTypeCollection != null && rowBizTypeCollection.size() > 0) {
            RowTypeInfo rowtype = ((RowBizTypeInfo)rowBizTypeCollection.get(0)).getRowType();
            entryInfo.setRowType(rowtype);
            entryInfo.setDestinationType(rowtype.getDestinationType());
        }
        Calendar cal = Calendar.getInstance();
        entryInfo.setDeliveryDate(cal.getTime());
        StorageOrgUnitInfo storageOrgInfo = null;
        AdminOrgUnitInfo adminOrgUnit = null;
        OrgUnitCollection requestOrgUnitCollection = null;
        OrgUnitCollection adminOrgUnitCollection = null;
        if (purordid != null) {
            requestOrgUnitCollection = this.getOrgUnitColl(ctx, purordid, OrgType.Purchase, OrgType.Storage);
            StorageOrgUnitInfo currentOrgInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
            OrgUtils.getSortData((OrgUnitCollection)requestOrgUnitCollection);
            if (requestOrgUnitCollection != null && requestOrgUnitCollection.size() > 0 && currentOrgInfo != null) {
                for (int i = 0; i < requestOrgUnitCollection.size(); ++i) {
                    if (!currentOrgInfo.getId().toString().equals(requestOrgUnitCollection.get(i).getId().toString())) continue;
                    storageOrgInfo = (StorageOrgUnitInfo)requestOrgUnitCollection.get(i);
                    break;
                }
            }
            adminOrgUnitCollection = this.getOrgUnitColl(ctx, purordid, OrgType.Admin, OrgType.Purchase);
            AdminOrgUnitInfo currentadminOrgInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
            OrgUtils.getSortData((OrgUnitCollection)requestOrgUnitCollection);
            if (adminOrgUnitCollection != null && adminOrgUnitCollection.size() > 0 && currentOrgInfo != null) {
                for (int i = 0; i < adminOrgUnitCollection.size(); ++i) {
                    if (currentadminOrgInfo == null || !currentadminOrgInfo.getId().toString().equals(adminOrgUnitCollection.get(i).getId().toString())) continue;
                    adminOrgUnit = (AdminOrgUnitInfo)adminOrgUnitCollection.get(i);
                    break;
                }
            }
        }
        if (storageOrgInfo == null && requestOrgUnitCollection != null) {
            storageOrgInfo = (StorageOrgUnitInfo)requestOrgUnitCollection.get(0);
        }
        if (adminOrgUnit == null && adminOrgUnitCollection != null) {
            adminOrgUnit = (AdminOrgUnitInfo)adminOrgUnitCollection.get(0);
        }
        entryInfo.setAdminOrgUnit(adminOrgUnit);
        entryInfo.setStorageOrgUnit(storageOrgInfo);
        entryInfo.setRequestOrgUnit(storageOrgInfo);
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        if (storageOrgInfo != null && (cou = this.getEntryCompanyOrgUnit(ctx, storageOrgInfo.getId().toString())) != null) {
            entryInfo.setCompanyOrgUnit(cou);
            entryInfo.setRequestCompanyOrgUnit(cou);
            if (companyOrgid != null && !cou.getId().toString().equals(companyOrgid)) {
                entryInfo.setIsBetweenCompanyRec(true);
            } else {
                entryInfo.setIsBetweenCompanyRec(false);
            }
            entryInfo.put("e_companyOrgUnit", cou);
        }
        return entryInfo;
    }

    private ExchangeRateInfo getExchange(String orgid, String srcCurrid, String destCurrid) throws EASBizException, BOSException {
        CompanyOrgUnitInfo ficompanyOrgInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        if (!destCurrid.equals(srcCurrid)) {
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrid);
            destCurrPK = new ObjectUuidPK(destCurrid);
            IExchangeRate iexchangRate = ExchangeRateFactory.getRemoteInstance();
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }
}

