/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.IPurPlan;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurPlanAgent;
import com.kingdee.eas.scm.sm.pur.PurPlanCollection;
import com.kingdee.eas.scm.sm.pur.PurPlanEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurPlanEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurPlanException;
import com.kingdee.eas.scm.sm.pur.PurPlanFactory;
import com.kingdee.eas.scm.sm.pur.PurPlanInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurPlanControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;

public class PurPlanControllerBean
extends AbstractPurPlanControllerBean {
    private static final long serialVersionUID = -1256578197943670486L;
    private BigDecimal ZERO = new BigDecimal("0.00");

    protected String getBillTypeId() {
        return "Htzs+wEkEADgAAMJwKg9YtAMSuo=";
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurPlanInfo purPlanInfo = null;
        purPlanInfo = isUseAgent ? PurPlanAgent.create() : new PurPlanInfo();
        IBizType iBizType = BizTypeFactory.getLocalInstance((Context)ctx);
        BizTypeInfo bizTypeInfo = iBizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0106-1000-e000-04c5c0a812202407435C"), SCMSelectorFactory.getBizTypeInfoSelector());
        if (bizTypeInfo != null) {
            purPlanInfo.setBizType(bizTypeInfo);
        }
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        purPlanInfo.setBizDate(cal.getTime());
        purPlanInfo.setCreateTime(new Timestamp(cal.getTimeInMillis()));
        return purPlanInfo;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurPlanInfo)model).getPurchaseOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._audit(ctx, pks);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isAddNew = true;
        PurPlanInfo info = (PurPlanInfo)model;
        if (info.getId() != null) {
            isAddNew = false;
            ObjectUuidPK oldPks = new ObjectUuidPK(info.getId().toString());
            this._delete(ctx, (IObjectPK)oldPks);
            isAddNew = true;
        }
        info.setBizDate(info.getBizDate());
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"Htzs+wEkEADgAAMJwKg9YtAMSuo="));
        info.setBillType(billTypeInfo);
        BillTypeInfo sourceBillTypeInfo = new BillTypeInfo();
        sourceBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        info.setSourceBillType(sourceBillTypeInfo);
        info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        PurPlanEntryCollection entries = info.getEntries();
        PurPlanEntryInfo entry = null;
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            entry.setSourceBillType(billTypeInfo);
            entry.setTotalOrderQty(this.ZERO);
            entry.setTotalOrderBaseQty(this.ZERO);
            entry.setTotalUnOrderQty(entry.getQty());
            entry.setTotalUnOrderBaseQty(entry.getBaseQty());
        }
        IObjectPK pk = super._save(ctx, model);
        this.saveBillRelations(ctx, model, isAddNew);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isAddNew = true;
        PurPlanInfo info = (PurPlanInfo)model;
        PurPlanEntryCollection entries = info.getEntries();
        PurPlanEntryInfo entry = null;
        if (info.getId() == null) {
            isAddNew = true;
        } else {
            isAddNew = false;
            ObjectUuidPK oldPks = new ObjectUuidPK(info.getId().toString());
            info.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entry = entries.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            }
            super._update(ctx, (IObjectPK)oldPks, model);
            this._delete(ctx, (IObjectPK)oldPks);
            isAddNew = true;
        }
        info.setBizDate(info.getBizDate());
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"Htzs+wEkEADgAAMJwKg9YtAMSuo="));
        info.setBillType(billTypeInfo);
        BillTypeInfo sourceBillTypeInfo = new BillTypeInfo();
        sourceBillTypeInfo.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        info.setSourceBillType(sourceBillTypeInfo);
        info.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
            entry.setSourceBillType(billTypeInfo);
            entry.setTotalOrderQty(this.ZERO);
            entry.setTotalOrderBaseQty(this.ZERO);
            entry.setTotalUnOrderQty(entry.getQty());
            entry.setTotalUnOrderBaseQty(entry.getBaseQty());
        }
        IObjectPK pk = super._submit(ctx, model);
        this.saveBillRelations(ctx, model, isAddNew);
        String orgUnitID = info.getPurchaseOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, info, orgUnitID, 3)) {
            // empty if block
        }
        return pk;
    }

    protected void saveBillRelations(Context ctx, IObjectValue model, boolean isAddNew) throws BOSException, EASBizException {
        PurPlanInfo billInfo = (PurPlanInfo)model;
        BOTRelationInfo info = null;
        PurPlanEntryCollection entries = billInfo.getEntries();
        PurPlanEntryInfo entry = null;
        if (isAddNew) {
            IObjectPK[] pks = new IObjectPK[entries.size()];
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entry = entries.get(i);
                entry.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                pks[i] = new ObjectUuidPK(entry.getSourceBillEntryId().toString());
                info = new BOTRelationInfo();
                info.setSrcObjectID(entry.getSourceBillId().toString());
                info.setSrcEntityID("25428F2E");
                info.setDestEntityID("D00C4AEA");
                info.setDestObjectID(billInfo.getId().toString());
                info.setOperatorID(ctx.getUserName());
                info.setType(0);
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
                info = new BOTRelationInfo();
                info.setSrcObjectID(entry.getSourceBillEntryId().toString());
                info.setSrcEntityID("2B7DD5E4");
                info.setDestEntityID("31600FA8");
                info.setDestObjectID(entry.getId().toString());
                info.setOperatorID(ctx.getUserName());
                info.setType(0);
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
            }
            this.writeBackToPurReq(ctx, pks, BizActionEnum.CLOSE);
        }
    }

    private void writeBackToPurReq(Context ctx, IObjectPK[] pks, BizActionEnum enums) throws BOSException, EASBizException {
        IPurRequestEntry iEntry = PurRequestEntryFactory.getLocalInstance(ctx);
        if (enums.equals((Object)BizActionEnum.CLOSE)) {
            iEntry.closeEntry(pks);
        } else if (enums.equals((Object)BizActionEnum.UNCLOSE)) {
            iEntry.unClose(pks);
        }
    }

    public BatchActionResults batchSaveRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return super.batchSaveRelations(ctx, entries);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unAudit(ctx, new IObjectPK[]{pk});
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        HashSet<IObjectPK> idSet = new HashSet<IObjectPK>();
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            idSet.add(pks[j]);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("baseStatus"));
        view.getSelector().add(new SelectorItemInfo("entries.id"));
        view.getSelector().add(new SelectorItemInfo("baseStatus"));
        PurPlanCollection coll = PurPlanFactory.getLocalInstance(ctx).getPurPlanCollection(view);
        PurPlanInfo purInfo = null;
        int size2 = coll.size();
        for (int j = 0; j < size2; ++j) {
            purInfo = coll.get(j);
            if (!purInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT);
            }
            PurPlanEntryCollection entries = purInfo.getEntries();
            int esize = entries.size();
            for (int k = 0; k < esize; ++k) {
                if (entries.get(k).getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
                throw new SCMBillException(SCMBillException.ENTRIESISNOTAUDIT_CANNOTUNAUDIT);
            }
            if (!SCMServerUtils.hasDestBill((Context)ctx, (String)purInfo.getId().toString())) continue;
            throw new SCMBillException(SCMBillException.HASDESTBILL_CANNOTUNAUDIT);
        }
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            String updateSql = "update T_SM_PurPlan set FBaseStatus = 1,FAuditorId = null, FAuditTime = null where fid in(" + params.toString() + ")";
            String updateEntrySql = "update T_SM_PurPlanEntry set FBaseStatus = 1 where FParentID in(" + params.toString() + ")";
            batchStatement.addBatch(updateSql);
            batchStatement.addBatch(updateEntrySql);
            batchStatement.executeBatch();
            this.writeSourceBillForPurRequest_unAudit(ctx, params.toString());
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSourceBillForPurRequest_unAudit(Context ctx, String params) throws SQLException, BOSException {
        Connection con = null;
        Statement srcRateStatement = null;
        Statement destRateStatement = null;
        PreparedStatement updateStatement = null;
        ResultSet srcRateSet = null;
        ResultSet destRateSet = null;
        IRowSet result = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FQty").append(" from T_SM_PurPlanEntry entry").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and entry.FParentID in(").append(params).append(")");
            result = DbUtil.executeQuery((Context)ctx, (String)valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                srcRateStatement = con.createStatement();
                destRateStatement = con.createStatement();
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,entry.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurPlanEntry entry").append(" on entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and FParentID in(").append(params).append(")").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurPlanEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")").append(") temp order by temp.fseq");
                destBuffer.append("select FBaseConvsRate from(select unit.FBaseConvsRate,tempOrder.fseq as fseq from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurPlanEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.FSourceBillEntryId").append(" where entry.FParentId in(").append(params).append(")").append(")tempOrder on tempOrder.FMaterialID = unit.FMaterialID").append(" and tempOrder.destUnit = unit.FMeasureUnitID ").append(" union select 1 as FBaseConvsRate,anotherEntry.fseq as fseq from T_SM_PurPlanEntry anotherEntry where FMaterialID IS NULL").append(" and FParentID in(").append(params).append(")").append(") temp order by temp.fseq");
                String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty-?,FOrderedBaseQty = FOrderedBaseQty-?,  FUnOrderedQty = FQty - FOrderedQty+?,FUnOrderedBaseQty = FBaseQty-FOrderedBaseQty+? where Fid = ?";
                updateStatement = con.prepareStatement(updateReqSql);
                srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
                destRateSet = destRateStatement.executeQuery(destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal qty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                BigDecimal destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    if (result.getBigDecimal(2) != null) {
                        qty = result.getBigDecimal(2);
                    }
                    srcRate = srcRateSet.getBigDecimal(1);
                    destRate = destRateSet.getBigDecimal(1);
                    destQty = this.exchangeQtyByUnit(srcRate, destRate, qty);
                    if (destRate == null) {
                        destRate = new BigDecimal("1.00");
                    }
                    destBaseQty = destRate.intValue() == 1 ? destQty : destQty.multiply(destRate);
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, destBaseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, destBaseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
            }
            StringBuffer sqlParams = new StringBuffer();
            for (int i = 0; i < sourceEntryIdList.size(); ++i) {
                if (i > 0) {
                    sqlParams.append(",");
                }
                sqlParams.append("'");
                sqlParams.append(sourceEntryIdList.get(i).toString());
                sqlParams.append("'");
            }
            if (sqlParams.length() > 0) {
                StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
                updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =4").append(" where FUnOrderedQty >0 and fid in(").append(sqlParams.toString()).append(")");
                DbUtil.execute((Context)ctx, (String)updateCloseReqEntryBuffer.toString());
                StringBuffer updateCloseReqBuffer = new StringBuffer();
                updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 4").append(" where fid in (select FParentid from T_SM_PurRequestEntry where fparentid in (select DISTINCT FParentId from T_SM_PurRequestEntry where fid in(").append(sqlParams.toString()).append(")))");
                DbUtil.execute((Context)ctx, (String)updateCloseReqBuffer.toString());
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLException(e.getMessage());
                catch (SQLDataException e2) {
                    throw new SQLException(e2.getMessage());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(srcRateSet, srcRateStatement, (Connection)con);
                SQLUtils.cleanup(destRateSet, destRateStatement);
                SQLUtils.cleanup(result, updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup(srcRateSet, (Statement)srcRateStatement, (Connection)con);
        SQLUtils.cleanup(destRateSet, (Statement)destRateStatement);
        SQLUtils.cleanup((ResultSet)result, updateStatement);
    }

    private BigDecimal exchangeQtyByUnit(BigDecimal srcRate, BigDecimal destRate, BigDecimal qty) {
        if (srcRate == null) {
            srcRate = new BigDecimal("1.00");
        }
        if (destRate == null) {
            destRate = new BigDecimal("1.00");
        }
        if (destRate.equals(srcRate)) {
            return qty;
        }
        BigDecimal baseQty = qty.multiply(srcRate);
        return baseQty.divide(destRate, baseQty.scale(), 0);
    }

    private void checkPurPlanRevoke(Context ctx, IPurPlan iPurPlan, IObjectPK pk) throws EASBizException, BOSException {
        PurPlanInfo purPlanInfo = iPurPlan.getPurPlanInfo(pk);
        if (purPlanInfo.getBaseStatus().getValue() == 1 || purPlanInfo.getBaseStatus().getValue() == 2) {
            return;
        }
        throw new PurPlanException(PurPlanException.QUOPLAN_CANNOT_CANCEL, new String[]{purPlanInfo.getBaseStatus().toString()});
    }

    protected void checkPurPlanRevoke(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkPurPlanRevoke(ctx, iPurPlan, pks[i]);
                    continue;
                }
                catch (PurPlanException ex) {
                    if (num > 1) {
                        throw new PurPlanException(PurPlanException.QUOPLAN_PARTCANNOTCANCEL);
                    }
                    throw ex;
                }
            }
        }
    }

    protected void _canRevoke(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkPurPlanRevoke(ctx, (IObjectPK[])new ObjectUuidPK[]{(ObjectUuidPK)pk});
    }

    protected void _canRevoke(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkPurPlanRevoke(ctx, pks);
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurPlanRevoke(ctx, pks);
        if (pks != null) {
            IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
            ReasonCodeInfo reasonCodeInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : (ReasonCodeInfo)reasonCodes[i];
                iPurPlan.revoke(pks[i], reasonCodeInfo);
            }
        }
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK[] pks, String[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurPlanRevoke(ctx, pks);
        if (pks != null) {
            IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
            String reasonCodeInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : reasonCodes[i];
                iPurPlan.revoke(pks[i], reasonCodeInfo);
            }
        }
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection selector = super.getSelector();
        selector.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        return selector;
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
        this.checkPurPlanRevoke(ctx, iPurPlan, pk);
        PurPlanInfo purPlanInfo = null;
        PurPlanEntryInfo entryInfo = null;
        PurPlanEntryCollection purPlanEntries = null;
        ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)reasonCode;
        purPlanInfo = iPurPlan.getPurPlanInfo(pk);
        purPlanInfo.setReason(reasonCodeInfo.getName());
        purPlanEntries = purPlanInfo.getEntries();
        IObjectPK[] pks = new IObjectPK[purPlanEntries.size()];
        int num2 = purPlanEntries.size();
        for (int j = 0; j < num2; ++j) {
            entryInfo = purPlanEntries.get(j);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
            pks[j] = new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString());
        }
        purPlanInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        iPurPlan.update(pk, purPlanInfo);
        this.writeBackToPurReq(ctx, pks, BizActionEnum.UNCLOSE);
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk, String reasonCode) throws BOSException, EASBizException {
        IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
        this.checkPurPlanRevoke(ctx, iPurPlan, pk);
        PurPlanInfo purPlanInfo = null;
        PurPlanEntryInfo entryInfo = null;
        PurPlanEntryCollection purPlanEntries = null;
        String reasonCodeInfo = reasonCode;
        purPlanInfo = iPurPlan.getPurPlanInfo(pk);
        purPlanInfo.setReason(reasonCodeInfo);
        purPlanEntries = purPlanInfo.getEntries();
        IObjectPK[] pks = new IObjectPK[purPlanEntries.size()];
        int num2 = purPlanEntries.size();
        for (int j = 0; j < num2; ++j) {
            entryInfo = purPlanEntries.get(j);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
            pks[j] = new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString());
        }
        purPlanInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        iPurPlan.update(pk, purPlanInfo);
        this.writeBackToPurReq(ctx, pks, BizActionEnum.UNCLOSE);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        PurPlanInfo info = (PurPlanInfo)this.getValue(ctx, pk);
        PurPlanEntryCollection purPlanEntries = null;
        PurPlanEntryInfo entryInfo = null;
        purPlanEntries = info.getEntries();
        IObjectPK[] pks = new IObjectPK[purPlanEntries.size()];
        int num2 = purPlanEntries.size();
        for (int j = 0; j < num2; ++j) {
            entryInfo = purPlanEntries.get(j);
            pks[j] = new ObjectUuidPK(entryInfo.getSourceBillEntryId().toString());
        }
        this.writeBackToPurReq(ctx, pks, BizActionEnum.UNCLOSE);
        super._delete(ctx, pk);
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPurPlan iPurPlan = PurPlanFactory.getLocalInstance(ctx);
        PurPlanInfo purPlanInfo = iPurPlan.getPurPlanInfo(pk);
        if (purPlanInfo.getBaseStatus().getValue() != 0 && purPlanInfo.getBaseStatus().getValue() != 1) {
            throw new PurPlanException(PurPlanException.NEED_TEMPORY, new String[]{purPlanInfo.getBaseStatus().toString()});
        }
        super._canUpdate(ctx, pk);
    }
}

