/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sd.channel.NetOrderManagerException;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurPlanFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurPlanFacadeControllerBean
extends AbstractPurPlanFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurPlanFacadeControllerBean");

    @Override
    protected IRowSet _getInventoryInfo(Context ctx, String material, String storageId, String queryType) throws BOSException {
        if (material != null) {
            StringBuffer sql = new StringBuffer();
            String warehouse = "null as warehouse,";
            String location = "null as location,";
            String lot = "null as lot,";
            String groupBy = " ";
            String permStorageIds = null;
            try {
                permStorageIds = this.getPermissionStorage(ctx);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            if (queryType != null) {
                if (queryType.indexOf("a") != -1) {
                    warehouse = "warehouse.fname_l2 as warehouse,";
                    groupBy = groupBy + "warehouse.fname_l2,";
                }
                if (queryType.indexOf("b") != -1) {
                    location = "location.fname_l2 as location,";
                    groupBy = groupBy + "location.fname_l2,";
                }
                if (queryType.indexOf("c") != -1) {
                    lot = "inv.flot as lot,";
                    groupBy = groupBy + "inv.flot,";
                }
            }
            sql.append(" select material.fname_l2 as material ,storage.fname_l2 as storageOrg,");
            sql.append(warehouse);
            sql.append(location);
            sql.append(lot);
            sql.append("sum(inv.fbaseqty) as qty,measureunit.fname_l2  as unit from t_im_inventory inv inner join t_bd_material material on inv.fmaterialid=material.fid  left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid  left outer join t_db_location location on inv.flocationid=location.fid  left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ");
            sql.append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid='");
            sql.append(material);
            sql.append("' and storeState.fnumber='1' ");
            if (permStorageIds != null) {
                sql.append(" and storage.fid in  ");
                sql.append(permStorageIds);
            }
            if (storageId != null) {
                sql.append(" and storage.fid ='");
                sql.append(storageId);
                sql.append("' ");
            }
            sql.append(" group by material.fname_l2,storage.fname_l2,");
            sql.append(groupBy);
            sql.append("measureunit.fname_l2");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            return rs;
        }
        return null;
    }

    protected String getPermissionStorage(Context ctx) throws EASBizException, BOSException {
        ObjectUuidPK userPK = new ObjectUuidPK(((UserInfo)ctx.get((Object)"UserInfo")).getId());
        FullOrgUnitCollection coll = null;
        StringBuffer storageIds = new StringBuffer();
        coll = PermissionFactory.getLocalInstance((Context)ctx).getAuthorizedOrg((IObjectPK)userPK, OrgType.Storage, null, "inventory");
        if (coll.size() > 0) {
            storageIds.append("('");
            for (int i = 0; i < coll.size(); ++i) {
                storageIds.append(coll.get(i).getId());
                storageIds.append("','");
            }
            storageIds.delete(storageIds.length() - 2, storageIds.length());
            storageIds.append(")");
        }
        return storageIds.toString();
    }

    @Override
    protected IObjectValue _getWarehouseByStorage(Context ctx, String storageId) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        WarehouseInfo warehouse = null;
        String warehousePk = null;
        sql.append("select top 1 fid from t_db_warehouse  where fstorageOrgid='");
        sql.append(storageId);
        sql.append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rowSet.next()) {
                warehousePk = rowSet.getString("fid");
                warehouse = WarehouseFactory.getLocalInstance((Context)ctx).getWarehouseInfo((IObjectPK)new ObjectUuidPK(warehousePk));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new NetOrderManagerException(NetOrderManagerException.SQL_EXCE_ERROR);
        }
        return warehouse;
    }

    @Override
    protected IRowSet _getInventoryDetail(Context ctx, List materialIds, List storageIds, String queryType) throws BOSException {
        if (materialIds == null || materialIds.size() < 1) {
            return null;
        }
        StringBuffer materialIdSet = new StringBuffer();
        Iterator it = materialIds.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Object id = it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                materialIdSet.append(",");
            }
            materialIdSet.append("'").append(id.toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String warehouse = "null as warehouse,";
        String location = "null as location,";
        String lot = "null as lot,";
        String groupBy = " ";
        String permStorageIds = null;
        try {
            permStorageIds = this.getPermissionStorage(ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        if (queryType != null) {
            if (queryType.indexOf("a") != -1) {
                warehouse = "warehouse.fname_l2 as warehouse,";
                groupBy = groupBy + "warehouse.fname_l2,";
            }
            if (queryType.indexOf("b") != -1) {
                location = "location.fname_l2 as location,";
                groupBy = groupBy + "location.fname_l2,";
            }
            if (queryType.indexOf("c") != -1) {
                lot = "inv.flot as lot,";
                groupBy = groupBy + "inv.flot,";
            }
        }
        sql.append(" select material.fid as materialId, material.fnumber as materialNumber,  material.fname_l2 as materialName, material.FModel as materialModel,storage.fname_l2 as storageOrg,");
        sql.append(warehouse);
        sql.append(location);
        sql.append(lot);
        sql.append("sum(inv.fbaseqty) as qty,measureunit.fname_l2  as unit,measureunit.fid as unitId from t_im_inventory inv inner join t_bd_material material on inv.fmaterialid=material.fid  left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid  left outer join t_db_location location on inv.flocationid=location.fid  left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ");
        sql.append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid in (");
        sql.append(materialIdSet);
        sql.append(") and storeState.fnumber='1' ");
        if (permStorageIds != null) {
            sql.append(" and storage.fid in  ");
            sql.append(permStorageIds);
        }
        sql.append(" group by material.fid,material.fnumber,material.fname_l2,material.FModel,storage.fname_l2,");
        sql.append(groupBy);
        sql.append("measureunit.fname_l2,measureunit.fid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    @Override
    protected Map _getInventoryQtyBase(Context ctx, List materialIds, List storageIds) throws BOSException {
        HashMap<String, BigDecimal> result = new HashMap<String, BigDecimal>();
        if (materialIds == null || materialIds.size() < 1) {
            return null;
        }
        StringBuffer materialIdSet = new StringBuffer();
        Iterator it = materialIds.iterator();
        boolean isFirst = true;
        while (it.hasNext()) {
            Object id = it.next();
            if (isFirst) {
                isFirst = false;
            } else {
                materialIdSet.append(",");
            }
            materialIdSet.append("'").append(id.toString()).append("'");
        }
        StringBuffer sql = new StringBuffer();
        String warehouse = "null as warehouse,";
        String location = "null as location,";
        String lot = "null as lot,";
        String groupBy = " ";
        String permStorageIds = null;
        try {
            permStorageIds = this.getPermissionStorage(ctx);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        sql.append(" select inv.fstorageorgunitid as fstorageorgunitid,measureunit.fid as funitid,material.fid as materialId, material.fnumber as materialNumber,  material.fname_l2 as materialName, material.FModel as materialModel,storage.fname_l2 as storageOrg,");
        sql.append(warehouse);
        sql.append(location);
        sql.append(lot);
        sql.append("sum(inv.fbaseqty) as qty,measureunit.fname_l2  as unit from t_im_inventory inv inner join t_bd_material material on inv.fmaterialid=material.fid  left outer join t_org_storage storage on inv.fstorageorgunitid=storage.fid left outer join  t_db_warehouse warehouse on inv.fwarehouseid=warehouse.fid  left outer join t_db_location location on inv.flocationid=location.fid  left outer join t_bd_measureunit measureunit on inv.fbaseunitid=measureunit.fid left outer join T_IM_STORESTATE storeState on inv.FStoreStatusID=storeState.fid left outer join T_IM_STORETYPE storeType on inv.fStoreTypeId=storeType.fid ");
        sql.append(" where inv.fbaseqty<>0 and storeType.fnumber='G' and  material.fid in (");
        sql.append(materialIdSet);
        sql.append(") and storeState.fnumber='1' ");
        if (permStorageIds != null) {
            sql.append(" and storage.fid in  ");
            sql.append(permStorageIds);
        }
        sql.append(" group by material.fid,material.fnumber,material.fname_l2,material.FModel,storage.fname_l2,");
        sql.append(groupBy);
        sql.append("measureunit.fname_l2,inv.fstorageorgunitid,measureunit.fid");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() < 1) {
            return result;
        }
        try {
            while (rs.next()) {
                String storageID = rs.getString("fstorageorgunitid");
                String materialId = rs.getString("materialId");
                BigDecimal qty = rs.getBigDecimal("qty");
                result.put(storageID + materialId, qty);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return result;
    }
}

