/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IAsstAttrValue;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.IProject;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.DeliveryStyleEnum;
import com.kingdee.eas.scm.sm.pur.DisCountStyleEnum;
import com.kingdee.eas.scm.sm.pur.IPurPriceRelations;
import com.kingdee.eas.scm.sm.pur.IPurPriceRelationsEntry;
import com.kingdee.eas.scm.sm.pur.IPurQuotation;
import com.kingdee.eas.scm.sm.pur.IPurQuotationPlan;
import com.kingdee.eas.scm.sm.pur.PriceRelationsResultEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsException;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsFactory;
import com.kingdee.eas.scm.sm.pur.PurPriceRelationsInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanException;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurPriceRelationsControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurPriceRelationsControllerBean
extends AbstractPurPriceRelationsControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurPriceRelationsControllerBean");
    private IRowSet rowSet = null;
    private IPurPriceRelations iPurPriceRelations = null;
    private PurPriceRelationsInfo purPriceRelationsInfo = null;
    private BigDecimal zero = new BigDecimal(0);
    private IMultiMeasureUnit iMultiMeasureUnit = null;
    private MultiMeasureUnitCollection measureUnitColl = null;
    IPurPriceRelationsEntry iPurPriceRelationsEntry = null;

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        PurPriceRelationsInfo purPriceRelationsInfo = (PurPriceRelationsInfo)model;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purPriceRelationsInfo.getPurOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (purchaseOrgUnitInfo != null && (orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    private void removeTotalLine(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurPriceRelationsInfo info = (PurPriceRelationsInfo)model;
        if (!info.isFullBillComparePrice()) {
            return;
        }
        int i = 0;
        int size = info.getEntries().size();
        while (i < size) {
            PurPriceRelationsEntryInfo entry = info.getEntries().get(i);
            if (entry.getSourceBillEntryId() == null || entry.getSourceBillEntryId().trim().length() == 0) {
                info.getEntries().removeObject(i);
            } else {
                ++i;
            }
            size = info.getEntries().size();
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurPriceRelationsInfo)model).getPurOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.removeTotalLine(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurPriceRelationsInfo purPriceRelationsInfo = (PurPriceRelationsInfo)model;
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        BillTypeInfo aBillTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0b814fd463ED552"));
        purPriceRelationsInfo.setBillType(aBillTypeInfo);
        this.removeTotalLine(ctx, model);
        IObjectPK pk = super._submit(ctx, model);
        String orgUnitID = purPriceRelationsInfo.getPurOrgUnit().getId().toString();
        this.checkPurSecrecy(ctx, orgUnitID, purPriceRelationsInfo);
        if (this.isAuditAfterSubmit(ctx, purPriceRelationsInfo, orgUnitID, 3)) {
            this.auditAndLog(ctx, pk, purPriceRelationsInfo.getBOSType(), purPriceRelationsInfo.getNumber(), "scm_purPrice_audit");
        }
        return pk;
    }

    private void checkPurSecrecy(Context ctx, String orgUnitID, PurPriceRelationsInfo purPriceRelationsInfo) throws BOSException, EASBizException {
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        if (purPriceRelationsInfo != null && purPriceRelationsInfo.getPurOrgUnit() != null && purPriceRelationsInfo.getPurOrgUnit().getId() != null) {
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(purPriceRelationsInfo.getPurOrgUnit().getId());
            if (pk != null && this.isPurQuoSecrecy(ctx, pk.toString())) {
                String wfService = null;
                String funcName = "com.kingdee.eas.scm.sm.pur.PurPriceRelationsFunction";
                String operationName = "ActionSubmit";
                IEnactmentService iEnactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
                if (user.getSupplierID() != null) {
                    user = iUser.getUserByID(ctx.getCaller());
                }
                if ((wfService = iEnactmentService.findSubmitProcDef(user.getId().toString(), (IObjectValue)purPriceRelationsInfo, funcName, operationName)) == null) {
                    if (purPriceRelationsInfo != null) {
                        throw new PurQuotationPlanException(PurQuotationPlanException.QUOPLAN_PROCESS_NULL, new String[]{purPriceRelationsInfo.getBaseStatus().toString()});
                    }
                    throw new PurQuotationPlanException(PurQuotationPlanException.QUOPLAN_PROCESS_NULL, new String[]{BillBaseStatusEnum.SUBMITED.toString().toString()});
                }
            }
        }
    }

    private boolean isPurQuoSecrecy(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURQUO003")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    protected int[] convertBizPeriod(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo v = (SCMBillBaseInfo)model;
        if (v.getBizDate() == null) {
            throw new PurPriceRelationsException(PurPriceRelationsException.BIZDATENOTNULL);
        }
        return super.convertBizPeriod(ctx, model);
    }

    private void UpdatePurQuotation(Context ctx, StringBuffer pks) throws BOSException, EASBizException {
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update t_sm_purquotationentry set FIsAffirm=1 where fid in");
        strSQL.append("(select fsourcebillentryid from t_sm_purpricerelationsentry where fparentid in (").append(sp);
        strSQL.append(pks);
        strSQL.append("))");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
    }

    private void UpdatePurQuotationPlan(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.rowSet = null;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> supplierList = new ArrayList<String>();
        ArrayList<String> sourceSEntryList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        ArrayList<String> materialGroupList = new ArrayList<String>();
        ArrayList<String> materialNameList = new ArrayList<String>();
        ArrayList<String> paramList = new ArrayList<String>();
        String quotationplanId = null;
        Object material = null;
        Object materialGroup = null;
        Object materialName = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("quotationPlanID"));
        sql.append("select purpricerelations.fquotationplanid quotationplanid,purpricerelationsentry.FSupplierID supplierID,");
        sql.append("purpricerelationsentry.FPriceRelationResult priceRelationResult,purpricerelationsentry.FMaterialID materialID,");
        sql.append("purpricerelationsentry.FMaterialGroupID materialGroupID,purpricerelationsentry.FMaterialName materialName, ");
        sql.append("purpricerelationsentry.FSourceBillSEntryID sourceBillSEntryID ");
        sql.append("from t_sm_purpricerelationsentry purpricerelationsentry left outer join t_sm_purpricerelations purpricerelations on purpricerelations.fid=purpricerelationsentry.fparentid  where fparentid = '" + pk + "' ");
        this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (this.rowSet.next()) {
                quotationplanId = this.rowSet.getString("quotationplanid");
                material = this.rowSet.getObject("materialID");
                materialGroup = this.rowSet.getObject("materialGroupID");
                materialName = this.rowSet.getObject("materialName");
                if (this.rowSet.getInt("priceRelationResult") != 1) continue;
                supplierList.add(this.rowSet.getString("supplierID"));
                sourceSEntryList.add(this.rowSet.getString("sourceBillSEntryID"));
                if (material != null) {
                    materialList.add(material.toString());
                } else {
                    materialList.add(null);
                }
                if (materialGroup != null) {
                    materialGroupList.add(materialGroup.toString());
                } else {
                    materialGroupList.add(null);
                }
                if (materialName != null && material == null) {
                    materialNameList.add(materialName.toString());
                } else {
                    materialNameList.add(null);
                }
                sql.delete(0, sql.length());
                sql.append("update T_SM_PurQuotationEntry set fpriceRelResult=? ");
                sql.append(" where FParentID in (select fid from T_SM_PurQuotation where FPurQuoTationPlanID=? and FSupplierID=?) ");
                paramList.add("0");
                paramList.add(quotationplanId);
                paramList.add(this.rowSet.getString("supplierID"));
                if (material != null) {
                    sql.append(" and  FMaterialID=?");
                    paramList.add(material.toString());
                } else if (materialGroup != null) {
                    sql.append(" and  FMaterialGroupID=?");
                    paramList.add(materialGroup.toString());
                } else if (materialName != null && material == null) {
                    sql.append(" and  FMaterialName=?");
                    paramList.add(materialName.toString());
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                paramList.clear();
            }
            sql.delete(0, sql.length());
            for (int index = 0; index < supplierList.size(); ++index) {
                this.rowSet = null;
                sql.append("select fid from t_sm_purquoplanmentry where FParentID in (select fid from T_SM_PurQuotationPlan where fnumber='" + quotationplanId + "')");
                if (materialList.get(index) != null) {
                    sql.append(" and  fmaterialid='" + materialList.get(index).toString() + "'");
                } else if (materialGroupList.get(index) != null) {
                    sql.append(" and  FMaterialGroupID='" + materialGroupList.get(index).toString() + "'");
                } else if (materialNameList.get(index) != null) {
                    sql.append(" and  FMaterialName='" + materialNameList.get(index).toString() + "'");
                }
                this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                sql.delete(0, sql.length());
                while (this.rowSet.next()) {
                    sql.append("update T_SM_PurQuoPlanSEntry set FIsSelected=? ");
                    sql.append(" where fsupplierid=? and FID=?");
                    paramList.add("0");
                    paramList.add(supplierList.get(index).toString());
                    paramList.add(sourceSEntryList.get(index).toString());
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                    sql.delete(0, sql.length());
                    paramList.clear();
                }
            }
            this.rowSet = null;
            sql.append("select fid from T_SM_PurQuotationPlan where fnumber='" + quotationplanId + "'");
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.delete(0, sql.length());
            while (this.rowSet.next()) {
                sql.append("update t_sm_purquoplanmentry set FHasComparison=?");
                sql.append(" where FParentID=?");
                paramList.add("0");
                paramList.add(this.rowSet.getString("fid"));
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                sql.delete(0, sql.length());
                paramList.clear();
            }
            sql.append("update t_sm_purquotationplan  set fbasestatus=? ");
            sql.append("where Fnumber=?");
            paramList.add("4");
            paramList.add(quotationplanId);
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            paramList.clear();
            IPurPriceRelations iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
            PurPriceRelationsInfo purPriceRelationsInfo = iPurPriceRelations.getPurPriceRelationsInfo(pk, selector);
            this.rowSet = null;
            sql.delete(0, sql.length());
            sql.append("select FBaseStatus from T_SM_PurQuotation where FPurQuotationPlanID='" + purPriceRelationsInfo.getQuotationPlanID() + "'");
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.delete(0, sql.length());
            while (this.rowSet.next()) {
                if (this.rowSet.getInt("FBaseStatus") != 7) continue;
                sql.append("update T_SM_PurQuotation set FBaseStatus=?");
                sql.append(" where FPurQuotationPlanID=? and FBaseStatus=7 ");
                paramList.add(String.valueOf(4));
                paramList.add(purPriceRelationsInfo.getQuotationPlanID());
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                sql.delete(0, sql.length());
                paramList.clear();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IPurQuotationPlan iPurQuotationPlan = PurQuotationPlanFactory.getLocalInstance(ctx);
        this.iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
        this.purPriceRelationsInfo = this.iPurPriceRelations.getPurPriceRelationsInfo(pk, selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.purPriceRelationsInfo.getQuotationPlanID().toString(), CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseStatus"));
        ObjectUuidPK uuidPK = null;
        PurQuotationPlanInfo purQuotationPlanInfo = null;
        PurQuotationPlanCollection purQuotationPlanColl = iPurQuotationPlan.getPurQuotationPlanCollection(viewInfo);
        if (purQuotationPlanColl != null && purQuotationPlanColl.size() > 0) {
            for (int k = 0; k < purQuotationPlanColl.size(); ++k) {
                purQuotationPlanInfo = purQuotationPlanColl.get(k);
                purQuotationPlanInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
                uuidPK = new ObjectUuidPK(purQuotationPlanInfo.getId());
                iPurQuotationPlan.update((IObjectPK)uuidPK, purQuotationPlanInfo);
            }
        }
    }

    protected void checkAudit(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IPurPriceRelations iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkAudit(ctx, iPurPriceRelations, pks[i]);
                    continue;
                }
                catch (PurOrderException ex) {
                    if (num > 1) {
                        throw new PurReqException(PurReqException.PUR_NOT_SUBMIT);
                    }
                    throw ex;
                }
            }
        }
    }

    private void checkAudit(Context ctx, IPurPriceRelations iPurPriceRelations, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet checkSet;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("purOrgUnit.id"));
        selector.add(new SelectorItemInfo("creator.id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        PurPriceRelationsInfo purPriceRelationsInfo = iPurPriceRelations.getPurPriceRelationsInfo(pk, selector);
        if (purPriceRelationsInfo.getBaseStatus().getValue() != 2) {
            throw new PurReqException(PurReqException.PUR_NOT_SUBMIT);
        }
        this.isSamePerson4Audit(ctx, purPriceRelationsInfo);
        String checkSql = "select fid from t_sm_purquotation purq where fpurQuotationPlanID in(select fquotationPlanID from t_sm_purpricerelations where fid in('" + pk.toString() + "')) and purq.fbasestatus=-2";
        try {
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next()) {
                throw new PurPriceRelationsException(PurPriceRelationsException.HAS_ALERTING_WF);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        checkSql = "select fbaseStatus from t_sm_purquotationPlan where fnumber in(select fquotationPlanID from t_sm_purpricerelations where fid in('" + pk.toString() + "'))";
        try {
            int fbasesatus;
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next() && (fbasesatus = checkSet.getInt("fbaseStatus")) == 7) {
                throw new PurPriceRelationsException(PurPriceRelationsException.ALREADY_CLOSE_BILL);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkAudit(ctx, pks);
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update T_SM_PurPriceRelations set FBaseStatus =4,FAuditorId='");
        strSQL.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
        strSQL.append("',FAuditTime = getDate() where fid in(").append(sp);
        strSQL.append(params.toString());
        strSQL.append(");");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
        StringBuffer strEntrySQL = new StringBuffer();
        strEntrySQL.append("update T_SM_PurPriceRelationsEntry set FBaseStatus =4 where fparentid in(").append(sp);
        strEntrySQL.append(params.toString());
        strEntrySQL.append(");");
        DbUtil.execute((Context)ctx, (String)strEntrySQL.toString());
        this.UpdatePurQuotation(ctx, params);
        Connection con = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            ObjectUuidPK[] qUpdateASInfoPks = null;
            ObjectUuidPK[] qUpdateASInfoPurOrgPks = null;
            ObjectUuidPK[] qUpdateASInfoMaterialpks = null;
            String checkSql = "select entry.fsourcebillentryid from t_sm_purpricerelationsentry entry left join t_sm_purpricerelations bill on entry.fparentid=bill.FID where entry.fparentid in (" + params.toString() + ") and entry.FSupplierAffirm =1 and entry.fsourcebillid is not null";
            IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            int i = 0;
            while (checkSet.next()) {
                ++i;
            }
            if (i > 0) {
                ObjectUuidPK[] qPks = new ObjectUuidPK[i];
                i = 0;
                checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (checkSet.next()) {
                    qPks[i] = new ObjectUuidPK(checkSet.getString(1));
                    ++i;
                }
                IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
                iPurQuotation.audit((IObjectPK[])qPks);
            }
            checkSql = "select fsourcebillentryid from t_sm_purpricerelationsentry where fparentid in (" + params.toString() + ") and FSupplierAffirm =-1 and fsourcebillid is not null";
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            i = 0;
            while (checkSet.next()) {
                ++i;
            }
            if (i > 0) {
                IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
                ObjectUuidPK[] qPks = new ObjectUuidPK[i];
                i = 0;
                checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (checkSet.next()) {
                    qPks[i] = new ObjectUuidPK(checkSet.getString(1));
                    ++i;
                }
                iPurQuotation.calcel((IObjectPK[])qPks);
            }
            checkSql = "select entry.FID,bill.FPurOrgUnitID, entry.FMaterialID from t_sm_purpricerelationsentry entry left join  t_sm_purpricerelations bill on bill.FId=entry.FparentID where entry.fparentid in (" + params.toString() + ") and entry.FPriceRelationResult =1 ";
            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            i = 0;
            while (checkSet.next()) {
                ++i;
            }
            if (i > 0) {
                qUpdateASInfoPks = new ObjectUuidPK[i];
                qUpdateASInfoPurOrgPks = new ObjectUuidPK[i];
                qUpdateASInfoMaterialpks = new ObjectUuidPK[i];
                i = 0;
                checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                while (checkSet.next()) {
                    qUpdateASInfoPks[i] = new ObjectUuidPK(checkSet.getString(1));
                    qUpdateASInfoPurOrgPks[i] = new ObjectUuidPK(checkSet.getString(2));
                    if (checkSet.getString(3) != null) {
                        qUpdateASInfoMaterialpks[i] = new ObjectUuidPK(checkSet.getString(3));
                    }
                    ++i;
                }
            }
            boolean isUpdateASInfo = false;
            if (qUpdateASInfoPks != null && qUpdateASInfoPks.length > 0) {
                for (int m = 0; m < qUpdateASInfoPks.length; ++m) {
                    ObjectUuidPK purOrgpk;
                    isUpdateASInfo = false;
                    IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                    String strUpdateASInfo = ipc.getParamValue((IObjectPK)(purOrgpk = new ObjectUuidPK(qUpdateASInfoPurOrgPks[m].toString())), "PURQUOT002");
                    if (strUpdateASInfo != null && strUpdateASInfo.trim().length() != 0 && strUpdateASInfo.trim().equalsIgnoreCase("true") && qUpdateASInfoMaterialpks != null && qUpdateASInfoMaterialpks[m] != null) {
                        isUpdateASInfo = true;
                    }
                    if (!isUpdateASInfo) continue;
                    IPurPriceRelationsEntry iPurPriceRelationsEntry = PurPriceRelationsEntryFactory.getLocalInstance(ctx);
                    iPurPriceRelationsEntry.createApprovedSupplier((IObjectPK)qUpdateASInfoPks[m]);
                }
            }
        }
        catch (EASBizException er) {
            throw er;
        }
        catch (Exception er) {
            throw new BOSException((Throwable)er);
        }
        finally {
            SQLUtils.cleanup(batchStatement, (Connection)con);
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._audit(ctx, pks);
        this.setPurQuotationPlan(pk, ctx);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        String[] ids = batchResults.getAllIDs();
        if (ids == null) {
            return;
        }
        if (BatchActionEnum.UNAUDIT.equals((Object)batchAction)) {
            StringBuffer idCol = new StringBuffer();
            idCol.append("(");
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    idCol.append("'").append(ids[i]).append("'");
                    continue;
                }
                idCol.append(",'").append(ids[i]).append("'");
            }
            idCol.append(")");
            String sql = "select FNumber from T_SM_PurPriceRelations where FID in (select distinct(FParentID) from T_SM_PurPriceRelationsEntry where FParentID in " + idCol + " and FIsUpdateASInfo = 1)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs != null && rs.size() != 0) {
                throw new PurPriceRelationsException(PurPriceRelationsException.QUO_ISUPDATEASINFO, new String[0]);
            }
        }
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchDelete(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurPriceRelationsInfo info = this.getPurPriceRelationsInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.DELETE);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        block30: {
            Object[] pks;
            block31: {
                block29: {
                    pks = batchResults.getToDoPkArray();
                    if (pks.length == 0) {
                        return;
                    }
                    if (!BatchActionEnum.AUDIT.equals((Object)batchAction)) break block29;
                    this.checkAudit(ctx, (IObjectPK[])pks);
                    StringBuffer params = new StringBuffer();
                    int c = pks.length;
                    for (int i = 0; i < c; ++i) {
                        if (i > 0) {
                            params.append(",");
                        }
                        params.append("'");
                        params.append(pks[i].toString());
                        params.append("'");
                    }
                    StringBuffer strSQL = new StringBuffer();
                    String sp = " \r\n";
                    strSQL.append("update T_SM_PurPriceRelations set FBaseStatus =4,FAuditorId='");
                    strSQL.append(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                    strSQL.append("',FAuditTime = getDate() where fid in(").append(sp);
                    strSQL.append(params.toString());
                    strSQL.append(");");
                    DbUtil.execute((Context)ctx, (String)strSQL.toString());
                    StringBuffer strEntrySQL = new StringBuffer();
                    strEntrySQL.append("update T_SM_PurPriceRelationsEntry set FBaseStatus =4 where fparentid in(").append(sp);
                    strEntrySQL.append(params.toString());
                    strEntrySQL.append(");");
                    DbUtil.execute((Context)ctx, (String)strEntrySQL.toString());
                    this.UpdatePurQuotation(ctx, params);
                    Connection con = null;
                    Statement batchStatement = null;
                    try {
                        con = this.getConnection(ctx);
                        ObjectUuidPK[] qUpdateASInfoPks = null;
                        ObjectUuidPK[] qUpdateASInfoPurOrgPks = null;
                        ObjectUuidPK[] qUpdateASInfoMaterialpks = null;
                        String checkSql = "select entry.fsourcebillentryid from t_sm_purpricerelationsentry entry left join t_sm_purpricerelations bill on entry.fparentid=bill.FID where entry.fparentid in (" + params.toString() + ") and entry.FSupplierAffirm =1 and entry.fsourcebillid is not null";
                        IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                        int i = 0;
                        while (checkSet.next()) {
                            ++i;
                        }
                        if (i > 0) {
                            ObjectUuidPK[] qPks = new ObjectUuidPK[i];
                            i = 0;
                            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                            while (checkSet.next()) {
                                qPks[i] = new ObjectUuidPK(checkSet.getString(1));
                                ++i;
                            }
                            IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
                            iPurQuotation.audit((IObjectPK[])qPks);
                        }
                        checkSql = "select fsourcebillentryid from t_sm_purpricerelationsentry where fparentid in (" + params.toString() + ") and FSupplierAffirm =-1 and fsourcebillid is not null";
                        checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                        i = 0;
                        while (checkSet.next()) {
                            ++i;
                        }
                        if (i > 0) {
                            IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
                            ObjectUuidPK[] qPks = new ObjectUuidPK[i];
                            i = 0;
                            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                            while (checkSet.next()) {
                                qPks[i] = new ObjectUuidPK(checkSet.getString(1));
                                ++i;
                            }
                            iPurQuotation.calcel((IObjectPK[])qPks);
                        }
                        checkSql = "select entry.FID,bill.FPurOrgUnitID, entry.FMaterialID from t_sm_purpricerelationsentry entry left join  t_sm_purpricerelations bill on bill.FId=entry.FparentID where entry.fparentid in (" + params.toString() + ") and entry.FPriceRelationResult =1 ";
                        checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                        i = 0;
                        while (checkSet.next()) {
                            ++i;
                        }
                        if (i > 0) {
                            qUpdateASInfoPks = new ObjectUuidPK[i];
                            qUpdateASInfoPurOrgPks = new ObjectUuidPK[i];
                            qUpdateASInfoMaterialpks = new ObjectUuidPK[i];
                            i = 0;
                            checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
                            while (checkSet.next()) {
                                qUpdateASInfoPks[i] = new ObjectUuidPK(checkSet.getString(1));
                                qUpdateASInfoPurOrgPks[i] = new ObjectUuidPK(checkSet.getString(2));
                                if (checkSet.getString(3) != null) {
                                    qUpdateASInfoMaterialpks[i] = new ObjectUuidPK(checkSet.getString(3));
                                }
                                ++i;
                            }
                        }
                        boolean isUpdateASInfo = false;
                        if (qUpdateASInfoPks != null && qUpdateASInfoPks.length > 0) {
                            for (int m = 0; m < qUpdateASInfoPks.length; ++m) {
                                ObjectUuidPK purOrgpk;
                                isUpdateASInfo = false;
                                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                                String strUpdateASInfo = ipc.getParamValue((IObjectPK)(purOrgpk = new ObjectUuidPK(qUpdateASInfoPurOrgPks[m].toString())), "PURQUOT002");
                                if (strUpdateASInfo != null && strUpdateASInfo.trim().length() != 0 && strUpdateASInfo.trim().equalsIgnoreCase("true") && qUpdateASInfoMaterialpks != null && qUpdateASInfoMaterialpks[m] != null) {
                                    isUpdateASInfo = true;
                                }
                                if (!isUpdateASInfo) continue;
                                IPurPriceRelationsEntry iPurPriceRelationsEntry = PurPriceRelationsEntryFactory.getLocalInstance(ctx);
                                iPurPriceRelationsEntry.createApprovedSupplier((IObjectPK)qUpdateASInfoPks[m]);
                            }
                        }
                    }
                    catch (EASBizException er) {
                        throw er;
                    }
                    catch (Exception er) {
                        throw new BOSException((Throwable)er);
                    }
                    finally {
                        SQLUtils.cleanup(batchStatement, (Connection)con);
                        SQLUtils.cleanup((Connection)con);
                    }
                    for (Object pk : pks) {
                        this.setPurQuotationPlan((IObjectPK)pk, ctx);
                    }
                    break block30;
                }
                if (!BatchActionEnum.UNAUDIT.equals((Object)batchAction)) break block31;
                PurPriceRelationsInfo info = null;
                int size = pks.length;
                for (int i = 0; i < size; ++i) {
                    Object pk = pks[i];
                    info = PurPriceRelationsFactory.getLocalInstance(ctx).getPurPriceRelationsInfo((IObjectPK)pk);
                    SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)info);
                    this.isSamePerson4UnAudit(ctx, info);
                }
                StringBuffer params = new StringBuffer();
                int c = pks.length;
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        params.append(",");
                    }
                    params.append("'");
                    params.append(pks[i].toString());
                    params.append("'");
                }
                StringBuffer strSQL = new StringBuffer();
                String sp = " \r\n";
                strSQL.append("update T_SM_PurPriceRelations set FBaseStatus =1,FAuditorId=null,FAuditTime = null where fid in(").append(sp);
                strSQL.append(params.toString());
                strSQL.append(");");
                DbUtil.execute((Context)ctx, (String)strSQL.toString());
                StringBuffer strEntrySQL = new StringBuffer();
                strEntrySQL.append("update T_SM_PurPriceRelationsEntry set FBaseStatus =1,FIsUpdateASInfo=0 where fparentid in(").append(sp);
                strEntrySQL.append(params.toString());
                strEntrySQL.append(");");
                DbUtil.execute((Context)ctx, (String)strEntrySQL.toString());
                this.UpdatePurQuotation(ctx, params);
                for (Object pk : pks) {
                    this.UpdatePurQuotationPlan(ctx, (IObjectPK)pk);
                }
                break block30;
            }
            if (!BatchActionEnum.DELETE.equals((Object)batchAction)) break block30;
            StringBuffer params = new StringBuffer();
            params.append(StringUtil.getKeyIdList((Object[])pks));
            StringBuffer strSQL = new StringBuffer();
            String sp = " \r\n";
            strSQL.append(" UPDATE T_SM_PurQuotation SET FBASESTATUS =").append(4);
            strSQL.append(" WHERE FBASESTATUS = ").append(7);
            strSQL.append(" and FPURQUOTATIONPLANID  in");
            strSQL.append(" (SELECT FQUOTATIONPLANID  FROM t_sm_purpricerelations where FID in (").append(sp);
            strSQL.append(params);
            strSQL.append("))");
            DbUtil.execute((Context)ctx, (String)strSQL.toString());
            strSQL.setLength(0);
            StringBuffer strEntrySQL = new StringBuffer();
            strEntrySQL.append(" UPDATE T_SM_PurQuotationentry SET FBASESTATUS =").append(4);
            strEntrySQL.append(" WHERE FBASESTATUS = ").append(7);
            strEntrySQL.append(" and FSOURCEBILLNUMBER in");
            strEntrySQL.append(" (SELECT FQUOTATIONPLANID  FROM t_sm_purpricerelations where FID in (").append(sp);
            strEntrySQL.append(params.toString());
            strEntrySQL.append("))");
            DbUtil.execute((Context)ctx, (String)strEntrySQL.toString());
            strEntrySQL.setLength(0);
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                super._delete(ctx, (IObjectPK)pks[i]);
            }
        }
    }

    private void setPurQuotationPlan(IObjectPK pk, Context ctx) throws EASBizException, BOSException {
        this.rowSet = null;
        StringBuffer sql = new StringBuffer();
        ArrayList<String> supplierList = new ArrayList<String>();
        ArrayList<String> sourceSEntryList = new ArrayList<String>();
        ArrayList<String> materialList = new ArrayList<String>();
        ArrayList<String> materialGroupList = new ArrayList<String>();
        ArrayList<String> materialNameList = new ArrayList<String>();
        ArrayList<String> paramList = new ArrayList<String>();
        String quotationplanId = null;
        Object material = null;
        Object materialGroup = null;
        Object materialName = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("quotationPlanID"));
        sql.append("select purpricerelations.fquotationplanid quotationplanid,purpricerelationsentry.FSupplierID supplierID,");
        sql.append("purpricerelationsentry.FPriceRelationResult priceRelationResult,purpricerelationsentry.FMaterialID materialID,");
        sql.append("purpricerelationsentry.FMaterialGroupID materialGroupID,purpricerelationsentry.FMaterialName materialName, ");
        sql.append("purpricerelationsentry.FSourceBillSEntryID sourceBillSEntryID ");
        sql.append("from t_sm_purpricerelationsentry purpricerelationsentry left outer join t_sm_purpricerelations purpricerelations on purpricerelations.fid=purpricerelationsentry.fparentid  where fparentid = '" + pk + "' ");
        this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (this.rowSet.next()) {
                quotationplanId = this.rowSet.getString("quotationplanid");
                material = this.rowSet.getObject("materialID");
                materialGroup = this.rowSet.getObject("materialGroupID");
                materialName = this.rowSet.getObject("materialName");
                if (this.rowSet.getInt("priceRelationResult") != 1) continue;
                supplierList.add(this.rowSet.getString("supplierID"));
                sourceSEntryList.add(this.rowSet.getString("sourceBillSEntryID"));
                if (material != null) {
                    materialList.add(material.toString());
                } else {
                    materialList.add(null);
                }
                if (materialGroup != null) {
                    materialGroupList.add(materialGroup.toString());
                } else {
                    materialGroupList.add(null);
                }
                if (materialName != null && material == null) {
                    materialNameList.add(materialName.toString());
                } else {
                    materialNameList.add(null);
                }
                sql.delete(0, sql.length());
                sql.append("update T_SM_PurQuotationEntry set fpriceRelResult=? ");
                sql.append(" where FParentID in (select fid from T_SM_PurQuotation where FPurQuoTationPlanID=? and FSupplierID=?) ");
                paramList.add("1");
                paramList.add(quotationplanId);
                paramList.add(this.rowSet.getString("supplierID"));
                if (material != null) {
                    sql.append(" and  FMaterialID=?");
                    paramList.add(material.toString());
                } else if (materialGroup != null) {
                    sql.append(" and  FMaterialGroupID=?");
                    paramList.add(materialGroup.toString());
                } else if (materialName != null) {
                    sql.append(" and  FMaterialName=?");
                    paramList.add(materialName.toString());
                }
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                paramList.clear();
            }
            sql.delete(0, sql.length());
            for (int index = 0; index < supplierList.size(); ++index) {
                this.rowSet = null;
                sql.append("select fid from t_sm_purquoplanmentry where FParentID in (select fid from T_SM_PurQuotationPlan where fnumber='" + quotationplanId + "')");
                if (materialList.get(index) != null) {
                    sql.append(" and  fmaterialid='" + materialList.get(index).toString() + "'");
                } else if (materialGroupList.get(index) != null) {
                    sql.append(" and  FMaterialGroupID='" + materialGroupList.get(index).toString() + "'");
                } else if (materialNameList.get(index) != null) {
                    sql.append(" and  FMaterialName='" + materialNameList.get(index).toString() + "'");
                }
                this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                sql.delete(0, sql.length());
                while (this.rowSet.next()) {
                    sql.append("update T_SM_PurQuoPlanSEntry set FIsSelected=? ");
                    sql.append(" where fsupplierid=? and FID=?");
                    paramList.add("1");
                    paramList.add(supplierList.get(index).toString());
                    paramList.add(sourceSEntryList.get(index).toString());
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                    sql.delete(0, sql.length());
                    paramList.clear();
                }
            }
            this.rowSet = null;
            sql.append("select fid from T_SM_PurQuotationPlan where fnumber='" + quotationplanId + "'");
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.delete(0, sql.length());
            while (this.rowSet.next()) {
                sql.append("update t_sm_purquoplanmentry set FHasComparison=?");
                sql.append(" where FParentID=?");
                paramList.add("1");
                paramList.add(this.rowSet.getString("fid"));
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                sql.delete(0, sql.length());
                paramList.clear();
            }
            sql.append("update t_sm_purquotationplan  set fbasestatus=? ");
            sql.append("where Fnumber=?");
            paramList.add("7");
            paramList.add(quotationplanId);
            DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            paramList.clear();
            IPurPriceRelations iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
            PurPriceRelationsInfo purPriceRelationsInfo = iPurPriceRelations.getPurPriceRelationsInfo(pk, selector);
            this.rowSet = null;
            sql.delete(0, sql.length());
            sql.append("select FBaseStatus from T_SM_PurQuotation where FPurQuotationPlanID='" + purPriceRelationsInfo.getQuotationPlanID() + "'");
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            sql.delete(0, sql.length());
            while (this.rowSet.next()) {
                if (this.rowSet.getInt("FBaseStatus") != 4 && this.rowSet.getInt("FBaseStatus") != -2) {
                    sql.append("update T_SM_PurQuotation set FBaseStatus=?");
                    sql.append(" where FPurQuotationPlanID=? and FBaseStatus in (1,2,10,11) ");
                    paramList.add(String.valueOf(3));
                    paramList.add(purPriceRelationsInfo.getQuotationPlanID());
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                    sql.delete(0, sql.length());
                    paramList.clear();
                    continue;
                }
                if (this.rowSet.getInt("FBaseStatus") == 4) {
                    sql.append("update T_SM_PurQuotation set FBaseStatus=?");
                    sql.append(" where FPurQuotationPlanID=? and FBaseStatus=4");
                    paramList.add(String.valueOf(7));
                    paramList.add(purPriceRelationsInfo.getQuotationPlanID());
                    DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                    sql.delete(0, sql.length());
                    paramList.clear();
                    continue;
                }
                if (this.rowSet.getInt("FBaseStatus") != -2) continue;
                sql.append("update T_SM_PurQuotation set FBaseStatus=?");
                sql.append(" where FPurQuotationPlanID=? and FBaseStatus=-2");
                paramList.add(String.valueOf(7));
                paramList.add(purPriceRelationsInfo.getQuotationPlanID());
                DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
                sql.delete(0, sql.length());
                paramList.clear();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        IPurQuotationPlan iPurQuotationPlan = PurQuotationPlanFactory.getLocalInstance(ctx);
        this.iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
        this.purPriceRelationsInfo = this.iPurPriceRelations.getPurPriceRelationsInfo(pk, selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.purPriceRelationsInfo.getQuotationPlanID().toString(), CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseStatus"));
        ObjectUuidPK uuidPK = null;
        PurQuotationPlanInfo purQuotationPlanInfo = null;
        PurQuotationPlanCollection purQuotationPlanColl = iPurQuotationPlan.getPurQuotationPlanCollection(viewInfo);
        if (purQuotationPlanColl != null && purQuotationPlanColl.size() > 0) {
            for (int k = 0; k < purQuotationPlanColl.size(); ++k) {
                purQuotationPlanInfo = purQuotationPlanColl.get(k);
                purQuotationPlanInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
                uuidPK = new ObjectUuidPK(purQuotationPlanInfo.getId());
                iPurQuotationPlan.update((IObjectPK)uuidPK, purQuotationPlanInfo);
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("purOrgUnit.id"));
        selector.add(new SelectorItemInfo("auditor.id"));
        PurQuotationPlanInfo info = (PurQuotationPlanInfo)this.getValue(ctx, pk, selector);
        this.isSamePerson4UnAudit(ctx, info);
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._unAudit(ctx, pks);
        this.UpdatePurQuotationPlan(ctx, pk);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            PurPriceRelationsInfo purInfo = PurPriceRelationsFactory.getLocalInstance(ctx).getPurPriceRelationsInfo(pks[j]);
            SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)purInfo);
        }
        StringBuffer params = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            params.append("'");
            params.append(pks[i].toString());
            params.append("'");
        }
        StringBuffer strSQL = new StringBuffer();
        String sp = " \r\n";
        strSQL.append("update T_SM_PurPriceRelations set FBaseStatus =1,FAuditorId=null,FAuditTime = null where fid in(").append(sp);
        strSQL.append(params.toString());
        strSQL.append(");");
        DbUtil.execute((Context)ctx, (String)strSQL.toString());
        StringBuffer strEntrySQL = new StringBuffer();
        strEntrySQL.append("update T_SM_PurPriceRelationsEntry set FBaseStatus =1,FIsUpdateASInfo=0 where fparentid in(").append(sp);
        strEntrySQL.append(params.toString());
        strEntrySQL.append(");");
        DbUtil.execute((Context)ctx, (String)strEntrySQL.toString());
        this.UpdatePurQuotation(ctx, params);
    }

    @Override
    protected BTPTransformResult _makeBill(Context ctx, EntityViewInfo entityViewInfo) throws BOSException, EASBizException {
        entityViewInfo.getSelector().addObjectCollection((IObjectCollection)this.getPurQuotationBOTPSelectors());
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        PurQuotationCollection aPurQuotationCollection = iPurQuotation.getPurQuotationCollection(entityViewInfo);
        IBTPManager iBTPManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        CoreBillBaseCollection billCollection = new CoreBillBaseCollection();
        int count = aPurQuotationCollection.size();
        for (int i = 0; i < count; ++i) {
            if (aPurQuotationCollection.get(i).getEntries().size() <= 0) continue;
            billCollection.add((CoreBillBaseInfo)aPurQuotationCollection.get(i));
        }
        if (billCollection.size() > 0) {
            BTPTransformResult btpResult = iBTPManager.transformMultiBill(billCollection, "AC85D92F");
            return btpResult;
        }
        return null;
    }

    private SelectorItemCollection getPurQuotationBOTPSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("deliveryType.id"));
        sic.add(new SelectorItemInfo("deliveryType.number"));
        sic.add(new SelectorItemInfo("deliveryType.name"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("currency.number"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("currency.precision"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseGroup.id"));
        sic.add(new SelectorItemInfo("purchaseGroup.number"));
        sic.add(new SelectorItemInfo("purchaseGroup.name"));
        sic.add(new SelectorItemInfo("purchasePerson.id"));
        sic.add(new SelectorItemInfo("purchasePerson.number"));
        sic.add(new SelectorItemInfo("purchasePerson.name"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.basictype.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.compondingtype.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseQtyFrom"));
        sic.add(new SelectorItemInfo("entries.baseQtyTo"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.qtyFrom"));
        sic.add(new SelectorItemInfo("entries.qtyTo"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.taxRate"));
        sic.add(new SelectorItemInfo("entries.taxPrice"));
        sic.add(new SelectorItemInfo("entries.discount"));
        sic.add(new SelectorItemInfo("entries.actualTaxPrice"));
        sic.add(new SelectorItemInfo("entries.actualPrice"));
        sic.add(new SelectorItemInfo("entries.baseLocalActualPrice"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.isAffirm"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modificationTime"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("enabledDate"));
        sic.add(new SelectorItemInfo("disibleDate"));
        sic.add(new SelectorItemInfo("baseStatus"));
        return sic;
    }

    @Override
    protected IRowSet _getEentryIDByMaterialID(Context ctx, String materialID, String materialGroupID, String materialName, String fid) throws BOSException {
        this.rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FSupplierID, FAssistProPertyID, FBaseUnitLocalPrice, FcurrencyID, FExchangeRate, \n");
        sql.append(" FUnitID, FActualTaxPrice, FActualPrice, FQtyFrom, FQtyTo, FLocalAmountFrom, \n ");
        sql.append(" FLocalAmountTo, Fremark, FPrice, FTaxRate, FTaxPrice, FDiscountType, FDiscount, \n ");
        sql.append(" FPayMentTypeID, FPaymentConditionID, FMoney, FTaxation, FPriceTaxTotal, \n ");
        sql.append(" FstandardCurrencyTotal, FpurAdvance, FinsureQualityDate,FenabledDate, \n ");
        sql.append(" FunEffectiveTime, Fcarriage, FincidentalExpenses, FpackagingExp, fid, \n ");
        sql.append(" FMaterialGroupID, FMaterialID, FmaterialName \n ");
        sql.append(" from T_SM_PurPriceRelationsEntry where ");
        if (materialID != null) {
            sql.append("fMaterialID='" + materialID + "' and fparentid='" + fid + "'");
        } else if (materialGroupID != null) {
            sql.append("FmaterialGroupID='" + materialGroupID + "' and fparentid='" + fid + "'");
        } else if (materialName != null) {
            sql.append("(FmaterialName='" + materialName + "' and fparentid='" + fid + "') and fMaterialID is null");
        }
        try {
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.rowSet;
    }

    protected IRowSet getMaterialAndSuppierByID(String id, Context ctx) throws BOSException {
        this.rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select purquoplanmentry.fsourcebillnumber requestNumber,purquoplanmentry.fsourcebillentryseq requestSeq,purquoplansentry.fsupplierid supplierId,");
        sql.append("purquoplanmentry.fpurrequestId purRequestID,purquoplanmentry.fpurrequestentryId purRequestEntryID,");
        sql.append("purquoplanmentry.FStorageOrgUnitID storageOrgUnitID,purquoplanmentry.FReceivedOrgUnitID receivedOrgUnitID,");
        sql.append("purquoplanmentry.fid meid,purquoplanmentry.fseq meseq,");
        sql.append("purquoplansentry.fid seid,");
        sql.append("purquotationplan.fid pid,purquotationplan.fnumber pnumber,");
        sql.append("purquoplanmentry.frowtypeid rowTypeId,purquoplanmentry.fmaterialgroupid materialgroupId,purquoplanmentry.fmaterialid materialId,purquoplanmentry.fmaterialname materialName,purquoplanmentry.fnoNumMaterialModel noNumMaterialModel,purquoplanmentry.fassistpropertyid assistPropertyId,purquoplansentry.fcurrencyid currencyId,purquoplansentry.fexchangerate exChangerate,purquoplanmentry.funitid unitId,purquoplanmentry.fbaseunitid baseUnitId,purquoplanmentry.fbaseqty baseQty,purquoplansentry.factualprice actualPrice,purquoplansentry.factualtaxprice actualTaxPrice,purquoplansentry.fqty qtyFrom,purquoplansentry.fqtyto qtyTo,purquoplanmentry.FDeliveryStyle deliveryStyle,purquoplanmentry.fdeliverydate deliveryDate,purquoplanmentry.fdeliveryaddress deliveryAddress,purquoplanmentry.fremark remark,purquoplansentry.fprice price,purquoplansentry.ftaxrate taxRate,purquoplansentry.ftaxprice taxPrice,purquoplanmentry.fqty qty,purquoplansentry.fdiscount discount,purquoplansentry.fdiscountstyle disconnectStyle,purquoplansentry.fpaymentconditionid payMentCondition,purquoplansentry.fpaymentsytleid payMentSytle,purquoplansentry.fpurleadtime purLeadTime,purquoplansentry.fwarrantydate warrantDate,purquoplansentry.fenabledate enableDate,purquoplansentry.fdisibledate disableDate,purquoplansentry.fpackageprice packagePrice,purquoplansentry.fcarriageprice carriagePrice,purquoplansentry.fmiscellaneous miscellaneous,purquotationplan.FIsTaxInclude isTaxInclude ,purquoplanmentry.FProjectID projectId,purquoplanmentry.FTrackNumberID trackNumberId, purquoplanmentry.FAssistUnitID assistunitid ");
        sql.append("from t_sm_purquoplanmentry purquoplanmentry ");
        sql.append("left outer join t_Sm_Purquoplansentry  purquoplansentry on purquoplanmentry.fid = Purquoplansentry.Fparentid ");
        sql.append("left outer join t_sm_purquotationplan purquotationplan on purquotationplan.fid = purquoplanmentry.fparentid ");
        sql.append("where purquotationplan.FNumber='" + id + "' ");
        sql.append("order by purquoplanmentry.fmaterialgroupid ,purquoplanmentry.fmaterialid ,purquoplanmentry.fmaterialname ");
        try {
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return this.rowSet;
    }

    protected void buidPriceRelationsEntry(PurPriceRelationsInfo info, Context ctx) throws Exception {
        this.rowSet = null;
        this.rowSet = this.getMaterialAndSuppierByID(info.getQuotationPlanID(), ctx);
        this.iPurPriceRelations = PurPriceRelationsFactory.getLocalInstance(ctx);
        this.iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        CurrencyInfo baseCurrInfo = null;
        if (info.getPurOrgUnit() != null) {
            CompanyOrgUnitInfo ficompanyOrgInfo = (CompanyOrgUnitInfo)OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(info.getPurOrgUnit().getId().toString(), 3, 1).get(0);
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
        }
        IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
        RowTypeInfo rowTypeInfo = null;
        PurPriceRelationsEntryInfo entryInfo = null;
        SupplierInfo supplierInfo = null;
        ISupplier iSupplier = SupplierFactory.getLocalInstance((Context)ctx);
        CurrencyInfo currencyInfo = null;
        ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo unitInfo = null;
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        MeasureUnitInfo assitantUnitInfo = null;
        PaymentTypeInfo paymentTypeInfo = null;
        IPaymentType iPaymentType = PaymentTypeFactory.getLocalInstance((Context)ctx);
        PayConditionInfo payConditionInfo = null;
        IPayCondition iPayCondition = PayConditionFactory.getLocalInstance((Context)ctx);
        MaterialInfo materialInfo = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        AsstAttrValueInfo asstAttrValueInfo = null;
        IAsstAttrValue iAsstAttrValue = AsstAttrValueFactory.getLocalInstance((Context)ctx);
        MaterialGroupInfo materialGroupInfo = null;
        IMaterialGroup iMaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
        ProjectInfo projectInfo = null;
        IProject iProject = ProjectFactory.getLocalInstance((Context)ctx);
        TrackNumberInfo trackNumberInfo = null;
        ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
        BigDecimal qtyFrom = new BigDecimal(0);
        BigDecimal qtyTo = new BigDecimal(0);
        BigDecimal qty = new BigDecimal(0);
        BigDecimal price = new BigDecimal(0);
        BigDecimal taxRate = new BigDecimal(0);
        BigDecimal taxPrice = new BigDecimal(0);
        BigDecimal baseUnitLocalPrice = new BigDecimal(0);
        BigDecimal exChangerate = new BigDecimal(0);
        BigDecimal money = new BigDecimal(0);
        BigDecimal taxation = new BigDecimal(0);
        BigDecimal discount = new BigDecimal(0);
        BigDecimal localCurrencyTotal = new BigDecimal(0);
        BigDecimal actualPrice = new BigDecimal(0);
        BigDecimal carriage = new BigDecimal(0);
        BigDecimal packagingExp = new BigDecimal(0);
        BigDecimal incidentalExpenses = new BigDecimal(0);
        int precision = 4;
        while (this.rowSet.next()) {
            entryInfo = new PurPriceRelationsEntryInfo();
            if (!UIRuleUtil.isNotNull((Object)this.rowSet.getObject("rowTypeId"))) continue;
            entryInfo.setPurRequestNumber(this.rowSet.getString("requestNumber"));
            entryInfo.setPurRequestSeq(this.rowSet.getInt("requestSeq"));
            if (this.rowSet.getString("purRequestID") != null) {
                entryInfo.setPurRequestID(this.rowSet.getString("purRequestID"));
            }
            if (this.rowSet.getString("seid") != null) {
                entryInfo.setSourceBillSEntryID(this.rowSet.getString("seid"));
            }
            if (this.rowSet.getString("purRequestEntryID") != null) {
                entryInfo.setPurRequestEntryID(this.rowSet.getString("purRequestEntryID"));
            }
            if (this.rowSet.getString("storageOrgUnitID") != null) {
                StorageOrgUnitInfo storageOrgUnit = new StorageOrgUnitInfo();
                storageOrgUnit.setId(BOSUuid.read((String)this.rowSet.getString("storageOrgUnitID")));
                entryInfo.setStorageOrgUnit(storageOrgUnit);
            }
            if (this.rowSet.getString("receivedOrgUnitID") != null) {
                StorageOrgUnitInfo receivedOrgUnit = new StorageOrgUnitInfo();
                receivedOrgUnit.setId(BOSUuid.read((String)this.rowSet.getString("receivedOrgUnitID")));
                entryInfo.setReceivedOrgUnit(receivedOrgUnit);
            }
            supplierInfo = iSupplier.getSupplierInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("supplierId"))));
            entryInfo.setSupplier(supplierInfo);
            rowTypeInfo = iRowType.getRowTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("rowTypeId")).toString()));
            entryInfo.setRowType(rowTypeInfo);
            currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("currencyId"))));
            entryInfo.setCurrency(currencyInfo);
            if (this.rowSet.getString("projectId") != null && this.rowSet.getString("projectId").toString().length() > 0) {
                projectInfo = iProject.getProjectInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("projectId"))));
                entryInfo.setProject(projectInfo);
            }
            if (this.rowSet.getString("trackNumberId") != null && this.rowSet.getString("trackNumberId").toString().length() > 0) {
                trackNumberInfo = iTrackNumber.getTrackNumberInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("trackNumberId"))));
                entryInfo.setTrackNumber(trackNumberInfo);
            }
            exChangerate = this.rowSet.getBigDecimal("exChangerate");
            entryInfo.setExchangeRate(exChangerate);
            unitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("unitId"))));
            entryInfo.setUnit(unitInfo);
            if (this.rowSet.getString("assistunitid") != null && !this.rowSet.getString("assistunitid").equals("")) {
                assitantUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("assistunitid"))));
                entryInfo.setAssistUnit(assitantUnitInfo);
            }
            actualPrice = this.rowSet.getBigDecimal("actualPrice");
            entryInfo.setActualPrice(actualPrice);
            entryInfo.setActualTaxPrice(this.rowSet.getBigDecimal("actualTaxPrice"));
            qtyFrom = this.rowSet.getBigDecimal("qtyFrom");
            entryInfo.setQtyFrom(qtyFrom);
            qtyTo = this.rowSet.getBigDecimal("qtyTo");
            entryInfo.setQtyTo(this.rowSet.getBigDecimal("qtyTo"));
            entryInfo.setDeliveryType(DeliveryStyleEnum.getEnum(this.rowSet.getString("deliveryStyle")));
            entryInfo.setConsignmentDate(this.rowSet.getTimestamp("deliveryDate"));
            entryInfo.setConsignmentAddress(this.rowSet.getString("deliveryAddress"));
            entryInfo.setRemark(this.rowSet.getString("remark"));
            price = this.rowSet.getBigDecimal("price");
            entryInfo.setPrice(price);
            taxRate = this.rowSet.getBigDecimal("taxRate");
            entryInfo.setTaxRate(taxRate);
            taxRate = taxRate.multiply(new BigDecimal("0.01"));
            taxPrice = this.rowSet.getBigDecimal("taxPrice");
            entryInfo.setTaxPrice(taxPrice);
            qty = new BigDecimal(this.rowSet.getString("qty"));
            entryInfo.setQty(qty);
            discount = this.rowSet.getBigDecimal("discount");
            entryInfo.setDiscount(this.rowSet.getBigDecimal("discount"));
            int discountType = this.rowSet.getInt("disconnectStyle");
            if (discountType == 0) {
                entryInfo.setDiscountType(DisCountStyleEnum.DISCOUNTRATE);
            } else if (discountType == 1) {
                entryInfo.setDiscountType(DisCountStyleEnum.DISCOUNTUNIT);
            }
            if (this.rowSet.getString("payMentSytle") != null && this.rowSet.getString("payMentSytle").length() > 0) {
                paymentTypeInfo = iPaymentType.getPaymentTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("payMentSytle"))));
                entryInfo.setPaymentType(paymentTypeInfo);
            }
            if (this.rowSet.getString("payMentCondition") != null && this.rowSet.getString("payMentCondition").length() > 0) {
                payConditionInfo = iPayCondition.getPayConditionInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("payMentCondition"))));
                entryInfo.setPaymentCondition(payConditionInfo);
            }
            entryInfo.setPurAdvance(this.rowSet.getBigDecimal("purLeadTime"));
            entryInfo.setInsureQualityDate(this.rowSet.getBigDecimal("warrantDate"));
            entryInfo.setEnabledDate(this.rowSet.getTimestamp("enableDate"));
            entryInfo.setUnEffectiveTime(this.rowSet.getTimestamp("disableDate"));
            if (this.rowSet.getBigDecimal("carriagePrice") != null) {
                carriage = this.rowSet.getBigDecimal("carriagePrice");
            }
            if (this.rowSet.getBigDecimal("carriagePrice") != null) {
                entryInfo.setCarriage(this.rowSet.getBigDecimal("carriagePrice"));
            }
            if (this.rowSet.getBigDecimal("packagePrice") != null) {
                packagingExp = this.rowSet.getBigDecimal("packagePrice");
            }
            if (this.rowSet.getBigDecimal("packagePrice") != null) {
                entryInfo.setPackagingExp(this.rowSet.getBigDecimal("packagePrice"));
            }
            if (this.rowSet.getBigDecimal("miscellaneous") != null) {
                incidentalExpenses = this.rowSet.getBigDecimal("miscellaneous");
            }
            if (this.rowSet.getBigDecimal("miscellaneous") != null) {
                entryInfo.setIncidentalExpenses(this.rowSet.getBigDecimal("miscellaneous"));
            }
            precision = rowTypeInfo.getPrecision();
            if (rowTypeInfo.isIsHasMaterialNumber()) {
                if (this.rowSet.getString("assistPropertyId") != null && this.rowSet.getString("assistPropertyId").length() > 0) {
                    asstAttrValueInfo = iAsstAttrValue.getAsstAttrValueInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("assistPropertyId"))));
                    entryInfo.setAssistProperty(asstAttrValueInfo);
                }
                if (UIRuleUtil.isNotNull((Object)this.rowSet.getObject("materialId"))) {
                    materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("materialId"))));
                    entryInfo.setMaterial(materialInfo);
                    entryInfo.setMaterialName(materialInfo.getName());
                    entryInfo.setNoNumMaterialModel(materialInfo.getModel());
                    entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                    precision = materialInfo.getPricePrecision();
                    baseUnitLocalPrice = this.countBaseUnitLocalPrice(precision, actualPrice, taxRate, materialInfo.getId().toString(), exChangerate, price, this.rowSet.getInt("isTaxInclude"), unitInfo.getId().toString(), ctx);
                    entryInfo.setBaseUnitLocalPrice(baseUnitLocalPrice);
                } else if (UIRuleUtil.isNotNull((Object)this.rowSet.getObject("materialgroupId"))) {
                    materialGroupInfo = iMaterialGroup.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("materialgroupId"))));
                    entryInfo.setMaterailGroup(materialGroupInfo);
                    baseUnitLocalPrice = this.countBaseUnitLocalPrice(precision, actualPrice, taxRate, null, exChangerate, price, this.rowSet.getInt("isTaxInclude"), unitInfo.getId().toString(), ctx);
                    entryInfo.setBaseUnitLocalPrice(baseUnitLocalPrice);
                    if (this.rowSet.getString("baseUnitId") != null) {
                        MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("baseUnitId"))));
                        if (baseUnitInfo != null) {
                            entryInfo.setBaseUnit(baseUnitInfo);
                        }
                    } else if (entryInfo.getUnit() != null) {
                        entryInfo.setBaseUnit(entryInfo.getUnit());
                    }
                    if (entryInfo.getQty() != null && this.rowSet.getBigDecimal("baseQty").compareTo(this.zero) == 0) {
                        entryInfo.setBaseQty(entryInfo.getQty());
                    }
                }
            } else if (this.rowSet.getObject("materialId") == null && this.rowSet.getObject("materialId") == null) {
                entryInfo.setMaterialName(this.rowSet.getString("materialName"));
                entryInfo.setNoNumMaterialModel(this.rowSet.getString("noNumMaterialModel"));
                baseUnitLocalPrice = this.countBaseUnitLocalPrice(precision, actualPrice, taxRate, null, exChangerate, price, this.rowSet.getInt("isTaxInclude"), unitInfo.getId().toString(), ctx);
                entryInfo.setBaseUnitLocalPrice(baseUnitLocalPrice);
                MeasureUnitInfo baseUnitInfo = null;
                if (this.rowSet.getString("baseUnitId") != null && this.rowSet.getString("baseUnitId").length() > 0) {
                    baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.rowSet.getString("baseUnitId"))));
                }
                if (baseUnitInfo != null) {
                    entryInfo.setBaseUnit(baseUnitInfo);
                } else {
                    entryInfo.setBaseUnit(entryInfo.getUnit());
                }
            }
            if (this.rowSet.getBigDecimal("baseQty") != null && this.rowSet.getBigDecimal("baseQty").compareTo(this.zero) > 0) {
                entryInfo.setBaseQty(this.rowSet.getBigDecimal("baseQty"));
            } else {
                entryInfo.setBaseQty(entryInfo.getQty());
            }
            int currPrecisioin = 2;
            if (currencyInfo != null) {
                currPrecisioin = currencyInfo.getPrecision();
            }
            int basecurrPrecisioin = 2;
            if (baseCurrInfo != null) {
                basecurrPrecisioin = baseCurrInfo.getPrecision();
            }
            entryInfo.setLocalAmountFrom(baseUnitLocalPrice.multiply(qtyFrom).setScale(basecurrPrecisioin, 4));
            entryInfo.setLocalAmountTo(baseUnitLocalPrice.multiply(qtyTo).setScale(basecurrPrecisioin, 4));
            if (info.isContainTax()) {
                BigDecimal priceTaxTotal = this.getMoney(qty, taxPrice, discount, discountType);
                entryInfo.setPriceTaxTotal(priceTaxTotal);
                taxation = this.getTaxationWhenInTax(priceTaxTotal, taxRate, currPrecisioin);
                taxation = taxation.setScale(currPrecisioin, 4);
                entryInfo.setTaxation(taxation);
                money = priceTaxTotal.subtract(taxation);
                money = money.setScale(currPrecisioin, 4);
                entryInfo.setMoney(money);
            } else {
                money = this.getMoney(qty, price, discount, this.rowSet.getInt("disconnectStyle"));
                money = money.setScale(currPrecisioin, 4);
                entryInfo.setMoney(money);
                taxation = this.getTaxation(money, taxRate).setScale(currPrecisioin, 4);
                entryInfo.setTaxation(taxation);
                entryInfo.setPriceTaxTotal(money.add(taxation));
            }
            localCurrencyTotal = this.getlocalTotal(money, packagingExp, carriage, incidentalExpenses, exChangerate);
            localCurrencyTotal = localCurrencyTotal.setScale(basecurrPrecisioin, 4);
            if (this.rowSet.getString("meid") != null) {
                entryInfo.setSourceBillEntryId(this.rowSet.getString("meid"));
            }
            entryInfo.setSourceBillEntrySeq(this.rowSet.getInt("meseq"));
            if (this.rowSet.getString("pid") != null) {
                entryInfo.setSourceBillId(this.rowSet.getString("pid"));
            }
            if (this.rowSet.getString("pnumber") != null) {
                entryInfo.setSourceBillNumber(this.rowSet.getString("pnumber"));
            }
            entryInfo.setStandardCurrencyTotal(localCurrencyTotal);
            info.getEntries().add(entryInfo);
        }
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        super._handleAfterTransform(ctx, action, collection);
        StringBuffer pks = new StringBuffer();
        try {
            PurPriceRelationsInfo purPriceRelationsInfo = null;
            for (int index = 0; index < collection.size(); ++index) {
                purPriceRelationsInfo = (PurPriceRelationsInfo)collection.getObject(index);
                purPriceRelationsInfo.setIsOnlySupplier(true);
                this.buidPriceRelationsEntry(purPriceRelationsInfo, ctx);
                pks.append("'").append(purPriceRelationsInfo.getQuotationPlanID().toString()).append("'");
                if (index == collection.size() - 1) continue;
                pks.append(",");
            }
            if ("SAVE".equals(action)) {
                String params = pks.toString();
                StringBuffer strSQL = new StringBuffer();
                strSQL.append(" UPDATE T_SM_PurQuotationEntry SET FBASESTATUS =").append(3);
                strSQL.append(" WHERE FPARENTID in (SELECT FID FROM T_SM_PurQuotation bill WHERE bill.FBASESTATUS!=");
                strSQL.append(4);
                strSQL.append(" and bill.FBASESTATUS!=").append(-2);
                strSQL.append(" AND bill.FPURQUOTATIONPLANID  in (");
                strSQL.append(params);
                strSQL.append("))");
                DbUtil.execute((Context)ctx, (String)strSQL.toString());
                strSQL.setLength(0);
                strSQL.append(" UPDATE T_SM_PurQuotation SET FBASESTATUS =").append(3);
                strSQL.append(" WHERE FBASESTATUS!=").append(4);
                strSQL.append(" and FBASESTATUS!=").append(-2);
                strSQL.append(" AND FPURQUOTATIONPLANID  in(");
                strSQL.append(params);
                strSQL.append(")");
                DbUtil.execute((Context)ctx, (String)strSQL.toString());
                strSQL.setLength(0);
                strSQL.append(" UPDATE T_SM_PurQuotationEntry SET FBASESTATUS =").append(7);
                strSQL.append(" WHERE FPARENTID in (SELECT FID FROM T_SM_PurQuotation bill WHERE (bill.FBASESTATUS=");
                strSQL.append(4);
                strSQL.append(" or bill.FBASESTATUS=").append(-2);
                strSQL.append(" )AND bill.FPURQUOTATIONPLANID  in(");
                strSQL.append(params);
                strSQL.append("))");
                DbUtil.execute((Context)ctx, (String)strSQL.toString());
                strSQL.setLength(0);
                strSQL.append(" UPDATE T_SM_PurQuotation SET FBASESTATUS =").append(7);
                strSQL.append(" WHERE (FBASESTATUS=").append(4);
                strSQL.append(" or FBASESTATUS=").append(-2);
                strSQL.append(" )AND FPURQUOTATIONPLANID  in(");
                strSQL.append(params);
                strSQL.append(")");
                DbUtil.execute((Context)ctx, (String)strSQL.toString());
                strSQL.setLength(0);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private BigDecimal countBaseUnitLocalPrice(int precision, BigDecimal actualPrice, BigDecimal taxRate, String materialID, BigDecimal exchangeRate, BigDecimal price, int isTax, String measureUnitID, Context ctx) throws EASBizException, BOSException {
        BigDecimal baseUnitLocalPrice = null;
        BigDecimal unitToBaseUnitRale = null;
        unitToBaseUnitRale = this.getBaseConvs(ctx, materialID, measureUnitID);
        baseUnitLocalPrice = actualPrice.divide(unitToBaseUnitRale, 8, 4).multiply(exchangeRate);
        baseUnitLocalPrice = baseUnitLocalPrice.setScale(precision, 4);
        return baseUnitLocalPrice;
    }

    private BigDecimal getMoney(BigDecimal qty, BigDecimal price, BigDecimal discount, int discountType) {
        BigDecimal money = null;
        BigDecimal discountMoney = null;
        if (discountType == 0) {
            discountMoney = discount.multiply(new BigDecimal("0.01"));
            money = qty.multiply(price).multiply(new BigDecimal(1).subtract(discountMoney));
        } else if (discountType == 1) {
            money = qty.multiply(price.subtract(discount));
        }
        return money;
    }

    private BigDecimal getTaxation(BigDecimal money, BigDecimal taxRate) {
        BigDecimal taxation = null;
        taxation = money.multiply(taxRate);
        return taxation;
    }

    private BigDecimal getTaxationWhenInTax(BigDecimal priceTaxTotal, BigDecimal taxRate, int currPrecisioin) {
        BigDecimal taxation = null;
        taxation = priceTaxTotal.divide(new BigDecimal("1").add(taxRate), currPrecisioin, 4).multiply(taxRate);
        return taxation;
    }

    private BigDecimal getlocalTotal(BigDecimal money, BigDecimal packagingExp, BigDecimal carriage, BigDecimal incidentalExpenses, BigDecimal exchangeRate) {
        BigDecimal localCurrencyTotal = null;
        localCurrencyTotal = money.add(packagingExp).add(carriage).add(incidentalExpenses).multiply(exchangeRate);
        return localCurrencyTotal;
    }

    private BigDecimal getBaseConvs(Context ctx, String materialID, String measureUnitID) throws BOSException, EASBizException {
        BigDecimal baseConvs = new BigDecimal("1.00");
        if (materialID == null && measureUnitID != null) {
            return baseConvs;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)new ObjectUuidPK(BOSUuid.read((String)measureUnitID)), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        this.measureUnitColl = this.iMultiMeasureUnit.getMultiMeasureUnitCollection(viewInfo);
        if (this.measureUnitColl != null && this.measureUnitColl.size() != 0) {
            baseConvs = this.measureUnitColl.get(0).getBaseConvsRate();
        }
        return baseConvs;
    }

    @Override
    protected IRowSet _getAllMterialPrice(Context ctx, IObjectValue modle, String fileName, String value) throws BOSException {
        PurPriceRelationsInfo purPriceRelationsInfo = (PurPriceRelationsInfo)modle;
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("select FMaterialGroupID,FMaterialID,FMaterialName,FRowTypeID,FStandardCurrencyTotal,FBaseUnitLocalPrice from T_SM_PurPriceRelationsEntry where FParentID='" + purPriceRelationsInfo.getId().toString() + "' and " + fileName + "='" + value + "'");
        this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlBuffer.toString());
        return this.rowSet;
    }

    @Override
    protected Map _batchCacheMatrialPrice(Context ctx, IObjectValue model, String fileName, Set values) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        HashMap map = new HashMap();
        this.purPriceRelationsInfo = (PurPriceRelationsInfo)model;
        String id = this.purPriceRelationsInfo.getId().toString();
        StringBuffer ids = new StringBuffer();
        String value = null;
        Iterator it = values.iterator();
        boolean hasNext = it.hasNext();
        ids.append("(");
        while (hasNext) {
            value = (String)it.next();
            ids.append("'").append(value).append("'");
            hasNext = it.hasNext();
            if (!hasNext) continue;
            ids.append(",");
        }
        ids.append(")");
        sql.append("select FMaterialGroupID,FMaterialID,FMaterialName,FRowTypeID,FStandardCurrencyTotal,FBaseUnitLocalPrice from T_SM_PurPriceRelationsEntry ").append("where FParentID='").append(id).append("' and ").append(fileName).append(" in ").append(ids).append(" order by ").append(fileName);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<BigDecimal> set = new HashSet<BigDecimal>();
        String oldValue = "";
        String currentValue = "";
        BigDecimal keyValue = new BigDecimal(0);
        IRowSet rowSet = null;
        try {
            boolean isNext = rs.next();
            while (isNext) {
                if (rs.getString(fileName) == null) continue;
                currentValue = rs.getString(fileName);
                keyValue = rs.getBigDecimal("FBaseUnitLocalPrice");
                rowSet = rs;
                isNext = rs.next();
                if (!oldValue.equals(currentValue)) {
                    if (!oldValue.equals("")) {
                        map.put(oldValue, set);
                    }
                    set = new HashSet();
                    set.add(keyValue);
                    oldValue = currentValue;
                    if (isNext) continue;
                    map.put(currentValue, set);
                    continue;
                }
                set.add(keyValue);
                oldValue = currentValue;
                if (isNext) continue;
                map.put(currentValue, set);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        long time2 = System.currentTimeMillis();
        logger.debug((Object)("\u6bd4\u4ef7\u5355\u6279\u91cf\u7f13\u5b58\u57fa\u672c\u8ba1\u91cf\u5355\u4f4d\u672c\u4f4d\u5e01\u5355\u4ef7_batchCacheMatrialPrice()\u65b9\u6cd5\u8017\u65f6\uff1a" + (time2 - time1)));
        return map;
    }

    @Override
    protected IRowSet _getEntrySeqByValue(Context ctx, String value, String fileName, String fid, String fileName2, String value2) throws BOSException {
        StringBuffer sql = new StringBuffer();
        BigDecimal value1 = new BigDecimal(value);
        if (fileName2.equals("FSupplierID")) {
            sql.append("select Fseq from T_SM_PurPriceRelationsEntry where FSuppStandardCurrencyTotal=" + value1.toString().trim() + " and");
            sql.append(" FParentID='" + fid + "'");
        } else {
            sql.append("select Fseq from T_SM_PurPriceRelationsEntry where " + fileName + "=" + value1.toString().trim() + " and");
            sql.append(" (FParentID='" + fid + "' and " + fileName2 + " is not null)");
        }
        try {
            this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.rowSet;
    }

    protected String getBillTypeId() {
        return "510b6503-0105-1000-e000-010bc0b814fd463ED552";
    }

    @Override
    protected void _updatePurReq(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("isUpdateRequest"));
        selector.add(new SelectorItemInfo("entries.priceRelationResult"));
        selector.add(new SelectorItemInfo("entries.purRequestEntryID"));
        selector.add(new SelectorItemInfo("entries.price"));
        selector.add(new SelectorItemInfo("entries.taxPrice"));
        selector.add(new SelectorItemInfo("entries.taxRate"));
        selector.add(new SelectorItemInfo("entries.actualPrice"));
        selector.add(new SelectorItemInfo("entries.actualTaxPrice"));
        selector.add(new SelectorItemInfo("entries.discount"));
        selector.add(new SelectorItemInfo("entries.exchangeRate"));
        selector.add(new SelectorItemInfo("entries.supplier"));
        PurPriceRelationsInfo info = PurPriceRelationsFactory.getLocalInstance(ctx).getPurPriceRelationsInfo(pk, selector);
        PurPriceRelationsEntryInfo entryInfo = null;
        PurRequestEntryInfo purRequestEntryInfo = null;
        PurRequestInfo purRequestInfo = null;
        boolean flag = false;
        selector.clear();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("qty"));
        selector.add(new SelectorItemInfo("currency"));
        selector.add(new SelectorItemInfo("currency.precision"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit"));
        selector.add(new SelectorItemInfo("exchangeRate"));
        selector.add(new SelectorItemInfo("price"));
        selector.add(new SelectorItemInfo("supplier"));
        selector.add(new SelectorItemInfo("amount"));
        selector.add(new SelectorItemInfo("localAmount"));
        selector.add(new SelectorItemInfo("taxPrice"));
        selector.add(new SelectorItemInfo("taxAmount"));
        selector.add(new SelectorItemInfo("localTaxAmount"));
        selector.add(new SelectorItemInfo("tax"));
        selector.add(new SelectorItemInfo("taxRate"));
        selector.add(new SelectorItemInfo("actualPrice"));
        selector.add(new SelectorItemInfo("actualTaxPrice"));
        selector.add(new SelectorItemInfo("discountRate"));
        selector.add(new SelectorItemInfo("discountAmount"));
        selector.add(new SelectorItemInfo("material.id"));
        selector.add(new SelectorItemInfo("material.pricePrecision"));
        selector.add(new SelectorItemInfo("parent.id"));
        selector.add(new SelectorItemInfo("parent.totalAmount"));
        selector.add(new SelectorItemInfo("parent.localTotalAmount"));
        selector.add(new SelectorItemInfo("parent.totalTax"));
        selector.add(new SelectorItemInfo("parent.localTotalTaxAmount"));
        selector.add(new SelectorItemInfo("parent.totalTaxAmount"));
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("price"));
        updateSelector.add(new SelectorItemInfo("supplier"));
        updateSelector.add(new SelectorItemInfo("amount"));
        updateSelector.add(new SelectorItemInfo("localAmount"));
        updateSelector.add(new SelectorItemInfo("taxPrice"));
        updateSelector.add(new SelectorItemInfo("taxAmount"));
        updateSelector.add(new SelectorItemInfo("localTaxAmount"));
        updateSelector.add(new SelectorItemInfo("tax"));
        updateSelector.add(new SelectorItemInfo("taxRate"));
        updateSelector.add(new SelectorItemInfo("actualPrice"));
        updateSelector.add(new SelectorItemInfo("actualTaxPrice"));
        updateSelector.add(new SelectorItemInfo("discountRate"));
        updateSelector.add(new SelectorItemInfo("discountAmount"));
        SelectorItemCollection updateRequestSelector = new SelectorItemCollection();
        updateRequestSelector.add(new SelectorItemInfo("totalAmount"));
        updateRequestSelector.add(new SelectorItemInfo("localTotalAmount"));
        updateRequestSelector.add(new SelectorItemInfo("tax"));
        updateRequestSelector.add(new SelectorItemInfo("localTotalTaxAmount"));
        updateRequestSelector.add(new SelectorItemInfo("totalTaxAmount"));
        BigDecimal relationRate = null;
        BigDecimal reqRate = null;
        BigDecimal price = null;
        BigDecimal taxPrice = null;
        BigDecimal totalLocalAmount = null;
        BigDecimal totalLocalTaxAmount = null;
        BigDecimal totalAmount = null;
        BigDecimal totalTaxAmount = null;
        BigDecimal totalTax = null;
        int pricePrecision = 2;
        SelectorItemCollection companyOrgUnitSelector = new SelectorItemCollection();
        int count = info.getEntries().size();
        for (int i = 0; i < count; ++i) {
            BigDecimal taxAmount;
            IOrgUnitRelation iUnitRel;
            CompanyOrgUnitInfo ret;
            entryInfo = info.getEntries().get(i);
            if (!entryInfo.getPriceRelationResult().equals((Object)PriceRelationsResultEnum.chose) || entryInfo.getPurRequestEntryID() == null) continue;
            relationRate = entryInfo.getExchangeRate();
            purRequestEntryInfo = this.getPurRequestEntryInfo(ctx, entryInfo.getPurRequestEntryID(), selector);
            purRequestInfo = purRequestEntryInfo.getParent();
            totalLocalAmount = purRequestInfo.getLocalTotalAmount();
            totalAmount = purRequestInfo.getTotalAmount();
            totalTaxAmount = purRequestInfo.getTotalTaxAmount();
            totalTax = purRequestInfo.getTotalTax();
            totalLocalTaxAmount = purRequestInfo.getLocalTotalTaxAmount();
            reqRate = purRequestEntryInfo.getExchangeRate();
            if (purRequestEntryInfo.getMaterial() != null) {
                pricePrecision = purRequestEntryInfo.getMaterial().getPricePrecision();
            }
            if ((ret = (CompanyOrgUnitInfo)(iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getDefaultToUnit(purRequestEntryInfo.getPurchaseOrgUnit().getId().toString(), 3, 1)) == null) {
                OrgUnitCollection orgCol = iUnitRel.getToUnit(purRequestEntryInfo.getPurchaseOrgUnit().getId().toString(), 3, 1);
                ret = (CompanyOrgUnitInfo)orgCol.get(0);
            }
            companyOrgUnitSelector.clear();
            companyOrgUnitSelector.add(new SelectorItemInfo("id"));
            companyOrgUnitSelector.add(new SelectorItemInfo("baseCurrency"));
            companyOrgUnitSelector.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ret.getId()), companyOrgUnitSelector);
            if (purRequestEntryInfo == null) continue;
            if (entryInfo.getPrice() != null) {
                price = entryInfo.getPrice().multiply(relationRate).divide(reqRate, pricePrecision, 4);
                purRequestEntryInfo.setPrice(price);
            }
            if (entryInfo.getTaxPrice() != null) {
                taxPrice = entryInfo.getTaxPrice().multiply(relationRate).divide(reqRate, pricePrecision, 4);
                purRequestEntryInfo.setTaxPrice(taxPrice);
            }
            if (entryInfo.getTaxRate() != null) {
                purRequestEntryInfo.setTaxRate(entryInfo.getTaxRate());
            }
            if (entryInfo.getActualPrice() != null) {
                BigDecimal actualPrice = entryInfo.getActualPrice().multiply(relationRate).divide(reqRate, pricePrecision, 4);
                purRequestEntryInfo.setActualPrice(actualPrice);
            }
            if (entryInfo.getActualTaxPrice() != null) {
                BigDecimal actualTaxPrice = entryInfo.getActualTaxPrice().multiply(relationRate).divide(reqRate, pricePrecision, 4);
                purRequestEntryInfo.setActualTaxPrice(actualTaxPrice);
            }
            if (entryInfo.getDiscount() != null) {
                purRequestEntryInfo.setDiscountRate(entryInfo.getDiscount());
            }
            if (purRequestEntryInfo.getQty() != null) {
                totalAmount = totalAmount.subtract(purRequestEntryInfo.getAmount());
                BigDecimal amount = purRequestEntryInfo.getQty().multiply(purRequestEntryInfo.getPrice()).setScale(purRequestEntryInfo.getCurrency().getPrecision(), 4);
                purRequestEntryInfo.setAmount(amount);
                totalAmount = totalAmount.add(amount);
                purRequestInfo.setTotalAmount(totalAmount);
            }
            if (purRequestEntryInfo.getQty() != null) {
                totalTaxAmount = totalTaxAmount.subtract(purRequestEntryInfo.getTaxAmount());
                taxAmount = purRequestEntryInfo.getQty().multiply(purRequestEntryInfo.getTaxPrice()).setScale(purRequestEntryInfo.getCurrency().getPrecision(), 4);
                purRequestEntryInfo.setTaxAmount(taxAmount);
                totalTaxAmount = totalTaxAmount.add(taxAmount);
                purRequestInfo.setTotalTaxAmount(totalTaxAmount);
            }
            if (purRequestEntryInfo.getTaxAmount() != null && purRequestEntryInfo.getTaxRate() != null) {
                totalTax = totalTax.subtract(purRequestEntryInfo.getTax());
                taxAmount = purRequestEntryInfo.getTaxAmount();
                BigDecimal oneHundred = new BigDecimal("100.0");
                BigDecimal taxRate = purRequestEntryInfo.getTaxRate().divide(oneHundred, 10, 4);
                BigDecimal one = new BigDecimal("1.0");
                BigDecimal tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate).setScale(purRequestEntryInfo.getCurrency().getPrecision(), 4);
                purRequestEntryInfo.setTax(tax);
                totalTax = totalTax.add(tax);
                purRequestInfo.setTotalTax(totalTax);
            }
            if (entryInfo.getPrice() != null) {
                totalLocalAmount = totalLocalAmount.subtract(purRequestEntryInfo.getLocalAmount());
                BigDecimal LocalAmount = entryInfo.getPrice().multiply(relationRate).multiply(purRequestEntryInfo.getQty()).setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                purRequestEntryInfo.setLocalAmount(LocalAmount);
                totalLocalAmount = totalLocalAmount.add(LocalAmount);
                purRequestInfo.setLocalTotalAmount(totalLocalAmount);
            }
            if (entryInfo.getPrice() != null) {
                totalLocalTaxAmount = totalLocalTaxAmount.subtract(purRequestEntryInfo.getLocalTaxAmount());
                BigDecimal localTaxAmount = entryInfo.getTaxPrice().multiply(relationRate).multiply(purRequestEntryInfo.getQty()).setScale(companyInfo.getBaseCurrency().getPrecision(), 4);
                purRequestEntryInfo.setLocalTaxAmount(localTaxAmount);
                totalLocalTaxAmount = totalLocalTaxAmount.add(localTaxAmount);
                purRequestInfo.setLocalTotalTaxAmount(totalLocalTaxAmount);
            }
            if (entryInfo.getDiscount() != null) {
                BigDecimal discountAmount = entryInfo.getDiscount().multiply(purRequestEntryInfo.getTaxAmount()).setScale(purRequestEntryInfo.getCurrency().getPrecision(), 4);
                purRequestEntryInfo.setDiscountAmount(discountAmount);
            }
            if (entryInfo.getSupplier() != null) {
                purRequestEntryInfo.setSupplier(entryInfo.getSupplier());
            }
            PurRequestEntryFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)purRequestEntryInfo, updateSelector);
            PurRequestFactory.getLocalInstance(ctx).updatePartial((CoreBaseInfo)purRequestInfo, updateRequestSelector);
            flag = true;
        }
        if (flag) {
            info.setIsUpdateRequest(true);
            this.update(ctx, pk, (CoreBaseInfo)info);
        }
    }

    protected PurRequestEntryInfo getPurRequestEntryInfo(Context ctx, String purRequestEntryID, SelectorItemCollection selector) throws BOSException, EASBizException {
        PurRequestEntryInfo entryInfo = null;
        if (purRequestEntryID != null) {
            entryInfo = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryInfo((IObjectPK)new ObjectUuidPK(purRequestEntryID.toString()), selector);
        }
        return entryInfo;
    }

    public String getParamCon4Audit() {
        return "PUREXA001";
    }

    public String getParamCon4UnAudit() {
        return "PUREXA002";
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add(new SelectorItemInfo("purOrgUnit.id"));
        return sic;
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        SelectorItemCollection sic = super.getSelector(isNeedEntrySelector);
        sic.add(new SelectorItemInfo("purOrgUnit.id"));
        return sic;
    }
}

