/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sd.sale.QuotationException;
import com.kingdee.eas.scm.sm.pur.AbstractPurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.IPurQuotation;
import com.kingdee.eas.scm.sm.pur.IPurQuotationEntry;
import com.kingdee.eas.scm.sm.pur.MakeBillFlagEnum;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationException;
import com.kingdee.eas.scm.sm.pur.PurQuotationFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanException;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.QuoteStyleEnum;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurQuotationControllerBean;
import com.kingdee.eas.scm.sm.pur.app.PurOrderUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class PurQuotationControllerBean
extends AbstractPurQuotationControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurQuotationControllerBean");
    IPerson iPerson;
    private ObjectUuidPK purPK = null;
    private IPurQuotation iPurQuotation = null;
    private UserInfo currentUser;
    private IRowSet rowSet = null;
    private int alertTag = 0;

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        PurQuotationInfo purQuotationInfo = (PurQuotationInfo)model;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purQuotationInfo.getPurchaseOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (purchaseOrgUnitInfo != null && (orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurQuotationInfo)model).getPurchaseOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchCheck(ctx, batchAction, batchResults);
        String[] ids = batchResults.getAllIDs();
        if (ids == null) {
            return;
        }
        if (BatchActionEnum.UNAUDIT.equals((Object)batchAction)) {
            StringBuffer idCol = new StringBuffer();
            idCol.append("(");
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                if (i == 0) {
                    idCol.append("'").append(ids[i]).append("'");
                    continue;
                }
                idCol.append(",'").append(ids[i]).append("'");
            }
            idCol.append(")");
            String sql = "select FNumber from T_SM_PurQuotation where FID in (select distinct(FParentID) from T_SM_PurQuotationEntry where FParentID in " + idCol + " and FIsUpdateASInfo = 1)";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs != null && rs.size() != 0) {
                throw new PurQuotationException(PurQuotationException.QUO_ISUPDATEASINFO, new String[0]);
            }
        }
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        if (BatchActionEnum.AUDIT.equals((Object)batchAction)) {
            for (IObjectPK pk : pks) {
                Date disibleDate;
                if (pk == null) {
                    return;
                }
                IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("entries.id"));
                PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
                if (aPurQuotationInfo.getBaseStatus().getValue() != 2 && aPurQuotationInfo.getBaseStatus().getValue() != -2) {
                    throw new PurReqException(PurReqException.PUR_NOT_SUBMIT);
                }
                this.isSamePerson4Audit(ctx, aPurQuotationInfo);
                if (aPurQuotationInfo != null && aPurQuotationInfo.getPurQuotationPlanID() != null && (disibleDate = aPurQuotationInfo.getDisibleDate()).getTime() < new Date().getTime()) {
                    throw new PurQuotationException(PurQuotationException.QUO_NOTAUDIT, new String[]{null});
                }
                PurQuotationEntryInfo aPurQuotationInfoEntry = null;
                int size = 0;
                if (aPurQuotationInfo != null && aPurQuotationInfo.getEntries() != null) {
                    size = aPurQuotationInfo.getEntries().size();
                }
                IObjectPK[] entryPks = new IObjectPK[size];
                ObjectUuidPK[] qUpdateASInfoMaterialpks = new ObjectUuidPK[size];
                Connection con2 = null;
                Statement batchStatement2 = null;
                try {
                    String strUpdateASInfo;
                    con2 = this.getConnection(ctx);
                    batchStatement2 = con2.createStatement();
                    for (int j = 0; j < size; ++j) {
                        aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(j);
                        entryPks[j] = new ObjectUuidPK(aPurQuotationInfoEntry.getId());
                        if (aPurQuotationInfoEntry.getMaterial() != null) {
                            qUpdateASInfoMaterialpks[j] = new ObjectUuidPK(aPurQuotationInfoEntry.getMaterial().getId());
                        }
                        String updatePurPlanMEntrySql = "update T_SM_PurQuoPlanMEntry set FQuotationTimes = isnull(FQuotationTimes,0) + 1 where T_SM_PurQuoPlanMEntry.fid = '" + aPurQuotationInfoEntry.getSourceBillEntryId() + "'";
                        batchStatement2.addBatch(updatePurPlanMEntrySql);
                    }
                    this.returnWrite(ctx, aPurQuotationInfo);
                    Date today = new Date();
                    SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    String updateSql = "update T_SM_PurQuotation set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = to_date('" + simpleFormat.format(today) + "') where fid ='" + pk.toString() + "'";
                    batchStatement2.addBatch(updateSql);
                    String updateEntrySql = "update T_SM_PurQuotationEntry set FBaseStatus = 4 where FParentID ='" + pk.toString() + "'";
                    batchStatement2.addBatch(updateEntrySql);
                    batchStatement2.executeBatch();
                    if (aPurQuotationInfo != null) {
                        this.writeBackPurRequest(ctx, aPurQuotationInfo);
                    }
                    boolean isUpdateASInfo = false;
                    IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
                    ObjectUuidPK purOrgpk = null;
                    if (aPurQuotationInfo != null && aPurQuotationInfo.getPurchaseOrgUnit() != null) {
                        purOrgpk = new ObjectUuidPK(aPurQuotationInfo.getPurchaseOrgUnit().getId().toString());
                    }
                    if ((strUpdateASInfo = ipc.getParamValue(purOrgpk, "PURQUOT001")) != null && strUpdateASInfo.trim().length() != 0 && strUpdateASInfo.trim().equalsIgnoreCase("true")) {
                        for (int j = 0; j < qUpdateASInfoMaterialpks.length; ++j) {
                            if (qUpdateASInfoMaterialpks[j] == null) {
                                isUpdateASInfo = false;
                                break;
                            }
                            isUpdateASInfo = true;
                        }
                    }
                    if (isUpdateASInfo && (aPurQuotationInfo.getPurQuotationPlanID() == null || aPurQuotationInfo.getPurQuotationPlanID().length() <= 0)) {
                        IPurQuotationEntry iPurQuoEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
                        iPurQuoEntry.createApprovedSupplier(entryPks);
                    }
                }
                catch (EASBizException er) {
                    try {
                        throw er;
                        catch (Exception er2) {
                            throw new BOSException((Throwable)er2);
                        }
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(batchStatement2, (Connection)con2);
                        SQLUtils.cleanup((Connection)con2);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((Statement)batchStatement2, (Connection)con2);
                SQLUtils.cleanup((Connection)con2);
            }
            return;
        }
        if (!BatchActionEnum.UNAUDIT.equals((Object)batchAction)) return;
        for (IObjectPK pk : pks) {
            if (pk == null) {
                return;
            }
            IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
            PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
            SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)aPurQuotationInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("entries.id"));
            this.isSamePerson4UnAudit(ctx, aPurQuotationInfo);
            PurQuotationEntryInfo aPurQuotationInfoEntry = null;
            IObjectPK[] entryPks = new IObjectPK[aPurQuotationInfo.getEntries().size()];
            int num = aPurQuotationInfo.getEntries().size();
            for (int j = 0; j < num; ++j) {
                aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(j);
                entryPks[j] = new ObjectUuidPK(aPurQuotationInfoEntry.getId());
            }
            Connection con = null;
            Statement statement = null;
            Statement batchStatement = null;
            try {
                con = this.getConnection(ctx);
                statement = con.createStatement();
                batchStatement = con.createStatement();
                int size = 0;
                if (aPurQuotationInfo != null && aPurQuotationInfo.getEntries() != null) {
                    size = aPurQuotationInfo.getEntries().size();
                }
                if (aPurQuotationInfo != null && batchStatement != null && aPurQuotationInfo.getSourceBillType() != null && aPurQuotationInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a814fd463ED552")) {
                    this.writeBackPurQuotationPlanForUnAudit(ctx, (IObjectValue)aPurQuotationInfo);
                    for (int j = 0; j < size; ++j) {
                        aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(j);
                        String updatePurPlanMEntrySql = "update T_SM_PurQuoPlanMEntry set FQuotationTimes = isnull(FQuotationTimes,0) - 1 where T_SM_PurQuoPlanMEntry.fid = '" + aPurQuotationInfoEntry.getSourceBillEntryId() + "'";
                        batchStatement.addBatch(updatePurPlanMEntrySql);
                    }
                }
                String updateSql = "update T_SM_PurQuotation set FBaseStatus = 1,FAuditorId=null ,FAuditTime = null where fid ='" + pk.toString() + "'";
                String updateEntrySql = "update T_SM_PurQuotationEntry set FBaseStatus = 1,FAuditDate = null ,FEnabledUser = null where FParentID ='" + pk.toString() + "'";
                String updateEntryASInfoSql = "update T_SM_PurQuotationEntry set FIsUpdateASInfo = 0 where FParentID ='" + pk.toString() + "'";
                batchStatement.addBatch(updateSql);
                batchStatement.addBatch(updateEntrySql);
                batchStatement.addBatch(updateEntryASInfoSql);
                batchStatement.executeBatch();
            }
            catch (Exception er) {
                try {
                    throw new BOSException((Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement, (Connection)con);
                    SQLUtils.cleanup(batchStatement, (Connection)con);
                    SQLUtils.cleanup((Connection)con);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((Statement)statement, (Connection)con);
            SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
            SQLUtils.cleanup((Connection)con);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        this._auditBill(ctx, pks);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        IPurQuotationEntry iPurQuotationEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        PurQuotationInfo purQuotationInfo = null;
        PurQuotationEntryInfo purQuotationEntryInfo = null;
        for (int i = 0; i < pks.length; ++i) {
            purQuotationEntryInfo = iPurQuotationEntry.getPurQuotationEntryInfo(pks[i]);
            purQuotationInfo = iPurQuotation.getPurQuotationInfo((IObjectPK)new ObjectUuidPK(purQuotationEntryInfo.getParent().getId()));
            if (!UIRuleUtil.isNotNull((String)purQuotationInfo.getPurQuotationPlanID())) {
                return;
            }
            this.returnWrite(ctx, purQuotationInfo);
        }
    }

    private boolean checkSupplyInfoIsRepeate(Context ctx, SupplyInfoInfo vo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)vo.getPurchaseOrg().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)vo.getSupplier().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)vo.getMaterialItem().getId().toString(), CompareType.EQUALS));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)vo.getPurMeasureUnit().getId().toString(), CompareType.EQUALS));
        if (vo.getEffectualDate() != null) {
            filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)(sdf.format(vo.getEffectualDate()) + " 00 00 00"), CompareType.LESS_EQUALS));
        }
        if (vo.getUneffectualDate() != null) {
            filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)(sdf.format(vo.getUneffectualDate()) + " 23 59 59"), CompareType.GREATER_EQUALS));
        }
        if (vo.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)vo.getId().toString(), CompareType.NOTEQUALS));
        }
        view.setFilter(filter);
        ISupplyInfo iSupplyInfo = SupplyInfoFactory.getLocalInstance((Context)ctx);
        SupplyInfoCollection collection = iSupplyInfo.getSupplyInfoCollection(view);
        StringBuffer buffer = new StringBuffer();
        if (collection.size() > 0) {
            if (collection.get(0).getPurchaseOrg().getId().equals((Object)vo.getPurchaseOrg().getId())) {
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_PurOrg", (Context)ctx));
            }
            if (collection.get(0).getSupplier().getId().equals((Object)vo.getSupplier().getId())) {
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_SupplierTreeLabel", (Context)ctx));
            }
            if (collection.get(0).getMaterialItem().getId().equals((Object)vo.getMaterialItem().getId())) {
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_MaterialTreeLabel", (Context)ctx));
            }
            if (vo.getPurMeasureUnit() != null && collection.get(0).getPurMeasureUnit() != null) {
                if (collection.get(0).getPurMeasureUnit().getId().equals((Object)vo.getPurMeasureUnit().getId())) {
                    buffer.append(",");
                    buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_MeasureUnit", (Context)ctx));
                }
            } else if (vo.getPurMeasureUnit() != null) {
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_MeasureUnit", (Context)ctx));
            } else if (collection.get(0).getPurMeasureUnit() != null) {
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_MeasureUnit", (Context)ctx));
            }
            if (vo.getEffectualDate() != null && vo.getUneffectualDate() != null && (vo.getEffectualDate().after(collection.get(0).getEffectualDate()) || vo.getEffectualDate().equals(collection.get(0).getEffectualDate())) && (vo.getUneffectualDate().before(collection.get(0).getUneffectualDate()) || vo.getUneffectualDate().equals(collection.get(0).getUneffectualDate()))) {
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_Effective", (Context)ctx));
                buffer.append(",");
                buffer.append(SCMUtils.getResource((String)"com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoUIResource", (String)"Msg_UnEffective", (Context)ctx));
            }
            return true;
        }
        return false;
    }

    protected void createSupplyInfo(Context ctx, PurQuotationEntryInfo aPurQuotationEntryInfo, PurQuotationInfo purQuotationInfo) throws BOSException, EASBizException {
        if (aPurQuotationEntryInfo.getParent().getPurchaseOrgUnit().getId() != null && aPurQuotationEntryInfo.getParent().getSupplier().getId() != null && aPurQuotationEntryInfo.getMaterial().getId() != null) {
            ObjectUuidPK purchaseOrgUnitID = new ObjectUuidPK(aPurQuotationEntryInfo.getParent().getPurchaseOrgUnit().getId());
            ObjectUuidPK supplierID = new ObjectUuidPK(aPurQuotationEntryInfo.getParent().getSupplier().getId());
            ObjectUuidPK materialID = new ObjectUuidPK(aPurQuotationEntryInfo.getMaterial().getId());
            BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;
            ISupplyInfo iSupplyInfo = SupplyInfoFactory.getLocalInstance((Context)ctx);
            Date bizDate = aPurQuotationEntryInfo.getParent().getBizDate();
            Calendar cal = Calendar.getInstance();
            Calendar cal2 = Calendar.getInstance();
            cal2.setTime(bizDate);
            if (cal2.get(5) == cal.get(5)) {
                bizDate = cal.getTime();
            }
            if (purQuotationInfo.getEnabledDate() == null) {
                purQuotationInfo.setEnabledDate(bizDate);
            }
            if (purQuotationInfo.getDisibleDate() == null) {
                purQuotationInfo.setDisibleDate(bizDate);
            }
            SupplyInfoInfo objectValue = iSupplyInfo.getSupplyInfoValueWithDate((IObjectPK)materialID, (IObjectPK)purchaseOrgUnitID, (IObjectPK)supplierID, bizDate);
            UserInfo currentUser = (UserInfo)ctx.get((Object)"UserInfo");
            if (objectValue != null) {
                SupplyInfoInfo aSupplyInfo = objectValue;
                aSupplyInfo.setId(null);
                aSupplyInfo.setEffectualDate(purQuotationInfo.getEnabledDate());
                aSupplyInfo.setUneffectualDate(purQuotationInfo.getDisibleDate());
                aSupplyInfo.setIsUseable(IsUseableEnum.Useable);
                BigDecimal baseUnitQty = aPurQuotationEntryInfo.getLocalTaxPrice();
                if (!aSupplyInfo.getPurMeasureUnit().getId().toString().equals(aPurQuotationEntryInfo.getUnit().getId().toString())) {
                    baseUnitQty = this.getExchangeQty(ctx, aPurQuotationEntryInfo.getMaterial().getId().toString(), aSupplyInfo.getPurMeasureUnit(), aPurQuotationEntryInfo.getUnit(), baseUnitQty);
                }
                aSupplyInfo.setPrice(baseUnitQty);
                aSupplyInfo.setIsTaxPrice(true);
                aSupplyInfo.setDiscountRate(aPurQuotationEntryInfo.getDiscount());
                aSupplyInfo.setCreator(currentUser);
                aSupplyInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                aSupplyInfo.setAuditor(currentUser);
                aSupplyInfo.setAuditDate((Date)new Timestamp(System.currentTimeMillis()));
                if (!this.checkSupplyInfoIsRepeate(ctx, aSupplyInfo)) {
                    iSupplyInfo.submit((CoreBaseInfo)aSupplyInfo);
                }
            } else {
                SupplyInfoInfo aSupplyInfo = new SupplyInfoInfo();
                aSupplyInfo.setId(null);
                aSupplyInfo.setPurchaseOrg(aPurQuotationEntryInfo.getParent().getPurchaseOrgUnit());
                aSupplyInfo.setPurMeasureUnit(aPurQuotationEntryInfo.getUnit());
                aSupplyInfo.setMeasureUnit(aPurQuotationEntryInfo.getBaseUnit());
                aSupplyInfo.setSupplier(aPurQuotationEntryInfo.getParent().getSupplier());
                aSupplyInfo.setMaterialItem(aPurQuotationEntryInfo.getMaterial());
                aSupplyInfo.setQtyOrderBottom(ZERO);
                aSupplyInfo.setQtyOrderTop(ZERO);
                aSupplyInfo.setEffectualDate(purQuotationInfo.getEnabledDate());
                aSupplyInfo.setUneffectualDate(purQuotationInfo.getDisibleDate());
                aSupplyInfo.setIsUseable(IsUseableEnum.Useable);
                aSupplyInfo.setPrice(aPurQuotationEntryInfo.getLocalTaxPrice());
                aSupplyInfo.setIsTaxPrice(true);
                aSupplyInfo.setDiscountRate(aPurQuotationEntryInfo.getDiscount());
                aSupplyInfo.setCreator(currentUser);
                aSupplyInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
                aSupplyInfo.setAuditor(currentUser);
                aSupplyInfo.setAuditDate((Date)new Timestamp(System.currentTimeMillis()));
                if (!this.checkSupplyInfoIsRepeate(ctx, aSupplyInfo)) {
                    iSupplyInfo.submit((CoreBaseInfo)aSupplyInfo);
                }
            }
        }
    }

    private BigDecimal getExchangeQty(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        BigDecimal targetQty = qty;
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        if (multiUnifInfo != null && othermultiUnifInfo != null) {
            BigDecimal baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
            BigDecimal baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = SCMConstant.BIGDECIMAL_ONE;
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = SCMConstant.BIGDECIMAL_ONE;
            }
            BigDecimal baseQty = this.effectualNumeric(qty).multiply(baseExchangeRate1);
            int scale = 10;
            if (baseQty != null && qty != null) {
                scale = baseQty.scale() + qty.scale();
            }
            targetQty = this.effectualNumeric(baseQty).divide(this.effectualExchangeRate(baseExchangeRate2), scale != 0 ? scale : 10, 4);
        }
        return targetQty;
    }

    private BigDecimal effectualExchangeRate(BigDecimal exchangeRate) {
        return this.isDistrustExchangeRate(exchangeRate) ? exchangeRate : SCMConstant.BIGDECIMAL_ONE;
    }

    private boolean isDistrustExchangeRate(BigDecimal exchangeRate) {
        return exchangeRate != null && exchangeRate.compareTo(SysConstant.BIGZERO) != 0 && exchangeRate.compareTo(SysConstant.BIGZERO) != -1;
    }

    private BigDecimal effectualNumeric(BigDecimal v) {
        return this.equalsZero(v) ? SysConstant.BIGZERO : v;
    }

    private boolean equalsZero(BigDecimal v) {
        return v == null || SysConstant.BIGZERO.compareTo(v) == 0;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurQuotationInfo info = (PurQuotationInfo)model;
        BigDecimal baseLocalPrice = SCMConstant.BIGDECIMAL_ZERO;
        int count = info.getEntries().size();
        for (int i = 0; i < count; ++i) {
            PurQuotationEntryInfo entryInfo = info.getEntries().get(i);
            if (entryInfo == null || info.getExchangeRate() == null || entryInfo.getMaterial() == null || entryInfo.getMaterial().getId() == null || entryInfo.getUnit() == null || entryInfo.getUnit().getId() == null || entryInfo.getActualPrice() == null) continue;
            baseLocalPrice = this.countBaseUnitLocalPrice(entryInfo.getActualPrice(), entryInfo.getMaterial().getId().toString(), info.getExchangeRate(), entryInfo.getUnit().getId().toString(), ctx);
            entryInfo.setBaseLocalActualPrice(baseLocalPrice);
        }
        if (info.getMakeBillFlag() == null) {
            info.setMakeBillFlag(MakeBillFlagEnum.Purchase);
        }
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    private BigDecimal getBaseConvs(Context ctx, String materialID, String measureUnitID) throws BOSException, EASBizException {
        BigDecimal baseConvs = new BigDecimal("1.00");
        if (materialID == null && measureUnitID != null) {
            return baseConvs;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.getSelector().add(new SelectorItemInfo("material.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)new ObjectUuidPK(BOSUuid.read((String)materialID)), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)new ObjectUuidPK(BOSUuid.read((String)measureUnitID)), CompareType.EQUALS));
        viewInfo.setFilter(filterInfo);
        IMultiMeasureUnit iMultiMeasureUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitCollection measureUnitColl = iMultiMeasureUnit.getMultiMeasureUnitCollection(viewInfo);
        if (measureUnitColl != null && measureUnitColl.size() != 0) {
            baseConvs = measureUnitColl.get(0).getBaseConvsRate();
        }
        return baseConvs;
    }

    private BigDecimal countBaseUnitLocalPrice(BigDecimal actualPrice, String materialID, BigDecimal exchangeRate, String measureUnitID, Context ctx) throws BOSException {
        BigDecimal baseUnitLocalPrice = null;
        BigDecimal unitToBaseUnitRale = null;
        try {
            unitToBaseUnitRale = this.getBaseConvs(ctx, materialID, measureUnitID);
            baseUnitLocalPrice = actualPrice.divide(unitToBaseUnitRale, 4, 4).multiply(exchangeRate);
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return baseUnitLocalPrice;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        PurQuotationInfo quotationInfo = (PurQuotationInfo)model;
        boolean isAddNew = true;
        if (this.isAddNew(ctx, (IObjectValue)quotationInfo)) {
            isAddNew = true;
            this.checkNumber(ctx, isAddNew, quotationInfo);
        } else {
            isAddNew = false;
        }
        this.checkSubmit(ctx, quotationInfo);
        quotationInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (quotationInfo.getMakeBillFlag() == null) {
            quotationInfo.setMakeBillFlag(MakeBillFlagEnum.Purchase);
        }
        IObjectPK pk = super._submit(ctx, model);
        if (quotationInfo.getEditionNumber() == 0 && quotationInfo.getAuditor() == null) {
            String orgUnitID = quotationInfo.getPurchaseOrgUnit().getId().toString();
            if (this.isAuditAfterSubmit(ctx, quotationInfo, orgUnitID, 3)) {
                LogControllManager.getInstance().enableLog();
                ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
                IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Audit", (BOSObjectType)quotationInfo.getBOSType(), (IObjectPK)pk, (String)quotationInfo.getNumber(), (String)"scm_purQuotation_audit");
                this._auditBill(ctx, pk);
                LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
            }
            long time2 = System.currentTimeMillis();
            logger.error((Object)("$$$$$$$$\uff1a" + (time2 - time1)));
            return pk;
        }
        if (quotationInfo.getEditionNumber() == 0 && quotationInfo.getAuditor() != null) {
            ++this.alertTag;
            this._alter(ctx, pk, model);
        } else if (quotationInfo.getEditionNumber() != 0 && quotationInfo.getAuditor() != null && this.alertTag == 0) {
            ++this.alertTag;
            this._alter(ctx, pk, model);
        }
        String orgUnitID = quotationInfo.getPurchaseOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, quotationInfo, orgUnitID, 3)) {
            LogControllManager.getInstance().enableLog();
            ServiceStateManager.getInstance().enableNextCallService("LOG_SERVICE");
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"Audit", (BOSObjectType)quotationInfo.getBOSType(), (IObjectPK)pk, (String)quotationInfo.getNumber(), (String)"scm_purQuotation_audit");
            this._auditBill(ctx, pk);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("$$$$$$$$\uff1a" + (time2 - time1)));
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    private void setZero(PurQuotationEntryInfo entry) throws BOSException {
        String[] fields = new String[]{"qtyFrom", "qtyTo", "baseQtyFrom", "baseQtyTo", "price", "taxRate", "taxPrice", "discount", "actualTaxPrice"};
        this.setBigDecimalZeros(entry, fields);
    }

    private void setBigDecimalZeros(PurQuotationEntryInfo entry, String[] fields) throws BOSException {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = PurQuotationEntryInfo.class.getMethod(getMethodName, null);
                Method setMethod = PurQuotationEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, null) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                throw new BOSException((Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new BOSException((Throwable)e);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected void checkDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurQuotationInfo quotationInfo = this.getPurQuotationInfo(ctx, pk);
        if (quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1 && quotationInfo.getBaseStatus().getValue() != 2) {
            throw new PurQuotationException(PurQuotationException.QUO_CANNOT_DELETE, new String[]{quotationInfo.getBaseStatus().toString()});
        }
        PurQuotationEntryCollection entryInfos = quotationInfo.getEntries();
        PurQuotationEntryInfo entry = null;
        int num = entryInfos.size();
        for (int i = 0; i < num; ++i) {
            entry = entryInfos.get(i);
            if (entry.getBaseStatus().getValue() == 0 || entry.getBaseStatus().getValue() == 1 || entry.getBaseStatus().getValue() == 2) continue;
            throw new PurQuotationException(PurQuotationException.QUO_CANNOT_DELETE, new String[]{entry.getBaseStatus().toString()});
        }
        if ("1".equals(ctx.get((Object)"isFromGUI"))) {
            if (MakeBillFlagEnum.SUPPLIER.equals((Object)quotationInfo.getMakeBillFlag())) {
                throw new PurQuotationException(PurQuotationException.QUO_NET_PRICE_UNDO, new String[]{this.getServerResource("OPERATOR_DELETE", ctx)});
            }
            if (quotationInfo.getSupplier() != null && quotationInfo.getPurchaseOrgUnit() != null && BillBaseStatusEnum.SUBMITED.equals((Object)quotationInfo.getBaseStatus())) {
                String supplierID = quotationInfo.getSupplier().getId().toString();
                String purchaseOrgUnitID = quotationInfo.getPurchaseOrgUnit().getId().toString();
                boolean isSupplierPurSyn = PurOrderUtils.isSupplierPurSyn(ctx, supplierID, purchaseOrgUnitID);
                if (PurOrderUtils.isPurSyn(ctx) && isSupplierPurSyn && QuoteStyleEnum.WEB.equals((Object)quotationInfo.getQuoteType())) {
                    throw new PurQuotationException(PurQuotationException.QUO_NET_PRICE_UNDO, new String[]{this.getServerResource("OPERATOR_DELETE", ctx)});
                }
            }
        }
        super._canUpdate(ctx, pk);
    }

    protected void checkSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurQuotationInfo quotationInfo = this.getPurQuotationInfo(ctx, pk);
        if (quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1) {
            throw new PurQuotationException(PurQuotationException.QUO_ONLYTEMP_CANBE_SAVE);
        }
        super._canUpdate(ctx, pk);
    }

    protected void checkSubmit(Context ctx, PurQuotationInfo quotationInfo) throws BOSException, EASBizException {
        if (quotationInfo != null && quotationInfo.getBaseStatus() != null && quotationInfo.getBaseStatus().getValue() != 0 && quotationInfo.getBaseStatus().getValue() != 1 && quotationInfo.getBaseStatus().getValue() != 2 && quotationInfo.getBaseStatus().getValue() != 10) {
            throw new SCMBillException(SCMBillException.BILLSTATUSNOTSAVEORSUBMIT);
        }
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = (UserInfo)ctx.get((Object)"UserInfo");
        StringBuffer errorSb = new StringBuffer();
        BigDecimal zero = new BigDecimal(0);
        boolean isError = false;
        boolean isUseAssit = false;
        if (quotationInfo.getPurchaseOrgUnit() != null) {
            String paramValue = ParamControlFactory.getLocalInstance((Context)ctx).getParamValue((IObjectPK)new ObjectUuidPK(quotationInfo.getPurchaseOrgUnit().getId().toString()), "PURORDER100");
            isUseAssit = Boolean.parseBoolean(paramValue);
        }
        if (quotationInfo != null && quotationInfo.getPurQuotationPlanID() == null) {
            int count = quotationInfo.getEntries().size();
            for (int num = 0; num < count; ++num) {
                PurQuotationEntryInfo entryInfo = quotationInfo.getEntries().get(num);
                if (user.getSupplierID() != null) continue;
                if (entryInfo.getPrice() == null || entryInfo.getPrice().compareTo(zero) == -1 || entryInfo.getPrice().compareTo(zero) == 0) {
                    isError = true;
                    errorSb.append(this.getServerResource("ORDER_FIELD_PRICE", ctx));
                    if (isError) {
                        errorSb.append(",");
                    }
                }
                if (entryInfo.getTaxPrice() == null || entryInfo.getTaxPrice().compareTo(zero) == -1 || entryInfo.getTaxPrice().compareTo(zero) == 0) {
                    isError = true;
                    errorSb.append(this.getServerResource("ORDER_FIELD_TAXPRICE", ctx));
                    if (isError) {
                        errorSb.append(",");
                    }
                }
                if (isError) {
                    throw new PurQuotationException(PurQuotationException.QUO_PRICE_TAXPRICE_CANNT_ZERO, new String[]{String.valueOf(num + 1), errorSb.toString()});
                }
                if (isUseAssit || entryInfo.getMaterial() == null || entryInfo.getMaterial().getAssistAttr() == null || entryInfo.getAssistProperty() != null) continue;
                throw new PurQuotationException(PurQuotationException.QUO_ASSISTATTR_CANNT_NULL, new String[]{String.valueOf(num + 1)});
            }
        }
        if (quotationInfo != null && quotationInfo.getPurchaseOrgUnit() != null && quotationInfo.getPurchaseOrgUnit().getId() != null) {
            ObjectUuidPK pk = null;
            pk = new ObjectUuidPK(quotationInfo.getPurchaseOrgUnit().getId());
            if (pk != null && this.isPurQuoSecrecy(ctx, pk.toString())) {
                String wfService = null;
                String funcName = "com.kingdee.eas.scm.sm.pur.PurQuotationFunction";
                String operationName = "ActionSubmit";
                IEnactmentService iEnactmentService = EnactmentServiceFactory.createEnactService((Context)ctx);
                if (user.getSupplierID() != null) {
                    user = iUser.getUserByID(ctx.getCaller());
                }
                BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-010bc0a814fd463ED552"));
                wfService = iEnactmentService.findSubmitProcDef(user.getId().toString(), (IObjectValue)quotationInfo, funcName, operationName);
                if (wfService == null) {
                    if (quotationInfo != null) {
                        throw new PurQuotationPlanException(PurQuotationPlanException.QUOPLAN_PROCESS_NULL, new String[]{quotationInfo.getBaseStatus().toString()});
                    }
                    throw new PurQuotationPlanException(PurQuotationPlanException.QUOPLAN_PROCESS_NULL, new String[]{BillBaseStatusEnum.SUBMITED.toString().toString()});
                }
            }
        }
        super._canUpdate(ctx, (IObjectPK)new ObjectUuidPK(quotationInfo.getId()));
    }

    private boolean isPurQuoSecrecy(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURQUO003")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private void checkNumber(Context ctx, boolean isAddNew, PurQuotationInfo quotationInfo) throws BOSException, EASBizException {
        if (!(this.isRuleAutoNumber(ctx, quotationInfo, quotationInfo.getPurchaseOrgUnit().getId().toString()) || quotationInfo.getNumber() != null && quotationInfo.getNumber().trim().length() != 0)) {
            throw new PurQuotationException(PurQuotationException.FIELD_CANNOT_EMPTY, new String[]{this.getServerResource("PURQUO_FIELD_NUMBER", ctx)});
        }
    }

    public CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    public CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        PurQuotationInfo purQuotaionInfo = (PurQuotationInfo)model;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purQuotaionInfo.getPurchaseOrgUnit();
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (purchaseOrgUnitInfo != null && (orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(purchaseOrgUnitInfo.getId().toString(), 3, 1)) != null && orgUnitCollection.size() > 0) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return companyOrgUnitInfo;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key, (Context)ctx);
    }

    public String getImportServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurQuotationResource", (String)key, (Context)ctx);
    }

    private void checkEntriesValidforSubmit(PurQuotationEntryCollection entries, Context ctx) throws PurQuotationException {
        StringBuffer errorSb = new StringBuffer();
        boolean isError = false;
        int nrow = entries.size();
        if (nrow <= 0) {
            throw new PurQuotationException(PurQuotationException.ENTRY_CANNOT_EMPTY);
        }
        PurQuotationEntryInfo quotationEntryInfo = null;
        for (int row = 0; row < nrow; ++row) {
            quotationEntryInfo = entries.get(row);
            if (quotationEntryInfo.getMaterial() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_MATERIAL", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getBaseUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_BASEUNIT", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_UNIT", ctx));
                isError = true;
            }
            if (quotationEntryInfo.getTaxRate() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_TAXRATE", ctx));
                isError = true;
            }
            if (!isError) continue;
            throw new PurQuotationException(PurQuotationException.ENTRY_FIELD_CANNOT_EMPTY, new String[]{String.valueOf(row + 1), errorSb.toString()});
        }
    }

    protected void checkValidforSubmit(IObjectValue model, Context ctx) throws PurQuotationException {
        PurQuotationInfo quotationInfo = (PurQuotationInfo)model;
        StringBuffer errorSb = new StringBuffer();
        boolean isError = false;
        if (quotationInfo.getBizDate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_ORDERDATE", ctx));
            isError = true;
        }
        if (quotationInfo.getSupplier() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_SUPPLIER", ctx));
            isError = true;
        }
        if (quotationInfo.getCurrency() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_CURRENCY", ctx));
            isError = true;
        }
        if (quotationInfo.getExchangeRate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_EXCHANGERATE", ctx));
            isError = true;
        }
        if (quotationInfo.getPurchaseOrgUnit() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (quotationInfo.getPaymentType() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (quotationInfo.getPaymentCondition() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (quotationInfo.getUnEffectiveTime() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (quotationInfo.getQuoteType() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (quotationInfo.getDisibleDate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (isError) {
            throw new PurQuotationException(PurQuotationException.FIELD_CANNOT_EMPTY, new String[]{errorSb.toString()});
        }
        this.checkEntriesValidforSubmit(quotationInfo.getEntries(), ctx);
    }

    protected void _calcel(Context ctx, IObjectPK[] pks, String reasSon) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        StringBuffer params = new StringBuffer();
        PurQuotationEntryInfo aPurQuotation = null;
        IPurQuotationEntry iPurQuotationEntryInfo = PurQuotationEntryFactory.getLocalInstance(ctx);
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent"));
        sic.add(new SelectorItemInfo("parent.baseStatus"));
        sic.add(new SelectorItemInfo("parent.supplier"));
        sic.add(new SelectorItemInfo("parent.id"));
        FilterInfo filterInfo = new FilterInfo();
        if (pks != null && pks.length > 0) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", new HashSet<IObjectPK>(Arrays.asList(pks)), CompareType.INCLUDE));
        } else {
            filterInfo.getFilterItems().add(new FilterItemInfo("1 = 0"));
        }
        viewInfo.setFilter(filterInfo);
        PurQuotationEntryCollection coll = iPurQuotationEntryInfo.getPurQuotationEntryCollection(viewInfo);
        int c = coll.size();
        for (int i = 0; i < c; ++i) {
            if (i > 0) {
                params.append(",");
            }
            if ((aPurQuotation = coll.get(i)).getBaseStatus().getValue() == 4 || aPurQuotation.getBaseStatus().getValue() == 3 || aPurQuotation.getBaseStatus().getValue() == 7) {
                throw new PurQuotationException(PurQuotationException.QUO_CANNOT_CANCEL, new String[]{EntryBaseStatusEnum.DELETED.getAlias()});
            }
            params.append("'");
            params.append(aPurQuotation.getId().toString());
            params.append("'");
        }
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            String updateSql = "update T_SM_PurQuotationEntry set FBaseStatus =3,Freason='" + reasSon + "' where fid in(" + params.toString() + ")";
            batchStatement.addBatch(updateSql);
            StringBuffer updateAuditSQL = new StringBuffer();
            updateAuditSQL.append(" update ").append(" T_SM_PurQuotation set FBaseStatus = 3").append(" where fid in (select fparentid from T_SM_PurQuotationEntry where fid in (" + params.toString() + "))");
            batchStatement.addBatch(updateAuditSQL.toString());
            batchStatement.executeBatch();
        }
        catch (Exception er) {
            try {
                throw new BOSException((Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        this._auditBill(ctx, pk);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _auditBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        Date disibleDate;
        if (pk == null) {
            return;
        }
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
        this.isSamePerson4Audit(ctx, aPurQuotationInfo);
        if (aPurQuotationInfo != null && aPurQuotationInfo.getPurQuotationPlanID() != null && (disibleDate = aPurQuotationInfo.getDisibleDate()).getTime() < new Date().getTime()) {
            throw new PurQuotationException(PurQuotationException.QUO_NOTAUDIT, new String[]{null});
        }
        PurQuotationEntryInfo aPurQuotationInfoEntry = null;
        int size = 0;
        if (aPurQuotationInfo != null && aPurQuotationInfo.getEntries() != null) {
            size = aPurQuotationInfo.getEntries().size();
        }
        IObjectPK[] pks = new IObjectPK[size];
        ObjectUuidPK[] qUpdateASInfoMaterialpks = new ObjectUuidPK[size];
        Connection con = null;
        Statement batchStatement = null;
        try {
            String strUpdateASInfo;
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            for (int i = 0; i < size; ++i) {
                aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(i);
                pks[i] = new ObjectUuidPK(aPurQuotationInfoEntry.getId());
                if (aPurQuotationInfoEntry.getMaterial() != null) {
                    qUpdateASInfoMaterialpks[i] = new ObjectUuidPK(aPurQuotationInfoEntry.getMaterial().getId());
                }
                String updatePurPlanMEntrySql = "update T_SM_PurQuoPlanMEntry set FQuotationTimes = isnull(FQuotationTimes,0) + 1 where T_SM_PurQuoPlanMEntry.fid = '" + aPurQuotationInfoEntry.getSourceBillEntryId() + "'";
                batchStatement.addBatch(updatePurPlanMEntrySql);
            }
            this.returnWrite(ctx, aPurQuotationInfo);
            Date today = new Date();
            SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String updateSql = "update T_SM_PurQuotation set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = to_date('" + simpleFormat.format(today) + "') where fid ='" + pk.toString() + "'";
            batchStatement.addBatch(updateSql);
            String updateEntrySql = "update T_SM_PurQuotationEntry set FBaseStatus = 4 where FParentID ='" + pk.toString() + "'";
            batchStatement.addBatch(updateEntrySql);
            batchStatement.executeBatch();
            if (aPurQuotationInfo != null && batchStatement != null) {
                this.writeBackPurRequest(ctx, aPurQuotationInfo);
            }
            boolean isUpdateASInfo = false;
            IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK purOrgpk = null;
            if (aPurQuotationInfo != null && aPurQuotationInfo.getPurchaseOrgUnit() != null) {
                purOrgpk = new ObjectUuidPK(aPurQuotationInfo.getPurchaseOrgUnit().getId().toString());
            }
            if ((strUpdateASInfo = ipc.getParamValue(purOrgpk, "PURQUOT001")) != null && strUpdateASInfo.trim().length() != 0 && strUpdateASInfo.trim().equalsIgnoreCase("true")) {
                for (int i = 0; i < qUpdateASInfoMaterialpks.length; ++i) {
                    if (qUpdateASInfoMaterialpks[i] == null) {
                        isUpdateASInfo = false;
                        break;
                    }
                    isUpdateASInfo = true;
                }
            }
            if (isUpdateASInfo && (aPurQuotationInfo.getPurQuotationPlanID() == null || aPurQuotationInfo.getPurQuotationPlanID().length() <= 0)) {
                IPurQuotationEntry iPurQuoEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
                iPurQuoEntry.createApprovedSupplier(pks);
            }
        }
        catch (EASBizException er) {
            try {
                throw er;
                catch (Exception er2) {
                    throw new BOSException((Throwable)er2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK, Date bizDate) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK, bizDate);
        return exchangeRateInfo;
    }

    private void writeBackPurRequest(Context ctx, PurQuotationInfo aPurQuotationInfo) throws EASBizException, BOSException {
        if (aPurQuotationInfo == null || aPurQuotationInfo.getSourceBillType() == null || !aPurQuotationInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0107c0a812fd463ED552")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer updatesql = new StringBuffer();
        sql.append("update T_SM_PurRequestEntry set FQuotationTimes = isnull(FQuotationTimes,0) + 1 ");
        sql.append(" where T_SM_PurRequestEntry.fid in (");
        sql.append(" select fSourceBillEntryId from T_SM_PurQuotationEntry ");
        sql.append(" where fparentid = '").append(aPurQuotationInfo.getId().toString()).append("') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        boolean isWriteBack = this.isWritePurQue(ctx, aPurQuotationInfo);
        if (!isWriteBack) {
            return;
        }
        IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection ioc = iour.getToUnit(aPurQuotationInfo.getPurchaseOrgUnit().getId().toString(), 3, 1);
        CompanyOrgUnitInfo ficompanyOrgInfo = null;
        CurrencyInfo baseCurrInfo = null;
        ExchangeRateInfo tempexrateinfo = null;
        int basescale = 2;
        if (ioc.size() >= 1) {
            ficompanyOrgInfo = (CompanyOrgUnitInfo)ioc.get(0);
            baseCurrInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
            basescale = baseCurrInfo.getPrecision();
        }
        boolean isSameCurrency = true;
        if (baseCurrInfo != null && !baseCurrInfo.getId().toString().equals(aPurQuotationInfo.getCurrency().getId().toString())) {
            tempexrateinfo = PurQuotationControllerBean.getExchangeRate(ctx, ficompanyOrgInfo, (IObjectPK)new ObjectUuidPK(aPurQuotationInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(baseCurrInfo.getId()), aPurQuotationInfo.getBizDate());
            isSameCurrency = false;
        }
        updatesql.append(" update T_SM_PurRequestEntry set FSupplierID=?,FCurrencyID =?,FPrice=?,");
        updatesql.append(" FTAXPRICE = ?,FAmount = ?,FLocalAmount =?,FTAXRATE=?,FACTUALPRICE=?,");
        updatesql.append(" FACTUALTAXPRICE=?,FTAX=?,FTAXAMOUNT=?,FDISCOUNTAMOUNT=?,FLOCALTAXAMOUNT=?,");
        updatesql.append(" FLOCALTAX=? ,fdiscountRate = ?,fexchangeRate =? where fid =? ");
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            ps = conn.prepareStatement(updatesql.toString());
            sql.setLength(0);
            sql.append(" SELECT pqe.fSourceBillEntryId,pq.FSupplierID,pq.FCurrencyID,pqe.fprice ,pqe.FTAXPRICE,pqe.fnewAmount,");
            sql.append(" pqe.ftaxAmount,pqe.FTAXRATE,pqe.ftax,pqe.FACTUALPRICE,pqe.FACTUALTAXPRICE,pqe.FDISCOUNTAMOUNT,pqe.fdiscount as fdiscountRate,");
            sql.append(" pq.fexchangeRate ,pqe.FTAXRATE");
            sql.append(" FROM T_SM_PurQuotation pq ");
            sql.append(" left join T_SM_PurQuotationentry pqe on  pqe.fparentid = pq.fid ");
            sql.append(" where pq.fid='").append(aPurQuotationInfo.getId().toString()).append("'");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                BigDecimal localAmount = rs.getBigDecimal("fnewAmount");
                BigDecimal localTax = rs.getBigDecimal("FTAX");
                BigDecimal localTaxAmount = rs.getBigDecimal("ftaxAmount");
                BigDecimal exchangeRate = rs.getBigDecimal("fexchangeRate");
                ConvertModeEnum convertModeEnum = ConvertModeEnum.DIRECTEXCHANGERATE;
                if (tempexrateinfo != null) {
                    convertModeEnum = tempexrateinfo.getExchangeAux().getConvertMode();
                }
                if (!isSameCurrency) {
                    if (convertModeEnum.equals((Object)ConvertModeEnum.DIRECTEXCHANGERATE)) {
                        localAmount = localAmount.multiply(exchangeRate).setScale(basescale, 4);
                        localTax = localTax.multiply(exchangeRate).setScale(basescale, 4);
                        localTaxAmount = localTaxAmount.multiply(exchangeRate).setScale(basescale, 4);
                    } else {
                        localAmount = localAmount.divide(exchangeRate, basescale, 4);
                        localTax = localTax.divide(exchangeRate, basescale, 4);
                        localTaxAmount = localTaxAmount.divide(exchangeRate, basescale, 4);
                    }
                }
                ps.setString(1, rs.getString("FSupplierID"));
                ps.setString(2, rs.getString("FCurrencyID"));
                ps.setBigDecimal(3, rs.getBigDecimal("fprice"));
                ps.setBigDecimal(4, rs.getBigDecimal("FTAXPRICE"));
                ps.setBigDecimal(5, rs.getBigDecimal("fnewAmount"));
                ps.setBigDecimal(6, localAmount);
                ps.setBigDecimal(7, rs.getBigDecimal("FTAXRATE"));
                ps.setBigDecimal(8, rs.getBigDecimal("FACTUALPRICE"));
                ps.setBigDecimal(9, rs.getBigDecimal("FACTUALTAXPRICE"));
                ps.setBigDecimal(10, rs.getBigDecimal("FTAX"));
                ps.setBigDecimal(11, rs.getBigDecimal("ftaxAmount"));
                ps.setBigDecimal(12, rs.getBigDecimal("FDISCOUNTAMOUNT"));
                ps.setBigDecimal(13, localTaxAmount);
                ps.setBigDecimal(14, localTax);
                ps.setBigDecimal(15, rs.getBigDecimal("fdiscountRate"));
                ps.setBigDecimal(16, rs.getBigDecimal("fexchangeRate"));
                ps.setString(17, rs.getString("fSourceBillEntryId"));
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException("Sql execute exception : " + updatesql.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        sql.setLength(0);
        sql.append(" update T_SM_PurRequest req ");
        sql.append(" set (ftotalAmount,FLocalTotalAmount, ftotalTaxAmount,flocalTotalTaxAmount,ftotalTax) ");
        sql.append(" =( ");
        sql.append(" select a.FtotalAmount,a.FLocalTotalAmount,a.FtotalTaxAmount,a.FlocalTotalTaxAmount,a.FtotalTax from ");
        sql.append(" (select isnull(sum(famount),0) as FtotalAmount, isnull(sum(flocalamount),0) as FLocalTotalAmount,isnull(sum(ftaxAmount),0) as FtotalTaxAmount, ");
        sql.append(" isnull(sum(FLOCALTAXAMOUNT),0) as FlocalTotalTaxAmount,isnull(sum(ftax),0) as FtotalTax ");
        sql.append("  from t_sm_purrequestentry  ");
        sql.append(" where T_SM_PurRequestEntry.fparentid in (");
        sql.append(" select fSourceBillId from T_SM_PurQuotationEntry ");
        sql.append(" where fparentid = '").append(aPurQuotationInfo.getId().toString()).append("') )");
        sql.append(" as a ");
        sql.append(" )");
        sql.append(" where req.FID in (select fSourceBillId from T_SM_PurQuotationEntry ");
        sql.append(" where fparentid = '").append(aPurQuotationInfo.getId().toString()).append("') ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" update T_SM_PurRequest a set FIsInTax = (select FIsRevenue from T_SM_PurQuotation where fid ='");
        sql.append(aPurQuotationInfo.getId().toString()).append("') ").append("where fid in (");
        sql.append(" select fSourceBillId from T_SM_PurQuotationEntry ");
        sql.append(" where fparentid = '").append(aPurQuotationInfo.getId().toString()).append("')");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private boolean isWritePurQue(Context ctx, PurQuotationInfo aPurQuotationInfo) throws EASBizException, BOSException {
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        boolean isWritePurQue = false;
        ObjectUuidPK orgPk = new ObjectUuidPK(aPurQuotationInfo.getPurchaseOrgUnit().getId());
        String strWritePurQue = ipc.getParamValue((IObjectPK)orgPk, "PURQUO001");
        if (strWritePurQue != null && strWritePurQue.trim().length() != 0 && strWritePurQue.trim().equalsIgnoreCase("true")) {
            isWritePurQue = true;
        }
        return isWritePurQue;
    }

    @Override
    protected void _calcelBill(Context ctx, IObjectPK pk, String reasSon) throws BOSException, EASBizException {
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
        PurQuotationEntryInfo aPurQuotationInfoEntry = null;
        IObjectPK[] pks = new IObjectPK[aPurQuotationInfo.getEntries().size()];
        int num = aPurQuotationInfo.getEntries().size();
        for (int i = 0; i < num; ++i) {
            aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(i);
            pks[i] = new ObjectUuidPK(aPurQuotationInfoEntry.getId());
        }
        if (aPurQuotationInfo.getEntries().size() > 0) {
            this._calcel(ctx, pks, reasSon);
        }
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            String updateSql = "update T_SM_PurQuotation set FBaseStatus =3 where fid ='" + pk.toString() + "'";
            batchStatement.addBatch(updateSql);
            batchStatement.executeBatch();
        }
        catch (Exception er) {
            try {
                throw new BOSException((Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void _auditBill(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            this._auditBill(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int cont = pks.length;
        for (int i = 0; i < cont; ++i) {
            this._unAudit(ctx, pks[i]);
        }
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        PurQuotationInfo purInfo = iPurQuotation.getPurQuotationInfo(pk);
        SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)purInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
        this.isSamePerson4UnAudit(ctx, aPurQuotationInfo);
        PurQuotationEntryInfo aPurQuotationInfoEntry = null;
        IObjectPK[] entryPks = new IObjectPK[aPurQuotationInfo.getEntries().size()];
        int num = aPurQuotationInfo.getEntries().size();
        for (int j = 0; j < num; ++j) {
            aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(j);
            entryPks[j] = new ObjectUuidPK(aPurQuotationInfoEntry.getId());
        }
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            int size = 0;
            if (aPurQuotationInfo != null && aPurQuotationInfo.getEntries() != null) {
                size = aPurQuotationInfo.getEntries().size();
            }
            if (aPurQuotationInfo != null && batchStatement != null && aPurQuotationInfo.getSourceBillType() != null && aPurQuotationInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-010bc0a814fd463ED552")) {
                this.writeBackPurQuotationPlanForUnAudit(ctx, (IObjectValue)aPurQuotationInfo);
                for (int j = 0; j < size; ++j) {
                    aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(j);
                    String updatePurPlanMEntrySql = "update T_SM_PurQuoPlanMEntry set FQuotationTimes = isnull(FQuotationTimes,0) - 1 where T_SM_PurQuoPlanMEntry.fid = '" + aPurQuotationInfoEntry.getSourceBillEntryId() + "'";
                    batchStatement.addBatch(updatePurPlanMEntrySql);
                }
            }
            String updateSql = "update T_SM_PurQuotation set FBaseStatus = 1,FAuditorId=null ,FAuditTime = null where fid ='" + pk.toString() + "'";
            String updateEntrySql = "update T_SM_PurQuotationEntry set FBaseStatus = " + SCMConstant.BILLSTATUS_AFTERUNAUDIT_ENTRY.getValue() + ",FAuditDate = null ,FEnabledUser = null where FParentID ='" + pk.toString() + "'";
            String updateEntryASInfoSql = "update T_SM_PurQuotationEntry set FIsUpdateASInfo = 0 where FParentID ='" + pk.toString() + "'";
            batchStatement.addBatch(updateSql);
            batchStatement.addBatch(updateEntrySql);
            batchStatement.addBatch(updateEntryASInfoSql);
            batchStatement.executeBatch();
        }
        catch (Exception er) {
            try {
                throw new BOSException((Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, PurQuotationInfo info) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(this.getBOSType().toString());
        scmBizDataVO.setDelegatedOrgTypes(this.getDelegatedOrgTypes());
        PurEntryDataVO scmEntryDataVO = new PurEntryDataVO();
        scmEntryDataVO.setCurrencyInfo(info.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        this.initSCMBizDataVO(ctx, scmBizDataVO, info.getEntries());
        PurEntryDataVO purEntryDataVO = (PurEntryDataVO)scmBizDataVO.getScmEntryDataVO();
        purEntryDataVO.setMainOrgType(this.getMainBizOrgType());
        purEntryDataVO.setMainOrg(this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info));
        return scmBizDataVO;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    protected HashSet getDelegatedOrgTypes() {
        HashSet<OrgType> delegateOrgTypeSet = new HashSet<OrgType>();
        delegateOrgTypeSet.add(OrgType.Admin);
        delegateOrgTypeSet.add(OrgType.Company);
        delegateOrgTypeSet.add(OrgType.Storage);
        return delegateOrgTypeSet;
    }

    protected String getBillTypeId() {
        return "510b6503-0105-1000-e000-010bc0a814fd463ED552";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _alter(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException {
        int pc;
        int pcCount;
        int i2;
        PurQuotationInfo oldPurQuotationInfo = null;
        this.iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        try {
            oldPurQuotationInfo = this.iPurQuotation.getPurQuotationInfo(pk);
            if (this.checkIsAllowAlter(oldPurQuotationInfo) == 1) {
                // empty if block
            }
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
        this.currentUser = (UserInfo)ctx.get((Object)"UserInfo");
        int version = 1;
        PurQuotationInfo newPurQuotationInfo = (PurQuotationInfo)model;
        PurQuotationEntryInfo entryInfo = null;
        PurQuotationEntryCollection oldPurEntryCollection = null;
        PurQuotationEntryCollection newPurEntryCollection = null;
        PurQuotationEntryInfo newPurEntryInfo = null;
        if (oldPurQuotationInfo != null) {
            oldPurEntryCollection = oldPurQuotationInfo.getEntries();
        }
        if (newPurQuotationInfo != null) {
            newPurEntryCollection = newPurQuotationInfo.getEntries();
        }
        boolean isError = false;
        StringBuffer errorMsg = new StringBuffer();
        if (oldPurEntryCollection != null && newPurEntryCollection != null) {
            int num = oldPurEntryCollection.size();
            for (i2 = 0; i2 < num; ++i2) {
                newPurEntryInfo = newPurEntryCollection.get(i2);
                if (newPurEntryInfo.getBaseStatus().getValue() == 4 || ObjectValueUtil.objectValueEquals((Context)ctx, (AbstractObjectValue)newPurEntryInfo, (AbstractObjectValue)newPurEntryInfo)) continue;
                if (isError) {
                    errorMsg.append(", ");
                }
                errorMsg.append(i2 + 1);
                isError = true;
            }
        }
        if (isError) {
            try {
                throw new QuotationException(PurQuotationException.QUO_ENTRY_CANNOT_ALTER, (Object[])new String[]{errorMsg.toString()});
            }
            catch (QuotationException i2) {
                // empty catch block
            }
        }
        if (oldPurQuotationInfo != null && oldPurQuotationInfo.getEditionNumber() > 1) {
            version = oldPurQuotationInfo.getEditionNumber();
        }
        if (newPurQuotationInfo != null) {
            newPurQuotationInfo.setEditionNumber(version + 1);
            newPurQuotationInfo.setOldStatus(newPurQuotationInfo.getBaseStatus());
            newPurQuotationInfo.setBaseStatus(BillBaseStatusEnum.ALTERING);
            pcCount = newPurQuotationInfo.getEntries().size();
            for (pc = 0; pc < pcCount; ++pc) {
                entryInfo = newPurQuotationInfo.getEntries().get(pc);
                if (entryInfo.getBaseStatus().getValue() == 0 || entryInfo.getBaseStatus().getValue() == 1 || entryInfo.getBaseStatus().getValue() == 2 || entryInfo.getBaseStatus().getValue() == 4) {
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                }
                if (entryInfo.getBaseStatus().getValue() == 4) {
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.ALTERING);
                }
                this.setZero(entryInfo);
            }
            if (newPurQuotationInfo.getEntries() != null && newPurQuotationInfo.getEntries().size() > 0) {
                for (i2 = 0; i2 < newPurQuotationInfo.getEntries().size(); ++i2) {
                    newPurQuotationInfo.getEntries().get(i2).setIsUpdateASInfo(false);
                }
            }
        }
        if (oldPurQuotationInfo != null) {
            oldPurQuotationInfo.setOldID(oldPurQuotationInfo.getId().toString());
            oldPurQuotationInfo.setId(null);
            oldPurQuotationInfo.setOldStatus(oldPurQuotationInfo.getBaseStatus());
            oldPurQuotationInfo.setAlterPerson(this.currentUser);
            oldPurQuotationInfo.setAlterDate(new Timestamp(new Date().getTime()));
            oldPurQuotationInfo.setEditionNumber(version);
            oldPurQuotationInfo.setOldStatus(oldPurQuotationInfo.getBaseStatus());
            oldPurQuotationInfo.setBaseStatus(BillBaseStatusEnum.VERSION);
            oldPurEntryCollection = oldPurQuotationInfo.getEntries();
            if (oldPurEntryCollection != null) {
                pcCount = oldPurEntryCollection.size();
                for (pc = 0; pc < pcCount; ++pc) {
                    entryInfo = oldPurEntryCollection.get(pc);
                    entryInfo.setOldID(entryInfo.getId());
                    entryInfo.setId(null);
                    entryInfo.setOldStatus(entryInfo.getBaseStatus());
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.VERSION);
                    this.setZero(entryInfo);
                }
            }
        }
        try {
            this.innerAddnew(ctx, (IObjectValue)oldPurQuotationInfo);
            super._update(ctx, pk, (IObjectValue)newPurQuotationInfo);
            return;
        }
        catch (EASBizException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected int checkIsAllowAlter(PurQuotationInfo purQuotationInfo) throws PurQuotationException {
        if (purQuotationInfo.getBaseStatus().getValue() != 4) {
            throw new PurQuotationException(PurQuotationException.QUO_CANNOT_ALTER, new String[]{purQuotationInfo.getBaseStatus().toString()});
        }
        return 1;
    }

    private void writeBackPurQuotationPlanForUnAudit(Context ctx, IObjectValue model) throws Exception {
        StringBuffer ids;
        PurQuotationInfo purQuotationInfo = (PurQuotationInfo)model;
        if (UIRuleUtil.isNotNull((String)purQuotationInfo.getPurQuotationPlanID())) {
            int size = 0;
            PurQuotationEntryInfo aPurQuotationInfoEntry = null;
            if (purQuotationInfo != null && purQuotationInfo.getEntries() != null) {
                size = purQuotationInfo.getEntries().size();
            }
            ids = new StringBuffer("(");
            for (int i = 0; i < size; ++i) {
                aPurQuotationInfoEntry = purQuotationInfo.getEntries().get(i);
                if (i == 0) {
                    ids.append("'").append(aPurQuotationInfoEntry.getSourceBillSEntryID()).append("'");
                    continue;
                }
                ids.append(",'").append(aPurQuotationInfoEntry.getSourceBillSEntryID()).append("'");
            }
        } else {
            return;
        }
        ids.append(")");
        StringBuffer updateSql = new StringBuffer();
        updateSql.append("update T_SM_PurQuoPlanSEntry set ");
        updateSql.append("FQuoteStyle=null");
        updateSql.append(", FQty=null");
        updateSql.append(", FQtyTo=null");
        updateSql.append(", FPrice=null");
        updateSql.append(", FTaxRate=null");
        updateSql.append(", FTaxPrice=null");
        updateSql.append(", FDiscountStyle=null");
        updateSql.append(", FDiscount=null");
        updateSql.append(", FActualPrice=null");
        updateSql.append(", FActualTaxPrice=null");
        updateSql.append(", FPaymentSytleID=null, FPaymentConditionID=null");
        updateSql.append(", FPurLeadTime=null");
        updateSql.append(", FWarrantyDate=null");
        updateSql.append(", FPackagePrice=null");
        updateSql.append(", FCarriagePrice=null");
        updateSql.append(", FMiscellaneous=null");
        updateSql.append(", FEnableDate=null");
        updateSql.append(", FDisibleDate=null");
        updateSql.append(" where FID in ").append(ids);
        DbUtil.execute((Context)ctx, (String)updateSql.toString());
    }

    @Override
    protected void _returnWrite(Context ctx, IObjectValue model) throws BOSException {
        PurQuotationInfo purQuotationInfo = (PurQuotationInfo)model;
        try {
            if (!UIRuleUtil.isNotNull((String)purQuotationInfo.getPurQuotationPlanID())) {
                return;
            }
            this.upDatePurQuoataionPlanById(ctx, purQuotationInfo);
        }
        catch (Exception e) {
            try {
                throw new PurQuotationException(PurQuotationException.QUO_DATEIMPORT_OR_CHECK, new String[]{e.getMessage()});
            }
            catch (PurQuotationException e1) {
                throw new BOSException((Throwable)((Object)e1));
            }
        }
    }

    private boolean upDatePurQuoataionPlanById(Context ctx, PurQuotationInfo purQuotationInfo) throws Exception {
        boolean iSSucceed = false;
        PurQuotationEntryInfo purQuotationEntryInfo = null;
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("update T_SM_PurQuoPlanSEntry set ");
            sql.append("FQuoteStyle=?");
            sql.append(", FQty=?");
            sql.append(", FQtyTo=?");
            sql.append(", FPrice=?");
            sql.append(", FTaxRate=?");
            sql.append(", FTaxPrice=?");
            sql.append(", FDiscountStyle=?");
            sql.append(", FDiscount=?");
            sql.append(", FActualPrice=?");
            sql.append(", FActualTaxPrice=?");
            sql.append(", FPaymentSytleID=?, FPaymentConditionID=?");
            sql.append(", FPurLeadTime=?");
            sql.append(", FWarrantyDate=?");
            sql.append(", FPackagePrice=?");
            sql.append(", FCarriagePrice=?");
            sql.append(", FMiscellaneous=?");
            sql.append(", FEnableDate=?");
            sql.append(", FDisibleDate=?");
            sql.append(" where FID=? ");
            ps = conn.prepareStatement(sql.toString());
            for (int index = 0; index < purQuotationInfo.getEntries().size(); ++index) {
                purQuotationEntryInfo = purQuotationInfo.getEntries().get(index);
                this.batchUpdatePurQuotationPlan(ctx, purQuotationInfo, purQuotationEntryInfo, ps, sdf);
            }
            ps.executeBatch();
            iSSucceed = true;
        }
        catch (SQLException e) {
            try {
                iSSucceed = false;
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps);
                SQLUtils.cleanup(conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps);
        SQLUtils.cleanup((Connection)conn);
        return iSSucceed;
    }

    private void batchUpdatePurQuotationPlan(Context ctx, PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo purQuotationEntryInfo, PreparedStatement ps, SimpleDateFormat sdf) throws SQLException, EASBizException, BOSException {
        MaterialInfo materialInfo = null;
        MeasureUnitInfo mUnitInfo = null;
        IMeasureUnit iMeasureUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
        int pricePrecision = 0;
        int qtyPrecision = 0;
        if (purQuotationEntryInfo.getMaterial() != null && purQuotationEntryInfo.getMaterial().getId() != null) {
            IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
            materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)purQuotationEntryInfo.getMaterial().getId().toString())));
            pricePrecision = materialInfo.getPricePrecision();
        } else {
            IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
            if (purQuotationEntryInfo.getRowType() != null && purQuotationEntryInfo.getRowType().getId() != null) {
                RowTypeInfo rowTypeInfo = iRowType.getRowTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)purQuotationEntryInfo.getRowType().getId().toString())));
                pricePrecision = rowTypeInfo.getPrecision();
            }
        }
        if (materialInfo != null && materialInfo.getBaseUnit() != null && materialInfo.getBaseUnit().getId() != null) {
            mUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(materialInfo.getBaseUnit().getId()));
            qtyPrecision = this.changeTableColPrecision(ctx, materialInfo, mUnitInfo);
        } else if (purQuotationEntryInfo.getBaseUnit() != null && purQuotationEntryInfo.getBaseUnit().getId() != null) {
            mUnitInfo = iMeasureUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(purQuotationEntryInfo.getBaseUnit().getId()));
            qtyPrecision = mUnitInfo.getQtyPrecision();
        }
        ps.setInt(1, purQuotationInfo.getQuoteType().getValue());
        if (purQuotationEntryInfo.getQtyFrom() != null) {
            ps.setBigDecimal(2, purQuotationEntryInfo.getQtyFrom().setScale(qtyPrecision, 4));
        } else {
            ps.setBigDecimal(2, SysConstant.BIGZERO);
        }
        if (purQuotationEntryInfo.getQtyTo() != null) {
            ps.setBigDecimal(3, purQuotationEntryInfo.getQtyTo().setScale(qtyPrecision, 4));
        } else {
            ps.setBigDecimal(3, BigDecimal.valueOf(0L));
        }
        ps.setBigDecimal(4, purQuotationEntryInfo.getPrice().setScale(pricePrecision, 4));
        if (purQuotationEntryInfo.getTaxRate() != null) {
            ps.setBigDecimal(5, purQuotationEntryInfo.getTaxRate().setScale(2));
        } else {
            ps.setBigDecimal(5, SysConstant.BIGZERO);
        }
        ps.setBigDecimal(6, purQuotationEntryInfo.getTaxPrice().setScale(pricePrecision, 4));
        ps.setInt(7, purQuotationEntryInfo.getDiscountType().getValue());
        if (purQuotationEntryInfo.getDiscount() != null) {
            ps.setBigDecimal(8, purQuotationEntryInfo.getDiscount());
        } else {
            ps.setBigDecimal(8, SysConstant.BIGZERO);
        }
        if (purQuotationEntryInfo.getActualPrice() != null) {
            ps.setBigDecimal(9, purQuotationEntryInfo.getActualPrice().setScale(pricePrecision, 4));
        } else {
            ps.setBigDecimal(9, SysConstant.BIGZERO);
        }
        if (purQuotationEntryInfo.getActualTaxPrice() != null) {
            ps.setBigDecimal(10, purQuotationEntryInfo.getActualTaxPrice().setScale(pricePrecision, 4));
        } else {
            ps.setBigDecimal(10, SysConstant.BIGZERO);
        }
        ps.setString(11, purQuotationInfo.getPaymentType().getId().toString());
        ps.setString(12, purQuotationInfo.getPaymentCondition().getId().toString());
        ps.setInt(13, purQuotationEntryInfo.getPurAdvanceDate());
        ps.setInt(14, purQuotationEntryInfo.getInsureQualityDate());
        if (purQuotationEntryInfo.getPackagingExp() != null) {
            ps.setBigDecimal(15, purQuotationEntryInfo.getPackagingExp().setScale(2));
        } else {
            ps.setBigDecimal(15, purQuotationEntryInfo.getPackagingExp());
        }
        if (purQuotationEntryInfo.getCarriage() != null) {
            ps.setBigDecimal(16, purQuotationEntryInfo.getCarriage().setScale(2));
        } else {
            ps.setBigDecimal(16, purQuotationEntryInfo.getCarriage());
        }
        if (purQuotationEntryInfo.getIncidentalExpenses() != null) {
            ps.setBigDecimal(17, purQuotationEntryInfo.getIncidentalExpenses().setScale(2));
        } else {
            ps.setBigDecimal(17, purQuotationEntryInfo.getIncidentalExpenses());
        }
        ps.setDate(18, (java.sql.Date)purQuotationInfo.getEnabledDate());
        ps.setDate(19, (java.sql.Date)purQuotationInfo.getUnEffectiveTime());
        ps.setString(20, purQuotationEntryInfo.getSourceBillSEntryID());
        ps.addBatch();
    }

    private int changeTableColPrecision(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo measureUnitInfo) throws EASBizException, BOSException {
        IMultiMeasureUnit imultiUnit;
        MultiMeasureUnitInfo multiUnitInfo;
        int precision = 0;
        precision = measureUnitInfo != null && materialInfo != null ? ((multiUnitInfo = (imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx)).getMultiUnit(materialInfo.getId().toString(), measureUnitInfo.getId().toString())) != null ? multiUnitInfo.getQtyPrecision() : 4) : 4;
        return precision;
    }

    @Override
    protected void _updateBillBaseStatus(Context ctx, String fid) throws BOSException {
        ctx.put((Object)"isAlert", (Object)"1");
    }

    @Override
    protected IRowSet _getEntryByImportEntry(Context ctx, String entryID) throws BOSException {
        this.rowSet = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from T_SM_PurQuotationEntry where fid='" + entryID.trim() + "'");
        this.rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return this.rowSet;
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        SCMBillBaseInfo scmInfo = null;
        if (entries != null && entries.length > 0) {
            if (entries[0].get(0) instanceof IObjectValue) {
                scmInfo = (SCMBillBaseInfo)entries[0].get(0);
                ObjectUuidPK pk = new ObjectUuidPK(scmInfo.getId());
                if (ctx.get((Object)"isAlert") != null && ctx.get((Object)"isAlert").equals("1")) {
                    ctx.put((Object)"isAlert", null);
                    ServiceStateManager.getInstance().enableNextCallService("PERMISSION_SERVICE");
                    this.alter(ctx, (IObjectPK)pk, (PurQuotationInfo)scmInfo);
                    ServiceStateManager.getInstance().disableNextCallService("PERMISSION_SERVICE");
                    return null;
                }
                return super.batchSubmitRelations(ctx, entries);
            }
            PurQuotationInfo model = null;
            for (int i = 0; i < entries.length; ++i) {
                Class[] parameterTypes = new Class[]{IObjectValue.class};
                model = this.getPurQuotationInfo(ctx, (IObjectPK)new ObjectUuidPK(String.valueOf(entries[i].get(0))));
                entries[i] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
            }
            return super.batchSubmitRelations(ctx, entries);
        }
        return null;
    }

    @Override
    protected void _agreeAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.batchExecute(ctx, new Object[]{pk}, BatchActionEnum.AUDIT);
        if (pk == null) {
            return;
        }
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        PurQuotationInfo aPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
        PurQuotationEntryInfo aPurQuotationInfoEntry = null;
        Connection con = null;
        Statement statement = null;
        Statement batchStatement = null;
        Date today = new Date();
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            batchStatement = con.createStatement();
            String updateSql = "update T_SM_PurQuotation set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = to_date('" + simpleFormat.format(today) + "') where fid ='" + pk.toString() + "'";
            batchStatement.addBatch(updateSql);
            String updateEntrySql = "update T_SM_PurQuotationEntry set FBaseStatus = 4 where FParentID ='" + pk.toString() + "'";
            batchStatement.addBatch(updateEntrySql);
            int num = aPurQuotationInfo.getEntries().size();
            for (int i = 0; i < num; ++i) {
                aPurQuotationInfoEntry = aPurQuotationInfo.getEntries().get(i);
                String updatePurPlanMEntrySql = "update T_SM_PurQuoPlanMEntry set FQuotationTimes = isnull(FQuotationTimes,0) + 1 where T_SM_PurQuoPlanMEntry.fid = '" + aPurQuotationInfoEntry.getSourceBillEntryId() + "'";
                batchStatement.addBatch(updatePurPlanMEntrySql);
            }
            if (aPurQuotationInfo.getPurQuotationPlanID() != null) {
                this._returnWrite(ctx, (IObjectValue)aPurQuotationInfo);
            }
            this.writeBackPurRequest(ctx, aPurQuotationInfo);
            String sql = "delete from T_SM_SupplyInfo where FSourceBillNo='" + aPurQuotationInfo.getNumber() + "'";
            batchStatement.addBatch(sql);
            batchStatement.executeBatch();
            this.updateSupplierPrice(ctx, pk, aPurQuotationInfo);
        }
        catch (Exception er) {
            try {
                throw new BOSException((Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void updateSupplierPrice(Context ctx, IObjectPK pk, PurQuotationInfo aPurQuotationInfo) throws BOSException, EASBizException {
        String strUpdateASInfo;
        boolean isUpdateASInfo = false;
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK purOrgpk = null;
        if (aPurQuotationInfo != null && aPurQuotationInfo.getPurchaseOrgUnit() != null) {
            purOrgpk = new ObjectUuidPK(aPurQuotationInfo.getPurchaseOrgUnit().getId().toString());
        }
        if ((strUpdateASInfo = ipc.getParamValue(purOrgpk, "PURQUOT001")) != null && strUpdateASInfo.trim().length() != 0 && strUpdateASInfo.trim().equalsIgnoreCase("true")) {
            for (int i = 0; i < aPurQuotationInfo.getEntries().size(); ++i) {
                if (aPurQuotationInfo.getEntries().get(i).getMaterial() == null) {
                    isUpdateASInfo = false;
                    break;
                }
                isUpdateASInfo = true;
            }
        }
        if (isUpdateASInfo && (aPurQuotationInfo.getPurQuotationPlanID() == null || aPurQuotationInfo.getPurQuotationPlanID().length() <= 0)) {
            IPurQuotationEntry iPurQuoEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
            iPurQuoEntry.updateSupplierPrice(new IObjectPK[]{pk});
        }
    }

    @Override
    protected void _disaccordAlter(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        PurQuotationInfo delPurQuotationInfo = iPurQuotation.getPurQuotationInfo(pk);
        int version = 1;
        version = delPurQuotationInfo.getEditionNumber();
        AbstractPurQuotationInfo rePurQuotation = null;
        Connection con = null;
        Statement batchStatement = null;
        try {
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            String checkSql = "select FID from T_SM_PurQuotation where FOldID='" + delPurQuotationInfo.getId().toString() + "' and FEditionNumber=" + Integer.toString(version - 1);
            IRowSet checkSet = DbUtil.executeQuery((Context)ctx, (String)checkSql);
            if (checkSet.next() && checkSet.getString(1) != null) {
                rePurQuotation = iPurQuotation.getPurQuotationInfo((IObjectPK)new ObjectUuidPK(checkSet.getString(1)));
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        if (rePurQuotation != null) {
            PurQuotationEntryInfo entryInfo = null;
            PurQuotationEntryCollection rePurQuotationEntries = rePurQuotation.getEntries();
            rePurQuotation.setAlterDate(null);
            rePurQuotation.setAlterPerson(null);
            rePurQuotation.setBaseStatus(rePurQuotation.getOldStatus());
            if (rePurQuotationEntries != null) {
                int pcCount = rePurQuotationEntries.size();
                for (int pc = 0; pc < pcCount; ++pc) {
                    entryInfo = rePurQuotationEntries.get(pc);
                    entryInfo.setId(entryInfo.getOldID());
                    entryInfo.setBaseStatus(entryInfo.getOldStatus());
                }
            }
        }
        this.innerDelete(ctx, pk);
        if (rePurQuotation != null && rePurQuotation.getId() != null) {
            this.innerDelete(ctx, (IObjectPK)new ObjectUuidPK(rePurQuotation.getId().toString()));
        }
        if (rePurQuotation != null && rePurQuotation.getOldID() != null) {
            this.innerAddnew(ctx, (IObjectPK)new ObjectUuidPK(rePurQuotation.getOldID().toString()), (IObjectValue)rePurQuotation);
        }
    }

    @Override
    protected void _calcel(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this._calcel(ctx, pks, null);
    }

    @Override
    protected void _issueBill(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurQuotationInfo purquoInfo;
        if (PurOrderUtils.isPurSyn(ctx)) {
            purquoInfo = this.getPurQuotationInfo(ctx, pk);
            if (purquoInfo != null && purquoInfo.getSupplier() == null) {
                throw new PurQuotationException(PurQuotationException.QUO_NULL_SUPPLIER);
            }
            if (purquoInfo != null && purquoInfo.getPurchaseOrgUnit() == null) {
                throw new PurQuotationException(PurQuotationException.QUO_NULL_PURORGUNIT);
            }
            if (!PurOrderUtils.isSupplierPurSyn(ctx, purquoInfo.getSupplier().getId().toString(), purquoInfo.getPurchaseOrgUnit().getId().toString())) {
                throw new PurQuotationException(PurQuotationException.QUO_ENABLE_SUP_PURSYN);
            }
            if (purquoInfo != null && !QuoteStyleEnum.WEB.equals((Object)purquoInfo.getQuoteType())) {
                throw new PurQuotationException(PurQuotationException.QUO_QUOTYPE_NO_WEB);
            }
            if (purquoInfo != null && MakeBillFlagEnum.SUPPLIER.equals((Object)purquoInfo.getMakeBillFlag())) {
                throw new PurQuotationException(PurQuotationException.QUO_NET_PRICE_UNDO, new String[]{this.getServerResource("OPERATOR_ISSUE", ctx)});
            }
            if (purquoInfo != null && !BillBaseStatusEnum.TEMPORARILYSAVED.equals((Object)purquoInfo.getBaseStatus())) {
                throw new PurQuotationException(PurQuotationException.QUO_BILLSTATUE_NO_SAVE);
            }
            int size = purquoInfo.getEntries().size();
            if (size == 0) {
                throw new PurQuotationException(PurQuotationException.QUO_ENTYR_SIZE_ZERO);
            }
            PurQuotationEntryInfo entryInfo = null;
            for (int i = 0; i < size; ++i) {
                entryInfo = purquoInfo.getEntries().get(i);
                if (entryInfo.getMaterial() == null && entryInfo.getMaterialGroup() == null && entryInfo.getMaterialName() == null) {
                    throw new PurQuotationException(PurQuotationException.QUO_MAINFO_OR_MGINFO_NULL, new String[]{1 + i + ""});
                }
                if (entryInfo.getUnit() != null) continue;
                throw new PurQuotationException(PurQuotationException.QUO_UNIT_IS_NULL, new String[]{1 + i + ""});
            }
        } else {
            throw new PurQuotationException(PurQuotationException.QUO_ENABLE_PURSYN);
        }
        purquoInfo.setBaseStatus(BillBaseStatusEnum.PUBLISHED);
        purquoInfo.setIssuer(ContextUtil.getCurrentUserInfo((Context)ctx));
        purquoInfo.setIssueTime(new Timestamp(System.currentTimeMillis()));
        super.update(ctx, pk, (CoreBaseInfo)purquoInfo);
    }

    public String getParamCon4Audit() {
        return "PUREXA001";
    }

    public String getParamCon4UnAudit() {
        return "PUREXA002";
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        PurQuotationInfo info = null;
        SupplierCompanyInfoInfo companyInfo = null;
        SupplierCompanyInfoCollection coln = null;
        SupplierInfo supinfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurQuotationInfo)collection.getObject(i);
            supinfo = info.getSupplier();
            CompanyOrgUnitInfo comOrgInfo = InvServerUtils.getCompanyInfoForPurchase((Context)ctx, (PurchaseOrgUnitInfo)info.getPurchaseOrgUnit());
            if ((info.getPaymentType() == null || info.getPaymentCondition() == null) && info.getSupplier() != null) {
                String supplierID = info.getSupplier().getId().toString();
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)supplierID, CompareType.EQUALS));
                if (comOrgInfo != null) {
                    filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)comOrgInfo.getId().toString(), CompareType.EQUALS));
                }
                viewInfo.setFilter(filter);
                coln = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(viewInfo);
                if (coln != null && coln.size() > 0) {
                    companyInfo = coln.get(0);
                    if (info.getPaymentType() == null) {
                        info.setPaymentType(companyInfo.getPaymentType());
                    }
                    if (info.getPaymentCondition() == null) {
                        info.setPaymentCondition(companyInfo.getPayCondition());
                    }
                }
            }
            if (info != null) {
                this.setDefaultPrivacyDate(info);
            }
            if (info == null || info.getSupplier() == null || info.getSupplier().getTaxRate() == null || SCMConstant.BIGDECIMAL_ZERO.compareTo(info.getSupplier().getTaxRate()) == 0) continue;
            PurQuotationEntryInfo entry = null;
            for (int k = 0; k < info.getEntries().size(); ++k) {
                entry = info.getEntries().get(k);
                if (entry.getTaxRate() != null && SCMConstant.BIGDECIMAL_ZERO.compareTo(info.getSupplier().getTaxRate()) == 0 || info.getSupplier().getTaxRate() == null) continue;
                entry.setTaxRate(info.getSupplier().getTaxRate());
            }
        }
    }

    private void setDefaultPrivacyDate(PurQuotationInfo info) {
        Date bizDate = null;
        bizDate = info.getBizDate();
        Calendar calender = Calendar.getInstance();
        calender.setTime(bizDate);
        calender.add(2, 1);
        calender.set(11, 23);
        calender.set(12, 59);
        calender.set(13, 59);
        calender.set(14, 999);
        info.setDisibleDate(calender.getTime());
        calender.setTime(info.getDisibleDate());
        calender.add(6, 10);
        info.setSecrecyDeadline(new Timestamp(calender.getTimeInMillis()));
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        SelectorItemCollection sic = super.getSelector(isNeedEntrySelector);
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        return sic;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("entries.*");
        selector.add("entries.material.assistAttr.id");
        PurQuotationInfo model = this.getPurQuotationInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }
}

