/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IPayCondition;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PayConditionCollection;
import com.kingdee.eas.basedata.assistant.PayConditionFactory;
import com.kingdee.eas.basedata.assistant.PayConditionInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupFactory;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonCollection;
import com.kingdee.eas.basedata.scm.sm.pur.PurchasePersonFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.sm.pur.DeliveryStyleEnum;
import com.kingdee.eas.scm.sm.pur.PurQuotationCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.QuoteStyleEnum;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;

public class PurQuotationDataImport
extends SCMDataImport {
    StringBuffer erroSB = new StringBuffer();
    PurQuotationInfo purQuotationInfoOld;
    public static final int DEFAULT_PRICISION = 2;
    private static final BigDecimal ZERO = new BigDecimal("0.0");
    public static final BigDecimal MAXVAL = new BigDecimal("1000000000000");
    UserInfo userInfo = null;
    ImportDataCache dataPool = new ImportDataCache();
    PurQuotationInfo purQuotationInfo = null;

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurQuotationFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    public int getSubmitType() {
        return 1;
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        Hashtable innerTable;
        this.userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        PurchaseOrgUnitInfo purOrgInfo = null;
        if (this.erroSB.length() > 0) {
            this.erroSB.delete(0, this.erroSB.length());
        }
        if (hsData == null || hsData.isEmpty()) {
            return null;
        }
        this.purQuotationInfo = null;
        Iterator rowIt = hsData.entrySet().iterator();
        boolean isFromSource = false;
        if (rowIt.hasNext()) {
            Map.Entry entry = rowIt.next();
            innerTable = (Hashtable)entry.getValue();
            String tempNumber = this.getDataString(innerTable, "FNumber");
            purOrgInfo = this.getPurchaseOrgUnit(ctx, this.getDataString(innerTable, "FPurchaseOrgUnit"));
            String sourceBillID = this.getDataString(innerTable, "FSourceBillID");
            String billType = this.getDataString(innerTable, "FSourceBillType");
            boolean bl = isFromSource = !StringUtil.isEmptyString((String)sourceBillID) && !StringUtil.isEmptyString((String)billType);
            if (isFromSource) {
                try {
                    if (tempNumber == null) {
                        throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "PurNumber_Not_Null", ctx) + "\n" + this.erroSB.append("\n"));
                    }
                    this.purQuotationInfo = this.getPurQuotationInfoFromSource(sourceBillID, tempNumber, billType, innerTable, purOrgInfo, ctx);
                    if (!this.purQuotationInfo.getNumber().equals(tempNumber)) {
                        throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "SourceBillID_Not_According_PurNumber", ctx) + "\n" + this.erroSB.append("\n"));
                    }
                    if (!this.purQuotationInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) && this.isSltImportUpdate()) {
                        throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "UpdateBill_BaseStatus_Not_Saved", ctx) + "\n" + this.erroSB.append("\n"));
                    }
                    this.setPurQuotationInfo(ctx, this.purQuotationInfo, innerTable, true);
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
                catch (EASBizException e) {
                    throw new TaskExternalException(e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.purQuotationInfo = new PurQuotationInfo();
                this.setPurQuotationInfo(ctx, this.purQuotationInfo, innerTable, false);
            }
            catch (BOSException e) {
                this.recycleNumber(ctx, this.purQuotationInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (EASBizException e) {
                this.recycleNumber(ctx, this.purQuotationInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (TaskExternalException e) {
                this.recycleNumber(ctx, this.purQuotationInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        for (int i = 0; i < hsData.entrySet().size(); ++i) {
            innerTable = (Hashtable)hsData.get(i);
            try {
                this.setEntryValue(ctx, this.purQuotationInfo, innerTable, isFromSource);
                this.calAllAmount(ctx, this.purQuotationInfo);
                continue;
            }
            catch (EASBizException e) {
                if (!isFromSource) {
                    this.recycleNumber(ctx, this.purQuotationInfo);
                }
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (BOSException e) {
                if (!isFromSource) {
                    this.recycleNumber(ctx, this.purQuotationInfo);
                }
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (SQLException e) {
                if (!isFromSource) {
                    this.recycleNumber(ctx, this.purQuotationInfo);
                }
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (ParseException e) {
                if (!isFromSource) {
                    this.recycleNumber(ctx, this.purQuotationInfo);
                }
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            catch (TaskExternalException e) {
                this.recycleNumber(ctx, this.purQuotationInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        if (this.erroSB.length() > 0) {
            if (!isFromSource) {
                this.recycleNumber(ctx, this.purQuotationInfo);
            }
            throw new TaskExternalException(this.erroSB.toString());
        }
        this.purQuotationInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return this.purQuotationInfo;
    }

    private void calAllAmount(Context ctx, PurQuotationInfo purQuotationInfo) {
        PurQuotationEntryCollection pec = purQuotationInfo.getEntries();
        for (int i = 0; i < pec.size(); ++i) {
            PurQuotationEntryInfo entryInfo = purQuotationInfo.getEntries().get(i);
            this.calEntry(purQuotationInfo, entryInfo);
        }
        this.calTotalTaxAmount(purQuotationInfo);
        this.calTotalAmount(purQuotationInfo);
    }

    private void calEntry(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        if (purQuotationInfo.isIsRevenue()) {
            this.calEntryDiscountAmount(purQuotationInfo, entryInfo);
            this.calEntryTaxAmount(purQuotationInfo, entryInfo);
            this.calEntryTax(purQuotationInfo, entryInfo);
            this.calEntryAmount(purQuotationInfo, entryInfo);
            this.calEntryTotalAmount(purQuotationInfo, entryInfo);
        } else {
            this.calEntryAmount(purQuotationInfo, entryInfo);
            this.calEntryTax(purQuotationInfo, entryInfo);
            this.calEntryTaxAmount(purQuotationInfo, entryInfo);
            this.calEntryDiscountAmount(purQuotationInfo, entryInfo);
            this.calEntryTotalAmount(purQuotationInfo, entryInfo);
        }
    }

    private void calEntryAmount(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        int scale = 2;
        BigDecimal amount = ZERO;
        boolean isRevenue = purQuotationInfo.isIsRevenue();
        BigDecimal qty = entryInfo.getAmount();
        BigDecimal actualPrice = entryInfo.getActualPrice();
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        if (isRevenue) {
            BigDecimal taxAmount = entryInfo.getTaxAmount();
            BigDecimal tax = entryInfo.getTax();
            if (taxAmount != null) {
                amount = taxAmount.subtract(tax).setScale(scale, 4);
            }
        } else {
            amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualPrice, (int)scale);
        }
        entryInfo.setNewAmount(amount);
    }

    private void calEntryDiscountAmount(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        BigDecimal qty = entryInfo.getAmount();
        DiscountModeEnum discounMode = entryInfo.getDiscountType();
        BigDecimal discount = entryInfo.getDiscount();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int scale = entryInfo.getAmount().precision();
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        if (null != discounMode) {
            BigDecimal discountAmount = ZERO;
            discountAmount = purQuotationInfo.isIsRevenue() ? CalculateUtils.calDiscountAmount((DiscountModeEnum)discounMode, (BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale, (boolean)true) : CalculateUtils.calDiscountAmount((DiscountModeEnum)discounMode, (BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale, (boolean)false);
            entryInfo.setDiscountAmount(discountAmount);
        }
    }

    private void calTotalTaxAmount(PurQuotationInfo purQuotationInfo) {
        int entrySize = purQuotationInfo.getEntries().size();
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal entryTaxAmount = ZERO;
        int scale = 2;
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        for (int i = 0; i < entrySize; ++i) {
            PurQuotationEntryInfo entryInfo = purQuotationInfo.getEntries().get(i);
            entryTaxAmount = entryInfo.getTaxAmount();
            if (entryTaxAmount == null) continue;
            totalTaxAmount = totalTaxAmount.add(entryTaxAmount);
        }
        totalTaxAmount = totalTaxAmount.setScale(scale, 4);
        purQuotationInfo.setTotalTaxAmount(totalTaxAmount);
    }

    private void calTotalAmount(PurQuotationInfo purQuotationInfo) {
        int entrySize = purQuotationInfo.getEntries().size();
        BigDecimal totalAmount = ZERO;
        BigDecimal entryTotalAmount = ZERO;
        int scale = 2;
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        for (int i = 0; i < entrySize; ++i) {
            PurQuotationEntryInfo entryInfo = purQuotationInfo.getEntries().get(i);
            entryTotalAmount = entryInfo.getTotalAmount();
            if (entryTotalAmount == null) continue;
            totalAmount = totalAmount.add(entryTotalAmount);
        }
        totalAmount = totalAmount.setScale(scale, 4);
        purQuotationInfo.setTotalAmount(totalAmount);
    }

    public void calEntryTotalAmount(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        int scale = 2;
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        BigDecimal TaxAmount = entryInfo.getTaxAmount();
        BigDecimal packagingExp = entryInfo.getPackagingExp();
        BigDecimal carriage = entryInfo.getCarriage();
        BigDecimal incidentalExpenses = entryInfo.getIncidentalExpenses();
        BigDecimal TotalAmount = ZERO;
        if (TaxAmount != null) {
            TotalAmount = TotalAmount.add(TaxAmount).add(packagingExp == null ? ZERO : packagingExp).add(carriage == null ? ZERO : carriage).add(incidentalExpenses == null ? ZERO : incidentalExpenses);
            TotalAmount = TotalAmount.setScale(scale, 4);
            entryInfo.setTotalAmount(TotalAmount);
        }
    }

    private void calEntryTax(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        BigDecimal taxAmount = SysConstant.BIGZERO;
        BigDecimal taxRate = SysConstant.BIGZERO;
        BigDecimal tax = SysConstant.BIGZERO;
        if (null != entryInfo.getTaxAmount()) {
            taxAmount = entryInfo.getTaxAmount();
        }
        if (null != entryInfo.getTaxRate()) {
            taxRate = entryInfo.getTaxRate();
        }
        boolean isRevenue = purQuotationInfo.isIsRevenue();
        int scale = entryInfo.getAmount().precision();
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        if (isRevenue) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                tax = tax.setScale(scale, 4);
            }
            entryInfo.setTax(tax);
        } else {
            BigDecimal amount = entryInfo.getNewAmount();
            if (null != amount) {
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
            }
            entryInfo.setTax(tax);
        }
    }

    private void calEntryTaxAmount(PurQuotationInfo purQuotationInfo, PurQuotationEntryInfo entryInfo) {
        int scale = entryInfo.getAmount().precision();
        boolean isRevenue = purQuotationInfo.isIsRevenue();
        CurrencyInfo currencyInfo = purQuotationInfo.getCurrency();
        if (currencyInfo != null) {
            scale = currencyInfo.getPrecision();
        }
        if (isRevenue) {
            BigDecimal qty = entryInfo.getAmount();
            BigDecimal taxPrice = entryInfo.getTaxPrice();
            BigDecimal discountAmount = entryInfo.getDiscountAmount();
            if (qty != null && taxPrice != null) {
                BigDecimal totalTaxAmount = qty.multiply(taxPrice);
                if (discountAmount != null) {
                    totalTaxAmount = totalTaxAmount.subtract(discountAmount);
                }
                totalTaxAmount = totalTaxAmount.setScale(scale, 4);
                entryInfo.setTaxAmount(totalTaxAmount);
            }
        } else {
            BigDecimal amount = entryInfo.getNewAmount();
            BigDecimal tax = entryInfo.getTax();
            BigDecimal TaxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
            entryInfo.setTaxAmount(TaxAmount);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PurQuotationInfo getPurQuotationInfoFromSource(String sourceBillID, String number, String billType, Hashtable innerTable, PurchaseOrgUnitInfo orgInfo, Context ctx) throws TaskExternalException, BOSException {
        PurQuotationInfo purQuotationInfo = null;
        EntityViewInfo view = this.getEvWithNumber(number, false);
        FilterInfo filterInfo = view.getFilter();
        filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)orgInfo.getId().toString()));
        SelectorItemCollection infoSelector = new SelectorItemCollection();
        infoSelector.add(new SelectorItemInfo("*"));
        infoSelector.add(new SelectorItemInfo("entries.sourceBillId"));
        infoSelector.add(new SelectorItemInfo("entries.rowType.*"));
        infoSelector.add(new SelectorItemInfo("entries.materialName"));
        infoSelector.add(new SelectorItemInfo("entries.noNumMaterialModel"));
        infoSelector.add(new SelectorItemInfo("entries.assistProperty"));
        infoSelector.add(new SelectorItemInfo("entries.unit"));
        infoSelector.add(new SelectorItemInfo("entries.amount"));
        infoSelector.add(new SelectorItemInfo("entries.baseUnit"));
        infoSelector.add(new SelectorItemInfo("entries.baseQty"));
        infoSelector.add(new SelectorItemInfo("entries.consignmentAddress"));
        infoSelector.add(new SelectorItemInfo("entries.consignmentDate"));
        infoSelector.add(new SelectorItemInfo("entries.consignmentType"));
        infoSelector.add(new SelectorItemInfo("entries.qtyFrom"));
        infoSelector.add(new SelectorItemInfo("entries.qtyTo"));
        infoSelector.add(new SelectorItemInfo("entries.taxRate"));
        infoSelector.add(new SelectorItemInfo("entries.taxPrice"));
        infoSelector.add(new SelectorItemInfo("entries.price"));
        infoSelector.add(new SelectorItemInfo("entries.discountType"));
        infoSelector.add(new SelectorItemInfo("entries.discount"));
        infoSelector.add(new SelectorItemInfo("entries.actualTaxPrice"));
        infoSelector.add(new SelectorItemInfo("entries.actualPrice"));
        infoSelector.add(new SelectorItemInfo("entries.remark"));
        infoSelector.add(new SelectorItemInfo("entries.packagingExp"));
        infoSelector.add(new SelectorItemInfo("entries.carriage"));
        infoSelector.add(new SelectorItemInfo("entries.incidentalExpenses"));
        infoSelector.add(new SelectorItemInfo("entries.insureQualityDate"));
        infoSelector.add(new SelectorItemInfo("entries.purAdvanceDate"));
        infoSelector.add(new SelectorItemInfo("entries.project"));
        infoSelector.add(new SelectorItemInfo("entries.trackNumber"));
        infoSelector.add(new SelectorItemInfo("entries.material.*"));
        infoSelector.add(new SelectorItemInfo("entries.sourceBillType.*"));
        view.setSelector(infoSelector);
        PurQuotationCollection infoCols = PurQuotationFactory.getLocalInstance(ctx).getPurQuotationCollection(view);
        if (infoCols == null || infoCols.size() <= 0) throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "PurQuotationNumber_Not_Exist", new String[]{number, orgInfo.getNumber()}, ctx) + "\n" + this.erroSB.append("\n"));
        purQuotationInfo = infoCols.get(0);
        PurQuotationEntryCollection entryCols = purQuotationInfo.getEntries();
        if (entryCols == null || entryCols.size() <= 0) throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "PurQuotationNumber_Not_Exist", new String[]{number, orgInfo.getNumber()}, ctx) + "\n" + this.erroSB.append("\n"));
        PurQuotationEntryInfo entryInfo = entryCols.get(0);
        if (entryInfo.getSourceBillId() == null || !entryInfo.getSourceBillId().toString().equals(sourceBillID)) {
            throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "SourceBillID_Not_Exist", ctx) + "\n" + this.erroSB.append("\n"));
        }
        if (entryInfo.getSourceBillType() != null && entryInfo.getSourceBillType().getNumber().equals(billType)) return purQuotationInfo;
        throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "BillType_Not_Exist", ctx) + "\n" + this.erroSB.append("\n"));
    }

    private String getDataString(Hashtable hsData, String key) {
        DataToken dataToken = (DataToken)hsData.get(key);
        if (dataToken == null) {
            Logger.info((String)(key + "not exist"));
            return null;
        }
        String number = (String)dataToken.data;
        return number;
    }

    private Integer getDataInteger(Hashtable hsData, String key) throws NumberFormatException {
        String str = this.getDataString(hsData, key);
        if (StringUtils.isEmpty((String)str)) {
            return 0;
        }
        return Integer.valueOf(str);
    }

    private BigDecimal getDataBigDecimal(Hashtable hsData, String key) throws NumberFormatException {
        String str = this.getDataString(hsData, key);
        if (StringUtils.isEmpty((String)str)) {
            return BigDecimal.valueOf(0L);
        }
        return new BigDecimal(str);
    }

    private void setPurQuotationInfo(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable, boolean isFromSource) throws TaskExternalException, BOSException, EASBizException {
        try {
            String quoteSty;
            String paymentTypeName;
            PayConditionInfo payConditionInfo;
            IPayCondition iPayCondition;
            PayConditionCollection payConditionCollection;
            String bizDate;
            String data = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            PurchaseOrgUnitInfo purOrgInfo = this.getPurchaseOrgUnit(ctx, this.getDataString(innerTable, "FPurchaseOrgUnit"));
            purQuotationInfo.setPurchaseOrgUnit(purOrgInfo);
            purQuotationInfo.setCU(purOrgInfo.getCU());
            if (!isFromSource) {
                String secrecyDeadline;
                this.doNumber(ctx, purQuotationInfo, innerTable);
                this.doSupplier(ctx, purQuotationInfo, innerTable);
                data = this.doCurrency(ctx, purQuotationInfo, innerTable);
                CompanyOrgUnitInfo cOrgInfo = this.getPurOrgRelateCompanyOrg(purQuotationInfo, ctx);
                CurrencyInfo baseCurrencyInfo = null;
                if (cOrgInfo != null) {
                    if (this.dataPool.getCurrencyInfo(cOrgInfo.getBaseCurrency().getId().toString()) == null) {
                        baseCurrencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(cOrgInfo.getBaseCurrency().getId()));
                        this.dataPool.setCurrencyInfo(data, baseCurrencyInfo);
                    } else {
                        baseCurrencyInfo = this.dataPool.getCurrencyInfo(cOrgInfo.getBaseCurrency().getId().toString());
                    }
                } else {
                    throw new TaskExternalException(this.getImportServerResource("PurOrg_Not_RelateTo_Company", ctx));
                }
                this.getExchangRate(ctx, purQuotationInfo, innerTable, baseCurrencyInfo);
                this.doPurchaseGroup(ctx, purQuotationInfo, innerTable);
                this.doPurchasePerson(ctx, purQuotationInfo, innerTable);
                String revenueStr = this.getDataString(innerTable, "FIsRevenue");
                if (this.getImportServerResource("QUOTATION_IMPORT_ISREVEN", ctx).equals(revenueStr)) {
                    purQuotationInfo.setIsRevenue(true);
                } else {
                    purQuotationInfo.setIsRevenue(false);
                }
                String disibleDate = this.getDataString(innerTable, "FDisibleDate");
                if (!StringUtil.isEmptyString((String)disibleDate)) {
                    Date date = this.getDate(ctx, disibleDate);
                    purQuotationInfo.setDisibleDate(date);
                }
                if (!StringUtil.isEmptyString((String)(secrecyDeadline = this.getDataString(innerTable, "FSecrecyDeadline")))) {
                    Date date = this.getDate(ctx, secrecyDeadline);
                    purQuotationInfo.setSecrecyDeadline(new Timestamp(date.getTime()));
                }
            }
            if (!StringUtil.isEmptyString((String)(bizDate = this.getDataString(innerTable, "FBizDate")))) {
                Date date = this.getDate(ctx, bizDate);
                purQuotationInfo.setBizDate(date);
            }
            purQuotationInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            String payConditionName = this.getDataString(innerTable, "FPaymentCondition");
            if (!StringUtil.isEmptyString((String)payConditionName) && (payConditionCollection = (iPayCondition = PayConditionFactory.getLocalInstance((Context)ctx)).getPayConditionCollection(this.getEvWithName(payConditionName, true))) != null && payConditionCollection.size() > 0 && (payConditionInfo = payConditionCollection.get(0)) != null) {
                purQuotationInfo.setPaymentCondition(payConditionInfo);
            }
            if (!StringUtil.isEmptyString((String)(paymentTypeName = this.getDataString(innerTable, "FPaymentType")))) {
                PaymentTypeInfo paymentTypeInfo = this.getPaymentType(ctx, "name", paymentTypeName, null);
                purQuotationInfo.setPaymentType(paymentTypeInfo);
            }
            Date tempEnabledDate = null;
            try {
                String enabledDate = this.getDataString(innerTable, "FEnabledDate");
                if (!StringUtil.isEmptyString((String)enabledDate)) {
                    tempEnabledDate = this.getDate(ctx, enabledDate);
                }
                if (tempEnabledDate != null) {
                    GregorianCalendar gc = new GregorianCalendar();
                    gc.setTime(new Date());
                    gc.add(2, -6);
                    gc.set(gc.get(1), gc.get(2), gc.get(5));
                    Date newDate = df.parse(df.format(gc.getTime()));
                    if (tempEnabledDate.getTime() > newDate.getTime()) {
                        purQuotationInfo.setEnabledDate(tempEnabledDate);
                    }
                }
            }
            catch (ParseException e) {
                this.erroSB.append(this.getImportServerResource("QUOTATION_IMPORT_ENMDATE", ctx) + this.getImportServerResource("Date_Style_Is_Error", ctx) + "\n");
            }
            Date unEffectiveTime = null;
            String unEffective = this.getDataString(innerTable, "FUnEffectiveTime");
            if (!StringUtil.isEmptyString((String)unEffective)) {
                unEffectiveTime = this.getDate(ctx, unEffective);
            }
            if (unEffectiveTime != null && tempEnabledDate != null) {
                if (unEffectiveTime.getTime() > tempEnabledDate.getTime()) {
                    purQuotationInfo.setUnEffectiveTime(unEffectiveTime);
                } else {
                    this.erroSB.append(this.getImportServerResource("UnEffectiveTime", ctx) + ";");
                }
            }
            if (!StringUtil.isEmptyString((String)(quoteSty = this.getDataString(innerTable, "FQuoteType")))) {
                if (QuoteStyleEnum.EMAIL.toString().equals(quoteSty)) {
                    purQuotationInfo.setQuoteType(QuoteStyleEnum.EMAIL);
                } else if (QuoteStyleEnum.FAX.toString().equals(quoteSty)) {
                    purQuotationInfo.setQuoteType(QuoteStyleEnum.FAX);
                } else if (QuoteStyleEnum.PHONE.toString().equals(quoteSty)) {
                    purQuotationInfo.setQuoteType(QuoteStyleEnum.PHONE);
                } else if (QuoteStyleEnum.WEB.toString().equals(quoteSty)) {
                    purQuotationInfo.setQuoteType(QuoteStyleEnum.WEB);
                }
            }
            if (!StringUtil.isEmptyString((String)(data = this.getDataString(innerTable, "FDescription")))) {
                if (data.length() > 255) {
                    data = data.substring(0, 255);
                }
                purQuotationInfo.setDescription(data);
            }
            purQuotationInfo.setEditionNumber(0);
            this.doCreate(ctx, purQuotationInfo, innerTable);
            Date date = null;
            String creatDate = this.getDataString(innerTable, "FCreatDate");
            if (!StringUtil.isEmptyString((String)creatDate)) {
                date = this.getDate(ctx, creatDate);
            }
            if (date == null) {
                date = new Date();
            }
            purQuotationInfo.setCreateTime(new Timestamp(date.getTime()));
        }
        catch (NumberFormatException nfe) {
            throw new TaskExternalException(nfe.getMessage());
        }
    }

    public void doCreate(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable) throws BOSException {
        String data = this.getDataString(innerTable, "FCreator");
        UserInfo userInfo = null;
        if (!StringUtil.isEmptyString((String)data)) {
            UserCollection cols = UserFactory.getLocalInstance((Context)ctx).getUserCollection(this.getEvWithName(data, true));
            if (cols != null && cols.size() > 0) {
                purQuotationInfo.setCreator(cols.get(0));
            } else {
                this.erroSB.append(this.getImportServerResource("BillCreator_Not_Null", ctx) + "\n");
            }
        } else {
            userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            purQuotationInfo.setCreator(userInfo);
        }
    }

    public void doPurchasePerson(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable) throws BOSException, EASBizException {
        String data = this.getDataString(innerTable, "FPurchasePerson");
        PurchasePersonCollection pPersonCols = null;
        if (!StringUtil.isEmptyString((String)data)) {
            EntityViewInfo view1 = this.getEvWithNumber(data, true);
            PersonCollection perCols = PersonFactory.getLocalInstance((Context)ctx).getPersonCollection(view1);
            if (perCols != null && perCols.size() > 0) {
                PersonInfo pInfo = perCols.get(0);
                String controlID = null;
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("Person", (Object)pInfo.getId().toString(), CompareType.EQUALS));
                if (purQuotationInfo.getPurchaseGroup() != null) {
                    controlID = purQuotationInfo.getPurchaseGroup().getId().toString();
                    filter.getFilterItems().add(new FilterItemInfo("purGroup", (Object)controlID, CompareType.EQUALS));
                } else {
                    controlID = purQuotationInfo.getPurchaseOrgUnit().getId().toString();
                    StringBuffer sql = new StringBuffer();
                    sql.append("select fid from  T_BD_PurchaseGroup where FPurOrgID ='" + controlID + "'");
                    if (this.isControllByPurOrgUnit(controlID, ctx)) {
                        filter.getFilterItems().add(new FilterItemInfo("purGroup", (Object)sql.toString(), CompareType.INNER));
                    }
                }
                view.setFilter(filter);
                pPersonCols = PurchasePersonFactory.getLocalInstance((Context)ctx).getPurchasePersonCollection(view);
                if (pPersonCols != null && pPersonCols.size() > 0) {
                    purQuotationInfo.setPurchasePerson(pPersonCols.get(0).getPerson());
                }
            }
        }
    }

    public void doPurchaseGroup(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable) throws EASBizException, BOSException {
        String data = this.getDataString(innerTable, "FPurchaseGroup");
        PurchaseGroupCollection pGroupCols = null;
        if (!StringUtil.isEmptyString((String)data)) {
            String orgId = purQuotationInfo.getPurchaseOrgUnit().getId().toString();
            if (this.dataPool.getPurchaseGroupInfo(data + orgId) == null) {
                EntityViewInfo view = this.getEvWithNumber(data, true);
                if (this.isControllByPurOrgUnit(orgId, ctx)) {
                    view.getFilter().getFilterItems().add(new FilterItemInfo("purOrg.id", (Object)orgId, CompareType.EQUALS));
                }
                if ((pGroupCols = PurchaseGroupFactory.getLocalInstance((Context)ctx).getPurchaseGroupCollection(view)) != null && pGroupCols.size() > 0) {
                    purQuotationInfo.setPurchaseGroup(pGroupCols.get(0));
                    this.dataPool.setPurchaseGroupInfo(data + orgId, pGroupCols.get(0));
                }
            } else {
                purQuotationInfo.setPurchaseGroup(this.dataPool.getPurchaseGroupInfo(data + orgId));
            }
        }
    }

    public void getExchangRate(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable, CurrencyInfo baseCurrencyInfo) {
        String data = this.getDataString(innerTable, "FExchangeRate");
        if (!StringUtil.isEmptyString((String)data)) {
            if (purQuotationInfo.getCurrency().getId().toString().equalsIgnoreCase(baseCurrencyInfo.getId().toString())) {
                purQuotationInfo.setExchangeRate(new BigDecimal("1.0"));
            } else {
                purQuotationInfo.setExchangeRate(new BigDecimal(data));
            }
        } else {
            this.erroSB.append(this.getImportServerResource("ExchangeRate_Not_Null", ctx) + "\n");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doCurrency(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable) throws BOSException, TaskExternalException {
        String data = this.getDataString(innerTable, "FCurrency");
        CurrencyCollection currencyCols = null;
        if (StringUtil.isEmptyString((String)data)) throw new TaskExternalException(this.getImportServerResource("Currency_Is_Null", ctx));
        if (this.dataPool.getCurrencyInfo(data) == null) {
            EntityViewInfo view = this.getEvWithNumber(data, false);
            SelectorItemCollection infoSelector = new SelectorItemCollection();
            infoSelector.add(new SelectorItemInfo("name"));
            infoSelector.add(new SelectorItemInfo("number"));
            infoSelector.add(new SelectorItemInfo("id"));
            infoSelector.add(new SelectorItemInfo("precision"));
            view.setSelector(infoSelector);
            currencyCols = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            if (currencyCols == null || currencyCols.size() <= 0) throw new TaskExternalException(this.getImportServerResource("Currency_Not_Exist", ctx));
            purQuotationInfo.setCurrency(currencyCols.get(0));
            this.dataPool.setCurrencyInfo(data, currencyCols.get(0));
            return data;
        } else {
            purQuotationInfo.setCurrency(this.dataPool.getCurrencyInfo(data));
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSupplier(Context ctx, PurQuotationInfo purQuotationInfo, Hashtable innerTable) throws BOSException, TaskExternalException {
        String data = this.getDataString(innerTable, "FSupplier");
        SupplierCollection supplierCols = null;
        if (StringUtil.isEmptyString((String)data)) throw new TaskExternalException(this.getImportServerResource("Supplier_Not_Exist", ctx) + "\n" + this.erroSB.append("\n"));
        if (this.dataPool.getSupplierInfo(data) == null) {
            supplierCols = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(this.getEvWithNumber(data, true));
            if (supplierCols != null && supplierCols.size() > 0) {
                purQuotationInfo.setSupplier(supplierCols.get(0));
                this.dataPool.setSupplierInfo(data, supplierCols.get(0));
                return;
            } else {
                supplierCols = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(this.getEvWithName(data, true));
                if (supplierCols == null || supplierCols.size() <= 0) throw new TaskExternalException(this.getImportServerResource("Supplier_Not_Exist", ctx) + "\n" + this.erroSB.append("\n"));
                purQuotationInfo.setSupplier(supplierCols.get(0));
                this.dataPool.setSupplierInfo(data, supplierCols.get(0));
            }
            return;
        } else {
            purQuotationInfo.setSupplier(this.dataPool.getSupplierInfo(data));
        }
    }

    private boolean getBooleanValue(String value, String key, Context ctx) throws TaskExternalException {
        if ((value = value.trim()).equalsIgnoreCase("N") || value.equalsIgnoreCase("NO") || value.equalsIgnoreCase("0")) {
            return false;
        }
        if (value.equalsIgnoreCase("Y") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1")) {
            return true;
        }
        throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurBizResource", key, ctx));
    }

    private void setEntryValue(Context ctx, PurQuotationInfo headInfo, Hashtable innerTable, boolean isFromSource) throws TaskExternalException, BOSException, EASBizException, SQLException, ParseException {
        PurQuotationEntryInfo entryInfo = null;
        String data = null;
        if (!isFromSource) {
            String type;
            if (headInfo.getEntries() == null || headInfo.getEntries().size() <= 0) {
                entryInfo = new PurQuotationEntryInfo();
                headInfo.getEntries().add(entryInfo);
            } else {
                data = this.getDataString(innerTable, "FEntries_ID");
                if (StringUtil.isEmptyString((String)data)) {
                    entryInfo = new PurQuotationEntryInfo();
                    headInfo.getEntries().add(entryInfo);
                } else {
                    for (int i = 0; headInfo.getEntries() != null && i < headInfo.getEntries().size(); ++i) {
                        if (headInfo.getEntries().get(i).getId() != null && data.equals(headInfo.getEntries().get(i).getId().toString())) {
                            entryInfo = headInfo.getEntries().get(i);
                            break;
                        }
                        if (i != headInfo.getEntries().size() - 1) continue;
                        entryInfo = new PurQuotationEntryInfo();
                        headInfo.getEntries().add(entryInfo);
                        break;
                    }
                }
            }
            data = this.getDataString(innerTable, "FEntries_rowType");
            RowTypeCollection rTypeCols = null;
            RowTypeInfo rowInfo = null;
            SelectorItemCollection infoSelector = new SelectorItemCollection();
            infoSelector.add(new SelectorItemInfo("name"));
            infoSelector.add(new SelectorItemInfo("number"));
            infoSelector.add(new SelectorItemInfo("id"));
            infoSelector.add(new SelectorItemInfo("precision"));
            infoSelector.add(new SelectorItemInfo("isHasMaterialNumber"));
            EntityViewInfo view = null;
            view = StringUtil.isEmptyString((String)data) ? this.getEvWithNumber("010", false) : this.getEvWithNumber(data, false);
            if (view != null) {
                view.setSelector(infoSelector);
            }
            if ((rTypeCols = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeCollection(view)) != null && rTypeCols.size() > 0) {
                rowInfo = rTypeCols.get(0);
                if (entryInfo != null) {
                    entryInfo.setRowType(rowInfo);
                }
            } else {
                throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "RowType_is_Error", new String[]{data}, ctx) + "\n" + this.erroSB.append("\n"));
            }
            if (rowInfo.isIsHasMaterialNumber()) {
                MaterialInfo materialInfo = this.doMaterial(ctx, innerTable, entryInfo);
                this.doAssistAttr(ctx, innerTable, entryInfo, materialInfo);
                this.doUnit(ctx, innerTable, entryInfo, materialInfo);
                BigDecimal qtyFrom = this.getDataBigDecimal(innerTable, "FEntries_qtyFrom");
                BigDecimal qtyTo = this.getDataBigDecimal(innerTable, "FEntries_qtyTo");
                BigDecimal qty = this.getDataBigDecimal(innerTable, "FEntries_qty");
                if (MAXVAL.compareTo(qty) <= 0) {
                    throw new TaskExternalException(this.getImportServerResource("QTY_MORETNER", ctx) + "\n" + this.erroSB.append("\n"));
                }
                if (MAXVAL.compareTo(qtyTo) <= 0) {
                    throw new TaskExternalException(this.getImportServerResource("QTYFROM_MORETNER", ctx) + "\n" + this.erroSB.append("\n"));
                }
                if (MAXVAL.compareTo(qtyFrom) <= 0) {
                    throw new TaskExternalException(this.getImportServerResource("QTYTO_MORETNER", ctx) + "\n" + this.erroSB.append("\n"));
                }
                this.checkAndSetQtyFromTo(ctx, innerTable, entryInfo);
                if (materialInfo != null && entryInfo != null) {
                    entryInfo.setBaseUnit(materialInfo.getBaseUnit());
                    if (entryInfo.getAmount() != null) {
                        BigDecimal baseQty = this.getConvertQty(materialInfo.getId().toString(), entryInfo.getUnit(), entryInfo.getAmount(), true, ctx);
                        entryInfo.setBaseQty(baseQty);
                    }
                }
            } else {
                data = this.getDataString(innerTable, "FEntries_materialName");
                if (!StringUtil.isEmptyString((String)data) && entryInfo != null) {
                    if (data.length() > 255) {
                        data = data.substring(0, 255);
                    }
                    entryInfo.setMaterialName(data);
                    entryInfo.setMaterial(null);
                    entryInfo.setAssistProperty(null);
                } else {
                    this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "MaterialName_Not_Null_According_RowType", ctx) + "\n");
                }
                data = this.getDataString(innerTable, "FEntries_materialModel");
                if (!StringUtil.isEmptyString((String)data) && entryInfo != null) {
                    if (data.length() > 255) {
                        data = data.substring(0, 255);
                    }
                    entryInfo.setNoNumMaterialModel(data);
                }
                this.doUnit(ctx, innerTable, entryInfo);
                this.checkAndSetQtyFromTo(ctx, innerTable, entryInfo);
                if (entryInfo != null) {
                    entryInfo.setBaseUnit(entryInfo.getUnit());
                    entryInfo.setBaseQty(entryInfo.getAmount());
                }
            }
            data = this.getDataString(innerTable, "FEntries_consignmentAddress");
            if (!StringUtil.isEmptyString((String)data)) {
                if (data.length() > 255) {
                    data = data.substring(0, 255);
                }
                if (entryInfo != null) {
                    entryInfo.setConsignmentAddress(data);
                }
            }
            Date date = null;
            String consignmentDate = this.getDataString(innerTable, "FEntries_consignmentDate");
            if (!StringUtil.isEmptyString((String)consignmentDate)) {
                date = this.getDate(ctx, consignmentDate);
            }
            if (date != null && entryInfo != null) {
                entryInfo.setConsignmentDate(date);
            }
            if (!StringUtils.isEmpty((String)(type = this.getDataString(innerTable, "FEntries_consignmentType"))) && (type.equals(DeliveryStyleEnum.DELIVERY.toString().trim()) || type.equals(DeliveryStyleEnum.SELF.toString().trim()))) {
                if (type.equals(DeliveryStyleEnum.DELIVERY.toString().trim())) {
                    if (null != entryInfo) {
                        entryInfo.setConsignmentType(DeliveryStyleEnum.DELIVERY);
                    }
                } else if (type.equals(DeliveryStyleEnum.SELF.toString().trim()) && null != entryInfo) {
                    entryInfo.setConsignmentType(DeliveryStyleEnum.SELF);
                }
            }
        } else {
            if (headInfo.getEntries() == null || headInfo.size() <= 0) {
                return;
            }
            data = this.getDataString(innerTable, "FEntries_ID");
            if (StringUtil.isEmptyString((String)data)) {
                return;
            }
            for (int i = 0; headInfo.getEntries() != null && i < headInfo.getEntries().size(); ++i) {
                if (data.equals(headInfo.getEntries().get(i).getId().toString())) {
                    entryInfo = headInfo.getEntries().get(i);
                    break;
                }
                if (i != headInfo.getEntries().size()) continue;
                return;
            }
            data = this.getDataString(innerTable, "FEntries_unit");
            MeasureUnitInfo measureUnitInfo = null;
            if (!StringUtil.isEmptyString((String)data) && entryInfo != null) {
                measureUnitInfo = this.getMeasureUnit(ctx, "number", entryInfo.getMaterial());
                if (measureUnitInfo == null || measureUnitInfo != null && !measureUnitInfo.getId().toString().equals(entryInfo.getUnit().getId().toString())) {
                    throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "Unit_Not_Allowed_Modify", ctx) + entryInfo.getUnit().getName() + "\n" + this.erroSB.append("\n"));
                }
            } else {
                String unitName = "";
                if (entryInfo != null && entryInfo.getUnit() != null) {
                    unitName = entryInfo.getUnit().getName();
                }
                throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "Unit_Not_Allowed_Modify", ctx) + unitName + "\n" + this.erroSB.append("\n"));
            }
        }
        try {
            BigDecimal carriage;
            BigDecimal actualPrice;
            BigDecimal actualTaxPrice;
            BigDecimal tax;
            BigDecimal taxRate;
            int precision = 2;
            if (entryInfo != null && entryInfo.getMaterial() != null) {
                precision = entryInfo.getMaterial().getPricePrecision();
            }
            BigDecimal price = this.getDataBigDecimal(innerTable, "FEntries_price");
            BigDecimal taxPrice = this.getDataBigDecimal(innerTable, "FEntries_taxPrice");
            if (headInfo.isIsRevenue()) {
                if (taxPrice == null) {
                    throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "TaxPrice_Not_Null_According_Revenue", ctx) + "\n" + this.erroSB.append("\n"));
                }
                taxRate = this.getDataBigDecimal(innerTable, "FEntries_taxRate");
                if (taxRate.compareTo(ZERO) == 0 || taxRate.compareTo(new BigDecimal(100)) == -1) {
                    if (taxRate.compareTo(ZERO) == -1) {
                        this.erroSB.append(this.getImportServerResource("Tax", ctx) + "\n");
                    } else if (entryInfo != null) {
                        entryInfo.setTaxRate(taxRate);
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("Tax", ctx) + "\n");
                }
                if (taxPrice.compareTo(ZERO) == 1 || taxPrice.compareTo(ZERO) == 0) {
                    if (null != entryInfo) {
                        entryInfo.setTaxPrice(taxPrice);
                    }
                    tax = taxRate.multiply(new BigDecimal("0.01"));
                    price = (taxPrice = taxPrice.setScale(precision, 4)).divide(new BigDecimal("1").add(tax), precision, 4);
                    if (price.compareTo(ZERO) == 1 || price.compareTo(ZERO) == 0) {
                        entryInfo.setPrice(price);
                    } else if (headInfo.getPurQuotationPlanID() == null || headInfo.getPurQuotationPlanID().length() <= 0) {
                        this.erroSB.append(this.getImportServerResource("price", ctx) + "\n");
                    } else {
                        this.erroSB.append(this.getImportServerResource("PRICE_GT_ZERO", ctx) + "\n");
                    }
                } else if (headInfo.getPurQuotationPlanID() == null || headInfo.getPurQuotationPlanID().length() <= 0) {
                    this.erroSB.append(this.getImportServerResource("TaxPrice", ctx) + "\n");
                } else {
                    this.erroSB.append(this.getImportServerResource("TAXPRICE_GT_ZERO", ctx) + "\n");
                }
            } else {
                if (price == null) {
                    throw new TaskExternalException(this.getImportServerResource("Price_Not_Null_According_Revenue", ctx) + "\n" + this.erroSB.append("\n"));
                }
                taxRate = this.getDataBigDecimal(innerTable, "FEntries_taxRate");
                if (taxRate.compareTo(ZERO) == 0 || taxRate.compareTo(new BigDecimal(100)) == -1) {
                    if (taxRate.compareTo(ZERO) == -1) {
                        this.erroSB.append(this.getImportServerResource("Tax", ctx) + "\n");
                    } else if (null != entryInfo) {
                        entryInfo.setTaxRate(taxRate);
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("Tax", ctx) + "\n");
                }
                price = price.setScale(precision, 4);
                if (price.compareTo(ZERO) == 1 || price.compareTo(ZERO) == 0) {
                    if (null != entryInfo) {
                        entryInfo.setPrice(price);
                    }
                    if ((taxPrice = price.multiply(new BigDecimal("1").add(tax = taxRate.multiply(new BigDecimal("0.01")))).setScale(precision, 4)).compareTo(ZERO) == 1 || taxPrice.compareTo(ZERO) == 0) {
                        entryInfo.setTaxPrice(taxPrice);
                    } else if (headInfo.getPurQuotationPlanID() == null || headInfo.getPurQuotationPlanID().length() <= 0) {
                        this.erroSB.append(this.getImportServerResource("TaxPrice", ctx) + "\n");
                    } else {
                        this.erroSB.append(this.getImportServerResource("TAXPRICE_GT_ZERO", ctx) + "\n");
                    }
                } else if (headInfo.getPurQuotationPlanID() == null || headInfo.getPurQuotationPlanID().length() <= 0) {
                    this.erroSB.append(this.getImportServerResource("price", ctx) + "\n");
                } else {
                    this.erroSB.append(this.getImportServerResource("PRICE_GT_ZERO", ctx) + "\n");
                }
            }
            String discountTypeValue = DiscountModeEnum.PERCENT.toString();
            BigDecimal discount = this.getDataBigDecimal(innerTable, "FEntries_discount");
            if (DiscountModeEnum.PERCENT.toString().equals(discountTypeValue)) {
                if (null != entryInfo) {
                    entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
                }
                if ((discount.compareTo(ZERO) == 0 || discount.compareTo(ZERO) == 1) && discount.compareTo(new BigDecimal(100)) == -1) {
                    entryInfo.setDiscount(discount);
                } else {
                    this.erroSB.append(this.getImportServerResource("Discount", ctx) + ";");
                }
            } else if (DiscountModeEnum.PERUNIT.toString().equals(discountTypeValue)) {
                if (null != entryInfo) {
                    entryInfo.setDiscountType(DiscountModeEnum.PERUNIT);
                }
                if (headInfo.isIsRevenue()) {
                    if ((discount.compareTo(ZERO) == 0 || discount.compareTo(ZERO) == 1) && discount.compareTo(taxPrice) == -1) {
                        entryInfo.setDiscount(discount);
                    } else {
                        this.erroSB.append(this.getImportServerResource("Discount", ctx) + "\n");
                    }
                } else if (discount.compareTo(ZERO) == 0 || discount.compareTo(ZERO) == 1) {
                    if (discount.compareTo(price) == -1 || discount.compareTo(price) == 0) {
                        entryInfo.setDiscount(discount);
                    } else {
                        this.erroSB.append(this.getImportServerResource("Discount", ctx) + "\n");
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("Discount", ctx) + ";");
                }
            } else {
                this.erroSB.append(this.getImportServerResource("DiscountType", ctx) + "\n");
            }
            if (headInfo.isIsRevenue()) {
                if (DiscountModeEnum.PERCENT.toString().equals(discountTypeValue)) {
                    actualTaxPrice = taxPrice.multiply(new BigDecimal(1).subtract(discount.multiply(new BigDecimal(0.01))));
                    actualPrice = price.multiply(new BigDecimal(1).subtract(discount.multiply(new BigDecimal(0.01))));
                } else {
                    actualTaxPrice = taxPrice.subtract(discount);
                    actualPrice = price.subtract(discount);
                }
                if (actualTaxPrice.compareTo(discount) == 1 || actualTaxPrice.compareTo(discount) == 0 || actualPrice.compareTo(ZERO) == 0 || actualPrice.compareTo(ZERO) == 1) {
                    if (actualTaxPrice.compareTo(ZERO) == 0 || actualTaxPrice.compareTo(ZERO) == 1) {
                        actualTaxPrice = actualTaxPrice.setScale(precision, 4);
                        if (null != entryInfo) {
                            entryInfo.setActualTaxPrice(actualTaxPrice);
                        }
                    } else {
                        this.erroSB.append(this.getImportServerResource("ActualTaxPrice", ctx) + "\n");
                    }
                    if (actualPrice.compareTo(ZERO) == 0 || actualPrice.compareTo(ZERO) == 1) {
                        actualPrice = actualPrice.setScale(precision, 4);
                        if (null != entryInfo) {
                            entryInfo.setActualPrice(actualPrice);
                        }
                    } else {
                        this.erroSB.append(this.getImportServerResource("ActualPrice", ctx) + "\n");
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("Discount", ctx) + "\n");
                }
            } else {
                if (DiscountModeEnum.PERCENT.toString().equals(discountTypeValue)) {
                    actualPrice = price.multiply(new BigDecimal(1).subtract(discount.multiply(new BigDecimal(0.01))));
                    actualTaxPrice = taxPrice.multiply(new BigDecimal(1).subtract(discount.multiply(new BigDecimal(0.01))));
                } else {
                    actualPrice = price.subtract(discount);
                    actualTaxPrice = taxPrice.subtract(discount);
                }
                if (actualPrice.compareTo(ZERO) == 0 || actualPrice.compareTo(ZERO) == 1 || actualTaxPrice.compareTo(discount) == 1 || actualTaxPrice.compareTo(discount) == 0) {
                    actualPrice = actualPrice.setScale(precision, 4);
                    if (null != entryInfo) {
                        entryInfo.setActualPrice(actualPrice);
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("ActualPrice", ctx) + "\n");
                }
                if (actualTaxPrice.compareTo(ZERO) == 0 || actualTaxPrice.compareTo(ZERO) == 1) {
                    actualTaxPrice = actualTaxPrice.setScale(precision, 4);
                    if (entryInfo != null) {
                        entryInfo.setActualTaxPrice(actualTaxPrice);
                    }
                } else {
                    this.erroSB.append(this.getImportServerResource("ActualTaxPrice", ctx) + "\n");
                }
            }
            if (!StringUtil.isEmptyString((String)(data = this.getDataString(innerTable, "FEntries_remark"))) && null != entryInfo) {
                entryInfo.setRemark(data);
            }
            if ((data = this.getDataString(innerTable, "FEntries_packagingExp")) != null && data.trim().length() > 0) {
                BigDecimal packagingExp = new BigDecimal(data);
                if (packagingExp.compareTo(ZERO) == -1) {
                    this.erroSB.append(this.getImportServerResource("packagingExp", ctx) + "\n");
                } else {
                    packagingExp = packagingExp.setScale(headInfo.getCurrency().getPrecision());
                    if (null != entryInfo) {
                        entryInfo.setPackagingExp(packagingExp);
                    }
                }
            }
            if ((carriage = this.getDataBigDecimal(innerTable, "FEntries_carriage")).compareTo(ZERO) == -1) {
                this.erroSB.append(this.getImportServerResource("carriage", ctx) + "\n");
            } else {
                carriage = carriage.setScale(headInfo.getCurrency().getPrecision());
                if (null != entryInfo) {
                    entryInfo.setCarriage(carriage);
                }
            }
            BigDecimal incidentalExpenses = this.getDataBigDecimal(innerTable, "FEntries_incidentalExpenses");
            if (incidentalExpenses.compareTo(ZERO) == -1) {
                this.erroSB.append(this.getImportServerResource("incidentalExpenses", ctx) + "\n");
            } else {
                incidentalExpenses = incidentalExpenses.setScale(headInfo.getCurrency().getPrecision());
                if (null != entryInfo) {
                    entryInfo.setIncidentalExpenses(incidentalExpenses);
                }
            }
            int insureQualityDate = this.getDataInteger(innerTable, "FEntries_insureQualityDate");
            if (insureQualityDate >= 0) {
                if (null != entryInfo) {
                    entryInfo.setInsureQualityDate(insureQualityDate);
                }
            } else {
                this.erroSB.append(this.getImportServerResource("insureQualityDate", ctx) + "\n");
            }
            int purAdvanceDate = this.getDataInteger(innerTable, "FEntries_purAdvanceDate");
            if (entryInfo != null) {
                entryInfo.setPurAdvanceDate(purAdvanceDate);
                if (entryInfo.getRowType().isIsHasMaterialNumber()) {
                    this.doProject(ctx, innerTable, entryInfo);
                    this.doTrackNumber(ctx, innerTable, entryInfo);
                }
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
    }

    public void doTrackNumber(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo) throws BOSException {
        String trackNumber = this.getDataString(innerTable, "FEntries_FTrackNumber");
        if (trackNumber != null && trackNumber.trim().length() > 0) {
            if (this.dataPool.getTrackNumber(trackNumber) == null) {
                StringBuffer sql = new StringBuffer();
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                HashSet<Integer> status = new HashSet<Integer>();
                status.add(new Integer(10));
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)trackNumber, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("status", status, CompareType.INCLUDE));
                if (entryInfo.getProject() != null) {
                    sql.append("select FTrackNumberID from T_MM_ProjectCar where FProjectID in ( '" + entryInfo.getProject().getId().toString() + "')");
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
                } else {
                    sql.append("select FTrackNumberID from T_MM_ProjectCar where FTrackNumberID is not null");
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
                }
                FilterInfo filter2 = new FilterInfo();
                CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                ObjectUuidPK cuPK = null;
                cuPK = cu == null ? new ObjectUuidPK(BOSUuid.create((BOSObjectType)new CtrlUnitInfo().getBOSType())) : new ObjectUuidPK(cu.getId());
                try {
                    filter2 = iTrackNumber.getDatabaseDFilter((IObjectPK)cuPK, "id", "CU.id");
                }
                catch (EASBizException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                catch (BOSException e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                if (filter2 != null) {
                    filter.mergeFilter(filter2, "and");
                }
                viewInfo.setFilter(filter);
                TrackNumberCollection coll = iTrackNumber.getTrackNumberCollection(viewInfo);
                if (coll != null && coll.size() > 0) {
                    TrackNumberInfo trackNumberInfo = coll.get(0);
                    entryInfo.setTrackNumber(trackNumberInfo);
                    this.dataPool.setTrackNumber(trackNumber, trackNumberInfo);
                }
            } else {
                entryInfo.setTrackNumber(this.dataPool.getTrackNumber(trackNumber));
            }
        }
    }

    public void doProject(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo) throws TaskExternalException {
        String projNumber = this.getDataString(innerTable, "FEntries_FProjectNumber");
        CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)ctx);
        ProjectInfo projectInfo = this.getProject(ctx, projNumber, cu);
        entryInfo.setProject(projectInfo);
    }

    public void doUnit(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo) throws BOSException {
        String data = this.getDataString(innerTable, "FEntries_unit");
        MeasureUnitInfo measureUnitInfo = this.getMeasureUnitByNumber(ctx, data);
        entryInfo.setUnit(measureUnitInfo);
    }

    public void doUnit(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        String data = this.getDataString(innerTable, "FEntries_unit");
        MeasureUnitInfo measureUnitInfo = this.getMeasureUnit(ctx, data, materialInfo);
        entryInfo.setUnit(measureUnitInfo);
    }

    public void doAssistAttr(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo, MaterialInfo materialInfo) throws TaskExternalException {
        String data = this.getDataString(innerTable, "FEntries_materialAssistAttr");
        if (materialInfo.getAssistAttr() != null && !StringUtil.isEmptyString((String)materialInfo.getAssistAttr().getId().toString())) {
            AsstAttrValueInfo info = this.getAsstAttr(ctx, data, materialInfo.getAssistAttr());
            entryInfo.setAssistProperty(info);
        }
    }

    public MaterialInfo doMaterial(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo) throws TaskExternalException {
        String data = this.getDataString(innerTable, "FEntries_materialNumber");
        MaterialInfo materialInfo = this.getMaterial(ctx, data, null);
        entryInfo.setMaterial(materialInfo);
        entryInfo.setMaterialName(materialInfo.getName());
        entryInfo.setNoNumMaterialModel(materialInfo.getModel());
        return materialInfo;
    }

    private PurchaseOrgUnitInfo getPurchaseOrgUnit(Context ctx, String orgName) throws TaskExternalException {
        try {
            if (!StringUtils.isEmpty((String)orgName)) {
                if (this.dataPool.getPurchaseOrgUnitInfo(orgName) == null) {
                    IPurchaseOrgUnit ipur = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo ev = this.getEvWithNumber(orgName, true);
                    SelectorItemCollection selector = ev.getSelector();
                    selector.add("cu.id");
                    if (ev != null) {
                        PurchaseOrgUnitCollection cols = ipur.getPurchaseOrgUnitCollection(ev);
                        if (cols.size() > 0) {
                            PurchaseOrgUnitInfo orgInfo = cols.get(0);
                            this.dataPool.setPurchaseOrgUnitInfo(orgName, orgInfo);
                            return orgInfo;
                        }
                        throw new TaskExternalException(PurUtil.getPurQuotationResource("PurchaseOrgUnit_Not_Exist") + "\n" + this.erroSB.append("\n"));
                    }
                    throw new TaskExternalException(PurUtil.getPurQuotationResource("PurchaseOrgUnit_Not_Exist") + "\n" + this.erroSB.append("\n"));
                }
                PurchaseOrgUnitInfo orgInfo = this.dataPool.getPurchaseOrgUnitInfo(orgName);
                return orgInfo;
            }
            throw new TaskExternalException(PurUtil.getPurQuotationResource("PUR_ORG_IS_NULL") + "\n" + this.erroSB.append("\n"));
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
    }

    private EntityViewInfo getEvWithNumber(String numberVal, boolean selectPart) {
        if (StringUtils.isEmpty((String)numberVal)) {
            Logger.info((String)"number Value is null in function getEvWithNumber");
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)numberVal, CompareType.EQUALS));
        ev.setFilter(filter);
        if (selectPart) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            ev.setSelector(selector);
        }
        return ev;
    }

    private EntityViewInfo getEvWithName(String name, boolean selectPart) {
        if (StringUtils.isEmpty((String)name)) {
            Logger.info((String)"name Value is null in function getEvWithNumber");
            return null;
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)name, CompareType.EQUALS));
        ev.setFilter(filter);
        if (selectPart) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            ev.setSelector(selector);
        }
        return ev;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.app.PurQuotationQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Purchase, (String)"purQuotation_view");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            LinkedHashSet<String> status = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
                status.add(String.valueOf(BillBaseStatusEnum.TEMPORARILYSAVED.getValue()));
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", keys, CompareType.INCLUDE));
            filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", status, CompareType.EQUALS));
            return filterInfo;
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, Object> result = new Hashtable<String, Object>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        this.userInfo = (UserInfo)ctx.get((Object)"UserInfo");
        try {
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.userInfo.getId().toString()), (IObjectPK)new ObjectUuidPK(rs.getString("purchaseOrgUnit.id")), "purQuotation_exmport");
        }
        catch (EASBizException e2) {
            throw new TaskExternalException(e2.getMessage(), (Throwable)e2);
        }
        catch (BOSException e2) {
            throw new TaskExternalException(e2.getMessage(), (Throwable)e2);
        }
        catch (SQLException e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        try {
            String dDate;
            Date disibleDate;
            if (rs.getObject("number") != null) {
                result.put("FNumber", rs.getObject("number"));
            }
            if (rs.getObject("bizDate") != null) {
                result.put("FBizDate", rs.getString("bizDate"));
            }
            if (rs.getObject("baseStatus") != null) {
                result.put("FBaseStatus", this.checkBillBaseStatusEnum(rs.getString("baseStatus")));
            }
            if (rs.getString("purQuotationPlanID") != null) {
                result.put("FPurQuotationPlanNumber", rs.getString("purQuotationPlanID"));
            }
            Object typeInfo = null;
            if (rs.getString("sourceBillType.number") != null) {
                result.put("FSourceBillType", rs.getString("sourceBillType.number"));
            }
            Object purInfo = null;
            if (rs.getString("entries.sourceBillId") != null) {
                result.put("FSourceBillID", rs.getString("entries.sourceBillId"));
            }
            if (rs.getObject("paymentType") != null) {
                result.put("FPaymentType", rs.getObject("paymentType"));
            }
            if (rs.getObject("paymentCondition") != null) {
                result.put("FPaymentCondition", rs.getObject("paymentCondition"));
            }
            if (rs.getObject("supplier.number") != null) {
                result.put("FSupplier", rs.getObject("supplier.number"));
            }
            if (rs.getObject("currency.number") != null) {
                result.put("FCurrency", rs.getObject("currency.number"));
            }
            if (rs.getObject("exchangeRate") != null) {
                result.put("FExchangeRate", rs.getObject("exchangeRate"));
            }
            if (rs.getObject("purchaseOrgUnit.number") != null) {
                result.put("FPurchaseOrgUnit", rs.getObject("purchaseOrgUnit.number"));
            }
            if (rs.getObject("purchaseGroup.number") != null) {
                result.put("FPurchaseGroup", rs.getObject("purchaseGroup.number"));
            }
            if (rs.getObject("purchasePerson.number") != null) {
                result.put("FPurchasePerson", rs.getObject("purchasePerson.number"));
            }
            if (rs.getObject("enabledDate") != null) {
                result.put("FEnabledDate", rs.getString("enabledDate"));
            }
            if (rs.getObject("unEffectiveTime") != null) {
                result.put("FUnEffectiveTime", rs.getString("unEffectiveTime"));
            }
            if (rs.getObject("disibleDate") != null) {
                disibleDate = new Date(rs.getTimestamp("disibleDate").getTime());
                dDate = dateFormat.format(disibleDate);
                result.put("FDisibleDate", dDate);
            }
            if (rs.getObject("quoteType") != null) {
                int quoteType = rs.getInt("quoteType");
                if (0 == quoteType) {
                    result.put("FQuoteType", QuoteStyleEnum.FAX.toString());
                } else if (3 == quoteType) {
                    result.put("FQuoteType", QuoteStyleEnum.PHONE.toString());
                } else if (1 == quoteType) {
                    result.put("FQuoteType", QuoteStyleEnum.EMAIL.toString());
                } else if (2 == quoteType) {
                    result.put("FQuoteType", QuoteStyleEnum.WEB.toString());
                }
            }
            if (rs.getObject("description") != null) {
                result.put("FDescription", rs.getString("description"));
            }
            if (rs.getObject("revenue") != null) {
                if (rs.getBoolean("revenue")) {
                    result.put("FIsRevenue", this.getImportServerResource("QUOTATION_IMPORT_ISREVEN", ctx));
                } else {
                    result.put("FIsRevenue", this.getImportServerResource("QUOTATION_IMPORT_ISNOTREVEN", ctx));
                }
            }
            if (rs.getObject("secrecyDeadline") != null) {
                disibleDate = new Date(rs.getTimestamp("secrecyDeadline").getTime());
                dDate = dateFormat.format(disibleDate);
                result.put("FSecrecyDeadline", dDate);
            }
            if (rs.getObject("entries.id") != null) {
                result.put("FEntries_ID", rs.getString("entries.id"));
            }
            if (rs.getObject("rowType.number") != null) {
                result.put("FEntries_rowType", rs.getString("rowType.number"));
            }
            if (rs.getObject("material.number") != null) {
                result.put("FEntries_materialNumber", rs.getString("material.number"));
            }
            if (rs.getObject("material.name") != null) {
                result.put("FEntries_materialName", rs.getString("material.name"));
            }
            if (rs.getObject("material.model") != null) {
                result.put("FEntries_materialModel", rs.getString("material.model"));
            }
            if (rs.getObject("assistProperty.number") != null) {
                result.put("FEntries_materialAssistAttr", rs.getString("assistProperty.number"));
            }
            if (rs.getObject("unit.number") != null) {
                result.put("FEntries_unit", rs.getObject("unit.number"));
            }
            if (rs.getObject("entries.amount") != null) {
                result.put("FEntries_qty", rs.getObject("entries.amount"));
            }
            if (rs.getObject("entries.qtyFrom") != null) {
                result.put("FEntries_qtyFrom", rs.getObject("entries.qtyFrom"));
            }
            if (rs.getObject("entries.qtyTo") != null) {
                result.put("FEntries_qtyTo", rs.getObject("entries.qtyTo"));
            }
            if (rs.getObject("entries.consignmentAddress") != null) {
                result.put("FEntries_consignmentAddress", rs.getObject("entries.consignmentAddress"));
            }
            if (rs.getObject("entries.comsignmentDate") != null) {
                result.put("FEntries_consignmentDate", rs.getString("entries.comsignmentDate"));
            }
            if (rs.getObject("entries.comsignmentType") != null) {
                int comsignmentType = rs.getInt("entries.comsignmentType");
                if (0 == comsignmentType) {
                    result.put("FEntries_consignmentType", DeliveryStyleEnum.DELIVERY.toString());
                } else if (1 == comsignmentType) {
                    result.put("FEntries_consignmentType", DeliveryStyleEnum.SELF.toString());
                }
            }
            if (rs.getObject("entries.price") != null) {
                result.put("FEntries_price", rs.getObject("entries.price"));
            }
            if (rs.getObject("entries.taxRate") != null) {
                result.put("FEntries_taxRate", rs.getObject("entries.taxRate"));
            }
            if (rs.getObject("entries.taxPrice") != null) {
                result.put("FEntries_taxPrice", rs.getObject("entries.taxPrice"));
            }
            if (rs.getObject("discountType") != null) {
                int discountType = rs.getInt("discountType");
                if (0 == discountType) {
                    result.put("FEntries_discountType", DiscountModeEnum.PERCENT.toString());
                } else if (1 == discountType) {
                    result.put("FEntries_discountType", DiscountModeEnum.PERUNIT.toString());
                }
            }
            if (rs.getObject("entries.discount") != null) {
                result.put("FEntries_discount", rs.getObject("entries.discount"));
            }
            if (rs.getObject("entries.taxPrice") != null) {
                result.put("FEntries_tactualPrice", rs.getObject("entries.taxPrice"));
            }
            if (rs.getObject("entries.actualTaxPrice") != null) {
                result.put("FEntries_actualTaxPrice", rs.getObject("entries.actualTaxPrice"));
            }
            if (rs.getObject("project.number") != null) {
                result.put("FEntries_FProjectNumber", rs.getObject("project.number"));
            }
            if (rs.getObject("trackNumber.number") != null) {
                result.put("FEntries_FTrackNumber", rs.getObject("trackNumber.number"));
            }
            if (rs.getObject("entries.packagingExp") != null) {
                result.put("FEntries_packagingExp", rs.getObject("entries.packagingExp"));
            }
            if (rs.getObject("entries.carriage") != null) {
                result.put("FEntries_carriage", rs.getObject("entries.carriage"));
            }
            if (rs.getObject("entries.incidentalExpenses") != null) {
                result.put("FEntries_incidentalExpenses", rs.getObject("entries.incidentalExpenses"));
            }
            if (rs.getObject("entries.purAdvanceDate") != null) {
                result.put("FEntries_purAdvanceDate", rs.getObject("entries.purAdvanceDate"));
            }
            if (rs.getObject("entries.insureQualityDate") != null) {
                result.put("FEntries_insureQualityDate", rs.getObject("entries.insureQualityDate"));
            }
            if (rs.getObject("creator.name") != null) {
                result.put("FCreator", rs.getObject("creator.name"));
            }
            if (rs.getObject("createTime") != null) {
                Date disibleDate2 = new Date(rs.getTimestamp("createTime").getTime());
                dDate = dateFormat.format(disibleDate2);
                result.put("FCreatDate", dDate);
            }
        }
        catch (SQLException e) {
            Logger.error((Throwable)e);
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private String getImportServerResource(String key, Context ctx) {
        return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", key, ctx);
    }

    private String checkBillBaseStatusEnum(String value) {
        if ((BillBaseStatusEnum.TEMPORARILYSAVED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.TEMPORARILYSAVED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.SUBMITED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.SUBMITED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.AUDITED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.AUDITED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.DELETED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.DELETED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.ALTERING.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.ALTERING.getValue()) + "";
        }
        if ((BillBaseStatusEnum.RELEASED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.RELEASED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.CLOSED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.CLOSED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.BLOCKED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.BLOCKED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.COMPLETE.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.COMPLETE.getValue()) + "";
        }
        if ((BillBaseStatusEnum.PUBLISHED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.PUBLISHED.getValue()) + "";
        }
        if ((BillBaseStatusEnum.FINISH.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.FINISH.getValue()) + "";
        }
        if ((BillBaseStatusEnum.FINCLOSED.getValue() + "").equals(value)) {
            return BillBaseStatusEnum.getEnum((int)BillBaseStatusEnum.FINCLOSED.getValue()) + "";
        }
        return null;
    }

    private PurQuotationInfo getPurQuotationInfo(String number, PurchaseOrgUnitInfo purOrgInfo, Context ctx) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        PurQuotationInfo info = null;
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)purOrgInfo.getId().toString()));
        view.setFilter(filter);
        PurQuotationCollection cols = PurQuotationFactory.getLocalInstance(ctx).getPurQuotationCollection(view);
        if (cols == null || cols.size() <= 0) {
            return null;
        }
        info = cols.get(0);
        return info;
    }

    private CompanyOrgUnitInfo getPurOrgRelateCompanyOrg(PurQuotationInfo purQuotationInfo, Context ctx) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyInfo = null;
        if (purQuotationInfo.getPurchaseOrgUnit() != null) {
            PurchaseOrgUnitInfo orgInfo = purQuotationInfo.getPurchaseOrgUnit();
            OrgUnitCollection cols = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(orgInfo.getId().toString(), 3, 1);
            if (cols != null && cols.size() > 0) {
                companyInfo = (CompanyOrgUnitInfo)cols.get(0);
            }
        }
        return companyInfo;
    }

    private boolean checkAssistAttr(String materialID, String asstAttrNumber, String type, Context ctx) throws BOSException, SQLException {
        StringBuffer sp = new StringBuffer();
        sp.append(" select fmappingfield from t_bd_asstattrbasictype where fid ='" + type + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sp.toString());
        String mapping = null;
        while (rs.next()) {
            mapping = rs.getString("fmappingfield");
        }
        if (mapping == null) {
            // empty if block
        }
        sp = new StringBuffer();
        sp.append(" select f" + mapping + " from t_bd_AsstAttrValue where fbasictypeid");
        sp.append(" = '" + type + "' and fnumber = '" + asstAttrNumber + "'");
        IRowSet valueRowSet = DbUtil.executeQuery((Context)ctx, (String)sp.toString());
        return valueRowSet.next();
    }

    private BigDecimal getConvertQty(String materialID, MeasureUnitInfo unitInfo, BigDecimal fromQty, boolean isCoverToBase, Context ctx) throws EASBizException, BOSException {
        MultiMeasureUnitInfo multiUnifInfo = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialID, unitInfo.getId().toString());
        BigDecimal toQty = null;
        toQty = isCoverToBase ? fromQty.multiply(multiUnifInfo.getBaseConvsRate()).setScale(unitInfo.getQtyPrecision(), 4) : fromQty.divide(multiUnifInfo.getBaseConvsRate(), unitInfo.getQtyPrecision(), 4);
        return toQty;
    }

    public boolean isControllByPurOrgUnit(String purchaseOrgUnitID, Context ctx) throws EASBizException, BOSException {
        boolean isPurParam = true;
        String strPurParam = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(purchaseOrgUnitID), (String)"PURJICHU001");
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("0")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("1")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public void checkAndSetQtyFromTo(Context ctx, Hashtable innerTable, PurQuotationEntryInfo entryInfo) {
        BigDecimal qtyFrom = this.getDataBigDecimal(innerTable, "FEntries_qtyFrom");
        BigDecimal qtyTo = this.getDataBigDecimal(innerTable, "FEntries_qtyTo");
        BigDecimal qty = this.getDataBigDecimal(innerTable, "FEntries_qty");
        if (qtyFrom.compareTo(ZERO) < 0 || qtyTo.compareTo(ZERO) < 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "QTY_FROM_TO_ERROR", ctx) + "\n");
        } else if (qtyFrom.compareTo(ZERO) == 0 && qtyTo.compareTo(ZERO) == 0) {
            if (qty.compareTo(ZERO) < 0) {
                this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "Amount", ctx) + "\n");
            }
        } else if (qtyFrom.compareTo(ZERO) > 0 && qtyTo.compareTo(ZERO) == 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "QTY_RELATION", ctx) + "\n");
        } else if (qtyFrom.compareTo(ZERO) == 0 && qtyTo.compareTo(ZERO) > 0) {
            this.bewteenValue(ctx, qtyFrom, qtyTo, qty);
        } else if (qtyFrom.compareTo(qtyTo) > 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "QTY_RELATION", ctx) + "\n");
        } else {
            this.bewteenValue(ctx, qtyFrom, qtyTo, qty);
        }
        entryInfo.setQtyFrom(qtyFrom);
        entryInfo.setQtyTo(qtyTo);
        entryInfo.setAmount(qty);
    }

    public void bewteenValue(Context ctx, BigDecimal from, BigDecimal to, BigDecimal value) {
        if (value.compareTo(ZERO) < 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "Amount", ctx) + "\n");
            return;
        }
        if (value.compareTo(ZERO) == 0) {
            return;
        }
        if (from.compareTo(value) > 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "QtyFrom", ctx) + "\n");
        } else if (to.compareTo(value) < 0) {
            this.erroSB.append(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurQuotationResource", "QtyTo", ctx) + "\n");
        }
    }

    public String getImportPermissionItem() {
        return "purQuotation_addnew";
    }
}

