/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.CreatTypeEnum;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.IsUseableEnum;
import com.kingdee.eas.basedata.scm.sm.srm.PriceSourceEnum;
import com.kingdee.eas.basedata.scm.sm.srm.SharePriceCtrlStrategyEnum;
import com.kingdee.eas.basedata.scm.sm.srm.ShareSupplyInfoException;
import com.kingdee.eas.basedata.scm.sm.srm.SuplierPriceAllocMessageDetailInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SuplierPriceAllocMessageInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.IPurQuotation;
import com.kingdee.eas.scm.sm.pur.IPurQuotationEntry;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationException;
import com.kingdee.eas.scm.sm.pur.PurQuotationFactory;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurQuotationEntryControllerBean;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PurQuotationEntryControllerBean
extends AbstractPurQuotationEntryControllerBean {
    private static final long serialVersionUID = -109826081230409575L;
    private BigDecimal ZERO = new BigDecimal("0.00");

    @Override
    protected void _canCreateApprovedSupplier(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkEntryHandCreateAS(ctx, pks);
    }

    @Override
    protected void _createApprovedSupplier(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._createApprovedSupplier(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _createApprovedSupplier(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkEntryHandCreateAS(ctx, pks);
        if (pks != null) {
            ObjectUuidPK parentPK = null;
            IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
            IPurQuotationEntry iPurQuotationEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
            PurQuotationInfo purQuotationInfo = null;
            PurQuotationEntryInfo purQuotationEntryInfo = null;
            PurQuotationEntryInfo entryInfo = null;
            SelectorItemCollection billSelector = new SelectorItemCollection();
            billSelector.add(new SelectorItemInfo("id"));
            billSelector.add(new SelectorItemInfo("number"));
            billSelector.add(new SelectorItemInfo("purchaseOrgUnit.id"));
            billSelector.add(new SelectorItemInfo("supplier.id"));
            billSelector.add(new SelectorItemInfo("enabledDate"));
            billSelector.add(new SelectorItemInfo("unEffectiveTime"));
            billSelector.add(new SelectorItemInfo("isRevenue"));
            billSelector.add(new SelectorItemInfo("currency.id"));
            billSelector.add(new SelectorItemInfo("bizType"));
            SelectorItemCollection entrySelector = new SelectorItemCollection();
            entrySelector.add(new SelectorItemInfo("id"));
            entrySelector.add(new SelectorItemInfo("seq"));
            entrySelector.add(new SelectorItemInfo("parent.id"));
            entrySelector.add(new SelectorItemInfo("parent.supplier.id"));
            entrySelector.add(new SelectorItemInfo("parent.enabledDate"));
            entrySelector.add(new SelectorItemInfo("parent.unEffectiveTime"));
            entrySelector.add(new SelectorItemInfo("parent.currency.id"));
            entrySelector.add(new SelectorItemInfo("parent.purchaseOrgUnit.id"));
            entrySelector.add(new SelectorItemInfo("parent.isRevenue"));
            entrySelector.add(new SelectorItemInfo("parent.number"));
            entrySelector.add(new SelectorItemInfo("material.id"));
            entrySelector.add(new SelectorItemInfo("materialGroup.id"));
            entrySelector.add(new SelectorItemInfo("insureQualityDate"));
            entrySelector.add(new SelectorItemInfo("purAdvanceDate"));
            entrySelector.add(new SelectorItemInfo("taxRate"));
            entrySelector.add(new SelectorItemInfo("unit.id"));
            entrySelector.add(new SelectorItemInfo("qtyFrom"));
            entrySelector.add(new SelectorItemInfo("qtyTo"));
            entrySelector.add(new SelectorItemInfo("baseUnit.id"));
            entrySelector.add(new SelectorItemInfo("taxPrice"));
            entrySelector.add(new SelectorItemInfo("price"));
            entrySelector.add(new SelectorItemInfo("discountType"));
            entrySelector.add(new SelectorItemInfo("discount"));
            entrySelector.add(new SelectorItemInfo("assistProperty"));
            StringBuffer buffer = new StringBuffer();
            ArrayList<PurQuotationEntryInfo> entryList = new ArrayList<PurQuotationEntryInfo>();
            for (int i = 0; i < pks.length; ++i) {
                purQuotationEntryInfo = iPurQuotationEntry.getPurQuotationEntryInfo(pks[i], entrySelector);
                if (purQuotationEntryInfo.getMaterial() != null) {
                    entryList.add(purQuotationEntryInfo);
                    continue;
                }
                buffer.append(purQuotationEntryInfo.getSeq());
                buffer.append(",");
            }
            ArrayList toQtyList = new ArrayList();
            int num = entryList.size();
            for (int i = 0; i < num; ++i) {
                boolean isUpdate = true;
                purQuotationEntryInfo = (PurQuotationEntryInfo)entryList.get(i);
                if (purQuotationEntryInfo.getQtyFrom() != null && purQuotationEntryInfo.getQtyTo() != null && purQuotationEntryInfo.getQtyFrom().compareTo(purQuotationEntryInfo.getQtyTo()) == 0) {
                    for (int j = 0; j < entryList.size() && i != j; ++j) {
                        entryInfo = (PurQuotationEntryInfo)entryList.get(j);
                        if (this.isNeedUpdate(purQuotationEntryInfo, entryInfo)) continue;
                        isUpdate = false;
                        break;
                    }
                    if (!isUpdate) continue;
                }
                this.changeEntryStatus(iPurQuotationEntry, (IObjectPK)new ObjectUuidPK(purQuotationEntryInfo.getId().toString()));
                parentPK = new ObjectUuidPK(purQuotationEntryInfo.getParent().getId());
                purQuotationInfo = iPurQuotation.getPurQuotationInfo((IObjectPK)parentPK, billSelector);
                this.GeneralApprovedSupplier(ctx, purQuotationInfo, purQuotationEntryInfo);
                this.GeneralSupplierPrice(ctx, purQuotationInfo, purQuotationEntryInfo, true);
            }
            if (buffer.length() > 0) {
                buffer.deleteCharAt(buffer.length() - 1);
                throw new PurQuotationException(PurQuotationException.QUO_MATERIALGROUP_NOT_UPDATE_SUPPLIERPRICE, new String[]{buffer.toString()});
            }
        }
    }

    protected void changeEntryStatus(IPurQuotationEntry iPurQuotationEntry, IObjectPK pk) throws EASBizException, BOSException {
        boolean isUpdateASInfo = true;
        PurQuotationEntryInfo purQuotationEntryInfo = iPurQuotationEntry.getPurQuotationEntryInfo(pk);
        purQuotationEntryInfo.setIsUpdateASInfo(isUpdateASInfo);
        iPurQuotationEntry.update(pk, (CoreBaseInfo)purQuotationEntryInfo);
    }

    protected void checkEntryHandCreateAS(Context ctx, IObjectPK[] entryPKs) throws EASBizException, BOSException {
        if (entryPKs != null && entryPKs.length > 0) {
            int n = entryPKs.length;
            for (int i = 0; i < n; ++i) {
                try {
                    this.checkEntryHandCreateAS(ctx, entryPKs[i]);
                    continue;
                }
                catch (PurQuotationException e) {
                    if (n > 1) {
                        throw new PurQuotationException(PurQuotationException.QUOPR_CANNOT_ASINFO_NOALL, new String[]{PurUtil.getUIResource("OPERATOR_CLOSE")});
                    }
                    throw e;
                }
            }
        }
    }

    public void checkEntryHandCreateAS(Context ctx, IObjectPK entryPK) throws EASBizException, BOSException {
        PurQuotationInfo pqInfo = null;
        PurQuotationEntryInfo pqEntryInfo = this.getPurQuotationEntryInfo(ctx, entryPK);
        ObjectUuidPK pqPK = new ObjectUuidPK(pqEntryInfo.getParent().getId());
        IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
        pqInfo = iPurQuotation.getPurQuotationInfo((IObjectPK)pqPK);
        if (pqEntryInfo.getBaseStatus().getValue() != 4) {
            throw new PurQuotationException(PurQuotationException.QUO_CANNOT_ASINFO);
        }
        if (pqEntryInfo.isIsUpdateASInfo()) {
            throw new PurQuotationException(PurQuotationException.QUOPR_CANNOT_ASINFO_AGAIN);
        }
        if (pqEntryInfo.getMaterial() == null && pqEntryInfo.getMaterialGroup() == null) {
            throw new PurQuotationException(PurQuotationException.QUOPR_CANNOT_ASINFO_NOROWTYPE);
        }
        if (SysConstant.BIGZERO.compareTo(pqEntryInfo.getPrice()) == 0) {
            throw new PurQuotationException(PurQuotationException.QUO_NET_PRICE_UP_SUPPRICE, new String[]{"", String.valueOf(pqEntryInfo.getSeq())});
        }
    }

    public void GeneralApprovedSupplier(Context ctx, PurQuotationInfo billInfo, PurQuotationEntryInfo billEntryInfo) throws EASBizException, BOSException {
        ObjectUuidPK purOrgID = new ObjectUuidPK(billInfo.getPurchaseOrgUnit().getId().toString());
        IParamControl ipc = ParamControlFactory.getLocalInstance((Context)ctx);
        String isParamValue = ipc.getParamValue((IObjectPK)purOrgID, "PURSUP001");
        if (isParamValue == null || isParamValue.trim().length() == 0 || !isParamValue.trim().equalsIgnoreCase("true")) {
            return;
        }
        ApprovedSupplierCollection ApprovedSupColl = null;
        ApprovedSupColl = new ApprovedSupplierCollection();
        ApprovedSupplierInfo approveSupp = new ApprovedSupplierInfo();
        boolean isHasApprovedSupplier = false;
        IApprovedSupplier iAS = ApprovedSupplierFactory.getLocalInstance((Context)ctx);
        String materialID = null;
        String materialGroupID = null;
        if (billEntryInfo.getMaterial() != null) {
            materialID = billEntryInfo.getMaterial().getId().toString();
        }
        if (billEntryInfo.getMaterialGroup() != null) {
            materialGroupID = billEntryInfo.getMaterialGroup().getId().toString();
        }
        ApprovedSupplierInfo oldApproveSupp = new ApprovedSupplierInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)billInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)billInfo.getSupplier().getId().toString(), CompareType.EQUALS));
        if (materialID != null && materialID.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialID, CompareType.EQUALS));
        }
        if (materialGroupID != null && materialGroupID.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("materialGroup1.id", (Object)materialGroupID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("purchaseOrg.name");
        selector.add("purchaseOrg.number");
        selector.add("materialItem.name");
        selector.add("materialItem.number");
        selector.add("supplier.name");
        selector.add("supplier.number");
        selector.add("isUseable");
        selector.add("materialAttr");
        selector.add("creatType");
        selector.add("isVMI");
        view.setSelector(selector);
        ApprovedSupplierCollection collection = iAS.getApprovedSupplierCollection(view);
        if (collection != null && collection.size() >= 1) {
            isHasApprovedSupplier = true;
            oldApproveSupp = collection.get(0);
        } else {
            isHasApprovedSupplier = false;
        }
        if (!isHasApprovedSupplier) {
            approveSupp.setId(BOSUuid.create((String)BOSObjectType.create((String)"30690305").toString()));
        } else {
            approveSupp = oldApproveSupp;
        }
        approveSupp.setPurchaseOrg(billInfo.getPurchaseOrgUnit());
        approveSupp.setSupplier(billInfo.getSupplier());
        if (billEntryInfo.getMaterial() != null) {
            approveSupp.setMaterialItem(billEntryInfo.getMaterial());
        }
        if (billEntryInfo.getMaterialGroup() != null) {
            approveSupp.setMaterialGroup1(billEntryInfo.getMaterialGroup());
        }
        approveSupp.setExpiryDate(billEntryInfo.getInsureQualityDate());
        approveSupp.setLeadtime(billEntryInfo.getPurAdvanceDate());
        approveSupp.setPurMeasureUnit(billEntryInfo.getUnit());
        approveSupp.setQtyOrderBottom(this.ZERO);
        approveSupp.setQtyOrderTop(PurUtil.MAXVAL);
        if (billInfo.getPurchaseOrgUnit() != null && billEntryInfo.getMaterial() != null) {
            IMaterialPurchasing ima = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("daysDelay"));
            sic.add(new SelectorItemInfo("daydAhead"));
            sic.add(new SelectorItemInfo("receiveBottomRatio"));
            sic.add(new SelectorItemInfo("receiveTopRatio"));
            sic.add(new SelectorItemInfo("isNotControlQty"));
            sic.add(new SelectorItemInfo("isNotControlTime"));
            viewInfo.setSelector(sic);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)billInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)billEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            MaterialPurchasingCollection con = ima.getMaterialPurchasingCollection(viewInfo);
            MaterialPurchasingInfo mpInfo = null;
            if (con.size() > 0) {
                mpInfo = con.get(0);
            }
            if (mpInfo != null) {
                approveSupp.setDayBottom(new BigDecimal(mpInfo.getDaysDelay()));
                approveSupp.setDayTop(new BigDecimal(mpInfo.getDaydAhead()));
                approveSupp.setQtySupplyBottom(new BigDecimal(mpInfo.getReceiveBottomRatio()));
                approveSupp.setQtySupplyTop(new BigDecimal(mpInfo.getReceiveTopRatio()));
                if (mpInfo.isIsNotControlQty()) {
                    approveSupp.setQuantityUnCtrl(Boolean.TRUE.booleanValue());
                } else {
                    approveSupp.setQuantityUnCtrl(Boolean.FALSE.booleanValue());
                }
                if (mpInfo.isIsNotControlTime()) {
                    approveSupp.setTimeUnCtrl(Boolean.TRUE.booleanValue());
                } else {
                    approveSupp.setTimeUnCtrl(Boolean.FALSE.booleanValue());
                }
            }
        }
        if (billEntryInfo.getTaxRate() != null) {
            approveSupp.setTaxRate(billEntryInfo.getTaxRate());
        }
        approveSupp.setIsUseable(IsUseableEnum.Useable);
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        Date today = new Date();
        approveSupp.setCreator(user);
        approveSupp.setCreateTime(new Timestamp(today.getTime()));
        approveSupp.setLastUpdateUser(user);
        approveSupp.setLastUpdateTime(new Timestamp(today.getTime()));
        approveSupp.setAuditor(user);
        approveSupp.setAuditDate((Date)new Timestamp(today.getTime()));
        approveSupp.setPurOrgCreator(approveSupp.getPurchaseOrg());
        approveSupp.setCreatType(CreatTypeEnum.ADD_NEW);
        approveSupp.setString("isFromQuo", "isFromQuo");
        ApprovedSupColl.addObject((IObjectValue)approveSupp);
        ApprovedSupplierCollection updateCol = null;
        ApprovedSupplierCollection submitCol = null;
        if (!isHasApprovedSupplier) {
            submitCol = ApprovedSupColl;
        } else {
            updateCol = ApprovedSupColl;
        }
        iAS.doSave((IObjectCollection)updateCol, (IObjectCollection)submitCol);
    }

    private boolean isSubContractBillData(SCMBillBaseInfo info) {
        boolean isSub = false;
        if (info.getBizType() != null && info.getBizType().getId() != null && "1x7KMBq4mUmpj58T4jNPqiQHQ1w=".equals(info.getBizType().getId().toString())) {
            isSub = true;
        }
        return isSub;
    }

    public void GeneralSupplierPrice(Context ctx, PurQuotationInfo billInfo, PurQuotationEntryInfo billEntryInfo, boolean isQtyFrom) throws EASBizException, BOSException {
        if (billEntryInfo == null || billEntryInfo.getMaterial() == null) {
            return;
        }
        SupplyInfoCollection suppPriceColl = null;
        suppPriceColl = new SupplyInfoCollection();
        ArrayList<SupplyInfoInfo> supplyInfoList = new ArrayList<SupplyInfoInfo>();
        SupplyInfoInfo suppPriceInfo = new SupplyInfoInfo();
        boolean isHasSupplierPrice = false;
        ISupplyInfo iSuppInfo = SupplyInfoFactory.getLocalInstance((Context)ctx);
        SupplyInfoInfo oldSuppPriceInfo = new SupplyInfoInfo();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)billInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)billInfo.getSupplier().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)billEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        if (this.isSubContractBillData(billInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"1", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"0", CompareType.EQUALS));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)billEntryInfo.getUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)(sdf.format(billInfo.getEnabledDate()) + " 00:00:00.0"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)(sdf.format(billInfo.getUnEffectiveTime()) + " 23:59:59.0"), CompareType.EQUALS));
        if (isQtyFrom) {
            if (billEntryInfo.getQtyFrom() != null) {
                filter.getFilterItems().add(new FilterItemInfo("fromQty", (Object)billEntryInfo.getQtyFrom().toPlainString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("fromQty", null, CompareType.EQUALS));
            }
        } else if (billEntryInfo.getQtyTo().toPlainString() != null) {
            filter.getFilterItems().add(new FilterItemInfo("fromQty", (Object)billEntryInfo.getQtyTo().toPlainString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("fromQty", null, CompareType.EQUALS));
        }
        if (billEntryInfo.getAssistProperty() != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty", (Object)billEntryInfo.getAssistProperty().getId().toString(), CompareType.EQUALS));
        }
        if (billInfo.getCurrency() != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)billInfo.getCurrency().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("recOrg", null, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getSupplyInfoSelector());
        SupplyInfoCollection collection = iSuppInfo.getSupplyInfoCollection(view);
        if (collection != null && collection.size() > 0 && (oldSuppPriceInfo = collection.get(0)) != null) {
            isHasSupplierPrice = true;
        }
        UserInfo user = new UserInfo();
        user.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        Date today = new Date();
        if (!isHasSupplierPrice) {
            suppPriceInfo.setId(BOSUuid.create((String)BOSObjectType.create((String)"6584F9A8").toString()));
            suppPriceInfo.setPurchaseOrg(billInfo.getPurchaseOrgUnit());
            suppPriceInfo.setSupplier(billInfo.getSupplier());
            if (billEntryInfo.getMaterial() != null) {
                suppPriceInfo.setMaterialItem(billEntryInfo.getMaterial());
            }
            suppPriceInfo.setMeasureUnit(billEntryInfo.getBaseUnit());
            suppPriceInfo.setPurMeasureUnit(billEntryInfo.getUnit());
            SimpleDateFormat effectDate = new SimpleDateFormat("yyyy-MM-dd 00:00:00");
            SimpleDateFormat uneffectDate = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
            suppPriceInfo.setEffectualDate((Date)Timestamp.valueOf(effectDate.format(billInfo.getEnabledDate())));
            suppPriceInfo.setUneffectualDate((Date)Timestamp.valueOf(uneffectDate.format(billInfo.getUnEffectiveTime())));
            suppPriceInfo.setQtyOrderBottom(this.ZERO);
            suppPriceInfo.setQtyOrderTop(this.ZERO);
            suppPriceInfo.setMaxPrice(this.ZERO);
            suppPriceInfo.setMinPrice(this.ZERO);
            if (billEntryInfo.getQtyFrom() != null) {
                suppPriceInfo.setFromQty(billEntryInfo.getQtyFrom());
            }
            if (billEntryInfo.getQtyTo() != null) {
                suppPriceInfo.setToQty(billEntryInfo.getQtyTo());
            }
            suppPriceInfo.setIsTaxPrice(billInfo.isIsRevenue());
            if (billInfo.isIsRevenue()) {
                suppPriceInfo.setTaxRate(billEntryInfo.getTaxRate());
            }
            if (billInfo.isIsRevenue()) {
                suppPriceInfo.setTaxRate(billEntryInfo.getTaxRate());
            }
            if (isQtyFrom) {
                if (billInfo.isIsRevenue()) {
                    suppPriceInfo.setPrice(billEntryInfo.getTaxPrice());
                } else {
                    suppPriceInfo.setPrice(billEntryInfo.getPrice());
                }
            } else {
                suppPriceInfo.setPrice(this.ZERO);
            }
            if (billEntryInfo.getDiscountType().equals((Object)DiscountModeEnum.PERCENT)) {
                suppPriceInfo.setDiscountRate(billEntryInfo.getDiscount());
            }
            suppPriceInfo.setLastPrice(this.ZERO);
            suppPriceInfo.setLastPurTime(null);
            suppPriceInfo.setIsUseable(IsUseableEnum.Useable);
            suppPriceInfo.setCreator(user);
            suppPriceInfo.setCreateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setLastUpdateUser(user);
            suppPriceInfo.setLastUpdateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setAuditor(user);
            suppPriceInfo.setAuditDate((Date)new Timestamp(today.getTime()));
        } else {
            suppPriceInfo = oldSuppPriceInfo;
            suppPriceInfo.setIsTaxPrice(billInfo.isIsRevenue());
            if (billInfo.isIsRevenue()) {
                suppPriceInfo.setTaxRate(billEntryInfo.getTaxRate());
            }
            if (isQtyFrom) {
                if (billInfo.isIsRevenue()) {
                    suppPriceInfo.setPrice(billEntryInfo.getTaxPrice());
                } else {
                    suppPriceInfo.setPrice(billEntryInfo.getPrice());
                }
            } else {
                suppPriceInfo.setPrice(this.ZERO);
            }
            if (billEntryInfo.getDiscountType().equals((Object)DiscountModeEnum.PERCENT)) {
                suppPriceInfo.setDiscountRate(billEntryInfo.getDiscount());
            }
            suppPriceInfo.setIsUseable(IsUseableEnum.Useable);
            suppPriceInfo.setCreator(user);
            suppPriceInfo.setCreateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setLastUpdateUser(user);
            suppPriceInfo.setLastUpdateTime(new Timestamp(today.getTime()));
            suppPriceInfo.setAuditor(user);
            suppPriceInfo.setAuditDate((Date)new Timestamp(today.getTime()));
            if (billEntryInfo.getQtyFrom() != null) {
                suppPriceInfo.setFromQty(billEntryInfo.getQtyFrom());
            }
            if (billEntryInfo.getQtyTo() != null) {
                suppPriceInfo.setToQty(billEntryInfo.getQtyTo());
            }
        }
        if (this.isSubContractBillData(billInfo)) {
            suppPriceInfo.setMaterialPurchaseType(MaterialPurchaseTypeEnum.SUBCONTRACT);
        } else {
            suppPriceInfo.setMaterialPurchaseType(MaterialPurchaseTypeEnum.PURCHASE);
        }
        if (billEntryInfo.getAssistProperty() != null) {
            suppPriceInfo.setAssistProperty(billEntryInfo.getAssistProperty());
        }
        if (billInfo.getCurrency() != null) {
            suppPriceInfo.setCurrency(billInfo.getCurrency());
        }
        suppPriceInfo.setSourceBillEntrySeq(billEntryInfo.getSeq());
        suppPriceInfo.setSourceBillNo(billInfo.getNumber());
        suppPriceInfo.setPriceSource(PriceSourceEnum.FROM_PUR_QUOTATION);
        suppPriceInfo.setCreatePurchaseOrg(suppPriceInfo.getPurchaseOrg());
        suppPriceInfo.setPriceCtrlStrategy(SharePriceCtrlStrategyEnum.NO_CTRL);
        supplyInfoList.add(suppPriceInfo);
        SuplierPriceAllocMessageInfo updateResult = iSuppInfo.batchUpdate(supplyInfoList);
        List checkPrcieCtrlStrategy = updateResult.getCheckPriceStrategyResult();
        if (checkPrcieCtrlStrategy.size() > 0 && !this.IsInActiveWorkFlow(ctx, billInfo.getId().toString())) {
            SuplierPriceAllocMessageDetailInfo messageInfo = (SuplierPriceAllocMessageDetailInfo)checkPrcieCtrlStrategy.get(0);
            PurchaseOrgUnitInfo purorg = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(suppPriceInfo.getPurchaseOrg().getId()));
            throw new ShareSupplyInfoException(ShareSupplyInfoException.PURCHASENOPRICECTRLSTRATEGYEXCEPTION, (Object[])new String[]{purorg.getName(), ((String)messageInfo.getDetialList().get(0)).toString()});
        }
    }

    private BigDecimal getActPriceForSupplier(Context ctx, PurQuotationInfo billInfo, BigDecimal oldPrice) throws EASBizException, BOSException {
        ISupplier supplier = SupplierFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK supplierPK = new ObjectUuidPK(billInfo.getSupplier().getId());
        SupplierCompanyInfoInfo supplierCompanyInfoInfo = null;
        CurrencyInfo billCurrencyInfo = null;
        CurrencyInfo supplierCurrencyInfo = null;
        billCurrencyInfo = billInfo.getCurrency();
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(billInfo.getPurchaseOrgUnit().getId().toString(), 3, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(billInfo.getPurchaseOrgUnit().getId().toString(), 3, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        ObjectUuidPK companyOrgUnitPK = new ObjectUuidPK(ret.getId());
        SelectorItemCollection supplierCompanyInfoSelector = new SelectorItemCollection();
        supplierCompanyInfoSelector.add(new SelectorItemInfo("settlementCurrency.*"));
        supplierCompanyInfoInfo = supplier.getCompanyInfo((IObjectPK)supplierPK, (IObjectPK)companyOrgUnitPK, supplierCompanyInfoSelector);
        if (supplierCompanyInfoInfo != null) {
            supplierCurrencyInfo = supplierCompanyInfoInfo.getSettlementCurrency();
        }
        if (billCurrencyInfo != null && supplierCurrencyInfo != null && billCurrencyInfo.getId() != supplierCurrencyInfo.getId()) {
            BigDecimal actPrice = oldPrice;
            if (oldPrice.compareTo(actPrice = this.exchangeRateChangeForSupplier(ctx, ret, supplierCurrencyInfo, billCurrencyInfo, actPrice)) != 0) {
                oldPrice = actPrice;
            }
        }
        return oldPrice;
    }

    private BigDecimal exchangeRateChangeForSupplier(Context ctx, CompanyOrgUnitInfo companyOrgInfo, CurrencyInfo currencyInfo, CurrencyInfo baseCurrForSupplierInfo, BigDecimal actPrice) throws EASBizException, BOSException {
        BigDecimal ONE = new BigDecimal("1.00");
        int DEFAULTPRECISION = 2;
        if (currencyInfo == null) {
            return actPrice;
        }
        ExchangeRateInfo exchangeRateForSupplierInfo = null;
        BigDecimal exchangeRate = ONE;
        int exchangeRatePrecision = DEFAULTPRECISION;
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(currencyInfo.getId());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(baseCurrForSupplierInfo.getId());
        exchangeRateForSupplierInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)companyOrgInfo, (IObjectPK)destCurrPK, (IObjectPK)sourceCurrPK);
        if (exchangeRateForSupplierInfo != null) {
            exchangeRate = exchangeRateForSupplierInfo.getConvertRate();
            exchangeRatePrecision = exchangeRateForSupplierInfo.getPrecision();
            actPrice = exchangeRateForSupplierInfo == null || exchangeRateForSupplierInfo.getConvertMode().getValue() == 1 ? actPrice.divide(exchangeRate, exchangeRatePrecision, 4) : actPrice.multiply(exchangeRate).setScale(exchangeRatePrecision, 4);
        }
        return actPrice;
    }

    @Override
    protected void _updateSupplierPrice(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks != null) {
            int i;
            Object parentPK = null;
            IPurQuotation iPurQuotation = PurQuotationFactory.getLocalInstance(ctx);
            IPurQuotationEntry iPurQuotationEntry = PurQuotationEntryFactory.getLocalInstance(ctx);
            PurQuotationInfo purQuotationInfo = null;
            PurQuotationEntryInfo purQuotationEntryInfo = null;
            PurQuotationEntryInfo entryInfo = null;
            SelectorItemCollection billSelector = new SelectorItemCollection();
            billSelector.add(new SelectorItemInfo("id"));
            billSelector.add(new SelectorItemInfo("number"));
            billSelector.add(new SelectorItemInfo("purchaseOrgUnit.id"));
            billSelector.add(new SelectorItemInfo("supplier.id"));
            billSelector.add(new SelectorItemInfo("enabledDate"));
            billSelector.add(new SelectorItemInfo("unEffectiveTime"));
            billSelector.add(new SelectorItemInfo("isRevenue"));
            billSelector.add(new SelectorItemInfo("currency.id"));
            SelectorItemCollection entrySelector = new SelectorItemCollection();
            billSelector.add(new SelectorItemInfo("entries.id"));
            billSelector.add(new SelectorItemInfo("entries.seq"));
            billSelector.add(new SelectorItemInfo("entries.material.id"));
            billSelector.add(new SelectorItemInfo("entries.materialGroup.id"));
            billSelector.add(new SelectorItemInfo("entries.insureQualityDate"));
            billSelector.add(new SelectorItemInfo("entries.purAdvanceDate"));
            billSelector.add(new SelectorItemInfo("entries.taxRate"));
            billSelector.add(new SelectorItemInfo("entries.unit.id"));
            billSelector.add(new SelectorItemInfo("entries.qtyFrom"));
            billSelector.add(new SelectorItemInfo("entries.qtyTo"));
            billSelector.add(new SelectorItemInfo("entries.baseUnit.id"));
            billSelector.add(new SelectorItemInfo("entries.taxPrice"));
            billSelector.add(new SelectorItemInfo("entries.price"));
            billSelector.add(new SelectorItemInfo("entries.discountType"));
            billSelector.add(new SelectorItemInfo("entries.discount"));
            billSelector.add(new SelectorItemInfo("entries.assistProperty"));
            ArrayList<PurQuotationEntryInfo> toQtyList = new ArrayList<PurQuotationEntryInfo>();
            int num = pks.length;
            for (i = 0; i < num; ++i) {
                purQuotationInfo = iPurQuotation.getPurQuotationInfo(pks[i], billSelector);
                for (int j = 0; j < purQuotationInfo.getEntries().size(); ++j) {
                    boolean isUpdate = true;
                    purQuotationEntryInfo = purQuotationInfo.getEntries().get(j);
                    if (purQuotationEntryInfo.getMaterialGroup() != null) continue;
                    if (purQuotationEntryInfo.getQtyFrom() != null && purQuotationEntryInfo.getQtyTo() != null && purQuotationEntryInfo.getQtyFrom().compareTo(purQuotationEntryInfo.getQtyTo()) == 0) {
                        for (int m = 0; m < purQuotationInfo.getEntries().size() && m != j; ++m) {
                            entryInfo = purQuotationInfo.getEntries().get(j);
                            if (this.isNeedUpdate(purQuotationEntryInfo, entryInfo)) continue;
                            isUpdate = false;
                            break;
                        }
                        if (!isUpdate) continue;
                    }
                    if (purQuotationEntryInfo.getQtyFrom() != null && purQuotationEntryInfo.getQtyTo() != null && purQuotationEntryInfo.getQtyFrom().compareTo(purQuotationEntryInfo.getQtyTo()) == 0) {
                        this.GeneralSupplierPrice(ctx, purQuotationInfo, purQuotationEntryInfo, true);
                        continue;
                    }
                    this.GeneralSupplierPrice(ctx, purQuotationInfo, purQuotationEntryInfo, true);
                    toQtyList.add(purQuotationEntryInfo);
                }
            }
            for (i = 0; i < toQtyList.size(); ++i) {
                boolean isUpdate;
                purQuotationEntryInfo = (PurQuotationEntryInfo)toQtyList.get(i);
                if (purQuotationEntryInfo.getMaterialGroup() != null || !(isUpdate = this.isUpdatePriceByQtyTo(ctx, purQuotationInfo, purQuotationEntryInfo))) continue;
                purQuotationEntryInfo.setQtyFrom(purQuotationEntryInfo.getQtyTo());
                this.GeneralSupplierPrice(ctx, purQuotationInfo, purQuotationEntryInfo, false);
            }
        }
    }

    private boolean isUpdatePriceByQtyTo(Context ctx, PurQuotationInfo billInfo, PurQuotationEntryInfo billEntryInfo) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrg", (Object)billInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplier", (Object)billInfo.getSupplier().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("materialItem", (Object)billEntryInfo.getMaterial().getId().toString(), CompareType.EQUALS));
        if (this.isSubContractBillData(billInfo)) {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"1", CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)"0", CompareType.EQUALS));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)billEntryInfo.getUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)(sdf.format(billInfo.getEnabledDate()) + " 00:00:00.0"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)(sdf.format(billInfo.getUnEffectiveTime()) + " 23:59:59.0"), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("fromQty", (Object)billEntryInfo.getQtyTo(), CompareType.EQUALS));
        if (billEntryInfo.getAssistProperty() != null) {
            filter.getFilterItems().add(new FilterItemInfo("assistProperty", (Object)billEntryInfo.getAssistProperty().getId().toString(), CompareType.EQUALS));
        }
        if (billInfo.getCurrency() != null) {
            filter.getFilterItems().add(new FilterItemInfo("currency", (Object)billInfo.getCurrency().getId().toString(), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("recOrg", null, CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getSupplyInfoSelector());
        ISupplyInfo iSuppInfo = SupplyInfoFactory.getLocalInstance((Context)ctx);
        SupplyInfoCollection collection = iSuppInfo.getSupplyInfoCollection(view);
        return collection == null || collection.size() <= 0;
    }

    private boolean isNeedUpdate(PurQuotationEntryInfo entryInfo, PurQuotationEntryInfo entryInfo1) {
        return !this.isSame(entryInfo.getMaterial(), entryInfo1.getMaterial()) || !this.isSame(entryInfo.getUnit(), entryInfo1.getUnit()) || !this.isSame(entryInfo.getAssistProperty(), entryInfo1.getAssistProperty()) || !this.isSame(entryInfo.getParent().getSupplier(), entryInfo1.getParent().getSupplier()) || !this.isSame(entryInfo.getParent().getCurrency(), entryInfo1.getParent().getCurrency()) || this.isSame(entryInfo1.getQtyFrom(), entryInfo1.getQtyTo());
    }

    private boolean isSame(Object obj1, Object obj2) {
        if (obj1 != null && obj2 == null || obj1 == null && obj2 != null) {
            return false;
        }
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null && obj2 != null) {
            if (obj1 instanceof String) {
                return obj1.equals(obj2);
            }
            if (obj1 instanceof BigDecimal) {
                return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
            }
            if (obj1 instanceof MaterialInfo) {
                return ((MaterialInfo)obj1).getId().toString().equals(((MaterialInfo)obj2).getId().toString());
            }
            if (obj1 instanceof AsstAttrValueInfo) {
                return ((AsstAttrValueInfo)obj1).getId().toString().equals(((AsstAttrValueInfo)obj2).getId().toString());
            }
            if (obj1 instanceof SupplierInfo) {
                return ((SupplierInfo)obj1).getId().toString().equals(((SupplierInfo)obj2).getId().toString());
            }
            if (obj1 instanceof CurrencyInfo) {
                return ((CurrencyInfo)obj1).getId().toString().equals(((CurrencyInfo)obj2).getId().toString());
            }
        }
        return true;
    }

    private boolean IsInActiveWorkFlow(Context ctx, String keyIDs) throws BOSException {
        IEnactmentService service = EnactmentServiceFactory.createEnactService((Context)ctx);
        ProcessInstInfo instInfo = null;
        ProcessInstInfo[] procInsts = service.getProcessInstanceByHoldedObjectId(keyIDs);
        int n = procInsts.length;
        for (int j = 0; j < n; ++j) {
            if (!"open.running".equals(procInsts[j].getState())) continue;
            instInfo = procInsts[j];
        }
        return instInfo != null;
    }
}

