/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.google.gson.internal.LinkedTreeMap;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueCollection;
import com.kingdee.eas.basedata.master.material.AsstAttrValueFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeCollection;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.DBUtil;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.control.IProductionOrder;
import com.kingdee.eas.mm.control.ProductionOrderFactory;
import com.kingdee.eas.mm.planning.ReqPlanForSCMFacadeFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvBizException;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestAgent;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.ReqParamDataVO;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequestControllerBean;
import com.kingdee.eas.scm.sm.pur.app.EntryProcessServerHelper;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestCal;
import com.kingdee.eas.scm.sm.pur.util.BgCtrlCallerUtil;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.eas.scm.sm.pur.util.PurEntryProcessUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class PurRequestControllerBean
extends AbstractPurRequestControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 4038871494955656710L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequestControllerBean");
    private String sp = "\r\n";
    public static final BigDecimal MAXVAL = new BigDecimal("9999999999999.0");
    private Map<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
    private Map<String, PurchaseOrgUnitInfo> storageTopurMap = new HashMap<String, PurchaseOrgUnitInfo>();
    private String loc = "l2";
    private String permissionSQL = null;
    private String permissionJoinSQL = null;
    private static final String[] zerofields = new String[]{"qty", "assistQty", "price", "amount", "unOrderedQty", "localAmount", "baseQty", "orderedQty", "discountRate", "taxRate", "actualPrice", "orderedBaseQty", "unOrderedBaseQty", "totalReqQty", "totalRequQty", "unTotalReqQty", "requestQty", "assOrderBaseQty", "assOrderQty", "taxPrice", "actualTaxPrice", "tax", "taxAmount", "discountAmount", "localTaxAmount", "localTax", "executeAmout", "reqBudgetAmt"};

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurRequestInfo purRequestInfo = null;
        purRequestInfo = isUseAgent ? PurRequestAgent.create() : new PurRequestInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        purRequestInfo.setCreateTime(ts);
        purRequestInfo.setBizDate(curDate);
        purRequestInfo.setPerson(this.getPersonInfo(ctx));
        BizTypeInfo bizTypeInfo = null;
        IBizType iBizType = BizTypeFactory.getLocalInstance((Context)ctx);
        bizTypeInfo = Boolean.TRUE.equals(ctx.get((Object)"isSubContract")) ? iBizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK("1x7KMBq4mUmpj58T4jNPqiQHQ1w=")) : iBizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        purRequestInfo.setBizType(bizTypeInfo);
        if (!this.isBizTypeValid(ctx, (IObjectValue)purRequestInfo, "510b6503-0105-1000-e000-0107c0a812fd463ED552", bizTypeInfo).booleanValue()) {
            purRequestInfo.setBizType(null);
        } else {
            purRequestInfo.setDemandType(this.getDefaultDemandType(ctx, bizTypeInfo));
        }
        return purRequestInfo;
    }

    private DemandTypeInfo getDefaultDemandType(Context ctx, BizTypeInfo biztype) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        if (Boolean.TRUE.equals(ctx.get((Object)"isSubContract"))) {
            filter.getFilterItems().add(new FilterItemInfo("purchanseType", (Object)1));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("purchanseType", (Object)0));
            StringBuffer sql = new StringBuffer();
            sql.append(" select FRowTypeID  from T_SCM_RowBizType where FBizTypeID = '").append(biztype.getId().toString()).append("'");
            filter.getFilterItems().add(new FilterItemInfo("rowType.id", (Object)sql.toString(), CompareType.INNER));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        ServiceStateManager.getInstance().enableNextCallServices();
        DemandTypeCollection demandTypeColl = DemandTypeFactory.getLocalInstance((Context)ctx).getDemandTypeCollection(view);
        if (demandTypeColl != null && demandTypeColl.size() > 0) {
            return demandTypeColl.get(0);
        }
        return null;
    }

    private PersonInfo getPersonInfo(Context ctx) throws BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo curPerson = userInfo.getPerson();
        if (curPerson == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid from T_BD_Person as p ");
        sql.append(" inner join T_ORG_PositionMember as pm on p.fid = pm.FPersonID ");
        sql.append(" inner join T_ORG_Position as po on po.fid =pm.FPositionID");
        sql.append(" inner join T_ORG_Admin as a on po.FAdminOrgUnitID = a.fid ");
        sql.append(" inner join T_ORG_CtrlUnit as cu on cu.fid = a.FControlUnitID ");
        sql.append(" where cu.fid = '").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(" and p.fid = '").append(curPerson.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!rowSet.next()) {
                curPerson = null;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return curPerson;
    }

    protected void _delete(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int len = pks.length;
        for (i = 0; i < len; ++i) {
            list.add(pks[i].toString());
        }
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.SUBMIT);
        len = pks.length;
        for (i = 0; i < len; ++i) {
            this._delete(ctx, pks[i]);
        }
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequestInfo model = (PurRequestInfo)this.getValue(ctx, pk);
        this.checkBeforeDEL(ctx, model);
        this.writeByPurRequestTotal(ctx, new IObjectPK[]{pk}, true);
        if (this.isBotpBill(model, "ejIZHXXTQliYCQJg9t4Re0Y+1VI=")) {
            ObjectUuidPK poPK = new ObjectUuidPK(model.getSourceBillId());
            IProductionOrder iProductionOrder = ProductionOrderFactory.getLocalInstance((Context)ctx);
            iProductionOrder.outSourceBillDelateWriteBack(new IObjectPK[]{poPK}, false);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(pk.toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.DELETE);
        super._delete(ctx, pk);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = super.getSelector();
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        return sic;
    }

    private void checkBeforeDEL(Context ctx, PurRequestInfo model) throws BOSException, EASBizException {
        if (model.getBaseStatus() != null) {
            if (model.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.DEL_IS_CANCEL);
            }
            if (model.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.DEL_IS_ADDIT);
            }
            if (model.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.DEL_IS_CLOSED);
            }
            if (PurEntryProcessUtils.isEnableEntryProcessForPurRequest(ctx)) {
                PurRequestInfo info = model;
                PurRequestEntryCollection entries = info.getEntries();
                PurRequestEntryInfo entry = null;
                int len = entries.size();
                for (int i = 0; i < len; ++i) {
                    entry = entries.get(i);
                    if (!EntryProcessServerHelper.IsInActiveWorkFlow(ctx, entry.getId().toString())) continue;
                    throw new PurReqException(PurReqException.WF_DONOT);
                }
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        long time1 = System.currentTimeMillis();
        IObjectPK[] pks = new IObjectPK[]{objPK};
        PurRequestInfo info = this.getPurRequestInfo(ctx, objPK, this.getSelector(true));
        long time11 = System.currentTimeMillis();
        logger.error((Object)("@@@@@@@@@@@\u5ba1\u6838\u603b\u8ba1\u8017\u65f611\uff1a" + (time11 - time1)));
        if (this.checkIsInWF(ctx, pks)) {
            IObjectPK logPk = LogUtil.beginLog((Context)ctx, (String)"", (BOSObjectType)info.getBOSType(), (IObjectPK)new ObjectUuidPK(objPK.toString()), (String)info.getNumber().toString(), (String)"scm_purReport_audit");
            this.passAudit(ctx, objPK, (CoreBillBaseInfo)info);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPk);
        } else {
            this._passAudit(ctx, objPK, (IObjectValue)info);
        }
        long time2 = System.currentTimeMillis();
        logger.error((Object)("@@@@@@@@@@@\u5ba1\u6838\u603b\u8ba1\u8017\u65f6\uff1a" + (time2 - time1)));
    }

    protected void _audit(Context ctx, String[] ids) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[ids.length];
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            pks[i] = new ObjectUuidPK(ids[i]);
        }
        this._audit(ctx, pks);
    }

    protected void passAuditPurReq(Context ctx, IObjectPK objPK, IObjectValue vo) throws BOSException, EASBizException {
        PurRequestInfo purRequestInfo = (PurRequestInfo)vo;
        purRequestInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        if (purRequestInfo.getId() == null) {
            throw new PurReqException(PurReqException.PURREQUEST_IS_NULL);
        }
        PurRequestEntryCollection entries = purRequestInfo.getEntries();
        if (entries != null) {
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
            }
        }
        super._update(ctx, objPK, vo);
    }

    protected void checkNumber(Context ctx, IObjectPK pk, IObjectValue vo) throws BOSException, EASBizException {
        super.checkNumberBlank(ctx, pk, (CoreBillBaseInfo)((PurRequestInfo)vo));
        super.checkNumberDup(ctx, pk, (CoreBillBaseInfo)((PurRequestInfo)vo));
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK objPK) throws BOSException, EASBizException {
        PurRequestInfo vo = (PurRequestInfo)this.getValue(ctx, objPK);
        this.checkBeforeCancellation(ctx, (IObjectValue)vo);
        this.passCancellation(ctx, objPK, (IObjectValue)vo);
        ArrayList<String> list = new ArrayList<String>();
        list.add(objPK.toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.DELETE);
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK objPK, IObjectValue reasonInfo) throws BOSException, EASBizException {
        PurRequestInfo vo = (PurRequestInfo)this.getValue(ctx, objPK);
        this.checkBeforeCancellation(ctx, (IObjectValue)vo);
        this.passCancellation(ctx, objPK, (IObjectValue)vo, reasonInfo);
        ArrayList<String> list = new ArrayList<String>();
        list.add(objPK.toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.DELETE);
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            this._cancellation(ctx, ids[i]);
        }
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK objPK, String reasonInfo) throws BOSException, EASBizException {
        PurRequestInfo vo = null;
        if (objPK == null) {
            return;
        }
        boolean isHasFlow = false;
        String tableName = "T_SM_PurRequestEntry";
        if (SCMServerUtils.isExistsBizFlowField((Context)ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)ctx, (String)tableName, (String)objPK.toString())) {
            isHasFlow = true;
            vo = (PurRequestInfo)this.getValue(ctx, objPK);
        } else {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("baseStatus"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("entries.id"));
            selector.add(new SelectorItemInfo("entries.baseStatus"));
            selector.add(new SelectorItemInfo("entries.reason"));
            vo = PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo(objPK, selector);
        }
        this.checkBeforeCancellation(ctx, (IObjectValue)vo);
        if (isHasFlow) {
            SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)vo, (BatchActionEnum)BatchActionEnum.CANCEL);
        }
        this.passCancellation(ctx, objPK, (IObjectValue)vo, reasonInfo);
        ArrayList<String> list = new ArrayList<String>();
        list.add(objPK.toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.DELETE);
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK[] ids, String reasonInfo) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            this._cancellation(ctx, ids[i], reasonInfo);
        }
    }

    private void checkBeforeCancellation(Context ctx, IObjectValue vo) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)vo;
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CANCEL_IS_CANCEL);
            }
            if (info.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.CANCEL_IS_AUDIT);
            }
            if (info.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.CANCEL_IS_CLOSED);
            }
        }
    }

    protected void passCancellation(Context ctx, IObjectPK objPK, IObjectValue vo) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)vo;
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurRequestEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
            }
        }
        super._update(ctx, objPK, vo);
    }

    protected void passCancellation(Context ctx, IObjectPK objPK, IObjectValue vo, IObjectValue reasonInfo) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)vo;
        ReasonCodeInfo reason = (ReasonCodeInfo)reasonInfo;
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurRequestEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
                entries.get(i).setReason(reason.getName());
            }
        }
        super._update(ctx, objPK, vo);
    }

    protected void passCancellation(Context ctx, IObjectPK objPK, IObjectValue vo, String reasonInfo) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)vo;
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurRequestEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
                entries.get(i).setReason(reasonInfo);
            }
        }
        super._update(ctx, objPK, vo);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        boolean isCheckBudget;
        PurRequestInfo info = (PurRequestInfo)model;
        if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue() && info != null && info.getCompanyOrgUnit() != null && !info.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == info.getPurchaseType() && this.isControlBudget(ctx, info, info.getCompanyOrgUnit().getId().toString(), 1) && !(isCheckBudget = false)) {
            isCheckBudget = true;
            if (info.get("isEditUI") != null && info.getBoolean("isEditUI")) {
                CompanyOrgUnitInfo companyOrgUnit = info.getCompanyOrgUnit();
                if (companyOrgUnit.getBaseCurrency() != null) {
                    if (companyOrgUnit.getBaseCurrency().getId() != null && companyOrgUnit.getBaseCurrency().getNumber() == null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("number"));
                        sic.add(new SelectorItemInfo("name"));
                        sic.add(new SelectorItemInfo("precision"));
                        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnit.getBaseCurrency().getId()), sic);
                        companyOrgUnit.setBaseCurrency(currency);
                        info.setCompanyOrgUnit(companyOrgUnit);
                    }
                } else {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("baseCurrency.id"));
                    sic.add(new SelectorItemInfo("baseCurrency.number"));
                    sic.add(new SelectorItemInfo("baseCurrency.name"));
                    sic.add(new SelectorItemInfo("baseCurrency.precision"));
                    CompanyOrgUnitInfo newCompanyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnit.getId()), sic);
                    CurrencyInfo currency = newCompanyOrgUnitInfo.getBaseCurrency();
                    companyOrgUnit.setBaseCurrency(currency);
                    info.setCompanyOrgUnit(companyOrgUnit);
                }
                BgCtrlCallerUtil.checkBudget(ctx, (IObjectValue)info);
            } else {
                BgCtrlCallerUtil.checkBudget(ctx, info.getId());
            }
        }
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            IObjectPK pk = super.submitWithoutBusiness(ctx, model);
            PurBgCtrlUtil.checkBudget4Submit(ctx, info);
            return pk;
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        ObjectUuidPK pk = new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
        PurBgCtrlUtil.checkBudget4Submit(ctx, info);
        return pk;
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo requestInfo;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String isEntryAudit = scmParam.getParamByBillTypeID("PURREQ002", 1, (requestInfo = (PurRequestInfo)model).getCompanyOrgUnit().getId().toString(), this.getBillTypeId());
        if (isEntryAudit != null && isEntryAudit.trim().equalsIgnoreCase("1")) {
            PurRequestEntryCollection entryCol = requestInfo.getEntries();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)pk.toString(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(PurRequestControllerBean.getPurOrderEntrySelector());
            view.setFilter(filter);
            PurRequestEntryCollection col = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryCollection(view);
            if (col != null && col.size() > 0) {
                HashMap<Integer, PurRequestEntryInfo> map = new HashMap<Integer, PurRequestEntryInfo>();
                PurRequestEntryInfo entry = new PurRequestEntryInfo();
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    entry = col.get(i);
                    map.put(col.get(i).getSeq(), entry);
                }
                PurRequestEntryInfo entryInfo = new PurRequestEntryInfo();
                int len = entryCol.size() - 1;
                int seq = 0;
                for (int j = len; j >= 0; --j) {
                    entryInfo = entryCol.get(j);
                    seq = entryInfo.getSeq();
                    if (!map.containsKey(seq)) continue;
                    requestInfo.getEntries().removeObject(j);
                    requestInfo.getEntries().add((PurRequestEntryInfo)map.get(seq));
                }
            }
        }
        requestInfo.put("WF_CENTER_AUDIT", "WF_CENTER_AUDIT");
        this._submit(ctx, (IObjectValue)requestInfo);
    }

    protected void writeUnOrderedQty(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)model;
        PurRequestEntryCollection entries = info.getEntries();
        PurRequestEntryInfo entry = null;
        int len = entries.size();
        for (int i = 0; i < len; ++i) {
            entry = entries.get(i);
            entry.setUnOrderedQty(entry.getQty());
            entry.setUnOrderedBaseQty(entry.getBaseQty());
            entry.setOrderedBaseQty(new BigDecimal("0"));
            entry.setOrderedQty(new BigDecimal("0"));
            entry.setTotalReqQty(new BigDecimal("0"));
            entry.setTotalRequQty(new BigDecimal("0"));
            entry.setUnTotalReqQty(entry.getQty());
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)model;
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)info);
        PurRequestEntryCollection entries = info.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            this.setZero(entries.get(i));
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected IObjectValue getAutoCloseInfo(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        PurRequestInfo newPurRequestInfo = null;
        if (model instanceof PurRequestInfo) {
            newPurRequestInfo = (PurRequestInfo)model;
        }
        if (newPurRequestInfo == null) {
            return model;
        }
        PurRequestEntryCollection entryCollection = newPurRequestInfo.getEntries();
        PurRequestEntryInfo entryInfo = null;
        BigDecimal unOrderQty = SysConstant.BIGZERO;
        BigDecimal requestQty = SysConstant.BIGZERO;
        BigDecimal orderQty = SysConstant.BIGZERO;
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCollection.get(i);
            requestQty = entryInfo.getQty();
            orderQty = entryInfo.getOrderedQty();
            if (entryInfo.getOrderedQty() != null) {
                orderQty = entryInfo.getOrderedQty();
            }
            unOrderQty = requestQty.subtract(orderQty);
            entryInfo.setUnOrderedQty(unOrderQty);
            this.autoCloseEntryInfo(entryInfo, newPurRequestInfo);
        }
        this.autoClose(newPurRequestInfo);
        return newPurRequestInfo;
    }

    protected PurRequestInfo autoClose(PurRequestInfo purRequestInfo) {
        if (purRequestInfo.getBaseStatus().getValue() == 4) {
            PurRequestEntryCollection entryCollection = purRequestInfo.getEntries();
            PurRequestEntryInfo entryInfo = null;
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = entryCollection.get(i);
                if (entryInfo.getBaseStatus().getValue() == 7) continue;
                return purRequestInfo;
            }
            purRequestInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        }
        return purRequestInfo;
    }

    protected PurRequestEntryInfo autoCloseEntryInfo(PurRequestEntryInfo entryInfo, PurRequestInfo purRequestInfo) {
        if (entryInfo.getBaseStatus().getValue() == 4) {
            BigDecimal requestQutity = null;
            BigDecimal orderQutity = null;
            requestQutity = entryInfo.getQty();
            if (requestQutity.compareTo(orderQutity = entryInfo.getOrderedQty()) <= 0) {
                entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            }
        }
        return entryInfo;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Boolean release = null;
        release = (Boolean)ctx.get((Object)"isPlannedOrderRelease");
        if (release != null && release.booleanValue()) {
            return new ObjectUuidPK(model.getBOSUuid("id"));
        }
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    private Map loadMaterial(Context ctx, String[] ids, SelectorItemCollection siCol) throws BOSException {
        int length = ids.length;
        HashMap<String, MaterialInfo> mapMaterial = new HashMap<String, MaterialInfo>(length * 2);
        HashSet<String> idSet = new HashSet<String>(length * 2);
        for (int i = 0; i < length; ++i) {
            if (ids[i] == null) continue;
            idSet.add(ids[i]);
        }
        if (idSet.size() == 0) {
            return mapMaterial;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        if (siCol != null) {
            viewInfo.setSelector(siCol);
        }
        MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        int size = materialCol.size();
        for (int i = 0; i < size; ++i) {
            mapMaterial.put(materialCol.get(i).getId().toString(), materialCol.get(i));
        }
        return mapMaterial;
    }

    private Map loadRowType(Context ctx, String[] ids, SelectorItemCollection siCol) throws BOSException {
        int length = ids.length;
        HashMap<String, RowTypeInfo> mapRowType = new HashMap<String, RowTypeInfo>(length * 2);
        HashSet<String> idSet = new HashSet<String>(length * 2);
        for (int i = 0; i < length; ++i) {
            if (ids[i] == null) continue;
            idSet.add(ids[i]);
        }
        if (idSet.size() == 0) {
            return mapRowType;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        if (siCol != null) {
            viewInfo.setSelector(siCol);
        }
        RowTypeCollection rowTypeCol = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeCollection(viewInfo);
        int size = rowTypeCol.size();
        for (int i = 0; i < size; ++i) {
            mapRowType.put(rowTypeCol.get(i).getId().toString(), rowTypeCol.get(i));
        }
        return mapRowType;
    }

    private Map loadMultiMeasureUnit(Context ctx, String[] ids, String[] unitIds, SelectorItemCollection siCol) throws BOSException {
        int length = ids.length;
        HashMap<String, MultiMeasureUnitInfo> mapMultiMeasureUnit = new HashMap<String, MultiMeasureUnitInfo>(length * 2);
        HashSet<String> idSet = new HashSet<String>(length * 2);
        HashSet<String> unitIdSet = new HashSet<String>(length * 2);
        for (int i = 0; i < length; ++i) {
            if (ids[i] != null) {
                idSet.add(ids[i]);
            }
            if (unitIds[i] == null) continue;
            unitIdSet.add(unitIds[i]);
        }
        if (idSet.size() == 0 && unitIdSet.size() == 0) {
            return mapMultiMeasureUnit;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", idSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit", unitIdSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        if (siCol != null) {
            viewInfo.setSelector(siCol);
        }
        MultiMeasureUnitCollection mulMeasureUnitCol = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(viewInfo);
        int size = mulMeasureUnitCol.size();
        for (int i = 0; i < size; ++i) {
            mapMultiMeasureUnit.put(mulMeasureUnitCol.get(i).getMaterial().getId().toString() + mulMeasureUnitCol.get(i).getMeasureUnit().getId().toString(), mulMeasureUnitCol.get(i));
        }
        return mapMultiMeasureUnit;
    }

    public static BigDecimal getUnitQty(Context ctx, BigDecimal fromQty, String materialID, String fromUnitID, String toUnitID, Map mapMultiMeasureUnitFrom, Map mapMultiMeasureUnitTo) throws BOSException, EASBizException {
        BigDecimal zero = new BigDecimal(0.0);
        BigDecimal one = new BigDecimal(1.0);
        if (fromQty == null || fromQty.compareTo(zero) == 0 || StringUtil.isEmptyString((String)materialID) || StringUtil.isEmptyString((String)fromUnitID) || StringUtil.isEmptyString((String)toUnitID)) {
            return zero;
        }
        MultiMeasureUnitInfo fromMmu = (MultiMeasureUnitInfo)mapMultiMeasureUnitFrom.get(materialID + fromUnitID);
        MultiMeasureUnitInfo toMmu = (MultiMeasureUnitInfo)mapMultiMeasureUnitTo.get(materialID + toUnitID);
        if (fromMmu == null || toMmu == null) {
            return zero;
        }
        BigDecimal fromRate = fromMmu.getBaseConvsRate();
        BigDecimal toRate = toMmu.getBaseConvsRate();
        if (fromRate == null) {
            fromRate = one;
        }
        if (toRate == null) {
            toRate = one;
        }
        return fromQty.multiply(fromRate).divide(toRate, toMmu.getQtyPrecision(), 4);
    }

    protected void checkBusinessRule(Context ctx, PurRequestInfo header) throws BOSException, EASBizException {
        int i;
        PurRequestEntryInfo entry = null;
        PurRequestEntryCollection entries = header.getEntries();
        SelectorItemCollection materialSic = new SelectorItemCollection();
        materialSic.add("id");
        materialSic.add("baseUnit.id");
        materialSic.add("baseUnit.name");
        materialSic.add("baseUnit.number");
        SelectorItemCollection unitSic = new SelectorItemCollection();
        unitSic.add("id");
        unitSic.add("material.id");
        unitSic.add("measureUnit.id");
        unitSic.add("baseConvsRate");
        unitSic.add("qtyPrecision");
        Map mapMaterial = new HashMap(entries.size());
        String[] materialIds = new String[entries.size()];
        Map mapRowType = new HashMap(entries.size());
        String[] rowTypeIds = new String[entries.size()];
        Map mapMultiMeasureUnitFrom = new HashMap(entries.size());
        Map mapMultiMeasureUnitTo = new HashMap(entries.size());
        String[] unitIds = new String[entries.size()];
        String[] baseUnitIds = new String[entries.size()];
        int len = entries.size();
        for (i = 0; i < len; ++i) {
            entry = entries.get(i);
            MaterialInfo material = entry.getMaterial();
            RowTypeInfo rowType = entry.getRowType();
            MeasureUnitInfo unit = entry.getUnit();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            if (material != null && material.getId() != null) {
                materialIds[i] = material.getId().toString();
            }
            if (rowType != null && rowType.getId() != null) {
                rowTypeIds[i] = rowType.getId().toString();
            }
            if (unit == null || baseUnit == null) continue;
            unitIds[i] = unit.getId().toString();
            baseUnitIds[i] = baseUnit.getId().toString();
        }
        mapMaterial = this.loadMaterial(ctx, materialIds, materialSic);
        mapRowType = this.loadRowType(ctx, rowTypeIds, null);
        mapMultiMeasureUnitFrom = this.loadMultiMeasureUnit(ctx, materialIds, unitIds, unitSic);
        mapMultiMeasureUnitTo = this.loadMultiMeasureUnit(ctx, materialIds, baseUnitIds, unitSic);
        len = entries.size();
        for (i = 0; i < len; ++i) {
            entry = entries.get(i);
            if (entry == null) continue;
            boolean isNeedSetDefault = true;
            try {
                RowTypeInfo rowtype = (RowTypeInfo)mapRowType.get(entry.getRowType().getId().toString());
                if (rowtype.isIsHasMaterialNumber()) {
                    MaterialInfo material = entry.getMaterial();
                    if (material != null && material.getId() != null) {
                        material = (MaterialInfo)mapMaterial.get(material.getId().toString());
                    }
                    if (material != null && material.getBaseUnit() != null && material.getBaseUnit() instanceof MeasureUnitInfo) {
                        entry.setBaseUnit(material.getBaseUnit());
                        BigDecimal qty = entry.getQty();
                        MeasureUnitInfo unit = entry.getUnit();
                        MeasureUnitInfo baseUnit = entry.getBaseUnit();
                        String unitID = null;
                        String baseUnitID = null;
                        BigDecimal baseQty = null;
                        if (qty != null && unit != null && baseUnit != null) {
                            unitID = unit.getId().toString();
                            baseUnitID = baseUnit.getId().toString();
                            baseQty = PurRequestControllerBean.getUnitQty(ctx, qty, material.getId().toString(), unitID, baseUnitID, mapMultiMeasureUnitFrom, mapMultiMeasureUnitTo);
                            entry.setBaseQty(baseQty);
                        }
                    }
                    if (material == null && entry.getMaterialGroup1() == null) {
                        entries.remove(entry);
                        isNeedSetDefault = false;
                    }
                } else if (entry.getMaterialName() == null) {
                    entries.remove(entry);
                    isNeedSetDefault = false;
                } else {
                    this.setDefaultValue(entry);
                }
            }
            catch (NullPointerException e) {
                entries.remove(entry);
                logger.error((Object)e);
            }
            if (!isNeedSetDefault) continue;
            this.setZero(entry);
        }
    }

    private void setDefaultValue(PurRequestEntryInfo entry) {
        entry.setBaseUnit(entry.getUnit());
        entry.setBaseQty(entry.getQty());
    }

    private void setZero(PurRequestEntryInfo entry) {
        this.setBigDecimalZeros(entry, zerofields);
    }

    private void setBigDecimalZeros(PurRequestEntryInfo entry, String[] fields) {
        BigDecimal zero = new BigDecimal("0.00");
        Object[] zeros = new BigDecimal[]{zero};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = PurRequestEntryInfo.class.getMethod(getMethodName, new Class[0]);
                Method setMethod = PurRequestEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, new Object[0]) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)this.getValue(ctx, pk);
        info.setBaseStatus(BillBaseStatusEnum.CLOSED);
        super._update(ctx, pk, (IObjectValue)info);
        ArrayList<String> list = new ArrayList<String>();
        list.add(pk.toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo info = null;
        return info;
    }

    @Override
    protected void _cancellation(Context ctx, IObjectPK[] ids, IObjectValue reasonCode) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            this._cancellation(ctx, ids[i], reasonCode);
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        CompanyOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurRequestInfo)model).getCompanyOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Statement batchStatement;
        Connection con;
        block13: {
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            PurRequestInfo purInfo = null;
            if (pks.length == 0) {
                return;
            }
            HashSet<String> idsSet = new HashSet<String>();
            for (int i = 0; i < pks.length; ++i) {
                idsSet.add(pks[i].toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("isMergeBill"));
            sic.add(new SelectorItemInfo("purchaseType"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.name"));
            sic.add(new SelectorItemInfo("companyOrgUnit.number"));
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("billType.number"));
            sic.add(new SelectorItemInfo("billType.name"));
            view.setSelector(sic);
            PurRequestCollection coll = iPurRequest.getPurRequestCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    purInfo = coll.get(i);
                    this.isSamePerson4Audit(ctx, purInfo);
                }
            }
            con = null;
            batchStatement = null;
            try {
                con = this.getConnection(ctx);
                batchStatement = con.createStatement();
                StringBuffer params = new StringBuffer();
                int c = pks.length;
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        params.append(",");
                    }
                    params.append("'");
                    params.append(pks[i].toString());
                    params.append("'");
                }
                String updateSql = "update T_SM_PurRequest set FBaseStatus = 4,FAuditorId='" + ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() + "',FAuditTime = getDate() where fid in(" + params.toString() + ")";
                String updateEntrySql = "update T_SM_PurRequestEntry set FBaseStatus = 4 where FParentID in(" + params.toString() + ")";
                batchStatement.executeUpdate(updateSql);
                batchStatement.addBatch(updateEntrySql);
                batchStatement.executeBatch();
                this._writePlanOrder(ctx, pks, BizActionEnum.AUDIT);
                if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
                    if (coll != null && coll.size() > 0) {
                        int size = coll.size();
                        for (int i = 0; i < size; ++i) {
                            purInfo = coll.get(i);
                            if (purInfo == null || purInfo.getCompanyOrgUnit() == null || purInfo.isIsMergeBill() || PurchaseTypeEnum.PURCHASE != purInfo.getPurchaseType() || !this.isControlBudget(ctx, purInfo, purInfo.getCompanyOrgUnit().getId().toString(), 1)) continue;
                            BgCtrlCallerUtil.requestBudget(ctx, purInfo.getId());
                        }
                    }
                    break block13;
                }
                PurBgCtrlUtil.requestBudgetForPurReqest(ctx, idsSet, null, false);
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(batchStatement, (Connection)con);
                    SQLUtils.cleanup((Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    private void _writePlanOrder(Context ctx, IObjectPK[] pks, BizActionEnum enumaction) throws BOSException, EASBizException {
        try {
            String params = this.convertToString(pks);
            StringBuffer sql = new StringBuffer();
            sql.append("select FSourceBillId, FSourceBillEntryID from t_sm_purRequestentry where fparentid in (").append(params).append(") and FSourceBillTypeId = '").append("7UcZ6QEUEADgAAYawKg9C0Y+1VI=").append("'").append(" group by FSourceBillId, FSourceBillEntryID");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> srcEntryIDList = new ArrayList<String>();
            while (rs.next()) {
                list.add(rs.getString(1));
                srcEntryIDList.add(rs.getString(2));
            }
            String[] curIdArray = new String[pks.length];
            for (int i = 0; i < pks.length; ++i) {
                curIdArray[i] = pks[i].toString();
            }
            if (list.size() > 0) {
                String[] srcIdArr = new String[list.size()];
                list.toArray(srcIdArr);
                IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)new PurRequestInfo().getBOSType(), (String[])srcIdArr);
                for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
                    handlers[j].handle(ctx, enumaction, curIdArray, (String[][])null);
                }
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        Statement batchStatement;
        Statement statement;
        Connection con;
        block15: {
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            PurRequestInfo purInfo = null;
            if (pks.length == 0) {
                return;
            }
            HashSet<String> idsSet = new HashSet<String>();
            for (int i = 0; i < pks.length; ++i) {
                idsSet.add(pks[i].toString());
                purInfo = this.getPurRequestInfo(ctx, pks[i]);
                SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)purInfo);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("creator.id"));
            sic.add(new SelectorItemInfo("auditor.id"));
            sic.add(new SelectorItemInfo("isMergeBill"));
            sic.add(new SelectorItemInfo("purchaseType"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.name"));
            sic.add(new SelectorItemInfo("companyOrgUnit.number"));
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("billType.number"));
            sic.add(new SelectorItemInfo("billType.name"));
            view.setSelector(sic);
            PurRequestCollection coll = iPurRequest.getPurRequestCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    purInfo = coll.get(i);
                    this.isSamePerson4UnAudit(ctx, purInfo);
                }
            }
            con = null;
            statement = null;
            batchStatement = null;
            try {
                int size;
                con = this.getConnection(ctx);
                statement = con.createStatement();
                batchStatement = con.createStatement();
                StringBuffer params = new StringBuffer();
                int c = pks.length;
                for (int i = 0; i < c; ++i) {
                    if (i > 0) {
                        params.append(",");
                    }
                    params.append("'");
                    params.append(pks[i].toString());
                    params.append("'");
                }
                String updateSql = "update T_SM_PurRequest set FBaseStatus = 1,FAuditorId=null,FAuditTime = null where fid in(" + params.toString() + ")";
                String updateEntrySql = "update T_SM_PurRequestEntry set FBaseStatus = 1 where FParentID in(" + params.toString() + ")";
                batchStatement.addBatch(updateSql);
                batchStatement.addBatch(updateEntrySql);
                batchStatement.executeBatch();
                this._writePlanOrder(ctx, pks, BizActionEnum.UNAUDIT);
                if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
                    if (coll == null || coll.size() <= 0) break block15;
                    size = coll.size();
                } else {
                    PurBgCtrlUtil.requestBudgetForPurReqest(ctx, idsSet, null, false);
                    break block15;
                }
                for (int i = 0; i < size; ++i) {
                    purInfo = coll.get(i);
                    if (purInfo == null || purInfo.getCompanyOrgUnit() == null || purInfo.isIsMergeBill() || PurchaseTypeEnum.PURCHASE != purInfo.getPurchaseType() || !this.isControlBudget(ctx, purInfo, purInfo.getCompanyOrgUnit().getId().toString(), 1)) continue;
                    boolean checkPass = BgCtrlCallerUtil.checkBizUnitInfo(ctx, purInfo.getId(), null);
                    if (!checkPass) {
                        SQLUtils.cleanup((Statement)statement, (Connection)con);
                        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
                        SQLUtils.cleanup((Connection)con);
                        return;
                    }
                    BgCtrlCallerUtil.returnBudget(ctx, purInfo.getId());
                }
            }
            catch (SQLException er) {
                try {
                    throw new BOSException("sql Execute Error :", (Throwable)er);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(statement, (Connection)con);
                    SQLUtils.cleanup(batchStatement, (Connection)con);
                    SQLUtils.cleanup((Connection)con);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return;
    }

    private void writeByPurRequestTotal(Context ctx, IObjectPK[] pks, boolean isDelte) throws BOSException, EASBizException {
        Connection con = null;
        Statement statementDetail = null;
        String mergeBillSql = null;
        String recursiveMergeBillSql = null;
        IRowSet resultSet = null;
        ResultSet mergeResultSet = null;
        StringBuffer mergeBillIds = null;
        String updateEntryBillSql = null;
        String updateBillSql = null;
        String mergeBillNumber = null;
        String SourMergeBillNumber = null;
        try {
            con = this.getConnection(ctx);
            statementDetail = con.createStatement();
            StringBuffer params = new StringBuffer();
            int c = pks.length;
            for (int i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pks[i].toString());
                params.append("'");
            }
            mergeBillSql = " select distinct pur.FNumber number ,purEntry.FMergeBillNumber mergeBillNumber  from T_SM_PurRequest pur  Left Join T_SM_PurRequestEntry purEntry on pur.Fid=purEntry.FParentID where pur.fid in(" + params.toString() + ")";
            resultSet = DbUtil.executeQuery((Context)ctx, (String)mergeBillSql);
            mergeBillIds = new StringBuffer();
            while (resultSet.next()) {
                mergeBillNumber = resultSet.getString("number");
                SourMergeBillNumber = resultSet.getString("mergeBillNumber");
                if (!isDelte && SourMergeBillNumber != null && !SourMergeBillNumber.equals("")) {
                    throw new PurReqException(PurReqException.UNAUDIT_MERAGE, new String[]{SourMergeBillNumber.toString()});
                }
                recursiveMergeBillSql = "select distinct fparentid id from T_SM_PurRequestEntry where FMergeBillNumber ='" + mergeBillNumber + "'";
                mergeResultSet = statementDetail.executeQuery(recursiveMergeBillSql);
                while (mergeResultSet.next()) {
                    if (mergeBillIds.length() > 0) {
                        mergeBillIds.append(",");
                    }
                    mergeBillIds.append("'");
                    mergeBillIds.append(mergeResultSet.getString("id"));
                    mergeBillIds.append("'");
                }
            }
            if (mergeBillIds.length() > 0) {
                updateEntryBillSql = null;
                updateEntryBillSql = isDelte ? "update T_SM_PurRequestEntry set FMergeBillNumber=null,FMergeBillSeq=null,fbasestatus = 4 where fparentid in(" + mergeBillIds.toString() + ") and FMergeBillNumber ='" + mergeBillNumber + "'" : "update T_SM_PurRequestEntry set fbasestatus = 4 where fparentid in(" + mergeBillIds.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateEntryBillSql);
                updateBillSql = "update T_SM_PurRequest set fbasestatus = 4 where fid in(" + mergeBillIds.toString() + ")";
                DbUtil.execute((Context)ctx, (String)updateBillSql);
            }
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statementDetail, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statementDetail, (Connection)con);
        SQLUtils.cleanup((Connection)con);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SCMServerUtils.lockBill((Context)ctx, (IObjectPK)pk, (String)"T_SM_PurRequest");
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurRequestInfo info = this.getPurRequestInfo(ctx, pk, this.getSelector(true));
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _handleWriteBack(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length <= 0) {
            return;
        }
        StringBuffer sqlParams = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (sqlParams.length() > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("'");
            sqlParams.append(pks[i].toString());
            sqlParams.append("'");
        }
        this.handelWriteBackByPurContract(ctx, sqlParams.toString());
        this.handleAutoClose(ctx, sqlParams.toString());
    }

    @Override
    protected void _handleWriteBack_UnAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks.length <= 0) {
            return;
        }
        StringBuffer sqlParams = new StringBuffer();
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            if (sqlParams.length() > 0) {
                sqlParams.append(",");
            }
            sqlParams.append("'");
            sqlParams.append(pks[i].toString());
            sqlParams.append("'");
        }
        this.handelWriteBackByPurContract(ctx, sqlParams.toString());
        this.handleAutoClose_UnAudit(ctx, sqlParams.toString());
    }

    private void handelWriteBackByPurContract(Context ctx, String param) throws BOSException, EASBizException {
        Connection con = null;
        Statement srcRateStatement = null;
        Statement statement = null;
        Statement destRateStatement = null;
        PreparedStatement updateStatement = null;
        ResultSet srcRateSet = null;
        ResultSet destRateSet = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer valueBuffer = new StringBuffer();
            ArrayList<String> sourceEntryIdList = new ArrayList<String>();
            int count = 0;
            valueBuffer.append(" select entry.FSourceBillEntryId,entry.FBaseQty").append(" from T_SM_PurContractEntry entry").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and entry.FParentID in(").append(param).append(")").append(" order by entry.FSeq");
            ResultSet result = statement.executeQuery(valueBuffer.toString());
            if (result.next() && result.getString(1) != null) {
                srcRateStatement = con.createStatement();
                destRateStatement = con.createStatement();
                StringBuffer srcBuffer = new StringBuffer();
                StringBuffer destBuffer = new StringBuffer();
                sourceEntryIdList.add(count++, result.getString(1));
                srcBuffer.append("select unit.FBaseConvsRate,unit.fqtyPrecision from T_SM_PurContractEntry entry").append(" left join T_BD_MultiMeasureUnit unit on ").append("entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID where ").append("entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and FParentID in(").append(param).append(")").append(" order by entry.FSeq");
                destBuffer.append("select unit.FBaseConvsRate,unit.fqtyPrecision from T_BD_MultiMeasureUnit unit").append(" right join (select entry.FMaterialId,requestEntry.FUnitId destUnit,entry.fseq").append(" from T_SM_PurContractEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.FSourceBillEntryId").append(" where entry.FParentId in(").append(param).append(")").append(")tempContract on tempContract.FMaterialID = unit.FMaterialID").append(" and tempContract.destUnit = unit.FMeasureUnitID order by tempContract.fseq");
                String updateReqSql = "update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty+?,FOrderedBaseQty = FOrderedBaseQty+?,  FUnOrderedQty = FQty - FOrderedQty-?,FUnOrderedBaseQty = FBaseQty-FOrderedBaseQty-? where Fid = ?";
                updateStatement = con.prepareStatement(updateReqSql);
                srcRateSet = srcRateStatement.executeQuery(srcBuffer.toString());
                destRateSet = destRateStatement.executeQuery(destBuffer.toString());
                BigDecimal destQty = null;
                BigDecimal baseQty = null;
                BigDecimal srcRate = null;
                BigDecimal destRate = null;
                Object destBaseQty = null;
                while (srcRateSet.next()) {
                    destRateSet.next();
                    baseQty = BigDecimal.ZERO;
                    if (result.getBigDecimal(2) != null) {
                        baseQty = result.getBigDecimal(2);
                    }
                    srcRate = srcRateSet.getBigDecimal(1);
                    destRate = destRateSet.getBigDecimal(1);
                    int qtyPrecision = destRateSet.getInt(2);
                    if (destRate == null) {
                        destRate = new BigDecimal("1.00");
                    }
                    destQty = baseQty.divide(destRate, qtyPrecision, RoundingMode.HALF_UP);
                    updateStatement.setBigDecimal(1, destQty);
                    updateStatement.setBigDecimal(2, baseQty);
                    updateStatement.setBigDecimal(3, destQty);
                    updateStatement.setBigDecimal(4, baseQty);
                    updateStatement.setString(5, result.getString(1));
                    sourceEntryIdList.add(count++, result.getString(1));
                    result.next();
                    updateStatement.addBatch();
                }
                updateStatement.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(srcRateSet, srcRateStatement);
                SQLUtils.cleanup(destRateSet, destRateStatement);
                SQLUtils.cleanup(updateStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup(srcRateSet, srcRateStatement);
        SQLUtils.cleanup(destRateSet, destRateStatement);
        SQLUtils.cleanup(updateStatement);
    }

    private BigDecimal exchangeQtyByUnit(BigDecimal srcRate, BigDecimal destRate, BigDecimal qty) {
        if (srcRate == null) {
            srcRate = new BigDecimal("1.00");
        }
        if (destRate == null) {
            destRate = new BigDecimal("1.00");
        }
        if (destRate.equals(srcRate)) {
            return qty;
        }
        BigDecimal baseQty = qty.multiply(srcRate);
        return baseQty.divide(destRate, baseQty.scale(), 0);
    }

    private void handleAutoClose(Context ctx, String param) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        try {
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
            updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =7").append(" where FUnOrderedQty <=0 and fid in(select entry.FSourceBillEntryId").append(" from T_SM_PurContractEntry entry").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and entry.FParentID in(").append(param).append(")").append(")");
            statement.execute(updateCloseReqEntryBuffer.toString());
            StringBuffer updateCloseReqBuffer = new StringBuffer();
            updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 7").append(" where fid in (select temp.fparentid from (").append("select fparentid,count(fid) entrycount,0 billcount from T_SM_purRequestEntry where  FBaseStatus =7 and fparentid in(").append(" select entry.FSourceBillId  from T_SM_PurContractEntry entry where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552' and ").append(" entry.FParentID in(").append(param).append("))").append(" group by fparentid ").append(" union all  ").append(" select fparentid,0 entrycount,count(fid) billcount from T_SM_purRequestEntry ").append(" where fparentid in(select entry.FSourceBillId  from T_SM_PurContractEntry entry ").append(" where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552' and entry.FParentID in(").append(param).append("))").append(" group by fparentid) temp group by temp.fparentid ").append("having sum(entrycount) = sum(billcount)) ");
            statement.execute(updateCloseReqBuffer.toString());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
    }

    private void handleAutoClose_UnAudit(Context ctx, String param) throws BOSException, EASBizException {
        Statement statement;
        Connection con;
        block5: {
            con = null;
            statement = null;
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer updateCloseReqEntryBuffer = new StringBuffer();
            updateCloseReqEntryBuffer.append(" update ").append(" T_SM_PurRequestEntry set FBaseStatus =4").append(" where FIsManualClose = 0 and FUnOrderedQty >0 and Fid in(").append(" select entry.FSourceBillEntryId  from T_SM_PurContractEntry entry where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552' and ").append(" entry.FParentID in(").append(param).append("))");
            int count = statement.executeUpdate(updateCloseReqEntryBuffer.toString());
            if (count > 0) break block5;
            SQLUtils.cleanup((Statement)statement);
            SQLUtils.cleanup((Connection)con);
            return;
        }
        try {
            StringBuffer updateCloseReqBuffer = new StringBuffer();
            updateCloseReqBuffer.append(" update ").append(" T_SM_PurRequest set FBaseStatus = 4").append(" where fid in(").append(" select entry.FSourceBillId  from T_SM_PurContractEntry entry where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552' and ").append(" entry.FParentID in(").append(param).append("))").append(" and fid not in(").append(" select FParentid from T_SM_PurRequestEntry where fbasestatus <> 4 and fbasestatus <> 7 and fparentid in (").append(" select entry.FSourceBillId  from T_SM_PurContractEntry entry where entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552' and ").append(" entry.FParentID in(").append(param).append(")))");
            statement.execute(updateCloseReqBuffer.toString());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
    }

    public String getAuditParam(Context ctx, SCMBillBaseInfo model, BatchActionEnum action) throws EASBizException, BOSException {
        PurRequestInfo info = (PurRequestInfo)model;
        if (info == null) {
            return null;
        }
        boolean isEqual = false;
        if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
            isEqual = info.getPurchaseType() != null && info.getPurchaseType() == PurchaseTypeEnum.PURCHASE ? this.isPurParamEnable(ctx, action == BatchActionEnum.AUDIT ? "PRAuditorNECreator" : "PRAuditorEqualUnAuditor", info, info.getCompanyOrgUnit().getId().toString(), 1) : this.isPurParamEnable(ctx, action == BatchActionEnum.AUDIT ? "WRAuditorNECreator" : "WRAuditorEqualUnAuditor", info, info.getCompanyOrgUnit().getId().toString(), 1);
        }
        return String.valueOf(isEqual);
    }

    protected boolean isPurParamEnable(Context ctx, String paramNumber, PurRequestInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isNotEqual = false;
        if (info != null && info.getPurchaseType() != null) {
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strNotEqual = "";
            if (info.getPurchaseType() == PurchaseTypeEnum.PURCHASE) {
                if (info.getBillType() != null) {
                    String billTypeId = info.getBillType().getId().toString();
                    strNotEqual = scmParam.getParamByBillTypeID(paramNumber, orgType, orgUnitID, billTypeId);
                }
            } else {
                strNotEqual = scmParam.getParamByBillTypeID(paramNumber, orgType, orgUnitID, "BUztSVXaSxu9edfekgCmrEY+1VI=");
            }
            if (strNotEqual != null && strNotEqual.trim().length() != 0 && strNotEqual.trim().equalsIgnoreCase("1")) {
                isNotEqual = true;
            }
        }
        return isNotEqual;
    }

    @Override
    protected void _handleWriteBack(Context ctx, IObjectValue newObjectValue, IObjectValue oldObjectValue) throws BOSException, EASBizException {
        if (newObjectValue instanceof PurContractInfo && oldObjectValue instanceof PurContractInfo) {
            this.handleWriteBackByContractAlert(ctx, (PurContractInfo)newObjectValue, (PurContractInfo)oldObjectValue);
        }
    }

    private void handleWriteBackByContractAlert(Context ctx, PurContractInfo newPurContractInfo, PurContractInfo oldPurContractInfo) throws BOSException, EASBizException {
        if (newPurContractInfo == null && oldPurContractInfo == null) {
            return;
        }
        Connection con = null;
        PreparedStatement updateStatement = null;
        IRowSet srcRateSet = null;
        IRowSet destRateSet = null;
        try {
            con = this.getConnection(ctx);
            StringBuffer sqlstr = new StringBuffer();
            sqlstr.append(" update T_SM_PurRequestEntry set FOrderedQty = FOrderedQty+?-?,FUnOrderedQty=FQty-FOrderedQty-?+?,").append(" FOrderedBaseQty = FOrderedBaseQty+?-?,FUnOrderedBaseQty= FBaseQty-FOrderedBaseQty-?+? ").append(" where  fid = ?");
            updateStatement = con.prepareStatement(sqlstr.toString());
            StringBuffer ides = new StringBuffer();
            StringBuffer srcBuffer = new StringBuffer();
            StringBuffer destBuffer = new StringBuffer();
            srcBuffer.append("select unit.FBaseConvsRate,entry.FMaterialID from T_BD_MultiMeasureUnit unit").append(" inner join T_SM_PurContractEntry entry").append(" on entry.FSourceBillTypeId = '510b6503-0105-1000-e000-0107c0a812fd463ED552'").append(" and FParentID in('").append(newPurContractInfo.getId().toString()).append("')").append(" and entry.FMaterialID = unit.FMaterialID").append(" and entry.FUnitId = unit.FMeasureUnitID order by entry.FMaterialID");
            destBuffer.append("select unit.FBaseConvsRate,tempContract.FMaterialId from T_BD_MultiMeasureUnit unit").append(" inner join (select entry.FMaterialId,requestEntry.FUnitId destUnit").append(" from T_SM_PurContractEntry entry").append(" inner join T_SM_PurRequestEntry requestEntry on requestEntry.fid = entry.FSourceBillEntryId").append(" where entry.FParentId in('").append(newPurContractInfo.getId().toString()).append("')").append(")tempContract on tempContract.FMaterialID = unit.FMaterialID").append(" and tempContract.destUnit = unit.FMeasureUnitID order by tempContract.FMaterialId");
            srcRateSet = DbUtil.executeQuery((Context)ctx, (String)srcBuffer.toString());
            destRateSet = DbUtil.executeQuery((Context)ctx, (String)destBuffer.toString());
            HashMap<String, BigDecimal> srcRate = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> destRate = new HashMap<String, BigDecimal>();
            while (srcRateSet.next()) {
                destRateSet.next();
                srcRate.put(srcRateSet.getString(2), srcRateSet.getBigDecimal(1));
                destRate.put(destRateSet.getString(2), destRateSet.getBigDecimal(1));
            }
            BigDecimal srcRatebd = null;
            BigDecimal destRatebd = null;
            int c = oldPurContractInfo.getEntries().size();
            for (int i = 0; i < c; ++i) {
                PurContractEntryInfo oldpurContractEntryInfo = oldPurContractInfo.getEntries().get(i);
                PurContractEntryInfo newpurContractEntryInfo = null;
                if (null == oldpurContractEntryInfo.getSourceBillEntryId()) continue;
                for (int j = 0; j < newPurContractInfo.getEntries().size(); ++j) {
                    PurContractEntryInfo thisNewEntryInfo = newPurContractInfo.getEntries().get(j);
                    if (null == thisNewEntryInfo.getSourceBillEntryId() || oldpurContractEntryInfo.getSourceBillEntryId() == null || thisNewEntryInfo.getSourceBillEntryId() == null || !oldpurContractEntryInfo.getSourceBillEntryId().toString().equals(thisNewEntryInfo.getSourceBillEntryId().toString())) continue;
                    newpurContractEntryInfo = thisNewEntryInfo;
                    break;
                }
                srcRatebd = null;
                destRatebd = null;
                if (newpurContractEntryInfo != null && newpurContractEntryInfo.getMaterial() != null) {
                    srcRatebd = (BigDecimal)srcRate.get(newpurContractEntryInfo.getMaterial().getId().toString());
                    destRatebd = (BigDecimal)destRate.get(newpurContractEntryInfo.getMaterial().getId().toString());
                }
                BigDecimal destnewQty = BigDecimal.ZERO;
                BigDecimal destnewBaseQty = BigDecimal.ZERO;
                if (newpurContractEntryInfo != null) {
                    destnewQty = this.exchangeQtyByUnit(srcRatebd, destRatebd, newpurContractEntryInfo.getQty());
                }
                if (newpurContractEntryInfo != null) {
                    destnewBaseQty = this.exchangeQtyByUnit(srcRatebd, destRatebd, newpurContractEntryInfo.getBaseQty());
                }
                BigDecimal destoldQty = this.exchangeQtyByUnit(srcRatebd, destRatebd, oldpurContractEntryInfo.getQty());
                BigDecimal destoldBaseQty = this.exchangeQtyByUnit(srcRatebd, destRatebd, oldpurContractEntryInfo.getBaseQty());
                if (oldpurContractEntryInfo.getSourceBillType() == null || !oldpurContractEntryInfo.getSourceBillType().getId().toString().equals("510b6503-0105-1000-e000-0107c0a812fd463ED552")) continue;
                updateStatement.setBigDecimal(1, destnewQty);
                updateStatement.setBigDecimal(2, destoldQty);
                updateStatement.setBigDecimal(3, destnewQty);
                updateStatement.setBigDecimal(4, destoldQty);
                updateStatement.setBigDecimal(5, destnewBaseQty);
                updateStatement.setBigDecimal(6, destoldBaseQty);
                updateStatement.setBigDecimal(7, destnewBaseQty);
                updateStatement.setBigDecimal(8, destoldBaseQty);
                updateStatement.setString(9, oldpurContractEntryInfo.getSourceBillEntryId().toString());
                if (ides.length() > 0) {
                    ides.append(",");
                }
                ides.append("'");
                ides.append(oldpurContractEntryInfo.getSourceBillEntryId().toString());
                ides.append("'");
                updateStatement.addBatch();
            }
            updateStatement.executeBatch();
            StringBuffer updatereqe = new StringBuffer();
            updatereqe.append(" update T_SM_PurRequestEntry set FBaseStatus = CASE WHEN FUnOrderedQty<=0 THEN  ").append(7).append(" ELSE ").append(4).append("END  where fid in(").append(ides.toString()).append(")");
            DbUtil.execute((Context)ctx, (String)updatereqe.toString());
            StringBuffer updatereq = new StringBuffer();
            updatereq.append("update T_SM_PurRequest set FBaseStatus = ").append(4).append(" where fid in(select fparentid from T_SM_PurRequestEntry where fid in(").append(ides.toString()).append(") and FBaseStatus =").append(4).append(")");
            DbUtil.execute((Context)ctx, (String)updatereq.toString());
            updatereq.delete(0, updatereq.length());
            updatereq.append("update T_SM_PurRequest set FBaseStatus = ").append(7).append(" where not exists (").append(" select ALLPURE.fparentid from T_SM_PurRequest PUR ").append("INNER JOIN T_SM_PurRequestEntry  PURE ON PUR.FID = PURE.FPARENTID ").append("INNER JOIN T_SM_PurRequestEntry  ALLPURE ON PUR.FID = ALLPURE.FPARENTID ").append("WHERE PUR.FID IN (select fparentid from T_SM_PurRequestEntry where fid in(").append(ides.toString()).append(")) and ALLPURE.FBaseStatus =").append(4).append(")").append(" and fid in (select fparentid from T_SM_PurRequestEntry where fid in(").append(ides.toString()).append("))");
            DbUtil.execute((Context)ctx, (String)updatereq.toString());
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(srcRateSet, updateStatement, (Connection)con);
                SQLUtils.cleanup(destRateSet);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)srcRateSet, (Statement)updateStatement, (Connection)con);
        SQLUtils.cleanup((ResultSet)destRateSet);
    }

    @Override
    protected String _handleGatherBill(Context ctx, IObjectPK[] pkBillEntrys, IObjectPK[] pkBills) throws BOSException, EASBizException {
        String string;
        String companyOrgUnitID = "";
        String purOrgUnitID = "";
        String storageOrgUnitID = "";
        String Purpose = "";
        String demandTypeId = "";
        String projectId = "";
        String trackNoId = "";
        java.sql.Date requirementDate = null;
        Date proposeDeliveryDate = null;
        Date proposePurchaseDate = null;
        StringBuffer remark = new StringBuffer();
        PurRequestInfo requestInfo = new PurRequestInfo();
        String bizTypeID = "d8e80652-0106-1000-e000-04c5c0a812202407435C";
        PurchaseTypeEnum purchaseType = PurchaseTypeEnum.PURCHASE;
        int seq = 0;
        boolean hasbotp = BOTMappingFactory.getLocalInstance((Context)ctx).exists(" where id ='XpnhyG7gQbeQV6u0QD2BAwRRIsQ='");
        logger.error((Object)("$$$$$$$2805 " + hasbotp));
        if (!hasbotp) {
            throw new PurReqException(PurReqException.NO_BOTP, new String[]{"PUR030"});
        }
        StringBuffer checkSql = new StringBuffer();
        StringBuffer gatherBillSql = new StringBuffer();
        StringBuffer gatherFieldSql = new StringBuffer();
        Connection con = null;
        Statement statement = null;
        Statement statementTemp = null;
        ResultSet gatherFieldSet = null;
        try {
            int i;
            con = this.getConnection(ctx);
            statement = con.createStatement();
            StringBuffer params = new StringBuffer();
            StringBuffer parentParams = new StringBuffer();
            int c = pkBillEntrys.length;
            for (i = 0; i < c; ++i) {
                if (i > 0) {
                    params.append(",");
                }
                params.append("'");
                params.append(pkBillEntrys[i].toString());
                params.append("'");
            }
            logger.error((Object)("$$$$$$$2837    " + pkBills.length));
            c = pkBills.length;
            for (i = 0; i < c; ++i) {
                if (i > 0) {
                    parentParams.append(",");
                }
                parentParams.append("'");
                parentParams.append(pkBills[i].toString());
                parentParams.append("'");
                logger.error((Object)("$$$$$$$2845" + pkBills[i].toString()));
                if (!PurRequestControllerBean.hasDestBillExceptBill(ctx, pkBills[i].toString(), requestInfo.getBOSType())) continue;
                throw new PurReqException(PurReqException.ENTRYALREADYGATHER);
            }
            checkSql.append("");
            checkSql = checkSql.append("select FBizTypeID ");
            checkSql = checkSql.append("from T_SM_PurRequest ");
            checkSql = checkSql.append("where Fid  in (" + parentParams.toString() + ") ");
            ResultSet bizTypeSet = statement.executeQuery(checkSql.toString());
            HashSet<String> bizTypeIDs = new HashSet<String>();
            while (bizTypeSet.next()) {
                bizTypeID = bizTypeSet.getString("FBizTypeID");
                bizTypeIDs.add(bizTypeID);
            }
            if (bizTypeIDs.size() > 1) {
                throw new PurReqException(PurReqException.BIZTYPEDIFFER);
            }
            checkSql.setLength(0);
            if (bizTypeID.equals("1x7KMBq4mUmpj58T4jNPqiQHQ1w=")) {
                purchaseType = PurchaseTypeEnum.SUBCONTRACT;
            }
            checkSql.append("");
            checkSql = checkSql.append("select purReq.FDemandTypeId, purReq.FID,purReq.FCompanyOrgUnitID,");
            checkSql = checkSql.append("purReqEntry.FID,purReqEntry.FPurchaseOrgUnitID,purReqEntry.FReceivedOrgUnitID,");
            checkSql = checkSql.append("purReqEntry.FPROJECTID,purReqEntry.FTRACKNOID,");
            checkSql = checkSql.append("purReqEntry.FPurpose,purReqEntry.FBaseQty,purReqEntry.FBaseUnitID,purReq.FSourceBillTypeID ");
            checkSql = checkSql.append("from T_SM_PurRequestEntry purReqEntry ");
            checkSql = checkSql.append("inner join T_SM_PurRequest purReq on purReqEntry.FParentID=purReq.FID ");
            checkSql = checkSql.append("where purReqEntry.Fid in(" + params.toString() + ") Order by purReqEntry.FParentID");
            ResultSet checkSet = statement.executeQuery(checkSql.toString());
            if (checkSet.next()) {
                demandTypeId = checkSet.getString("FDemandTypeId");
                companyOrgUnitID = checkSet.getString("FCompanyOrgUnitID");
                purOrgUnitID = checkSet.getString("FPurchaseOrgUnitID");
                storageOrgUnitID = checkSet.getString("FReceivedOrgUnitID") == null ? "" : checkSet.getString("FReceivedOrgUnitID");
                Purpose = checkSet.getString("FPurpose") == null ? "" : checkSet.getString("FPurpose");
                projectId = checkSet.getString("FPROJECTID") == null ? "" : checkSet.getString("FPROJECTID");
                trackNoId = checkSet.getString("FTRACKNOID") == null ? "" : checkSet.getString("FTRACKNOID");
            }
            boolean gatherFlag = false;
            while (checkSet.next()) {
                if (companyOrgUnitID.equals(checkSet.getString("FCompanyOrgUnitID")) && purOrgUnitID.equals(checkSet.getString("FPurchaseOrgUnitID")) && storageOrgUnitID.equals(checkSet.getString("FReceivedOrgUnitID") == null ? "" : checkSet.getString("FReceivedOrgUnitID")) && Purpose.equals(checkSet.getString("FPurpose") == null ? "" : checkSet.getString("FPurpose")) && demandTypeId.equals(checkSet.getString("FDemandTypeId")) && projectId.equals(checkSet.getString("FPROJECTID") == null ? "" : checkSet.getString("FPROJECTID")) && trackNoId.equals(checkSet.getString("FTRACKNOID") == null ? "" : checkSet.getString("FTRACKNOID"))) continue;
                gatherFlag = true;
            }
            if (gatherFlag) {
                throw new PurReqException(PurReqException.PURREQUESTDIFFERENCEFORGATHER);
            }
            checkSql.setLength(0);
            checkSql.append("select FID from T_SM_PurRequestEntry where FID in (").append(params.toString()).append(") ");
            checkSql.append("and FBaseStatus = 7 and (FMergeBillSeq is not null or FMergeBillNumber is not null)");
            checkSet = statement.executeQuery(checkSql.toString());
            if (checkSet.next()) {
                throw new PurReqException(PurReqException.ENTRYALREADYGATHER);
            }
            IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
            BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0107c0a812fd463ED552"));
            requestInfo.setBillType(billTypeInfo);
            CompanyOrgUnitInfo companyInfo = null;
            companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitID));
            DemandTypeInfo demandTypeInfo = new DemandTypeInfo();
            demandTypeInfo.setId(BOSUuid.read((String)demandTypeId));
            requestInfo.setDemandType(demandTypeInfo);
            requestInfo.setCompanyOrgUnit(companyInfo);
            requestInfo.setCU(companyInfo.getCU());
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            requestInfo.setCreator(userInfo);
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            if (userInfo.getPerson() != null) {
                requestInfo.setAdminOrg(iPerson.getPrimaryAdminOrgUnit(userInfo.getPerson().getId()));
            }
            Calendar cal = Calendar.getInstance();
            Timestamp theTime = new Timestamp(cal.getTimeInMillis());
            requestInfo.setCreateTime(theTime);
            requestInfo.setBizDate(theTime);
            requestInfo.setPerson(userInfo.getPerson());
            BizTypeInfo bizTypeInfo = new BizTypeInfo();
            bizTypeInfo.setId(BOSUuid.read((String)bizTypeID));
            requestInfo.setBizType(bizTypeInfo);
            requestInfo.setPurchaseType(purchaseType);
            requestInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            requestInfo.setIsMergeBill(true);
            requestInfo.setBotpCallSave(false);
            requestInfo.setIsUrgent(false);
            requestInfo.setIsPriceInTax(true);
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            String num = codingRuleManager.getNumber((IObjectValue)requestInfo, companyOrgUnitID);
            requestInfo.setNumber(num);
            gatherBillSql.append("");
            gatherBillSql = gatherBillSql.append("select purReqEntry.FRowTypeID FRowTypeID,purReqEntry.FPurchaseOrgUnitID  FPurchaseOrgUnitID,");
            gatherBillSql = gatherBillSql.append("purReqEntry.fsupplierid  fsupplierid,");
            gatherBillSql = gatherBillSql.append("purReqEntry.FReceivedOrgUnitID FReceivedOrgUnitID,");
            gatherBillSql = gatherBillSql.append("purReqEntry.FMaterialID  FMaterialID,purReqEntry.FPROJECTID FPROJECTID,purReqEntry.FTRACKNOID FTRACKNOID,purReqEntry.FAssistPropertyID  FAssistPropertyID,");
            gatherBillSql = gatherBillSql.append("purReqEntry.FPurpose FPurpose,purReqEntry.FBaseUnitID  FBaseUnitID,");
            gatherBillSql = gatherBillSql.append("sum(FBaseQty) as FBaseQty,sum(ISNULL(FAssistQty,0)) as FAssistQty, ");
            gatherBillSql = gatherBillSql.append("round(decimal((decimal(sum(FBaseQty),21,8)/purUnit.FBaseConvsRate),21,8),purUnit.FQtyPrecision)  as FQty, ");
            gatherBillSql = gatherBillSql.append(" mp.funitid as fpurunitid ,");
            gatherBillSql = gatherBillSql.append("round(decimal((SUM(ISNULL(FRequestQty*mmUnit.FBaseConvsRate,0))/purUnit.FBaseConvsRate),21,8),purUnit.FQtyPrecision) AS FRequestQty ");
            gatherBillSql = gatherBillSql.append(this.getFieldEX());
            gatherBillSql = gatherBillSql.append("from T_SM_PurRequestEntry purReqEntry ").append("\r\n");
            gatherBillSql = gatherBillSql.append("LEFT OUTER JOIN t_bd_material material ON purReqEntry.fmaterialid = material.fid ").append("\r\n");
            gatherBillSql = gatherBillSql.append("INNER JOIN t_bd_measureunit baseunit ON purReqEntry.fbaseunitid = baseunit.fid ").append("\r\n");
            gatherBillSql = gatherBillSql.append("LEFT OUTER JOIN t_bd_multimeasureunit mmUnit ON purReqEntry.FUnitID = mmUnit.FMeasureUnitID ");
            gatherBillSql = gatherBillSql.append("AND purReqEntry.fmaterialid = mmUnit.FMaterialID ");
            gatherBillSql = gatherBillSql.append(" left join T_BD_MaterialPurchasing as mp on mp.fmaterialid = purReqEntry.fmaterialid");
            gatherBillSql = gatherBillSql.append(" and mp.forgunit = purReqEntry.FPurchaseOrgUnitID ");
            gatherBillSql = gatherBillSql.append("LEFT OUTER JOIN t_bd_multimeasureunit purUnit ON mp.funitid = purUnit.FMeasureUnitID ");
            gatherBillSql = gatherBillSql.append("AND purReqEntry.fmaterialid = purUnit.FMaterialID ");
            gatherBillSql = gatherBillSql.append("where purReqEntry.Fid in(" + params.toString() + ") ").append("\r\n");
            gatherBillSql = gatherBillSql.append("group by purReqEntry.FRowTypeID,purReqEntry.FPurchaseOrgUnitID,purReqEntry.fsupplierid,purReqEntry.FReceivedOrgUnitID , ");
            gatherBillSql = gatherBillSql.append("purReqEntry.FMaterialID ,purReqEntry.FPROJECTID,purReqEntry.FTRACKNOID ,purReqEntry.FAssistPropertyID ,purReqEntry.FPurpose ,purReqEntry.FBaseUnitID ");
            gatherBillSql = gatherBillSql.append(",purUnit.FQtyPrecision,purUnit.FBaseConvsRate,mp.funitid ").append(this.getFieldGroupEX());
            HashMap<String, String> srcDestMap = new HashMap<String, String>();
            HashMap<String, ArrayList<String>> parentEntryMap = new HashMap<String, ArrayList<String>>();
            ArrayList<String> idList = null;
            String fid = null;
            String parentid = null;
            PurRequestEntryInfo entry = new PurRequestEntryInfo();
            statement = null;
            statement = con.createStatement();
            ResultSet gatherSet = statement.executeQuery(gatherBillSql.toString());
            seq = 1;
            statementTemp = null;
            statementTemp = con.createStatement(1004, 1007);
            String[] fileds = new String[]{"ORDER_FIELD_QUANTITY", "ORDER_FIELD_RequestQty", "ORDER_FIELD_ASSISTQUANTITY"};
            BigDecimal[] qtys = new BigDecimal[3];
            while (gatherSet.next()) {
                entry = new PurRequestEntryInfo();
                entry.setId(BOSUuid.create((BOSObjectType)entry.getBOSType()));
                entry.setSeq(seq);
                RowTypeInfo rowTypeInfo = new RowTypeInfo();
                if (gatherSet.getString("FRowTypeID") != null) {
                    rowTypeInfo = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK(gatherSet.getString("FRowTypeID")));
                    entry.setRowType(rowTypeInfo);
                    entry.setDestinationType(rowTypeInfo.getDestinationType());
                }
                PurchaseOrgUnitInfo purOrgInfo = new PurchaseOrgUnitInfo();
                purOrgInfo.setId(BOSUuid.read((String)gatherSet.getString("FPurchaseOrgUnitID")));
                entry.setPurchaseOrgUnit(purOrgInfo);
                if (gatherSet.getString("fsupplierid") != null) {
                    SupplierInfo supplier = new SupplierInfo();
                    supplier.setId(BOSUuid.read((String)gatherSet.getString("fsupplierid")));
                    entry.setSupplier(supplier);
                }
                if (gatherSet.getString("FReceivedOrgUnitID") != null) {
                    StorageOrgUnitInfo storageOrgInfo = new StorageOrgUnitInfo();
                    storageOrgInfo.setId(BOSUuid.read((String)gatherSet.getString("FReceivedOrgUnitID")));
                    entry.setReceivedOrgUnit(storageOrgInfo);
                }
                if (gatherSet.getString("FPurpose") != null) {
                    entry.setPurpose(gatherSet.getString("FPurpose"));
                } else {
                    entry.setPurpose(null);
                }
                if (gatherSet.getString("FPROJECTID") != null) {
                    ProjectInfo projectInfo = new ProjectInfo();
                    projectInfo.setId(BOSUuid.read((String)gatherSet.getString("FPROJECTID")));
                    entry.setProject(projectInfo);
                }
                if (gatherSet.getString("FTRACKNOID") != null) {
                    TrackNumberInfo trackNumberInfo = new TrackNumberInfo();
                    trackNumberInfo.setId(BOSUuid.read((String)gatherSet.getString("FTRACKNOID")));
                    entry.setTrackNo(trackNumberInfo);
                }
                MaterialInfo material = new MaterialInfo();
                IMaterial imaterial = MaterialFactory.getLocalInstance((Context)ctx);
                material = imaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(gatherSet.getString("FMaterialID")));
                entry.setMaterial(material);
                if (material != null && purOrgInfo != null) {
                    MaterialPurchasingInfo info = null;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filterInfo = new FilterInfo();
                    view.getSelector().add(new SelectorItemInfo("isNotControlQty"));
                    filterInfo.getFilterItems().add(new FilterItemInfo("material", (Object)material.getId().toString(), CompareType.EQUALS));
                    filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)purOrgInfo.getId().toString(), CompareType.EQUALS));
                    view.setFilter(filterInfo);
                    MaterialPurchasingCollection col = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
                    if (col != null && col.size() > 0) {
                        info = col.get(0);
                        entry.setIsQuantityUnCtrl(info.isIsNotControlQty());
                    }
                }
                entry.setMaterialName(material.getName());
                if (material.getMaterialGroup() != null) {
                    IMaterialGroup imaterialGroup = MaterialGroupFactory.getLocalInstance((Context)ctx);
                    MaterialGroupInfo materiGroupInfo = imaterialGroup.getMaterialGroupInfo((IObjectPK)new ObjectUuidPK(material.getMaterialGroup().getId()));
                    entry.setMaterialBaseClass(materiGroupInfo.getName());
                }
                if (gatherSet.getString("FAssistPropertyID") != null) {
                    AsstAttrValueInfo asstAttrInfo = new AsstAttrValueInfo();
                    asstAttrInfo.setId(BOSUuid.read((String)gatherSet.getString("FAssistPropertyID")));
                    entry.setAssistProperty(asstAttrInfo);
                }
                MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                baseUnit.setId(BOSUuid.read((String)gatherSet.getString("FBaseUnitID")));
                entry.setBaseUnit(baseUnit);
                MeasureUnitInfo purUnit = new MeasureUnitInfo();
                purUnit.setId(BOSUuid.read((String)gatherSet.getString("fpurunitid")));
                entry.setUnit(purUnit);
                entry.setQty(gatherSet.getBigDecimal("FQty"));
                entry.setBaseQty(gatherSet.getBigDecimal("FBaseQty"));
                entry.setRequestQty(gatherSet.getBigDecimal("FRequestQty"));
                if (entry.getQty().compareTo(SysConstant.BIGZERO) <= 0) {
                    String error = this.getResource(ctx, "ORDER_FIELD_QUANTITY");
                    throw new PurReqException(PurReqException.QTY_CANNOT_NULL, new String[]{error});
                }
                if (material.getAssistUnit() != null) {
                    entry.setAssistUnit(material.getAssistUnit());
                    entry.setAssistQty(gatherSet.getBigDecimal("FAssistQty"));
                }
                qtys[0] = gatherSet.getBigDecimal("FBaseQty");
                qtys[1] = gatherSet.getBigDecimal("FRequestQty");
                qtys[2] = gatherSet.getBigDecimal("FAssistQty");
                for (int i2 = 0; i2 < fileds.length; ++i2) {
                    this.checkQty(ctx, fileds[i2], qtys[i2]);
                }
                gatherFieldSql = new StringBuffer();
                gatherFieldSql.append("");
                gatherFieldSql = gatherFieldSql.append("select ");
                gatherFieldSql = gatherFieldSql.append("FID,FParentId,FRequirementDate,FProposeDeliveryDate,FProposePurchaseDate,FRemark,FSTORAGEORGUNITID ");
                gatherFieldSql = gatherFieldSql.append("from T_SM_PurRequestEntry ");
                gatherFieldSql = gatherFieldSql.append("where Fid in(" + params.toString() + ") ");
                gatherFieldSql = gatherFieldSql.append("and FRowTypeID='" + gatherSet.getString("FRowTypeID") + "'  ");
                gatherFieldSql = gatherFieldSql.append("and FPurchaseOrgUnitID='" + gatherSet.getString("FPurchaseOrgUnitID") + "' ");
                if (gatherSet.getString("FReceivedOrgUnitID") != null) {
                    gatherFieldSql = gatherFieldSql.append("and FReceivedOrgUnitID='" + gatherSet.getString("FReceivedOrgUnitID") + "' ");
                }
                gatherFieldSql = gatherFieldSql.append("and FMaterialID='" + gatherSet.getString("FMaterialID") + "' ");
                gatherFieldSql = gatherSet.getString("FAssistPropertyID") != null ? gatherFieldSql.append("and FAssistPropertyID='" + gatherSet.getString("FAssistPropertyID") + "' ") : gatherFieldSql.append("and FAssistPropertyID is null ");
                gatherFieldSql = gatherSet.getString("FPurpose") != null ? gatherFieldSql.append("and FPurpose='" + gatherSet.getString("FPurpose") + "'") : gatherFieldSql.append("and FPurpose is null");
                gatherFieldSet = null;
                gatherFieldSet = statementTemp.executeQuery(gatherFieldSql.toString());
                StorageOrgUnitInfo storageOrgInfo = new StorageOrgUnitInfo();
                Boolean isNotGetStorageUnit = false;
                if (gatherFieldSet.next()) {
                    if (gatherFieldSet.getString("FStorageOrgUnitID") != null) {
                        storageOrgInfo.setId(BOSUuid.read((String)gatherFieldSet.getString("FStorageOrgUnitID")));
                    }
                    requirementDate = gatherFieldSet.getDate("FRequirementDate");
                    proposeDeliveryDate = gatherFieldSet.getDate("FProposeDeliveryDate");
                    proposePurchaseDate = gatherFieldSet.getDate("FProposePurchaseDate");
                    remark = new StringBuffer();
                }
                gatherFieldSet.beforeFirst();
                while (gatherFieldSet.next()) {
                    if (gatherFieldSet.getString("FStorageOrgUnitID") != null && storageOrgInfo.getId() != null && !storageOrgInfo.getId().toString().equals(gatherFieldSet.getString("FStorageOrgUnitID").toString())) {
                        isNotGetStorageUnit = true;
                    }
                    if (requirementDate != null && requirementDate.after(gatherFieldSet.getDate("FRequirementDate"))) {
                        requirementDate = gatherFieldSet.getDate("FRequirementDate");
                    }
                    remark.append(gatherFieldSet.getString("FRemark") == null ? "" : gatherFieldSet.getString("FRemark"));
                    fid = gatherFieldSet.getString("FID");
                    parentid = gatherFieldSet.getString("FParentId");
                    srcDestMap.put(fid, entry.getId().toString());
                    idList = (ArrayList<String>)parentEntryMap.get(parentid);
                    if (idList == null) {
                        idList = new ArrayList<String>();
                    }
                    idList.add(fid);
                    parentEntryMap.put(parentid, idList);
                }
                entry.setRequirementDate(requirementDate);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
                Calendar calender = Calendar.getInstance();
                calender.setTime(requirementDate);
                calender.add(5, -1);
                simpleDateFormat.format(calender.getTime());
                proposeDeliveryDate = calender.getTime();
                calender.setTime(proposeDeliveryDate);
                calender.add(5, -1);
                simpleDateFormat.format(calender.getTime());
                proposePurchaseDate = calender.getTime();
                entry.setProposeDeliveryDate(proposeDeliveryDate);
                entry.setProposePurchaseDate(proposePurchaseDate);
                if (remark.length() > 80) {
                    entry.setRemark(remark.substring(1, 80));
                } else {
                    entry.setRemark(remark.toString());
                }
                if (companyInfo.getBaseCurrency() != null) {
                    entry.setCurrency(companyInfo.getBaseCurrency());
                    entry.setExchangeRate(new BigDecimal("1.00"));
                } else {
                    entry.setCurrency(null);
                    entry.setExchangeRate(SysConstant.BIGZERO);
                }
                if (storageOrgInfo.getId() != null && !isNotGetStorageUnit.booleanValue()) {
                    entry.setStorageOrgUnit(storageOrgInfo);
                } else {
                    entry.setStorageOrgUnit(null);
                }
                entry.setAdminOrgUnit(null);
                entry.setUseAdminOrgUnit(null);
                entry.setDeliveryAddress(null);
                entry.setWarehosue(null);
                entry.setPurchasePerson(null);
                entry.setPrice(SysConstant.BIGZERO);
                entry.setAmount(SysConstant.BIGZERO);
                entry.setLocalAmount(SysConstant.BIGZERO);
                this.setFieldEX(entry, gatherSet);
                requestInfo.getEntries().add(entry);
                ++seq;
            }
            IObjectPK newBillID = null;
            PurRequestCal purRequestCal = new PurRequestCal();
            purRequestCal.fetchPrice(ctx, requestInfo);
            PurRequestCal.reCalcAmount(ctx, requestInfo);
            newBillID = this._save(ctx, (IObjectValue)requestInfo);
            requestInfo = PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo(newBillID);
            BOTRelationInfo info = null;
            for (int i3 = 0; i3 < pkBills.length; ++i3) {
                info = new BOTRelationInfo();
                info.setSrcObjectID(pkBills[i3].toString());
                info.setSrcEntityID("25428F2E");
                info.setDestEntityID("25428F2E");
                info.setDestObjectID(newBillID.toString());
                info.setOperatorID(ctx.getUserName());
                info.setBOTMappingID("XpnhyG7gQbeQV6u0QD2BAwRRIsQ=");
                info.setType(0);
                BOTRelationFactory.getLocalInstance((Context)ctx).addnew(info);
            }
            StringBuffer closeEntry = new StringBuffer();
            closeEntry.append(" UPDATE t_sm_purrequestentry ").append(" SET fbasestatus = ").append(7).append(",FMergeBillNumber = '").append(requestInfo.getNumber()).append("' ").append(this.sp).append(" WHERE fid IN (").append(params.toString()).append(");");
            DBUtil.executeUpdate((String)closeEntry.toString(), null, (Connection)con);
            StringBuffer updateSqlBuf = new StringBuffer();
            updateSqlBuf.append(" UPDATE t_sm_purrequestentry  AS t1 ").append(" SET (FMergeBillSeq,FMergeBillEntryId) = (SELECT t2.FSeq,t2.FId ").append(" FROM  t_sm_purrequestentry AS t2 ").append(" WHERE t1.fmaterialid = t2.fmaterialid AND ISNULL(t1.FAssistPropertyID,'1') = ISNULL(t2.FAssistPropertyID,'1') ").append(" AND ISNULL(t1.fsupplierid,'1') = ISNULL(t2.fsupplierid,'1') ").append(this.getJoinFilterEX()).append(" AND t1.fid IN (").append(params.toString()).append(") ").append(" AND t2.fparentid = '").append(requestInfo.getId().toString()).append("'); ");
            DBUtil.executeUpdate((String)updateSqlBuf.toString(), null, (Connection)con);
            StringBuffer closeBill = new StringBuffer();
            closeBill.append(" UPDATE t_sm_purrequest SET fbasestatus = ").append(7).append(this.sp).append(" WHERE fid in (").append(this.sp).append(" SELECT fid FROM (").append(this.sp).append(" SELECT fid,SUM(entryCount) entryCount,SUM(closeCount) closeCount FROM (").append(this.sp).append(" SELECT req.fid,count(req.fid) entryCount,0 closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(parentParams.toString()).append(")").append(this.sp).append(" GROUP BY req.fid ").append(this.sp).append(" UNION ALL ").append(this.sp).append(" SELECT req.fid,0 entryCount,count(req.fid) closeCount ").append(this.sp).append(" FROM t_sm_purrequest req inner join t_sm_purrequestentry entry on req.fid = entry.fparentid ").append(this.sp).append(" WHERE req.fid in (").append(parentParams.toString()).append(")").append(this.sp).append(" AND entry.fbasestatus = ").append(7).append(this.sp).append(" GROUP BY req.fid) AS TMP__").append(this.sp).append(" GROUP BY fid) AS TMP___").append(this.sp).append(" WHERE TMP___.entryCount = TMP___.closeCount);");
            DBUtil.execute((String)closeBill.toString(), null, (Connection)con);
            string = newBillID.toString();
        }
        catch (SQLException er) {
            try {
                throw new BOSException("sql Execute Error :", (Throwable)er);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)con);
                SQLUtils.cleanup(statementTemp, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)con);
        SQLUtils.cleanup((Statement)statementTemp, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return string;
    }

    public static boolean hasDestBillExceptBill(Context ctx, String srcId, BOSObjectType bosType) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("srcObjectID", (Object)srcId, CompareType.EQUALS));
        if (null != bosType) {
            filterInfo.getFilterItems().add(new FilterItemInfo("destEntityID", (Object)bosType, CompareType.NOTEQUALS));
        }
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        BOTRelationCollection collection = BOTRelationFactory.getLocalInstance((Context)ctx).getCollection(viewInfo);
        return collection != null && collection.size() > 0;
    }

    private void checkQty(Context ctx, String filed, BigDecimal qty) throws PurReqException {
        if (qty != null && qty.compareTo(MAXVAL) > 0) {
            String error = this.getResource(ctx, filed);
            throw new PurReqException(PurReqException.MSG_QTY_MAX, new String[]{error});
        }
    }

    private String getResource(Context ctx, String str) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)str, (Context)ctx);
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        PurRequestInfo info;
        if ("NOTSAVE".equals(action) && ctx.get((Object)"NOTSAVE_EDITUI_SELECTOR") == null) {
            SelectorItemCollection sic = this.getPurRequestSelector();
            ctx.put((Object)"NOTSAVE_EDITUI_SELECTOR", (Object)sic);
        }
        if (!this.isBotpBill(info = (PurRequestInfo)collection.getObject(0), "9XXvbVGlRtym/0qtqeIXXrhE1B8=")) {
            this.setDefaultValue(ctx, collection);
        }
        if (this.isBotpBill(info, "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=")) {
            this.setDefaultValueFormPurRequirement(ctx, collection, action);
        }
    }

    private void setDefaultValueFormPurRequirement(Context ctx, IObjectCollection collection, String action) throws EASBizException, BOSException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        HashSet<String> materialIdSet = new HashSet<String>();
        HashSet<String> purOrgUnitIdSet = new HashSet<String>();
        MaterialInfo materialInfo = null;
        PurchaseOrgUnitInfo purchaseOrgUnit = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurRequestInfo)collection.getObject(i);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("rowType.destinationType"));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getDemandType().getId().toString(), CompareType.EQUALS));
            view.setFilter(filter);
            view.setSelector(sic);
            DemandTypeCollection demandTypeColl = DemandTypeFactory.getLocalInstance((Context)ctx).getDemandTypeCollection(view);
            if (null == demandTypeColl || demandTypeColl.size() == 0) {
                return;
            }
            DemandTypeInfo demand = demandTypeColl.get(0);
            CompanyOrgUnitInfo comInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()));
            info.setCU(comInfo.getCU());
            info.setBaseStatus(BillBaseStatusEnum.ADD);
            if (null != info.getEntries() && info.getEntries().size() > 0) {
                entryInfo = info.getEntries().get(0);
                if (demand.getRowType().getDestinationType().equals((Object)DestinationTypeEnum.COSTS)) {
                    info.setReqAdminOrgUnit(entryInfo.getReqAdminOrgUnit());
                    info.setStorageOrgUnit(null);
                } else {
                    info.setStorageOrgUnit(entryInfo.getStorageOrgUnit());
                    info.setReqAdminOrgUnit(null);
                }
            }
            if (null != info.getEntries() && info.getEntries().size() > 0) {
                int m = info.getEntries().size();
                for (int j = 0; j < m; ++j) {
                    entryInfo = info.getEntries().get(j);
                    if (!"NOTSAVE".equals(action)) continue;
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
                }
            }
            HashMap<String, BigDecimal> exchangeMap = new HashMap<String, BigDecimal>();
            int m = info.getEntries().size();
            for (int j = 0; j < m; ++j) {
                entryInfo = info.getEntries().get(j);
                if (demand.getRowType().getDestinationType().equals((Object)DestinationTypeEnum.COSTS)) {
                    PurchaseOrgUnitInfo purOrg = null;
                    IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    if (null != entryInfo.getAdminOrgUnit()) {
                        String admId = entryInfo.getAdminOrgUnit().getId().toString();
                        OrgUnitInfo defaultOrg = iRelation.getDefaultToUnit(admId, 0, 3);
                        if (defaultOrg == null) {
                            OrgUnitCollection orgcol = iRelation.getToUnit(admId, 0, 3);
                            int size = orgcol.size();
                            for (int x = 0; x < size; ++x) {
                                if (!admId.equals(orgcol.get(x).getId().toString())) continue;
                                purOrg = (PurchaseOrgUnitInfo)orgcol.get(x);
                                break;
                            }
                            if (purOrg == null) {
                                purOrg = (PurchaseOrgUnitInfo)orgcol.get(0);
                            }
                        } else {
                            purOrg = (PurchaseOrgUnitInfo)defaultOrg;
                        }
                    }
                    entryInfo.setPurchaseOrgUnit(purOrg);
                }
                CompanyOrgUnitInfo comOrg = info.getCompanyOrgUnit();
                String sourceCurrPKStr = comOrg.getBaseCurrency().getId().toString();
                String destCurrPKStr = entryInfo.getCurrency().getId().toString();
                ObjectUuidPK sourceCurrPK = new ObjectUuidPK(comOrg.getBaseCurrency().getId());
                ObjectUuidPK destCurrPK = new ObjectUuidPK(entryInfo.getCurrency().getId());
                if (sourceCurrPKStr.equals(destCurrPKStr)) {
                    entryInfo.setExchangeRate(new BigDecimal(1));
                } else if (exchangeMap.containsKey(sourceCurrPKStr + destCurrPKStr)) {
                    entryInfo.setExchangeRate((BigDecimal)exchangeMap.get(sourceCurrPKStr + destCurrPKStr));
                } else {
                    CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(comOrg.getId()));
                    ExchangeTableInfo baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
                    if (baseExchangeTableInfo != null) {
                        ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
                        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
                        ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
                        if (null != tempexrateinfo) {
                            entryInfo.setExchangeRate(tempexrateinfo.getConvertRate());
                            exchangeMap.put(sourceCurrPKStr + destCurrPKStr, tempexrateinfo.getConvertRate());
                        } else {
                            exchangeMap.put(sourceCurrPKStr + destCurrPKStr, null);
                        }
                    } else {
                        exchangeMap.put(sourceCurrPKStr + destCurrPKStr, null);
                    }
                }
                if (entryInfo == null) continue;
                materialInfo = entryInfo.getMaterial();
                if (materialInfo != null) {
                    materialIdSet.add(materialInfo.getId().toString());
                }
                if ((purchaseOrgUnit = entryInfo.getPurchaseOrgUnit()) == null) continue;
                purOrgUnitIdSet.add(purchaseOrgUnit.getId().toString());
            }
        }
        HashMap materialPurchaseMap = new HashMap();
        this.setMaterialPurchaseCache(ctx, collection, materialIdSet, purOrgUnitIdSet, materialPurchaseMap);
        this.setTimeUnCtrl(collection, materialPurchaseMap);
    }

    private void setTimeUnCtrl(IObjectCollection collection, Map materialPurchaseMap) {
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            PurRequestInfo info = (PurRequestInfo)collection.getObject(i);
            if (info == null || info.getEntries() == null || info.getEntries().size() <= 0) continue;
            for (int j = 0; j < info.getEntries().size(); ++j) {
                PurRequestEntryInfo entryInfo = info.getEntries().get(j);
                Boolean isQuantityUnCtrl = null;
                if (entryInfo.get("isQuantityUnCtrl") != null) {
                    isQuantityUnCtrl = (Boolean)entryInfo.get("isQuantityUnCtrl");
                }
                if (isQuantityUnCtrl == null && entryInfo != null && entryInfo.getMaterial() != null && entryInfo.getPurchaseOrgUnit() != null) {
                    String entryMaterialId = entryInfo.getMaterial().getId().toString();
                    String entrypOrgId = entryInfo.getPurchaseOrgUnit().getId().toString();
                    MaterialPurchasingInfo materialPurchaseInfo = (MaterialPurchasingInfo)materialPurchaseMap.get(entryMaterialId + entrypOrgId);
                    if (materialPurchaseInfo != null) {
                        isQuantityUnCtrl = materialPurchaseInfo.isIsNotControlQty();
                    }
                }
                if (isQuantityUnCtrl == null) {
                    isQuantityUnCtrl = false;
                }
                entryInfo.setIsQuantityUnCtrl(isQuantityUnCtrl);
            }
        }
    }

    private void setMaterialPurchaseCache(Context ctx, IObjectCollection collection, Set materialIdSet, Set purOrgUnitIdSet, Map materialPurchaseMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)purOrgUnitIdSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)Integer.valueOf("1")));
        view.setFilter(filter);
        SelectorItemCollection materialPurchaseSelector = new SelectorItemCollection();
        materialPurchaseSelector.add(new SelectorItemInfo("material.id"));
        materialPurchaseSelector.add(new SelectorItemInfo("orgUnit.id"));
        materialPurchaseSelector.add(new SelectorItemInfo("isNotControlQty"));
        materialPurchaseSelector.add(new SelectorItemInfo("isNotControlTime"));
        view.setSelector(materialPurchaseSelector);
        MaterialPurchasingCollection materialPurchasecollection = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
        for (int i = 0; i < collection.size(); ++i) {
            PurRequestInfo info = (PurRequestInfo)collection.getObject(i);
            if (info == null || info.getEntries() == null || info.getEntries().size() <= 0) continue;
            for (int j = 0; j < info.getEntries().size(); ++j) {
                PurRequestEntryInfo entryInfo = info.getEntries().get(j);
                if (entryInfo == null || entryInfo.getMaterial() == null || entryInfo.getPurchaseOrgUnit() == null) continue;
                String entryMaterialId = entryInfo.getMaterial().getId().toString();
                String entrypOrgId = entryInfo.getPurchaseOrgUnit().getId().toString();
                if (materialPurchasecollection == null || materialPurchasecollection.size() <= 0) continue;
                for (int k = 0; k < materialPurchasecollection.size(); ++k) {
                    MaterialPurchasingInfo materialPurchasingInfo = materialPurchasecollection.get(k);
                    String mpMaterialId = materialPurchasingInfo.getMaterial().getId().toString();
                    String mpOrgId = materialPurchasingInfo.getOrgUnit().getId().toString();
                    if (entryMaterialId == null || entrypOrgId == null || mpMaterialId == null || mpOrgId == null || !entryMaterialId.equals(mpMaterialId) || !entrypOrgId.equals(mpOrgId)) continue;
                    materialPurchaseMap.put(entryMaterialId + entrypOrgId, materialPurchasingInfo);
                }
            }
        }
    }

    public void setDefaultValue(Context ctx, IObjectCollection collection) throws EASBizException, BOSException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.US);
        Date requirementDate = null;
        Date proposeDeliveryDate = null;
        Date proposePurchaseDate = null;
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        int orderBaseSeq = 10000;
        HashSet<String> idsSet = new HashSet<String>();
        IMaterialInventory imaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo warehouseView = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<String> purorgSet = new HashSet<String>();
        HashSet<String> storeOrgSet = new HashSet<String>();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurRequestInfo)collection.getObject(i);
            String SPAREPARTPLANORDER_BILLTYPEID = "iqOirq+CQ9uuawiIOSPHSkY+1VI=";
            if ((this.isBotpBill(info, "9XXvbVGlRtym/0qtqeIXXrhE1B8=") || this.isBotpBill(info, SPAREPARTPLANORDER_BILLTYPEID) || this.isBotpBill(info, "7UcZ6QEUEADgAAYawKg9C0Y+1VI=")) && info.getDemandType() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("number"));
                sic.add(new SelectorItemInfo("name"));
                sic.add(new SelectorItemInfo("rowType.id"));
                sic.add(new SelectorItemInfo("rowType.name"));
                sic.add(new SelectorItemInfo("rowType.number"));
                sic.add(new SelectorItemInfo("rowType.destinationType"));
                sic.add(new SelectorItemInfo("rowType.requestOrgType"));
                sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
                sic.add(new SelectorItemInfo("rowType.precision"));
                EntityViewInfo view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
                if (PurchaseTypeEnum.PURCHASE.equals((Object)info.getPurchaseType())) {
                    filter.getFilterItems().add(new FilterItemInfo("purchanseType", (Object)0));
                } else {
                    filter.getFilterItems().add(new FilterItemInfo("purchanseType", (Object)1));
                }
                view.setFilter(filter);
                view.setSelector(sic);
                SorterItemCollection sort = new SorterItemCollection();
                sort.add(new SorterItemInfo("number"));
                view.setSorter(sort);
                DemandTypeCollection demandTypeColl = DemandTypeFactory.getLocalInstance((Context)ctx).getDemandTypeCollection(view);
                if (demandTypeColl != null && demandTypeColl.size() > 0) {
                    info.setDemandType(demandTypeColl.get(0));
                }
            }
            int m = info.getEntries().size();
            for (int j = 0; j < m; ++j) {
                entryInfo = info.getEntries().get(j);
                if (info.getEntries().get(j).getMaterial() == null) continue;
                idsSet.add(info.getEntries().get(j).getMaterial().getId().toString());
                if (info.getEntries().get(j).getPurchaseOrgUnit() != null) {
                    purorgSet.add(info.getEntries().get(j).getPurchaseOrgUnit().getId().toString());
                }
                if (info.getEntries().get(j).getStorageOrgUnit() != null) {
                    storeOrgSet.add(info.getEntries().get(j).getStorageOrgUnit().getId().toString());
                }
                if (this.isBotpBill(info, "7UcZ6QEUEADgAAYawKg9C0Y+1VI=") && entryInfo.getRequirementDate() != null) {
                    requirementDate = entryInfo.getRequirementDate();
                    Calendar calender = Calendar.getInstance();
                    calender.setTime(requirementDate);
                    calender.add(5, -1);
                    simpleDateFormat.format(calender.getTime());
                    proposeDeliveryDate = calender.getTime();
                    calender.setTime(proposeDeliveryDate);
                    calender.add(5, -1);
                    simpleDateFormat.format(calender.getTime());
                    proposePurchaseDate = calender.getTime();
                    entryInfo.setProposeDeliveryDate(proposeDeliveryDate);
                    entryInfo.setProposePurchaseDate(proposePurchaseDate);
                }
                if (info != null && entryInfo != null) {
                    if (info.getBizDate() != null) {
                        entryInfo.setBizDate(info.getBizDate());
                    }
                    if (info.getCompanyOrgUnit() != null && info.getCompanyOrgUnit().getId() != null) {
                        entryInfo.setCompanyOrgUnit(info.getCompanyOrgUnit().getId().toString());
                        if (null == entryInfo.getCurrency()) {
                            entryInfo.setCurrency(info.getCompanyOrgUnit().getBaseCurrency());
                            entryInfo.setExchangeRate(new BigDecimal("1.00"));
                        }
                    }
                }
                this.ReWriteSupplierAndPrice(ctx, info, entryInfo);
                if (i == 0 && PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
                    paramCol.setPurchaseType(MaterialPurchaseTypeEnum.SUBCONTRACT);
                }
                if (entryInfo == null || entryInfo.getMaterial() == null || entryInfo.getPurchaseOrgUnit() == null || entryInfo.getPrice() != null && entryInfo.getPrice().compareTo(SCMConstant.BIGDECIMAL_ZERO) != 0) continue;
                paramCol.setBizTypeId(info.getBillType() != null ? info.getBizType().getId().toString() : null);
                int seq = orderBaseSeq * (i + 1) + j;
                PurPriceParam param = PurRequestCal.getPriceParam(seq, info, entryInfo);
                paramCol.addPurPriceParam(param);
            }
            Object key = null;
            this.calBotpAssQty(ctx, info);
            this.doMergeAfterTransform(ctx, (IObjectValue)info);
        }
        PurRequestCal purRequestCal = new PurRequestCal();
        purRequestCal.fetchPrice(ctx, collection, paramCol, orderBaseSeq);
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
        warehouseView.getSelector().add(new SelectorItemInfo("Material.id"));
        warehouseView.getSelector().add(new SelectorItemInfo("defaultWarehouse.*"));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", storeOrgSet, CompareType.INCLUDE));
        warehouseView.setFilter(filter);
        MaterialInventoryCollection collections = imaterialInventory.getMaterialInventoryCollection(warehouseView);
        filter.getFilterItems().clear();
        filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", purorgSet, CompareType.INCLUDE));
        HashMap<String, WarehouseInfo> warehosueMap = new HashMap<String, WarehouseInfo>();
        for (int i = 0; i < collections.size(); ++i) {
            if (collections.get(i).getDefaultWarehouse() == null) continue;
            warehosueMap.put(collections.get(i).getMaterial().getId().toString() + collections.get(i).getDefaultWarehouse().getStorageOrg().getId().toString(), collections.get(i).getDefaultWarehouse());
        }
        String key = null;
        int n2 = collection.size();
        for (int i = 0; i < n2; ++i) {
            info = (PurRequestInfo)collection.getObject(i);
            for (int row = 0; row < info.getEntries().size(); ++row) {
                if (info.getEntries().get(row).getStorageOrgUnit() == null || info.getEntries().get(row).getWarehosue() != null || info.getEntries().get(row).getMaterial() == null || !warehosueMap.containsKey(key = info.getEntries().get(row).getMaterial().getId() + info.getEntries().get(row).getStorageOrgUnit().getId().toString())) continue;
                info.getEntries().get(row).setWarehosue((WarehouseInfo)warehosueMap.get(key));
            }
        }
        EntityViewInfo purMaterialView = new EntityViewInfo();
        purMaterialView.setFilter(filter);
        MaterialPurchasingCollection materialPurcon = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(purMaterialView);
        HashMap<String, MaterialPurchasingInfo> purMaterialMap = new HashMap<String, MaterialPurchasingInfo>();
        for (int i = 0; i < materialPurcon.size(); ++i) {
            purMaterialMap.put(materialPurcon.get(i).getMaterial().getId().toString() + materialPurcon.get(i).getOrgUnit().getId().toString(), materialPurcon.get(i));
        }
        if (info != null) {
            for (int row = 0; row < info.getEntries().size(); ++row) {
                if (info.getEntries().get(row).getPurchaseOrgUnit() == null || info.getEntries().get(row).getMaterial() == null || !purMaterialMap.containsKey(key = info.getEntries().get(row).getMaterial().getId().toString() + info.getEntries().get(row).getPurchaseOrgUnit().getId().toString())) continue;
                if (null == info.getEntries().get(row).getPurchasePerson()) {
                    info.getEntries().get(row).setPurchasePerson(((MaterialPurchasingInfo)purMaterialMap.get(key)).getPurPerson());
                }
                if (null != info.getEntries().get(row).getPurchaseGroup()) continue;
                info.getEntries().get(row).setPurchaseGroup(((MaterialPurchasingInfo)purMaterialMap.get(key)).getPurGroup());
            }
        }
    }

    private void ReWriteSupplierAndPrice(Context ctx, PurRequestInfo info, PurRequestEntryInfo entryInfo) throws BOSException, EASBizException {
        if ((this.isBotpBill(info, "7UcZ6QEUEADgAAYawKg9C0Y+1VI=") || this.isBotpBill(info, "9XXvbVGlRtym/0qtqeIXXrhE1B8=")) && entryInfo.getMaterial() != null && entryInfo.getStorageOrgUnit() != null) {
            PurchaseOrgUnitInfo purOrg = null;
            String materialID = entryInfo.getMaterial().getId().toString();
            StorageOrgUnitInfo storage = entryInfo.getStorageOrgUnit();
            IMaterialPlan matPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            view.setFilter(filter);
            MaterialPlanCollection col = matPlan.getMaterialPlanCollection(view);
            if (col.size() > 0 && col.get(0) != null) {
                MaterialPlanInfo matPlanInfo = col.get(0);
                purOrg = matPlanInfo.getPurOrg();
            }
            if (purOrg == null) {
                if (this.storageTopurMap.containsKey(storage.getId().toString())) {
                    purOrg = this.storageTopurMap.get(storage.getId().toString());
                } else {
                    purOrg = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(storage.getId().toString());
                    this.storageTopurMap.put(storage.getId().toString(), purOrg);
                }
            }
            if (purOrg != null && purOrg.getId() != null) {
                entryInfo.setPurchaseOrgUnit(purOrg);
            }
        }
    }

    public void handlePurChaseOrgUnit(Context ctx, PurRequestEntryInfo reqInfo) throws BOSException, EASBizException {
        if (reqInfo.getMaterial() == null || reqInfo.getStorageOrgUnit() == null) {
            return;
        }
        PurchaseOrgUnitInfo purOrg = null;
        String materialID = reqInfo.getMaterial().getId().toString();
        StorageOrgUnitInfo storage = reqInfo.getStorageOrgUnit();
        IMaterialPlan matPlan = MaterialPlanFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storage.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        view.setFilter(filter);
        MaterialPlanCollection col = matPlan.getMaterialPlanCollection(view);
        if (col.size() > 0 && col.get(0) != null) {
            MaterialPlanInfo matPlanInfo = col.get(0);
            purOrg = matPlanInfo.getPurOrg();
        }
        if (purOrg == null) {
            purOrg = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getPurchaseByStorageOrg(storage.getId().toString());
        }
        MaterialPurchasingInfo materialPurInfo = null;
        if (purOrg != null && purOrg.getId() != null) {
            reqInfo.setPurchaseOrgUnit(purOrg);
            FilterInfo matFilter = new FilterInfo();
            matFilter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialID));
            matFilter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)purOrg.getId().toString()));
            matFilter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(matFilter);
            MaterialPurchasingCollection materialPurcon = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(viewInfo);
            if (materialPurcon != null && materialPurcon.size() > 0 && materialPurcon.get(0) != null) {
                materialPurInfo = materialPurcon.get(0);
            }
        }
        if (materialPurInfo != null) {
            reqInfo.setPurchaseOrgUnit(purOrg);
            reqInfo.setPurchasePerson(materialPurInfo.getPurPerson());
            reqInfo.setPurchaseGroup(materialPurInfo.getPurGroup());
            reqInfo.setIsQuantityUnCtrl(materialPurInfo.isIsNotControlQty());
        }
    }

    @Override
    protected Map _submitForPlan(Context ctx, PurRequestInfo[] model) throws BOSException, EASBizException {
        PurRequestCollection collection = new PurRequestCollection();
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PurRequestInfo purRequestInfo2 = model[0];
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)purRequestInfo2.getPurchaseType())) {
            return this.submitForPlanold(ctx, model);
        }
        for (PurRequestInfo purRequestInfo2 : model) {
            if (purRequestInfo2.getPerson() == null) {
                purRequestInfo2.setPerson(userInfo.getPerson());
            }
            if (purRequestInfo2.getCreator() == null) {
                purRequestInfo2.setCreator(userInfo);
            }
            collection.add(purRequestInfo2);
        }
        this.setDefaultValue(ctx, (IObjectCollection)collection);
        return new HashMap();
    }

    @Deprecated
    private Map submitForPlanold(Context ctx, PurRequestInfo[] model) throws BOSException, EASBizException {
        IBOTRelation ibotp = BOTRelationFactory.getLocalInstance((Context)ctx);
        PurRequestInfo purRequestInfo = null;
        PurRequestEntryInfo purRequestEntryInfo = null;
        HashMap<String, String> result = new HashMap<String, String>();
        BigDecimal qty = null;
        BigDecimal price = null;
        BigDecimal sumAmount = null;
        BigDecimal amount = null;
        CurrencyInfo currencyInfo = null;
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("precision"));
        int scale = 4;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        for (int i = 0; i < model.length; ++i) {
            sumAmount = new BigDecimal("0.0");
            purRequestInfo = model[i];
            if (purRequestInfo.getPerson() == null) {
                purRequestInfo.setPerson(userInfo.getPerson());
            }
            if (purRequestInfo.getCreator() == null) {
                purRequestInfo.setCreator(userInfo);
            }
            int num = purRequestInfo.getEntries().size();
            for (int j = 0; j < num; ++j) {
                purRequestEntryInfo = purRequestInfo.getEntries().get(j);
                currencyInfo = purRequestEntryInfo.getCurrency();
                if (currencyInfo != null) {
                    if (currencyMap.get(currencyInfo.getId().toString()) == null) {
                        currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId()), sic);
                        currencyMap.put(currencyInfo.getId().toString(), currencyInfo);
                    }
                    scale = currencyInfo.getPrecision();
                }
                qty = purRequestEntryInfo.getQty();
                price = purRequestEntryInfo.getPrice();
                if (price == null) {
                    price = new BigDecimal("0.0");
                }
                amount = qty.multiply(price).setScale(scale, 4);
                purRequestEntryInfo.setAmount(amount);
                purRequestEntryInfo.setLocalAmount(amount);
                sumAmount = sumAmount.add(amount).setScale(scale, 4);
                if (purRequestEntryInfo.getStorageOrgUnit() == null) {
                    result.put(purRequestInfo.getSourceBillId(), EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"NOSTORAGEORGUNIT", (Locale)ctx.getOriginLocale()));
                    continue;
                }
                PurRequestEntryCollection entries = purRequestInfo.getEntries();
                for (int k = 0; k < entries.size(); ++k) {
                    PurRequestEntryInfo entry = entries.get(k);
                    this.handlePurChaseOrgUnit(ctx, entry);
                    if (entry.getPurchaseOrgUnit() != null) continue;
                    result.put(entry.getSourceBillId(), EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"NOPURCHASEORGUNIT", (Locale)ctx.getOriginLocale()));
                }
            }
            purRequestInfo.setTotalAmount(sumAmount);
            purRequestInfo.setLocalTotalAmount(sumAmount);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[model.length];
        for (int i = 0; i < model.length; ++i) {
            entries[i] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model[i]});
        }
        this.batchSubmitRelations(ctx, entries);
        return result;
    }

    protected void checkMoveAveMatForSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)model;
        if (info.getPurchaseType() != null && info.getPurchaseType().getValue() == 1) {
            ArrayList<String> matNumList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct mi.FNumber ");
            sb.append(" from T_SM_PurRequestEntry entry ");
            sb.append(" left join T_SM_PurRequest bill on entry.FParentID = bill.FID ");
            sb.append(" left join T_BD_MaterialCompanyInfo mc on entry.FCompanyOrgUnitID =  mc.FCompanyID and entry.FMaterialID =  mc.FMaterialID ");
            sb.append(" inner join T_BD_Material mi on entry.FMaterialID = mi.FID ");
            sb.append(" where bill.FID = '").append(pk.toString()).append("'");
            sb.append(" and mi.FIsOutsourcedPart = 1 ");
            sb.append(" and mc.FAccountType = ").append(1);
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    matNumList.add(rs.getString("FNumber"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sb.setLength(0);
            sb.append("\n");
            int count = matNumList.size();
            for (int i = 0; i < count; ++i) {
                sb.append(matNumList.get(i)).append("\r\n");
            }
            if (count > 0) {
                throw new SCMBillException(SCMBillException.CANNOT_BE_MOVEAGEMAT_IN_SUBCONSTRACT, new Object[]{sb.toString()});
            }
        }
    }

    public BatchActionResults batchAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchUnAudit(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    private String insertdata(Context ctx, Set keys) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table purorder (fid varchar(44) ");
        sql.append(",CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" insert into ").append(table);
        sql.append(" (fid) values (?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            Object[] ids = keys.toArray();
            int size = ids.length;
            for (int i = 0; i < size; ++i) {
                if (ids[i] == null) continue;
                stmt.setString(1, ids[i].toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        Object object;
        if ((BatchActionEnum.UNAUDIT.equals((Object)batchActionEnum) || BatchActionEnum.AUDIT.equals((Object)batchActionEnum)) && entries.length > 0 && (object = entries[0].get(0)) instanceof IObjectPK) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                String key = entries[i].get(0).toString();
                keys.add(key);
            }
            String tmptable = null;
            try {
                tmptable = this.insertdata(ctx, keys);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                String sqlstr = " select fid from " + tmptable;
                filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sqlstr, CompareType.INNER));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(this.getSelector(true));
                CoreBaseCollection billCol = this.getCollection(ctx, viewInfo);
                Object poInfo = null;
                int size2 = entries.length;
                for (int i = 0; i < size2; ++i) {
                    String id = entries[i].get(0).toString();
                    poInfo = billCol.get((Object)BOSUuid.read((String)id));
                    if (poInfo == null) {
                        poInfo = new PurRequestInfo();
                        poInfo.setId(BOSUuid.read((String)id));
                    }
                    entries[i] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{poInfo});
                }
            }
            finally {
                if (tmptable != null) {
                    TempTablePool.getInstance((Context)ctx).releaseTable(tmptable);
                }
            }
        }
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    protected String getBillTypeId() {
        return "510b6503-0105-1000-e000-0107c0a812fd463ED552";
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    private String getSourceIDsStr(String ids, Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FSourceBillEntryID from T_SM_PurRequestEntry where FParentID in (").append(ids).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet == null || rowSet.size() == 0) {
            return "";
        }
        StringBuffer SorceBillEntryIDs = new StringBuffer();
        try {
            while (rowSet.next()) {
                SorceBillEntryIDs.append("'").append(rowSet.getString("FSourceBillEntryID")).append("'").append(",");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return SorceBillEntryIDs.substring(0, SorceBillEntryIDs.length() - 1);
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION") == null || Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurRequestInfo model = null;
        model = this.getPurRequestInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelector(true));
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getPurRequestSelector((boolean)isNeedEntrySelector);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        Boolean release = (Boolean)ctx.get((Object)"isPlannedOrderRelease");
        if (release != null && release.booleanValue()) {
            return this.batchExecute(ctx, entries, batchAction);
        }
        if (BatchActionEnum.SUBMIT.equals((Object)batchAction)) {
            CoreBaseCollection billCol = null;
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                String key = null;
                if (entries[i].get(0) instanceof PurRequestInfo) continue;
                key = entries[i].get(0).toString();
                keys.add(key);
            }
            if (keys.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(this.getSelector(true));
                billCol = this.getCollection(ctx, viewInfo);
                if (billCol.size() > 0) {
                    Object poInfo = null;
                    int size2 = entries.length;
                    for (int i = 0; i < size2; ++i) {
                        String id = null;
                        if (!(entries[i].get(0) instanceof PurRequestInfo)) {
                            id = entries[i].get(0).toString();
                        }
                        if ((poInfo = billCol.get((Object)BOSUuid.read(id))) == null) {
                            poInfo = new PurRequestInfo();
                            poInfo.setId(BOSUuid.read((String)id));
                        }
                        entries[i] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{poInfo});
                    }
                }
            }
        }
        return this.batchExecute(ctx, entries, batchAction);
    }

    public String getFieldEX() {
        String filed = " ";
        return filed;
    }

    public String getFieldGroupEX() {
        String filed = " ";
        return filed;
    }

    public void setFieldEX(PurRequestEntryInfo entry, ResultSet gatherSet) throws SQLException {
    }

    public String getJoinFilterEX() {
        return " ";
    }

    public void _newHandleAfterTransform(Context ctx, String action, IObjectValue objectValue, String mappingId, IObjectCollection relationCol) throws EASBizException, BOSException {
        super._newHandleAfterTransform(ctx, action, objectValue, mappingId, relationCol);
        this.doMergeAfterTransformnew(ctx, null, objectValue, relationCol);
    }

    private void doMergeAfterTransform(Context ctx, IObjectValue objectValue) throws EASBizException, BOSException {
        PurRequestInfo info = null;
        Object entryInfo = null;
        if (objectValue == null) {
            return;
        }
        info = (PurRequestInfo)objectValue;
        if (!this.isBotpBill(info, "510b6503-0105-1000-e000-0107c0a812fd463ED552") || !info.isIsMergeBill()) {
            return;
        }
        this.dealEntryWithTransform(ctx, info);
        this.dealBillWithTransform(ctx, info);
        this.dealBillParams(ctx, info);
    }

    private void dealBillParams(Context ctx, PurRequestInfo info) throws BOSException {
        if (null == info.getBaseStatus() || info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        }
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            info.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
    }

    private void doMergeAfterTransformnew(Context ctx, String action, IObjectValue objectValue, IObjectCollection relationCol) throws EASBizException, BOSException {
        PurRequestInfo info = null;
        Object entryInfo = null;
        if (objectValue == null || relationCol == null) {
            return;
        }
        info = (PurRequestInfo)objectValue;
        if (!this.isBotpBill(info, "510b6503-0105-1000-e000-0107c0a812fd463ED552") || !info.isIsMergeBill()) {
            return;
        }
        this.doWriteBackByMerge(ctx, info, relationCol);
        this.insertDataToPurWorkTable(ctx, info);
    }

    private void dealEntryWithTransform(Context ctx, PurRequestInfo info) throws BOSException, EASBizException {
        PurRequestEntryInfo entryInfo = null;
        PersonInfo personInfo = null;
        PurchaseGroupInfo purGroupInfo = null;
        ExchangeRateInfo rateInfo = null;
        int priceScale = 2;
        int currencyPrecision = 2;
        Object multiInfo = null;
        Map<String, ExchangeRateInfo> rateMap = null;
        BigDecimal targetQty = SysConstant.BIGZERO;
        HashSet<String> cset = new HashSet<String>();
        HashSet<String> mset = new HashSet<String>();
        Map<String, Integer> materialMap = null;
        String baseCurrId = info.getCompanyOrgUnit().getBaseCurrency().getId().toString();
        cset.add(baseCurrId);
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getBaseUnit() == null || entryInfo.getRowType() == null) continue;
            if (entryInfo.getUnit() == null || entryInfo.getMaterial() == null) {
                entryInfo.setUnit(entryInfo.getBaseUnit());
            }
            if (entryInfo.getCurrency() != null && !entryInfo.getCurrency().getId().toString().equals(baseCurrId)) {
                cset.add(entryInfo.getCurrency().getId().toString());
            }
            if (entryInfo.getMaterial() == null) continue;
            mset.add(entryInfo.getMaterial().getId().toString());
        }
        if (mset.size() > 0) {
            materialMap = this.mapMaterialPrecision(ctx, mset);
        }
        Map<String, MultiMeasureUnitInfo> mmuConvsRate = this.putConvsRateToMap(ctx, info);
        Map<String, Integer> prcisionMap = this.cacheCurrencyPrecision(ctx, cset);
        cset.remove(baseCurrId);
        if (cset.size() > 0) {
            rateMap = this.cacheExchangeRate(ctx, cset, info);
        }
        IRowSet rs = this.getPurchaseGroupByUserId(ctx);
        try {
            if (rs.next()) {
                if (rs.getString("FPersonID") != null) {
                    personInfo = new PersonInfo();
                    personInfo.setId(BOSUuid.read((String)rs.getString("FPersonID")));
                }
                if (rs.getString("FPurGroupID") != null) {
                    purGroupInfo = new PurchaseGroupInfo();
                    purGroupInfo.setId(BOSUuid.read((String)rs.getString("FPurGroupID")));
                }
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        int size2 = info.getEntries().size();
        for (int i = 0; i < size2; ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getBaseUnit() == null || entryInfo.getRowType() == null) continue;
            if (entryInfo.getRowType().isIsHasMaterialNumber()) {
                if (entryInfo.getMaterial() == null) continue;
                if (entryInfo.getUnit() == null) {
                    entryInfo.setQty(entryInfo.getBaseQty());
                    entryInfo.setRequestQty(entryInfo.getBaseQty());
                }
                if (entryInfo.getMaterial() != null) {
                    if (entryInfo.getUnit() != null && !entryInfo.getBaseUnit().getId().toString().equals(entryInfo.getUnit().getId().toString())) {
                        targetQty = this.getTargetQtyByBaseQty(ctx, entryInfo.getMaterial(), entryInfo.getUnit(), entryInfo.getBaseQty(), mmuConvsRate);
                        entryInfo.setQty(targetQty);
                        entryInfo.setRequestQty(targetQty);
                    } else {
                        entryInfo.setQty(entryInfo.getBaseQty());
                        entryInfo.setRequestQty(entryInfo.getBaseQty());
                    }
                }
                if (materialMap != null && materialMap.containsKey(entryInfo.getMaterial().getId().toString())) {
                    priceScale = Integer.parseInt(materialMap.get(entryInfo.getMaterial().getId().toString()).toString());
                }
            } else {
                priceScale = entryInfo.getRowType().getPrecision();
                entryInfo.setUnit(entryInfo.getBaseUnit());
                entryInfo.setQty(entryInfo.getBaseQty());
                entryInfo.setRequestQty(entryInfo.getBaseQty());
                entryInfo.setAssistQty(BigDecimal.ZERO);
            }
            if (entryInfo.getLocalAmount() == null || entryInfo.getLocalAmount().compareTo(BigDecimal.ZERO) == 0) {
                entryInfo.setAmount(BigDecimal.ZERO);
                entryInfo.setPrice(BigDecimal.ZERO);
            }
            if (entryInfo.getCurrency() == null) {
                entryInfo.setCurrency(info.getCompanyOrgUnit().getBaseCurrency());
                entryInfo.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
            } else {
                if (!entryInfo.getCurrency().getId().toString().equals(baseCurrId)) {
                    if (rateMap != null && rateMap.containsKey(entryInfo.getCurrency().getId().toString()) && prcisionMap.containsKey(entryInfo.getCurrency().getId().toString())) {
                        rateInfo = rateMap.get(entryInfo.getCurrency().getId().toString());
                        currencyPrecision = Integer.parseInt(((Object)prcisionMap.get(entryInfo.getCurrency().getId().toString())).toString());
                        if (rateInfo.getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                            entryInfo.setAmount(entryInfo.getLocalAmount().divide(rateInfo.getConvertRate(), currencyPrecision, 4));
                        } else {
                            entryInfo.setAmount(entryInfo.getLocalAmount().multiply(rateInfo.getConvertRate()).setScale(currencyPrecision, 4));
                        }
                        entryInfo.setExchangeRate(rateInfo.getConvertRate());
                    }
                } else {
                    entryInfo.setAmount(entryInfo.getLocalAmount());
                    entryInfo.setExchangeRate(SCMConstant.BIGDECIMAL_ONE);
                }
                if (entryInfo.getQty() != null && entryInfo.getQty().compareTo(BigDecimal.ZERO) > 0 && entryInfo.getAmount() != null && entryInfo.getAmount().compareTo(BigDecimal.ZERO) > 0) {
                    entryInfo.setPrice(entryInfo.getAmount().divide(entryInfo.getQty(), priceScale, 4));
                }
                PurRequestCal purRequestCal = new PurRequestCal();
                purRequestCal.calByEntryPriceChange(info, entryInfo);
            }
            if (entryInfo.getPerson() == null && personInfo != null) {
                entryInfo.setPerson(personInfo);
            }
            entryInfo.setUnOrderedQty(entryInfo.getQty());
            entryInfo.setAssociateQty(entryInfo.getQty());
            entryInfo.setUnOrderedBaseQty(entryInfo.getBaseQty());
            entryInfo.setUnTotalReqQty(entryInfo.getQty());
            entryInfo.setBizDate(info.getBizDate());
            entryInfo.setCompanyOrgUnit(info.getCompanyOrgUnit().getId().toString());
            entryInfo.setMergeBillSeq(0);
            if (entryInfo.getProposeDeliveryDate() != null) continue;
            entryInfo.setProposeDeliveryDate(entryInfo.getRequirementDate());
        }
    }

    private void dealBillWithTransform(Context ctx, PurRequestInfo info) {
        UserInfo userInfo = new UserInfo();
        userInfo.setId(BOSUuid.read((String)ctx.getCaller().toString()));
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        info.setCreator(userInfo);
        info.setCreateTime(ts);
        if (info.getPerson() == null && info.getEntries() != null && info.getEntries().size() > 0) {
            info.setPerson(info.getEntries().get(0).getPerson());
        }
    }

    private void doWriteBackByMerge(Context ctx, PurRequestInfo info, IObjectCollection relationCol) throws BOSException {
        IObjectValue entryValue = null;
        BOTRelationInfo btpRelationInfo = null;
        if (relationCol == null || relationCol.size() == 0 || info == null) {
            return;
        }
        HashSet<String> srcEntryIdSet = new HashSet<String>();
        HashSet<String> srcIdSet = new HashSet<String>();
        HashSet<String> destIdSet = new HashSet<String>();
        HashMap<String, String> srcMap = new HashMap<String, String>();
        int size = relationCol.size();
        for (int i = 0; i < size; ++i) {
            btpRelationInfo = ((BOTRelationCollection)relationCol).get(i);
            srcIdSet.add(btpRelationInfo.getSrcObjectID());
            int count = btpRelationInfo.getRelationEntries().size();
            for (int j = 0; j < count; ++j) {
                entryValue = btpRelationInfo.getRelationEntries().getObject(j);
                if (entryValue == null) continue;
                srcMap.put(entryValue.get("srcentryid").toString(), entryValue.get("destentryid").toString());
                srcEntryIdSet.add(entryValue.get("srcentryid").toString());
                destIdSet.add(entryValue.get("destentryid").toString());
            }
        }
        if (srcEntryIdSet.size() > 0 && srcIdSet.size() > 0) {
            String entryids = PurUtil.setToString(srcEntryIdSet);
            StringBuilder sql = new StringBuilder();
            sql.append(" update T_sm_purrequestentry set fbasestatus = ").append(7);
            sql.append(" where fid in ").append(entryids);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            info.put("mergeSrcBillId", entryids);
            info.setIsMergeBill(true);
            String parentids = PurUtil.setToString(srcIdSet);
            sql.setLength(0);
            sql.append(" update T_sm_purrequest set fbasestatus = ").append(7);
            sql.append(" where fid in ").append(parentids);
            sql.append(" and fid not in (select fparentid from T_sm_purrequestentry where fbasestatus<>7 and fparentid in");
            sql.append(parentids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            String updateSrcMergeBillEntryIdSql = "update T_SM_PURREQUESTENTRY set FMergeBillEntryId = ? where FID = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            for (String key : srcMap.keySet()) {
                params.add(new Object[]{srcMap.get(key), key});
            }
            DbUtil.executeBatch((Context)ctx, (String)updateSrcMergeBillEntryIdSql, params);
        }
    }

    private void insertDataToPurWorkTable(Context ctx, PurRequestInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        Connection conn = null;
        Statement ps = null;
        String personId = "";
        String orgId = "";
        if (info.getEntries().get(0) != null) {
            if (info.getEntries().get(0).getPurchaseOrgUnit() != null) {
                orgId = info.getEntries().get(0).getPurchaseOrgUnit().getId().toString();
            }
            if (info.getEntries().get(0).getPurchasePerson() != null) {
                personId = info.getEntries().get(0).getPurchasePerson().getId().toString();
            }
        }
        if (StringUtils.isEmpty((String)personId) || StringUtils.isEmpty((String)personId)) {
            return;
        }
        try {
            StringBuilder sql = new StringBuilder();
            String tableName = "T_SM_PurPersonWorkBench";
            sql.append("insert into ").append(tableName).append(" (FID,FPurOrgID,FType,FPersonID) Values(?,?,?,?)");
            conn = this.getConnection(ctx);
            ps = conn.prepareStatement(sql.toString());
            int size = info.getEntries().size();
            for (int i = 0; i < size; ++i) {
                ps.setString(1, info.getEntries().get(i).getId().toString());
                ps.setString(2, orgId);
                ps.setInt(3, 0);
                ps.setString(4, personId);
                ps.addBatch();
            }
            ps.executeBatch();
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }

    private BigDecimal getTargetQtyByBaseQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo otherUnitInfo, BigDecimal baseQty, Map<String, MultiMeasureUnitInfo> mmuConvsRate) throws BOSException, EASBizException {
        Object multiUnifInfo = null;
        MultiMeasureUnitInfo othermultiUnifInfo = null;
        if (materialInfo == null) {
            throw new IllegalArgumentException();
        }
        String materialID = materialInfo.getId().toString();
        if (otherUnitInfo == null || baseQty == null || baseQty.compareTo(SysConstant.BIGZERO) == 0 || mmuConvsRate == null) {
            return SysConstant.BIGZERO;
        }
        BigDecimal targetQty = SysConstant.BIGZERO;
        BigDecimal baseExchangeRate = SCMConstant.BIGDECIMAL_ONE;
        if (mmuConvsRate.containsKey(materialID + otherUnitInfo.getId().toString())) {
            if (mmuConvsRate.get(materialID + otherUnitInfo.getId().toString()) != null) {
                othermultiUnifInfo = mmuConvsRate.get(materialID + otherUnitInfo.getId().toString());
                baseExchangeRate = othermultiUnifInfo.getBaseConvsRate();
            }
            if (baseExchangeRate == null) {
                baseExchangeRate = SCMConstant.BIGDECIMAL_ONE;
            }
            int scale = 10;
            if (othermultiUnifInfo != null) {
                scale = othermultiUnifInfo.getQtyPrecision();
            }
            targetQty = baseQty.divide(baseExchangeRate, scale, 4);
        }
        return targetQty;
    }

    private Map<String, MultiMeasureUnitInfo> putConvsRateToMap(Context ctx, PurRequestInfo info) throws BOSException {
        PurRequestEntryInfo entryInfo = null;
        HashSet<String> mset = new HashSet<String>();
        HashSet<String> uset = new HashSet<String>();
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            if (entryInfo.getBaseUnit() == null || entryInfo.getMaterial() == null) continue;
            if (entryInfo.getMaterial() != null) {
                mset.add(entryInfo.getMaterial().getId().toString());
            }
            if (entryInfo.getUnit() != null && !entryInfo.getUnit().getId().toString().equals(entryInfo.getBaseUnit().getId().toString())) {
                uset.add(entryInfo.getUnit().getId().toString());
            }
            if (entryInfo.getAssistUnit() == null || entryInfo.getAssistUnit().getId().toString().equals(entryInfo.getBaseUnit().getId().toString())) continue;
            uset.add(entryInfo.getAssistUnit().getId().toString());
        }
        if (mset.size() > 0 && uset.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("material.id", mset, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", uset, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("material.id"));
            sic.add(new SelectorItemInfo("measureUnit.id"));
            sic.add(new SelectorItemInfo("qtyPrecision"));
            sic.add(new SelectorItemInfo("baseConvsRate"));
            view.setSelector(sic);
            MultiMeasureUnitCollection multiColl = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
            MultiMeasureUnitInfo multiUnifInfo = null;
            if (multiColl != null && multiColl.size() > 0) {
                HashMap<String, MultiMeasureUnitInfo> mmuConvsRate = new HashMap<String, MultiMeasureUnitInfo>();
                int size2 = multiColl.size();
                for (int i = 0; i < size2; ++i) {
                    multiUnifInfo = multiColl.get(i);
                    if (multiUnifInfo.getMaterial() == null || multiUnifInfo.getMeasureUnit() == null || mmuConvsRate.containsKey(multiUnifInfo.getMaterial().getId().toString() + multiUnifInfo.getMeasureUnit().getId().toString())) continue;
                    mmuConvsRate.put(multiUnifInfo.getMaterial().getId().toString() + multiUnifInfo.getMeasureUnit().getId().toString(), multiUnifInfo);
                }
                return mmuConvsRate;
            }
        }
        return null;
    }

    private Map<String, Integer> cacheCurrencyPrecision(Context ctx, Set<String> cset) throws BOSException {
        if (cset == null || cset.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", cset, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("precision"));
        view.setSelector(selector);
        CurrencyCollection currencys = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
        if (currencys != null && currencys.size() > 0) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int k = 0; k < currencys.size(); ++k) {
                map.put(currencys.get(k).getId().toString(), currencys.get(k).getPrecision());
            }
            return map;
        }
        return null;
    }

    private Map<String, Integer> mapMaterialPrecision(Context ctx, Set<String> mset) throws BOSException {
        if (mset == null || mset.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", mset, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("pricePrecision"));
        view.setSelector(sic);
        MaterialCollection coll = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        HashMap<String, Integer> materialMap = new HashMap<String, Integer>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            materialMap.put(coll.get(i).getId().toString(), new Integer(coll.get(i).getPricePrecision()));
        }
        return materialMap;
    }

    private Map<String, ExchangeRateInfo> cacheExchangeRate(Context ctx, Set<String> cset, PurRequestInfo info) throws BOSException {
        ExchangeRateInfo rateInfo = null;
        ExchangeTableInfo exchangeTableInfo = info.getCompanyOrgUnit().getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)excTablepk.toString()));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", cset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)info.getCompanyOrgUnit().getBaseCurrency().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"0"));
        filter.setMaskString("#0 and #1 and #2 and #3");
        evi.setFilter(filter);
        SorterItemInfo sortItem = new SorterItemInfo("availTime");
        sortItem.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortItem);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("convertRate"));
        evi.getSelector().add(new SelectorItemInfo("precision"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.id"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.sourceCurrency.id"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.sourceCurrency.precision"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
        evi.getSelector().add(new SelectorItemInfo("exchangeAux.targetCurrency.precision"));
        ExchangeRateCollection vos = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateCollection(evi);
        if (vos != null && vos.size() > 0) {
            HashMap<String, ExchangeRateInfo> map = new HashMap<String, ExchangeRateInfo>();
            int size = vos.size();
            for (int i = 0; i < size; ++i) {
                rateInfo = vos.get(i);
                if (map.containsKey(rateInfo.getExchangeAux().getSourceCurrency().getId().toString())) continue;
                map.put(rateInfo.getExchangeAux().getSourceCurrency().getId().toString(), rateInfo);
            }
            return map;
        }
        return null;
    }

    private IRowSet getPurchaseGroupByUserId(Context ctx) throws BOSException {
        IObjectPK upk = ctx.getCaller();
        StringBuilder sql = new StringBuilder();
        sql.append("select pp.FPersonID as FPersonID,pp.FPurGroupID as FPurGroupID from T_PM_USER u ");
        sql.append("inner join T_BD_Person p on p.FID = u.FPersonID ");
        sql.append("inner join T_BD_PurchasePerson pp on pp.FPersonID = p.FID ");
        sql.append("where u.FID = ? and pp.FDeletedStatus = 1");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{upk.toString()});
        return rs;
    }

    @Override
    protected Map _creatToPurOrderForWeb(Context ctx, String purchaseType, Map idMap) throws BOSException, EASBizException {
        String billId = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)purchaseType) || idMap == null || idMap.size() == 0) {
            return null;
        }
        try {
            Iterator iterator = idMap.keySet().iterator();
            if (iterator.hasNext()) {
                billId = iterator.next().toString();
            }
            String destBosTypeID = null;
            if (purchaseType.equals("0")) {
                destBosTypeID = "3171BFAD";
            } else if (purchaseType.equals("1")) {
                destBosTypeID = "F99EE589";
            }
            BOTMappingCollection botColl = this.getBTPMappingCollection(ctx, billId, destBosTypeID);
            if (botColl == null || botColl.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            String[] idList = new String[idMap.size()];
            ArrayList<String> entryids = new ArrayList<String>();
            iterator = idMap.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                idList[i] = billId = iterator.next().toString();
                String entryId = idMap.get(billId).toString();
                String[] strIds = entryId.split(",");
                int count = strIds.length;
                for (int j = 0; j < count; ++j) {
                    entryids.add(strIds[j]);
                }
                ++i;
            }
            if (botColl.size() == 1) {
                BOTMappingInfo mappingInfo = botColl.get(0);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(idList, new String[]{"entries"}, entryids, null, mappingInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), mappingInfo.getSrcEntityName());
                IObjectCollection objColl = btpResult.getBills();
                StringBuilder billNumber = new StringBuilder();
                int size = objColl.size();
                for (int j = 0; j < size; ++j) {
                    billNumber.append(objColl.getObject(j).getString("number"));
                    if (j >= size - 1) continue;
                    if (ctx.getLocale() == LocaleUtils.locale_L2) {
                        billNumber.append("\u3001");
                        continue;
                    }
                    billNumber.append(",");
                }
                map.put("billNumber", billNumber.toString());
            } else {
                map.put("botMapColl", botColl);
                map.put("billIds", idList);
                map.put("entryIds", entryids);
                map.put("purchaseType", purchaseType);
            }
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
        }
        return map;
    }

    @Override
    protected Map _handleMergeForWeb(Context ctx, String orgId, Map idMap) throws BOSException, EASBizException {
        String billId = "";
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)orgId) || idMap == null || idMap.size() == 0) {
            return null;
        }
        try {
            BOTMappingCollection botColl;
            IObjectPK userPK = ctx.getCaller();
            PermissionFactory.getRemoteInstance().checkFunctionPermission(userPK, OrgType.Purchase, (IObjectPK)new ObjectUuidPK(orgId), "purPersonWorkBench_merge");
            String flag = this.filterHasDestBill(ctx, idMap);
            Iterator iterator = idMap.keySet().iterator();
            if (iterator.hasNext()) {
                billId = iterator.next().toString();
            }
            if ((botColl = this.getBTPMappingCollection(ctx, billId, "25428F2E")) == null || botColl.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            String[] idList = new String[idMap.size()];
            ArrayList<String> entryids = new ArrayList<String>();
            iterator = idMap.keySet().iterator();
            int i = 0;
            while (iterator.hasNext()) {
                idList[i] = billId = iterator.next().toString();
                String entryId = idMap.get(billId).toString();
                String[] strIds = entryId.split(",");
                int count = strIds.length;
                for (int j = 0; j < count; ++j) {
                    entryids.add(strIds[j]);
                }
                ++i;
            }
            if (botColl.size() == 1) {
                BOTMappingInfo mappingInfo = botColl.get(0);
                BTPTransformResult btpResult = BTPManagerFactory.getLocalInstance((Context)ctx).transformForBotp(idList, new String[]{"entries"}, entryids, null, mappingInfo.getDestEntityName(), (IObjectPK)new ObjectUuidPK(mappingInfo.getId()), mappingInfo.getSrcEntityName());
                IObjectCollection objColl = btpResult.getBills();
                StringBuilder billNumber = new StringBuilder();
                int size = objColl.size();
                for (int j = 0; j < size; ++j) {
                    billNumber.append(objColl.getObject(j).getString("number"));
                    if (j >= size - 1) continue;
                    if (ctx.getLocale() == LocaleUtils.locale_L2) {
                        billNumber.append("\u3001");
                        continue;
                    }
                    billNumber.append(",");
                }
                map.put("billNumber", billNumber.toString());
            } else {
                map.put("botMapColl", botColl);
                map.put("billIds", idList);
                map.put("entryIds", entryids);
            }
            if (!StringUtils.isEmpty((String)flag)) {
                map.put("HasDestBill", "HasDestBill");
            }
        }
        catch (Exception e) {
            map.put("error", e.getMessage());
        }
        return map;
    }

    private BOTMappingCollection getBTPMappingCollection(Context ctx, String id, String destBosTypeID) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("cu.id"));
        PurRequestInfo info = this.getPurRequestInfo(ctx, (IObjectPK)new ObjectUuidPK(id), selector);
        if (info != null && info.getCU() != null) {
            BOSObjectType sourceBosType = new BOSObjectType("25428F2E");
            BOSObjectType destBosType = new BOSObjectType(destBosTypeID);
            String cuID = info.getCU().getId().toString();
            BOTMappingCollection botMappingCol = SCMUtil.getBotpMappingCollection(null, (BOSObjectType)sourceBosType, (BOSObjectType)destBosType, (String)cuID);
            if (botMappingCol == null || botMappingCol.size() == 0) {
                throw new BTPException(BTPException.GETMAPPINGINFOERROR);
            }
            return botMappingCol;
        }
        return null;
    }

    private String filterHasDestBill(Context ctx, Map idMap) throws EASBizException, BOSException {
        String billId = "";
        if (idMap == null || idMap.size() == 0) {
            return "";
        }
        HashSet<String> idSet = new HashSet<String>();
        Iterator itor = idMap.keySet().iterator();
        while (itor.hasNext()) {
            idSet.add(itor.next().toString());
        }
        if (idSet.size() > 0) {
            StringBuilder sql = new StringBuilder();
            sql.append("select FSrcObjectID from T_BOT_Relation where FSrcObjectID in ").append(PurUtil.setToString(idSet));
            sql.append(" and FSRCENTITYID = '").append("25428F2E").append("' and FDESTENTITYID <> '").append("25428F2E").append("'");
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                if (rs != null && rs.size() > 0) {
                    HashMap<String, String> hasDestIdMap = new HashMap<String, String>();
                    while (rs.next()) {
                        hasDestIdMap.put(rs.getString("FSrcObjectID"), rs.getString("FSrcObjectID"));
                    }
                    if (hasDestIdMap.size() > 0) {
                        if (hasDestIdMap.size() == idMap.size()) {
                            throw new PurReqException(PurReqException.MERGE_ERROR);
                        }
                        Iterator iterator = idSet.iterator();
                        while (iterator.hasNext()) {
                            billId = iterator.next().toString();
                            if (!hasDestIdMap.containsKey(billId)) continue;
                            idMap.remove(billId);
                        }
                        return "HasDestBill";
                    }
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return "";
    }

    @Override
    protected Map _getDefaultPurOrg(Context ctx, Object purParamVo) throws BOSException, EASBizException {
        if (purParamVo == null || !(purParamVo instanceof ReqParamDataVO)) {
            return null;
        }
        ReqParamDataVO paramVo = (ReqParamDataVO)purParamVo;
        IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
        RowTypeInfo rowType = null;
        if (!StringUtils.isEmpty((String)paramVo.getDemandTypeID())) {
            DemandTypeInfo demandType = PurUtil.getDemandType(ctx, paramVo.getDemandTypeID());
            rowType = demandType.getRowType();
        }
        return this.getDefaultOrgMap(ctx, paramVo, rowType, this.getPurRightSql(ctx, purParamVo, rowType), true);
    }

    @Override
    protected Map _getPurRightPurOrg(Context ctx, Object purParamVo) throws BOSException, EASBizException {
        if (purParamVo == null || !(purParamVo instanceof ReqParamDataVO)) {
            return null;
        }
        ReqParamDataVO paramVo = (ReqParamDataVO)purParamVo;
        IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
        RowTypeInfo rowType = null;
        if (!StringUtils.isEmpty((String)paramVo.getDemandTypeID())) {
            DemandTypeInfo demandType = PurUtil.getDemandType(ctx, paramVo.getDemandTypeID());
            rowType = demandType.getRowType();
        }
        return this.getDefaultOrgMap(ctx, paramVo, rowType, this.getPurRightSql(ctx, purParamVo, rowType), false);
    }

    private StringBuffer getPurRightSql(Context ctx, Object purParamVo, RowTypeInfo rowType) throws EASBizException, BOSException {
        ReqParamDataVO paramVo = (ReqParamDataVO)purParamVo;
        if ((paramVo.getMaterialList() == null || paramVo.getMaterialList().size() == 0) && StringUtil.isEmptyString((String)paramVo.getMaterialName()) || StringUtil.isEmptyString((String)paramVo.getDemandTypeID()) || StringUtil.isEmptyString((String)paramVo.getStorageOrgID()) && StringUtil.isEmptyString((String)paramVo.getReqAdminOrgUnitID())) {
            return null;
        }
        boolean isHasMaterialNum = rowType != null && rowType.isIsHasMaterialNumber();
        boolean isStorage = rowType != null && rowType.getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT;
        StringBuffer materialIds = new StringBuffer();
        if (isHasMaterialNum) {
            for (int i = 0; i < paramVo.getMaterialList().size(); ++i) {
                materialIds.append("'" + paramVo.getMaterialList().get(i) + "',");
            }
            materialIds.setLength(materialIds.length() - 1);
        }
        StringBuffer sql = new StringBuffer();
        String select = "select max(purR.FAmount) FAmount, purR.FPurchaseOrgUnitID purOrgId";
        StringBuffer commonWhere = new StringBuffer();
        commonWhere.append("where purR.FDemandTypeId = '" + paramVo.getDemandTypeID() + "'");
        if (isStorage) {
            commonWhere.append(" and  purR.FStorageOrgUnitID = '" + paramVo.getStorageOrgID() + "'");
        } else {
            commonWhere.append(" and  purR.FAdminOrgUnitID = '" + paramVo.getReqAdminOrgUnitID() + "'");
        }
        commonWhere.append(" and purR.FStatus = 1");
        if (paramVo.getLocalAmount().compareTo(BigDecimal.ZERO) > 0) {
            commonWhere.append(" and purR.FAmount <= ").append(paramVo.getLocalAmount());
            commonWhere.append(" and purR.FAmount >0 ");
        } else {
            commonWhere.append(" and purR.FAmount = 0 ");
        }
        String AllWhere = " (purR.FMaterialGroupID is null and purR.FMaterialID is null) ";
        if (isHasMaterialNum) {
            sql.append("select * from (");
            sql.append(select + ",purR.FMaterialID materialId, 0 isMaterialByGroup");
            sql.append(" from T_SM_PurRightStrategy purR");
            sql.append(this.getSelectByMaterial(isHasMaterialNum));
            sql.append(commonWhere).append(" and (purR.FMaterialID in (" + materialIds.toString() + ") or " + AllWhere + ") ");
            sql.append(" group by  purR.FPurchaseOrgUnitID ,purR.FMaterialID ");
            sql.append(" union \n");
            sql.append(select + ",gDetail.FMaterialID materialId, 1 isMaterialByGroup");
            sql.append(" from T_SM_PurRightStrategy purR");
            sql.append(this.getSelectByMaterialGroup());
            sql.append(commonWhere).append(" and gDetail.FMaterialID in (" + materialIds.toString() + ") ");
            sql.append(" group by  purR.FPurchaseOrgUnitID ,gDetail.FMaterialID ");
            sql.append(") as temp ");
        } else {
            sql.append(select + ",purR.FMaterialName materialName");
            sql.append(" from T_SM_PurRightStrategy purR");
            sql.append(this.getSelectByMaterial(isHasMaterialNum));
            sql.append(commonWhere).append(" and purR.FMaterialName = '" + paramVo.getMaterialName() + "'");
            sql.append(" group by  purR.FPurchaseOrgUnitID ,purR.FMaterialName ");
        }
        return sql;
    }

    private Map getDefaultOrgMap(Context ctx, ReqParamDataVO paramVo, RowTypeInfo rowType, StringBuffer sql, boolean isNeedDefaultOrg) throws BOSException, EASBizException {
        boolean isHasMaterialNum = rowType != null && rowType.isIsHasMaterialNumber();
        HashMap<String, OrgUnitInfo> defaultMap = new HashMap<String, OrgUnitInfo>();
        if (sql == null) {
            return null;
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        OrgUnitInfo defaultPurOrg = null;
        try {
            String materialId = null;
            if (isHasMaterialNum) {
                for (int i = 0; i < paramVo.getMaterialList().size(); ++i) {
                    materialId = paramVo.getMaterialList().get(i);
                    rs.beforeFirst();
                    defaultPurOrg = this.getRealOrg(ctx, rs, materialId, rowType, paramVo, isNeedDefaultOrg);
                    defaultMap.put(materialId, defaultPurOrg);
                }
            } else {
                rs.beforeFirst();
                defaultPurOrg = this.getRealOrg(ctx, rs, materialId, rowType, paramVo, isNeedDefaultOrg);
                defaultMap.put(paramVo.getMaterialName(), defaultPurOrg);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return defaultMap;
    }

    private OrgUnitInfo getRealOrg(Context ctx, IRowSet rs, String materialId, RowTypeInfo rowType, ReqParamDataVO paramVo, boolean isNeedDefaultOrg) throws EASBizException, BOSException, SQLException {
        String defaultPurorgid = paramVo.getPurchaseOrgID();
        String rsMaterialId = null;
        TreeMap<BigDecimal, String> dValueByMaterial = new TreeMap<BigDecimal, String>();
        TreeMap<BigDecimal, String> dValueByGroupMateial = new TreeMap<BigDecimal, String>();
        TreeMap<BigDecimal, String> dValueByNull = new TreeMap<BigDecimal, String>();
        String realOrgId = null;
        Object relationOrgInfo = null;
        OrgUnitInfo defaultPurOrg = null;
        boolean isHasMaterialNum = rowType != null && rowType.isIsHasMaterialNumber();
        boolean isStorage = rowType != null && rowType.getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT;
        String purOrgId = null;
        BigDecimal price = null;
        while (rs.next()) {
            purOrgId = rs.getString("purOrgId");
            price = rs.getBigDecimal("FAmount");
            if (isHasMaterialNum) {
                rsMaterialId = rs.getString("materialId");
                if (rsMaterialId != null && rsMaterialId.equals(materialId)) {
                    if (rs.getString("isMaterialByGroup").equals("0")) {
                        dValueByMaterial.put(price, purOrgId);
                        break;
                    }
                    if (!rs.getString("isMaterialByGroup").equals("1")) continue;
                    dValueByGroupMateial.put(price, purOrgId);
                    continue;
                }
                if (rsMaterialId != null) continue;
                dValueByNull.put(price, purOrgId);
                continue;
            }
            if (rs.getString("materialName") != null && rs.getString("materialName").equals(paramVo.getMaterialName())) {
                dValueByMaterial.put(price, purOrgId);
                continue;
            }
            dValueByNull.put(price, purOrgId);
        }
        if (dValueByMaterial != null && dValueByMaterial.size() > 0) {
            realOrgId = this.getOrgId(dValueByMaterial);
        } else if (dValueByGroupMateial != null && dValueByGroupMateial.size() > 0) {
            realOrgId = this.getOrgId(dValueByGroupMateial);
        } else if (dValueByNull != null && dValueByNull.size() > 0) {
            realOrgId = this.getOrgId(dValueByNull);
        }
        if (realOrgId == null && isNeedDefaultOrg) {
            if (relationOrgInfo == null) {
                defaultPurOrg = this.getDefaultRelationOrg(ctx, paramVo, isStorage, materialId);
            }
        } else if (realOrgId != null) {
            if (this.orgMap.containsKey(realOrgId)) {
                defaultPurOrg = this.orgMap.get(realOrgId);
            } else {
                defaultPurOrg = this.getPurOrg(ctx, realOrgId);
                this.orgMap.put(realOrgId, defaultPurOrg);
            }
        }
        return defaultPurOrg;
    }

    private boolean checkMaterialPurchasing(Context ctx, String materialId, String purorgid) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select 1 from T_BD_MaterialPurchasing where FmaterialID ='").append(materialId);
        sql.append("' and forgUnit = '").append(purorgid);
        sql.append("' and fstatus =1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rowSet.size() > 0;
    }

    private String getOrgId(TreeMap<BigDecimal, String> dValueByMaterial) {
        Object[] keys = dValueByMaterial.keySet().toArray();
        Arrays.sort(keys);
        String realOrgId = dValueByMaterial.get(keys[keys.length - 1]);
        return realOrgId;
    }

    private OrgUnitInfo getDefaultRelationOrg(Context ctx, ReqParamDataVO paramVo, boolean isStorage, String materialId) throws BOSException, EASBizException {
        OrgUnitInfo relationOrgInfo;
        block13: {
            int i;
            int size;
            String fromOrgId;
            int fromOrgType;
            IOrgUnitRelation iRelation;
            OrgUnitCollection orgcol;
            String defaultPurorgid;
            block14: {
                int i2;
                int size2;
                defaultPurorgid = paramVo.getPurchaseOrgID();
                if (StringUtil.isEmptyString((String)defaultPurorgid) || !this.checkMaterialPurchasing(ctx, materialId, defaultPurorgid)) {
                    defaultPurorgid = null;
                }
                relationOrgInfo = null;
                Object relationOrgInfo2 = null;
                orgcol = null;
                iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                fromOrgType = isStorage ? 4 : 0;
                String string = fromOrgId = isStorage ? paramVo.getStorageOrgID() : paramVo.getReqAdminOrgUnitID();
                if (!isStorage) break block14;
                if (!StringUtil.isEmptyString((String)defaultPurorgid)) {
                    orgcol = iRelation.getToUnit(fromOrgId, fromOrgType, 3);
                    size2 = orgcol.size();
                    for (i2 = 0; i2 < size2; ++i2) {
                        if (!defaultPurorgid.equals(orgcol.get(i2).getId().toString())) continue;
                        relationOrgInfo = orgcol.get(i2);
                        break;
                    }
                }
                if (relationOrgInfo == null && (relationOrgInfo = iRelation.getDefaultToUnit(fromOrgId, fromOrgType, 3)) != null && !this.checkMaterialPurchasing(ctx, materialId, relationOrgInfo.getId().toString())) {
                    relationOrgInfo = null;
                }
                if (relationOrgInfo != null) break block13;
                if (orgcol == null) {
                    orgcol = iRelation.getToUnit(fromOrgId, fromOrgType, 3);
                }
                size2 = orgcol.size();
                for (i2 = 0; i2 < size2; ++i2) {
                    if (!this.checkMaterialPurchasing(ctx, materialId, orgcol.get(i2).getId().toString())) continue;
                    relationOrgInfo = orgcol.get(i2);
                    break block13;
                }
                break block13;
            }
            orgcol = iRelation.getToUnit(fromOrgId, fromOrgType, 3);
            if (!StringUtil.isEmptyString((String)defaultPurorgid)) {
                size = orgcol.size();
                for (i = 0; i < size; ++i) {
                    if (!defaultPurorgid.equals(orgcol.get(i).getId().toString())) continue;
                    relationOrgInfo = orgcol.get(i);
                    break;
                }
            }
            if (relationOrgInfo != null && !StringUtil.isEmptyString((String)defaultPurorgid)) {
                if (this.checkMaterialPurchasing(ctx, materialId, relationOrgInfo.getId().toString())) {
                    relationOrgInfo = null;
                }
                size = orgcol.size();
                for (i = 0; i < size; ++i) {
                    if (!fromOrgId.equals(orgcol.get(i).getId().toString())) continue;
                    if (!this.checkMaterialPurchasing(ctx, materialId, fromOrgId)) break;
                    relationOrgInfo = orgcol.get(i);
                    break;
                }
            }
            if (relationOrgInfo == null) {
                size = orgcol.size();
                for (i = 0; i < size; ++i) {
                    if (!this.checkMaterialPurchasing(ctx, materialId, orgcol.get(i).getId().toString())) continue;
                    relationOrgInfo = orgcol.get(i);
                    break;
                }
            }
        }
        return relationOrgInfo;
    }

    private PurchaseOrgUnitInfo getPurOrg(Context ctx, String orgId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        return PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
    }

    private String getSelectByMaterial(boolean isHasMaterialNum) {
        StringBuffer select = new StringBuffer();
        select.append(" inner join T_SM_DemandType dType on purR.FDemandTypeID = dType.fid \n");
        if (isHasMaterialNum) {
            select.append(" inner join t_org_storage storage on storage.fid = purR.FStorageOrgUnitID \n");
        } else {
            select.append(" inner join t_org_admin orgadmin on orgadmin.fid = purR.FAdminOrgUnitID \n");
        }
        return select.toString();
    }

    private String getSelectByMaterialGroup() {
        StringBuffer select = new StringBuffer();
        select.append(" inner join T_BD_MaterialGroupDetial gDetail on gDetail.FMaterialGroupStandardID = purR.FMaterialStandardID \n");
        select.append(" inner join T_BD_Material material on material.fid = gDetail.FMaterialID \n");
        select.append(" inner join T_BD_MaterialGroup mGroup on mGroup.fid = purR.FMaterialGroupID and purR.FMaterialGroupID = gDetail.fMaterialGroupId \n");
        select.append(" inner join T_SM_DemandType dType on purR.FDemandTypeID = dType.fid \n");
        return select.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryInventoryByMaterial(Context ctx, Map paramMap) throws BOSException, EASBizException {
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        HashMap dataMap = new HashMap();
        try {
            String sql = this.getQuerySql(paramMap);
            con = this.getConnection(ctx);
            pstmt = con.prepareStatement(sql);
            rs = pstmt.executeQuery();
            ArrayList<LinkedTreeMap> records = new ArrayList<LinkedTreeMap>();
            LinkedTreeMap row = null;
            while (rs.next()) {
                row = new LinkedTreeMap();
                row.put((Object)"entrySOU", rs.getObject("FStorageOrgUnitID"));
                row.put((Object)"warehouse", rs.getObject("FWarehouseID"));
                row.put((Object)"location", rs.getObject("FLocationID"));
                row.put((Object)"storeType", rs.getObject("FStoreTypeID"));
                row.put((Object)"storeState", rs.getObject("FStoreStatusID"));
                row.put((Object)"entryLot", rs.getObject("FLot"));
                row.put((Object)"mfg", rs.getObject("FMFG"));
                row.put((Object)"exp", rs.getObject("FEXP"));
                row.put((Object)"supplier", rs.getObject("FSupplierID"));
                row.put((Object)"customer", rs.getObject("FCustomerID"));
                row.put((Object)"unit", rs.getObject("FUnitID"));
                row.put((Object)"curStoreQty", rs.getObject("FCurStoreQty"));
                row.put((Object)"curStoreAssistQty", rs.getObject("FCurStoreAssistQty"));
                row.put((Object)"curStoreBaseQty", rs.getObject("FBaseQty"));
                row.put((Object)"entryAssistProp", rs.getObject("FAssistPropertyID"));
                row.put((Object)"project", rs.getObject("FProjectID"));
                row.put((Object)"trackNumber", rs.getObject("FTrackNumberID"));
                row.put((Object)"warehouseIDpk_hide", rs.getObject("FWarehouseIDpk_hide"));
                row.put((Object)"supplierIDpk_hide", rs.getObject("FSupplierIDpk_hide"));
                row.put((Object)"assistPropertyIDpk_hide", rs.getObject("FAssistPropertyIDpk_hide"));
                row.put((Object)"unitIDpk_hide", rs.getObject("FUnitIDpk_hide"));
                row.put((Object)"multiBaseUnitQtyPrecision", rs.getObject("MULTIBASEUNITQTYPRECISION"));
                row.put((Object)"multiAssistUnitQtyPrecision", rs.getObject("MULTIASSISTUNITQTYPRECISION"));
                row.put((Object)"multiUnitQtyPrecision", rs.getObject("MULTIUNITQTYPRECISION"));
                records.add(row);
            }
            dataMap.put("gridData", records);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    logger.error((Object)e2.getMessage(), (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)con);
        return dataMap;
    }

    private void cacheUnit(List infoList, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("isBaseUnit"));
        view.getSelector().add(new SelectorItemInfo("coefficient"));
        MeasureUnitCollection col = MeasureUnitFactory.getRemoteInstance().getMeasureUnitCollection(view);
        if (col != null && col.size() > 0) {
            infoList.add(col.get(0));
        }
    }

    private void cacheAssistPorp(List infoList, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        AsstAttrValueCollection col = AsstAttrValueFactory.getRemoteInstance().getAsstAttrValueCollection(view);
        if (col != null && col.size() > 0) {
            infoList.add(col.get(0));
        }
    }

    private void cacheSupplier(List infoList, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        SupplierCollection col = SupplierFactory.getRemoteInstance().getSupplierCollection(view);
        if (col != null && col.size() > 0) {
            infoList.add(col.get(0));
        }
    }

    private void cacheWarehouse(List infoList, String id) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        WarehouseCollection col = WarehouseFactory.getRemoteInstance().getWarehouseCollection(view);
        if (col != null && col.size() > 0) {
            infoList.add(col.get(0));
        }
    }

    private String getQuerySql(Map paramMap) throws Exception {
        String storageOrgUnitID = null;
        String materialID = null;
        String unitID = null;
        String assistPropertyID = null;
        String lot = null;
        String baseUnitID = null;
        String assistUnitID = null;
        if (paramMap.get("storageOrgUnitID") != null) {
            storageOrgUnitID = (String)paramMap.get("storageOrgUnitID");
        }
        if (paramMap.get("materialID") != null) {
            materialID = (String)paramMap.get("materialID");
        }
        if (paramMap.get("unitID") != null) {
            unitID = (String)paramMap.get("unitID");
        }
        if (paramMap.get("baseUnitID") != null) {
            baseUnitID = (String)paramMap.get("baseUnitID");
        }
        if (paramMap.get("assistUnitID") != null) {
            assistUnitID = (String)paramMap.get("assistUnitID");
        }
        if (paramMap.get("assistPropertyID") != null) {
            assistPropertyID = (String)paramMap.get("assistPropertyID");
        }
        if (paramMap.get("lot") != null) {
            lot = (String)paramMap.get("lot");
        }
        StringBuilder sqlSelect = this.getDefaultSelectSQL();
        StringBuilder sqlFrom = this.getDefaultFromSQL();
        StringBuilder sqlWhere = this.getDefaultWhereSQL();
        if (!StringUtil.isEmptyString((String)storageOrgUnitID)) {
            sqlWhere.append(" AND inventory.FStorageOrgUnitID= '" + storageOrgUnitID + "'");
        }
        if (StringUtil.isEmptyString((String)materialID)) {
            throw new InvBizException(InvBizException.MATERIAL_IS_NULL);
        }
        sqlWhere.append(" AND inventory.FMaterialID= '" + materialID + "'");
        if (!StringUtil.isEmptyString((String)unitID)) {
            sqlWhere.append(" AND inventory.FUnitID= '" + unitID + "'");
        }
        if (!StringUtil.isEmptyString((String)assistPropertyID)) {
            sqlWhere.append(" AND inventory.FAssistPropertyID= '" + assistPropertyID + "'");
        }
        if (!StringUtil.isEmptyString((String)baseUnitID)) {
            sqlWhere.append(" AND inventory.FBaseUnitID= '" + baseUnitID + "'");
        }
        if (!StringUtil.isEmptyString((String)assistUnitID)) {
            sqlWhere.append(" AND inventory.FAssistUnitID= '" + assistUnitID + "'");
        }
        if (!StringUtil.isEmptyString((String)lot)) {
            sqlWhere.append(" AND inventory.FLot= '" + lot + "'");
        }
        StringBuilder querySql = new StringBuilder();
        querySql.append((CharSequence)sqlSelect).append((CharSequence)sqlFrom);
        this.initPermissionSQL(storageOrgUnitID);
        if (!StringUtil.isEmptyString((String)this.permissionJoinSQL)) {
            querySql.append(this.permissionJoinSQL);
        }
        querySql.append((CharSequence)sqlWhere);
        if (!StringUtil.isEmptyString((String)this.permissionSQL)) {
            querySql.append(" and ").append(this.permissionSQL);
        }
        return querySql.toString();
    }

    private StringBuilder getDefaultSelectSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT INVENTORY.FID AS FID, \r\n");
        sb.append(" MATERIAL.FAssistAttr AS MATERIALASSISTATTR,  \r\n");
        sb.append(" STORAGEORGUNIT.FID AS FStorageOrgUnitIDpk_hide, \r\n");
        sb.append(" STORAGEORGUNIT.FName_").append(this.loc).append(" AS FStorageOrgUnitID,  \r\n");
        sb.append(" WAREHOUSE.FName_").append(this.loc).append(" AS FWarehouseID, \r\n");
        sb.append(" LOCATION.FName_").append(this.loc).append(" AS FLocationID,  \r\n");
        sb.append(" STORETYPE.FName_").append(this.loc).append(" AS FStoreTypeID,  \r\n");
        sb.append(" UNIT.FName_").append(this.loc).append(" AS FUnitID, \r\n");
        sb.append(" UNIT.FID AS FUnitIDpk_hide, \r\n");
        sb.append(" ASSISTUNIT.FName_").append(this.loc).append(" AS FAssistUnitID,  \r\n");
        sb.append(" ASSISTUNIT.FID AS FAssistUnitIDpk_hide,  \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreQty ");
        sb.append(" - ");
        sb.append(" ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) ");
        sb.append(" AS FCurStoreQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FCurStoreAssistQty - ISNULL(RESERVATION.FReservationAssistQty, 0), MULTIASSISTUNIT.FQtyPrecision) AS FCurStoreAssistQty,  \r\n");
        sb.append(" ROUND(INVENTORY.FBaseQty - ISNULL(RESERVATION.FReservationBaseQty, 0), MULTIBASEUNIT.FQtyPrecision) AS FBaseQty,   \r\n");
        sb.append(" MATERIAL.FModel AS MATERIALMODEL,   \r\n");
        sb.append(" STORESTATUS.FNumber AS STORESTATUSNUMBER,  \r\n");
        sb.append(" STORESTATUS.FName_").append(this.loc).append(" AS FStoreStatusID,   \r\n");
        sb.append(" MATERIAL.FName_").append(this.loc).append(" AS MATERIALNAME,   \r\n");
        sb.append(" MATERIAL.FNumber AS MATERIALNUMBER,  \r\n");
        sb.append(" INVENTORY.FMaterialID AS MATERIALID,   \r\n");
        sb.append(" FBASEUNIT.FName_").append(this.loc).append(" AS FBaseUnitID, \r\n");
        sb.append(" MULTIBASEUNIT.FQtyPrecision AS MULTIBASEUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIASSISTUNIT.FQtyPrecision AS MULTIASSISTUNITQTYPRECISION,   \r\n");
        sb.append(" MULTIUNIT.FQtyPrecision AS MULTIUNITQTYPRECISION,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLot = '").append("YNi0IQEOEADgBT3mfwAAAcznrtQ=").append("' THEN NULL ELSE INVENTORY.FLot END AS FLot,    \r\n");
        sb.append(" PROJECT.FNumber AS FProjectID,   \r\n");
        sb.append(" TRACKNUMBER.FNumber AS FTrackNumberID,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FAssistPropertyID = '").append("EgkAAAA5EWALxvQu").append("' THEN NULL ELSE INVENTORY.FAssistPropertyID END AS FAssistPropertyIDpk_hide,   \r\n");
        sb.append(" ASSISTPROPERTY.FNumber AS ASSISTPROPERTYNUMBER,    \r\n");
        sb.append(" ASSISTPROPERTY.FName_").append(this.loc).append(" AS FAssistPropertyID,    \r\n");
        sb.append(" SUPPLIER.FName_").append(this.loc).append(" AS FSupplierID,    \r\n");
        sb.append(" CUSTOMER.FName_").append(this.loc).append(" AS FCustomerID,    \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationQty, MULTIUNIT.FQtyPrecision), 0) AS FReservationQty,   \r\n");
        sb.append(" ISNULL(ROUND(RESERVATION.FReservationBaseQty, MULTIBASEUNIT.FQtyPrecision), 0) AS FReservationBaseQty,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FLocationID = '").append("EgkAAABc3XMgX/hq").append("' THEN NULL ELSE INVENTORY.FLocationID END AS FLocationIDpk_hide,   \r\n");
        sb.append(" CASE  WHEN INVENTORY.FWarehouseID = '").append("EgkAAABc3XG76fiu").append("' THEN NULL ELSE INVENTORY.FWarehouseID END AS FWarehouseIDpk_hide,    \r\n");
        sb.append(" WAREHOUSE.FHasLocation AS WAREHOUSEHASLOCATION,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FSupplierID = '").append("EgkAAABc3Xo3xn38").append("' THEN NULL ELSE INVENTORY.FSupplierID END AS FSupplierIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FCustomerID = '").append("EgkAAABc3Xu/DAQO").append("' THEN NULL ELSE INVENTORY.FCustomerID END AS FCustomerIDpk_hide,   \r\n");
        sb.append(" INVENTORY.FUnitID AS FUnitIDpk_hide,    \r\n");
        sb.append(" INVENTORY.FStoreTypeID AS FStoreTypeIDpk_hide,     \r\n");
        sb.append(" INVENTORY.FStoreStatusID AS FStoreStatusIDpk_hide,    \r\n");
        sb.append(" CASE  WHEN INVENTORY.FProjectID = '").append("EgkAAABc3Xza3gXu").append("' THEN NULL ELSE INVENTORY.FProjectID END AS FProjectIDpk_hide,     \r\n");
        sb.append(" CASE  WHEN INVENTORY.FTrackNumberID = '").append("EgkAAABc3X0Ibpg9").append("' THEN NULL ELSE INVENTORY.FTrackNumberID END AS FTrackNumberIDpk_hide,    \r\n");
        sb.append(" ROUND(DECIMAL((INVENTORY.FBaseQty / MULTIINVENTORYUNIT.FBaseConvsRate), 21, 8), MULTIINVENTORYUNIT.FQtyPrecision) AS CURMATSTOREQTY,      \r\n");
        sb.append(" MULTIINVENTORYUNIT.FQtyPrecision AS MULTIINVENTORYUNITQTYPRECIS43,    \r\n");
        sb.append(" DATEOFMINDURABILITY.FMfg AS FMFG,     \r\n");
        sb.append(" DATEOFMINDURABILITY.FExp AS FEXP    \r\n");
        return sb;
    }

    private StringBuilder getDefaultFromSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" FROM T_IM_Inventory AS INVENTORY \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON INVENTORY.FSupplierID = SUPPLIER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORESTATE AS STORESTATUS ON INVENTORY.FStoreStatusID = STORESTATUS.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_STORETYPE AS STORETYPE ON INVENTORY.FStoreTypeID = STORETYPE.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_LOCATION AS LOCATION ON INVENTORY.FLocationID = LOCATION.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_DB_WAREHOUSE AS WAREHOUSE ON INVENTORY.FWarehouseID = WAREHOUSE.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Storage AS STORAGEORGUNIT ON INVENTORY.FStorageOrgUnitID = STORAGEORGUNIT.FID \r\n");
        sb.append(" INNER JOIN T_ORG_Company AS COMPANYORGUNIT ON INVENTORY.FCompanyOrgUnitID = COMPANYORGUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Material AS MATERIAL ON INVENTORY.FMaterialID = MATERIAL.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON INVENTORY.FUnitID = UNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS ASSISTUNIT ON INVENTORY.FAssistUnitID = ASSISTUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIBASEUNIT ON INVENTORY.FMaterialID = MULTIBASEUNIT.FMaterialID AND INVENTORY.FBaseUnitID = MULTIBASEUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIASSISTUNIT ON INVENTORY.FMaterialID = MULTIASSISTUNIT.FMaterialID AND INVENTORY.FAssistUnitID = MULTIASSISTUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIUNIT ON INVENTORY.FMaterialID = MULTIUNIT.FMaterialID AND INVENTORY.FUnitID = MULTIUNIT.FMeasureUnitID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_AsstAttrValue AS ASSISTPROPERTY ON INVENTORY.FAssistPropertyID = ASSISTPROPERTY.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_Customer AS CUSTOMER ON INVENTORY.FCustomerID = CUSTOMER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_Project AS PROJECT ON INVENTORY.FProjectID = PROJECT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_MM_TrackNumber AS TRACKNUMBER ON INVENTORY.FTrackNumberID = TRACKNUMBER.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MaterialInventory AS MATLINVENTORY ON INVENTORY.FStorageOrgUnitID = MATLINVENTORY.FOrgUnit AND INVENTORY.FMaterialID = MATLINVENTORY.FMaterialID \r\n");
        sb.append(" LEFT OUTER JOIN T_IM_DateOfMinDurability AS DATEOFMINDURABILITY ON INVENTORY.FStorageOrgUnitID = DATEOFMINDURABILITY.FStorageOrgUnitID AND INVENTORY.FMaterialID = DATEOFMINDURABILITY.FMaterialID AND INVENTORY.FLot = DATEOFMINDURABILITY.FLot \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS FBASEUNIT ON MATERIAL.FBaseUnit = FBASEUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MeasureUnit AS INVENTORYUNIT ON MATLINVENTORY.FUnitID = INVENTORYUNIT.FID \r\n");
        sb.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit AS MULTIINVENTORYUNIT ON MATLINVENTORY.FMaterialID = MULTIINVENTORYUNIT.FMaterialID AND MATLINVENTORY.FUnitID = MULTIINVENTORYUNIT.FMeasureUnitID \r\n");
        sb.append((CharSequence)this.getReservationSQL());
        return sb;
    }

    private StringBuilder getDefaultWhereSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append(" WHERE (ROUND(INVENTORY.FCurStoreQty  -  ISNULL(DECIMAL((RESERVATION.FReservationBaseQty / MULTIUNIT.FBaseConvsRate), 21, 8), 0), MULTIUNIT.FQtyPrecision) <> 0) ");
        return sb;
    }

    private void initPermissionSQL(String storageOrgUnitID) throws BOSException {
        if (storageOrgUnitID == null || storageOrgUnitID != "") {
            return;
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(storageOrgUnitID);
        Map permMap = SCMBillCommonFacadeFactory.getRemoteInstance().getPermissionEntityViewMap(ids, null);
        this.permissionSQL = (String)permMap.get("PERM_WHERE");
        this.permissionJoinSQL = (String)permMap.get("PERM_JOIN");
    }

    private StringBuilder getReservationSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append(" LEFT OUTER JOIN (");
        sql.append(" SELECT FInventoryID, ");
        sql.append(" ISNULL(SUM(FReservationQty), 0) AS FReservationQty, ").append(" ISNULL(SUM(FReservationBaseQty), 0) AS FReservationBaseQty, ").append(" ISNULL(SUM(FReservationAssistQty), 0) AS FReservationAssistQty ");
        sql.append(" FROM T_IM_Reservation ");
        sql.append(" GROUP BY FInventoryID) AS RESERVATION ");
        sql.append(" ON RESERVATION.FInventoryID = INVENTORY.FID \r\n");
        return sql;
    }

    @Override
    protected List _queryInvRelationInfo(Context ctx, Map paramMap) throws BOSException, EASBizException {
        String warehouse = null;
        String supplier = null;
        String unit = null;
        String assistProperty = null;
        ArrayList infoList = new ArrayList();
        if (paramMap.get("warehouse") != null) {
            warehouse = paramMap.get("warehouse").toString();
            this.cacheWarehouse(infoList, warehouse);
        }
        if (paramMap.get("supplier") != null) {
            supplier = paramMap.get("supplier").toString();
            this.cacheSupplier(infoList, supplier);
        }
        if (paramMap.get("unit") != null) {
            unit = paramMap.get("unit").toString();
            this.cacheUnit(infoList, unit);
        }
        if (paramMap.get("assistProperty") != null) {
            assistProperty = paramMap.get("assistProperty").toString();
            this.cacheAssistPorp(infoList, assistProperty);
        }
        return infoList;
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        if ("list".equalsIgnoreCase(viewType)) {
            return "com.kingdee.eas.scm.sm.pur.purRequestBillList";
        }
        if ("edit".equalsIgnoreCase(viewType)) {
            return "com.kingdee.eas.scm.sm.pur.purRequestEditPage";
        }
        return null;
    }

    protected static SelectorItemCollection getPurOrderEntrySelector() {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("supplier.id"));
        selector.add(new SelectorItemInfo("supplier.number"));
        selector.add(new SelectorItemInfo("supplier.name"));
        selector.add(new SelectorItemInfo("currency.id"));
        selector.add(new SelectorItemInfo("currency.number"));
        selector.add(new SelectorItemInfo("currency.name"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        selector.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        selector.add(new SelectorItemInfo("useAdminOrgUnit.id"));
        selector.add(new SelectorItemInfo("useAdminOrgUnit.number"));
        selector.add(new SelectorItemInfo("useAdminOrgUnit.name"));
        selector.add(new SelectorItemInfo("rowType.id"));
        selector.add(new SelectorItemInfo("rowType.number"));
        selector.add(new SelectorItemInfo("rowType.name"));
        selector.add(new SelectorItemInfo("rowType.projectType"));
        selector.add(new SelectorItemInfo("rowType.destinationType"));
        selector.add(new SelectorItemInfo("rowType.requestOrgType"));
        selector.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        selector.add(new SelectorItemInfo("rowType.precision"));
        selector.add(new SelectorItemInfo("receivedOrgUnit.id"));
        selector.add(new SelectorItemInfo("receivedOrgUnit.number"));
        selector.add(new SelectorItemInfo("receivedOrgUnit.name"));
        selector.add(new SelectorItemInfo("warehosue.id"));
        selector.add(new SelectorItemInfo("warehosue.number"));
        selector.add(new SelectorItemInfo("warehosue.name"));
        selector.add(new SelectorItemInfo("storageOrgUnit.id"));
        selector.add(new SelectorItemInfo("storageOrgUnit.number"));
        selector.add(new SelectorItemInfo("storageOrgUnit.name"));
        selector.add(new SelectorItemInfo("adminOrgUnit.id"));
        selector.add(new SelectorItemInfo("adminOrgUnit.number"));
        selector.add(new SelectorItemInfo("adminOrgUnit.name"));
        selector.add(new SelectorItemInfo("sourceStorageOrgUnit.id"));
        selector.add(new SelectorItemInfo("sourceStorageOrgUnit.number"));
        selector.add(new SelectorItemInfo("sourceStorageOrgUnit.name"));
        selector.add(new SelectorItemInfo("sourceWarehouse.id"));
        selector.add(new SelectorItemInfo("sourceWarehouse.number"));
        selector.add(new SelectorItemInfo("sourceWarehouse.name"));
        selector.add(new SelectorItemInfo("purchasePerson.id"));
        selector.add(new SelectorItemInfo("purchasePerson.number"));
        selector.add(new SelectorItemInfo("purchasePerson.name"));
        selector.add(new SelectorItemInfo("materialGroup1.id"));
        selector.add(new SelectorItemInfo("materialGroup1.number"));
        selector.add(new SelectorItemInfo("materialGroup1.name"));
        selector.add(new SelectorItemInfo("bom.id"));
        selector.add(new SelectorItemInfo("bom.number"));
        selector.add(new SelectorItemInfo("bom.name"));
        selector.add(new SelectorItemInfo("purchaseGroup.id"));
        selector.add(new SelectorItemInfo("purchaseGroup.number"));
        selector.add(new SelectorItemInfo("purchaseGroup.name"));
        selector.add(new SelectorItemInfo("project.id"));
        selector.add(new SelectorItemInfo("project.number"));
        selector.add(new SelectorItemInfo("project.name"));
        selector.add(new SelectorItemInfo("trackNo.id"));
        selector.add(new SelectorItemInfo("trackNo.number"));
        selector.add(new SelectorItemInfo("trackNo.name"));
        selector.add(new SelectorItemInfo("purContractID.id"));
        selector.add(new SelectorItemInfo("purContractID.number"));
        selector.add(new SelectorItemInfo("purContractID.name"));
        selector.add(new SelectorItemInfo("entries1.baseQty"));
        selector.add(new SelectorItemInfo("entries1.qty"));
        selector.add(new SelectorItemInfo("entries1.assistQty"));
        selector.add(new SelectorItemInfo("entries1.unitQty"));
        selector.add(new SelectorItemInfo("entries1.lossRatio"));
        selector.add(new SelectorItemInfo("entries1.demandDate"));
        selector.add(new SelectorItemInfo("entries1.standardQty"));
        selector.add(new SelectorItemInfo("entries1.scrapQty"));
        selector.add(new SelectorItemInfo("entries1.storageOrgUnit"));
        selector.add(new SelectorItemInfo("entries1.scrapRateExpression"));
        selector.add(new SelectorItemInfo("exchangeRate"));
        selector.add(new SelectorItemInfo("materialBaseClass"));
        selector.add(new SelectorItemInfo("requirementDate"));
        selector.add(new SelectorItemInfo("proposeDeliveryDate"));
        selector.add(new SelectorItemInfo("proposePurchaseDate"));
        selector.add(new SelectorItemInfo("purpose"));
        selector.add(new SelectorItemInfo("price"));
        selector.add(new SelectorItemInfo("qty"));
        selector.add(new SelectorItemInfo("assistQty"));
        selector.add(new SelectorItemInfo("amount"));
        selector.add(new SelectorItemInfo("localAmount"));
        selector.add(new SelectorItemInfo("orderedQty"));
        selector.add(new SelectorItemInfo("unOrderedQty"));
        selector.add(new SelectorItemInfo("trackNumber"));
        selector.add(new SelectorItemInfo("baseQty"));
        selector.add(new SelectorItemInfo("orderedBaseQty"));
        selector.add(new SelectorItemInfo("unOrderedBaseQty"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("mergeBillNumber"));
        selector.add(new SelectorItemInfo("destinationType"));
        selector.add(new SelectorItemInfo("deliveryAddress"));
        selector.add(new SelectorItemInfo("sourceType"));
        selector.add(new SelectorItemInfo("materialName"));
        selector.add(new SelectorItemInfo("mergeBillSeq"));
        selector.add(new SelectorItemInfo("isQuantityUnCtrl"));
        selector.add(new SelectorItemInfo("totalReqQty"));
        selector.add(new SelectorItemInfo("totalRequQty"));
        selector.add(new SelectorItemInfo("unTotalReqQty"));
        selector.add(new SelectorItemInfo("processRequirement"));
        selector.add(new SelectorItemInfo("operationNo"));
        selector.add(new SelectorItemInfo("planOrderNumber"));
        selector.add(new SelectorItemInfo("saleOrderNumber"));
        selector.add(new SelectorItemInfo("dosingType"));
        selector.add(new SelectorItemInfo("quotationTimes"));
        selector.add(new SelectorItemInfo("requestQty"));
        selector.add(new SelectorItemInfo("noNumMaterialModel"));
        selector.add(new SelectorItemInfo("bizDate"));
        selector.add(new SelectorItemInfo("companyOrgUnit"));
        selector.add(new SelectorItemInfo("isManualClose"));
        selector.add(new SelectorItemInfo("assOrderBaseQty"));
        selector.add(new SelectorItemInfo("assOrderQty"));
        selector.addObjectCollection((IObjectCollection)SCMSelectorFactory.getSCMBillBaseEntrySelector((String)""));
        return selector;
    }

    protected SelectorItemCollection getPurRequestSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("localTotalAmount"));
        sic.add(new SelectorItemInfo("isUrgent"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("isMergeBill"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("purchaseType"));
        sic.add(new SelectorItemInfo("isApprovedSupplier"));
        sic.add(new SelectorItemInfo("modificationTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.number"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("modifier.id"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("auditor.id"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.number"));
        sic.add(new SelectorItemInfo("sourceBillType.name"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("entries.materialBaseClass"));
        sic.add(new SelectorItemInfo("entries.purpose"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.number"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.model"));
        sic.add(new SelectorItemInfo("entries.material.helpCode"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.material.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.id"));
        sic.add(new SelectorItemInfo("entries.material.isOutsourcedPart"));
        sic.add(new SelectorItemInfo("entries.material.materialGroup.number"));
        sic.add(new SelectorItemInfo("entries.material.materialGroup.name"));
        sic.add(new SelectorItemInfo("entries.supplier.id"));
        sic.add(new SelectorItemInfo("entries.supplier.name"));
        sic.add(new SelectorItemInfo("entries.supplier.number"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.name"));
        sic.add(new SelectorItemInfo("entries.unit.number"));
        sic.add(new SelectorItemInfo("entries.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.requirementDate"));
        sic.add(new SelectorItemInfo("entries.proposeDeliveryDate"));
        sic.add(new SelectorItemInfo("entries.proposePurchaseDate"));
        sic.add(new SelectorItemInfo("entries.trackNumber"));
        sic.add(new SelectorItemInfo("entries.assistQty"));
        sic.add(new SelectorItemInfo("entries.unOrderedQty"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.baseQty"));
        sic.add(new SelectorItemInfo("entries.orderedQty"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.mergeBillNumber"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.destinationType"));
        sic.add(new SelectorItemInfo("entries.deliveryAddress"));
        sic.add(new SelectorItemInfo("entries.sourceType"));
        sic.add(new SelectorItemInfo("entries.materialName"));
        sic.add(new SelectorItemInfo("entries.mergeBillSeq"));
        sic.add(new SelectorItemInfo("entries.isQuantityUnCtrl"));
        sic.add(new SelectorItemInfo("entries.totalReqQty"));
        sic.add(new SelectorItemInfo("entries.totalRequQty"));
        sic.add(new SelectorItemInfo("entries.processRequirement"));
        sic.add(new SelectorItemInfo("entries.operationNo"));
        sic.add(new SelectorItemInfo("entries.planOrderNumber"));
        sic.add(new SelectorItemInfo("entries.saleOrderNumber"));
        sic.add(new SelectorItemInfo("entries.dosingType"));
        sic.add(new SelectorItemInfo("entries.quotationTimes"));
        sic.add(new SelectorItemInfo("entries.requestQty"));
        sic.add(new SelectorItemInfo("entries.noNumMaterialModel"));
        sic.add(new SelectorItemInfo("entries.unTotalReqQty"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.name"));
        sic.add(new SelectorItemInfo("entries.assistUnit.number"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.name"));
        sic.add(new SelectorItemInfo("entries.baseUnit.number"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.assistProperty.name"));
        sic.add(new SelectorItemInfo("entries.assistProperty.number"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.rowType.id"));
        sic.add(new SelectorItemInfo("entries.rowType.name"));
        sic.add(new SelectorItemInfo("entries.rowType.number"));
        sic.add(new SelectorItemInfo("entries.rowType.projectType"));
        sic.add(new SelectorItemInfo("entries.rowType.destinationType"));
        sic.add(new SelectorItemInfo("entries.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("entries.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("entries.rowType.precision"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.warehosue.id"));
        sic.add(new SelectorItemInfo("entries.warehosue.name"));
        sic.add(new SelectorItemInfo("entries.warehosue.number"));
        sic.add(new SelectorItemInfo("entries.sourceStorageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.sourceStorageOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.sourceStorageOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.sourceWarehouse.id"));
        sic.add(new SelectorItemInfo("entries.sourceWarehouse.name"));
        sic.add(new SelectorItemInfo("entries.sourceWarehouse.number"));
        sic.add(new SelectorItemInfo("entries.useAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.useAdminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.useAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.purchasePerson.id"));
        sic.add(new SelectorItemInfo("entries.purchasePerson.number"));
        sic.add(new SelectorItemInfo("entries.purchasePerson.name"));
        sic.add(new SelectorItemInfo("entries.materialGroup1.id"));
        sic.add(new SelectorItemInfo("entries.materialGroup1.number"));
        sic.add(new SelectorItemInfo("entries.materialGroup1.name"));
        sic.add(new SelectorItemInfo("entries.bom.id"));
        sic.add(new SelectorItemInfo("entries.bom.name"));
        sic.add(new SelectorItemInfo("entries.bom.number"));
        sic.add(new SelectorItemInfo("entries.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("entries.purchaseGroup.number"));
        sic.add(new SelectorItemInfo("entries.purchaseGroup.name"));
        sic.add(new SelectorItemInfo("entries.project.id"));
        sic.add(new SelectorItemInfo("entries.project.name"));
        sic.add(new SelectorItemInfo("entries.project.number"));
        sic.add(new SelectorItemInfo("entries.trackNo.id"));
        sic.add(new SelectorItemInfo("entries.trackNo.name"));
        sic.add(new SelectorItemInfo("entries.trackNo.number"));
        sic.add(new SelectorItemInfo("entries.purContractID.id"));
        sic.add(new SelectorItemInfo("entries.purContractID.name"));
        sic.add(new SelectorItemInfo("entries.purContractID.number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("cu.id"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.id"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.number"));
        sic.add(new SelectorItemInfo("entries.material.assistAttr.name"));
        sic.add(new SelectorItemInfo("netBuyOfferID"));
        sic.add(new SelectorItemInfo("entries.person.id"));
        sic.add(new SelectorItemInfo("entries.person.number"));
        sic.add(new SelectorItemInfo("entries.person.name"));
        sic.add(new SelectorItemInfo("entries.reqAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.reqAdminOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.reqAdminOrgUnit.name"));
        return sic;
    }

    private void calBotpAssQty(Context ctx, PurRequestInfo info) throws BOSException, EASBizException {
        MaterialInfo material;
        int i;
        PurRequestEntryInfo entry = null;
        PurRequestEntryCollection entries = info.getEntries();
        SelectorItemCollection materialSic = new SelectorItemCollection();
        materialSic.add("id");
        SelectorItemCollection unitSic = new SelectorItemCollection();
        unitSic.add("id");
        unitSic.add("material.id");
        unitSic.add("measureUnit.id");
        unitSic.add("baseConvsRate");
        unitSic.add("qtyPrecision");
        Map mapMaterial = new HashMap(entries.size());
        String[] materialIds = new String[entries.size()];
        Map mapMultiMeasureUnitFrom = new HashMap(entries.size());
        Map mapMultiMeasureUnitTo = new HashMap(entries.size());
        String[] assUnitIds = new String[entries.size()];
        String[] baseUnitIds = new String[entries.size()];
        int len = entries.size();
        for (i = 0; i < len; ++i) {
            entry = entries.get(i);
            material = entry.getMaterial();
            RowTypeInfo rowType = entry.getRowType();
            MeasureUnitInfo assUnit = entry.getAssistUnit();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            if (material != null && material.getId() != null) {
                materialIds[i] = material.getId().toString();
            }
            if (assUnit == null || baseUnit == null) continue;
            assUnitIds[i] = assUnit.getId().toString();
            baseUnitIds[i] = baseUnit.getId().toString();
        }
        mapMaterial = this.loadMaterial(ctx, materialIds, materialSic);
        mapMultiMeasureUnitFrom = this.loadMultiMeasureUnit(ctx, materialIds, baseUnitIds, unitSic);
        mapMultiMeasureUnitTo = this.loadMultiMeasureUnit(ctx, materialIds, assUnitIds, unitSic);
        len = entries.size();
        for (i = 0; i < len; ++i) {
            entry = entries.get(i);
            if (entry == null || entry.get("assistQty") != null || (material = entry.getMaterial()) == null || material.getId() == null) continue;
            material = (MaterialInfo)mapMaterial.get(material.getId().toString());
            BigDecimal baseQty = entry.getBaseQty();
            MeasureUnitInfo baseUnit = entry.getBaseUnit();
            MeasureUnitInfo assUnit = entry.getAssistUnit();
            String assUnitID = null;
            String baseUnitID = null;
            BigDecimal assistQty = null;
            if (baseQty == null || assUnit == null || baseUnit == null) continue;
            assUnitID = assUnit.getId().toString();
            baseUnitID = baseUnit.getId().toString();
            assistQty = PurRequestControllerBean.getUnitQty(ctx, baseQty, material.getId().toString(), baseUnitID, assUnitID, mapMultiMeasureUnitFrom, mapMultiMeasureUnitTo);
            entry.setAssistQty(assistQty);
        }
    }
}

