/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHCollection;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHFactory;
import com.kingdee.eas.basedata.scm.im.inv.SOAccreditWHInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IDemandType;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.ITrackNumber;
import com.kingdee.eas.mm.basedata.TrackNumberCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarFactory;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.sm.pur.IPurContract;
import com.kingdee.eas.scm.sm.pur.PurContractCollection;
import com.kingdee.eas.scm.sm.pur.PurContractFactory;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.FilterSqlUtils;
import com.kingdee.eas.scm.sm.pur.calculate.PurRequestCal;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurRequestDataImport
extends SCMDataImport {
    private static Logger logger = Logger.getLogger(PurRequestDataImport.class);
    String[] DATE_FIELDS = new String[]{"FBizDate", "FCreateTime"};
    String[] DATE_OBJS = new String[]{"bizDate", "createTime"};
    private CompanyOrgUnitInfo comOrg = null;
    private HashMap comOrgMap = new HashMap();
    private Map<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
    private Map<String, StorageOrgUnitInfo> storageOrgMap = new HashMap<String, StorageOrgUnitInfo>();
    private Map<String, PurchaseOrgUnitInfo> purOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
    private Map<String, AdminOrgUnitInfo> adminOrgMap = new HashMap<String, AdminOrgUnitInfo>();
    private Map<String, ProjectInfo> projectMap = new HashMap<String, ProjectInfo>();
    private Map<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, TrackNumberInfo> trackNumberMap = new HashMap<String, TrackNumberInfo>();
    private Map<String, Map<String, ExchangeRateInfo>> exchangeMap = new HashMap<String, Map<String, ExchangeRateInfo>>();
    private StringBuffer msg = new StringBuffer();
    Map<String, String> numberMap = new HashMap<String, String>();
    ImportDataCache dataPool = new ImportDataCache();
    PurRequestInfo purRequestInfo = null;
    private static final String RESOURCE = "com.kingdee.eas.scm.sm.pur.PurImportExportResource";

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurRequestFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadCompanyOrgUnit(PurRequestInfo purRequestInfo, Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        String souData = (String)this.getData("FCompanyOrgUnit_Number", hsData);
        CompanyOrgUnitInfo info = null;
        if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)souData) || souData.toString().trim().length() <= 0) throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "companyOrgUnitNotNull"));
        try {
            if (this.comOrgMap.containsKey(souData)) {
                if (this.comOrgMap.get(souData) != null) {
                    throw (TaskExternalException)((Object)this.comOrgMap.get(souData));
                }
                this.comOrg = info = this.getCompanyOrgUnit(ctx, "number", souData);
                purRequestInfo.setCompanyOrgUnit(info);
                purRequestInfo.setCU(info.getCU());
                return;
            } else {
                info = this.getCompanyOrgUnit(ctx, "number", souData);
                if (info == null) throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "companyOrgNotExist"));
                this.comOrg = info;
                purRequestInfo.setCompanyOrgUnit(info);
                purRequestInfo.setCU(info.getCU());
                UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
                String userInfoID = null;
                if (userInfo != null) {
                    userInfoID = userInfo.getId().toString();
                }
                if (userInfoID == null) return;
                PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(info.getId().toString()), "purreq_addnew");
                this.comOrgMap.put(souData, null);
                return;
            }
        }
        catch (EASBizException e) {
            TaskExternalException te = new TaskExternalException(e.getMessage());
            this.comOrgMap.put(souData, te);
            throw te;
        }
    }

    public PurRequestInfo transmitnew(Hashtable hsData, Context ctx) throws TaskExternalException, BOSException, EASBizException {
        this.msg.setLength(0);
        Object[] list = hsData.entrySet().toArray();
        Map.Entry entry1 = (Map.Entry)list[list.length - 1];
        Hashtable innerTable1 = (Hashtable)entry1.getValue();
        boolean isImportDataByRule = DataImportUtils.getImportParam(ctx);
        String number = this.getData("FNumber", innerTable1).toString();
        boolean isNumberNull = com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)number);
        this.purRequestInfo = new PurRequestInfo();
        this.loadCompanyOrgUnit(this.purRequestInfo, innerTable1, ctx);
        Iterator rowIt = hsData.entrySet().iterator();
        int i = list.length - 1;
        if (i >= 0) {
            Map.Entry entry = (Map.Entry)list[i];
            Hashtable innerTable = (Hashtable)entry.getValue();
            this.purRequestInfo = this.setHeadInfo(ctx, this.purRequestInfo, innerTable);
        }
        this.doNumber(ctx, this.purRequestInfo, innerTable1);
        PurRequestEntryInfo entryInfo = null;
        for (int i2 = list.length - 1; i2 >= 0; --i2) {
            Map.Entry entry = (Map.Entry)list[i2];
            Hashtable innerTable = (Hashtable)entry.getValue();
            entryInfo = new PurRequestEntryInfo();
            entryInfo.setParent(this.purRequestInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
            if (this.purRequestInfo.getBizDate() != null) {
                entryInfo.setBizDate(this.purRequestInfo.getBizDate());
            }
            this.handleEntry(this.purRequestInfo, entryInfo, innerTable, ctx, (Integer)entry.getKey() + 1 + "");
            this.calEntry(this.purRequestInfo, entryInfo);
            this.purRequestInfo.getEntries().add(entryInfo);
        }
        this.calTotalAmount(this.purRequestInfo);
        this.calTotalValue(this.purRequestInfo);
        this.calTotalFields(this.purRequestInfo);
        DemandTypeInfo demandTypeInfo = this.purRequestInfo.getDemandType();
        if (demandTypeInfo != null && demandTypeInfo.getRowType() != null && this.purRequestInfo.getEntries().size() > 0) {
            if (demandTypeInfo.getRowType().isIsHasMaterialNumber()) {
                this.purRequestInfo.setStorageOrgUnit(this.purRequestInfo.getEntries().get(0).getStorageOrgUnit());
            } else {
                this.purRequestInfo.setReqAdminOrgUnit(this.purRequestInfo.getEntries().get(0).getReqAdminOrgUnit());
            }
        }
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-0107c0a812fd463ED552"));
        this.purRequestInfo.setBillType(billtype);
        Date day = new Date();
        this.purRequestInfo.setCreateTime(new Timestamp(day.getTime()));
        return this.purRequestInfo;
    }

    private PurRequestInfo setHeadInfo(Context ctx, PurRequestInfo purRequestInfo, Hashtable hsData) throws TaskExternalException, BOSException, EASBizException {
        String oldnumber = purRequestInfo.getNumber();
        if (this.numberMap.containsKey(oldnumber)) {
            oldnumber = this.numberMap.get(oldnumber);
        }
        Object data = null;
        String str = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            Object o = this.getData(this.DATE_FIELDS[i], hsData);
            if (o != null && o.toString().length() > 0) {
                Date value;
                try {
                    o = df.parse(o.toString());
                }
                catch (ParseException pex) {
                    logger.error((Object)pex);
                    this.fail(ctx, "InvalidDateFormat", oldnumber, null, null);
                }
                if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
                purRequestInfo.setDate(this.DATE_OBJS[i], value);
                continue;
            }
            if ("FBizDate".equalsIgnoreCase(this.DATE_FIELDS[i])) {
                this.fail(ctx, "requestDateNotNull", oldnumber, null, null);
            }
            if (!"FCreateTime".equalsIgnoreCase(this.DATE_FIELDS[i])) continue;
            purRequestInfo.setDate(this.DATE_OBJS[i], new Date());
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        Object userInfo = null;
        UserInfo user = this.getCreator(ctx, data);
        purRequestInfo.setCreator(user);
        this.doBiztype(ctx, hsData, purRequestInfo);
        data = this.getData("FDemandType_Number", hsData);
        this.getDemandType(ctx, purRequestInfo, oldnumber, data);
        data = this.getData("Fperson_Number", hsData);
        PersonInfo personInfo = this.getPerson(ctx, data, RESOURCE, "requestPersonNotExist");
        purRequestInfo.setPerson(personInfo);
        data = this.getData("FAdminOrgUnit_Number", hsData);
        if (data != null) {
            str = data.toString();
            if (str != null && str.length() > 0) {
                AdminOrgUnitInfo adminOrgUnitInfo = this.getAdminOrgUnit(ctx, "number", str);
                purRequestInfo.setAdminOrg(adminOrgUnitInfo);
            } else if (null != purRequestInfo.getPerson()) {
                purRequestInfo.setAdminOrg(this.getAdminByPerson(ctx, purRequestInfo.getPerson().getId().toString()));
            }
        }
        data = this.getData("FIsQuicken", hsData);
        purRequestInfo.setIsUrgent(this.getBooleanValue(data.toString(), ctx));
        Object description = this.getData("FDescription", hsData);
        if (description != null && !com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)(str = description.toString()))) {
            if (str.length() > 255) {
                str = str.substring(0, 255);
            }
            purRequestInfo.setDescription(str);
        }
        purRequestInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        if (purRequestInfo.getEntries() != null && purRequestInfo.getEntries().size() > 0) {
            purRequestInfo.getEntries().clear();
        }
        data = this.getData("FIsInTax", hsData);
        purRequestInfo.setIsInTax(this.getBooleanValue(data.toString(), ctx));
        purRequestInfo.setIsPriceInTax(true);
        return purRequestInfo;
    }

    public void getCreator(Context ctx, PurRequestInfo purRequestInfo, String oldnumber, Object data, IUser iuser) throws BOSException, TaskExternalException {
        if (data != null) {
            String str = data.toString();
            if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
                purRequestInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            } else {
                UserInfo userInfo = this.getUserFromNumber(iuser, str);
                if (userInfo != null) {
                    purRequestInfo.setCreator(userInfo);
                } else {
                    this.fail(ctx, "creatorNotExist", oldnumber, null, str);
                }
            }
        }
    }

    private void doBiztype(Context ctx, Map lineData, PurRequestInfo purRequestInfo) throws TaskExternalException {
        Object data = ((DataToken)lineData.get((Object)"FBizType_Number")).data;
        BizTypeInfo bizType = this.getBizType(ctx, "510b6503-0105-1000-e000-0107c0a812fd463ED552", "number", data);
        purRequestInfo.setBizType(bizType);
        if (bizType.getId().toString().equals("1x7KMBq4mUmpj58T4jNPqiQHQ1w=")) {
            purRequestInfo.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
        } else {
            purRequestInfo.setPurchaseType(PurchaseTypeEnum.PURCHASE);
        }
    }

    public void getDemandType(Context ctx, PurRequestInfo purRequestInfo, String oldnumber, Object data) throws BOSException, TaskExternalException {
        if (data != null) {
            String str = data.toString();
            if (str != null && str.trim().length() > 0) {
                if (this.dataPool.getDemandType(str) == null) {
                    IDemandType idemandType = DemandTypeFactory.getLocalInstance((Context)ctx);
                    EntityViewInfo viewInfo = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                    viewInfo.setFilter(filter);
                    DemandTypeCollection collection = idemandType.getDemandTypeCollection(viewInfo);
                    if (collection != null && collection.size() > 0) {
                        DemandTypeInfo info = collection.get(0);
                        if (info != null) {
                            purRequestInfo.setDemandType(info);
                            this.dataPool.setDemandType(str, info);
                        } else {
                            this.fail(ctx, "demandTypeNotNull", oldnumber, null, null);
                        }
                    } else {
                        this.fail(ctx, "demandTypeNotExist", oldnumber, null, str);
                    }
                } else {
                    purRequestInfo.setDemandType(this.dataPool.getDemandType(str));
                }
            } else {
                throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"demandTypeNotNull", (Context)ctx));
            }
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.purRequestInfo = null;
        try {
            this.transmitnew(hsData, ctx);
            if (this.msg.length() > 0) {
                this.recycleNumber(ctx, this.purRequestInfo);
                throw new TaskExternalException(this.msg.toString());
            }
            this.msg.setLength(0);
            return this.purRequestInfo;
        }
        catch (BOSException e) {
            this.recycleNumber(ctx, this.purRequestInfo);
            throw new TaskExternalException(e.getMessage());
        }
        catch (EASBizException e) {
            this.recycleNumber(ctx, this.purRequestInfo);
            throw new TaskExternalException(e.getMessage());
        }
        catch (TaskExternalException e) {
            this.recycleNumber(ctx, this.purRequestInfo);
            throw new TaskExternalException(e.getMessage());
        }
    }

    private void calEntry(PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        PurRequestCal calUtil = new PurRequestCal();
        calUtil.setAmoutscale(entryInfo.getAmount().scale());
        if (info.isIsInTax()) {
            calUtil.setInTax(true);
            calUtil.calByEntryTaxPriceChange(info, entryInfo);
        } else {
            calUtil.setInTax(false);
            calUtil.calByEntryPriceChange(info, entryInfo);
        }
        this.calEntryLocalValue(entryInfo);
    }

    private void calEntryAmount(PurRequestEntryInfo entryInfo) {
        int currencyPrecision = 2;
        if (entryInfo.getCurrency() != null) {
            currencyPrecision = entryInfo.getCurrency().getPrecision();
        }
        BigDecimal price = entryInfo.getPrice();
        BigDecimal qty = entryInfo.getQty();
        BigDecimal amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)price, (int)currencyPrecision);
        entryInfo.setAmount(amount);
    }

    private void calEntryLocalValue(PurRequestEntryInfo entryInfo) {
        BigDecimal entryLocalAmount = new BigDecimal("0.00");
        int currencyPrecision = 2;
        if (entryInfo.getCurrency() != null) {
            currencyPrecision = entryInfo.getCurrency().getPrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal exchangeRate = entryInfo.getExchangeRate();
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        entryLocalAmount = amount.multiply(exchangeRate).setScale(currencyPrecision, 4);
        entryInfo.setLocalAmount(entryLocalAmount);
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal entryLocalTaxAmount = taxAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
        entryInfo.setLocalTaxAmount(entryLocalTaxAmount);
    }

    private void calTotalAmount(PurRequestInfo purReqInfo) {
        BigDecimal totalAmount = new BigDecimal("0.00");
        int count = purReqInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReqInfo.getEntries().get(index).getAmount() == null) continue;
            totalAmount = totalAmount.add(purReqInfo.getEntries().get(index).getAmount());
        }
        purReqInfo.setTotalAmount(totalAmount);
    }

    private void calTotalValue(PurRequestInfo purReqInfo) {
        BigDecimal localTotalAmount = new BigDecimal("0.00");
        int count = purReqInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReqInfo.getEntries().get(index).getAmount() == null) continue;
            localTotalAmount = localTotalAmount.add(purReqInfo.getEntries().get(index).getAmount());
        }
        purReqInfo.setLocalTotalAmount(localTotalAmount);
    }

    private void calTotalFields(PurRequestInfo orderInfo) {
        PurRequestEntryCollection entries = orderInfo.getEntries();
        BigDecimal localTotalAmount = new BigDecimal("0.00");
        BigDecimal entryLocalAmount = null;
        for (int i = 0; i < entries.size(); ++i) {
            entryLocalAmount = entries.get(i).getLocalAmount();
            if (entryLocalAmount == null) continue;
            localTotalAmount = localTotalAmount.add(entryLocalAmount);
        }
        orderInfo.setLocalTotalAmount(localTotalAmount);
    }

    private void handleEntry(PurRequestInfo purRequestInfo, PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex) throws TaskExternalException {
        String oldnumber = purRequestInfo.getNumber();
        if (this.numberMap.containsKey(oldnumber)) {
            oldnumber = this.numberMap.get(oldnumber);
        }
        Object data = null;
        try {
            BigDecimal discountRate;
            BigDecimal qty;
            String str = null;
            RowTypeInfo rowType = null;
            rowType = this.doRowType(purRequestInfo, entryInfo, hsData, ctx, entriesIndex, oldnumber, rowType);
            data = ((DataToken)hsData.get((Object)"FReceivedOrgUnit")).data;
            StorageOrgUnitInfo storageOrgUnitInfo = this.getStorageOrgUnit(ctx, "number", data);
            entryInfo.setReceivedOrgUnit(storageOrgUnitInfo);
            data = this.getData("FPurchaseOrgUnit_Number", hsData);
            PurchaseOrgUnitInfo PurchaseOrgUnitInfo2 = this.getPurchaseOrgUnit(ctx, "number", data);
            entryInfo.setPurchaseOrgUnit(PurchaseOrgUnitInfo2);
            MaterialInfo material = null;
            if (rowType != null && rowType.isIsHasMaterialNumber()) {
                data = ((DataToken)hsData.get((Object)"FMaterial_Number")).data;
                material = this.doMaterial(entryInfo, ctx, entriesIndex, oldnumber, data, material, purRequestInfo);
            } else {
                str = this.getData("FMaterialName", hsData).toString();
                if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
                    this.fail(ctx, "RowTypeNotNeedMaterial", oldnumber, entriesIndex, null);
                }
                entryInfo.setMaterial(null);
                entryInfo.setMaterialName(str);
                str = this.getData("FModel", hsData).toString();
                entryInfo.setNoNumMaterialModel(str);
            }
            this.doAssistAttr(entryInfo, hsData, ctx, entriesIndex, oldnumber, material);
            data = ((DataToken)hsData.get((Object)"FUnit_Number")).data;
            boolean flag = false;
            if (data != null) {
                str = data.toString().trim();
                MeasureUnitInfo unitInfo = this.getMeasureUnit(ctx, str, entryInfo.getMaterial());
                entryInfo.setUnit(unitInfo);
            } else {
                this.fail(ctx, "unitNotNull", oldnumber, entriesIndex, null);
            }
            int qtyPrecision = 4;
            if (material == null && entryInfo.getUnit() != null) {
                qtyPrecision = entryInfo.getUnit().getQtyPrecision();
            }
            if ((qty = this.getBigDecimal(ctx, this.getData("FRequestQty", hsData), oldnumber, entriesIndex)) == null) {
                qty = BigDecimal.ZERO;
            }
            entryInfo.setRequestQty(qty.setScale(qtyPrecision, 4));
            qty = this.getBigDecimal(ctx, this.getData("FQty", hsData), oldnumber, entriesIndex);
            if (qty == null) {
                if (entryInfo.getRequestQty() == null) {
                    this.fail(ctx, "qtyNotNull", oldnumber, entriesIndex, null);
                } else {
                    qty = entryInfo.getRequestQty();
                    entryInfo.setQty(entryInfo.getRequestQty().setScale(qtyPrecision, 4));
                }
            } else {
                entryInfo.setQty(qty.setScale(qtyPrecision, 4));
            }
            int baseUnit_precision = 6;
            MultiMeasureUnitInfo multiUnifInfo = null;
            if (rowType != null && rowType.isIsHasMaterialNumber() && entryInfo.getMaterial() != null) {
                multiUnifInfo = this.getMultiMeasureUnitInfo(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getBaseUnit().getId().toString());
                if (null != multiUnifInfo) {
                    baseUnit_precision = multiUnifInfo.getQtyPrecision();
                }
            } else {
                baseUnit_precision = entryInfo.getUnit().getQtyPrecision();
            }
            if (material != null && multiUnifInfo != null) {
                BigDecimal baseUnitQty = SCMUtils.getExchangePrecisionQtyForServer((Context)ctx, (String)material.getId().toString(), (MeasureUnitInfo)entryInfo.getUnit(), (MeasureUnitInfo)entryInfo.getBaseUnit(), (BigDecimal)entryInfo.getQty());
                entryInfo.setBaseQty(baseUnitQty.setScale(baseUnit_precision, 4));
            } else {
                entryInfo.setBaseQty(qty);
            }
            if (material != null && material.getAssistUnit() != null) {
                int assistPrecision = material.getAssistUnit().getQtyPrecision();
                BigDecimal fAssistQty = this.getBigDecimal(ctx, this.getData("FAssistQty", hsData), oldnumber, entriesIndex);
                if (null == fAssistQty) {
                    fAssistQty = BigDecimal.ZERO;
                }
                entryInfo.setAssistQty(fAssistQty.setScale(assistPrecision, 4));
            }
            entryInfo.setRequirementDate(this.getDate(ctx, this.getData("FRequirementDate", hsData), true, oldnumber, entriesIndex));
            entryInfo.setProposeDeliveryDate(this.getDate(ctx, this.getData("FProposeDeliveryDate", hsData), true, oldnumber, entriesIndex));
            entryInfo.setProposePurchaseDate(this.getDate(ctx, this.getData("FProposePurchaseDate", hsData), true, oldnumber, entriesIndex));
            this.doCurrency(entryInfo, hsData, ctx, entriesIndex, oldnumber);
            this.doExchangeRate(entryInfo, hsData, ctx, entriesIndex, oldnumber);
            BigDecimal price = this.getBigDecimal(ctx, this.getData("FPrice", hsData), oldnumber, entriesIndex);
            BigDecimal taxPrice = this.getBigDecimal(ctx, this.getData("FEntries_taxPrice", hsData), oldnumber, entriesIndex);
            BigDecimal amount = this.getBigDecimal(ctx, this.getData("FAmount", hsData), oldnumber, entriesIndex);
            BigDecimal localAmount = this.getBigDecimal(ctx, this.getData("FLocalAmount", hsData), oldnumber, entriesIndex);
            if (price == null) {
                price = SysConstant.BIGZERO;
            }
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            if (localAmount == null) {
                localAmount = SysConstant.BIGZERO;
            }
            int pricePrcision = 4;
            if (entryInfo.getRowType() != null) {
                if (entryInfo.getRowType().isIsHasMaterialNumber() && material != null) {
                    pricePrcision = material.getPricePrecision();
                } else if (rowType != null) {
                    pricePrcision = rowType.getPrecision();
                }
            }
            this.doPriceAndTaxPrice(purRequestInfo, entryInfo, ctx, price, taxPrice, pricePrcision);
            BigDecimal taxRate = this.getBigDecimal(ctx, this.getData("FEntries_taxRate", hsData), oldnumber, entriesIndex);
            if (taxRate == null) {
                taxRate = BigDecimal.ZERO;
            }
            entryInfo.setTaxRate(taxRate.setScale(2, 4));
            int discountRatePrecision = 4;
            if (this.comOrg != null) {
                discountRatePrecision = Integer.parseInt(ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(this.comOrg.getId().toString()), (String)"DISCOUNTRATEPRECISION"));
            }
            if ((discountRate = this.getBigDecimal(ctx, this.getData("FEntries_discountRate", hsData), oldnumber, entriesIndex)) == null) {
                discountRate = BigDecimal.ZERO;
            }
            entryInfo.setDiscountRate(discountRate.setScale(discountRatePrecision, 4));
            if (amount != null && amount.compareTo(BigDecimal.ZERO) < 0) {
                this.fail(ctx, "AmountCannotBeNegative", oldnumber, entriesIndex, null);
            }
            if (localAmount != null && localAmount.compareTo(BigDecimal.ZERO) < 0) {
                this.fail(ctx, "LocalAmountCannotBeNegative", oldnumber, entriesIndex, null);
            }
            int amountPrecision = 2;
            if (entryInfo.getCurrency() != null) {
                amountPrecision = entryInfo.getCurrency().getPrecision();
            }
            int localAmountPrecision = 2;
            if (this.comOrg != null) {
                localAmountPrecision = this.comOrg.getBaseCurrency().getPrecision();
            }
            entryInfo.setTax(BigDecimal.ZERO.setScale(amountPrecision));
            entryInfo.setTaxAmount(BigDecimal.ZERO.setScale(amountPrecision));
            entryInfo.setAmount(amount.setScale(amountPrecision, 4));
            entryInfo.setLocalAmount(localAmount.setScale(localAmountPrecision, 4));
            entryInfo.setLocalTaxAmount(BigDecimal.ZERO.setScale(localAmountPrecision));
            if (entryInfo.getReceivedOrgUnit() != null) {
                data = ((DataToken)hsData.get((Object)"FProject")).data;
                this.doProject(entryInfo, ctx, data);
                data = ((DataToken)hsData.get((Object)"FTrackNumber")).data;
                this.doTrackNumber(entryInfo, ctx, entriesIndex, oldnumber, data);
                StorageOrgUnitInfo receiveOrgInfo = entryInfo.getReceivedOrgUnit();
                this.doWarehouse(entryInfo, hsData, ctx, entriesIndex, oldnumber, material, receiveOrgInfo);
            }
            entryInfo.setPurpose(this.getData("FPurpose", hsData).toString());
            PurchaseOrgUnitInfo purorOrgUnitInfo = entryInfo.getPurchaseOrgUnit();
            this.doPurchaseGroup(entryInfo, hsData, ctx, purorOrgUnitInfo);
            this.doPurchasePerson(entryInfo, hsData, ctx);
            entryInfo.setDeliveryAddress(this.getData("FDeliveryAddress", hsData).toString());
            this.getAdminOrgUnit(entryInfo, hsData, ctx);
            entryInfo.setIsQuantityUnCtrl(this.getBooleanValue(this.getData("FIsQuantityUnCtrl", hsData).toString(), ctx));
            this.doSupplier(entryInfo, hsData, ctx, entriesIndex, oldnumber);
            this.doPurContractNumber(entryInfo, hsData, ctx, entriesIndex, oldnumber);
            Object remark = this.getData("Fremark", hsData);
            if (remark != null && !com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)(str = remark.toString()))) {
                if (str.length() > 255) {
                    str = str.substring(0, 255);
                }
                entryInfo.setRemark(str);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            ex.printStackTrace();
            throw new TaskExternalException(ex.getMessage());
        }
    }

    public void doPriceAndTaxPrice(PurRequestInfo purRequestInfo, PurRequestEntryInfo entryInfo, Context ctx, BigDecimal price, BigDecimal taxPrice, int pricePrcision) throws TaskExternalException {
        if (purRequestInfo.isIsInTax()) {
            if (taxPrice != null && taxPrice.compareTo(BigDecimal.ZERO) < 0) {
                throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "priceCannotNegative"));
            }
            if (taxPrice == null) {
                entryInfo.setTaxPrice(BigDecimal.ZERO.setScale(pricePrcision));
            } else {
                entryInfo.setTaxPrice(taxPrice.setScale(pricePrcision, 4));
            }
            entryInfo.setPrice(BigDecimal.ZERO.setScale(pricePrcision));
        } else {
            if (price != null && price.compareTo(BigDecimal.ZERO) < 0) {
                throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "priceCannotNegative"));
            }
            entryInfo.setPrice(price.setScale(pricePrcision, 4));
            entryInfo.setTaxPrice(BigDecimal.ZERO.setScale(pricePrcision));
        }
    }

    public void doPurContractNumber(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber) throws BOSException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"FPurContract_Number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            IPurContract iPurContract = PurContractFactory.getLocalInstance(ctx);
            PurContractCollection collection = iPurContract.getPurContractCollection(this.getFilter(data.toString().trim()));
            if (collection != null && collection.size() > 0) {
                PurContractInfo info = collection.get(0);
                if (info != null) {
                    entryInfo.setPurContractID(info);
                }
            } else {
                this.fail(ctx, "com.kingdee.eas.scm.sm.pur.PurBizResource", "PurContractNotExists", oldnumber, entriesIndex, str);
            }
        }
    }

    public void doSupplier(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber) throws TaskExternalException, BOSException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"Fsupplier_Number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            SupplierInfo Supplier = this.getSupplier(ctx, "number", str);
            entryInfo.setSupplier(Supplier);
            if (!this.checkSupplierEnable(ctx, Supplier)) {
                entryInfo.setSupplier(null);
                this.fail(ctx, "com.kingdee.eas.scm.sm.pur.PurBizResource", "IMPORT_SUPPLY_DISABLE", oldnumber, entriesIndex, str);
            }
            if (null != entryInfo.getPurchaseOrgUnit()) {
                StringBuffer sq = new StringBuffer();
                sq.append(" where usingStatus = 0 and supplier = '").append(Supplier.getId().toString()).append("'");
                sq.append("and purchaseOrgUnit = '").append(entryInfo.getPurchaseOrgUnit().getId().toString()).append("'");
                SupplierPurchaseInfoCollection supplierCol = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).getSupplierPurchaseInfoCollection(sq.toString());
                if (null == supplierCol || supplierCol.size() == 0) {
                    entryInfo.setSupplier(null);
                    this.fail(ctx, "com.kingdee.eas.scm.sm.pur.PurBizResource", "IMPORT_SUPPLY_ERROR", oldnumber, entriesIndex, str);
                }
            }
        }
    }

    public void getAdminOrgUnit(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        String str = this.getData("FUseAdminOrgUnit", hsData).toString();
        if (!com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
            if (this.dataPool.getAdminOrgUnitInfo(str) == null) {
                AdminOrgUnitInfo info = this.getAdminOrgUnitInfo(ctx, str);
                if (info != null) {
                    entryInfo.setUseAdminOrgUnit(info);
                    this.dataPool.setAdminOrgUnitInfo(str, info);
                } else {
                    this.failNotExist(ctx, RESOURCE, new String[]{"useDep", "adminOrg"});
                }
            } else {
                entryInfo.setUseAdminOrgUnit(this.dataPool.getAdminOrgUnitInfo(str));
            }
        }
    }

    public void doPurchasePerson(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx) throws BOSException, TaskExternalException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"FPurchasePerson_Number")).data;
        PurchaseGroupInfo purGourpInfo = entryInfo.getPurchaseGroup();
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            PersonInfo purchasePersonInfo = this.getPurchasePerson(ctx, "number", purGourpInfo, str);
            entryInfo.setPurchasePerson(purchasePersonInfo);
        }
    }

    public void doPurchaseGroup(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, PurchaseOrgUnitInfo purorOrgUnitInfo) throws TaskExternalException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"FPurchaseGroup_Number")).data;
        if (data != null && (str = data.toString()) != null && str.length() > 0) {
            PurchaseGroupInfo purchaseGroupInfo = this.getPurchaseGroup(ctx, "number", purorOrgUnitInfo, str, true);
            entryInfo.setPurchaseGroup(purchaseGroupInfo);
        }
    }

    public void doWarehouse(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber, MaterialInfo material, StorageOrgUnitInfo receiveOrgInfo) throws BOSException, TaskExternalException {
        String str;
        Object data;
        if (material != null && receiveOrgInfo != null && (data = ((DataToken)hsData.get((Object)"FWareHouse_Number")).data) != null && (str = data.toString()) != null && str.length() > 0) {
            EntityViewInfo accreditEV = new EntityViewInfo();
            FilterInfo accreditF = new FilterInfo();
            SelectorItemCollection accreditSic = new SelectorItemCollection();
            accreditF.getFilterItems().add(new FilterItemInfo("storageOrg", (Object)receiveOrgInfo.getId().toString(), CompareType.EQUALS));
            accreditF.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
            accreditSic.add(new SelectorItemInfo("warehouse"));
            accreditEV.setSelector(accreditSic);
            accreditEV.setFilter(accreditF);
            SOAccreditWHCollection isoCol = SOAccreditWHFactory.getLocalInstance((Context)ctx).getSOAccreditWHCollection(accreditEV);
            HashSet<String> warehouseIdSet = new HashSet<String>();
            SOAccreditWHInfo sOAccreditWHInfo = null;
            for (int i = 0; i < isoCol.size(); ++i) {
                sOAccreditWHInfo = isoCol.get(i);
                if (null == sOAccreditWHInfo || null == sOAccreditWHInfo.getWarehouse()) continue;
                warehouseIdSet.add(sOAccreditWHInfo.getWarehouse());
            }
            EntityViewInfo ev = this.getFilter(data.toString().trim());
            FilterInfo f = ev.getFilter();
            f.getFilterItems().add(new FilterItemInfo("id", warehouseIdSet, CompareType.INCLUDE));
            f.getFilterItems().add(new FilterItemInfo("whState", (Object)"1", CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            ev.setSelector(sic);
            IWarehouse iHouse = WarehouseFactory.getLocalInstance((Context)ctx);
            WarehouseCollection collection = iHouse.getWarehouseCollection(ev);
            if (collection != null && collection.size() > 0) {
                WarehouseInfo info = collection.get(0);
                if (info != null) {
                    entryInfo.setWarehosue(info);
                }
            } else {
                this.fail(ctx, "WarehouseNotExistOrInvalid", oldnumber, entriesIndex, null);
            }
        }
    }

    public void doTrackNumber(PurRequestEntryInfo entryInfo, Context ctx, String entriesIndex, String oldnumber, Object data) throws BOSException, TaskExternalException {
        String str;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getReceivedOrgUnit() != null) {
            SelectorItemCollection sic;
            FilterInfo filter;
            EntityViewInfo evi;
            TrackNumberInfo info = null;
            String key = str + entryInfo.getReceivedOrgUnit().getCU().getId().toString();
            if (this.trackNumberMap.containsKey(key)) {
                info = this.trackNumberMap.get(key);
            } else {
                evi = new EntityViewInfo();
                filter = new FilterInfo();
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str));
                filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)entryInfo.getReceivedOrgUnit().getCU().getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)80, CompareType.NOTEQUALS));
                evi.setFilter(filter);
                evi.setSelector(sic);
                ITrackNumber iTrackNumber = TrackNumberFactory.getLocalInstance((Context)ctx);
                TrackNumberCollection tnc = iTrackNumber.getTrackNumberCollection(evi);
                if (tnc != null && tnc.size() > 0) {
                    info = tnc.get(0);
                    this.trackNumberMap.put(key, info);
                }
            }
            if (info != null) {
                if (entryInfo.getProject() != null) {
                    evi = new EntityViewInfo();
                    filter = new FilterInfo();
                    sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    filter.getFilterItems().add(new FilterItemInfo("project.id", (Object)entryInfo.getProject().getId().toString()));
                    filter.getFilterItems().add(new FilterItemInfo("trackNumber.id", (Object)info.getId().toString()));
                    evi.setFilter(filter);
                    evi.setSelector(sic);
                    ProjectCarCollection pjc = ProjectCarFactory.getLocalInstance((Context)ctx).getProjectCarCollection(evi);
                    if (pjc != null && pjc.size() > 0) {
                        entryInfo.setTrackNo(info);
                    } else {
                        this.fail(ctx, "trackNumberNotInProject", oldnumber, entriesIndex, null);
                    }
                } else {
                    entryInfo.setTrackNo(info);
                }
            } else {
                this.fail(ctx, "trackNumberNotExist", oldnumber, entriesIndex, str);
            }
        }
    }

    public void doProject(PurRequestEntryInfo entryInfo, Context ctx, Object data) throws TaskExternalException {
        String str;
        if (data != null && (str = data.toString()) != null && str.length() > 0 && entryInfo.getMaterial() != null && entryInfo.getReceivedOrgUnit() != null) {
            ProjectInfo pro = this.getProject(ctx, data, entryInfo.getReceivedOrgUnit().getCU());
            MaterialPlanInfo mpInfo = this.getMaterialPlan(ctx, entryInfo.getMaterial(), entryInfo.getReceivedOrgUnit(), null, null);
            if (mpInfo != null) {
                HashSet<String> set = new HashSet<String>();
                set.add("MTO20");
                set.add("ATO20");
                ManufactureStrategyInfo strategy = mpInfo.getManufactureStrategy();
                if (strategy == null || !set.contains(strategy.getNumber())) {
                    entryInfo.setProject(pro);
                }
            } else {
                entryInfo.setProject(pro);
            }
        }
    }

    public RowTypeInfo doRowType(PurRequestInfo purRequestInfo, PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber, RowTypeInfo rowType) throws BOSException, EASBizException, TaskExternalException {
        if (purRequestInfo.getDemandType() != null) {
            RowTypeInfo rowTypeOld = purRequestInfo.getDemandType().getRowType();
            if (rowTypeOld.getId() != null && !this.rowTypeMap.containsKey(rowTypeOld.getId().toString())) {
                rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK(rowTypeOld.getId()));
                this.rowTypeMap.put(rowTypeOld.getId().toString(), rowType);
            } else if (rowTypeOld.getId() != null && this.rowTypeMap.containsKey(rowTypeOld.getId().toString())) {
                rowType = this.rowTypeMap.get(rowTypeOld.getId().toString());
            }
        }
        entryInfo.setRowType(rowType);
        if (rowType != null) {
            StorageOrgUnitInfo info;
            String str;
            entryInfo.setDestinationType(rowType.getDestinationType());
            if (rowType.getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT) {
                str = this.getData("FRequestOrgUnit_Number", hsData).toString();
                if (!com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
                    if (this.storageOrgMap.containsKey(str)) {
                        info = this.storageOrgMap.get(str);
                        if (purRequestInfo.getCompanyOrgUnit() != null && !this.isRelationOrg(ctx, 4, info.getId().toString(), purRequestInfo.getCompanyOrgUnit().getId().toString())) {
                            throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"relation_org_error", (String[])new String[]{this.getMessage(ctx, RESOURCE, "storageOrg"), info.getName(ctx.getLocale()), purRequestInfo.getCompanyOrgUnit().getName(ctx.getLocale())}, (Context)ctx));
                        }
                        entryInfo.setStorageOrgUnit(info);
                        if (null == purRequestInfo.getStorageOrgUnit()) {
                            purRequestInfo.setStorageOrgUnit(info);
                        }
                    } else {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("name"));
                        sic.add(new SelectorItemInfo("cu.id"));
                        EntityViewInfo viewInfo = this.getFilter(str);
                        viewInfo.setSelector(sic);
                        IStorageOrgUnit isto = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                        StorageOrgUnitCollection stoc = isto.getStorageOrgUnitCollection(viewInfo);
                        if (stoc != null && stoc.size() > 0) {
                            StorageOrgUnitInfo info2 = stoc.get(0);
                            if (purRequestInfo.getCompanyOrgUnit() != null && !this.isRelationOrg(ctx, 4, info2.getId().toString(), purRequestInfo.getCompanyOrgUnit().getId().toString())) {
                                throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"relation_org_error", (String[])new String[]{this.getMessage(ctx, RESOURCE, "storageOrg"), info2.getName(ctx.getLocale()), purRequestInfo.getCompanyOrgUnit().getName(ctx.getLocale())}, (Context)ctx));
                            }
                            entryInfo.setStorageOrgUnit(info2);
                            this.storageOrgMap.put(str, info2);
                            if (null == purRequestInfo.getStorageOrgUnit()) {
                                purRequestInfo.setStorageOrgUnit(info2);
                            }
                        } else {
                            this.failNotExist(ctx, RESOURCE, new String[]{"requestOrg", "storageOrg"});
                        }
                    }
                } else {
                    this.fail(ctx, "reqOrg_sto_not_null", oldnumber, entriesIndex, null);
                }
            }
            if (rowType.getRequestOrgType() == RequestOrgTypeEnum.ADMINORGUNIT) {
                str = this.getData("FRequestAdminOrgUnit_Number", hsData).toString();
                if (!com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
                    if (this.adminOrgMap.containsKey(str)) {
                        if (!this.isRelationOrg(ctx, 0, this.adminOrgMap.get(str).getId().toString(), purRequestInfo.getCompanyOrgUnit().getId().toString())) {
                            throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"relation_org_error", (String[])new String[]{this.getMessage(ctx, RESOURCE, "requestOrg"), this.adminOrgMap.get(str).getName(ctx.getLocale()), purRequestInfo.getCompanyOrgUnit().getName(ctx.getLocale())}, (Context)ctx));
                        }
                        entryInfo.setAdminOrgUnit(this.adminOrgMap.get(str));
                        if (null == purRequestInfo.getReqAdminOrgUnit()) {
                            purRequestInfo.setReqAdminOrgUnit(this.adminOrgMap.get(str));
                        }
                    } else {
                        info = this.getAdminOrgUnitInfo(ctx, str);
                        if (info != null) {
                            if (!this.isRelationOrg(ctx, 0, info.getId().toString(), purRequestInfo.getCompanyOrgUnit().getId().toString())) {
                                throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"relation_org_error", (String[])new String[]{this.getMessage(ctx, RESOURCE, "requestOrg"), info.getName(ctx.getLocale()), purRequestInfo.getCompanyOrgUnit().getName(ctx.getLocale())}, (Context)ctx));
                            }
                            entryInfo.setAdminOrgUnit((AdminOrgUnitInfo)info);
                            this.adminOrgMap.put(str, (AdminOrgUnitInfo)info);
                            if (null == purRequestInfo.getReqAdminOrgUnit()) {
                                purRequestInfo.setReqAdminOrgUnit((AdminOrgUnitInfo)info);
                            }
                        } else {
                            this.fail(ctx, RESOURCE, "ImportDataNotExist_01", new String[]{entriesIndex, this.getMessage(ctx, RESOURCE, "requestDep"), this.getMessage(ctx, RESOURCE, "adminOrg")});
                        }
                    }
                } else {
                    this.fail(ctx, "reqOrg_adm_not_null", oldnumber, entriesIndex, null);
                }
            }
        }
        return rowType;
    }

    public void doExchangeRate(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber) throws TaskExternalException, BOSException, EASBizException {
        if (this.comOrg != null) {
            if (entryInfo.getCurrency() == null || this.comOrg.getBaseCurrency() == null || entryInfo.getCurrency().getId().toString().equals(this.comOrg.getBaseCurrency().getId().toString())) {
                entryInfo.setExchangeRate(BigDecimal.ONE.setScale(2));
            } else {
                BigDecimal exchangeRate = this.getBigDecimal(ctx, this.getData("FExchangeRate", hsData), oldnumber, entriesIndex);
                ExchangeRateInfo exchangeInfo = this.getExchangeInfo(ctx, this.comOrg.getId().toString(), entryInfo.getCurrency().getId().toString(), this.comOrg.getBaseCurrency().getId().toString());
                if (exchangeRate == null) {
                    if (null != exchangeInfo) {
                        exchangeRate = exchangeInfo.getConvertRate().setScale(exchangeInfo.getExchangeAux().getPrecision(), 4);
                    }
                } else if (null != exchangeInfo) {
                    exchangeRate = exchangeRate.setScale(exchangeInfo.getExchangeAux().getPrecision(), 4);
                }
                if (exchangeRate == null) {
                    this.fail(ctx, "exchangeRateNotNull", oldnumber, entriesIndex, null);
                }
                entryInfo.setExchangeRate(exchangeRate);
            }
        }
    }

    public void doCurrency(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber) throws BOSException {
        Object data = ((DataToken)hsData.get((Object)"FCurrency_Number")).data;
        if (data != null) {
            String str = data.toString();
            if (str != null && str.length() > 0) {
                if (this.currencyMap.containsKey(str)) {
                    entryInfo.setCurrency(this.currencyMap.get(str));
                } else {
                    ICurrency icurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    CurrencyCollection collection = icurrency.getCurrencyCollection(this.getFilter(data.toString().trim()));
                    if (collection != null && collection.size() > 0) {
                        CurrencyInfo info = collection.get(0);
                        if (info != null) {
                            entryInfo.setCurrency(info);
                            this.currencyMap.put(str, info);
                        }
                    } else {
                        this.fail(ctx, "com.kingdee.eas.scm.sm.pur.PurBizResource", "CurrencyNotExists", oldnumber, entriesIndex, str);
                    }
                }
            } else {
                if (this.comOrg != null) {
                    entryInfo.setCurrency(this.comOrg.getBaseCurrency());
                }
                entryInfo.setExchangeRate(BigDecimal.ONE);
            }
        }
    }

    public void doAssistAttr(PurRequestEntryInfo entryInfo, Hashtable hsData, Context ctx, String entriesIndex, String oldnumber, MaterialInfo material) throws BOSException, TaskExternalException {
        String str;
        if (material != null && material.getAssistAttr() != null && (str = this.getData("FAssistProperty_Number", hsData).toString()) != null) {
            AsstAttrValueInfo info = this.getAsstAttr(ctx, str, material.getAssistAttr());
            entryInfo.setAssistProperty(info);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MaterialInfo doMaterial(PurRequestEntryInfo entryInfo, Context ctx, String entriesIndex, String oldnumber, Object data, MaterialInfo material, PurRequestInfo purRequestInfo) throws BOSException, TaskExternalException {
        if (data == null || data == "") throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "materialNotExist"));
        String str = data.toString();
        if (str != null && str.trim().length() > 0) {
            material = this.getMaterial(ctx, "number", str, new OrgUnitInfo[]{entryInfo.getPurchaseOrgUnit(), purRequestInfo.getCompanyOrgUnit()});
            if (null != material && !UsedStatusEnum.APPROVED.equals((Object)material.getStatus())) {
                throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurBizResource", "MATERIAL_NOT_APPROVED", new String[]{str}, ctx));
            }
            if (material == null) throw new TaskExternalException(this.getMessage(ctx, RESOURCE, "materialNotExist"));
            entryInfo.setMaterial(material);
            entryInfo.setMaterialName(material.getName());
            entryInfo.setNoNumMaterialModel(material.getModel());
            entryInfo.setBaseUnit(material.getBaseUnit());
            entryInfo.setAssistUnit(material.getAssistUnit());
            return material;
        } else {
            this.fail(ctx, "RowTypeNeedMaterial", oldnumber, entriesIndex, null);
        }
        return material;
    }

    private boolean getBooleanValue(String value, Context ctx) throws TaskExternalException {
        return (value = value.trim()).equals(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx)) || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private String getBooleanText(Context ctx, boolean value) {
        if (value) {
            return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx);
        }
        return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "not", ctx);
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizType_Number", rs.getString("bizType.number"));
            this.putTable(result, "FDemandType_Number", rs.getString("demandType.number"));
            this.putTable(result, "FCompanyOrgUnit_Number", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "Fperson_Number", rs.getString("person.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAdminOrgUnit_Number", rs.getString("adminOrg.number"));
            this.putTable(result, "FIsQuicken", this.getBooleanText(ctx, rs.getBoolean("isUrgent")));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FRequestOrgUnit_Number", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FRequestAdminOrgUnit_Number", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FPurchaseOrgUnit_Number", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterialName", rs.getString("entries.materialName"));
            this.putTable(result, "FModel", rs.getString("material.model"));
            this.putTable(result, "FAssistProperty_Number", rs.getString("assistProperty.number"));
            this.putTable(result, "FUnit_Number", rs.getString("unit.number"));
            this.putTable(result, "FRequestQty", rs.getString("entries.requestQty"));
            this.putTable(result, "FQty", rs.getString("entries.qty"));
            this.putTable(result, "FAssistQty", rs.getString("entries.assistQty"));
            this.putTable(result, "FRequirementDate", rs.getString("entries.requirementDate"));
            this.putTable(result, "FProposeDeliveryDate", rs.getString("entries.proposeDeliveryDate"));
            this.putTable(result, "FProposePurchaseDate", rs.getString("entries.proposePurchaseDate"));
            this.putTable(result, "FCurrency_Number", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getString("entries.exchangeRate"));
            this.putTable(result, "FPrice", rs.getString("entries.price"));
            this.putTable(result, "FAmount", rs.getString("entries.amount"));
            this.putTable(result, "FLocalAmount", rs.getString("entries.localAmount"));
            this.putTable(result, "FProject", rs.getString("project.number"));
            this.putTable(result, "FTrackNumber", rs.getString("trackNo.number"));
            this.putTable(result, "FPurpose", rs.getString("entries.purpose"));
            this.putTable(result, "FPurchaseGroup_Number", rs.getString("purchaseGroup.number"));
            this.putTable(result, "FPurchasePerson_Number", rs.getString("purchasePerson.number"));
            this.putTable(result, "FWareHouse_Number", rs.getString("warehosue.number"));
            this.putTable(result, "FReceivedOrgUnit", rs.getString("receivedOrgUnit.number"));
            this.putTable(result, "FDeliveryAddress", rs.getString("entries.deliveryAddress"));
            this.putTable(result, "FUseAdminOrgUnit", rs.getString("useAdminOrgUnit.number"));
            this.putTable(result, "FIsQuantityUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.isQuantityUnCtrl")));
            this.putTable(result, "Fsupplier_Number", rs.getString("supplier.number"));
            this.putTable(result, "FPurContract_Number", rs.getString("purContractID.number"));
            this.putTable(result, "Fremark", rs.getString("entries.remark"));
            this.putTable(result, "Fcreator_Number", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", rs.getString("createTime"));
            this.putTable(result, "FIsInTax", this.getBooleanText(ctx, rs.getBoolean("isInTax")));
            this.putTable(result, "FEntries_discountRate", rs.getString("entries.discountRate"));
            this.putTable(result, "FEntries_taxRate", rs.getString("entries.taxRate"));
            this.putTable(result, "FEntries_taxPrice", rs.getString("entries.taxPrice"));
            this.putTable(result, "FEntries_discountAmount", rs.getString("entries.discountAmount"));
            this.putTable(result, "FEntries_tax", rs.getString("entries.tax"));
            this.putTable(result, "FEntries_taxAmount", rs.getString("entries.taxAmount"));
            this.putTable(result, "FEntries_localTax", rs.getString("entries.localTax"));
            this.putTable(result, "FEntries_localTaxAmount", rs.getString("entries.localTaxAmount"));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private String getMessage(Context ctx, String resource, String key) {
        return PurUtil.getServerResource(resource, key, ctx);
    }

    private String getMessage(Context ctx, String resource, String key, String[] params) {
        return PurUtil.getServerResource(resource, key, params, ctx);
    }

    private void fail(Context ctx, String resource, String key, String[] params) throws TaskExternalException {
        this.msg.append(this.getMessage(ctx, resource, key, params));
    }

    private void fail(Context ctx, String resource, String key, String billnumber, String entriesIndex, String value) {
        String detaiMessage = "";
        detaiMessage = StringUtil.isEmpty((String)"value") ? this.getMessage(ctx, resource, key) : this.getMessage(ctx, resource, key, new String[]{value});
        if (billnumber != null) {
            this.msg.append(this.getMessage(ctx, RESOURCE, "BillNumberMesg", new String[]{billnumber}));
        }
        if (entriesIndex != null && entriesIndex.trim() != "") {
            this.msg.append(this.getMessage(ctx, RESOURCE, "EntriesIndexMesg", new String[]{entriesIndex}));
        }
        this.msg.append(detaiMessage);
        this.msg.append("\n");
    }

    private void fail(Context ctx, String key, String billnumber, String entriesIndex, String value) throws TaskExternalException {
        this.fail(ctx, RESOURCE, key, billnumber, entriesIndex, value);
    }

    private void failNotExist(Context ctx, String resource, String[] keys) throws TaskExternalException {
        String[] params = new String[keys.length];
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            params[i] = this.getMessage(ctx, resource, keys[i]);
        }
        this.fail(ctx, RESOURCE, "ImportDataNotExist", params);
    }

    private Object getData(String key, Hashtable hsData) {
        return ((DataToken)hsData.get((Object)key)).data;
    }

    private BigDecimal getBigDecimal(Context ctx, Object val, String number, String entriesIndex) throws TaskExternalException {
        BigDecimal bd = null;
        try {
            String str = val.toString();
            if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)str)) {
                return null;
            }
            bd = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            this.fail(ctx, "invalidBigDecimalFormat", number, entriesIndex, null);
        }
        return bd;
    }

    private Date getDate(Context ctx, Object val, boolean useDefault, String number, String entriesIndex) throws TaskExternalException {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)val.toString())) {
            if (useDefault) {
                return new Date();
            }
            return null;
        }
        try {
            val = df.parse(val.toString());
            return (Date)val;
        }
        catch (ParseException pex) {
            logger.error((Object)pex);
            this.fail(ctx, "InvalidDateFormat", number, entriesIndex, null);
            return null;
        }
    }

    private AdminOrgUnitInfo getAdminOrgUnitInfo(Context ctx, String number) throws BOSException {
        IAdminOrgUnit iao = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        AdminOrgUnitCollection aoc = iao.getAdminOrgUnitCollection(this.getFilter(number));
        if (aoc != null && aoc.size() > 0) {
            AdminOrgUnitInfo info = aoc.get(0);
            return info;
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.app.PurRequestExportQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterItmesStr = (String)this.getContextMap().get("filterItems");
        if (filterItmesStr != null) {
            FilterInfo filterInfo = null;
            SqlExpr sqlExpr = null;
            try {
                if (filterItmesStr.contains("{\"subject\"")) {
                    String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                    filterInfo = new FilterInfo(filterItems);
                } else {
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                return filterInfo;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (cuInfo == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1 or #2");
            Object parameter = this.getContextParameter("entries.id");
            if (parameter == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", parameter, CompareType.INCLUDE));
            return filterInfo;
        }
        return null;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    public int getSubmitType() {
        return 1;
    }

    private void putExchangeMap(String comId, String sourceid, String objId, ExchangeRateInfo rateInfo) {
        Map<Object, Object> map1 = new HashMap();
        if (this.exchangeMap.containsKey(comId)) {
            map1 = this.exchangeMap.get(comId);
        }
        if (!map1.containsKey(sourceid + objId)) {
            map1.put(sourceid + objId, rateInfo);
        }
    }

    private ExchangeRateInfo getExchangeMap(Context ctx, String comId, String sourceid, String objId) throws EASBizException, BOSException {
        if (!this.exchangeMap.containsKey(comId)) {
            ExchangeRateInfo tempexrateinfo = this.getExchangeInfo(ctx, comId, sourceid, objId);
            this.putExchangeMap(comId, sourceid, objId, tempexrateinfo);
            return tempexrateinfo;
        }
        if (!this.exchangeMap.get(comId).containsKey(sourceid + objId)) {
            ExchangeRateInfo tempexrateinfo = this.getExchangeInfo(ctx, comId, sourceid, objId);
            this.putExchangeMap(comId, sourceid, objId, tempexrateinfo);
            return tempexrateinfo;
        }
        return this.exchangeMap.get(comId).get(sourceid + objId);
    }

    private ExchangeRateInfo getExchangeInfo(Context ctx, String comId, String sourceid, String objId) throws BOSException, EASBizException {
        ExchangeRateInfo tempexrateinfo = null;
        ExchangeTableInfo baseExchangeTableInfo = this.comOrg.getBaseExchangeTable();
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(sourceid);
        ObjectUuidPK destCurrPK = new ObjectUuidPK(objId);
        if (baseExchangeTableInfo != null) {
            ObjectUuidPK excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
        }
        return tempexrateinfo;
    }

    public AdminOrgUnitInfo getAdminByPerson(Context ctx, String personid) throws EASBizException, BOSException {
        AdminOrgUnitInfo aAdminOrgUnitInfo = null;
        AdminOrgUnitInfo adinfo = new AdminOrgUnitInfo();
        if (personid != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            aAdminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(BOSUuid.read((String)personid));
            adinfo.setId(aAdminOrgUnitInfo.getId());
            adinfo.setName(aAdminOrgUnitInfo.getName());
            adinfo.setNumber(aAdminOrgUnitInfo.getNumber());
            AdminOrgUnitCollection adminCollection = PersonFactory.getLocalInstance((Context)ctx).getAllAdminOrgUnit(BOSUuid.read((String)personid));
            if (adminCollection != null) {
                StringBuffer adminOrgFilter = new StringBuffer();
                int size = adminCollection.size();
                for (int i = 0; i < size; ++i) {
                    AdminOrgUnitInfo AdminOrgUnitInfo2 = adminCollection.get(i);
                    if (adminOrgFilter.toString().equals("")) {
                        adminOrgFilter.append("'").append(AdminOrgUnitInfo2.getId().toString()).append("'");
                        continue;
                    }
                    adminOrgFilter.append(",").append("'").append(AdminOrgUnitInfo2.getId().toString()).append("'");
                }
                AdminOrgUnitInfo adminInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
                if (adminOrgFilter.indexOf(adminInfo.getId().toString()) != -1) {
                    adinfo = adminInfo;
                }
            }
        }
        return adinfo;
    }

    public boolean isRelationOrg(Context ctx, int orgType, String formId, String toId) throws BOSException, EASBizException {
        if (com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)formId) || com.kingdee.eas.dynbusiness.adv.chain.StringUtil.isEmpty((String)toId)) {
            return false;
        }
        boolean flag = false;
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCol = iUnitRel.getToUnit(formId, orgType, 1);
        if (null != orgCol && orgCol.size() > 0) {
            for (int i = 0; i < orgCol.size(); ++i) {
                if (!orgCol.get(i).getId().toString().equals(toId)) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    protected String getLocName(Context ctx) throws BOSException {
        return "FName_" + LocaleUtils.getLocaleString((Locale)ctx.getLocale());
    }
}

