/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgTypeRelation;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgTypeRelationFactory;
import com.kingdee.eas.basedata.org.OrgTypeRelationInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillBizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BillBizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillBizTypeInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.IBillType;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.openapi.scm.common.PurPriceOpenFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISMSDBillConfig;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigCollection;
import com.kingdee.eas.scm.common.SMSDBillConfigFactory;
import com.kingdee.eas.scm.common.SMSDBillConfigInfo;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.ISupplierQuotaFacade;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.SupplierQuotaFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequestWebFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.util.BgCtrlCallerUtil;
import com.kingdee.eas.scm.sm.pur.util.InfoUtil;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurRequestWebFacadeControllerBean
extends AbstractPurRequestWebFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequestWebFacadeControllerBean");
    private PurchaseTypeEnum purchaseType = null;

    @Override
    public Map _handleBillByOprtState(Context ctx, String billId, String oprtState, boolean isMultiOrg) throws BOSException, EASBizException {
        HashMap<String, Object> cacheData = null;
        if (StringUtils.isEmpty((String)oprtState) || StringUtils.isEmpty((String)billId)) {
            return null;
        }
        if (OprtStateConstant.EDIT.equals(oprtState)) {
            PurRequestInfo info = this.getBillInfoById(ctx, billId);
            cacheData = new HashMap<String, Object>();
            this.cachePrecision(ctx, cacheData, info);
            cacheData.put("editCtrl", PurPriceOpenFacadeFactory.getLocalInstance((Context)ctx).editCtrl((IObjectValue)info));
            cacheData.put("budgetMap", this.getBudgetMsg(ctx, info));
            cacheData.put("DISCOUNT_RATE_PRECISION", ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()), (String)"DISCOUNTRATEPRECISION"));
            RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, (IObjectValue)info, info.getCompanyOrgUnit().getId().toString());
            cacheData.put("rulestatus", ruleStatus);
        } else if (OprtStateConstant.VIEW.equals(oprtState)) {
            PurRequestInfo info = this.getBillInfoById(ctx, billId);
            cacheData = new HashMap();
            cacheData.put("newCompanyOrgUnit", info.getCompanyOrgUnit());
            this.cachePrecision(ctx, cacheData, info);
            cacheData.put("viewDemandType", info.getDemandType());
            if (info.getSourceBillType() != null) {
                cacheData.put("sourceBillType", info.getSourceBillType().getId().toString());
            }
            cacheData.put("budgetMap", this.getBudgetMsg(ctx, info));
            cacheData.put("DISCOUNT_RATE_PRECISION", ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()), (String)"DISCOUNTRATEPRECISION"));
        }
        return cacheData;
    }

    private ArrayList batchGetParamValue(Context ctx, String[] purOrgIds) throws EASBizException, BOSException {
        if (purOrgIds.length <= 0) {
            return null;
        }
        ArrayList<String> paramNumberList = new ArrayList<String>();
        ArrayList<String> orgIdStrList = new ArrayList<String>();
        for (String purorgid : purOrgIds) {
            if (StringUtil.isEmpty((String)purorgid) || orgIdStrList.contains(purorgid)) continue;
            orgIdStrList.add(purorgid);
        }
        paramNumberList.add("PURORDER003");
        paramNumberList.add("PURFIELD001");
        return ParamManager.getParamListBatch((Context)ctx, paramNumberList, orgIdStrList);
    }

    private Map<String, Object> getCacheData(Context ctx, PurRequestInfo info, boolean isMultiOrg) throws BOSException, EASBizException {
        String cid = "";
        DemandTypeInfo demandInfo = info.getDemandType();
        if (demandInfo == null || demandInfo.getRowType() == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("demandType", demandInfo);
        Set<String> couSet = this.getHasAddPermCOU(ctx, isMultiOrg);
        Map storageMap = this.cacheStorageOrgUnit(ctx, couSet, null);
        map.put("f7_storageorg", storageMap.get("f7_storageorg"));
        map.put("storageOrgUnit", storageMap.get("storageOrgUnit"));
        if (demandInfo.getRowType().getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT)) {
            Map adminMap = this.cacheReqAdminOrgUnit(ctx, couSet, null);
            map.put("f7_adminorg", adminMap.get("f7_adminorg"));
            map.put("reqAdminOrgUnit", adminMap.get("reqAdminOrgUnit"));
        }
        if (demandInfo.getPurchanseType() == PurchaseType.PURCHASE) {
            map.put("purchaseEnum", demandInfo.getPurchanseType());
            map.put("purchaseBizType", info.getBizType());
        } else {
            map.put("subcontractEnum", PurchaseTypeEnum.SUBCONTRACT);
            map.put("subcontractBizType", info.getBizType());
        }
        map.put("billTypeID", "510b6503-0105-1000-e000-0107c0a812fd463ED552");
        cid = info.getCU() == null && info.getCompanyOrgUnit().getCU() != null ? info.getCompanyOrgUnit().getCU().getId().toString() : info.getCU().getId().toString();
        String personFilter = this.getPersonF7Filter(ctx, cid);
        map.put("f7_person", personFilter);
        RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, (IObjectValue)info, info.getCompanyOrgUnit().getId().toString());
        map.put("rulestatus", ruleStatus);
        String orgId = info.getCompanyOrgUnit().getId().toString();
        String requestOrgType = demandInfo.getRowType().getRequestOrgType().getValue();
        if (requestOrgType.equals("10")) {
            String orgid = info.getStorageOrgUnit() == null ? null : info.getStorageOrgUnit().getId().toString();
            this.getSomeFilter(ctx, orgId, map, requestOrgType, orgid);
        } else {
            String orgid = info.getReqAdminOrgUnit() == null ? null : info.getReqAdminOrgUnit().getId().toString();
            this.getSomeFilter(ctx, orgId, map, requestOrgType, orgid);
        }
        return map;
    }

    @Override
    protected Map<String, Object> _createBill(Context ctx, String mainorgid, boolean isMultiOrg) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        BizTypeInfo bizTypeInfo = null;
        PurRequestInfo info = new PurRequestInfo();
        DemandTypeInfo demandInfo = this.getDemandType(ctx, null);
        if (demandInfo == null || demandInfo.getRowType() == null) {
            map.put("error", this.getServerResource("NO_AVAILABLE_DEMANDTYPE", ctx));
            return map;
        }
        info.setIsPriceInTax(true);
        info.setDemandType(demandInfo);
        Set<String> couSet = this.getHasAddPermCOU(ctx, isMultiOrg);
        Map storageMap = this.cacheStorageOrgUnit(ctx, couSet, mainorgid);
        info.put("f7_storageorg", storageMap.get("f7_storageorg"));
        if (demandInfo.getRowType().getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT) {
            if (storageMap.get("storageOrgUnit") != null) {
                info.setStorageOrgUnit((StorageOrgUnitInfo)storageMap.get("storageOrgUnit"));
                info.setCompanyOrgUnit(this.getCompanyOrgUnitInfo(ctx, info.getStorageOrgUnit().getId().toString(), RequestOrgTypeEnum.STORAGEORGUNIT));
            }
        } else {
            Map adminMap = this.cacheReqAdminOrgUnit(ctx, couSet, mainorgid);
            info.put("f7_adminorg", adminMap.get("f7_adminorg"));
            if (adminMap.get("reqAdminOrgUnit") != null) {
                info.setReqAdminOrgUnit((AdminOrgUnitInfo)adminMap.get("reqAdminOrgUnit"));
                info.setCompanyOrgUnit(this.getCompanyOrgUnitInfo(ctx, info.getReqAdminOrgUnit().getId().toString(), RequestOrgTypeEnum.ADMINORGUNIT));
            }
        }
        if (info.getCompanyOrgUnit() == null) {
            map.put("error", this.getServerResource("REQORG_NO_ADDPERMISSION", ctx));
            return map;
        }
        info.setCU(info.getCompanyOrgUnit().getCU());
        if (demandInfo.getPurchanseType().equals((Object)PurchaseType.PURCHASE)) {
            info.setPurchaseType(PurchaseTypeEnum.PURCHASE);
            bizTypeInfo = this.getBizTypeInfo(ctx, "d8e80652-0106-1000-e000-04c5c0a812202407435C");
        } else {
            info.setPurchaseType(PurchaseTypeEnum.SUBCONTRACT);
            bizTypeInfo = this.getBizTypeInfo(ctx, "1x7KMBq4mUmpj58T4jNPqiQHQ1w=");
        }
        if (!this.isBizTypeValid(ctx, "510b6503-0105-1000-e000-0107c0a812fd463ED552", bizTypeInfo).booleanValue()) {
            info.setBizType(null);
        } else {
            info.setBizType(bizTypeInfo);
        }
        IBillType iBillType = BillTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        BillTypeInfo billTypeInfo = iBillType.getBillTypeInfo((IObjectPK)new ObjectUuidPK("510b6503-0105-1000-e000-0107c0a812fd463ED552"), sic);
        info.setBillType(billTypeInfo);
        this.setDefaultPerson(ctx, info);
        Calendar cal = Calendar.getInstance();
        info.setBizDate(cal.getTime());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        info.setCreateTime(serverDate);
        CurrencyInfo currencyInfo = info.getCompanyOrgUnit().getBaseCurrency();
        HashMap<String, Integer> precisionMap = new HashMap<String, Integer>();
        if (currencyInfo != null && StringUtils.isEmpty((String)currencyInfo.getNumber())) {
            currencyInfo = this.getCurrencyInfo(ctx, currencyInfo.getId().toString());
            precisionMap.put(currencyInfo.getId().toString(), currencyInfo.getPrecision());
            info.put("precisionMap", precisionMap);
            info.put("baseCurrency", currencyInfo);
        }
        this.createEntryInfos(ctx, info, currencyInfo);
        RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, (IObjectValue)info, info.getCompanyOrgUnit().getId().toString());
        info.put("rulestatus", ruleStatus);
        info.put("DISCOUNT_RATE_PRECISION", ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(info.getCompanyOrgUnit().getId().toString()), (String)"DISCOUNTRATEPRECISION"));
        map.put("bill", info);
        return map;
    }

    public Boolean isBizTypeValid(Context ctx, String billTypeID, BizTypeInfo bizTypeInfo) throws BOSException {
        int i;
        int size;
        FilterInfo filter = new FilterInfo();
        if (!StringUtil.isEmpty((String)billTypeID)) {
            filter.getFilterItems().add(new FilterItemInfo("billType.id", (Object)billTypeID, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("selfmade", (Object)1, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        BillBizTypeCollection col = BillBizTypeFactory.getLocalInstance((Context)ctx).getBillBizTypeCollection(view);
        StringBuffer ids = new StringBuffer();
        if (!CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            BillBizTypeInfo info = null;
            size = col.size();
            for (i = 0; i < size; ++i) {
                info = (BillBizTypeInfo)col.getObject(i);
                ids.append(info.getBizType().getId().toString()).append(",");
            }
            if (ids.length() > 0) {
                ids.deleteCharAt(ids.length() - 1);
            }
        }
        if (ids.length() > 0) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
            view.setFilter(filter);
            BizTypeCollection bizCol = BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeCollection(view);
            size = bizCol.size();
            for (i = 0; i < size; ++i) {
                if (!bizCol.get(i).getId().toString().equals(bizTypeInfo.getId().toString())) continue;
                return true;
            }
        }
        return false;
    }

    private Map<String, Object> getSomeFilter(Context ctx, String orgId, Map filterMap, String requestType, String reqOrgId) throws EASBizException, BOSException {
        int i;
        StringBuilder sb;
        ArrayList<String> sourceOrgList = new ArrayList<String>();
        sourceOrgList.add(orgId);
        List<String> orgList = this.getFromUnit(ctx, sourceOrgList, 1, 0);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        CompanyOrgUnitInfo com = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId), sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)com.getCU().getId().toString(), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        FilterInfo filterInfo = null;
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(com.getCU().getId()), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        filterMap.put("trackNoF7Filer", filterInfo.toString());
        filterMap.put("projectF7Filer", InfoUtil.getProjectF7Filer(ctx, orgId));
        AdminOrgUnitCollection adminOrgUnitCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        StringBuilder admBuf = new StringBuilder();
        admBuf.append("id in (");
        if (orgList != null && orgList.size() > 0) {
            for (int i2 = 0; i2 < orgList.size(); ++i2) {
                admBuf.append("'" + orgList.get(i2) + "'").append(",");
            }
            AdminOrgUnitInfo aInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgList.get(0)));
            filterMap.put("defaultUseAdmin", aInfo);
        }
        if (null != adminOrgUnitCol && adminOrgUnitCol.size() > 0) {
            for (int i3 = 0; i3 < adminOrgUnitCol.size(); ++i3) {
                String id = adminOrgUnitCol.get(i3).getId().toString();
                if (admBuf.indexOf(id) != -1) continue;
                admBuf.append("'" + id + "'").append(",");
            }
        }
        admBuf.deleteCharAt(admBuf.length() - 1);
        admBuf.append(")");
        filterMap.put("useAdminOrgUnitF7Filter", admBuf.toString());
        IParamControl paramValue = ParamControlFactory.getLocalInstance((Context)ctx);
        ParamItemInfo paramItem = paramValue.getParamItemByNumberAndOrg("PURJICHU001", orgId);
        if (paramItem != null) {
            filterMap.put("purCtrlParamValue", paramItem.getValue());
        }
        if ((orgList = this.getFromUnit(ctx, sourceOrgList, 1, 4)) != null && orgList.size() > 0) {
            sb = new StringBuilder();
            sb.append("id in (");
            for (i = 0; i < orgList.size(); ++i) {
                sb.append("'" + orgList.get(i) + "'");
                if (i >= orgList.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
            filterMap.put("receivedOrgUnitFilter", sb.toString());
        }
        if (requestType != null && reqOrgId != null) {
            sourceOrgList.clear();
            sourceOrgList.add(reqOrgId);
            orgList = requestType.equals("20") ? this.getToUnit(ctx, sourceOrgList, 0, 3) : this.getToUnit(ctx, sourceOrgList, 4, 3);
            if (orgList != null && orgList.size() > 0) {
                sb = new StringBuilder();
                sb.append("id in (");
                for (i = 0; i < orgList.size(); ++i) {
                    sb.append("'" + orgList.get(i) + "'");
                    if (i >= orgList.size() - 1) continue;
                    sb.append(",");
                }
                sb.append(")");
                OrgViewType ovt = NewOrgViewHelper.convert((OrgType)OrgType.Purchase);
                ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
                ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)ovt));
                HashMap hm = OrgF7InnerUtils.getAuthorizedOrgViewIDs((IObjectPK)userPK, (OrgViewType)ovt, (IObjectPK)treePK, null, null);
                FilterInfo fi = new FilterInfo();
                if (hm.size() != 0) {
                    fi.getFilterItems().add(new FilterItemInfo("id", hm.keySet(), CompareType.INCLUDE));
                } else {
                    fi.getFilterItems().add(new FilterItemInfo("id", (Object)"*"));
                }
                if (fi.toSql() != null && fi.toSql().length() > 0) {
                    sb.append(" and ");
                    sb.append(fi.toSql());
                }
                filterMap.put("purchaseOrgUnitFilter", sb.toString());
            } else {
                sb = new StringBuilder();
                sb.append("id in (").append("'xxxxxxxx'").append(")");
                filterMap.put("purchaseOrgUnitFilter", sb.toString());
            }
        }
        if (requestType != null && reqOrgId != null) {
            orgList = requestType.equals(RequestOrgTypeEnum.ADMINORGUNIT) ? this.getToUnit(ctx, sourceOrgList, 0, 2) : this.getToUnit(ctx, sourceOrgList, 4, 2);
            if (orgList != null && orgList.size() > 0) {
                sb = new StringBuilder();
                sb.append("saleOrgUnit.id in ('");
                sourceOrgList.clear();
                sourceOrgList.add(orgId);
                List<String> saleOrgList = this.getFromUnit(ctx, sourceOrgList, 1, 2);
                for (int j = 0; j < saleOrgList.size(); ++j) {
                    if (!orgList.contains(saleOrgList.get(j))) continue;
                    sb.append("" + saleOrgList.get(j) + "','");
                    break;
                }
                sb.append("')");
                filterMap.put("saleOrderNumberFilter", sb.toString());
            } else {
                sb = new StringBuilder();
                sb.append("saleOrgUnit.id in (").append("'xxxxxxxx'").append(")");
                filterMap.put("saleOrderNumberFilter", sb.toString());
            }
        }
        filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = AddressFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterMap.put("deliveryAddressF7Filer", filterInfo.toString());
        return filterMap;
    }

    private List<String> getToUnit(Context ctx, List fromUnitIDs, int fromType, int toType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FTOUNITID from T_ORG_UnitRelation as r  ");
        sql.append(" inner join  T_ORG_TYPERELATION as type on r.FTYPERELATIONID = type.fid ");
        sql.append(" where r.FFROMUNITID in (").append(PurRequestWebFacadeControllerBean.listToString(fromUnitIDs)).append(")");
        sql.append(" and type.FFROMTYPE = ").append(fromType);
        sql.append(" and type.FTOTYPE = ").append(toType);
        ArrayList<String> toUnitList = new ArrayList<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                toUnitList.add(rs.getString("FTOUNITID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return toUnitList;
    }

    private List<String> getFromUnit(Context ctx, List toUnitIDs, int toUnitType, int fromUnitType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FFROMUNITID from T_ORG_UnitRelation as r  ");
        sql.append(" inner join  T_ORG_TYPERELATION as type on r.FTYPERELATIONID = type.fid ");
        sql.append(" where r.FToUNITID in (").append(PurRequestWebFacadeControllerBean.listToString(toUnitIDs)).append(")");
        sql.append(" and type.FFROMTYPE = ").append(fromUnitType);
        sql.append(" and type.FTOTYPE = ").append(toUnitType);
        ArrayList<String> fromUnitList = new ArrayList<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                fromUnitList.add(rs.getString("FFROMUNITID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fromUnitList;
    }

    public static String listToString(List ids) {
        StringBuffer idstring = new StringBuffer();
        idstring.append("'");
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) == null) continue;
            idstring.append(ids.get(i).toString()).append("','");
        }
        idstring.append("'");
        return idstring.toString();
    }

    private void createEntryInfos(Context ctx, PurRequestInfo info, CurrencyInfo currencyInfo) throws EASBizException, BOSException {
        RowTypeInfo rowType = info.getDemandType().getRowType();
        DestinationTypeEnum destinationType = rowType.getDestinationType();
        String orgId = null;
        String fromTypeStr = null;
        String toTypeStr = "Purchase";
        OrgUnitInfo purchaseOrgUnit = null;
        AdminOrgUnitInfo adminOrgInfo = null;
        AdminOrgUnitInfo useAdminOrgUnitInfo = null;
        if (destinationType.getValue().equals("20")) {
            OrgType toType;
            OrgType fromType;
            OrgUnitCollection orgCol;
            orgId = info.getReqAdminOrgUnit().getId().toString();
            fromTypeStr = "Admin";
            if (!(StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)fromTypeStr) || StringUtils.isEmpty((String)toTypeStr) || (orgCol = OrgUtils.getToOrgUnitColl((Context)ctx, (String)orgId, (OrgType)(fromType = OrgType.getEnum((String)fromTypeStr)), (OrgType)(toType = OrgType.getEnum((String)toTypeStr)))).isEmpty())) {
                purchaseOrgUnit = orgCol.get(0);
            }
            adminOrgInfo = info.getReqAdminOrgUnit();
            PersonInfo aPersonInfo = info.getPerson();
            if (aPersonInfo != null) {
                AdminOrgUnitInfo aAdminOrgUnitInfo = null;
                OrgUnitCollection collection = null;
                AdminOrgUnitCollection adminCollection = null;
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                IOrgUnitRelation iOrg = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                IOrgTypeRelation iOrgType = OrgTypeRelationFactory.getLocalInstance((Context)ctx);
                adminCollection = iPerson.getAllAdminOrgUnit(aPersonInfo.getId());
                OrgTypeRelationInfo orgRelation = iOrgType.getValue(OrgType.Admin, OrgType.Company);
                collection = iOrg.getFromUnits(orgRelation, (OrgUnitInfo)info.getCompanyOrgUnit());
                if (collection != null && adminCollection != null) {
                    int size = adminCollection.size();
                    block0: for (int i = 0; i < size; ++i) {
                        int inSize = collection.size();
                        for (int j = 0; j < inSize; ++j) {
                            if (!collection.get(j).getId().toString().equals(adminCollection.get(i).getId().toString())) continue;
                            aAdminOrgUnitInfo = adminCollection.get(i);
                            continue block0;
                        }
                    }
                }
                useAdminOrgUnitInfo = aAdminOrgUnitInfo;
            }
        }
        for (int i = 0; i < 5; ++i) {
            PurRequestEntryInfo entryInfo = new PurRequestEntryInfo();
            entryInfo.setAdminOrgUnit(adminOrgInfo);
            entryInfo.setCurrency(currencyInfo);
            entryInfo.setExchangeRate(BigDecimal.ONE);
            entryInfo.setRequirementDate(info.getBizDate());
            entryInfo.setProposeDeliveryDate(info.getBizDate());
            entryInfo.setReceivedOrgUnit(info.getStorageOrgUnit());
            entryInfo.setStorageOrgUnit(info.getStorageOrgUnit());
            entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
            entryInfo.setRowType(info.getDemandType().getRowType());
            entryInfo.setDestinationType(entryInfo.getRowType().getDestinationType());
            entryInfo.setProposePurchaseDate(info.getBizDate());
            entryInfo.setReqAdminOrgUnit(info.getAdminOrg());
            entryInfo.setPerson(info.getPerson());
            entryInfo.setPurchaseOrgUnit((PurchaseOrgUnitInfo)purchaseOrgUnit);
            entryInfo.setUseAdminOrgUnit(useAdminOrgUnitInfo);
            info.getEntries().add(entryInfo);
        }
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("precision"));
        currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        return currencyInfo;
    }

    private DemandTypeInfo getDemandType(Context ctx, String demandTypeID) throws BOSException {
        DemandTypeInfo demandInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        if (demandTypeID != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)demandTypeID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("purchanseType"));
        view.getSelector().add(new SelectorItemInfo("rowType.id"));
        view.getSelector().add(new SelectorItemInfo("rowType.name"));
        view.getSelector().add(new SelectorItemInfo("rowType.number"));
        view.getSelector().add(new SelectorItemInfo("rowType.requestOrgType"));
        view.getSelector().add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        view.getSelector().add(new SelectorItemInfo("rowType.destinationType"));
        view.getSelector().add(new SelectorItemInfo("rowType.precision"));
        SorterItemCollection sorterColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo("number");
        sortItem.setSortType(SortType.ASCEND);
        sorterColl.add(sortItem);
        view.setSorter(sorterColl);
        CoreBaseCollection col = DemandTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null && col.size() > 0) {
            demandInfo = (DemandTypeInfo)col.getObject(0);
        }
        return demandInfo;
    }

    private void setDefaultPerson(Context ctx, PurRequestInfo info) throws BOSException {
        try {
            String currentCUID = info.getCompanyOrgUnit().getCU().getId().toString();
            if (StringUtils.isEmpty((String)currentCUID)) {
                return;
            }
            IRowSet rs = this.getDefaultPersonRS(ctx, currentCUID);
            if (rs != null && rs.size() > 0) {
                PersonInfo pinfo = new PersonInfo();
                AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                if (rs.next()) {
                    pinfo.setId(BOSUuid.read((String)rs.getString("FID")));
                    pinfo.setNumber(rs.getString("FNumber"));
                    pinfo.setName(rs.getString("FName"));
                    adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FAdminID")));
                    adminOrgUnitInfo.setName(rs.getString("FAdminName"));
                    adminOrgUnitInfo.setNumber(rs.getString("FAdminNumber"));
                }
                info.setPerson(pinfo);
                info.setAdminOrg(adminOrgUnitInfo);
            }
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
    }

    private IRowSet getDefaultPersonRS(Context ctx, String cid) throws BOSException {
        if (StringUtils.isEmpty((String)cid)) {
            return null;
        }
        IObjectPK upk = ctx.getCaller();
        StringBuilder sql = new StringBuilder();
        sql.append("select p.FID as FID,p.FNumber as FNumber,p.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" as FName ");
        sql.append(",adminOrg.FID as FAdminID,adminOrg.FNumber FAdminNumber,adminOrg.FName_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale())).append(" FAdminName ");
        sql.append("from T_PM_USER u ");
        sql.append("inner join T_BD_Person p on p.FID = u.FPersonID ");
        sql.append("INNER JOIN T_ORG_PositionMember PositionMember ON P.FID = PositionMember.FPersonID ");
        sql.append("INNER JOIN T_ORG_Position Position ON PositionMember.FPositionID = Position.FID ");
        sql.append("INNER JOIN T_ORG_Admin adminOrg ON Position.FAdminOrgUnitID = adminOrg.FID ");
        sql.append("where u.FID = ? and adminOrg.FControlUnitID = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{upk.toString(), cid});
        return rs;
    }

    private String getPersonF7Filter(Context ctx, String cid) throws BOSException {
        if (StringUtils.isEmpty((String)cid)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("CU", (Object)cid, CompareType.EQUALS));
        view.setFilter(tmpFilter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        AdminOrgUnitCollection adminOrgUnitCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        if (adminOrgUnitCol.size() > 0) {
            FilterInfo tmpFilter2 = new FilterInfo();
            StringBuffer strBuffer = new StringBuffer();
            for (int i = 0; i < adminOrgUnitCol.size(); ++i) {
                strBuffer.append(adminOrgUnitCol.get(i).getId()).append(",");
            }
            strBuffer.deleteCharAt(strBuffer.length() - 1);
            tmpFilter2.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)strBuffer.toString(), CompareType.INCLUDE));
            tmpFilter2.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
            return tmpFilter2.toString();
        }
        return null;
    }

    private Set<String> getHasAddPermCOU(Context ctx, boolean isMultiOrg) throws BOSException, EASBizException {
        HashSet<String> couSet = new HashSet<String>();
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, null, this.getPermissionItem());
        if (fullCompanyColl != null && fullCompanyColl.size() > 0) {
            int size = fullCompanyColl.size();
            for (int i = 0; i < size; ++i) {
                couSet.add(fullCompanyColl.get(i).getId().toString());
            }
        }
        if (!isMultiOrg) {
            OrgUnitInfo loginOrgUnitInfo = (OrgUnitInfo)ctx.get((Object)OrgType.Company);
            if (loginOrgUnitInfo == null) {
                throw new EASBizException(new NumericExceptionSubItem("441112224", this.getServerResource("ORGVIRTUAL_FUNCTION_NOPERMISSION", ctx)));
            }
            if (!couSet.contains(loginOrgUnitInfo.getId().toString())) {
                throw new EASBizException(new NumericExceptionSubItem("441112224", this.getServerResource("COMPANYORG_NO_ADDPERMISSION", ctx)));
            }
            couSet = new HashSet();
            couSet.add(loginOrgUnitInfo.getId().toString());
        }
        return couSet;
    }

    private String getPermissionItem() {
        return "purreq_addnew";
    }

    private Map cacheStorageOrgUnit(Context ctx, Set<String> couSet, String mainorgid) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String curMainOrgid = null;
        Set<String> unitSet = this.getFromUnitsByCOU(ctx, couSet, OrgType.Storage);
        if (unitSet == null || unitSet.size() == 0) {
            return map;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", unitSet, CompareType.INCLUDE));
        HashSet<String> storageOrgids = new HashSet<String>();
        map.put("f7_storageorg", filter.toString());
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)1, CompareType.EQUALS));
        EntityViewInfo view = this.getOrgUnitEntityViewInfo(filter);
        StorageOrgUnitCollection soc = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitCollection(view);
        StorageOrgUnitInfo curSouInfo = ContextUtil.getCurrentStorageUnit((Context)ctx);
        StorageOrgUnitInfo sou = null;
        if (soc != null && soc.size() > 0) {
            int j;
            int count = soc.size();
            for (j = 0; j < count; ++j) {
                storageOrgids.add(soc.get(j).getId().toString().trim());
            }
            if (mainorgid != null) {
                HashSet<String> set = new HashSet<String>();
                set.add(mainorgid);
                Set<String> curSet = this.getFromUnitsByCOU(ctx, set, OrgType.Storage);
                if (curSet.contains(mainorgid)) {
                    curMainOrgid = mainorgid;
                } else if (curSet.size() > 0) {
                    curMainOrgid = curSet.toArray()[0].toString();
                }
                if (curMainOrgid != null) {
                    int count2 = soc.size();
                    for (int j2 = 0; j2 < count2; ++j2) {
                        if (!curMainOrgid.equals(soc.get(j2).getId().toString().trim())) continue;
                        sou = soc.get(j2);
                        break;
                    }
                }
            }
            if (sou == null) {
                count = soc.size();
                for (j = 0; j < count; ++j) {
                    if (curSouInfo == null || !curSouInfo.getId().toString().equals(soc.get(j).getId().toString().trim())) continue;
                    sou = soc.get(j);
                    break;
                }
            }
            if (sou == null) {
                sou = soc.get(0);
            }
        }
        FilterInfo sfilter = new FilterInfo();
        sfilter.getFilterItems().add(new FilterItemInfo("id", storageOrgids, CompareType.INCLUDE));
        map.put("f7_storageorg", sfilter.toString());
        map.put("storageOrgUnit", (String)sou);
        return map;
    }

    private EntityViewInfo getOrgUnitEntityViewInfo(FilterInfo filterInfo) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filterInfo);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItemInfo = new SorterItemInfo("longNumber");
        sortItemInfo.setSortType(SortType.ASCEND);
        sortColl.add(sortItemInfo);
        view.setSorter(sortColl);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("name"));
        return view;
    }

    private Set<String> getFromUnitsByCOU(Context ctx, Set<String> couSet, OrgType orgType) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (couSet == null || couSet.size() == 0) {
            return idSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("fromUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", couSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)orgType.getValue(), CompareType.EQUALS));
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        if (relCol != null && relCol.size() > 0) {
            int size = relCol.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(relCol.get(i).getFromUnit().getId().toString());
            }
        }
        return idSet;
    }

    private Map cacheReqAdminOrgUnit(Context ctx, Set<String> couSet, String mainorgid) throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        String curMainOrgid = null;
        Set<String> unitSet = this.getFromUnitsByCOU(ctx, couSet, OrgType.Admin);
        if (unitSet == null || unitSet.size() == 0) {
            return map;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", unitSet, CompareType.INCLUDE));
        map.put("f7_adminorg", filter.toString());
        filter.getFilterItems().add(new FilterItemInfo("isSealUp", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = this.getOrgUnitEntityViewInfo(filter);
        AdminOrgUnitCollection aoc = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        AdminOrgUnitInfo curAdminInfo = ContextUtil.getCurrentAdminUnit((Context)ctx);
        AdminOrgUnitInfo aou = null;
        if (aoc != null && aoc.size() > 0) {
            if (mainorgid != null) {
                HashSet<String> set = new HashSet<String>();
                set.add(mainorgid);
                Set<String> curSet = this.getFromUnitsByCOU(ctx, set, OrgType.Admin);
                if (curSet.contains(mainorgid)) {
                    curMainOrgid = mainorgid;
                } else if (curSet.size() > 0) {
                    curMainOrgid = curSet.toArray()[0].toString();
                }
                if (curMainOrgid != null) {
                    int count = aoc.size();
                    for (int j = 0; j < count; ++j) {
                        if (!curMainOrgid.equals(aoc.get(j).getId().toString().trim())) continue;
                        aou = aoc.get(j);
                        break;
                    }
                }
            }
            if (aou == null) {
                int count = aoc.size();
                for (int j = 0; j < count; ++j) {
                    if (curAdminInfo == null || !curAdminInfo.getId().toString().equals(aoc.get(j).getId().toString().trim())) continue;
                    aou = aoc.get(j);
                    break;
                }
            }
            if (aou == null) {
                aou = aoc.get(0);
            }
        }
        map.put("reqAdminOrgUnit", (String)aou);
        return map;
    }

    private BizTypeInfo getBizTypeInfo(Context ctx, String bizTypeId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("number"));
        return BizTypeFactory.getLocalInstance((Context)ctx).getBizTypeInfo((IObjectPK)new ObjectUuidPK(bizTypeId), selector);
    }

    public DemandTypeInfo cacheDemandType(Context ctx, Map<String, Object> map, String demandTypeID) throws BOSException {
        DemandTypeInfo demandInfo = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
        if (demandTypeID != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)demandTypeID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("status"));
        view.getSelector().add(new SelectorItemInfo("purchanseType"));
        view.getSelector().add(new SelectorItemInfo("rowType.id"));
        view.getSelector().add(new SelectorItemInfo("rowType.name"));
        view.getSelector().add(new SelectorItemInfo("rowType.number"));
        view.getSelector().add(new SelectorItemInfo("rowType.requestOrgType"));
        view.getSelector().add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        CoreBaseCollection col = DemandTypeFactory.getLocalInstance((Context)ctx).getCollection(view);
        if (col != null && col.size() > 0) {
            demandInfo = (DemandTypeInfo)col.getObject(0);
            map.put("demandType", demandInfo);
        }
        return demandInfo;
    }

    private boolean getISDMMsg(Context ctx) throws BOSException {
        FilterInfo filter = new FilterInfo();
        FilterItemInfo billClassNameFilter = new FilterItemInfo("billClassName", (Object)"com.kingdee.eas.scm.sm.pur.client.PurRequestEditUI", CompareType.EQUALS);
        FilterItemInfo userIDFilter = new FilterItemInfo("userID", (Object)ctx.getCaller().toString(), CompareType.EQUALS);
        filter.getFilterItems().add(billClassNameFilter);
        filter.getFilterItems().add(userIDFilter);
        EntityViewInfo ev = new EntityViewInfo();
        ev.setFilter(filter);
        ev.setSelector(SCMSelectorFactory.getSMSDBillConfigSelector());
        ISMSDBillConfig iSMSDBillConfig = SMSDBillConfigFactory.getLocalInstance((Context)ctx);
        SMSDBillConfigCollection coll = iSMSDBillConfig.getSMSDBillConfigCollection(ev);
        SMSDBillConfigInfo aSMSDBillConfig = null;
        boolean configValue = false;
        if (coll != null && coll.size() > 0) {
            for (int i = 0; i < coll.size(); ++i) {
                aSMSDBillConfig = coll.get(i);
                if (!aSMSDBillConfig.getConfigType().equals("ISDMMsg")) continue;
                configValue = aSMSDBillConfig.getConfigValue().equals("1");
            }
        }
        return configValue;
    }

    private PurRequestInfo getBillInfoById(Context ctx, String billID) throws EASBizException, BOSException {
        return PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelctorItemCollection());
    }

    private SelectorItemCollection getSelctorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("purchaseType"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("bizType.number"));
        sic.add(new SelectorItemInfo("bizType.name"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("demandType.id"));
        sic.add(new SelectorItemInfo("demandType.name"));
        sic.add(new SelectorItemInfo("demandType.number"));
        sic.add(new SelectorItemInfo("demandType.purchanseType"));
        sic.add(new SelectorItemInfo("demandType.rowType.id"));
        sic.add(new SelectorItemInfo("demandType.rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("demandType.rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("demandType.rowType.destinationType"));
        sic.add(new SelectorItemInfo("demandType.rowType.precision"));
        sic.add(new SelectorItemInfo("demandType.rowType.name"));
        sic.add(new SelectorItemInfo("demandType.rowType.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.CU.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseExchangeTable.number"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.number"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("CU.longNumber"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.seq"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.pricePrecision"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.precision"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.number"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit.number"));
        return sic;
    }

    private void cachePrecision(Context ctx, Map<String, Object> cacheData, PurRequestInfo info) throws BOSException, EASBizException {
        HashMap<String, Object> mmuConvsRate;
        HashMap<String, Object> precisionMap;
        block13: {
            int i;
            int pricePricesion;
            PurRequestEntryInfo entryInfo;
            PurRequestEntryCollection entryCol;
            block14: {
                HashSet<String> materialSet;
                block15: {
                    if (info == null) {
                        return;
                    }
                    entryCol = info.getEntries();
                    entryInfo = null;
                    materialSet = new HashSet<String>();
                    HashSet<String> unitSet = new HashSet<String>();
                    pricePricesion = 2;
                    precisionMap = new HashMap<String, Object>();
                    mmuConvsRate = new HashMap<String, Object>();
                    if (entryCol != null && entryCol.size() > 0) {
                        for (i = 0; i < entryCol.size(); ++i) {
                            entryInfo = entryCol.get(i);
                            if (entryInfo.getMaterial() != null) {
                                materialSet.add(entryInfo.getMaterial().getId().toString());
                                precisionMap.put(entryInfo.getMaterial().getId().toString(), entryInfo.getMaterial().getPricePrecision());
                            } else if (entryInfo.getUnit() != null) {
                                precisionMap.put(entryInfo.getUnit().getId().toString(), entryInfo.getUnit().getQtyPrecision());
                            }
                            if (entryInfo.getUnit() != null) {
                                unitSet.add(entryInfo.getUnit().getId().toString());
                            }
                            if (entryInfo.getBaseUnit() != null) {
                                unitSet.add(entryInfo.getBaseUnit().getId().toString());
                            }
                            if (entryInfo.getAssistUnit() != null) {
                                unitSet.add(entryInfo.getAssistUnit().getId().toString());
                            }
                            if (entryInfo.getCurrency() == null) continue;
                            precisionMap.put(entryInfo.getCurrency().getId().toString(), entryInfo.getCurrency().getPrecision());
                        }
                    }
                    if (info.getDemandType() == null) break block13;
                    if (!info.getDemandType().getRowType().isIsHasMaterialNumber()) break block14;
                    if (unitSet.size() == 0) {
                        cacheData.put("precisionMap", precisionMap);
                        return;
                    }
                    if (materialSet.size() <= 0 || unitSet.size() <= 0) break block15;
                    this.getMeasureUnitPrecision(ctx, materialSet, unitSet, precisionMap, mmuConvsRate);
                    break block13;
                }
                if (materialSet.size() <= 0) break block13;
                this.getMaterialPrecision(ctx, materialSet, precisionMap);
                break block13;
            }
            pricePricesion = info.getDemandType().getRowType().getPrecision();
            precisionMap.put("noMaterial", pricePricesion);
            if (entryCol != null && entryCol.size() > 0) {
                for (i = 0; i < entryCol.size(); ++i) {
                    entryInfo = entryCol.get(i);
                    if (entryInfo.getUnit() != null) {
                        precisionMap.put(entryInfo.getUnit().getId().toString(), entryInfo.getUnit().getQtyPrecision());
                    }
                    if (entryInfo.getBaseUnit() == null) continue;
                    precisionMap.put(entryInfo.getBaseUnit().getId().toString(), entryInfo.getBaseUnit().getQtyPrecision());
                }
            }
        }
        precisionMap.put(info.getCompanyOrgUnit().getBaseCurrency().getId().toString(), info.getCompanyOrgUnit().getBaseCurrency().getPrecision());
        cacheData.put("precisionMap", precisionMap);
        cacheData.put("mmuConvsRate", mmuConvsRate);
    }

    private void getMaterialPrecision(Context ctx, Set materialSet, Map<String, Object> precisionMap) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)materialSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("pricePrecision"));
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        MaterialInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                precisionMap.put(info.getId().toString(), info.getPricePrecision());
            }
        }
    }

    private void getMeasureUnitPrecision(Context ctx, Set materialSet, Set unitSet, Map<String, Object> precisionMap, Map<String, Object> mmuConvsRate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.pricePrecision"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        MultiMeasureUnitInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                precisionMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getQtyPrecision());
                precisionMap.put(info.getMaterial().getId().toString(), info.getMaterial().getPricePrecision());
                mmuConvsRate.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getBaseConvsRate());
            }
        }
    }

    @Override
    protected Map _handleBillByCopy(Context ctx, IObjectValue info, boolean isMultiOrg) throws BOSException, EASBizException {
        SelectorItemCollection sic;
        CompanyOrgUnitInfo couInfo;
        PurRequestInfo requestInfo = (PurRequestInfo)info;
        Map<String, Object> cacheData = this.getCacheData(ctx, requestInfo, isMultiOrg);
        if (requestInfo.getDemandType() != null) {
            DemandTypeInfo demandTypeInfo = this.getDemandType(ctx, requestInfo.getDemandType().getId().toString());
            cacheData.put("copyDemandType", demandTypeInfo);
            requestInfo.setDemandType(demandTypeInfo);
        }
        if (requestInfo.getCompanyOrgUnit() != null) {
            String couid = requestInfo.getCompanyOrgUnit().getId().toString();
            String oql = "select id,number,name,baseCurrency.id,baseCurrency.number,baseCurrency.name,baseCurrency.precision,baseExchangeTable.id,baseExchangeTable.number,baseExchangeTable.name,mainOrg where id ='" + couid + "')";
            couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
            cacheData.put("newCompanyOrgUnit", couInfo);
            requestInfo.setCompanyOrgUnit(couInfo);
            if (null != couInfo) {
                cacheData.put("DISCOUNT_RATE_PRECISION", ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(couInfo.getId().toString()), (String)"DISCOUNTRATEPRECISION"));
            }
        }
        if (requestInfo.getStorageOrgUnit() != null) {
            String souid = requestInfo.getStorageOrgUnit().getId().toString();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            couInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(souid), sic);
            cacheData.put("newStorageOrgUnit", couInfo);
        }
        if (requestInfo.getReqAdminOrgUnit() != null) {
            String adminid = requestInfo.getReqAdminOrgUnit().getId().toString();
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminid), sic);
            cacheData.put("newReqAdminOrgUnit", adminInfo);
        }
        cacheData.put("editCtrl", PurPriceOpenFacadeFactory.getLocalInstance((Context)ctx).editCtrl((IObjectValue)requestInfo));
        this.cachePrecision(ctx, cacheData, requestInfo);
        cacheData.put("budgetMap", this.getBudgetMsg(ctx, requestInfo));
        RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, info, requestInfo.getCompanyOrgUnit().getId().toString());
        cacheData.put("rulestatus", ruleStatus);
        return cacheData;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(Context ctx, String orgId, RequestOrgTypeEnum orgTypeEnum) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection orgUnitCollection;
        if (StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        CompanyOrgUnitInfo cou = null;
        int fromOrgType = 4;
        if (orgTypeEnum == RequestOrgTypeEnum.ADMINORGUNIT) {
            fromOrgType = 0;
        }
        if ((orgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(orgId, fromOrgType, 1)) != null && orgUnitCollection.size() > 0) {
            cou = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
        }
        return cou;
    }

    @Override
    protected Map _demandTypeChange(Context ctx, String id, boolean isMultiOrg) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        DemandTypeInfo demandInfo = this.getDemandType(ctx, id);
        map.put("demandType", demandInfo);
        if (demandInfo != null && demandInfo.getRowType() != null) {
            HashSet<String> couSet = new HashSet<String>();
            OrgUnitInfo loginOrgUnitInfo = (OrgUnitInfo)ctx.get((Object)OrgType.Company);
            couSet.add(loginOrgUnitInfo.getId().toString());
            Map storageMap = this.cacheStorageOrgUnit(ctx, couSet, null);
            map.put("f7_storageorg", storageMap.get("f7_storageorg"));
            map.put("storageOrgUnit", storageMap.get("storageOrgUnit"));
            if (demandInfo.getRowType().getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT)) {
                Map adminMap = this.cacheReqAdminOrgUnit(ctx, couSet, null);
                map.put("f7_adminorg", adminMap.get("f7_adminorg"));
                map.put("reqAdminOrgUnit", adminMap.get("reqAdminOrgUnit"));
            }
            if (demandInfo.getPurchanseType() == PurchaseType.PURCHASE) {
                map.put("purchaseEnum", demandInfo.getPurchanseType());
                map.put("purchaseBizType", this.getBizTypeInfo(ctx, "d8e80652-0106-1000-e000-04c5c0a812202407435C"));
            } else {
                map.put("subcontractEnum", PurchaseTypeEnum.SUBCONTRACT);
                map.put("subcontractBizType", this.getBizTypeInfo(ctx, "1x7KMBq4mUmpj58T4jNPqiQHQ1w="));
            }
        }
        return map;
    }

    @Override
    protected Map _doTransformForQuo(Context ctx, Set entryids, Map updateMap, String mappingId) throws BOSException, EASBizException {
        QuotaVOCollection result = this.getQuotaVOCollection(ctx, entryids);
        Locale locale = ctx.getLocale();
        HashMap resultMap = new HashMap();
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<QuotaVO> resultList = new ArrayList<QuotaVO>();
        String lastEntryId = null;
        for (int j = 0; j < result.size(); ++j) {
            if (lastEntryId == null || !lastEntryId.equals(result.getQuotaVO(j).getSrcBillEntryId())) {
                resultList = new ArrayList();
                resultMap.put(result.getQuotaVO(j).getSrcBillEntryId(), resultList);
            }
            lastEntryId = result.getQuotaVO(j).getSrcBillEntryId();
            resultList.add(result.getQuotaVO(j));
        }
        QuotaVOCollection quotaVOCol = new QuotaVOCollection();
        StringBuffer error = new StringBuffer();
        HashMap hasError = new HashMap();
        Object entryID = null;
        if (resultMap != null) {
            Set set = resultMap.keySet();
            Iterator iterator = set.iterator();
            HashSet<String> supplierIdSet = new HashSet<String>();
            HashSet<String> unitIdSet = new HashSet<String>();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                List quotaVOList = (List)resultMap.get(key);
                List updatelist = (List)updateMap.get(key);
                for (int j = 0; j < updatelist.size(); ++j) {
                    Map UImap = (Map)updatelist.get(j);
                    if (!UImap.get("supplierId").toString().equals("null")) {
                        supplierIdSet.add(UImap.get("supplierId").toString());
                    }
                    unitIdSet.add(UImap.get("unitId").toString());
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", supplierIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SupplierCollection supplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
            SupplierInfo supplierInfo = null;
            HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
            for (int i = 0; i < supplierCollection.size(); ++i) {
                supplierInfo = supplierCollection.get(i);
                supplierMap.put(supplierInfo.getId().toString(), supplierInfo);
            }
            EntityViewInfo view1 = new EntityViewInfo();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", unitIdSet, CompareType.INCLUDE));
            view1.setFilter(filter);
            MeasureUnitCollection unitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view1);
            MeasureUnitInfo unitInfo = null;
            HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
            for (int i = 0; i < unitCollection.size(); ++i) {
                unitInfo = unitCollection.get(i);
                unitMap.put(unitInfo.getId().toString(), unitInfo);
            }
            Iterator i = set.iterator();
            BigDecimal qty = SysConstant.BIGZERO;
            HashMap qtyMap = new HashMap();
            Boolean isQty = false;
            while (i.hasNext()) {
                String key = i.next().toString();
                List quotaVOList = (List)resultMap.get(key);
                List updatelist = (List)updateMap.get(key);
                for (int j = 0; j < updatelist.size(); ++j) {
                    QuotaVO quotaVO = (QuotaVO)((QuotaVO)quotaVOList.get(0)).clone();
                    Map UImap = (Map)updatelist.get(j);
                    supplierInfo = (SupplierInfo)supplierMap.get(UImap.get("supplierId").toString());
                    quotaVO.setSupplier(supplierInfo);
                    unitInfo = (MeasureUnitInfo)unitMap.get(UImap.get("unitId").toString());
                    quotaVO.setUnit(unitInfo);
                    quotaVO.setSplitQty(new BigDecimal(UImap.get("allocationQty").toString()));
                    quotaVO.setSplitBaseQty(new BigDecimal(UImap.get("allocationBaseQty").toString()));
                    quotaVOCol.addQuotaVO(quotaVO);
                }
            }
        }
        BTPTransformResult btpResult = SupplierQuotaFacadeFactory.getLocalInstance(ctx).createOrder(this.purchaseType, quotaVOCol, mappingId);
        IObjectCollection objColl = btpResult.getBills();
        StringBuilder billNumber = new StringBuilder();
        int size = objColl.size();
        for (int j = 0; j < size; ++j) {
            billNumber.append(objColl.getObject(j).getString("number"));
            if (j >= size - 1) continue;
            if (locale == LocaleUtils.locale_zh_CN) {
                billNumber.append("\u3001");
                continue;
            }
            billNumber.append(",");
        }
        map.put("billNumber", billNumber.toString());
        return map;
    }

    @Override
    protected Map _quotaAllocationCreatToOrder(Context ctx, Set entryIdSet, Map updateMap) throws BOSException, EASBizException {
        QuotaVOCollection result = this.getQuotaVOCollection(ctx, entryIdSet);
        result.sortForWeb();
        Locale locale = ctx.getLocale();
        LinkedHashMap resultMap = new LinkedHashMap();
        ArrayList<QuotaVO> resultList = new ArrayList<QuotaVO>();
        String lastEntryId = null;
        for (int j = 0; j < result.size(); ++j) {
            if (lastEntryId == null || !lastEntryId.equals(result.getQuotaVO(j).getSrcBillEntryId())) {
                resultList = new ArrayList();
                resultMap.put(result.getQuotaVO(j).getSrcBillEntryId(), resultList);
            }
            lastEntryId = result.getQuotaVO(j).getSrcBillEntryId();
            resultList.add(result.getQuotaVO(j));
        }
        QuotaVOCollection quotaVOCol = new QuotaVOCollection();
        StringBuffer error = new StringBuffer();
        HashMap<String, String> hasError = new HashMap<String, String>();
        String entryID = null;
        if (resultMap != null) {
            Set set = resultMap.keySet();
            Iterator iterator = set.iterator();
            HashSet<String> supplierIdSet = new HashSet<String>();
            HashSet<String> unitIdSet = new HashSet<String>();
            while (iterator.hasNext()) {
                String key = iterator.next().toString();
                List quotaVOList = (List)resultMap.get(key);
                List updatelist = (List)updateMap.get(key);
                for (int j = 0; j < updatelist.size(); ++j) {
                    Map UImap = (Map)updatelist.get(j);
                    if (!UImap.get("supplierId").toString().equals("null")) {
                        supplierIdSet.add(UImap.get("supplierId").toString());
                    }
                    unitIdSet.add(UImap.get("unitId").toString());
                }
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", supplierIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SupplierCollection supplierCollection = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
            SupplierInfo supplierInfo = null;
            HashMap<String, SupplierInfo> supplierMap = new HashMap<String, SupplierInfo>();
            for (int i = 0; i < supplierCollection.size(); ++i) {
                supplierInfo = supplierCollection.get(i);
                supplierMap.put(supplierInfo.getId().toString(), supplierInfo);
            }
            EntityViewInfo view1 = new EntityViewInfo();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", unitIdSet, CompareType.INCLUDE));
            view1.setFilter(filter);
            MeasureUnitCollection unitCollection = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(view1);
            MeasureUnitInfo unitInfo = null;
            HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
            for (int i = 0; i < unitCollection.size(); ++i) {
                unitInfo = unitCollection.get(i);
                unitMap.put(unitInfo.getId().toString(), unitInfo);
            }
            Iterator i = set.iterator();
            BigDecimal qty = SysConstant.BIGZERO;
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
            Boolean isQty = false;
            while (i.hasNext()) {
                String key = i.next().toString();
                List quotaVOList = (List)resultMap.get(key);
                List updatelist = (List)updateMap.get(key);
                for (int j = 0; j < updatelist.size(); ++j) {
                    QuotaVO quotaVO = (QuotaVO)((QuotaVO)quotaVOList.get(0)).clone();
                    Map UImap = (Map)updatelist.get(j);
                    supplierInfo = null;
                    if (!UImap.get("supplierId").toString().equals("null")) {
                        supplierInfo = (SupplierInfo)supplierMap.get(UImap.get("supplierId").toString());
                    }
                    quotaVO.setSupplier(supplierInfo);
                    unitInfo = (MeasureUnitInfo)unitMap.get(UImap.get("unitId").toString());
                    quotaVO.setUnit(unitInfo);
                    BigDecimal allocationQty = null;
                    BigDecimal unOrderedBaseQty = null;
                    allocationQty = "".equals(UImap.get("allocationQty").toString()) ? SysConstant.BIGZERO : new BigDecimal(UImap.get("allocationQty").toString());
                    quotaVO.setSplitQty(allocationQty);
                    BigDecimal allocationBaseQty = null;
                    allocationBaseQty = "".equals(UImap.get("allocationBaseQty").toString()) ? SysConstant.BIGZERO : new BigDecimal(UImap.get("allocationBaseQty").toString());
                    unOrderedBaseQty = "".equals(UImap.get("unOrderedBaseQty").toString()) ? SysConstant.BIGZERO : new BigDecimal(UImap.get("unOrderedBaseQty").toString());
                    quotaVO.setSplitBaseQty(allocationBaseQty);
                    entryID = quotaVO.getSrcBillEntryId();
                    qty = quotaVO.getSplitBaseQty();
                    if (qtyMap.containsKey(entryID)) {
                        qty = qty.add((BigDecimal)qtyMap.get(entryID));
                    }
                    qtyMap.put(entryID, qty);
                    if (j == updatelist.size() - 1 && !quotaVO.isUnCtrlQty() && qty.compareTo(unOrderedBaseQty) > 0) {
                        isQty = true;
                    }
                    if (isQty.booleanValue() || quotaVO.getSplitQty() == null || quotaVO.getSplitQty().compareTo(SysConstant.BIGZERO) == 0 || quotaVO.getSupplier() == null || quotaVO.getSupplier().getId() == null) {
                        if (!hasError.containsKey(entryID)) {
                            error.append(ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"BILL_FIELD_NUMBER", (Locale)ctx.getLocale()) + quotaVO.getNumber() + ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"NO", (Locale)ctx.getLocale()) + quotaVO.getEntrySeq() + ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ROW", (Locale)ctx.getLocale()) + "<br><br>");
                        }
                        hasError.put(entryID, quotaVO.getEntrySeq());
                        isQty = false;
                        continue;
                    }
                    quotaVOCol.addQuotaVO(quotaVO);
                }
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (error.length() > 0) {
            map.put("error", error.toString());
            map.put("errorDetail", ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"CHECKBILL", (Locale)ctx.getLocale()));
            return map;
        }
        BOTMappingInfo bOTMappingInfo = null;
        ISupplierQuotaFacade iSupplierQuotaFacade = SupplierQuotaFacadeFactory.getLocalInstance(ctx);
        BOTMappingCollection botMappingCols = iSupplierQuotaFacade.getBOTMappingInfos(this.purchaseType, result);
        if (botMappingCols.size() == 0) {
            error.append(ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"NOBOTP", (Locale)ctx.getLocale()));
            map.put("error", error.toString());
            return map;
        }
        if (botMappingCols.size() == 1) {
            bOTMappingInfo = botMappingCols.get(0);
            BTPTransformResult btpResult = iSupplierQuotaFacade.createOrder(this.purchaseType, quotaVOCol, bOTMappingInfo.getId().toString());
            IObjectCollection objColl = btpResult.getBills();
            StringBuilder billNumber = new StringBuilder();
            int size = objColl.size();
            for (int j = 0; j < size; ++j) {
                billNumber.append(objColl.getObject(j).getString("number"));
                if (j >= size - 1) continue;
                if (locale == LocaleUtils.locale_zh_CN) {
                    billNumber.append("\u3001");
                    continue;
                }
                billNumber.append(",");
            }
            map.put("billNumber", billNumber.toString());
        }
        if (botMappingCols.size() > 1) {
            map.put("botMapColl", botMappingCols);
            map.put("entryIds", entryIdSet);
        }
        return map;
    }

    private QuotaVOCollection getQuotaVOCollection(Context ctx, Set entryIdSet) throws BOSException, EASBizException {
        Object entryID = null;
        QuotaVOCollection quotaVOCollection = new QuotaVOCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(this.getSelectorsForPurReqEntry());
        PurRequestEntryCollection collection = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryCollection(view);
        PurRequestEntryInfo entryInfo = null;
        for (int i = 0; i < collection.size(); ++i) {
            entryInfo = collection.get(i);
            QuotaVO quotaVO = new QuotaVO();
            BigDecimal assOrderQty = SysConstant.BIGZERO;
            BigDecimal qty = SysConstant.BIGZERO;
            BigDecimal baseQty = SysConstant.BIGZERO;
            BigDecimal assBaseOrderQty = SysConstant.BIGZERO;
            if (entryInfo.getAssOrderBaseQty() != null) {
                assBaseOrderQty = entryInfo.getAssOrderBaseQty();
            }
            if (entryInfo.getBaseQty() != null) {
                baseQty = entryInfo.getBaseQty();
            }
            if (entryInfo.getAssOrderQty() != null) {
                assOrderQty = entryInfo.getAssOrderQty();
            }
            if (entryInfo.getQty() != null) {
                qty = entryInfo.getQty();
            }
            if (entryInfo.getStorageOrgUnit() != null) {
                quotaVO.setRecOrgUnitId(entryInfo.getStorageOrgUnit().getId().toString());
            }
            quotaVO.setUnAssBaseOrderQty(baseQty.subtract(assBaseOrderQty));
            quotaVO.setSrcBillId(entryInfo.getParent().getId().toString());
            quotaVO.setMaterialId(entryInfo.getMaterial().getId().toString());
            quotaVO.setPurOrgUnitId(entryInfo.getPurchaseOrgUnit().getId().toString());
            quotaVO.setSrcBillEntryId(entryInfo.getId().toString());
            quotaVO.setEntryQty(qty.subtract(assOrderQty));
            quotaVO.setUnitId(entryInfo.getUnit().getId().toString());
            quotaVO.setUnCtrlQty(entryInfo.isIsQuantityUnCtrl());
            quotaVO.setBaseUnitid(entryInfo.getBaseUnit().getId().toString());
            quotaVO.setBizDate(entryInfo.getParent().getBizDate());
            quotaVO.setRemainEntryQty(quotaVO.getEntryQty());
            quotaVO.setUnAssOrderQty(qty.subtract(assOrderQty));
            quotaVO.setNumber(entryInfo.getParent().getNumber());
            SupplierInfo supplier = new SupplierInfo();
            if (entryInfo.getSupplier() != null) {
                supplier.setId(BOSUuid.read((String)entryInfo.getSupplier().getId().toString()));
                supplier.setName(entryInfo.getSupplier().getName());
                supplier.setNumber(entryInfo.getSupplier().getNumber());
            }
            quotaVO.setSupplier(supplier);
            quotaVO.setEntrySeq("" + entryInfo.getSeq());
            quotaVOCollection.addQuotaVO(quotaVO);
            this.purchaseType = entryInfo.getParent().getPurchaseType();
        }
        QuotaVOCollection result = SupplierQuotaFacadeFactory.getLocalInstance(ctx).assign(this.purchaseType, quotaVOCollection);
        return result;
    }

    @Override
    protected Map _quoForRequestUIOnload(Context ctx, Set entryIdSet) throws BOSException, EASBizException {
        HashMap resultMap = new HashMap();
        if (entryIdSet.size() > 0) {
            int j;
            int i;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)entryIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(this.getSelectorsForPurReqEntry());
            PurRequestEntryCollection entryCollection = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryCollection(view);
            PurRequestEntryInfo entryInfo = null;
            Object entryID = null;
            PurchaseTypeEnum purchaseType = null;
            QuotaVOCollection quotaVOCollection = new QuotaVOCollection();
            HashMap infoMap = new HashMap();
            HashMap<String, Object> infoShareMap = null;
            HashSet<String> materialIdSet = new HashSet<String>();
            HashSet<String> purOrgIdSet = new HashSet<String>();
            for (int i2 = 0; i2 < entryCollection.size(); ++i2) {
                entryInfo = entryCollection.get(i2);
                materialIdSet.add(entryInfo.getMaterial().getId().toString());
                purOrgIdSet.add(entryInfo.getPurchaseOrgUnit().getId().toString());
            }
            EntityViewInfo view1 = new EntityViewInfo();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", purOrgIdSet, CompareType.INCLUDE));
            view1.setFilter(filter);
            MaterialPurchasingCollection materialPurchasingCollection = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
            MaterialPurchasingInfo materialPurchasingInfo = null;
            HashMap<String, SupplierInfo> materialPurOrgMap = new HashMap<String, SupplierInfo>();
            for (i = 0; i < materialPurchasingCollection.size(); ++i) {
                materialPurchasingInfo = materialPurchasingCollection.get(i);
                materialPurOrgMap.put(materialPurchasingInfo.getMaterial().getId().toString() + "|" + materialPurchasingInfo.getOrgUnit().getId().toString(), materialPurchasingInfo.getSupplier());
            }
            for (i = 0; i < entryCollection.size(); ++i) {
                entryInfo = entryCollection.get(i);
                QuotaVO quotaVO = new QuotaVO();
                BigDecimal assOrderQty = SysConstant.BIGZERO;
                BigDecimal qty = SysConstant.BIGZERO;
                BigDecimal baseQty = SysConstant.BIGZERO;
                BigDecimal assBaseOrderQty = SysConstant.BIGZERO;
                if (entryInfo.getAssOrderBaseQty() != null) {
                    assBaseOrderQty = entryInfo.getAssOrderBaseQty();
                }
                if (entryInfo.getBaseQty() != null) {
                    baseQty = entryInfo.getBaseQty();
                }
                if (assBaseOrderQty.compareTo(baseQty) >= 0) continue;
                if (entryInfo.getAssOrderQty() != null) {
                    assOrderQty = entryInfo.getAssOrderQty();
                }
                if (entryInfo.getQty() != null) {
                    qty = entryInfo.getQty();
                }
                if (entryInfo.getStorageOrgUnit() != null) {
                    quotaVO.setRecOrgUnitId(entryInfo.getStorageOrgUnit().getId().toString());
                }
                quotaVO.setUnAssBaseOrderQty(baseQty.subtract(assBaseOrderQty));
                quotaVO.setSrcBillId(entryInfo.getParent().getId().toString());
                quotaVO.setMaterialId(entryInfo.getMaterial().getId().toString());
                quotaVO.setPurOrgUnitId(entryInfo.getPurchaseOrgUnit().getId().toString());
                quotaVO.setSrcBillEntryId(entryInfo.getId().toString());
                quotaVO.setEntryQty(qty.subtract(assOrderQty));
                quotaVO.setUnitId(entryInfo.getUnit().getId().toString());
                quotaVO.setUnCtrlQty(entryInfo.isIsQuantityUnCtrl());
                quotaVO.setBaseUnitid(entryInfo.getBaseUnit().getId().toString());
                quotaVO.setBizDate(entryInfo.getParent().getBizDate());
                quotaVO.setRemainEntryQty(quotaVO.getEntryQty());
                quotaVO.setUnAssOrderQty(qty.subtract(assOrderQty));
                quotaVO.setNumber(entryInfo.getParent().getNumber());
                SupplierInfo supplier = new SupplierInfo();
                if (entryInfo.getSupplier() != null) {
                    supplier.setId(BOSUuid.read((String)entryInfo.getSupplier().getId().toString()));
                    supplier.setName(entryInfo.getSupplier().getName());
                    supplier.setNumber(entryInfo.getSupplier().getNumber());
                }
                quotaVO.setSupplier(supplier);
                quotaVO.setEntrySeq("" + entryInfo.getSeq());
                quotaVOCollection.addQuotaVO(quotaVO);
                purchaseType = entryInfo.getParent().getPurchaseType();
                infoShareMap = new HashMap<String, Object>();
                infoShareMap.put("number", entryInfo.getParent().getNumber());
                infoShareMap.put("demandTypeName", entryInfo.getParent().getDemandType().getName());
                infoShareMap.put("purchaseType", purchaseType);
                String adminOrgUnit = null;
                if (entryInfo.getParent().getStorageOrgUnit() != null) {
                    adminOrgUnit = entryInfo.getParent().getStorageOrgUnit().getName();
                } else if (entryInfo.getParent().getReqAdminOrgUnit() != null) {
                    adminOrgUnit = entryInfo.getParent().getReqAdminOrgUnit().getName();
                }
                SupplierInfo supplyInfo = (SupplierInfo)materialPurOrgMap.get(entryInfo.getMaterial().getId().toString() + "|" + entryInfo.getPurchaseOrgUnit().getId().toString());
                if (supplyInfo != null) {
                    infoShareMap.put("assSupplyInfo", supplyInfo);
                }
                infoShareMap.put("adminOrgUnit", adminOrgUnit);
                infoShareMap.put("id", entryInfo.getParent().getId().toString());
                infoShareMap.put("entryId", entryInfo.getId().toString());
                infoShareMap.put("seq", entryInfo.getSeq());
                infoShareMap.put("materialName", entryInfo.getMaterial().getName());
                infoShareMap.put("materialId", entryInfo.getMaterial().getId().toString());
                infoShareMap.put("baseUnit", entryInfo.getBaseUnit().getName());
                infoShareMap.put("baseUnitPrecision", entryInfo.getBaseUnit().getQtyPrecision());
                infoShareMap.put("baseQty", entryInfo.getBaseQty());
                infoShareMap.put("requestDate", entryInfo.getRequirementDate());
                infoShareMap.put("assOrderQty", entryInfo.getAssOrderQty());
                infoShareMap.put("assOrderBaseQty", entryInfo.getAssOrderBaseQty());
                infoShareMap.put("unOrderedBaseQty", entryInfo.getUnOrderedBaseQty());
                infoShareMap.put("isQuantityUnCtrl", entryInfo.isIsQuantityUnCtrl());
                if (entryInfo.getSupplier() != null) {
                    infoShareMap.put("supply", entryInfo.getSupplier());
                }
                if (entryInfo.getPurchaseOrgUnit() != null) {
                    infoShareMap.put("purchaseOrg", entryInfo.getPurchaseOrgUnit().getName());
                    infoShareMap.put("purOrgId", entryInfo.getPurchaseOrgUnit().getId().toString());
                }
                infoMap.put(entryInfo.getId().toString(), infoShareMap);
            }
            QuotaVOCollection result = SupplierQuotaFacadeFactory.getLocalInstance(ctx).assign(purchaseType, quotaVOCollection);
            ArrayList resultList = new ArrayList();
            String lastEntryId = null;
            HashMap<String, Object> quotaMap = null;
            HashSet<String> unitIdSet = new HashSet<String>();
            HashSet<String> baseUnitIdSet = new HashSet<String>();
            for (int j2 = 0; j2 < result.size(); ++j2) {
                unitIdSet.add(result.getQuotaVO(j2).getUnit().getId().toString());
                baseUnitIdSet.add(result.getQuotaVO(j2).getBaseUnitid());
            }
            MultiMeasureUnitInfo multiMeasureUnitInfo = null;
            MultiMeasureUnitInfo multiMeasureBaseUnitInfo = null;
            HashMap<String, MultiMeasureUnitInfo> unitMap = new HashMap<String, MultiMeasureUnitInfo>();
            HashMap<String, MultiMeasureUnitInfo> baseUnitMap = new HashMap<String, MultiMeasureUnitInfo>();
            EntityViewInfo view2 = new EntityViewInfo();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", unitIdSet, CompareType.INCLUDE));
            view2.setFilter(filter);
            MultiMeasureUnitCollection multiMeasureUnitCollection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view2);
            for (int j3 = 0; j3 < multiMeasureUnitCollection.size(); ++j3) {
                multiMeasureUnitInfo = multiMeasureUnitCollection.get(j3);
                unitMap.put(multiMeasureUnitInfo.getMaterial().getId().toString() + "|" + multiMeasureUnitInfo.getMeasureUnit().getId().toString(), multiMeasureUnitInfo);
            }
            EntityViewInfo view3 = new EntityViewInfo();
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", baseUnitIdSet, CompareType.INCLUDE));
            view3.setFilter(filter);
            MultiMeasureUnitCollection multiMeasureBaseUnitCollection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view3);
            for (j = 0; j < multiMeasureBaseUnitCollection.size(); ++j) {
                multiMeasureBaseUnitInfo = multiMeasureBaseUnitCollection.get(j);
                baseUnitMap.put(multiMeasureBaseUnitInfo.getMaterial().getId().toString() + "|" + multiMeasureBaseUnitInfo.getMeasureUnit().getId().toString(), multiMeasureBaseUnitInfo);
            }
            for (j = 0; j < result.size(); ++j) {
                quotaMap = new HashMap<String, Object>();
                quotaMap.putAll((Map)infoMap.get(result.getQuotaVO(j).getSrcBillEntryId()));
                quotaMap.put("quotaPolicyname", result.getQuotaVO(j).getQuotaPolicyname());
                if (result.getQuotaVO(j).getSupplier() != null && result.getQuotaVO(j).getSupplier().getId() != null) {
                    quotaMap.put("supply", result.getQuotaVO(j).getSupplier());
                }
                quotaMap.put("unit", result.getQuotaVO(j).getUnit());
                BigDecimal rate = new BigDecimal("1.00");
                if (result.getQuotaVO(j).getUnit().getId() != null && quotaMap.get("materialId") != null) {
                    multiMeasureUnitInfo = (MultiMeasureUnitInfo)unitMap.get(quotaMap.get("materialId").toString() + "|" + result.getQuotaVO(j).getUnit().getId().toString());
                    multiMeasureBaseUnitInfo = (MultiMeasureUnitInfo)baseUnitMap.get(quotaMap.get("materialId").toString() + "|" + result.getQuotaVO(j).getBaseUnitid());
                    quotaMap.put("baseConvsRate", multiMeasureUnitInfo.getBaseConvsRate());
                    if (multiMeasureBaseUnitInfo != null) {
                        quotaMap.put("baseUnitPrecision", multiMeasureBaseUnitInfo.getQtyPrecision());
                    }
                    int unitQtyPrecision = multiMeasureUnitInfo.getQtyPrecision();
                    result.getQuotaVO(j).getUnit().setQtyPrecision(unitQtyPrecision);
                    rate = multiMeasureUnitInfo.getBaseConvsRate();
                }
                quotaMap.put("unitId", result.getQuotaVO(j).getUnitId());
                quotaMap.put("splitQty", result.getQuotaVO(j).getSplitQty());
                BigDecimal splitBaseQty = result.getQuotaVO(j).getSplitQty().multiply(rate);
                quotaMap.put("splitBaseQty", splitBaseQty);
                if (lastEntryId == null || !lastEntryId.equals(result.getQuotaVO(j).getSrcBillEntryId())) {
                    resultList = new ArrayList();
                    resultMap.put(result.getQuotaVO(j).getSrcBillEntryId(), resultList);
                }
                lastEntryId = result.getQuotaVO(j).getSrcBillEntryId();
                resultList.add(quotaMap);
            }
        }
        return resultMap;
    }

    private SelectorItemCollection getSelectorsForPurReqEntry() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("assOrderBaseQty"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("unOrderedBaseQty"));
        sic.add(new SelectorItemInfo("isQuantityUnCtrl"));
        sic.add(new SelectorItemInfo("assOrderQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit.CU"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("requirementDate"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("unit.name"));
        sic.add(new SelectorItemInfo("unit.number"));
        sic.add(new SelectorItemInfo("unit.qtyPrecision"));
        sic.add(new SelectorItemInfo("isQuantityUnCtrl"));
        sic.add(new SelectorItemInfo("baseUnit.id"));
        sic.add(new SelectorItemInfo("baseUnit.name"));
        sic.add(new SelectorItemInfo("baseUnit.number"));
        sic.add(new SelectorItemInfo("baseUnit.qtyPrecision"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.bizDate"));
        sic.add(new SelectorItemInfo("parent.number"));
        sic.add(new SelectorItemInfo("parent.purchaseType"));
        sic.add(new SelectorItemInfo("parent.demandType.name"));
        sic.add(new SelectorItemInfo("parent.demandType.id"));
        sic.add(new SelectorItemInfo("parent.demandType.number"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.storageOrgUnit.number"));
        sic.add(new SelectorItemInfo("parent.reqAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.reqAdminOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.reqAdminOrgUnit.number"));
        return sic;
    }

    @Override
    protected Map _requsetOrgChanged(Context ctx, String orgId, String demandTypeId) throws BOSException, EASBizException {
        CompanyOrgUnitInfo cou = null;
        if (StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)demandTypeId)) {
            return null;
        }
        DemandTypeInfo demandInfo = this.getDemandType(ctx, demandTypeId);
        if (demandInfo != null && demandInfo.getRowType() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            cou = demandInfo.getRowType().getRequestOrgType() == RequestOrgTypeEnum.STORAGEORGUNIT ? this.getCompanyOrgUnitInfo(ctx, orgId, RequestOrgTypeEnum.STORAGEORGUNIT) : this.getCompanyOrgUnitInfo(ctx, orgId, RequestOrgTypeEnum.ADMINORGUNIT);
            if (cou == null) {
                return null;
            }
            CurrencyInfo currencyInfo = cou.getBaseCurrency();
            if (currencyInfo != null && StringUtils.isEmpty((String)currencyInfo.getNumber())) {
                currencyInfo = this.getCurrencyInfo(ctx, currencyInfo.getId().toString());
            }
            cou.setBaseCurrency(currencyInfo);
            map.put("companyOrgUnit", cou);
            String cid = cou.getCU().getId().toString();
            IRowSet rs = this.getDefaultPersonRS(ctx, cid);
            if (rs != null && rs.size() > 0) {
                try {
                    if (rs.next()) {
                        PersonInfo pinfo = new PersonInfo();
                        AdminOrgUnitInfo adminOrgUnitInfo = new AdminOrgUnitInfo();
                        pinfo.setId(BOSUuid.read((String)rs.getString("FID")));
                        pinfo.setNumber(rs.getString("FNumber"));
                        pinfo.setName(rs.getString("FName"));
                        adminOrgUnitInfo.setId(BOSUuid.read((String)rs.getString("FAdminID")));
                        adminOrgUnitInfo.setName(rs.getString("FAdminName"));
                        adminOrgUnitInfo.setNumber(rs.getString("FAdminNumber"));
                        map.put("person", pinfo);
                        map.put("adminOrg", adminOrgUnitInfo);
                    }
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            String f7_person = this.getPersonF7Filter(ctx, cid);
            map.put("f7_person", f7_person);
            RequestOrgTypeEnum requestOrgType = demandInfo.getRowType().getRequestOrgType();
            if (requestOrgType == RequestOrgTypeEnum.STORAGEORGUNIT) {
                this.getSomeFilter(ctx, cou.getId().toString(), map, requestOrgType.getValue(), orgId);
            } else {
                this.getSomeFilter(ctx, cou.getId().toString(), map, requestOrgType.getValue(), orgId);
            }
            PurRequestInfo info = new PurRequestInfo();
            this.handPurParams(ctx, map, requestOrgType.getValue(), orgId);
            return map;
        }
        return null;
    }

    private RuleStatus getCodeRuleStatus(Context ctx, IObjectValue model, String mainOrgId) throws BOSException, EASBizException {
        if (model != null && !StringUtils.isEmpty((String)mainOrgId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = codingRuleManager.getRuleStatus(model, mainOrgId);
            return ruleStatus;
        }
        return null;
    }

    private Map<String, String> getBudgetMsg(Context ctx, PurRequestInfo billInfo) throws BOSException, EASBizException {
        String budgetMsg = null;
        boolean isControlBudget = false;
        HashMap<String, String> map = new HashMap<String, String>();
        CompanyOrgUnitInfo companyOrgUnit = billInfo.getCompanyOrgUnit();
        try {
            isControlBudget = BgCtrlCallerUtil.isControlBudget(null, billInfo, companyOrgUnit.getId().toString(), 1, "510b6503-0105-1000-e000-0107c0a812fd463ED552");
            map.put("isControlBudget", String.valueOf(isControlBudget));
            if (isControlBudget) {
                PurRequestInfo requestInfo = PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(billInfo.getId()), BgCtrlCallerUtil.getPurRequestSelector());
                budgetMsg = BgCtrlCallerUtil.getBudgetMsg(null, (IObjectValue)requestInfo);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage();
            map.put("errorMsg", errorMsg);
        }
        map.put("budgetMsg", budgetMsg);
        return map;
    }

    @Override
    protected Map _getCacheData(Context ctx, Map params) throws BOSException, EASBizException {
        String cuid = (String)params.get("cuid");
        String companyOrgUnitId = (String)params.get("companyOrgUnitId");
        String requestorgid = (String)params.get("requestorgid");
        HashMap<String, Object> map = new HashMap<String, Object>();
        String requestOrgType = params.get("requestOrgType").toString();
        String billId = (String)params.get("billId");
        boolean isaddnew = Boolean.parseBoolean(params.get("isaddnew").toString());
        boolean isMultiOrg = Boolean.parseBoolean(params.get("isMultiOrg").toString());
        String personFilter = this.getPersonF7Filter(ctx, cuid);
        map.put("f7_person", personFilter);
        boolean iSDMMsg = this.getISDMMsg(ctx);
        map.put("ISDMMsg", iSDMMsg);
        map.put("DISCOUNT_RATE_PRECISION", ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(companyOrgUnitId), (String)"DISCOUNTRATEPRECISION"));
        this.getSomeFilter(ctx, companyOrgUnitId, map, requestOrgType, requestorgid);
        if (companyOrgUnitId != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.precision"));
            CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitId), sic);
            CurrencyInfo currencyInfo = companyOrgUnitInfo.getBaseCurrency();
            map.put("basecurrency", currencyInfo);
        }
        String companyOrgF7Filter = this.getMainOrgFilter(ctx);
        map.put("companyOrgF7Filter", companyOrgF7Filter);
        if (isaddnew) {
            return map;
        }
        String[] purorgids = params.get("purorgids").toString().split(",");
        Set<String> couSet = this.getHasAddPermCOU(ctx, isMultiOrg);
        if ("20".equals(requestOrgType)) {
            Map adminMap = this.cacheReqAdminOrgUnit(ctx, couSet, requestorgid);
            map.put("f7_adminorg", adminMap.get("f7_adminorg"));
            map.put("reqAdminOrgUnit", adminMap.get("reqAdminOrgUnit"));
        } else {
            Map storageMap = this.cacheStorageOrgUnit(ctx, couSet, requestorgid);
            map.put("f7_storageorg", storageMap.get("f7_storageorg"));
            map.put("storageOrgUnit", storageMap.get("storageOrgUnit"));
        }
        this.handPurParams(ctx, map, requestOrgType, requestorgid);
        return map;
    }

    public String getMainOrgFilter(Context ctx) throws BOSException, EASBizException {
        OrgType orgType = OrgType.Company;
        String permissionItem = this.getPermissionItem();
        OrgUnitInfo[] mainOrgs = OrgUnitUtils.getMainBizOrgList((Context)ctx, (OrgType)orgType, (String)permissionItem);
        String mainOrgFilter = "id in " + this.getOrgFilterStr(ctx, mainOrgs);
        return mainOrgFilter;
    }

    public String getOrgFilterStr(Context ctx, OrgUnitInfo[] orgs) {
        if (orgs == null || orgs.length == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < orgs.length; ++i) {
            sb.append("'").append(orgs[i].getId().toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    public void handPurParams(Context ctx, Map map, String requestOrgType, String requestorgid) throws BOSException, EASBizException {
        OrgUnitCollection orgUnitCollection;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int type = 4;
        if ("20".equals(requestOrgType)) {
            type = 0;
        }
        if (null != (orgUnitCollection = iOrgUnitRelation.getToUnit(requestorgid, type, 3)) && orgUnitCollection.size() > 0) {
            String[] idStr = new String[orgUnitCollection.size()];
            for (int i = 0; i < orgUnitCollection.size(); ++i) {
                idStr[i] = orgUnitCollection.get(i).getId().toString();
            }
            map.put("paramsMap", this.batchGetParamValue(ctx, idStr));
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)key, (Context)ctx);
    }
}

