/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementFactory;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequirementControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.apache.log4j.Logger;

public class PurRequirementControllerBean
extends AbstractPurRequirementControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 2677879478521810458L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequirementControllerBean");
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");
    private static final String[] zerofields = new String[]{"requestQty", "qty", "assistQty", "associateQty", "totalPurRequestQty"};

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurRequirementInfo purRequirementInfo = new PurRequirementInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        purRequirementInfo.setCreateTime(ts);
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"U5fWOTkYRA2hXGJ+KZy/wkY+1VI="));
        purRequirementInfo.setBillType(billTypeInfo);
        purRequirementInfo.setDemandType(this.getDefaultDemandType(ctx));
        DemandTypeInfo demandTypeInfo = purRequirementInfo.getDemandType();
        BizTypeInfo bizType = new BizTypeInfo();
        if (demandTypeInfo != null && PurchaseType.SUBCONTRACT.equals((Object)demandTypeInfo.getPurchanseType())) {
            bizType.setId(BOSUuid.read((String)"1x7KMBq4mUmpj58T4jNPqiQHQ1w="));
        } else {
            bizType.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        }
        purRequirementInfo.setBizType(bizType);
        purRequirementInfo.setBizDate(curDate);
        purRequirementInfo.setPerson(this.getPersonInfo(ctx));
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        if (purRequirementInfo.getPerson() != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitInfo aAdminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(purRequirementInfo.getPerson().getId());
            AdminOrgUnitCollection adminOrgs = iPerson.getAllAdminOrgUnit(purRequirementInfo.getPerson().getId());
            HashSet<String> adminOrgSet = new HashSet<String>();
            int size = adminOrgs.size();
            for (int i = 0; i < size; ++i) {
                if (adminOrgs.get(i) == null) continue;
                adminOrgSet.add(adminOrgs.get(i).getId().toString());
            }
            AdminOrgUnitInfo currentAdminOrg = (AdminOrgUnitInfo)ctx.get((Object)OrgType.Admin);
            adminOrgUnitInfo = currentAdminOrg != null && adminOrgSet.contains(currentAdminOrg.getId().toString()) ? currentAdminOrg : aAdminOrgUnitInfo;
            purRequirementInfo.setAdminOrg(adminOrgUnitInfo);
        }
        return purRequirementInfo;
    }

    protected String getBillTypeId() {
        return "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=";
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION") == null || Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchExecute(ctx, batchAction, batchResults);
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        if (BatchActionEnum.SUBMIT.equals((Object)batchAction)) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            int size = entries.length;
            for (int i = 0; i < size; ++i) {
                String key = null;
                if (entries[i].get(0) instanceof PurRequirementInfo) continue;
                key = entries[i].get(0).toString();
                keys.add(key);
            }
            if (keys.size() > 0) {
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
                viewInfo.setFilter(filterInfo);
                viewInfo.setSelector(this.getSelector(true));
                CoreBaseCollection billCol = this.getCollection(ctx, viewInfo);
                if (billCol.size() > 0) {
                    Object poInfo = null;
                    int size2 = entries.length;
                    for (int i = 0; i < size2; ++i) {
                        String id = null;
                        id = entries[i].get(0) instanceof PurRequirementInfo ? ((PurRequirementInfo)entries[i].get(0)).getId().toString() : entries[i].get(0).toString();
                        poInfo = billCol.get((Object)BOSUuid.read((String)id));
                        if (poInfo == null) {
                            poInfo = new PurRequestInfo();
                            poInfo.setId(BOSUuid.read((String)id));
                        }
                        entries[i] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{poInfo});
                    }
                }
            }
        }
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurRequirementInfo info = this.getPurRequirementInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx.get((Object)"CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequirementInfo model = PurRequirementFactory.getLocalInstance(ctx).getPurRequirementInfo(pk, this.getSelector());
        this.passAudit(ctx, pk, (CoreBillBaseInfo)model);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurRequirementInfo info = this.getPurRequirementInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.UNAUDIT);
    }

    protected SelectorItemCollection getSelector() {
        return SCMSelectorFactory.getPurRequirementSelector((boolean)true);
    }

    private DemandTypeInfo getDefaultDemandType(Context ctx) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        ServiceStateManager.getInstance().enableNextCallServices();
        DemandTypeCollection demandTypeColl = DemandTypeFactory.getLocalInstance((Context)ctx).getDemandTypeCollection(view);
        if (demandTypeColl != null && demandTypeColl.size() > 0) {
            return demandTypeColl.get(0);
        }
        return null;
    }

    private PersonInfo getPersonInfo(Context ctx) throws BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        PersonInfo curPerson = userInfo.getPerson();
        if (curPerson == null) {
            return null;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select p.fid from T_BD_Person as p ");
        sql.append(" inner join T_ORG_PositionMember as pm on p.fid = pm.FPersonID ");
        sql.append(" inner join T_ORG_Position as po on po.fid =pm.FPositionID");
        sql.append(" inner join T_ORG_Admin as a on po.FAdminOrgUnitID = a.fid ");
        sql.append(" inner join T_ORG_CtrlUnit as cu on cu.fid = a.FControlUnitID ");
        sql.append(" where cu.fid = '").append(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()).append("'");
        sql.append(" and p.fid = '").append(curPerson.getId().toString()).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!rowSet.next()) {
                curPerson = null;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return curPerson;
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequirementInfo info = (PurRequirementInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, null);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        PurRequirementInfo info = (PurRequirementInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue reason) throws BOSException, EASBizException {
        PurRequirementInfo info = (PurRequirementInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    protected void passCancellation(Context ctx, PurRequirementInfo info, Object reason) throws BOSException, EASBizException {
        String setReason = null;
        if (reason instanceof ReasonCodeInfo) {
            setReason = ((ReasonCodeInfo)reason).getName(ctx.getLocale());
        } else if (reason instanceof String) {
            setReason = reason.toString();
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurRequirementEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
                entries.get(i).setReason(setReason);
            }
        }
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    private void checkBeforeCancel(Context ctx, PurRequirementInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CANCEL_IS_CANCEL);
            }
            if (info.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.CANCEL_IS_AUDIT);
            }
            if (info.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.CANCEL_IS_CLOSED);
            }
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurRequirementInfo info = (PurRequirementInfo)model;
        SCMServerUtils.eliminateNULLValue((Context)ctx, (IObjectValue)info);
        PurRequirementEntryCollection entries = info.getEntries();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            this.setZero(entries.get(i));
        }
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void setZero(PurRequirementEntryInfo entry) {
        this.setBigDecimalZeros(entry, zerofields);
    }

    private void setBigDecimalZeros(PurRequirementEntryInfo entry, String[] fields) {
        Object[] zeros = new BigDecimal[]{BIGZERO};
        int length = fields.length;
        for (int i = 0; i < length; ++i) {
            String getMethodName = "get" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            String setMethodName = "set" + fields[i].substring(0, 1).toUpperCase() + fields[i].substring(1);
            try {
                Method getMethod = PurRequirementEntryInfo.class.getMethod(getMethodName, new Class[0]);
                Method setMethod = PurRequirementEntryInfo.class.getMethod(setMethodName, BigDecimal.class);
                if (getMethod == null || getMethod.invoke((Object)entry, new Object[0]) != null) continue;
                setMethod.invoke((Object)entry, zeros);
                continue;
            }
            catch (SecurityException e) {
                logger.error((Object)e);
                continue;
            }
            catch (NoSuchMethodException e) {
                logger.error((Object)e);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return super.batchSubmitRelations(ctx, entries);
    }

    protected OrgUnitCollection _getAuthOrgsByType(Context ctx, OrgType orgType, IMetaDataPK queryPK) throws BOSException, EASBizException {
        return SCMGroupServerUtils.getAuthorizedBizOrgUnitCollection((Context)ctx, (OrgType)orgType, (String)"prm_view");
    }
}

