/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.ManufactureStrategyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IDemandType;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectCarCollection;
import com.kingdee.eas.mm.project.ProjectCarInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementFactory;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.app.FilterSqlUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurRequirementDataImport
extends SCMDataImport {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequirementDataImport");
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
    private static final String RESOURCE = "com.kingdee.eas.scm.sm.pur.PurImportExportResource";
    String[] DATE_FIELDS = new String[]{"FBizDate", "FCreateTime"};
    String[] DATE_OBJS = new String[]{"bizDate", "createTime"};
    PurRequirementInfo currentPRMInfo = null;
    PurRequirementEntryInfo currentPRMEntryInfo = null;
    CompanyOrgUnitInfo comOrg = null;
    private HashMap comOrgMap = new HashMap();
    private Map<String, RowTypeInfo> rowTypeMap = new HashMap<String, RowTypeInfo>();
    private Map<String, StorageOrgUnitInfo> storageOrgMap = new HashMap<String, StorageOrgUnitInfo>();
    private Map<String, Map<String, StorageOrgUnitInfo>> storageMap = new HashMap<String, Map<String, StorageOrgUnitInfo>>();
    private UserInfo currentUserInfo = null;
    private String currentUserInfoID = null;
    BillTypeInfo billTypeInfo = null;
    String data = null;
    Object obj = null;
    ImportDataCache dataPool = new ImportDataCache();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurRequirementFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.currentPRMInfo = null;
        PurRequirementEntryInfo entryInfo = null;
        TaskExternalException tex = new TaskExternalException("");
        int k = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (k == 0) {
                try {
                    this.transmitHead(ctx, lineData);
                }
                catch (BOSException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.currentPRMInfo);
                    break;
                }
                catch (EASBizException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.currentPRMInfo);
                    break;
                }
                catch (TaskExternalException e) {
                    tex.addEntryErrorReason(i, e.getMessage());
                    this.recycleNumber(ctx, this.currentPRMInfo);
                    break;
                }
                if (this.currentPRMInfo == null) {
                    return null;
                }
            }
            try {
                entryInfo = this.transmitEntry(ctx, lineData);
            }
            catch (EASBizException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                this.recycleNumber(ctx, this.currentPRMInfo);
                break;
            }
            catch (BOSException e) {
                tex.addEntryErrorReason(i, e.getMessage());
                this.recycleNumber(ctx, this.currentPRMInfo);
                break;
            }
            catch (TaskExternalException e) {
                this.recycleNumber(ctx, this.currentPRMInfo);
                tex.addEntryErrorReason(i, e.getMessage());
            }
            ++k;
        }
        if (tex.getEntryErrorReasons().size() > 0) {
            throw tex;
        }
        return this.currentPRMInfo;
    }

    private PurRequirementInfo transmitHead(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.currentPRMInfo = new PurRequirementInfo();
        this.currentUserInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (this.currentUserInfo != null) {
            this.currentUserInfoID = this.currentUserInfo.getId().toString();
        }
        this.doCompanyOrgUnit(ctx, lineData);
        this.doNumber(ctx, this.currentPRMInfo, lineData);
        this.doDemandType(ctx, lineData);
        this.doBizType(ctx, lineData);
        this.doPerson(ctx, lineData);
        this.doAdminOrgUnit(ctx, lineData);
        this.doCreator(ctx, lineData);
        this.doDate(ctx, lineData);
        this.doBillType(ctx, lineData);
        this.doDescription(ctx, lineData);
        Date day = new Date();
        this.currentPRMInfo.setCreateTime(new Timestamp(day.getTime()));
        this.currentPRMInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        return this.currentPRMInfo;
    }

    private PurRequirementEntryInfo transmitEntry(Context ctx, Hashtable lineData) throws TaskExternalException, EASBizException, BOSException {
        this.currentPRMEntryInfo = new PurRequirementEntryInfo();
        this.currentPRMEntryInfo.setParent(this.currentPRMInfo);
        int seq = this.currentPRMInfo.getEntries().size() + 1;
        this.currentPRMEntryInfo.setSeq(seq);
        this.doEntryRowType(ctx, lineData);
        this.doEntryMaterial(ctx, lineData);
        this.doEntryAssistProperty(ctx, lineData);
        this.doEntryUnit(ctx, lineData);
        this.doEntryQty(ctx, lineData);
        this.doEntryBaseUnit(ctx, lineData);
        this.doEntryAssistUnit(ctx, lineData);
        this.doEntryRequirementDate(ctx, lineData);
        this.doEntryRequestReason(ctx, lineData);
        this.doEntryReceivedOrgUnit(ctx, lineData);
        this.doEntryUseAdminOrgUnit(ctx, lineData);
        this.doEntryWarehouse(ctx, lineData);
        this.doEntryDeliveryAddress(ctx, lineData);
        this.doEntryProjectNum(ctx, lineData);
        this.doEntryTrackNum(ctx, lineData);
        this.doEntryRemark(ctx, lineData);
        this.currentPRMEntryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        this.obj = this.getData("FEntries_isQuantityUnCtrl", lineData);
        if (this.obj == null) {
            this.currentPRMEntryInfo.setIsQuantityUnCtrl(false);
        } else {
            this.currentPRMEntryInfo.setIsQuantityUnCtrl(this.getBooleanValue(this.obj.toString(), ctx));
        }
        this.currentPRMInfo.getEntries().add(this.currentPRMEntryInfo);
        return this.currentPRMEntryInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doCompanyOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FCompanyOrgUnit_Number", lineData);
        if (this.obj == null || this.obj.toString().trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"companyOrgNotExist", (Context)ctx));
        this.data = this.obj.toString();
        try {
            this.comOrg = this.getCompanyOrgUnit(ctx, "number", this.data);
            if (this.comOrg == null) throw new TaskExternalException(SCMUtils.getResource((String)RESOURCE, (String)"companyOrgNotExist", (Context)ctx));
            this.currentPRMInfo.setCompanyOrgUnit(this.comOrg);
            this.currentPRMInfo.setCU(this.comOrg.getCU());
            if (this.currentUserInfoID == null) return;
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(this.currentUserInfoID), (IObjectPK)new ObjectUuidPK(this.comOrg.getId().toString()), "prm_addnew");
            this.comOrgMap.put(this.data, null);
            return;
        }
        catch (EASBizException e) {
            TaskExternalException te = new TaskExternalException(e.getMessage());
            throw te;
        }
    }

    private void doDemandType(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FDemandType_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.dataPool.getDemandType(this.data) == null) {
                IDemandType idemandType = DemandTypeFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)this.data, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                DemandTypeCollection collection = idemandType.getDemandTypeCollection(viewInfo);
                if (collection != null && collection.size() > 0) {
                    DemandTypeInfo info = collection.get(0);
                    if (info != null) {
                        this.currentPRMInfo.setDemandType(info);
                        this.dataPool.setDemandType(this.data, info);
                    } else {
                        this.fail(ctx, "demandTypeNotNull", this.currentPRMInfo.getNumber(), null);
                    }
                } else {
                    this.fail(ctx, "demandTypeNotExist", this.currentPRMInfo.getNumber(), null);
                }
            } else {
                this.currentPRMInfo.setDemandType(this.dataPool.getDemandType(this.data));
            }
        } else {
            this.fail(ctx, "demandTypeNotNull", this.currentPRMInfo.getNumber(), null);
        }
    }

    private void doBizType(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        DemandTypeInfo demandType = this.currentPRMInfo.getDemandType();
        if (demandType != null && PurchaseType.SUBCONTRACT.equals((Object)demandType.getPurchanseType())) {
            bizTypeInfo.setId(BOSUuid.read((String)"1x7KMBq4mUmpj58T4jNPqiQHQ1w="));
        } else {
            bizTypeInfo.setId(BOSUuid.read((String)"d8e80652-0106-1000-e000-04c5c0a812202407435C"));
        }
        this.currentPRMInfo.setBizType(bizTypeInfo);
    }

    private void doPerson(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FPerson_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            PersonInfo info = this.getPerson(ctx, this.data, RESOURCE, "requestPersonNotExist");
            this.currentPRMInfo.setPerson(info);
        } else {
            this.fail(ctx, "requestPersonNotExist", this.currentPRMInfo.getNumber(), null);
        }
    }

    private void doAdminOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FAdminOrg_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", this.data);
            this.currentPRMInfo.setAdminOrg(info);
        }
    }

    private void doCreator(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        UserInfo userInfo = null;
        userInfo = this.getCreator(ctx, lineData);
        this.currentPRMInfo.setCreator(userInfo);
    }

    private void doDate(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        Date value = null;
        for (int i = 0; i < this.DATE_FIELDS.length; ++i) {
            this.obj = this.getData(this.DATE_FIELDS[i], lineData);
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                try {
                    this.obj = this.df.parse(this.obj.toString());
                }
                catch (ParseException pex) {
                    logger.error((Object)pex);
                    this.fail(ctx, "InvalidDateFormat", this.currentPRMInfo.getNumber(), null);
                }
                if (this.obj == null || !(this.obj instanceof Date) || (value = (Date)this.obj) == null) continue;
                this.currentPRMInfo.setDate(this.DATE_OBJS[i], value);
                continue;
            }
            if ("FBizDate".equalsIgnoreCase(this.DATE_FIELDS[i])) {
                this.fail(ctx, "requestDateNotNull", this.currentPRMInfo.getNumber(), null);
            }
            if (!"FCreateTime".equalsIgnoreCase(this.DATE_FIELDS[i])) continue;
            this.currentPRMInfo.setDate(this.DATE_OBJS[i], new Date());
        }
    }

    private void doBillType(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.billTypeInfo = new BillTypeInfo();
        this.billTypeInfo.setId(BOSUuid.read((String)"U5fWOTkYRA2hXGJ+KZy/wkY+1VI="));
        this.currentPRMInfo.setBillType(this.billTypeInfo);
    }

    private void doDescription(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FDescription", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.data.length() > 255) {
                this.data = this.data.substring(0, 255);
            }
            this.currentPRMInfo.setDescription(this.data);
        }
    }

    private void doEntryRowType(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        RowTypeInfo rowType = null;
        RowTypeInfo rowTypeOld = this.currentPRMInfo.getDemandType().getRowType();
        if (rowTypeOld.getId() != null && !this.rowTypeMap.containsKey(rowTypeOld.getId().toString())) {
            rowType = RowTypeFactory.getLocalInstance((Context)ctx).getRowTypeInfo((IObjectPK)new ObjectUuidPK(rowTypeOld.getId()));
            this.rowTypeMap.put(rowTypeOld.getId().toString(), rowType);
        } else if (rowTypeOld.getId() != null && this.rowTypeMap.containsKey(rowTypeOld.getId().toString())) {
            rowType = this.rowTypeMap.get(rowTypeOld.getId().toString());
        }
        this.currentPRMEntryInfo.setRowType(rowType);
    }

    private void doEntryMaterial(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        RowTypeInfo rowType = this.currentPRMEntryInfo.getRowType();
        if (rowType.isIsHasMaterialNumber()) {
            this.obj = this.getData("FMaterial_Number", lineData);
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                this.data = this.obj.toString();
                MaterialInfo info = this.getMaterial(ctx, "number", this.data, null);
                this.currentPRMEntryInfo.setMaterial(info);
                this.currentPRMEntryInfo.setMaterialName(info.getName());
                this.currentPRMEntryInfo.setNoNumMaterialModel(info.getModel());
                this.currentPRMEntryInfo.setBaseUnit(info.getBaseUnit());
                this.currentPRMEntryInfo.setAssistUnit(info.getAssistUnit());
            } else {
                this.fail(ctx, "RowTypeNeedMaterial", this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
            }
        } else {
            this.obj = this.getData("FMaterial_Name", lineData);
            if (this.obj != null && this.obj.toString().trim().length() > 0) {
                this.data = this.obj.toString();
                this.currentPRMEntryInfo.setMaterial(null);
                this.currentPRMEntryInfo.setMaterialName(this.data);
                this.obj = this.getData("FModel", lineData);
                if (this.obj != null && this.obj.toString().trim().length() > 0) {
                    this.data = this.obj.toString();
                    this.currentPRMEntryInfo.setNoNumMaterialModel(this.data);
                }
            } else {
                this.fail(ctx, "RowTypeNotNeedMaterial", this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
            }
        }
    }

    private void doEntryAssistProperty(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        MaterialInfo material = this.currentPRMEntryInfo.getMaterial();
        if (material == null) {
            return;
        }
        if (material.getAssistAttr() == null) {
            return;
        }
        this.obj = this.getData("FAssistProperty_Number", lineData);
        AsstAttrValueInfo info = this.getAsstAttr(ctx, this.obj, material.getAssistAttr());
        this.currentPRMEntryInfo.setAssistProperty(info);
    }

    private void doEntryUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FUnit_Number", lineData);
        boolean flag = false;
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            MeasureUnitInfo unitInfo = this.getMeasureUnit(ctx, this.data, this.currentPRMEntryInfo.getMaterial());
            this.currentPRMEntryInfo.setUnit(unitInfo);
        }
    }

    private void doEntryQty(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        MaterialInfo material = this.currentPRMEntryInfo.getMaterial();
        int qtyPrecision = 4;
        if (material != null && this.currentPRMEntryInfo.getUnit() != null) {
            MultiMeasureUnitInfo multiUnifInfo = this.getMultiMeasureUnitInfo(ctx, this.currentPRMEntryInfo.getMaterial().getId().toString(), this.currentPRMEntryInfo.getUnit().getId().toString());
            qtyPrecision = multiUnifInfo.getQtyPrecision();
        }
        if (material == null && this.currentPRMEntryInfo.getUnit() != null) {
            qtyPrecision = this.currentPRMEntryInfo.getUnit().getQtyPrecision();
        }
        BigDecimal requestQty = this.getBigDecimal(ctx, this.getData("FRequestQty", lineData), this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
        BigDecimal qty = this.getBigDecimal(ctx, this.getData("FQty", lineData), this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
        if (requestQty == null) {
            requestQty = BigDecimal.ZERO;
        }
        if (qty == null) {
            qty = BigDecimal.ZERO;
        }
        if (requestQty.compareTo(BigDecimal.ZERO) == -1) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"REQUESTQTY_NOT_NEGATIVE", (Context)ctx));
        }
        if (qty.compareTo(BigDecimal.ZERO) == -1) {
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"QTY_NOT_NEGATIVE", (Context)ctx));
        }
        this.currentPRMEntryInfo.setRequestQty(requestQty.setScale(qtyPrecision, 4));
        this.currentPRMEntryInfo.setAssociateQty(qty.setScale(qtyPrecision, 4));
        this.currentPRMEntryInfo.setQty(qty.setScale(qtyPrecision, 4));
    }

    private void doEntryBaseUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        if (this.currentPRMEntryInfo.getMaterial() != null && this.currentPRMEntryInfo.getMaterial().getBaseUnit().getId() != null) {
            MeasureUnitInfo baseUnitInfo = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(this.currentPRMEntryInfo.getMaterial().getBaseUnit().getId()));
            this.currentPRMEntryInfo.setBaseUnit(baseUnitInfo);
            if (this.currentPRMEntryInfo.getUnit() != null && this.currentPRMEntryInfo.getQty() != null) {
                BigDecimal baseUnitQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)this.currentPRMEntryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)this.currentPRMEntryInfo.getUnit(), (MeasureUnitInfo)this.currentPRMEntryInfo.getBaseUnit(), (BigDecimal)this.currentPRMEntryInfo.getQty());
                this.currentPRMEntryInfo.setBaseQty(baseUnitQty);
                this.currentPRMEntryInfo.setAssociateBaseQty(baseUnitQty);
            }
        } else {
            this.currentPRMEntryInfo.setBaseUnit(this.currentPRMEntryInfo.getUnit());
            this.currentPRMEntryInfo.setBaseQty(this.currentPRMEntryInfo.getQty());
            this.currentPRMEntryInfo.setAssociateBaseQty(this.currentPRMEntryInfo.getQty());
        }
    }

    private void doEntryAssistUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        if (this.currentPRMEntryInfo.getMaterial() != null && this.currentPRMEntryInfo.getMaterial().getAssistUnit() != null) {
            this.obj = this.getData("FAssistQty", lineData);
            try {
                BigDecimal assistQty = this.getBigDecimal(ctx, this.obj, this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
                if (assistQty != null && assistQty.compareTo(BigDecimal.ZERO) == -1) {
                    throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ASSITQTY_NOT_NEGATIVE", (Context)ctx));
                }
                this.currentPRMEntryInfo.setAssistQty(assistQty);
            }
            catch (Exception e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        } else {
            this.currentPRMEntryInfo.setAssistQty(SCMConstant.BIGDECIMAL_ZERO);
        }
    }

    private void doEntryRequirementDate(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FRequirementDate", lineData);
        Date requirementDate = null;
        try {
            requirementDate = this.obj != null && this.obj.toString().trim().length() > 0 ? this.df.parse(this.obj.toString()) : new Date();
        }
        catch (ParseException pex) {
            logger.error((Object)pex);
            this.fail(ctx, "InvalidDateFormat", this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
        }
        this.currentPRMEntryInfo.setRequirementDate(requirementDate);
    }

    private void doEntryRequestReason(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FRequestReason", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.data.length() > 255) {
                this.data = this.data.substring(0, 255);
            }
            this.currentPRMEntryInfo.setRequestReason(this.data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doEntryReceivedOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FReceivedOrgUnit_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            CompanyOrgUnitInfo com = this.currentPRMInfo.getCompanyOrgUnit();
            this.handFromStorageOrgMap(ctx, com);
            this.data = this.obj.toString();
            if (!this.storageMap.containsKey(com.getNumber()) || !this.storageMap.get(com.getNumber()).containsKey(this.data)) throw new TaskExternalException(this.data + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"IMPORT_STRO_ERROR", (Context)ctx));
            this.currentPRMEntryInfo.setReceivedOrgUnit(this.storageMap.get(com.getNumber()).get(this.data));
            return;
        } else {
            if (this.currentPRMEntryInfo.getRowType().getRequestOrgType() != RequestOrgTypeEnum.STORAGEORGUNIT) return;
            throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"IMPORT_STRO_ERROR", (Context)ctx));
        }
    }

    private void handFromStorageOrgMap(Context ctx, CompanyOrgUnitInfo com) throws EASBizException, BOSException {
        if (null != com && !this.storageMap.containsKey(com.getNumber())) {
            OrgUnitCollection orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getFromUnit(com.getId().toString(), 1, 4);
            StringBuffer ids = new StringBuffer();
            StorageOrgUnitInfo info = null;
            HashMap<String, StorageOrgUnitInfo> map = new HashMap<String, StorageOrgUnitInfo>();
            int size = orgCol.size();
            for (int i = 0; i < size; ++i) {
                info = (StorageOrgUnitInfo)orgCol.get(i);
                if (!info.isIsBizUnit()) continue;
                map.put(info.getNumber(), info);
            }
            this.storageMap.put(com.getNumber(), map);
        }
    }

    private void doEntryUseAdminOrgUnit(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FUseAdminOrgUnit_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            AdminOrgUnitInfo info = this.getAdminOrgUnit(ctx, "number", this.data);
            this.currentPRMEntryInfo.setUseAdminOrgUnit(info);
        }
    }

    private void doEntryWarehouse(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        StorageOrgUnitInfo receiveOrgInfo = this.currentPRMEntryInfo.getReceivedOrgUnit();
        MaterialInfo material = this.currentPRMEntryInfo.getMaterial();
        this.obj = this.getData("FWarehouse_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            if (receiveOrgInfo == null || receiveOrgInfo.getId() == null) {
                return;
            }
            this.data = this.obj.toString();
            String number = this.data + "_" + receiveOrgInfo.getId().toString();
            if (this.dataPool.getAdminOrgUnitInfo(number) == null) {
                EntityViewInfo ev = this.getFilter(this.data.toString().trim());
                FilterInfo f = ev.getFilter();
                f.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)receiveOrgInfo.getId().toString()));
                IWarehouse iHouse = WarehouseFactory.getLocalInstance((Context)ctx);
                WarehouseCollection collection = iHouse.getWarehouseCollection(ev);
                if (collection != null && collection.size() > 0) {
                    WarehouseInfo info = collection.get(0);
                    if (info != null) {
                        this.currentPRMEntryInfo.setWarehouse(info);
                        this.dataPool.setWarehouseInfo(number, info);
                    }
                } else {
                    this.fail(ctx, "WarehouseNotExistOrInvalid", this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
                }
            } else {
                this.currentPRMEntryInfo.setWarehouse(this.dataPool.getWarehouseInfo(number));
            }
        }
    }

    private void doEntryDeliveryAddress(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FDeliveryAddress", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.data.length() > 255) {
                this.data = this.data.substring(0, 255);
            }
            this.currentPRMEntryInfo.setDeliveryAddress(this.data);
        }
    }

    private void doEntryProjectNum(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FProject_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.currentPRMEntryInfo.getMaterial() != null && this.currentPRMEntryInfo.getReceivedOrgUnit() != null) {
                ProjectInfo pro = this.getProject(ctx, this.data, this.currentPRMEntryInfo.getReceivedOrgUnit().getCU());
                MaterialPlanInfo mpc = this.getMaterialPlan(ctx, this.currentPRMEntryInfo.getMaterial(), this.currentPRMEntryInfo.getReceivedOrgUnit(), null, null);
                if (mpc != null && mpc.size() > 0) {
                    HashSet<String> set = new HashSet<String>();
                    set.add("MTS10");
                    set.add("MTS11");
                    set.add("MTS20");
                    set.add("ETO10");
                    set.add("ETO20");
                    ManufactureStrategyInfo strategy = mpc.getManufactureStrategy();
                    if (strategy == null || set.contains(strategy.getNumber())) {
                        this.currentPRMEntryInfo.setProject(pro);
                    }
                } else {
                    this.currentPRMEntryInfo.setProject(pro);
                }
            }
        }
    }

    private void doEntryTrackNum(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FTrackNo_Number", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.currentPRMEntryInfo.getReceivedOrgUnit() != null) {
                TrackNumberInfo info = this.getTrackNumber(ctx, this.data, this.currentPRMEntryInfo.getReceivedOrgUnit().getCU());
                if (this.currentPRMEntryInfo.getProject() != null) {
                    ProjectCarCollection pjc = this.currentPRMEntryInfo.getProject().getCarNumberRange();
                    if (pjc != null) {
                        boolean isFound = false;
                        int size = pjc.size();
                        for (int i = 0; i < size; ++i) {
                            String tr_proj;
                            ProjectCarInfo pci = pjc.get(i);
                            if (pci.getTrackNumber() == null || !(tr_proj = pci.getTrackNumber().getId().toString()).equals(info.getId().toString())) continue;
                            this.currentPRMEntryInfo.setTrackNo(info);
                            isFound = true;
                            break;
                        }
                        if (!isFound) {
                            this.fail(ctx, "trackNumberNotInProject", this.currentPRMInfo.getNumber(), String.valueOf(this.currentPRMEntryInfo.getSeq()));
                        }
                    }
                } else {
                    this.currentPRMEntryInfo.setTrackNo(info);
                }
            }
        }
    }

    private void doEntryRemark(Context ctx, Hashtable lineData) throws TaskExternalException, BOSException, EASBizException {
        this.obj = this.getData("FRemark", lineData);
        if (this.obj != null && this.obj.toString().trim().length() > 0) {
            this.data = this.obj.toString();
            if (this.data.length() > 255) {
                this.data = this.data.substring(0, 255);
            }
            this.currentPRMEntryInfo.setRemark(this.data);
        }
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FDemandType_Number", rs.getString("demandType.number"));
            this.putTable(result, "FCompanyOrgUnit_Number", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FCompanyOrgUnit_Name", rs.getString("companyOrgUnit.name"));
            this.putTable(result, "FPerson_Number", rs.getString("person.number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAdminOrg_Number", rs.getString("adminOrg.number"));
            this.putTable(result, "FAdminOrg_Name", rs.getString("adminOrg.name"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FMaterial_Number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_Name", rs.getString("material.name"));
            this.putTable(result, "FModel", rs.getString("material.model"));
            this.putTable(result, "FAssistProperty_Number", rs.getString("assistProperty.number"));
            this.putTable(result, "FUnit_Number", rs.getString("unit.number"));
            this.putTable(result, "FRequestQty", rs.getString("entries.requestQty"));
            this.putTable(result, "FQty", rs.getString("entries.qty"));
            this.putTable(result, "FBaseUnit_Number", rs.getString("baseUnit.number"));
            this.putTable(result, "FBaseQty", rs.getString("entries.baseQty"));
            this.putTable(result, "FAssistUnit_Number", rs.getString("assistUnit.number"));
            this.putTable(result, "FAssistQty", rs.getString("entries.assistQty"));
            this.putTable(result, "FRequirementDate", rs.getString("entries.requirementDate"));
            this.putTable(result, "FRequestReason", rs.getString("entries.requestReason"));
            this.putTable(result, "FProject_Number", rs.getString("project.number"));
            this.putTable(result, "FTrackNo_Number", rs.getString("trackNo.number"));
            this.putTable(result, "FWarehouse_Number", rs.getString("warehouse.number"));
            this.putTable(result, "FReceivedOrgUnit_Number", rs.getString("receivedOrgUnit.number"));
            this.putTable(result, "FReceivedOrgUnit_Name", rs.getString("receivedOrgUnit.name"));
            this.putTable(result, "FDeliveryAddress", rs.getString("entries.deliveryAddress"));
            this.putTable(result, "FUseAdminOrgUnit_Number", rs.getString("useAdminOrgUnit.number"));
            this.putTable(result, "FUseAdminOrgUnit_Name", rs.getString("useAdminOrgUnit.name"));
            this.putTable(result, "FRemark", rs.getString("entries.remark"));
            this.putTable(result, "FCreator_Number", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", this.timeToDateFormat(rs.getString("createTime")));
            this.putTable(result, "FEntries_isQuantityUnCtrl", this.getBooleanText(ctx, rs.getBoolean("entries.isQuantityUnCtrl")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        return result;
    }

    private String getBooleanText(Context ctx, boolean value) {
        if (value) {
            return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx);
        }
        return PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "not", ctx);
    }

    private boolean getBooleanValue(String value, Context ctx) throws TaskExternalException {
        return (value = value.trim()).equals(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx)) || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private String timeToDateFormat(String time) throws ParseException {
        if (time == null) {
            return time;
        }
        Date toDate = this.df.parse(time);
        return this.df.format(toDate).toString();
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        String filterItmesStr = (String)this.getContextMap().get("filterItems");
        if (filterItmesStr != null) {
            FilterInfo filterInfo = null;
            SqlExpr sqlExpr = null;
            try {
                if (filterItmesStr.contains("{\"subject\"")) {
                    String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                    filterInfo = new FilterInfo(filterItems);
                } else {
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                return filterInfo;
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        } else {
            FilterInfo filterInfo = new FilterInfo();
            CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
            if (cuInfo == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
            filterInfo.setMaskString("#0 or #1 or #2");
            Object parameter = this.getContextParameter("entries.id");
            if (parameter == null) {
                return filterInfo;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", parameter, CompareType.INCLUDE));
            return filterInfo;
        }
        return null;
    }

    private BigDecimal getBigDecimal(Context ctx, Object val, String number, String entriesIndex) throws TaskExternalException {
        BigDecimal bd = null;
        try {
            String str = val.toString();
            if (StringUtil.isEmptyString((String)str)) {
                return null;
            }
            bd = new BigDecimal(str);
        }
        catch (NumberFormatException e) {
            this.fail(ctx, "invalidBigDecimalFormat", number, String.valueOf(entriesIndex));
        }
        return bd;
    }

    private UserInfo getUserFromNumber(Context ctx, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection(this.getFilter(number.toString().trim()))) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    private void fail(Context ctx, String key, String number, String entriesIndex) throws TaskExternalException {
        StringBuffer errorMesg = new StringBuffer();
        errorMesg.append(this.getMessage(ctx, key));
        throw new TaskExternalException(errorMesg.toString());
    }

    private void fail(Context ctx, String resource, String key, String billnumber, String entriesIndex, String value) throws TaskExternalException {
        StringBuffer detaiMessage = new StringBuffer();
        detaiMessage.append(this.getMessage(ctx, RESOURCE, "BillNumberMesg", new String[]{billnumber}));
        if (entriesIndex != null && entriesIndex.trim() != "") {
            detaiMessage.append(this.getMessage(ctx, RESOURCE, "EntriesIndexMesg", new String[]{entriesIndex}));
        }
        if (com.kingdee.eas.scm.common.util.StringUtil.isEmpty((String)value)) {
            detaiMessage.append(this.getMessage(ctx, resource, key));
        } else {
            detaiMessage.append(this.getMessage(ctx, resource, key, new String[]{value}));
        }
        throw new TaskExternalException(detaiMessage.toString());
    }

    private String getMessage(Context ctx, String resource, String key, String[] params) {
        return PurUtil.getServerResource(resource, key, params, ctx);
    }

    private String getMessage(Context ctx, String resource, String key) {
        return PurUtil.getServerResource(resource, key, ctx);
    }

    private void fail(Context ctx, String key, String[] params) throws TaskExternalException {
        throw new TaskExternalException(this.getMessage(ctx, key, params));
    }

    private void failNotExist(Context ctx, String[] keys) throws TaskExternalException {
        String[] params = new String[keys.length];
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            params[i] = this.getMessage(ctx, keys[i]);
        }
        this.fail(ctx, "ImportDataNotExist", params);
    }

    private String getMessage(Context ctx, String key) {
        return PurUtil.getServerResource(RESOURCE, key, ctx);
    }

    private String getMessage(Context ctx, String key, String[] params) {
        return PurUtil.getServerResource(RESOURCE, key, params, ctx);
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    private Object getData(String key, Hashtable hsData) {
        return ((DataToken)hsData.get((Object)key)).data;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.app.PurRequirementQuery";
    }

    public int getSubmitType() {
        return 1;
    }
}

