/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AddressFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeCollection;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementFactory;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequirementWebFacadeControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurRequirementWebFacadeControllerBean
extends AbstractPurRequirementWebFacadeControllerBean {
    private static final long serialVersionUID = 1099358757835930443L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequirementWebFacadeControllerBean");

    @Override
    protected Map _getCacheData(Context ctx, Map params) throws BOSException, EASBizException {
        boolean isaddnew = Boolean.parseBoolean(params.get("isAddnew").toString());
        HashMap<String, String> map = new HashMap<String, String>();
        String cid = (String)params.get("companyOrgUnitId");
        String currentOrgUnitID = (String)params.get("currentOrgUnitId");
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullCompanyColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Company, null, this.getPermissionItem());
        map.put("companyOrgF7Filter", "id in " + this.getOrgFilterStr(ctx, (AbstractObjectCollection)fullCompanyColl) + " and companyOrgUnit.isBizUnit=1");
        String billId = (String)params.get("billId");
        String personFilter = null;
        ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
        String isReqPerson = scmParam.getParamByBillTypeID("PRM_PERSON_01", 1, cid, "U5fWOTkYRA2hXGJ+KZy/wkY+1VI=");
        personFilter = isReqPerson != null && isReqPerson.trim().length() != 0 && (isReqPerson.trim().equalsIgnoreCase("1") || isReqPerson.equalsIgnoreCase("true")) ? " deletedStatus = 1 " : this.getPersonF7Filter(ctx, cid);
        map.put("f7_person", personFilter);
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cid));
        StorageOrgUnitInfo storageOrg = (StorageOrgUnitInfo)this.getStorageOrgUnit(ctx, companyOrgUnitInfo, currentOrgUnitID).get(companyOrgUnitInfo.getId().toString());
        map.put("storageOrgUnit", (String)storageOrg);
        String warehouseFilter = "id ='xxxxxxxxxxxxxx'";
        if (null != storageOrg) {
            warehouseFilter = this.getWarehouseF7Filter(storageOrg);
        }
        map.put("f7_warehouse", warehouseFilter);
        map.put("projectF7Filer", this.getProjectF7Filer(ctx, cid));
        map.put("trackNumberF7Filer", this.getTrackNumberF7Filer(ctx, cid));
        map.put("receivedOrgUnitFilter", this.getReceivedOrgUnitFilter(ctx, cid));
        map.put("useAdminOrgUnitF7Filter", this.getUseAdminOrgUnitF7Filter(ctx, cid));
        map.put("deliveryaddrF7Filter", this.getDeliverAddF7Filter(ctx, cid));
        if (!isaddnew) {
            // empty if block
        }
        return map;
    }

    private String getUseAdminOrgUnitF7Filter(Context ctx, String orgid) throws BOSException, EASBizException {
        int i;
        ArrayList<String> sourceOrgList = new ArrayList<String>();
        sourceOrgList.add(orgid);
        List<String> orgList = this.getFromUnit(ctx, sourceOrgList, 1, 0);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("CU.id"));
        CompanyOrgUnitInfo com = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid), sic);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)com.getCU().getId().toString(), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        view.setSelector(sic);
        AdminOrgUnitCollection adminOrgUnitCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        StringBuilder admBuf = new StringBuilder();
        admBuf.append("id in (");
        if (orgList != null && orgList.size() > 0) {
            for (i = 0; i < orgList.size(); ++i) {
                admBuf.append("'" + orgList.get(i) + "'").append(",");
            }
        }
        if (null != adminOrgUnitCol && adminOrgUnitCol.size() > 0) {
            for (i = 0; i < adminOrgUnitCol.size(); ++i) {
                String id = adminOrgUnitCol.get(i).getId().toString();
                if (admBuf.indexOf(id) != -1) continue;
                admBuf.append("'" + id + "'").append(",");
            }
        }
        admBuf.deleteCharAt(admBuf.length() - 1);
        admBuf.append(")");
        return admBuf.toString();
    }

    private List<String> getFromUnit(Context ctx, List toUnitIDs, int toUnitType, int fromUnitType) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select r.FFROMUNITID from T_ORG_UnitRelation as r  ");
        sql.append(" inner join  T_ORG_TYPERELATION as type on r.FTYPERELATIONID = type.fid ");
        sql.append(" where r.FToUNITID in (").append(PurRequirementWebFacadeControllerBean.listToString(toUnitIDs)).append(")");
        sql.append(" and type.FFROMTYPE = ").append(fromUnitType);
        sql.append(" and type.FTOTYPE = ").append(toUnitType);
        ArrayList<String> fromUnitList = new ArrayList<String>();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                fromUnitList.add(rs.getString("FFROMUNITID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return fromUnitList;
    }

    public static String listToString(List ids) {
        StringBuffer idstring = new StringBuffer();
        idstring.append("'");
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) == null) continue;
            idstring.append(ids.get(i).toString()).append("','");
        }
        idstring.append("'");
        return idstring.toString();
    }

    private String getReceivedOrgUnitFilter(Context ctx, String orgid) throws EASBizException, BOSException {
        Set<String> idSet = this.getFromUnit(ctx, orgid, OrgType.Storage);
        StringBuilder sb = new StringBuilder();
        if (idSet != null && idSet.size() > 0) {
            sb.append("id in (");
            for (int i = 0; i < idSet.size(); ++i) {
                sb.append("'" + idSet.toArray()[i] + "'");
                if (i >= idSet.size() - 1) continue;
                sb.append(",");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    private Set<String> getFromUnit(Context ctx, String orgid, OrgType orgType) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (StringUtil.isEmpty((String)orgid)) {
            return idSet;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("fromUnit.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("toUnit.id", (Object)orgid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)orgType.getValue(), CompareType.EQUALS));
        view.setFilter(filter);
        OrgUnitRelationCollection relCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        if (relCol != null && relCol.size() > 0) {
            int size = relCol.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(relCol.get(i).getFromUnit().getId().toString());
            }
        }
        return idSet;
    }

    public String getTrackNumberF7Filer(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getProjectF7Filer(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    private String getadminFilter(Context ctx) throws BOSException, EASBizException {
        StringBuffer ids = new StringBuffer("111111111111111111111111111=");
        AdminOrgUnitInfo aAdminOrgUnitInfo = null;
        Object person = null;
        if (person != null) {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            aAdminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(person.getId());
            AdminOrgUnitCollection adminOrgs = iPerson.getAllAdminOrgUnit(person.getId());
            if (adminOrgs != null && adminOrgs.size() > 0) {
                ids.setLength(0);
                int size = adminOrgs.size();
                for (int i = 0; i < size; ++i) {
                    if (i > 0) {
                        ids.append(",");
                    }
                    ids.append(adminOrgs.get(i).getId().toString());
                }
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        return view.toString();
    }

    @Override
    protected Map _createBill(Context ctx, String mainorgId, boolean isMultiOrg) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PurRequirementInfo info = (PurRequirementInfo)PurRequirementFactory.getLocalInstance(ctx).createNewData(false);
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainorgId));
        if (companyOrgUnitInfo != null) {
            info.setCompanyOrgUnit(companyOrgUnitInfo);
        }
        if (info.getCompanyOrgUnit() == null) {
            map.put("error", this.getServerResource("COMPANYORG_NO_ADDPERMISSION", ctx));
            return map;
        }
        DemandTypeInfo demandInfo = info.getDemandType();
        if (demandInfo == null || demandInfo.getRowType() == null) {
            map.put("error", this.getServerResource("NO_AVAILABLE_DEMANDTYPE", ctx));
            return map;
        }
        info.setDemandType(demandInfo);
        Calendar cal = Calendar.getInstance();
        info.setBizDate(cal.getTime());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setCU(companyOrgUnitInfo.getCU());
        map.put("bill", info);
        return map;
    }

    private DemandTypeInfo getDefaultDemandType(Context ctx, String demandTypeID) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.name"));
        sic.add(new SelectorItemInfo("rowType.number"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)1));
        if (demandTypeID != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)demandTypeID, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        DemandTypeCollection demandTypeColl = DemandTypeFactory.getLocalInstance((Context)ctx).getDemandTypeCollection(view);
        if (demandTypeColl != null && demandTypeColl.size() > 0) {
            return demandTypeColl.get(0);
        }
        return null;
    }

    private String getPersonF7Filter(Context ctx, String cid) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        EntityViewInfo view2 = new EntityViewInfo();
        FilterInfo tmpFilter2 = new FilterInfo();
        CompanyOrgUnitInfo info = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(cid));
        String cuid = " ";
        if (info != null) {
            SelectorItemCollection sic;
            if (info.getCU() == null) {
                sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("cu"));
                ICompanyOrgUnit iCom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                info.setCU(iCom.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic).getCU());
            }
            cuid = info.getCU().getId().toString();
            tmpFilter.getFilterItems().add(new FilterItemInfo("CU", (Object)cuid, CompareType.EQUALS));
            view.setFilter(tmpFilter);
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            view.setSelector(sic);
            AdminOrgUnitCollection adminOrgUnitCol = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
            if (adminOrgUnitCol.size() > 0) {
                StringBuffer strBuffer = new StringBuffer();
                for (int i = 0; i < adminOrgUnitCol.size(); ++i) {
                    strBuffer.append(adminOrgUnitCol.get(i).getId()).append(",");
                }
                strBuffer.deleteCharAt(strBuffer.length() - 1);
                tmpFilter2.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)strBuffer.toString(), CompareType.INCLUDE));
                tmpFilter2.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)1, CompareType.EQUALS));
                view2.setFilter(tmpFilter2);
            }
        } else {
            tmpFilter2.getFilterItems().add(new FilterItemInfo("id", (Object)" ", CompareType.EQUALS));
            view2.setFilter(tmpFilter2);
        }
        return tmpFilter2.toString();
    }

    private Map getStorageOrgUnit(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String currentOrgUnitID) throws EASBizException, BOSException {
        HashMap<String, StorageOrgUnitInfo> defaultStorageForCompany = new HashMap<String, StorageOrgUnitInfo>();
        if (companyOrgUnitInfo == null) {
            return null;
        }
        StorageOrgUnitInfo orgUnit = null;
        if (defaultStorageForCompany.containsKey(companyOrgUnitInfo.getId().toString())) {
            orgUnit = (StorageOrgUnitInfo)defaultStorageForCompany.get(companyOrgUnitInfo.getId().toString());
        } else {
            orgUnit = this.getDefaultStorageOrgUnit(ctx, companyOrgUnitInfo, currentOrgUnitID);
            defaultStorageForCompany.put(companyOrgUnitInfo.getId().toString(), orgUnit);
        }
        return defaultStorageForCompany;
    }

    private StorageOrgUnitInfo getDefaultStorageOrgUnit(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, String currentOrgUnitID) throws BOSException, EASBizException {
        if (companyOrgUnitInfo == null) {
            return null;
        }
        StorageOrgUnitInfo orgUnit = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitColl = iOrgUnitRelation.getFromUnit(companyOrgUnitInfo.getId().toString(), 1, 4);
        if (orgUnitColl != null && orgUnitColl.size() > 0) {
            int count = orgUnitColl.size();
            for (int j = 0; j < count; ++j) {
                if (!currentOrgUnitID.equals(orgUnitColl.get(j).getId().toString().trim()) || !((StorageOrgUnitInfo)orgUnitColl.get(j)).isIsBizUnit() || ((StorageOrgUnitInfo)orgUnitColl.get(j)).isIsSealUp()) continue;
                orgUnit = (StorageOrgUnitInfo)orgUnitColl.get(j);
                break;
            }
            if (orgUnit == null) {
                for (int i = 0; orgUnitColl != null && i < orgUnitColl.size(); ++i) {
                    if (!((StorageOrgUnitInfo)orgUnitColl.get(i)).isIsBizUnit() || ((StorageOrgUnitInfo)orgUnitColl.get(i)).isIsSealUp()) continue;
                    orgUnit = (StorageOrgUnitInfo)orgUnitColl.get(i);
                    break;
                }
            }
        }
        return orgUnit;
    }

    private String getWarehouseF7Filter(StorageOrgUnitInfo storageOrgUnitInfo) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("FstorageOrgID", (Object)storageOrgUnitInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(tmpFilter);
        return view.toString();
    }

    private String getPermissionItem() {
        return "prm_addnew";
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)key, (Context)ctx);
    }

    private String getOrgFilterStr(Context ctx, AbstractObjectCollection orgCollection) throws BOSException, EASBizException {
        if (orgCollection == null || orgCollection.size() == 0) {
            return "('xxxxxxxx')";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        for (int i = 0; i < orgCollection.size(); ++i) {
            sb.append("'").append(orgCollection.getObject(i).get("id").toString()).append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        return sb.toString();
    }

    @Override
    protected Map _handleBillByOprtState(Context ctx, String billId, String oprtState, boolean isMultiOrg) throws BOSException, EASBizException {
        HashMap<String, Object> cacheData = null;
        if (StringUtils.isEmpty((String)oprtState) || StringUtils.isEmpty((String)billId)) {
            return null;
        }
        if (OprtStateConstant.EDIT.equals(oprtState)) {
            PurRequirementInfo info = this.getBillInfoById(ctx, billId);
            cacheData = new HashMap<String, Object>();
            this.cachePrecision(ctx, cacheData, info);
            RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, (IObjectValue)info, info.getCompanyOrgUnit().getId().toString());
            cacheData.put("rulestatus", ruleStatus);
        } else if (OprtStateConstant.VIEW.equals(oprtState)) {
            PurRequirementInfo info = this.getBillInfoById(ctx, billId);
            cacheData = new HashMap();
            cacheData.put("newCompanyOrgUnit", info.getCompanyOrgUnit());
            this.cachePrecision(ctx, cacheData, info);
            cacheData.put("viewDemandType", info.getDemandType());
            if (info.getSourceBillType() != null) {
                cacheData.put("sourceBillType", info.getSourceBillType().getId().toString());
            }
        }
        return cacheData;
    }

    @Override
    protected Map _handleBillByCopy(Context ctx, IObjectValue info, boolean isMultiOrg) throws BOSException, EASBizException {
        PurRequirementInfo requestInfo = (PurRequirementInfo)info;
        HashMap<String, Object> cacheData = new HashMap<String, Object>();
        if (requestInfo.getDemandType() != null) {
            DemandTypeInfo demandTypeInfo = this.getDefaultDemandType(ctx, requestInfo.getDemandType().getId().toString());
            cacheData.put("copyDemandType", demandTypeInfo);
            requestInfo.setDemandType(demandTypeInfo);
        }
        if (requestInfo.getCompanyOrgUnit() != null) {
            String couid = requestInfo.getCompanyOrgUnit().getId().toString();
            String oql = "select id,number,name,baseCurrency.id,baseCurrency.number,baseCurrency.name,baseCurrency.precision,baseExchangeTable.id,baseExchangeTable.number,baseExchangeTable.name,mainOrg where id ='" + couid + "')";
            CompanyOrgUnitInfo couInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo(oql);
            cacheData.put("newCompanyOrgUnit", couInfo);
            requestInfo.setCompanyOrgUnit(couInfo);
        }
        this.cachePrecision(ctx, cacheData, requestInfo);
        RuleStatus ruleStatus = this.getCodeRuleStatus(ctx, info, requestInfo.getCompanyOrgUnit().getId().toString());
        cacheData.put("rulestatus", ruleStatus);
        return cacheData;
    }

    private RuleStatus getCodeRuleStatus(Context ctx, IObjectValue model, String mainOrgId) throws BOSException, EASBizException {
        if (model != null && !StringUtils.isEmpty((String)mainOrgId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = codingRuleManager.getRuleStatus(model, mainOrgId);
            return ruleStatus;
        }
        return null;
    }

    private void cachePrecision(Context ctx, Map<String, Object> cacheData, PurRequirementInfo info) throws BOSException, EASBizException {
        int i;
        if (info == null) {
            return;
        }
        PurRequirementEntryCollection entryCol = info.getEntries();
        PurRequirementEntryInfo entryInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        HashMap<String, Object> mmuConvsRate = new HashMap<String, Object>();
        HashMap<String, Object> precisionMap = new HashMap<String, Object>();
        if (entryCol != null && entryCol.size() > 0) {
            for (i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                if (entryInfo.getMaterial() != null) {
                    materialSet.add(entryInfo.getMaterial().getId().toString());
                }
                if (entryInfo.getUnit() != null) {
                    unitSet.add(entryInfo.getUnit().getId().toString());
                }
                if (entryInfo.getBaseUnit() != null) {
                    unitSet.add(entryInfo.getBaseUnit().getId().toString());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                unitSet.add(entryInfo.getAssistUnit().getId().toString());
            }
        }
        if (info.getDemandType() != null) {
            if (info.getDemandType().getRowType().isIsHasMaterialNumber()) {
                if (unitSet.size() == 0) {
                    cacheData.put("precisionMap", precisionMap);
                    return;
                }
                if (materialSet.size() > 0 && unitSet.size() > 0) {
                    this.getMeasureUnitPrecision(ctx, materialSet, unitSet, precisionMap, mmuConvsRate);
                } else if (unitSet.size() > 0 && entryCol != null && entryCol.size() > 0) {
                    for (i = 0; i < entryCol.size(); ++i) {
                        entryInfo = entryCol.get(i);
                        if (entryInfo.getUnit() != null) {
                            precisionMap.put(entryInfo.getUnit().getId().toString(), entryInfo.getUnit().getQtyPrecision());
                        }
                        if (entryInfo.getBaseUnit() == null) continue;
                        precisionMap.put(entryInfo.getBaseUnit().getId().toString(), entryInfo.getBaseUnit().getQtyPrecision());
                    }
                }
            } else if (entryCol != null && entryCol.size() > 0) {
                for (i = 0; i < entryCol.size(); ++i) {
                    entryInfo = entryCol.get(i);
                    if (entryInfo.getUnit() != null) {
                        precisionMap.put(entryInfo.getUnit().getId().toString(), entryInfo.getUnit().getQtyPrecision());
                    }
                    if (entryInfo.getBaseUnit() == null) continue;
                    precisionMap.put(entryInfo.getBaseUnit().getId().toString(), entryInfo.getBaseUnit().getQtyPrecision());
                }
            }
        }
        cacheData.put("mmuConvsRate", mmuConvsRate);
        cacheData.put("precisionMap", precisionMap);
    }

    private void getMeasureUnitPrecision(Context ctx, Set materialSet, Set unitSet, Map<String, Object> precisionMap, Map<String, Object> mmuConvsRate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        MultiMeasureUnitInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                precisionMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getQtyPrecision());
                mmuConvsRate.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getBaseConvsRate());
            }
        }
    }

    private PurRequirementInfo getBillInfoById(Context ctx, String billID) throws EASBizException, BOSException {
        return PurRequirementFactory.getLocalInstance(ctx).getPurRequirementInfo((IObjectPK)new ObjectUuidPK(billID), SCMSelectorFactory.getPurRequirementSelector((boolean)true));
    }

    public String getDeliverAddF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = AddressFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        return filterInfo.toString();
    }
}

