/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.codingrule.RuleStatus;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.mm.basedata.TrackNumberFactory;
import com.kingdee.eas.mm.project.ProjectFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurReturnsWebFacadeControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.constant.OprtStateConstant;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PurReturnsWebFacadeControllerBean
extends AbstractPurReturnsWebFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurReturnsWebFacadeControllerBean");

    @Override
    protected Map _handleBillByOprtState(Context ctx, String id, String oprtState) throws BOSException, EASBizException {
        Map<Object, Object> map = new HashMap();
        if (OprtStateConstant.ADDNEW.equals(oprtState)) {
            map = this.getMap(ctx);
            String bizTypeF7Filter = map.get("bizTypeF7Filter").toString();
            bizTypeF7Filter = bizTypeF7Filter + " and id in( '" + "d8e80652-0107-1000-e000-04c5c0a812202407435C" + "','" + "3IS1Qaa0R32+3JPxlVZg5iQHQ1w=" + "')";
            map.put("bizTypeF7Filter", bizTypeF7Filter);
        } else if (OprtStateConstant.EDIT.equals(oprtState)) {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            PurReturnsInfo info = this.getBillInfoById(ctx, id);
            map = this.getMap(ctx, info);
            this.cachePrecision(ctx, map, info);
            CompanyOrgUnitInfo com = this.getCompanyOrgInfo(ctx, info.getPurchaseOrgUnit());
            boolean botpBillAllowAddEntry = SCMUtil.getBotpBillAllowAddEntry((Context)ctx, (SCMBillBaseInfo)info, (OrgType)OrgType.Purchase, (BOSUuid)info.getPurchaseOrgUnit().getId());
            map.put("botpBillAllowAddEntry", botpBillAllowAddEntry);
            map.put("exchangeRate", this.companyOrgChange(ctx, com.getId().toString()));
        } else if (OprtStateConstant.VIEW.equals(oprtState)) {
            if (StringUtils.isEmpty((String)id)) {
                return null;
            }
            PurReturnsInfo info = this.getBillInfoById(ctx, id);
            CompanyOrgUnitInfo com = this.getCompanyOrgInfo(ctx, info.getPurchaseOrgUnit());
            map.put("companyOrgUnit", com);
            map.put("currency", info.getCurrency());
            map.put("exchangeRate", this.companyOrgChange(ctx, com.getId().toString()));
            this.cachePrecision(ctx, map, info);
        }
        ctx.put((Object)"isWebCtx", (Object)true);
        return map;
    }

    public ExchangeRateCollection companyOrgChange(Context ctx, String couId) {
        ExchangeRateCollection exColl = null;
        if (couId != null) {
            Date curDate = new Date();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFormat.format(curDate);
            StringBuilder oql = new StringBuilder();
            oql.append("select convertRate,exchangeAux.sourceCurrency,exchangeAux.targetCurrency,exchangeAux.precision, \n");
            oql.append("exchangeAux.convertMode,exchangeAux.exchangeRateType,exchangeAux.exchangeTable.name,exchangeAux.exchangeTable.number \n");
            oql.append("where availTime <= '" + dateFormat.format(curDate) + "' and invalidTime >= '" + dateFormat.format(curDate) + "'");
            oql.append(" and  exchangeAux.exchangeTable.id in (select FBaseExgTableID from T_ORG_Company where fid ='" + couId + "'))");
            try {
                exColl = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateCollection(new EntityViewInfo(oql.toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return exColl;
    }

    private void cachePrecision(Context ctx, Map<String, Object> cacheData, PurReturnsInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        PurReturnsEntryCollection entryCol = info.getEntries();
        PurReturnsEntryInfo entryInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> unitSet = new HashSet<String>();
        HashMap<String, Object> precisionMap = new HashMap<String, Object>();
        HashMap<String, Object> mmuConvsRate = new HashMap<String, Object>();
        precisionMap.put(info.getCurrency().getId().toString(), info.getCurrency().getPrecision());
        if (entryCol != null && entryCol.size() > 0) {
            for (int i = 0; i < entryCol.size(); ++i) {
                entryInfo = entryCol.get(i);
                if (entryInfo.getMaterial() != null) {
                    materialSet.add(entryInfo.getMaterial().getId().toString());
                    precisionMap.put(entryInfo.getMaterial().getId().toString(), entryInfo.getMaterial().getPricePrecision());
                }
                if (entryInfo.getUnit() != null) {
                    unitSet.add(entryInfo.getUnit().getId().toString());
                }
                if (entryInfo.getBaseUnit() != null) {
                    unitSet.add(entryInfo.getBaseUnit().getId().toString());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                unitSet.add(entryInfo.getAssistUnit().getId().toString());
            }
        }
        if (materialSet.size() > 0 && unitSet.size() > 0) {
            this.setMeasureUnitPrecision(ctx, materialSet, unitSet, precisionMap, mmuConvsRate);
        }
        CurrencyInfo baseCurrencyInfo = this.getBaseCurrencyInfo(ctx, info.getPurchaseOrgUnit());
        precisionMap.put(baseCurrencyInfo.getId().toString(), baseCurrencyInfo.getPrecision());
        precisionMap.put(info.getCurrency().getId().toString(), info.getCurrency().getPrecision());
        precisionMap.put("baseCurrencyPrecision", baseCurrencyInfo.getPrecision());
        precisionMap.put("currencyPrecision", info.getCurrency().getPrecision());
        cacheData.put("precisionMap", precisionMap);
        cacheData.put("mmuConvsRate", mmuConvsRate);
    }

    private void setMeasureUnitPrecision(Context ctx, Set materialSet, Set unitSet, Map<String, Object> precisionMap, Map<String, Object> mmuConvsRate) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("material.id"));
        view.getSelector().add(new SelectorItemInfo("material.pricePrecision"));
        view.getSelector().add(new SelectorItemInfo("measureUnit.id"));
        view.getSelector().add(new SelectorItemInfo("qtyPrecision"));
        view.getSelector().add(new SelectorItemInfo("baseConvsRate"));
        view.getSelector().add(new SelectorItemInfo("isBasicUnit"));
        MultiMeasureUnitCollection col = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        MultiMeasureUnitInfo info = null;
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                precisionMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getQtyPrecision());
                precisionMap.put(info.getMaterial().getId().toString(), info.getMaterial().getPricePrecision());
                mmuConvsRate.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getBaseConvsRate());
            }
        }
    }

    @Override
    protected Map _handleBillByCopy(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        return map;
    }

    @Override
    protected Map _orgChanged(Context ctx, String orgId) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PurchaseOrgUnitInfo purOrgInfo = new PurchaseOrgUnitInfo();
        purOrgInfo.setId(BOSUuid.read((String)orgId));
        map.put("companyOrg", this.getCompanyOrgInfo(ctx, purOrgInfo));
        OrgUnitInfo[] storageOrgUnitInfos = this.getDefaultStorageOrgs(ctx, purOrgInfo);
        map.put("storageOrgF7Filter", this.getOrgFilter(ctx, storageOrgUnitInfos));
        map.put("baseCurrency", this.getBaseCurrencyInfo(ctx, purOrgInfo));
        this.setParam(ctx, orgId, map);
        if (storageOrgUnitInfos != null && storageOrgUnitInfos.length > 0) {
            int size = storageOrgUnitInfos.length;
            for (int i = 0; i < size; ++i) {
                if (orgId.equals(storageOrgUnitInfos[i].getId().toString().trim())) {
                    map.put("defaultStorageOrgInfo", storageOrgUnitInfos[i]);
                    break;
                }
                if (i != size - 1) continue;
                map.put("defaultStorageOrgInfo", storageOrgUnitInfos[0]);
            }
        } else {
            map.put("defaultStorageOrgInfo", null);
        }
        return map;
    }

    private RuleStatus getCodeRuleStatus(Context ctx, IObjectValue model, String mainOrgId) throws BOSException, EASBizException {
        if (model != null && !StringUtils.isEmpty((String)mainOrgId)) {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
            RuleStatus ruleStatus = codingRuleManager.getRuleStatus(model, mainOrgId);
            return ruleStatus;
        }
        return null;
    }

    @Override
    protected Map<String, Object> _createBill(Context ctx, String mainorgid, boolean isMultiOrg) throws BOSException, EASBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        PurReturnsInfo info = new PurReturnsInfo();
        Calendar cal = Calendar.getInstance();
        info.setBizDate(cal.getTime());
        info.setBaseStatus(BillBaseStatusEnum.ADD);
        info.setBizType(SCMServerUtils.getBizTypeInfo((Context)ctx, (String)"250"));
        info.setIsInTax(true);
        PurchaseOrgUnitInfo purOrgInfo = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainorgid));
        info.setPurchaseOrgUnit(purOrgInfo);
        info.setCurrency(this.getBaseCurrencyInfo(ctx, info.getPurchaseOrgUnit()));
        info.setExchangeRate(new BigDecimal("1.00"));
        info.getEntries().add(this.getNewEntryData(ctx, info.getPurchaseOrgUnit()));
        info.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        Timestamp serverDate = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getServerDate();
        info.setCreateTime(serverDate);
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String param = paramControl.getParamValue((IObjectPK)new ObjectUuidPK(mainorgid), "PURORDER001");
        if ("0".equals(param)) {
            info.setAdminOrgUnit((AdminOrgUnitInfo)ctx.get((Object)OrgType.Admin));
        } else {
            IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection ioc = iour.getToUnit(mainorgid, 3, 0);
            if (ioc.size() >= 1) {
                info.setAdminOrgUnit((AdminOrgUnitInfo)ioc.get(0));
            }
        }
        BillTypeInfo billTypeInfo = new BillTypeInfo();
        billTypeInfo.setId(BOSUuid.read((String)"50957179-0105-1000-e006-6152c0a812fd463ED552"));
        info.setBillType(billTypeInfo);
        info.setIsSysBill(false);
        info.setTotalAmount(new BigDecimal("0.00"));
        info.setTotalTax(new BigDecimal("0.00"));
        info.setTotalTaxAmount(new BigDecimal("0.00"));
        info.setCU(purOrgInfo.getCU());
        map.put("bill", info);
        return map;
    }

    private BizTypeInfo getBizTypeInfo(Context ctx) throws BOSException, EASBizException {
        BizTypeInfo bizTypeInfo = new BizTypeInfo();
        StringBuffer sql = new StringBuffer();
        sql.append("select t1.fid as fid,t1.fnumber as fnumber,t1.fname_").append(LocaleUtils.getLocaleString((Locale)ctx.getLocale()));
        sql.append(" as fname from T_SCM_BizType t1 inner join T_SCM_BillBizType t2 on t1.fid=t2.FBizTypeID");
        sql.append(" inner join T_SCM_BillType t3 on t2.FBillTypeID=t3.fid where t3.fnumber='");
        sql.append("250");
        sql.append("' and t1.FStatus=1 ORDER BY t1.fnumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            try {
                rs.beforeFirst();
                if (rs.next()) {
                    bizTypeInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                    bizTypeInfo.setNumber(rs.getString("fnumber"));
                    bizTypeInfo.setName(rs.getString("fname"));
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return bizTypeInfo;
    }

    private PurchaseOrgUnitInfo getDefaultPurOrgInfo(Context ctx) throws BOSException, EASBizException {
        OrgUnitInfo[] orgUnitInfos = this.getDefaultPurOrgs(ctx);
        PurchaseOrgUnitInfo currentOrgInfo = ContextUtil.getCurrentPurchaseUnit((Context)ctx);
        if (currentOrgInfo != null && orgUnitInfos != null && orgUnitInfos.length > 0) {
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                if (!currentOrgInfo.getId().toString().equals(orgUnitInfos[i].getId().toString())) continue;
                return currentOrgInfo;
            }
        }
        if (orgUnitInfos != null && orgUnitInfos.length > 0) {
            return (PurchaseOrgUnitInfo)orgUnitInfos[0];
        }
        return null;
    }

    private OrgUnitInfo[] getDefaultPurOrgs(Context ctx) throws BOSException, EASBizException {
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        FullOrgUnitCollection fullOrgColl = iPerm.getAuthorizedOrg(ctx.getCaller(), OrgType.Purchase, null, "pureturn_addnew");
        HashSet<String> orgSet = new HashSet<String>();
        for (int i = 0; i < fullOrgColl.size(); ++i) {
            orgSet.add(fullOrgColl.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", orgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)Integer.valueOf("1")));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("isBizUnit"));
        view.setSelector(sic);
        view.setFilter(filter);
        PurchaseOrgUnitCollection orgUnitCollection = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx).getPurchaseOrgUnitCollection(view);
        OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[orgUnitCollection.size()];
        for (int i = 0; i < orgUnitCollection.size(); ++i) {
            orgUnitInfos[i] = orgUnitCollection.get(i);
        }
        orgUnitInfos = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])orgUnitInfos, (boolean)true);
        return orgUnitInfos;
    }

    private CurrencyInfo getBaseCurrencyInfo(Context ctx, PurchaseOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        CurrencyInfo currencyInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = this.getCompanyOrgInfo(ctx, orgInfo);
        if (companyOrgUnitInfo != null && (currencyInfo = companyOrgUnitInfo.getBaseCurrency()) != null && StringUtils.isEmpty((String)currencyInfo.getNumber())) {
            currencyInfo = this.getCurrencyInfo(ctx, currencyInfo.getId().toString());
        }
        return currencyInfo;
    }

    private CompanyOrgUnitInfo getCompanyOrgInfo(Context ctx, PurchaseOrgUnitInfo orgInfo) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgUnitRelation;
        OrgUnitCollection companyOrgUnitCollection;
        if (orgInfo != null && orgInfo.getId() != null && (companyOrgUnitCollection = (iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx)).getToUnit(orgInfo.getId().toString(), 3, 1)) != null && companyOrgUnitCollection.size() > 0) {
            return (CompanyOrgUnitInfo)companyOrgUnitCollection.get(0);
        }
        return null;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, String currencyId) throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty((String)currencyId)) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("precision"));
        currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId), sic);
        return currencyInfo;
    }

    private PurReturnsEntryInfo getNewEntryData(Context ctx, PurchaseOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        PurReturnsEntryInfo entryInfo = new PurReturnsEntryInfo();
        Calendar cal = Calendar.getInstance();
        entryInfo.setReturnsDate(cal.getTime());
        entryInfo.setBaseStatus(EntryBaseStatusEnum.ADD);
        entryInfo.setStorageOrgUnit(this.getDefaultStorageOrgInfo(ctx, orgInfo));
        return entryInfo;
    }

    private StorageOrgUnitInfo getDefaultStorageOrgInfo(Context ctx, PurchaseOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        OrgUnitInfo[] orgUnitInfos = this.getDefaultStorageOrgs(ctx, orgInfo);
        StorageOrgUnitInfo defaultStorageOrgInfo = null;
        if (orgUnitInfos != null && orgUnitInfos.length > 0) {
            String purOrgId = orgInfo.getId().toString();
            int size = orgUnitInfos.length;
            for (int i = 0; i < size; ++i) {
                if (purOrgId.equals(orgUnitInfos[i].getId().toString().trim())) {
                    defaultStorageOrgInfo = (StorageOrgUnitInfo)orgUnitInfos[i];
                    break;
                }
                if (i != size - 1) continue;
                defaultStorageOrgInfo = (StorageOrgUnitInfo)orgUnitInfos[0];
            }
        }
        return defaultStorageOrgInfo;
    }

    private OrgUnitInfo[] getDefaultStorageOrgs(Context ctx, PurchaseOrgUnitInfo orgInfo) throws EASBizException, BOSException {
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection storageToPurOrgUnitCollection = iOrgUnitRelation.getFromUnit(orgInfo.getId().toString(), 3, 4);
        OrgUnitCollection storageOrgUnitCollection = new OrgUnitCollection();
        storageOrgUnitCollection = storageToPurOrgUnitCollection;
        if (storageOrgUnitCollection.size() > 0) {
            OrgUnitInfo[] orgUnitInfos = new OrgUnitInfo[storageOrgUnitCollection.size()];
            for (int i = 0; i < storageOrgUnitCollection.size(); ++i) {
                orgUnitInfos[i] = storageOrgUnitCollection.get(i);
            }
            orgUnitInfos = (OrgUnitInfo[])SortUtil.sortDataByNumber((DataBaseInfo[])orgUnitInfos, (boolean)true);
            return orgUnitInfos;
        }
        return null;
    }

    private Map<String, Object> getMap(Context ctx) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap();
        PurchaseOrgUnitInfo purOrgInfo = (PurchaseOrgUnitInfo)ctx.get((Object)"purReturns_purOrgInfo");
        if (purOrgInfo == null) {
            purOrgInfo = this.getDefaultPurOrgInfo(ctx);
        }
        map = this.getMap(ctx, purOrgInfo);
        if (ctx.get((Object)"purReturns_isCopy") != null && ((Boolean)ctx.get((Object)"purReturns_isCopy")).booleanValue()) {
            map.put("isCopy", true);
        }
        return map;
    }

    private String getOrgFilter(Context ctx, OrgUnitInfo[] orgUnitInfos) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        if (orgUnitInfos != null && orgUnitInfos.length > 0) {
            filter.append("id in (");
            for (int i = 0; i < orgUnitInfos.length; ++i) {
                filter.append("'").append(orgUnitInfos[i].getId().toString()).append("'");
                if (i == orgUnitInfos.length - 1) continue;
                filter.append(",");
            }
            filter.append(")");
            return filter.toString();
        }
        return "id in ('')";
    }

    private Map<String, Object> getMap(Context ctx, PurReturnsInfo info) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap();
        PurchaseOrgUnitInfo purOrgInfo = info.getPurchaseOrgUnit();
        map = this.getMap(ctx, purOrgInfo);
        return map;
    }

    private Object getParam(Context ctx, String paramValue) throws EASBizException, BOSException {
        if (paramValue != null) {
            if ("true".equalsIgnoreCase(paramValue)) {
                return true;
            }
            if ("false".equalsIgnoreCase(paramValue)) {
                return false;
            }
            return paramValue;
        }
        return null;
    }

    private PurReturnsInfo getBillInfoById(Context ctx, String billID) throws EASBizException, BOSException {
        return PurReturnsFactory.getLocalInstance(ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(billID), this.getSelectorItemCollection());
    }

    private SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = SCMSelectorFactory.getPurReturnsSelector((boolean)true);
        sic.add(new SelectorItemInfo("currency.precision"));
        return sic;
    }

    private Map<String, Object> getMap(Context ctx, PurchaseOrgUnitInfo purOrgInfo) throws EASBizException, BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bizTypeF7Filter", "billType.number = '250' and status=1");
        OrgUnitInfo[] purOrgUnitInfos = this.getDefaultPurOrgs(ctx);
        map.put("purOrgF7Filter", this.getOrgFilter(ctx, purOrgUnitInfos));
        map.put("companyOrg", this.getCompanyOrgInfo(ctx, purOrgInfo));
        OrgUnitInfo[] storageOrgUnitInfos = this.getDefaultStorageOrgs(ctx, purOrgInfo);
        map.put("storageOrgF7Filter", this.getOrgFilter(ctx, storageOrgUnitInfos));
        map.put("baseCurrency", this.getBaseCurrencyInfo(ctx, purOrgInfo));
        map.put("projectF7Filter", this.getProjectF7Filter(ctx, purOrgInfo.getId().toString()));
        map.put("trackNumberF7Filter", this.gettrackNumberF7Filter(ctx, purOrgInfo.getId().toString()));
        this.setParam(ctx, purOrgInfo.getId().toString(), map);
        if (storageOrgUnitInfos != null && storageOrgUnitInfos.length > 0) {
            String orgId = purOrgInfo.getId().toString();
            int size = storageOrgUnitInfos.length;
            for (int i = 0; i < size; ++i) {
                if (orgId.equals(storageOrgUnitInfos[i].getId().toString().trim())) {
                    map.put("defaultStorageOrgInfo", storageOrgUnitInfos[i]);
                    break;
                }
                if (i != size - 1) continue;
                map.put("defaultStorageOrgInfo", storageOrgUnitInfos[0]);
            }
        } else {
            map.put("defaultStorageOrgInfo", null);
        }
        return map;
    }

    public String gettrackNumberF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = TrackNumberFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("status", (Object)10, CompareType.EQUALS));
        return filterInfo.toString();
    }

    public String getProjectF7Filter(Context ctx, String orgid) throws EASBizException, BOSException {
        FilterInfo filterInfo = null;
        FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
        String cuid = orgInfo.getCU().getId().toString();
        filterInfo = ProjectFactory.getLocalInstance((Context)ctx).getDatabaseDFilter((IObjectPK)new ObjectUuidPK(cuid), "id", "CU.id");
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("baseStatus", (Object)4, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("isTemplate", (Object)false, CompareType.EQUALS));
        return filterInfo.toString();
    }

    private void setParam(Context ctx, String orgId, Map<String, Object> map) throws EASBizException, BOSException {
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
        String[] numbers = new String[]{"PURSUP001", "PURSUP004", "PURJICHU001", "PURORDER003", "PURFIELD001", "PURORDER100"};
        HashMap paramMap = paramControl.getParamHashMap(numbers, orgId);
        map.put("PURSUP001", this.getParam(ctx, (String)paramMap.get("PURSUP001")));
        map.put("PURSUP004", this.getParam(ctx, (String)paramMap.get("PURSUP004")));
        map.put("PURJICHU001", this.getParam(ctx, (String)paramMap.get("PURJICHU001")));
        map.put("PURORDER003", this.getParam(ctx, (String)paramMap.get("PURORDER003")));
        map.put("PURFIELD001", this.getParam(ctx, (String)paramMap.get("PURFIELD001")));
        map.put("PURORDER100", this.getParam(ctx, (String)paramMap.get("PURORDER100")));
    }
}

