/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.text.MessageFormat;

public class CheckPurPriceImpl
extends AbstractPurBusinessImpl<CheckPriceResult> {
    public CheckPurPriceImpl(Context ctx, Object param) {
        super(ctx, param);
    }

    @Override
    protected CheckPriceResult execute() throws EASBizException, BOSException {
        String initTempTable = null;
        CheckPriceResult checkResult = new CheckPriceResult();
        try {
            initTempTable = FetchPurPriceUtil.createTempTable(this.ctx, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.insertData(this.ctx, initTempTable, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.getRelatedData(this.ctx, initTempTable);
            FetchPurPriceUtil.setPriceStrategy(this.ctx, initTempTable);
            this.setPriceTop(initTempTable);
            this.convertPrice(initTempTable);
            this.checkPrice(initTempTable, checkResult);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (initTempTable != null) {
                FetchPurPriceUtil.releaseTempTable(this.ctx, initTempTable);
            }
        }
        return checkResult;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return "Top Price Control";
    }

    private void checkPrice(String initTempTable, CheckPriceResult result) throws BOSException {
        String errorMsg = this.getResource("PRICE_GT_TOP_CANNOT_SUBMIT");
        String detailMsg = this.checkPriceByCtrlStrategy(initTempTable, 10);
        if (detailMsg.length() == 0) {
            errorMsg = this.getResource("PRICE_GT_TOP_CONFIRM_SUBMIT");
            detailMsg = this.checkPriceByCtrlStrategy(initTempTable, 20);
            result.setMessageType(2);
        }
        if (detailMsg.length() > 0) {
            result.setMessage(errorMsg);
            result.setDetailMsg(detailMsg);
        }
    }

    private String checkPriceByCtrlStrategy(String initTempTable, int ctrlStrategy) throws BOSException {
        StringBuffer detailMsg = new StringBuffer();
        String pattern = this.getResource("PRICE_GT_TOP_DETAIL");
        Object[] args = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FSeq FSeq, m.FNumber FMaterialNumber, m.Fname_").append(this.ctx.getLocale()).append(" FMaterialName \n");
        sql.append(" from ").append(initTempTable).append(" t \n");
        sql.append("inner join t_bd_material m on t.FMaterialId=m.FID \n");
        sql.append("where case when t.FIsInTax = 1 then t.FActualTaxPrice else t.FActualPrice end > t.FPrice \n");
        sql.append("  and t.FPriceCtrlStrategy=").append(ctrlStrategy).append(" \n");
        sql.append("  and t.FPrice <> 0 ");
        sql.append("order by FSeq asc ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                args = new Object[]{rs.getInt("FSeq"), rs.getString("FMaterialNumber"), rs.getString("FMaterialName")};
                detailMsg.append(MessageFormat.format(pattern, args)).append(" \n");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return detailMsg.toString();
    }

    private void setPriceTop(String initTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(initTempTable).append(" t \n");
        sql.append("set (FPrice, FInPriceUnitId, FInPriceCurrencyId, FIsInTax, FPriceCtrlStrategy) = \n");
        sql.append("(select mp.FPriceTop, mp.FUnitId, t.FBaseCurrencyId, s.FIsInTax, r.FPriceCtrlStrategy \n");
        sql.append("  from t_bd_materialPurchasing mp, t_sm_purPriceStrategy s, \n");
        sql.append("  t_sm_fetchPriceRule r \n");
        sql.append("where t.FMaterialId=mp.FMaterialId and t.FPurchaseOrgUnitId=mp.FOrgUnit ");
        sql.append("  and t.FPurPriceStrategyId=s.FID \n");
        sql.append("  and s.FID=r.FParentId and r.FBillTypeId=t.FBillTypeId and r.FbizTypeId=t.FbizTypeId) ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void convertPrice(String initTempTable) throws BOSException {
        FetchPurPriceUtil.convertPriceByUnit(this.ctx, initTempTable);
        FetchPurPriceUtil.convertPriceByCurrency(this.ctx, initTempTable);
    }
}

