/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FetchPurPriceUtil {
    public static String createTempTable(Context ctx, PurPriceParamCollection paramCol) throws BOSException {
        List<String> extendFields = paramCol.getExtendFields();
        StringBuffer sql = new StringBuffer();
        sql.append("create table FetchPurPrice ( \n");
        sql.append("KSQL_SEQ INT IDENTITY (1, 1), \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FSeq INT not null default 0, \n");
        sql.append("FPurchaseOrgUnitId varchar(44), \n");
        sql.append("FCompanyOrgUnitId varchar(44), \n");
        sql.append("FSupplierId varchar(44), \n");
        sql.append("FBillTypeId varchar(44), \n");
        sql.append("FMaterialId varchar(44), \n");
        sql.append("FMaterialPurchaseType INT, \n");
        sql.append("FUnitId varchar(44), \n");
        sql.append("FPurUnitId varchar(44), \n");
        sql.append("FBaseUnitId varchar(44), \n");
        sql.append("FCurrencyId varchar(44), \n");
        sql.append("FBaseCurrencyId varchar(44), \n");
        sql.append("FAssistPropertyId varchar(44), \n");
        sql.append("FReceiveOrgUnitId varchar(44), \n");
        sql.append("FPurPriceStrategyId varchar(44), \n");
        sql.append("FQty numeric(21,8) not null default 0, \n");
        sql.append("FBaseQty numeric(21,8) not null default 0, \n");
        sql.append("FBizDate datetime , \n");
        sql.append("FDeliveryDate datetime, \n");
        sql.append("FMaterialGroupId varchar(44), \n");
        sql.append("FExchangeTableId varchar(44), \n");
        sql.append("FPricePrecision INT not null default 4, \n");
        sql.append("FbaseQtyPrecision INT not null default 4, \n");
        sql.append("FActualTaxPrice numeric(21,8) , \n");
        sql.append("FActualPrice numeric(21,8) , \n");
        sql.append("FSource nvarchar(80), \n");
        sql.append("FBizTypeId varchar(44), \n");
        sql.append("FPrice numeric(21,8) , \n");
        sql.append("FTaxRate numeric(21,8) , \n");
        sql.append("FInPriceUnitId varchar(44), \n");
        sql.append("FInPriceCurrencyId varchar(44), \n");
        sql.append("FPriceCtrlStrategy INT not null default 0, \n");
        sql.append("FEditCtrlStrategy INT not null default 0, \n");
        sql.append("FPriceType INT not null default 0, \n");
        sql.append("FIsInTax INT not null default 0, \n");
        sql.append("FIsSupplierTaxRate INT not null default 0, \n");
        sql.append("FDiscountRate numeric(21,8), \n");
        sql.append("FInPriceSupplierId varchar(44), \n");
        sql.append("FInPriceSupplierName Nvarchar(255), \n");
        sql.append("FInPriceSupplierNumber Nvarchar(80), \n");
        sql.append("FInPriceSupplierTaxRate numeric(21,8) not null default 0, \n");
        sql.append("FInPriceBillTypeId varchar(44), \n");
        sql.append("FFromQty numeric(21,8) not null default 0, \n");
        sql.append("FOriginPrice numeric(21,8), \n");
        sql.append("FOriginTaxPrice numeric(21,8), \n");
        sql.append("FInPriceRecOrgUnitId varchar(44), \n");
        sql.append("FInPriceEffectiveDate datetime, \n");
        sql.append("FInPriceUnEffectiveDate datetime, \n");
        sql.append("FInPriceBizDate datetime, \n");
        for (int i = 0; i < extendFields.size(); ++i) {
            String fieldName = extendFields.get(i);
            String fieldType = paramCol.getFieldsTypeByName(fieldName);
            if (fieldName == null || fieldType == null) continue;
            sql.append(fieldName).append(" ").append(fieldType).append(", \n");
        }
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    public static void insertData(Context ctx, String tempTable, PurPriceParamCollection paramCol) throws BOSException {
        int i;
        StringBuffer sql = new StringBuffer();
        List<String> extendFields = paramCol.getExtendFields();
        sql.append("insert into ").append(tempTable).append(" \n");
        sql.append("(FID, \n");
        sql.append("FSource, \n");
        sql.append("FSeq, \n");
        sql.append("FPurchaseOrgUnitId, \n");
        sql.append("FCompanyOrgUnitId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FBillTypeId, \n");
        sql.append("FMaterialId, \n");
        sql.append("FMaterialPurchaseType, \n");
        sql.append("FUnitId, \n");
        sql.append("FPurUnitId, \n");
        sql.append("FBaseUnitId, \n");
        sql.append("FCurrencyId, \n");
        sql.append("FBaseCurrencyId, \n");
        sql.append("FAssistPropertyId, \n");
        sql.append("FReceiveOrgUnitId, \n");
        sql.append("FQty, \n");
        sql.append("FBizDate, \n");
        sql.append("FDeliveryDate, \n");
        sql.append("FActualTaxPrice, \n");
        sql.append("FActualPrice, \n");
        sql.append("FIsInTax, \n");
        sql.append("FBizTypeId \n");
        for (i = 0; i < extendFields.size(); ++i) {
            sql.append(",").append(extendFields.get(i)).append("\n");
        }
        sql.append(") \n");
        sql.append("values (");
        sql.append("?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? ");
        for (i = 0; i < extendFields.size(); ++i) {
            sql.append(",?");
        }
        sql.append(") ");
        PurPriceParam paramInfo = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        for (int i2 = 0; i2 < paramCol.size(); ++i2) {
            paramInfo = paramCol.getPurPriceParam(i2);
            ArrayList<Object> param = new ArrayList<Object>();
            if (StringUtils.isEmpty((String)paramInfo.getMaterialId())) continue;
            param.add(BOSUuid.create((BOSObjectType)new BOSObjectType("406FDF31")).toString());
            param.add(paramCol.getSource());
            param.add(paramInfo.getSeq());
            param.add(paramInfo.getPurOrgUnitId());
            param.add(paramInfo.getCompanyOrgUnitId());
            param.add(paramInfo.getSupplierId());
            param.add(paramInfo.getSupplierId());
            param.add(paramInfo.getBillTypeId());
            param.add(paramInfo.getMaterialId());
            param.add(paramInfo.getMaterialPurchaseType());
            param.add(paramInfo.getUnitId());
            param.add(paramInfo.getPurUnitId());
            param.add(paramInfo.getBaseUnitId());
            param.add(paramInfo.getCurrencyId());
            param.add(paramInfo.getBaseCurrencyId());
            param.add(paramInfo.getAssistPropertyId());
            param.add(paramInfo.getRecOrgUnitId());
            param.add(paramInfo.getQty());
            param.add(paramInfo.getBizDate() != null ? new Date(paramInfo.getBizDate().getTime()) : null);
            param.add(paramInfo.getDeliveryDate() != null ? new Date(paramInfo.getDeliveryDate().getTime()) : null);
            param.add(paramInfo.getActualTaxPrice());
            param.add(paramInfo.getActualPrice());
            param.add(paramInfo.isInTax());
            param.add(paramInfo.getBizTypeId());
            for (int j = 0; j < paramCol.getExtendFields().size(); ++j) {
                param.add(paramInfo.get(paramCol.getExtendFields().get(j)));
            }
            sqlParams.add(param.toArray());
        }
        SQLUtil.executeBatch(ctx, sql.toString(), sqlParams);
    }

    public static void insertData(Context ctx, String initTempTable, String tempTable, String purPriceStrategyId, PurPriceParamCollection paramCol) throws BOSException {
        int i;
        List<String> extendFields = paramCol.getExtendFields();
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(tempTable).append(" \n");
        sql.append("(FID, \n");
        sql.append("FSource, \n");
        sql.append("FSeq, \n");
        sql.append("FPurchaseOrgUnitId , \n");
        sql.append("FCompanyOrgUnitId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FBillTypeId, \n");
        sql.append("FMaterialId, \n");
        sql.append("FMaterialPurchaseType, \n");
        sql.append("FUnitId, \n");
        sql.append("FPurUnitId, \n");
        sql.append("FBaseUnitId, \n");
        sql.append("FCurrencyId, \n");
        sql.append("FBaseCurrencyId, \n");
        sql.append("FAssistPropertyId, \n");
        sql.append("FReceiveOrgUnitId, \n");
        sql.append("FPurPriceStrategyId, \n");
        sql.append("FQty, \n");
        sql.append("FBaseQty, \n");
        sql.append("FBizDate, \n");
        sql.append("FDeliveryDate, \n");
        sql.append("FExchangeTableId, \n");
        sql.append("FPricePrecision, \n");
        sql.append("FIsInTax, \n");
        sql.append("FIsSupplierTaxRate, \n");
        sql.append("FBizTypeId \n");
        String fieldName = null;
        for (i = 0; i < extendFields.size(); ++i) {
            fieldName = extendFields.get(i);
            if (fieldName == null) continue;
            sql.append(", ").append(fieldName).append(" \n");
        }
        sql.append(") \n");
        sql.append("select \n");
        sql.append("newbosid('406FDF31'), \n");
        sql.append("FSource, \n");
        sql.append("FSeq, \n");
        sql.append("FPurchaseOrgUnitId , \n");
        sql.append("FCompanyOrgUnitId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FBillTypeId, \n");
        sql.append("FMaterialId, \n");
        sql.append("FMaterialPurchaseType, \n");
        sql.append("FUnitId, \n");
        sql.append("FPurUnitId, \n");
        sql.append("FBaseUnitId, \n");
        sql.append("FCurrencyId, \n");
        sql.append("FBaseCurrencyId, \n");
        sql.append("FAssistPropertyId, \n");
        sql.append("FReceiveOrgUnitId, \n");
        sql.append("FPurPriceStrategyId, \n");
        sql.append("FQty, \n");
        sql.append("FBaseQty, \n");
        sql.append("FBizDate, \n");
        sql.append("FDeliveryDate, \n");
        sql.append("FExchangeTableId, \n");
        sql.append("FPricePrecision, \n");
        sql.append("FIsInTax, \n");
        sql.append("FIsSupplierTaxRate, \n");
        sql.append("FBizTypeId \n");
        for (i = 0; i < extendFields.size(); ++i) {
            fieldName = extendFields.get(i);
            if (fieldName == null) continue;
            sql.append(", ").append(fieldName).append(" \n");
        }
        sql.append(" from ").append(initTempTable).append(" where ");
        sql.append("FPurPriceStrategyId = '").append(purPriceStrategyId).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static void getRelatedData(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" t set ");
        sql.append("(  FBaseCurrencyId, FCompanyOrgUnitId,");
        sql.append("  FExchangeTableId) = \n");
        sql.append("(select t2.FBaseCurrencyId, t2.FID,");
        sql.append("  t2.FBaseExgTableId \n");
        sql.append(" from  t_Org_Company t2, T_ORG_UnitRelation t3 \n");
        sql.append(" where t.FPurchaseOrgUnitId=t3.FFromUnitId and t3.Ftyperelationid='").append("00000000-0000-0000-0000-0000000000030FE9F8B5").append("' \n");
        sql.append("  and t3.FTOUnitId=t2.FID )");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" t set ");
        sql.append("(FPurUnitId)  = \n");
        sql.append("(select t1.FUnitId \n");
        sql.append(" from t_bd_MaterialPurchasing t1 \n");
        sql.append(" where t.FMaterialId=t1.FmaterialId and t.FPurchaseOrgUnitId=t1.FOrgUnit  ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" t set ");
        sql.append("( FBaseUnitId, FPricePrecision,");
        sql.append("    FbaseQtyPrecision) = \n");
        sql.append("(select  t5.FMeasureUnitId, t6.FPricePrecision,t5.FQtyPrecision\n");
        sql.append(" from  t_bd_MultiMeasureUnit t5, t_bd_material t6 \n");
        sql.append(" where t.FMaterialId=t5.FMaterialID and t5.FMeasureUnitId=t6.fbaseunit \n");
        sql.append("  and t.FMaterialId=t6.FID ) ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" t set ");
        sql.append("(FBaseQty) = \n");
        sql.append("(select   round(decimal(t.FQty*t7.FBaseConvsRate,21,8), t.FbaseQtyPrecision) \n");
        sql.append(" from  \n");
        sql.append("  t_bd_MultiMeasureUnit t7 \n");
        sql.append(" where   t.FMaterialId=t7.FMaterialID and t.FUnitId=t7.FMeasureUnitId) where t.FUnitId is not null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" t set ");
        sql.append("(FMaterialPurchaseType) = \n");
        sql.append(" (select case when t1.FBizCategoryID='+f4mYqj4xUGaNf69/HWRdqk4kCA=' ");
        sql.append("  or t1.FBizCategoryID='6LFeB81CJ0mD3wyAekUV7Kk4kCA=' then ").append(1);
        sql.append("  else ").append(0).append(" end \n");
        sql.append("from t_scm_bizType t1 \n");
        sql.append("where t1.FID=t.FBizTypeID) \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static String convertToString(Set<String> ids) {
        if (ids == null || ids.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = ids.size();
        for (int i = 0; i < count; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(ids.toArray()[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    public static void setPriceStrategy(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" as t0 set FPurPriceStrategyId = \n");
        sql.append("select t1.Fid from t_sm_priceStrategyAssign t \n");
        sql.append(" inner join t_sm_purPriceStrategy t1 on t.FPriceStrategyId=t1.Fid \n");
        sql.append("  where t.FMaterialId = t0.FMaterialId and t.FPurchaseOrgUnitId = t0.FPurchaseOrgUnitId \n");
        sql.append(" and t1.FBaseStatus=4");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" select FPurchaseOrgUnitId from ").append(tempTable).append(" where FPurPriceStrategyId is null ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet<String> set = new HashSet<String>();
        try {
            while (rs.next()) {
                if (rs.getString("FPurchaseOrgUnitId") == null) continue;
                set.add(rs.getString("FPurchaseOrgUnitId"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        String orgids = FetchPurPriceUtil.convertToString(set);
        if (!StringUtils.isEmpty((String)orgids)) {
            sql.setLength(0);
            sql.append(" select ass.FPriceStrategyId,ass.FMaterialGroupStandardId,mgroup.flongnumber from t_sm_priceStrategyAssign ass ");
            sql.append(" inner join t_bd_materialGroup mgroup on mgroup.fid = ass.FMaterialGroupId ");
            sql.append(" inner join t_sm_purPriceStrategy tsp on ass.FPriceStrategyId=tsp.Fid  ");
            sql.append(" where ass.FPurchaseOrgUnitId  in (").append(orgids).append(") and ass.FASSIGNTYPE = 1 ");
            sql.append("  and tsp.FBaseStatus=4 ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, String> strategyMap = new HashMap<String, String>();
            try {
                while (rs.next()) {
                    strategyMap.put(rs.getString("FMaterialGroupStandardId") + rs.getString("flongnumber"), rs.getString("FPriceStrategyId"));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            sql.setLength(0);
            sql.append(" select temp.fid,mgroup.flongnumber,groupd.FMaterialGroupStandardId from ").append(tempTable).append(" temp ");
            sql.append(" inner join T_BD_MaterialGroupDetial groupd on groupd.fmaterialid = temp.fmaterialid ");
            sql.append(" inner join t_bd_materialGroup mgroup on mgroup.fid = groupd.FMaterialGroupId and groupd.FMaterialGroupStandardId = mgroup.FGROUPSTANDARD");
            sql.append(" ");
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
            String priceStrategyId = null;
            try {
                while (rs.next()) {
                    priceStrategyId = FetchPurPriceUtil.getPurPriceStrategyId(strategyMap, rs.getString("flongnumber"), rs.getString("FMaterialGroupStandardId"));
                    if (priceStrategyId == null) continue;
                    Object[] params = new Object[]{priceStrategyId, rs.getString("fid")};
                    paramsList.add(params);
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            if (paramsList.size() > 0) {
                sql.setLength(0);
                sql.append("update ").append(tempTable).append("   set FPurPriceStrategyId =? \n");
                sql.append(" where fid =? and FPurPriceStrategyId is null");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
            }
        }
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" as t0 set FPurPriceStrategyId = \n");
        sql.append("(select t.FId from t_sm_purPriceStrategy t \n");
        sql.append("  where t0.FPurchaseOrgUnitId = t.FPurchaseOrgUnitId and t.FIsDefault = 1) \n");
        sql.append("where t0.FPurPriceStrategyId is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private static String getPurPriceStrategyId(Map<String, String> strategyMap, String longnumber, String materialGroupStandardId) {
        String priceStrategyId = null;
        String[] numbers = longnumber.split("!");
        String curLongnumber = "";
        for (int i = numbers.length; i > 0; --i) {
            for (int j = 0; j < i; ++j) {
                curLongnumber = j == 0 ? numbers[j] : curLongnumber + "!" + numbers[j];
            }
            if (!strategyMap.containsKey(materialGroupStandardId + curLongnumber)) continue;
            priceStrategyId = strategyMap.get(materialGroupStandardId + curLongnumber);
            break;
        }
        return priceStrategyId;
    }

    public static void convertPriceByCurrency(Context ctx, String tempTable) throws BOSException {
        String tempExchangeRateTable = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID FTraceId,t4.FConvertMode FConvertModeFrom, t3.FConvertMode FConvertModeTo, ");
        sql.append("  isnull(t2.FConvertRate, 1) FConvertRateFrom, isnull(t1.FConvertRate,1) FConvertRateTo \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("left outer join t_bd_exchangeaux t3 on t.FBaseCurrencyId=t3.FTargetCurrencyId \n");
        sql.append("  and t.FCurrencyId=t3.FSourceCurrencyId and t3.FExchangeTableId=t.FExchangeTableId \n");
        sql.append("left outer join t_bd_exchangerate t1 on t3.FID=t1.FExchangeAuxId \n");
        sql.append("left outer join t_bd_exchangeaux t4 on t.FBaseCurrencyId=t4.FTargetCurrencyId \n");
        sql.append("  and t.FInPriceCurrencyId=t4.FSourceCurrencyId and t4.FExchangeTableId=t.FExchangeTableId \n");
        sql.append("left outer join t_bd_exchangerate t2 on t4.FID=t2.FExchangeAuxId  \n");
        sql.append("where  isnull(t1.FAvailTime,now()) <= now() and isnull(t2.FAvailTime, now()) <= now() \n");
        sql.append("  and t.FCurrencyId<>t.FInPriceCurrencyId and t.FPrice is not null \n");
        sql.append("  order by t.FID asc, t2.FAvailTime desc, t1.FAvailTime desc \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String latestTraceId = null;
        String preTraceId = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Object[] obj = null;
        try {
            while (rs.next()) {
                latestTraceId = rs.getString("FTraceId");
                if (latestTraceId.equals(preTraceId)) continue;
                obj = new Object[]{BOSUuid.create((BOSObjectType)new BOSObjectType("406FDF31")).toString(), latestTraceId, rs.getInt("FConvertModeFrom"), rs.getInt("FConvertModeTo"), rs.getBigDecimal("FConvertRateFrom"), rs.getBigDecimal("FConvertRateTo")};
                sqlParams.add(obj);
                preTraceId = latestTraceId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        try {
            tempExchangeRateTable = FetchPurPriceUtil.createExchangeRateTempTable(ctx);
            sql.setLength(0);
            sql.append("insert into ").append(tempExchangeRateTable);
            sql.append(" values(?,?,?,?,?,?) ");
            SQLUtil.executeBatch(ctx, sql.toString(), sqlParams);
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" t0 set FPrice = \n");
            sql.append("select isnull(case \n");
            sql.append("  when isnull(tmp.FConvertModeFrom,0)=0 and isnull(tmp.FConvertModeTo,0)=0 ");
            sql.append("    then round(decimal(decimal(t0.FPrice*isnull(tmp.FConvertRateFrom,1), 21,8)/isnull(tmp.FConvertRateTo,1), 21,8), t0.FPricePrecision) \n");
            sql.append("  when isnull(tmp.FConvertModeFrom,1)=1 and isnull(tmp.FConvertModeTo,0)=0 ");
            sql.append("    then round(decimal(decimal(t0.FPrice/isnull(tmp.FConvertRateFrom,1), 21,8)/isnull(tmp.FConvertRateTo,1), 21,8), t0.FPricePrecision) \n");
            sql.append("  when isnull(tmp.FConvertModeFrom,0)=0 and isnull(tmp.FConvertModeTO,1)=1 ");
            sql.append("    then round(decimal(decimal(t0.FPrice*isnull(tmp.FConvertRateFrom,1), 21,8)*isnull(tmp.FConvertRateTo,1), 21,8), t0.FPricePrecision) \n");
            sql.append("  else ");
            sql.append("    round(decimal(decimal(t0.FPrice/isnull(tmp.FConvertRateFrom,1), 21,8)*isnull(tmp.FConvertRateTo,1), 21,8), t0.FPricePrecision) \n");
            sql.append("  end \n");
            sql.append(", t0.FPrice) \n");
            sql.append("from  \n");
            sql.append(tempExchangeRateTable).append(" tmp \n");
            sql.append(" where t0.FID=tmp.FTraceId \n");
            sql.append("where t0.FCurrencyId<>t0.FInPriceCurrencyId and t0.FPrice is not null \n");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            FetchPurPriceUtil.releaseTempTable(ctx, tempExchangeRateTable);
        }
    }

    public static void convertPriceByUnit(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" t set FPrice = \n");
        sql.append("select \n");
        sql.append("  isnull(round(decimal(t.FPrice*t2.FBaseConvsRate/t3.FBaseConvsRate, 21,8),t.FPricePrecision) \n");
        sql.append(", t.FPrice) \n");
        sql.append("from t_bd_multimeasureunit t2, t_bd_multimeasureunit t3 \n");
        sql.append("where t.FMaterialId=t2.FMaterialId and t.FUnitId=t2.FMeasureUnitId \n");
        sql.append("  and t.FMaterialId=t3.FMaterialId and t.FInPriceUnitId=t3.FMeasureUnitId \n");
        sql.append("where t.FunitId<>t.FInPriceUnitId and t.FPrice is not null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public static String createExchangeRateTempTable(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table SpplierPrice ( \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FTraceId varchar(44), \n");
        sql.append("FConvertModeFrom int not null default 0, \n");
        sql.append("FConvertModeTo int not null default 0, \n");
        sql.append("FConvertRateFrom numeric(21,8), \n");
        sql.append("FConvertRateTo numeric(21,8), \n");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    public static void releaseTempTable(Context ctx, String tempTable) {
        if (tempTable != null) {
            TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
        }
    }

    public static PurPriceInfoCollection readPriceInfoCol(Context ctx, String tempTable) throws BOSException {
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FSeq, \n");
        sql.append("t.FPurchaseOrgUnitId, \n");
        sql.append("t.Fsource, \n");
        sql.append("t.FPrice, \n");
        sql.append("t.FTaxRate, \n");
        sql.append("t.FMaterialId, \n");
        sql.append("t.FInPriceCurrencyId, \n");
        sql.append("t.FInPriceUnitId, \n");
        sql.append("t.FIsInTax, \n");
        sql.append("t.FIsSupplierTaxRate, \n");
        sql.append("t.FPricePrecision, \n");
        sql.append("t.FDiscountRate, \n");
        sql.append("t.FPurUnitId, \n");
        sql.append("t.FInPriceSupplierId, \n");
        sql.append("t.FInPriceSupplierName, \n");
        sql.append("t.FInPriceSupplierNumber, \n");
        sql.append("t.FInPriceSupplierTaxRate, \n");
        sql.append("case when t1.FId is not null then t1.FEditCtrlStrategy else ");
        sql.append(20).append(" end FEditCtrlStrategy, \n");
        sql.append("case when t1.FId is not null then t1.FPriceCtrlStrategy else ");
        sql.append(30).append(" end FPriceCtrlStrategy, \n");
        sql.append("case when t1.FPriceProviderID='G4gly5CtI0mW3m3xzBeXDOx3qDg=' ");
        sql.append(" or t1.FpriceProviderID is null then 0 else 1 end FhasPriceProvider \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("left outer join t_sm_fetchPriceRule t1 on t1.FparentId = t.FPurPriceStrategyId \n");
        sql.append("  and t1.FBillTypeId = t.FBillTypeId and t1.FBizTypeId = t.FBizTypeId ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PurPriceInfo purPriceInfo = new PurPriceInfo();
                purPriceInfo.read(rs);
                priceInfoCol.setPurPriceInfoBySeq(purPriceInfo.getSeq(), purPriceInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return priceInfoCol;
    }
}

