/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.scm.sm.pur.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UpDateTaxRate {
    public void update(Context ctx, String tmpTable, boolean isupdateSupplier, boolean isRefPrice) throws BOSException {
        if (isupdateSupplier) {
            this.updateSupplier(ctx, tmpTable);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.fid,t.FInPriceSupplierId,t.FMaterialId,t.FPurchaseOrgUnitId ,param.fValue_").append(ctx.getLocale()).append(" as pramvalue");
        sql.append(" from ").append(tmpTable).append(" as t");
        sql.append(" left join t_bas_paramitem as param on param.FORGUNITID = FPurchaseOrgUnitId");
        sql.append(" where param.fkeyid ='").append("xnVsHwEPEADgAAppwKgSUqiB8+c=").append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        Map<String, BigDecimal> supplierTaxMap = this.getSupplierTaxRate(ctx, tmpTable);
        Map<String, BigDecimal> appSupplierTaxMap = this.getAppSupplierTaxRate(ctx, tmpTable);
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Object[] obj = null;
        BigDecimal taxRate = BigDecimal.ZERO;
        try {
            while (rs.next()) {
                String key;
                if (rs.getString("FInPriceSupplierId") == null || rs.getString("FMaterialId") == null || rs.getString("FPurchaseOrgUnitId") == null) continue;
                taxRate = BigDecimal.ZERO;
                if ("true".equals(rs.getString("pramvalue"))) {
                    key = rs.getString("FInPriceSupplierId") + rs.getString("FPurchaseOrgUnitId") + rs.getString("FMaterialId");
                    taxRate = appSupplierTaxMap.get(key);
                    if (taxRate == null) {
                        taxRate = supplierTaxMap.get(rs.getString("FInPriceSupplierId"));
                    }
                } else {
                    key = rs.getString("FInPriceSupplierId") + rs.getString("FPurchaseOrgUnitId") + rs.getString("FMaterialId");
                    taxRate = supplierTaxMap.get(rs.getString("FInPriceSupplierId"));
                    if (taxRate == null) {
                        taxRate = appSupplierTaxMap.get(key);
                    }
                }
                if (taxRate == null) {
                    taxRate = BigDecimal.ZERO;
                }
                obj = new Object[]{taxRate, rs.getString("fid")};
                sqlParams.add(obj);
            }
            sql.setLength(0);
            sql.append("update ").append(tmpTable).append(" set ftaxRate =?  where fid =? and (ftaxRate=0 or ftaxRate is null)  ");
            if (isRefPrice) {
                sql.append(" and fprice is null ");
            }
            SQLUtil.executeBatch(ctx, sql.toString(), sqlParams);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateSupplier(Context ctx, String tmpTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tmpTable).append(" t set \n ");
        sql.append("(FInPriceSupplierId, \n");
        sql.append("FInPriceSupplierName, \n");
        sql.append("FInPriceSupplierNumber) = \n");
        sql.append("(select \n");
        sql.append("t2.FSUPPLIER,s.FName_").append(ctx.getLocale()).append(", s.FNumber \n");
        sql.append(" from t_bd_materialPurchasing t2,t_bd_supplier s ,T_BD_SupplierPurchaseInfo sp  \n");
        sql.append("where t.FMaterialId=t2.FmaterialId and t.FPurchaseOrgUnitId=t2.ForgUnit \n");
        sql.append("and s.FID = t2.FSUPPLIER and s.fid= sp.FSUPPLIERID and sp.FPURCHASEORGID= t.FPurchaseOrgUnitId)  \n");
        sql.append(" where FInPriceSupplierId is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private Map<String, BigDecimal> getSupplierTaxRate(Context ctx, String tmpTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.fid ,s.ftaxRate");
        sql.append(" from ").append(tmpTable).append(" as t");
        sql.append(" inner join t_bd_supplier as s on s.fid = t.FInPriceSupplierId ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                map.put(rs.getString("fid"), rs.getBigDecimal("ftaxRate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private Map<String, BigDecimal> getAppSupplierTaxRate(Context ctx, String tmpTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" select s.fsupplierid,s.FPURCHASEORGID,t.FMaterialId,s.ftaxRate");
        sql.append(" from ").append(tmpTable).append(" as t");
        sql.append(" inner join t_sm_ApprovedSupplier as s on s.fsupplierid = t.FInPriceSupplierId ");
        sql.append(" and s.FPURCHASEORGID = t.FPurchaseOrgUnitId ");
        sql.append(" and s.FMATERIALITEMID = t.FMaterialId ");
        sql.append(" where s.FISUSEABLE = ").append(1);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        try {
            while (rs.next()) {
                String key = rs.getString("fsupplierid") + rs.getString("FPURCHASEORGID") + rs.getString("FMaterialId");
                map.put(key, rs.getBigDecimal("ftaxRate"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

