/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price.history;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceQueryTypeEnum;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.history.HistoryPriceProvider;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class QueryHistoryPriceProvider
extends HistoryPriceProvider {
    private PurPriceParamCollection paramCol = null;
    private String initTempTable = null;
    private String tempTable4MinPrice = null;
    private Locale locale = null;

    public QueryHistoryPriceProvider(PurPriceParamCollection paramCol) {
        this.paramCol = paramCol;
    }

    @Override
    public Object fetchPrice(Context ctx, String tempTable, String purPriceStrategyId) throws BOSException, EASBizException {
        this.locale = ctx.getLocale();
        this.initTempTable = FetchPurPriceUtil.createTempTable(ctx, this.paramCol);
        this.tempTable4MinPrice = FetchPurPriceUtil.createTempTable(ctx, this.paramCol);
        PurchaseTypeEnum purchaseType = this.getPurchaseType(ctx, tempTable);
        StringBuffer tempResultSql = null;
        tempResultSql = PurchaseTypeEnum.PURCHASE.equals((Object)purchaseType) ? this.getPurchaseTempResultSql(tempTable) : this.getSubContractTempResultSql(tempTable);
        String historyTempTable = null;
        try {
            historyTempTable = QueryHistoryPriceProvider.createTempTable(ctx);
            this.insertHistoryPriceData(ctx, historyTempTable, tempResultSql.toString());
            this.getHistoryPrice(ctx, tempTable, historyTempTable);
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            FetchPurPriceUtil.releaseTempTable(ctx, historyTempTable);
        }
        this.getHistoryPrice4minPrice(ctx);
        FetchPurPriceUtil.convertPriceByUnit(ctx, this.initTempTable);
        FetchPurPriceUtil.convertPriceByCurrency(ctx, this.initTempTable);
        return this.readPriceInfoCol(ctx, this.initTempTable);
    }

    public static String createTempTable(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table QueryPurPrice ( \n");
        sql.append("FTraceId varchar(44) not null, \n");
        sql.append("FSeq INT not null default 0, \n");
        sql.append("FBizDate datetime , \n");
        sql.append("FAuditTime datetime, \n");
        sql.append("FPrice numeric(21,8) , \n");
        sql.append("FTaxRate numeric(21,8) , \n");
        sql.append("FTaxPrice numeric(21,8) , \n");
        sql.append("FUnitId varchar(44), \n");
        sql.append("FAssistPropertyId varchar(44), \n");
        sql.append("FRecOrgUnitId varchar(44), \n");
        sql.append("FCurrencyId varchar(44), \n");
        sql.append("FIsInTax INT not null default 0, \n");
        sql.append("FSupplierId varchar(44), \n");
        sql.append("FBillTypeId varchar(44), \n");
        sql.append("FDiscountRate numeric(21,8), \n");
        sql.append("FQty numeric(21,8) \n");
        sql.append(") ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    private void insertHistoryPriceData(Context ctx, String historyTempTable, String sql) throws BOSException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("insert into ");
        buffer.append(historyTempTable);
        buffer.append("(FTraceId, FSeq, FBizDate, FAuditTime,FPrice,FTaxRate,FTaxPrice, FUnitId, FCurrencyId, FIsInTax, FSupplierId, FBillTypeId,FDiscountRate,FQty,FAssistPropertyId,FRecOrgUnitId ) ");
        buffer.append(sql);
        DbUtil.execute((Context)ctx, (String)buffer.toString());
    }

    private void getHistoryPrice(Context ctx, String tempTable, String historyTempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(this.initTempTable).append(" \n");
        sql.append("( KSQL_SEQ, \n").append(this.getResultFields()).append(" ) \n");
        sql.append("select newbosid('406FDF31') FID, \n");
        sql.append("tmp.FSeq FSeq, \n");
        sql.append("t.FPurchaseOrgUnitId FPurchaseOrgUnitId, \n");
        sql.append("t.FCompanyOrgUnitId FCompanyOrgUnitId, \n");
        sql.append("t.FSupplierId FSupplierId, \n");
        sql.append("t.FBillTypeId FBillTypeId, \n");
        sql.append("t.FMaterialId FMaterialId, \n");
        sql.append("t.FMaterialPurchaseType FMaterialPurchaseType, \n");
        sql.append("t.FUnitId FUnitId, \n");
        sql.append("t.FPurUnitId FPurUnitId, \n");
        sql.append("t.FBaseUnitId FBaseUnitId, \n");
        sql.append("t.FCurrencyId FCurrencyId, \n");
        sql.append("t.FBaseCurrencyId FBaseCurrencyId, \n");
        sql.append("tmp.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("t.FReceiveOrgUnitId FReceiveOrgUnitId, \n");
        sql.append("t.FPurPriceStrategyId FPurPriceStrategyId, \n");
        sql.append("tmp.FQty FQty, \n");
        sql.append("t.FBaseQty FBaseQty, \n");
        sql.append("tmp.FBizDate FBizDate, \n");
        sql.append("t.FDeliveryDate FDeliveryDate, \n");
        sql.append("t.FExchangeTableId FExchangeTableId, \n");
        sql.append("t.FPricePrecision FPricePrecision, \n");
        Boolean isTaxPrice = (Boolean)this.paramCol.get("isTaxPrice");
        if (isTaxPrice != null) {
            if (isTaxPrice.booleanValue()) {
                sql.append("tmp.FTaxPrice FPrice, \n");
            } else {
                sql.append("tmp.FPrice  FPrice, \n");
            }
        } else {
            sql.append("case when tmp.FIsInTax =1 then tmp.FTaxPrice else tmp.FPrice end FPrice, \n");
        }
        sql.append("tmp.FTaxRate FTaxRate, \n");
        sql.append("tmp.FPrice FOriginPrice, \n");
        sql.append("tmp.FTaxPrice FOriginTaxPrice, \n");
        sql.append("tmp.FUnitId FInPriceUnitId, \n");
        sql.append("tmp.FCurrencyId FInPriceCurrencyId, \n");
        sql.append("0 FPriceType, \n");
        sql.append("tmp.FIsInTax FIsInTax, \n");
        sql.append("tmp.FDiscountRate FDiscountRate, \n");
        sql.append("tmp.FSupplierId FInPriceSupplierId, \n");
        sql.append("supplier.FName_" + ctx.getLocale() + " FInPriceSupplierName, \n");
        sql.append("supplier.FNumber FInPriceSupplierNumber,\n");
        sql.append("tmp.FBillTypeId FInPriceBillTypeId, \n");
        sql.append("tmp.FAuditTime FInPriceBizDate, \n");
        sql.append("tmp.FRecOrgUnitId FInPriceRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("inner join \n");
        sql.append(historyTempTable).append(" tmp \n");
        sql.append("  on t.FID = tmp.FTraceId \n");
        sql.append("inner join t_bd_supplier supplier on supplier.fid = tmp.FSupplierId \n");
        sql.append(" order by tmp.FBillTypeId asc, tmp.FBizDate desc, tmp.FAuditTime desc, tmp.FSeq asc ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void getHistoryPrice4minPrice(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(this.tempTable4MinPrice).append(" \n");
        sql.append("( KSQL_SEQ, \n").append(this.getResultFields()).append(" ) \n");
        sql.append("select ").append(this.getResultFields()).append(" from ").append(this.initTempTable).append(" \n");
        sql.append("order by FInPriceBillTypeId asc,FPrice asc,FBizDate desc,FInPriceBizDate desc,FSeq asc");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private String getResultFields() {
        StringBuffer sql = new StringBuffer();
        sql.append("FID, \n");
        sql.append("FSeq, \n");
        sql.append("FPurchaseOrgUnitId , \n");
        sql.append("FCompanyOrgUnitId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FBillTypeId, \n");
        sql.append("FMaterialId, \n");
        sql.append("FMaterialPurchaseType, \n");
        sql.append("FUnitId, \n");
        sql.append("FPurUnitId, \n");
        sql.append("FBaseUnitId, \n");
        sql.append("FCurrencyId, \n");
        sql.append("FBaseCurrencyId, \n");
        sql.append("FAssistPropertyId, \n");
        sql.append("FReceiveOrgUnitId, \n");
        sql.append("FPurPriceStrategyId, \n");
        sql.append("FQty, \n");
        sql.append("FBaseQty, \n");
        sql.append("FBizDate, \n");
        sql.append("FDeliveryDate, \n");
        sql.append("FExchangeTableId, \n");
        sql.append("FPricePrecision ,\n");
        sql.append("FPrice, \n");
        sql.append("FTaxRate, \n");
        sql.append("FOriginPrice, \n");
        sql.append("FOriginTaxPrice, \n");
        sql.append("FInPriceUnitId, \n");
        sql.append("FInPriceCurrencyId, \n");
        sql.append("FPriceType, \n");
        sql.append("FIsInTax, \n");
        sql.append("FDiscountRate, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FInPriceSupplierName, \n");
        sql.append("FInPriceSupplierNumber,\n");
        sql.append("FInPriceBillTypeId, \n");
        sql.append("FInPriceBizDate, \n");
        sql.append("FInPriceRecOrgUnitId ");
        return sql.toString();
    }

    public PurPriceInfoCollection readPriceInfoCol(Context ctx, String tempTable) throws BOSException {
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        StringBuffer sql = new StringBuffer();
        sql.append(" select * from (");
        sql.append(this.getResultSql(ctx, tempTable, this.getLatestPriceOrderbySql(), true));
        sql.append(" \n union all \n");
        sql.append(this.getResultSql(ctx, tempTable, "", false));
        sql.append(" ) as temp order by temp.FIsLatestPrice desc,");
        if (((Boolean)this.paramCol.get("isByBillType")).booleanValue()) {
            sql.append(" temp.FInPriceBillTypeId,");
        }
        sql.append(" temp.FBizDate desc,temp.FInPriceBizDate desc,fseq asc,temp.fid desc  ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PurPriceInfo purPriceInfo = new PurPriceInfo();
                int presicion = 2;
                if (!StringUtil.isEmpty((String)rs.getString("FPricePrecision"))) {
                    presicion = rs.getInt("FPricePrecision");
                }
                purPriceInfo.setPricePrecision(presicion);
                purPriceInfo.setTaxRate(rs.getBigDecimal("FTaxRate"));
                String priceType = rs.getString("FInPriceBillTypeId");
                if (rs.getString("FIsLatestPrice").equals("true")) {
                    if (!StringUtil.isEmpty((String)priceType)) {
                        if (priceType.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552") || priceType.equals("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=") || priceType.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
                            purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LATEST_ORDER_PRICE);
                        } else if (priceType.equals("510b6503-0105-1000-e000-010bc0a813fd463ED552")) {
                            purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LATEST_CONTRACT_PRICE);
                        } else {
                            purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LATEST_SETTLE_PRICE);
                        }
                    } else {
                        purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LATEST_SETTLE_PRICE);
                    }
                } else if (!StringUtil.isEmpty((String)priceType)) {
                    if (priceType.equals("510b6503-0105-1000-e000-010bc0a812fd463ED552") || priceType.equals("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=") || priceType.equals("50957179-0105-1000-e006-6152c0a812fd463ED552")) {
                        purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LOWEST_ORDER_PRICE);
                    } else if (priceType.equals("510b6503-0105-1000-e000-010bc0a813fd463ED552")) {
                        purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LOWEST_CONTRACT_PRICE);
                    } else {
                        purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LOWEST_SETTLE_PRICE);
                    }
                } else {
                    purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.LOWEST_SETTLE_PRICE);
                }
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceSupplierId"))) {
                    purPriceInfo.put("supplierID", rs.getString("FInPriceSupplierId"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceSupplierName"))) {
                    purPriceInfo.put("supplier", rs.getString("FInPriceSupplierName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FSimpleName"))) {
                    purPriceInfo.put("supplier.simpleName", rs.getString("FSimpleName"));
                }
                purPriceInfo.put("unit", rs.getString("unitName"));
                if (!StringUtil.isEmpty((String)rs.getString("propertyName"))) {
                    purPriceInfo.put("assistProperty", rs.getString("propertyName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("currencyName"))) {
                    purPriceInfo.put("currency", rs.getString("currencyName"));
                }
                BigDecimal originPrice = new BigDecimal(rs.getString("FOriginPrice"));
                originPrice = originPrice.setScale(presicion, 4);
                purPriceInfo.setPrice(originPrice);
                BigDecimal originTaxPrice = new BigDecimal(rs.getString("FOriginTaxPrice"));
                originTaxPrice = originTaxPrice.setScale(presicion, 4);
                purPriceInfo.put("taxPrice", originTaxPrice);
                if (!StringUtil.isEmpty((String)rs.getString("FDiscountRate"))) {
                    purPriceInfo.setDiscountRate(new BigDecimal(rs.getString("FDiscountRate")));
                } else {
                    purPriceInfo.setDiscountRate(new BigDecimal("0.0"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FPrice"))) {
                    purPriceInfo.put("comparePrice", new BigDecimal(rs.getString("FPrice")));
                } else {
                    purPriceInfo.put("comparePrice", new BigDecimal("0.0"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FQty"))) {
                    purPriceInfo.put("qty", new BigDecimal(rs.getString("FQty")));
                } else {
                    purPriceInfo.put("qty", new BigDecimal("0.0"));
                }
                if (this.paramCol.get("isTaxPrice") != null) {
                    purPriceInfo.put("isTaxPrice", (Boolean)this.paramCol.get("isTaxPrice"));
                } else if (rs.getString("FIsInTax").equals("1")) {
                    purPriceInfo.put("isTaxPrice", new Boolean(true));
                } else {
                    purPriceInfo.put("isTaxPrice", new Boolean(false));
                }
                if (!StringUtil.isEmpty((String)rs.getString("orgUnitName"))) {
                    purPriceInfo.put("recOrgUnit", rs.getString("orgUnitName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FBizDate"))) {
                    purPriceInfo.put("billDate", rs.getDate("FBizDate"));
                }
                priceInfoCol.addPurPriceInfo(purPriceInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            FetchPurPriceUtil.releaseTempTable(ctx, tempTable);
            FetchPurPriceUtil.releaseTempTable(ctx, this.tempTable4MinPrice);
        }
        return priceInfoCol;
    }

    private String getResultSql(Context ctx, String tempTable, String orderbySql, boolean isLatestPrice) {
        StringBuffer sql = new StringBuffer();
        if (!isLatestPrice) {
            sql.append(" select 'false' as FIsLatestPrice, \n");
        } else {
            sql.append("select 'true' as FIsLatestPrice,");
        }
        sql.append("t.FSeq, \n");
        sql.append("t.FPrice, \n");
        sql.append("t.FtaxRate, \n");
        sql.append("t.FOriginPrice, \n");
        sql.append("t.FOriginTaxPrice, \n");
        sql.append("t.FQty, \n");
        sql.append("t.FBizDate, \n");
        sql.append("t.FInPriceBillTypeId, \n");
        sql.append("t.FMaterialId, \n");
        sql.append("t.FInPriceCurrencyId, \n");
        sql.append("currency.fname_" + ctx.getLocale() + " as currencyName, \n");
        sql.append("t.FInPriceUnitId, \n");
        sql.append("unit.fname_" + ctx.getLocale() + " as unitName ,\n");
        sql.append("t.FIsInTax, \n");
        sql.append("t.FPricePrecision, \n");
        sql.append("t.FDiscountRate, \n");
        sql.append("t.FInPriceSupplierId, \n");
        sql.append("t.FInPriceSupplierName, \n");
        sql.append("t.FInPriceSupplierNumber, \n");
        sql.append("t.FAssistPropertyId, \n");
        sql.append("assistProperty.Fname_" + ctx.getLocale() + " as propertyName, \n");
        sql.append("reqOrgUnit.fname_" + ctx.getLocale() + " as orgUnitName, \n");
        sql.append("t.FInPriceBizDate, \n");
        sql.append("t.FPriceType, \n");
        sql.append("t.FID, \n");
        sql.append("supplier.FSimpleName \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append(" left outer join t_bd_currency currency on currency.fid = t.FInPriceCurrencyId \n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = t.FInPriceUnitId \n");
        sql.append(" left outer join t_bd_AsstAttrValue assistProperty on assistProperty.fid = t.FAssistPropertyId \n");
        sql.append(" left outer join t_org_baseUnit reqOrgUnit on reqOrgUnit.fid = t.FInPriceRecOrgUnitId \n");
        sql.append(" left outer join t_bd_supplier supplier on supplier.fid = t.FInPriceSupplierId \n");
        sql.append("where t.FID in \n");
        Integer qty = (Integer)this.paramCol.get("latestPriceQty");
        if (isLatestPrice) {
            sql.append("( ");
            if (((Boolean)this.paramCol.get("isByBillType")).booleanValue()) {
                sql.append("select t1.FID from ").append(tempTable).append(" t1, ").append(tempTable).append(" t2 \n");
                sql.append("where t1.FInPriceBillTypeId=t2.FInPriceBillTypeId and t1.KSQL_SEQ>=t2.KSQL_SEQ \n");
                sql.append("group by t1.FInPriceBillTypeId, t1.FID having count(*)<=").append(qty.toString());
            } else {
                sql.append("select top 1 t1.FID from ").append(tempTable).append(" t1 order by ");
                sql.append("t1.FBizDate desc, t1.FInPriceBizDate desc, t1.FSeq asc \n");
            }
            sql.append(") ");
        } else {
            sql.append("( ");
            if (((Boolean)this.paramCol.get("isByBillType")).booleanValue()) {
                sql.append("select t1.FID from  ").append(this.tempTable4MinPrice).append(" t1, ");
                sql.append(this.tempTable4MinPrice).append(" t2 \n");
                sql.append("where t1.FInPriceBillTypeId=t2.FInPriceBillTypeId and t1.KSQL_SEQ>=t2.KSQL_SEQ \n");
                sql.append("group by t1.FInPriceBillTypeId, t1.FID having count(*)=1 ");
            } else {
                sql.append("select top 1 t1.FID from  ").append(this.tempTable4MinPrice);
                sql.append(" t1 order by t1.FPrice asc, t1.FBizDate desc, t1.FInPriceBizDate desc, t1.FSeq asc\n");
            }
            sql.append(") ").append(" and ").append(this.getDateFilterSql());
        }
        return sql.toString();
    }

    protected String getLatestPriceOrderbySql() {
        return " order by t1.FBizDate desc,t1.FInPriceBizDate desc , t1.FSeq asc,t1.fprice asc ";
    }

    protected String getMinPriceOrderbySql() {
        return " order by t1.FPrice asc ";
    }

    protected String getOtherBillFilterSql() {
        return "";
    }

    protected String getPurOrderFilterSql() {
        return "";
    }

    protected String getPurContractFilterSql() {
        return "";
    }

    protected String getSubContractOrderFilterSql() {
        return "";
    }

    @Override
    protected String getTempResultOrderBySql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" order by tmp.FBillTypeId asc, tmp.FBizDate desc, tmp.FAuditTime desc, tmp.FSeq asc ");
        return sql.toString();
    }

    protected String getDateFilterSql() {
        StringBuffer buffer = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        Date currentDate = new Date();
        calendar.setTime(currentDate);
        Integer qty = (Integer)this.paramCol.get("queryPriceDate");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String fromDate = sdf.format(calendar.getTime());
        if (qty > 0) {
            calendar.add(2, -qty.intValue());
            fromDate = sdf.format(calendar.getTime());
            fromDate = fromDate + " 00:00:00.0";
        } else {
            fromDate = fromDate + " 23:59:59.0";
        }
        String toDate = sdf.format(currentDate);
        toDate = toDate + " 23:59:59.0";
        buffer.append(" t.FBizDate>=to_date('" + fromDate + "') and t.FBizDate<=to_date('" + toDate + "') \n");
        return buffer.toString();
    }
}

