/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.scm.sm.srm.FetchPriceFactorCollection;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyFactory;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.StringUtil;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceQueryTypeEnum;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.supplier.SupplierPriceProvider;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class QuerySupplierPriceProvider
extends SupplierPriceProvider {
    private PurPriceParamCollection paramCol = null;
    private String initTempTable = null;

    public QuerySupplierPriceProvider(PurPriceParamCollection paramCol) {
        this.paramCol = paramCol;
    }

    @Override
    public Object fetchPrice(Context ctx, String tempTable, String purPriceStrategyId) throws BOSException, EASBizException {
        this.initTempTable = FetchPurPriceUtil.createTempTable(ctx, this.paramCol);
        StringBuffer oql = new StringBuffer();
        oql.append("select factorEntries.factorItem.id, factorEntries.itemValue.id where id='");
        oql.append(purPriceStrategyId).append("' ");
        PurPriceStrategyInfo strategyInfo = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getPurPriceStrategyInfo(oql.toString());
        FetchPriceFactorCollection factors = strategyInfo.getFactorEntries();
        this.getSupplierPrice(ctx, tempTable, factors);
        FetchPurPriceUtil.convertPriceByUnit(ctx, this.initTempTable);
        FetchPurPriceUtil.convertPriceByCurrency(ctx, this.initTempTable);
        return this.readPriceInfoCol(ctx, this.initTempTable);
    }

    private void getSupplierPrice(Context ctx, String tempTable, FetchPriceFactorCollection factors) throws BOSException {
        StringBuffer temResult = this.createResultSql(ctx, tempTable, factors);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(this.initTempTable).append(" \n");
        sql.append("(FID, \n");
        sql.append("FSeq, \n");
        sql.append("FPurchaseOrgUnitId , \n");
        sql.append("FCompanyOrgUnitId, \n");
        sql.append("FSupplierId, \n");
        sql.append("FBillTypeId, \n");
        sql.append("FMaterialId, \n");
        sql.append("FMaterialPurchaseType, \n");
        sql.append("FUnitId, \n");
        sql.append("FPurUnitId, \n");
        sql.append("FBaseUnitId, \n");
        sql.append("FCurrencyId, \n");
        sql.append("FBaseCurrencyId, \n");
        sql.append("FAssistPropertyId, \n");
        sql.append("FReceiveOrgUnitId, \n");
        sql.append("FPurPriceStrategyId, \n");
        sql.append("FQty, \n");
        sql.append("FBaseQty, \n");
        sql.append("FBizDate, \n");
        sql.append("FDeliveryDate, \n");
        sql.append("FExchangeTableId, \n");
        sql.append("FPricePrecision, \n");
        sql.append("FPrice, \n");
        sql.append("FTaxRate, \n");
        sql.append("FInPriceUnitId, \n");
        sql.append("FInPriceCurrencyId, \n");
        sql.append("FPriceType, \n");
        sql.append("FIsInTax, \n");
        sql.append("FDiscountRate, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FInPriceSupplierName, \n");
        sql.append("FInPriceSupplierNumber, \n");
        sql.append("FInPriceBizDate, \n");
        sql.append("FInPriceBillTypeId, \n");
        sql.append("FFromQty, \n");
        sql.append("FOriginPrice, \n");
        sql.append("FOriginTaxPrice, \n");
        sql.append("FInPriceRecOrgUnitId, \n");
        sql.append("FInPriceEffectiveDate, \n");
        sql.append("FInPriceUnEffectiveDate)\n");
        sql.append("select newbosid('406FDF31'), \n");
        sql.append("t.FSeq, \n");
        sql.append("t.FPurchaseOrgUnitId , \n");
        sql.append("t.FCompanyOrgUnitId, \n");
        sql.append("t.FSupplierId, \n");
        sql.append("t.FBillTypeId, \n");
        sql.append("t.FMaterialId, \n");
        sql.append("t.FMaterialPurchaseType, \n");
        sql.append("t.FUnitId, \n");
        sql.append("t.FPurUnitId, \n");
        sql.append("t.FBaseUnitId, \n");
        sql.append("t.FCurrencyId, \n");
        sql.append("t.FBaseCurrencyId, \n");
        sql.append("tmp.FAssistPropertyId, \n");
        sql.append("t.FReceiveOrgUnitId, \n");
        sql.append("t.FPurPriceStrategyId, \n");
        sql.append("t.FQty, \n");
        sql.append("t.FBaseQty, \n");
        sql.append("t.FBizDate, \n");
        sql.append("t.FDeliveryDate, \n");
        sql.append("t.FExchangeTableId, \n");
        sql.append("t.FPricePrecision, \n");
        sql.append("tmp.FPrice, \n");
        sql.append("tmp.FTaxRate, \n");
        sql.append("tmp.FPurMeasureUnitId, \n");
        sql.append("tmp.FCurrencyId, \n");
        sql.append("0, \n");
        sql.append("tmp.FIsTaxPrice, \n");
        sql.append("tmp.FDiscountRate, \n");
        sql.append("tmp.FInPriceSupplierId, \n");
        sql.append("tmp.FInPriceSupplierName, \n");
        sql.append("tmp.FInPriceSupplierNumber, \n");
        sql.append("tmp.FAuditDate, \n");
        sql.append("'SUPPLIERpRICETyPE', \n");
        sql.append("tmp.FFromQty, \n");
        sql.append("case when tmp.FIsTaxPrice = 0 then tmp.FPrice else null end, \n");
        sql.append("case when tmp.FIsTaxPrice = 1 then tmp.FPrice else null end, \n");
        sql.append("tmp.FRecOrgID, \n");
        sql.append("tmp.FEffectualDate, \n");
        sql.append("tmp.FUneffectualDate \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("inner join ");
        sql.append("(").append(temResult.toString()).append(") tmp ");
        sql.append("  on t.FID = tmp.FTraceId ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    public PurPriceInfoCollection readPriceInfoCol(Context ctx, String tempTable) throws BOSException {
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        StringBuffer sql = new StringBuffer();
        sql.append("select " + this.getTempResultSelectSql() + " t.FSeq, \n");
        sql.append("t.FPrice, \n");
        sql.append("t.FTaxRate, \n");
        sql.append("t.FMaterialId, \n");
        sql.append("t.FInPriceCurrencyId, \n");
        sql.append("t.FInPriceUnitId, \n");
        sql.append("t.FIsInTax, \n");
        sql.append("t.FPricePrecision, \n");
        sql.append("t.FDiscountRate, \n");
        sql.append("t.FInPriceSupplierId, \n");
        sql.append("t.FInPriceSupplierName, \n");
        sql.append("t.FInPriceSupplierNumber, \n");
        sql.append("t.FPriceType, \n");
        sql.append("currency.fname_" + ctx.getLocale() + " as currencyName, \n");
        sql.append("unit.fname_" + ctx.getLocale() + " as unitName ,\n");
        sql.append("t.FAssistPropertyId, \n");
        sql.append("assistProperty.Fname_" + ctx.getLocale() + " as propertyName, \n");
        sql.append("t.FFromQty, \n");
        sql.append("t.FOriginPrice ,\n");
        sql.append("t.FOriginTaxPrice ,\n");
        sql.append("t.FInPriceRecOrgUnitId ,\n");
        sql.append("reqOrgUnit.fname_" + ctx.getLocale() + " as orgUnitName, \n");
        sql.append("t.FInPriceEffectiveDate, \n");
        sql.append("t.FInPriceUnEffectiveDate, \n");
        sql.append("t.FInPriceBizDate, \n");
        sql.append("supplier.FSimpleName \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append(" left outer join t_bd_currency currency on currency.fid = t.FInPriceCurrencyId \n");
        sql.append(" left outer join t_bd_measureunit unit on unit.fid = t.FInPriceUnitId \n");
        sql.append(" left outer join t_bd_AsstAttrValue assistProperty on assistProperty.fid = t.FAssistPropertyId \n");
        sql.append(" left outer join t_org_baseUnit reqOrgUnit on reqOrgUnit.fid = t.FInPriceRecOrgUnitId \n");
        sql.append(" left outer join t_bd_supplier supplier on supplier.fid = t.FInPriceSupplierId \n");
        sql.append(" order by t.FInPriceBizDate desc,t.FSeq asc");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                PurPriceInfo purPriceInfo = new PurPriceInfo();
                int presicion = 2;
                if (!StringUtil.isEmpty((String)rs.getString("FPricePrecision"))) {
                    presicion = rs.getInt("FPricePrecision");
                }
                purPriceInfo.setPricePrecision(presicion);
                purPriceInfo.setTaxRate(rs.getBigDecimal("FTaxRate"));
                purPriceInfo.put("priceType", (Object)PurPriceQueryTypeEnum.SUPPLIER_PRICE);
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceSupplierId"))) {
                    purPriceInfo.put("supplierID", rs.getString("FInPriceSupplierId"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceSupplierName"))) {
                    purPriceInfo.put("supplier", rs.getString("FInPriceSupplierName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FSimpleName"))) {
                    purPriceInfo.put("supplier.simpleName", rs.getString("FSimpleName"));
                }
                purPriceInfo.put("unit", rs.getString("unitName"));
                if (!StringUtil.isEmpty((String)rs.getString("propertyName"))) {
                    purPriceInfo.put("assistProperty", rs.getString("propertyName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("currencyName"))) {
                    purPriceInfo.put("currency", rs.getString("currencyName"));
                }
                boolean isTaxPrice = true;
                BigDecimal originPrice = null;
                if (rs.getString("FOriginPrice") != null) {
                    isTaxPrice = false;
                    originPrice = new BigDecimal(rs.getString("FOriginPrice"));
                    originPrice = originPrice.setScale(presicion, 4);
                }
                purPriceInfo.setPrice(originPrice);
                BigDecimal originTaxPrice = null;
                if (rs.getString("FOriginTaxPrice") != null) {
                    originTaxPrice = new BigDecimal(rs.getString("FOriginTaxPrice"));
                    originTaxPrice = originTaxPrice.setScale(presicion, 4);
                }
                purPriceInfo.put("taxPrice", originTaxPrice);
                purPriceInfo.put("isSupplierPrice", new Boolean(isTaxPrice));
                if (!StringUtil.isEmpty((String)rs.getString("FDiscountRate"))) {
                    purPriceInfo.setDiscountRate(new BigDecimal(rs.getString("FDiscountRate")));
                } else {
                    purPriceInfo.setDiscountRate(new BigDecimal("0.0"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FPrice"))) {
                    purPriceInfo.put("comparePrice", new BigDecimal(rs.getString("FPrice")));
                } else {
                    purPriceInfo.put("comparePrice", new BigDecimal("0.0"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FFromQty"))) {
                    purPriceInfo.put("qty", new BigDecimal(rs.getString("FFromQty")));
                } else {
                    purPriceInfo.put("qty", new BigDecimal("0.0"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("orgUnitName"))) {
                    purPriceInfo.put("recOrgUnit", rs.getString("orgUnitName"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceEffectiveDate"))) {
                    purPriceInfo.put("effectDate", rs.getDate("FInPriceEffectiveDate"));
                }
                if (!StringUtil.isEmpty((String)rs.getString("FInPriceUnEffectiveDate"))) {
                    purPriceInfo.put("unEffectDate", rs.getDate("FInPriceUnEffectiveDate"));
                }
                if (this.paramCol.get("isTaxPrice") != null) {
                    purPriceInfo.put("isTaxPrice", (Boolean)this.paramCol.get("isTaxPrice"));
                } else if (rs.getString("FIsInTax").equals("1")) {
                    purPriceInfo.put("isTaxPrice", new Boolean(true));
                } else {
                    purPriceInfo.put("isTaxPrice", new Boolean(false));
                }
                priceInfoCol.addPurPriceInfo(purPriceInfo);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return priceInfoCol;
    }

    @Override
    protected String getTempResultSelectSql() {
        StringBuffer getResultSql = new StringBuffer();
        Integer qty = (Integer)this.paramCol.get("SupplierPriceQty");
        if (qty != null) {
            getResultSql.append(" top " + qty + " ");
        } else {
            getResultSql.append(" ");
        }
        return getResultSql.toString();
    }

    public static String createTotalTempTable(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table TotalPrice ( \n");
        sql.append("FTraceId varchar(44) not null, \n");
        sql.append("FBaseFromQty numeric(21,8), \n");
        sql.append("FIsCurrencyMatch INT not null default 0, \n");
        sql.append("FIsUnitMatch INT not null default 0, \n");
        sql.append("FAuditDate datetime, \n");
        sql.append("FPrice numeric(21,8) , \n");
        sql.append("FTaxRate numeric(21,8) , \n");
        sql.append("FPurMeasureUnitId varchar(44), \n");
        sql.append("FCurrencyId varchar(44), \n");
        sql.append("FIsTaxPrice INT not null default 0, \n");
        sql.append("FDiscountRate numeric(21,8), \n");
        sql.append("FInPriceSupplierId varchar(44), \n");
        sql.append("FInPriceSupplierName varchar(80), \n");
        sql.append("FInPriceSupplierNumber varchar(80), \n");
        sql.append("FFromQty numeric(21,8), \n");
        sql.append("FRecOrgID varchar(44), \n");
        sql.append("FEffectualDate datetime, \n");
        sql.append("FUneffectualDate datetime, \n");
        sql.append("FAssistPropertyId varchar(44)) \n");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    @Override
    protected StringBuffer createResultSql(Context ctx, String tempTable, FetchPriceFactorCollection factors) {
        StringBuffer getResultSql;
        String totalTempTable;
        block5: {
            block4: {
                totalTempTable = null;
                try {
                    totalTempTable = QuerySupplierPriceProvider.createTotalTempTable(ctx);
                }
                catch (BOSException e) {
                    if (totalTempTable == null) break block4;
                    TempTablePool.getInstance((Context)ctx).releaseTable(totalTempTable);
                }
            }
            getResultSql = new StringBuffer();
            getResultSql.append(" insert into " + totalTempTable);
            getResultSql.append(" (FFromQty,FRecOrgID,FEffectualDate,FUneffectualDate,FAssistPropertyId, FTraceId,");
            getResultSql.append(" FBaseFromQty,FIsCurrencyMatch,FIsUnitMatch,FAuditDate,FPrice,FTaxRate,FPurMeasureUnitId,");
            getResultSql.append(" FCurrencyId,FIsTaxPrice,FDiscountRate,FInPriceSupplierId,FInPriceSupplierName,FInPriceSupplierNumber)");
            getResultSql.append("select ").append(this.getTempResultSelectSql()).append(" \n");
            getResultSql.append("t1.FFromQty, \n");
            getResultSql.append("t1.FRecOrgID, \n");
            getResultSql.append("t1.FEffectualDate, \n");
            getResultSql.append("t1.FUneffectualDate, \n");
            getResultSql.append("t1.FAssistPropertyId, \n");
            getResultSql.append(" t.FID FTraceId, \n");
            getResultSql.append("round(decimal(t1.FFromQty/u.FBaseConvsRate, 21,8),bu.FQtyPrecision) FBaseFromQty, \n");
            getResultSql.append("case when t.FCurrencyId=t1.FCurrencyId then 1 else 0 end FIsCurrencyMatch, \n");
            getResultSql.append("case when t.FunitId=t1.FPurMeasureUnitId then 1 else 0 end FIsUnitMatch, \n");
            getResultSql.append("t1.FAuditDate,\n");
            getResultSql.append("t1.FPrice, \n");
            getResultSql.append("t1.FTaxRate, \n");
            getResultSql.append("t1.FPurMeasureUnitId, \n");
            getResultSql.append("t1.FCurrencyId, \n");
            getResultSql.append("t1.FIsTaxPrice, \n");
            getResultSql.append("t1.FDiscountRate, \n");
            getResultSql.append("s.FID FInPriceSupplierId, \n");
            getResultSql.append("s.FName_").append(ctx.getLocale()).append(" FInPriceSupplierName, \n");
            getResultSql.append("s.FNumber FInPriceSupplierNumber \n");
            getResultSql.append("from ").append(tempTable).append(" t \n");
            getResultSql.append("inner join t_sm_supplyInfo t1 on t.FMaterialId = t1.FMaterialItemId ");
            getResultSql.append("  and t.FPurchaseOrgUnitId = t1.FPurchaseOrgId and t1.FIsUseable = 1 \n");
            getResultSql.append("inner join t_bd_multiMeasureUnit u on t.FMaterialId=u.FMaterialId \n");
            getResultSql.append("  and t1.FPurMeasureUnitId=u.FMeasureUnitId \n");
            getResultSql.append("inner join t_bd_multiMeasureUnit bu on t.FMaterialId=bu.FMaterialId \n");
            getResultSql.append("  and t.FBaseUnitId=bu.FMeasureUnitId \n");
            getResultSql.append("inner join t_bd_supplier s on t1.fsupplierId=s.FID \n");
            getResultSql.append("where \n");
            getResultSql.append(this.getFilterSql(factors));
            getResultSql.append(" order by t.FID asc, FIsCurrencyMatch desc, FIsUnitMatch desc, FBaseFromQty desc, t1.FAuditDate desc ");
            try {
                DbUtil.execute((Context)ctx, (String)getResultSql.toString());
            }
            catch (BOSException e) {
                if (totalTempTable == null) break block5;
                TempTablePool.getInstance((Context)ctx).releaseTable(totalTempTable);
            }
        }
        getResultSql.delete(0, getResultSql.length());
        getResultSql.append("select * from " + totalTempTable + " where FBaseFromQty =( select top 1 FBaseFromQty from " + totalTempTable + " order by FBaseFromQty desc )");
        return getResultSql;
    }
}

