/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.QuotaPolicyCollection;
import com.kingdee.eas.basedata.master.material.QuotaPolicyFactory;
import com.kingdee.eas.basedata.master.material.QuotaPolicyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.IQuotaPolicy;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;

public class QuotaAssignImpl
extends AbstractPurBusinessImpl<QuotaVOCollection> {
    private QuotaContext quotaCtx = null;
    private PurchaseTypeEnum purchaseType = null;
    private QuotaVOCollection quotaVOCol = null;
    private Map<String, IQuotaPolicy> cache = new HashMap<String, IQuotaPolicy>();

    public QuotaAssignImpl(Context ctx, Object param) {
        super(ctx, param);
        this.purchaseType = (PurchaseTypeEnum)((Object[])param)[0];
        this.quotaVOCol = (QuotaVOCollection)((Object[])param)[1];
        this.quotaCtx = new QuotaContext(ctx, this.purchaseType);
    }

    @Override
    protected QuotaVOCollection execute() throws EASBizException, BOSException {
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        this.quotaCtx.init(this.quotaVOCol);
        IQuotaPolicy executor = null;
        for (int i = 0; i < this.quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = this.quotaVOCol.getQuotaVO(i);
            MaterialPurchasingInfo purInfo = this.quotaCtx.getMaterialPurInfo(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
            if (purInfo != null && purInfo.getQuotaPolicy() != null) {
                executor = this.getPolicyExecutor(purInfo.getQuotaPolicy().getId().toString());
            }
            if (executor == null) continue;
            QuotaVOCollection voCol = executor.assign(quotaVO);
            quotaVOColAssign.merge(voCol);
        }
        return quotaVOColAssign;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return " Quota Assign ";
    }

    private IQuotaPolicy getPolicyExecutor(String key) throws BOSException {
        if (this.cache.size() == 0) {
            this.initCache();
        }
        return this.cache.get(key);
    }

    private void initCache() throws BOSException {
        QuotaPolicyCollection policyCol = QuotaPolicyFactory.getLocalInstance((Context)this.ctx).getQuotaPolicyCollection();
        for (int i = 0; i < policyCol.size(); ++i) {
            QuotaPolicyInfo policyInfo = policyCol.get(i);
            AbstractQuotaPolicy executor = null;
            Constructor<?> constructor = null;
            try {
                constructor = Class.forName(policyInfo.getClassname()).getConstructor(QuotaContext.class);
                executor = (AbstractQuotaPolicy)constructor.newInstance(this.quotaCtx);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            this.cache.put(policyInfo.getId().toString(), executor);
        }
        if (this.cache.size() == 0) {
            throw new BOSException(" init QuotaPolicy error ");
        }
    }
}

