/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class QuotaContext {
    private PurchaseTypeEnum purchaseType = null;
    private Context ctx = null;
    private Map<String, MaterialPurchasingInfo> materialPurInfoCol = new HashMap<String, MaterialPurchasingInfo>();
    private Map<String, List<ApprovedSupplierInfo>> supplierQuotaCol = new HashMap<String, List<ApprovedSupplierInfo>>();
    private Map<String, MultiMeasureUnitInfo> measureUnitInfoCol = new HashMap<String, MultiMeasureUnitInfo>();

    public PurchaseTypeEnum getPurchaseType() {
        return this.purchaseType;
    }

    public Context getCtx() {
        return this.ctx;
    }

    public QuotaContext(Context ctx, PurchaseTypeEnum purchaseType) {
        this.ctx = ctx;
        this.purchaseType = purchaseType;
    }

    public MaterialPurchasingInfo getMaterialPurInfo(String materialId, String purOrgUnitId) {
        return this.materialPurInfoCol.get(materialId + purOrgUnitId);
    }

    public List<ApprovedSupplierInfo> getSupplierQuotas(String materialId, String purOrgUnitId) {
        ArrayList supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        return supplierQuotas != null ? supplierQuotas : new ArrayList();
    }

    public MultiMeasureUnitInfo getMultiUnit(String materialId, String unitId) {
        return this.measureUnitInfoCol.get(materialId + unitId);
    }

    public void init(QuotaVOCollection quotaVOCol) throws BOSException {
        this.initMaterialPurchasing(quotaVOCol);
        this.initSupplierQuota(quotaVOCol);
        this.initMultiMeasureUnit(quotaVOCol);
    }

    private void initMaterialPurchasing(QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer oql = new StringBuffer();
        oql.append("select material.id, unit.id,unit.name,unit.number, orgUnit.id, minDivisionQty, quotaPeriod, ");
        oql.append(" quotaPolicy.id,quotaPolicy.name,useSupplyList \n");
        String purOrgUnitId = quotaVOCol.getQuotaVO(0).getPurOrgUnitId();
        StringBuffer materialIds = new StringBuffer();
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            if (i > 0) {
                materialIds.append(",");
            }
            materialIds.append("'").append(quotaVOCol.getQuotaVO(i).getMaterialId()).append("'");
        }
        oql.append(" where orgUnit.id = '").append(purOrgUnitId).append("'\n").append(" and material.id in (").append(materialIds).append(")");
        MaterialPurchasingCollection purCol = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx).getMaterialPurchasingCollection(oql.toString());
        for (int i = 0; i < purCol.size(); ++i) {
            MaterialPurchasingInfo purInfo = purCol.get(i);
            String key = purInfo.getMaterial().getId().toString() + purInfo.getOrgUnit().getId().toString();
            this.materialPurInfoCol.put(key, purInfo);
        }
    }

    protected void initSupplierQuota(QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer oql = new StringBuffer();
        String materialPurchaseType = "0";
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)this.purchaseType)) {
            materialPurchaseType = "1";
        }
        oql.append("select purMeasureUnit.id,purMeasureUnit.name,purMeasureUnit.number, purchaseOrg.id, materialItem.id, minPackingQty, \n");
        oql.append(" qtyOrderBottom, qtyOrderTop, supplyScope, supplier.number, supplier.name, \n");
        oql.append(" quotaRate, supplyPriority \n");
        oql.append(" where materialAttr = ").append(materialPurchaseType).append("  \n");
        oql.append("  and isUseable = ").append(1).append("  \n");
        String purOrgUnitId = quotaVOCol.getQuotaVO(0).getPurOrgUnitId();
        StringBuffer materialIds = new StringBuffer();
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            if (i > 0) {
                materialIds.append(",");
            }
            materialIds.append("'").append(quotaVOCol.getQuotaVO(i).getMaterialId()).append("'");
        }
        oql.append(" and purchaseOrg.id = '").append(purOrgUnitId).append("'\n").append(" and materialItem.id in (").append(materialIds).append(")").append(" order by materialItem.id, purchaseOrg.id ");
        ApprovedSupplierCollection supplierCol = ApprovedSupplierFactory.getLocalInstance((Context)this.ctx).getApprovedSupplierCollection(oql.toString());
        ArrayList<ApprovedSupplierInfo> suppliers = null;
        String lastKey = null;
        for (int i = 0; i < supplierCol.size(); ++i) {
            ApprovedSupplierInfo supplierQuota = supplierCol.get(i);
            String key = supplierQuota.getMaterialItem().getId().toString() + supplierQuota.getPurchaseOrg().getId().toString();
            if (lastKey == null || !lastKey.equals(key)) {
                suppliers = new ArrayList<ApprovedSupplierInfo>();
                this.supplierQuotaCol.put(key, suppliers);
            }
            lastKey = key;
            suppliers.add(supplierQuota);
        }
    }

    private void initMultiMeasureUnit(QuotaVOCollection quotaVOCol) throws BOSException {
        int i;
        StringBuffer oql = new StringBuffer();
        oql.append("select material.id, measureUnit.id, baseConvsRate, qtyPrecision, minDivisionQty, quotaPeriod \n");
        oql.append(" where \n").append(" id is null \n");
        LinkedList<String> keys = new LinkedList<String>();
        String materialId = null;
        String unitId = null;
        String baseUnitId = null;
        for (int i2 = 0; i2 < quotaVOCol.size(); ++i2) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i2);
            materialId = quotaVO.getMaterialId();
            unitId = quotaVO.getUnitId();
            baseUnitId = quotaVO.getBaseUnitid();
            this.getMultiUnitFilter(oql, keys, baseUnitId, materialId);
            this.getMultiUnitFilter(oql, keys, unitId, materialId);
        }
        Iterator<String> purIter = this.materialPurInfoCol.keySet().iterator();
        while (purIter.hasNext()) {
            MaterialPurchasingInfo purInfo = this.materialPurInfoCol.get(purIter.next());
            materialId = purInfo.getMaterial().getId().toString();
            unitId = purInfo.getUnit().getId().toString();
            this.getMultiUnitFilter(oql, keys, unitId, materialId);
        }
        Iterator<String> supplierIter = this.supplierQuotaCol.keySet().iterator();
        while (supplierIter.hasNext()) {
            List<ApprovedSupplierInfo> supplierQuotas = this.supplierQuotaCol.get(supplierIter.next());
            for (i = 0; i < supplierQuotas.size(); ++i) {
                materialId = supplierQuotas.get(i).getMaterialItem().getId().toString();
                unitId = supplierQuotas.get(i).getPurMeasureUnit().getId().toString();
                this.getMultiUnitFilter(oql, keys, unitId, materialId);
            }
        }
        MultiMeasureUnitCollection unitCol = MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx).getMultiMeasureUnitCollection(oql.toString());
        for (i = 0; i < unitCol.size(); ++i) {
            MultiMeasureUnitInfo unitInfo = unitCol.get(i);
            String key = unitInfo.getMaterial().getId().toString() + unitInfo.getMeasureUnit().getId().toString();
            this.measureUnitInfoCol.put(key, unitInfo);
        }
    }

    private void getMultiUnitFilter(StringBuffer oql, List<String> keys, String unitId, String materialId) {
        String key = materialId + unitId;
        if (!keys.contains(key)) {
            keys.add(key);
            oql.append(" or (material.id='").append(materialId).append("' and measureUnit.id='").append(unitId).append("')\n");
        }
    }
}

