/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class WriteBackRequestBill {
    private Context ctx = null;
    private String entryTable = null;

    public WriteBackRequestBill(Context ctx, String billtypeid) {
        this.ctx = ctx;
        this.init(billtypeid);
    }

    private void init(String billtypeid) {
        this.entryTable = "510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billtypeid) ? "T_sm_purorderentry" : "T_SM_SubContractOrderEntry";
    }

    protected Connection getConnection() throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)this.ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public void writePurReqQtyForUpdate(SCMBillBaseInfo purOrderInfo) throws BOSException {
        BillTypeInfo billtype = purOrderInfo.getSourceBillType();
        if (billtype == null || !billtype.getId().toString().equals("510b6503-0105-1000-e000-0107c0a812fd463ED552")) {
            return;
        }
        if (this.entryTable == null) {
            return;
        }
        Connection con = null;
        Statement statement = null;
        String sourceBillId = null;
        try {
            AbstractObjectCollection coll;
            con = this.getConnection();
            StringBuffer sql = new StringBuffer();
            AbstractObjectCollection col = (AbstractObjectCollection)purOrderInfo.getEntries();
            SCMBillEntryBaseInfo entryInfo = null;
            String SorceBillEntryIDs = this.getSourceIDsStr("'" + purOrderInfo.getId().toString() + "'");
            if (null == SorceBillEntryIDs || SorceBillEntryIDs.equals("")) {
                return;
            }
            if (purOrderInfo.getId() != null) {
                sql.append(" update T_SM_purrequestentry as requestentry1  set (FassOrderBaseQty) = ");
                sql.append(" (select fassOrderBaseQty from ");
                sql.append(" ( select (requestentry.FassOrderBaseQty-sum(orderentry.fbaseqty)) as fassOrderBaseQty ");
                sql.append(",requestentry.fid as fid ");
                sql.append(" from ").append(this.entryTable).append(" as orderentry ");
                sql.append(",T_SM_purrequestentry as requestentry ");
                sql.append(" where orderentry.fparentid = ? ");
                sql.append(" and requestentry.fid = orderentry.FSOURCEBILLENTRYID ");
                sql.append(" group by requestentry.fid ,requestentry.FassOrderBaseQty) as t1 ");
                sql.append(" where t1.fid = requestentry1.fid");
                sql.append(")");
                sql.append(" where requestentry1.FID in (").append(SorceBillEntryIDs).append(")");
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{purOrderInfo.getId().toString()});
            }
            if (col.size() > 0) {
                sql.setLength(0);
                sql.append(" update T_SM_purrequestentry  set FassOrderBaseQty =FassOrderBaseQty+? where fid = ?  ");
                int size = col.size();
                for (int i = 0; i < size; ++i) {
                    entryInfo = (SCMBillEntryBaseInfo)col.getObject(i);
                    if (entryInfo.getSourceBillEntryId() == null) continue;
                    if (statement == null) {
                        statement = con.prepareStatement(sql.toString());
                    }
                    statement.setBigDecimal(1, entryInfo.getBigDecimal("baseQty"));
                    statement.setString(2, entryInfo.getSourceBillEntryId());
                    sourceBillId = entryInfo.getSourceBillId();
                    statement.addBatch();
                }
                if (statement != null) {
                    statement.executeBatch();
                }
            }
            if ((coll = (AbstractObjectCollection)purOrderInfo.get("entries")) != null && coll.getObject(0) != null && coll.getObject(0).get("sourceBillId") != null) {
                sourceBillId = coll.getObject(0).getString("sourceBillId");
                sql.setLength(0);
                sql.append(" update T_SM_purrequestentry as t set (FassOrderQty) = (select ");
                sql.append(" round(decimal(t.FassOrderBaseQty / unit.FBaseConvsRate,21,8),unit.FQtyPrecision) as FassOrderQty ");
                sql.append(" from  t_bd_multimeasureunit unit where t.FUnitID = unit.fmeasureunitid ");
                sql.append(" and t.fmaterialid = unit.fmaterialid ");
                sql.append(" and t.FID in (").append(SorceBillEntryIDs).append(") ");
                sql.append(" and fparentid = ?)");
                sql.append(" where t.FID in (").append(SorceBillEntryIDs).append(")");
                DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])new String[]{sourceBillId});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    public void writePurReqQtyForAdd(String ids) throws BOSException {
        if (this.entryTable == null) {
            return;
        }
        String SorceBillEntryIDs = this.getSourceIDsStr(ids);
        if (null == SorceBillEntryIDs || SorceBillEntryIDs.equals("")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SM_purrequestentry as requestentry1  set (FassOrderBaseQty,FassOrderQty) = ");
        sql.append(" (select FassOrderBaseQty,FassOrderQty from ");
        sql.append(" ( select requestentry.fid as fid,(requestentry.FassOrderBaseQty+sum(orderentry.fbaseqty)) as FassOrderBaseQty,");
        sql.append("  case when unit.FBaseConvsRate is null then requestentry.FassOrderBaseQty+sum(orderentry.fbaseqty) \n");
        sql.append("    else round(decimal((requestentry.FassOrderBaseQty+sum(orderentry.fbaseqty)) / unit.FBaseConvsRate,21,8),unit.FQtyPrecision) \n");
        sql.append("   end as FassOrderQty \n");
        sql.append(" from  ").append(this.entryTable).append("  as orderentry \n");
        sql.append(" left join T_SM_purrequestentry as requestentry on requestentry.fid = orderentry.FSOURCEBILLENTRYID");
        sql.append(" left join t_bd_multimeasureunit unit on requestentry.FUnitID = unit.fmeasureunitid and orderentry.fmaterialid = unit.fmaterialid \n");
        sql.append(" where orderentry.fsourceBillTypeid = '").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
        sql.append(" and orderentry.fparentid in( ").append(ids);
        sql.append(" )");
        sql.append(" and requestentry.fid in (").append(SorceBillEntryIDs).append(")");
        sql.append(" group by requestentry.fid,requestentry.FassOrderBaseQty  ,unit.FBaseConvsRate,unit.FQtyPrecision) as t1");
        sql.append(" where t1.fid = requestentry1.fid");
        sql.append(")");
        sql.append(" where requestentry1.FID in (").append(SorceBillEntryIDs).append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    public void writePurReqQtyForDelete(String ids) throws BOSException {
        if (this.entryTable == null) {
            return;
        }
        String SorceBillEntryIDs = this.getSourceIDsStr(ids);
        if (null == SorceBillEntryIDs || SorceBillEntryIDs.equals("")) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_SM_purrequestentry as requestentry1  set (FassOrderBaseQty,FassOrderQty) = ");
        sql.append(" (select FassOrderBaseQty,FassOrderQty from ");
        sql.append(" ( select requestentry.fid as fid, (requestentry.FassOrderBaseQty-sum(orderentry.fbaseqty)) as FassOrderBaseQty ,");
        sql.append(" round(decimal((requestentry.FassOrderBaseQty-sum(orderentry.fbaseqty)) / unit.FBaseConvsRate,21,8),unit.FQtyPrecision) as FassOrderQty ");
        sql.append(" from  ").append(this.entryTable).append("  as orderentry , t_bd_multimeasureunit unit");
        sql.append(" ,T_SM_purrequestentry as requestentry");
        sql.append(" where requestentry.FUnitID = unit.fmeasureunitid ");
        sql.append(" and orderentry.fmaterialid = unit.fmaterialid ");
        sql.append(" and orderentry.fsourceBillTypeid = '").append("510b6503-0105-1000-e000-0107c0a812fd463ED552").append("'");
        sql.append(" and orderentry.fparentid in( ").append(ids);
        sql.append(" )and requestentry.fid = orderentry.FSOURCEBILLENTRYID ");
        sql.append(" and requestentry.fid in (").append(SorceBillEntryIDs).append(")");
        sql.append(" group by requestentry.fid,requestentry.FassOrderBaseQty ,unit.FBaseConvsRate,unit.FQtyPrecision ) as t1 ");
        sql.append(" where t1.fid = requestentry1.fid");
        sql.append(")");
        sql.append(" where requestentry1.FID in (").append(SorceBillEntryIDs).append(")");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getSourceIDsStr(String ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select FSourceBillEntryID from T_SM_PurOrderEntry where FParentID in (").append(ids).append(")");
        IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rowSet == null || rowSet.size() == 0) {
            return "";
        }
        StringBuffer SorceBillEntryIDs = new StringBuffer();
        try {
            while (rowSet.next()) {
                SorceBillEntryIDs.append("'").append(rowSet.getString("FSourceBillEntryID")).append("'").append(",");
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return SorceBillEntryIDs.substring(0, SorceBillEntryIDs.length() - 1);
    }
}

