/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.IQuotaPolicy;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.ajust.BatchAjustPolicy;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractQuotaPolicy
implements IQuotaPolicy {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONE = new BigDecimal("1.00");
    public static final BigDecimal HUND = new BigDecimal("100.00");
    public static int SCALE_RATIO = 4;
    protected QuotaContext quotaCtx = null;

    public QuotaContext getQuotaCtx() {
        return this.quotaCtx;
    }

    public AbstractQuotaPolicy(QuotaContext quotaCtx) {
        this.quotaCtx = quotaCtx;
    }

    @Override
    public QuotaVOCollection assign(QuotaVO quotaVO) throws BOSException, EASBizException {
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        List<ApprovedSupplierInfo> supplierQuotas = this.getSupplierQuotas(quotaVO);
        QuotaVO voAssign = null;
        if (supplierQuotas != null && supplierQuotas.size() > 0) {
            this.sortSupplierQuotas(supplierQuotas);
            Iterator<ApprovedSupplierInfo> quotaIter = supplierQuotas.iterator();
            ApprovedSupplierInfo approvedSupplierInfo = null;
            BigDecimal minDivQty = this.getMinDivQty(quotaVO);
            while (quotaIter.hasNext() && quotaVO.getRemainEntryQty().compareTo(ZERO) > 0) {
                approvedSupplierInfo = quotaIter.next();
                voAssign = this.assign4Supplier(quotaVO, approvedSupplierInfo, supplierQuotas);
                BatchAjustPolicy ajustPolicy = new BatchAjustPolicy(this.quotaCtx);
                ajustPolicy.ajustPolicy(quotaVO, voAssign, approvedSupplierInfo);
                this.resetQuotaVO(quotaVO, voAssign);
                this.getRelatedData(voAssign, approvedSupplierInfo);
                quotaVOColAssign.addQuotaVO(voAssign);
                if (quotaVO.getEntryQty().compareTo(minDivQty) > 0 || voAssign.getSplitQty().compareTo(ZERO) <= 0) continue;
                break;
            }
        } else {
            voAssign = this.assign4NoSupplier(quotaVO);
            this.getRelatedData(voAssign);
            quotaVOColAssign.addQuotaVO(voAssign);
        }
        return quotaVOColAssign;
    }

    protected void getRelatedData(QuotaVO voAssign) {
        MaterialPurchasingInfo materialPurchasingInfo = this.quotaCtx.getMaterialPurInfo(voAssign.getMaterialId(), voAssign.getPurOrgUnitId());
        voAssign.setQuotaPolicyname(materialPurchasingInfo.getQuotaPolicy().getName());
        BigDecimal splitQty = voAssign.getEntryQty();
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), voAssign.getUnitId());
        voAssign.setUnit(materialPurchasingInfo.getUnit());
        MultiMeasureUnitInfo purUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), materialPurchasingInfo.getUnit().getId().toString());
        splitQty = QuotaUtil.getQtyByUnit(splitQty, billUnit, purUnit);
        voAssign.setUnitId(purUnit.getMeasureUnit().getId().toString());
        voAssign.setSplitQty(splitQty);
        voAssign.setSplitBaseQty(voAssign.getUnAssBaseOrderQty());
        voAssign.setEnableSupplyList(materialPurchasingInfo.isUseSupplyList());
    }

    protected void getRelatedData(QuotaVO voAssign, ApprovedSupplierInfo supplierQuota) {
        MaterialPurchasingInfo materialPurchasingInfo = this.quotaCtx.getMaterialPurInfo(voAssign.getMaterialId(), voAssign.getPurOrgUnitId());
        voAssign.setSupplier(supplierQuota.getSupplier());
        voAssign.setPriority(supplierQuota.getSupplyPriority());
        voAssign.setQuotaPolicyname(materialPurchasingInfo.getQuotaPolicy().getName());
        voAssign.setRatio(supplierQuota.getQuotaRate());
        voAssign.setSplitRatio(this.getSplitRatio(voAssign, supplierQuota));
        voAssign.setSplitBaseQty(this.getSplitBaseQty(voAssign));
        BigDecimal splitQty = voAssign.getSplitQty();
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), voAssign.getUnitId());
        if (supplierQuota.getPurMeasureUnit() != null) {
            voAssign.setUnit(supplierQuota.getPurMeasureUnit());
            MultiMeasureUnitInfo quotaUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), supplierQuota.getPurMeasureUnit().getId().toString());
            splitQty = QuotaUtil.getQtyByUnit(voAssign.getSplitQty(), billUnit, quotaUnit);
        } else {
            voAssign.setUnit(materialPurchasingInfo.getUnit());
            MultiMeasureUnitInfo purUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), materialPurchasingInfo.getUnit().getId().toString());
            splitQty = QuotaUtil.getQtyByUnit(voAssign.getSplitQty(), billUnit, purUnit);
        }
        voAssign.setSplitQty(splitQty);
        voAssign.setSupplyScope(this.getSupplyScopeOrgCollection(supplierQuota.getSupplyScope()));
        voAssign.setEnableSupplyList(materialPurchasingInfo.isUseSupplyList());
    }

    private String getSupplyScopeOrgCollection(String ids) {
        String supplyScope = null;
        if (!StringUtils.isEmpty((String)ids)) {
            String[] idArr = ids.split(";");
            int len = idArr.length;
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = evi.getSelector();
            sic.add("number");
            sic.add("name");
            FilterInfo fi = new FilterInfo();
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < len; ++i) {
                idSet.add(idArr[i]);
            }
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            StorageOrgUnitCollection col = null;
            try {
                col = StorageOrgUnitFactory.getLocalInstance((Context)this.quotaCtx.getCtx()).getStorageOrgUnitCollection(evi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            StringBuffer sb = new StringBuffer();
            if (col != null && col.size() > 0) {
                int size = col.size() > 5 ? 5 : col.size();
                for (int i = 0; i < size; ++i) {
                    sb.append(col.get(i).get("name")).append(";");
                }
            }
            if (sb.length() > 0) {
                supplyScope = sb.delete(sb.length() - 1, sb.length()).toString();
            }
        }
        return supplyScope;
    }

    private BigDecimal getSplitBaseQty(QuotaVO voAssign) {
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), voAssign.getUnitId());
        MultiMeasureUnitInfo baseUnit = this.quotaCtx.getMultiUnit(voAssign.getMaterialId(), voAssign.getBaseUnitid());
        BigDecimal splitBaseQty = QuotaUtil.getQtyByUnit(voAssign.getSplitQty(), billUnit, baseUnit);
        return splitBaseQty;
    }

    protected BigDecimal getSplitRatio(QuotaVO voAssign, ApprovedSupplierInfo supplierQuota) {
        BigDecimal splitRatio = ZERO;
        BigDecimal splitQty = voAssign.getSplitQty();
        BigDecimal totalQty = voAssign.getEntryQty();
        if (splitQty != null && totalQty != null && totalQty.compareTo(ZERO) > 0) {
            splitRatio = splitQty.divide(totalQty, 4, 4);
        }
        return splitRatio;
    }

    protected void resetQuotaVO(QuotaVO quotaVO, QuotaVO voAssign) {
        quotaVO.setRemainEntryQty(quotaVO.getRemainEntryQty().subtract(voAssign.getSplitQty()));
    }

    protected BigDecimal getMinDivQty(QuotaVO quotaVO) {
        MaterialPurchasingInfo purInfo = this.quotaCtx.getMaterialPurInfo(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), quotaVO.getUnitId());
        MultiMeasureUnitInfo purUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), purInfo.getUnit().getId().toString());
        BigDecimal minDivQty = QuotaUtil.getQtyByUnit(purInfo.getMinDivisionQty(), purUnit, billUnit);
        return minDivQty;
    }

    public List<ApprovedSupplierInfo> getSupplierQuotas(QuotaVO quotaVO) throws BOSException {
        return this.quotaCtx.getSupplierQuotas(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
    }

    protected QuotaVO assign4NoSupplier(QuotaVO quotaVO) {
        return (QuotaVO)quotaVO.clone();
    }

    protected void sortSupplierQuotas(List<ApprovedSupplierInfo> supplierQuotas) {
    }

    public abstract QuotaVO assign4Supplier(QuotaVO var1, ApprovedSupplierInfo var2, List<ApprovedSupplierInfo> var3) throws BOSException, EASBizException;
}

