/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import com.kingdee.eas.scm.sm.pur.app.quota.SupplierQuotaComparator;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;

public class FixedRatioPolicy
extends AbstractQuotaPolicy {
    public FixedRatioPolicy(QuotaContext quotaContext) {
        super(quotaContext);
    }

    @Override
    public QuotaVO assign4Supplier(QuotaVO quotaVO, ApprovedSupplierInfo supplierQuota, List<ApprovedSupplierInfo> supplierQuotas) throws BOSException {
        QuotaVO voAssign = (QuotaVO)quotaVO.clone();
        int scale = QuotaUtil.getScale(this.quotaCtx, quotaVO.getMaterialId(), quotaVO.getUnitId());
        int ratioScale = 6;
        BigDecimal totalRatio = this.getTotalRatio(supplierQuotas);
        BigDecimal splitQty = ZERO;
        BigDecimal minDivQty = this.getMinDivQty(quotaVO);
        if (quotaVO.getEntryQty().compareTo(minDivQty) <= 0) {
            splitQty = quotaVO.getEntryQty();
        } else if (totalRatio.compareTo(ZERO) != 0 && supplierQuota.getQuotaRate().compareTo(ZERO) != 0) {
            BigDecimal ratio = supplierQuota.getQuotaRate().divide(totalRatio, ratioScale, 4);
            splitQty = quotaVO.getEntryQty().multiply(ratio).setScale(scale, 4);
            int index = supplierQuotas.indexOf(supplierQuota);
            if (index == supplierQuotas.size() - 1) {
                splitQty = quotaVO.getRemainEntryQty();
            }
        }
        voAssign.setSplitQty(splitQty);
        return voAssign;
    }

    @Override
    public void sortSupplierQuotas(List<ApprovedSupplierInfo> supplierQuotas) {
        Collections.sort(supplierQuotas, SupplierQuotaComparator.SUPPLIER_QUOTA_RATIO_EDSC);
    }

    @Override
    public List<ApprovedSupplierInfo> getSupplierQuotas(QuotaVO quotaVO) throws BOSException {
        List<ApprovedSupplierInfo> approvedSupplierList = this.quotaCtx.getSupplierQuotas(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
        return approvedSupplierList;
    }

    private BigDecimal getTotalRatio(List<ApprovedSupplierInfo> supplierQuotas) {
        BigDecimal totalRatio = ZERO;
        for (int i = 0; i < supplierQuotas.size(); ++i) {
            BigDecimal quotaRate = supplierQuotas.get(i).getQuotaRate() == null ? ZERO : supplierQuotas.get(i).getQuotaRate();
            totalRatio = totalRatio.add(quotaRate);
        }
        return totalRatio;
    }
}

