/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.sm.pur.PurContractEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurContractInfo;
import com.kingdee.eas.scm.sm.pur.calculate.AbstractCal;
import java.math.BigDecimal;

public class PurContractCal
extends AbstractCal {
    public PurContractCal() {
        this.initFiledValue();
    }

    @Override
    protected void initFiledValue() {
        this.setACTUALPRICE("actualPrice");
        this.setACTUALTAXPRICE("actualTaxPrice");
        this.setAMOUNT("amount");
        this.setCONTAINTAX("isInTax");
        this.setDISCOUNT("discount");
        this.setDISCOUNTAMOUNT("discountAmount");
        this.setISPRICE_EXCLUDE_TAX("isPriceInTax");
        this.setPRICE("price");
        this.setQTY("qty");
        this.setTAX("tax");
        this.setTAXAMOUNT("taxAmount");
        this.setTAXPRICE("taxPrice");
        this.setTAXRATE("taxRate");
    }

    @Override
    protected AbstractObjectCollection getEntry(SCMBillBaseInfo info) {
        return (AbstractObjectCollection)info.get("entries");
    }

    @Override
    protected boolean getHeadBooleanValue(SCMBillBaseInfo info, String fieldName) {
        if ("isPriceInTax".equals(fieldName)) {
            return true;
        }
        return super.getHeadBooleanValue(info, fieldName);
    }

    @Override
    public void calByEntryTaxPriceChange(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.calEntryPrice(info, entryInfo);
        this.calEntryTaxAmount(info, entryInfo);
        this.calEntryTax(info, entryInfo);
        this.calEntryAmount(info, entryInfo);
        this.calEntryActualPrice(info, entryInfo);
        this.calEntryActualTaxPrice(info, entryInfo);
        this.calEntryDiscountAmount(info, entryInfo);
    }

    @Override
    public void calByEntryPriceChange(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        this.calEntryTaxPrice(info, entryInfo);
        this.calEntryDiscountAmount(info, entryInfo);
        this.calEntryAmount(info, entryInfo);
        this.calEntryActualPrice(info, entryInfo);
        this.calEntryTax(info, entryInfo);
        this.calEntryTaxAmount(info, entryInfo);
        this.calEntryActualTaxPrice(info, entryInfo);
    }

    public void calPrepayment(PurContractInfo info) {
        BigDecimal totalTaxAmount = SysConstant.BIGZERO;
        BigDecimal prepaymentRate = info.getPrepayRate() != null ? info.getPrepayRate() : SysConstant.BIGZERO;
        int precision = 8;
        if (info.getCurrency() != null) {
            precision = info.getCurrency().getPrecision();
        }
        prepaymentRate = prepaymentRate.divide(new BigDecimal("100.00"), prepaymentRate.scale() + 2, 4);
        for (int i = 0; i < info.getEntries().size(); ++i) {
            PurContractEntryInfo entryInfo = info.getEntries().get(i);
            BigDecimal entryTaxAmount = entryInfo.getTaxAmount() != null ? entryInfo.getTaxAmount() : SysConstant.BIGZERO;
            totalTaxAmount = totalTaxAmount.add(entryTaxAmount);
        }
        BigDecimal prepayment = prepaymentRate.multiply(totalTaxAmount).setScale(precision, 4);
        info.setPrepayAmount(prepayment);
    }
}

