/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.calculate;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sm.sc.MaterialPurchaseTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.calculate.AbstractCal;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class PurRequestCal
extends AbstractCal {
    public PurRequestCal() {
        this.initFiledValue();
    }

    @Override
    protected void initFiledValue() {
        this.setACTUALPRICE("actualPrice");
        this.setACTUALTAXPRICE("actualTaxPrice");
        this.setAMOUNT("amount");
        this.setCONTAINTAX("isInTax");
        this.setDISCOUNT("discountRate");
        this.setDISCOUNTAMOUNT("discountAmount");
        this.setHEAD_AMOUNT("totalAmount");
        this.setHEAD_LOCALAMOUNT("localTotalAmount");
        this.setHEAD_TAX("totalTax");
        this.setHEAD_TAXAMOUNT("totalTaxAmount");
        this.setHEAD_LOCALTAXAMOUNT("localTotalTaxAmount");
        this.setISPRICE_EXCLUDE_TAX("isPriceInTax");
        this.setPRICE("price");
        this.setQTY("qty");
        this.setTAX("tax");
        this.setTAXAMOUNT("taxAmount");
        this.setTAXPRICE("taxPrice");
        this.setTAXRATE("taxRate");
        this.setLOCALAMOUNT("localAmount");
        this.setLOCALTAXAMOUNT("localTaxAmount");
    }

    @Override
    protected AbstractObjectCollection getEntry(SCMBillBaseInfo info) {
        AbstractObjectCollection col = null;
        try {
            if (info.getClass().newInstance() instanceof PurRequestInfo) {
                col = (AbstractObjectCollection)info.get("entries");
            }
        }
        catch (InstantiationException e) {
            Logger.error((Throwable)e);
        }
        catch (IllegalAccessException e) {
            Logger.error((Throwable)e);
        }
        return col;
    }

    @Override
    public void calEntryPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        boolean containTax = this.isInTax();
        if (!containTax) {
            return;
        }
        BigDecimal taxPrice = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE).scale();
        BigDecimal price = null;
        boolean is_price_exclude_tax = this.getHeadBooleanValue(info, this.ISPRICE_EXCLUDE_TAX);
        price = is_price_exclude_tax ? CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale) : CalculateUtils.calPriceIsPriceInTax((BigDecimal)taxRate, (BigDecimal)taxPrice, (int)scale);
        entryInfo.put(this.PRICE, (Object)price);
    }

    @Override
    public void calEntryTaxPrice(SCMBillBaseInfo info, SCMBillEntryBaseInfo entryInfo) {
        BigDecimal price = this.getEntryBigDecimalValue(entryInfo, this.PRICE);
        BigDecimal taxRate = this.getEntryBigDecimalValue(entryInfo, this.TAXRATE);
        int scale = this.getEntryBigDecimalValue(entryInfo, this.TAXPRICE).scale();
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
        entryInfo.put(this.TAXPRICE, (Object)taxPrice);
    }

    public static void calcAmount(Context ctx, PurRequestInfo info) {
        PurRequestEntryInfo entryInfo = null;
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTax = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        int size = info.getEntries().size();
        for (int j = 0; j < size; ++j) {
            entryInfo = info.getEntries().get(j);
            BigDecimal amount = entryInfo.getAmount() != null ? entryInfo.getAmount() : BigDecimal.ZERO;
            BigDecimal tax = entryInfo.getTax() != null ? entryInfo.getTax() : BigDecimal.ZERO;
            BigDecimal taxAmount = entryInfo.getTaxAmount() != null ? entryInfo.getTaxAmount() : BigDecimal.ZERO;
            totalAmount = totalAmount.add(amount);
            entryInfo.setLocalAmount(amount);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            entryInfo.setLocalAmount(amount);
            entryInfo.setLocalTax(tax);
            entryInfo.setLocalTaxAmount(taxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }

    public static PurPriceParam getPriceParam(int seq, PurRequestInfo info, PurRequestEntryInfo entryInfo) {
        PurPriceParam param = new PurPriceParam();
        if (info.getBillType() != null) {
            param.setBillTypeId(info.getBillType().getId().toString());
        } else {
            param.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        }
        param.setSeq(seq);
        param.setPurOrgUnitId(entryInfo.getPurchaseOrgUnit() != null ? entryInfo.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(entryInfo.getSupplier() != null ? entryInfo.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)info.getPurchaseType())) {
            param.setMaterialPurchaseType(1);
        } else {
            param.setMaterialPurchaseType(0);
        }
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(entryInfo.getCurrency() != null ? entryInfo.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        param.setDeliveryDate(entryInfo.getProposeDeliveryDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setBizTypeId(info.getBizType() != null ? info.getBizType().getId().toString() : null);
        param.setRecOrgUnitId(entryInfo.getReceivedOrgUnit() != null ? entryInfo.getReceivedOrgUnit().getId().toString() : null);
        return param;
    }

    public static void reCalcAmount(Context ctx, PurRequestInfo info) throws BOSException, EASBizException {
        BigDecimal ZERO = SysConstant.BIGZERO;
        BigDecimal HUNDRED = SCMConstant.BIGDECIMAL_ONEHUNDRED;
        CurrencyInfo currencyInfo = null;
        boolean isContainsTax = info.isIsInTax();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurRequestEntryCollection collection = info.getEntries();
        PurRequestEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            int scale = 2;
            if (entryInfo.getCurrency() != null) {
                currencyInfo = entryInfo.getCurrency();
                if (currencyMap.containsKey(currencyInfo.getId().toString())) {
                    scale = ((CurrencyInfo)currencyMap.get(currencyInfo.getId().toString())).getPrecision();
                } else {
                    currencyInfo = ctx == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId().toString())) : CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyInfo.getId().toString()));
                    scale = currencyInfo.getPrecision();
                    currencyMap.put(currencyInfo.getId().toString(), currencyInfo);
                }
            }
            materialInfo = entryInfo.getMaterial();
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty());
            BigDecimal price = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPrice());
            BigDecimal taxRate = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxRate());
            BigDecimal taxPrice = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxPrice());
            int priceScale = 6;
            priceScale = materialInfo == null ? entryInfo.getRowType().getPrecision() : materialInfo.getPricePrecision();
            DiscountModeEnum discountMode = DiscountModeEnum.PERCENT;
            BigDecimal discount = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getDiscountRate());
            BigDecimal actualPrice = ZERO;
            BigDecimal amount = ZERO;
            BigDecimal tax = ZERO;
            BigDecimal taxAmount = ZERO;
            BigDecimal discountAmount = ZERO;
            if (isContainsTax) {
                BigDecimal actualTaxPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)taxPrice, (BigDecimal)discount, (int)10);
                taxAmount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualTaxPrice2, (int)scale);
                tax = taxAmount.multiply(taxRate).divide(HUNDRED.add(taxRate), scale, 4);
                amount = taxAmount.subtract(tax);
                discountAmount = CalculateUtils.calDiscountAmountByTaxAmount((BigDecimal)taxPrice, (BigDecimal)qty, (BigDecimal)taxAmount, (int)scale);
                if (qty.compareTo(ZERO) != 0) {
                    actualPrice = amount.divide(qty, priceScale, 4);
                }
            } else {
                taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)scale);
                BigDecimal actualPrice2 = CalculateUtils.calActualTaxPrice((DiscountModeEnum)discountMode, (BigDecimal)price, (BigDecimal)discount, (int)10);
                amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)actualPrice2, (int)scale);
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
                taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
                discountAmount = CalculateUtils.calDiscountAmount((DiscountModeEnum)discountMode, (BigDecimal)discount, (BigDecimal)qty, (BigDecimal)taxPrice, (BigDecimal)taxRate, (int)scale, (boolean)isContainsTax);
                actualPrice = actualPrice2.setScale(priceScale, 4);
            }
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            entryInfo.setAmount(amount);
            entryInfo.setTax(tax);
            entryInfo.setTaxAmount(taxAmount);
            entryInfo.setDiscountAmount(discountAmount);
            entryInfo.setActualPrice(actualPrice);
            entryInfo.setUnOrderedQty(qty);
            entryInfo.setLocalAmount(amount);
            entryInfo.setLocalTax(tax);
            entryInfo.setLocalTaxAmount(taxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }

    public void fetchPrice(Context ctx, IObjectCollection collection, PurPriceParamCollection paramCol, int orderBaseSeq) throws EASBizException, BOSException {
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        CurrencyInfo currencyInfo = null;
        Map currencyMap = this.getCurrencyCache(ctx, collection);
        if (paramCol.size() > 0) {
            for (int i = 0; i < collection.size(); ++i) {
                info = (PurRequestInfo)collection.getObject(i);
                info.setIsPriceInTax(true);
                for (int j = 0; j < info.getEntries().size(); ++j) {
                    entryInfo = info.getEntries().get(j);
                    int seq = orderBaseSeq * (i + 1) + j;
                    PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
                    if (priceInfo != null) {
                        if (entryInfo.getSupplier() == null) {
                            entryInfo.setSupplier(priceInfo.getSupplier());
                        }
                        if (entryInfo.getTaxRate() == null || BigDecimal.ZERO.compareTo(entryInfo.getTaxRate()) == 0) {
                            if (priceInfo.getTaxRate() != null) {
                                entryInfo.setTaxRate(priceInfo.getTaxRate());
                            } else {
                                entryInfo.setTaxRate(BigDecimal.ZERO);
                            }
                        }
                    }
                    PurRequestCal purRequestCal = new PurRequestCal();
                    if (priceInfo != null) {
                        purRequestCal.setInTax(priceInfo.isInTaxPrice());
                    }
                    if (priceInfo != null && priceInfo.getPrice() != null) {
                        if (priceInfo.getDiscountRate() != null) {
                            entryInfo.setDiscountRate(priceInfo.getDiscountRate());
                        }
                        currencyInfo = entryInfo.getCurrency();
                        purRequestCal.setAmoutscale(currencyInfo.getPrecision());
                        if (entryInfo.getCurrency() != null) {
                            currencyInfo = (CurrencyInfo)currencyMap.get(entryInfo.getCurrency().getId().toString());
                            purRequestCal.setAmoutscale(currencyInfo.getPrecision());
                            entryInfo.setAmount(BigDecimal.ZERO.setScale(currencyInfo.getPrecision()));
                        }
                        if (priceInfo.isInTaxPrice()) {
                            entryInfo.setTaxPrice(priceInfo.getPrice());
                        } else {
                            entryInfo.setPrice(priceInfo.getPrice());
                        }
                    }
                    if (priceInfo == null) continue;
                    if (priceInfo.isInTaxPrice()) {
                        purRequestCal.calByEntryTaxPriceChange(info, entryInfo);
                        continue;
                    }
                    purRequestCal.calByEntryPriceChange(info, entryInfo);
                }
            }
        }
        this.calcAmount(ctx, collection);
    }

    public void fetchPrice(Context ctx, PurRequestInfo requestBillInfo) throws EASBizException, BOSException {
        PurPriceParamCollection paramCol = this.getPriceParamCol(ctx, requestBillInfo);
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
        PurRequestEntryInfo entryInfo = null;
        PurPriceInfo priceInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            if (entryInfo.getMaterial() == null) continue;
            priceInfo = cols.getPurPriceInfoBySeq(entryInfo.getSeq());
            if (priceInfo == null || entryInfo.getSupplier() == null) {
                // empty if block
            }
            if (priceInfo == null || priceInfo.getPrice() == null) continue;
            PurRequestCal purRequestCal = new PurRequestCal();
            purRequestCal.setInTax(priceInfo.isInTaxPrice());
            if (entryInfo.getTaxRate() == null || BigDecimal.ZERO.compareTo(entryInfo.getTaxRate()) == 0) {
                entryInfo.setTaxRate(priceInfo.getTaxRate());
            }
            if (priceInfo.getDiscountRate() != null) {
                entryInfo.setDiscountRate(priceInfo.getDiscountRate());
            }
            if (priceInfo.isInTaxPrice()) {
                entryInfo.setTaxPrice(priceInfo.getPrice());
                purRequestCal.calByEntryTaxPriceChange(requestBillInfo, entryInfo);
                continue;
            }
            entryInfo.setPrice(priceInfo.getPrice());
            purRequestCal.calByEntryPriceChange(requestBillInfo, entryInfo);
        }
        PurRequestCal.calcAmount(ctx, requestBillInfo);
    }

    private PurPriceParamCollection getPriceParamCol(Context ctx, PurRequestInfo requestBillInfo) {
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        paramCol.setPurchaseType(MaterialPurchaseTypeEnum.PURCHASE);
        paramCol.setBizTypeId(requestBillInfo.getBizType().getId().toString());
        PurPriceParam param = null;
        PurRequestEntryInfo entryInfo = null;
        int size = requestBillInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = requestBillInfo.getEntries().get(i);
            param = PurRequestCal.getPriceParam(entryInfo.getSeq(), requestBillInfo, entryInfo);
            paramCol.addPurPriceParam(param);
        }
        paramCol.addPurPriceParam(param);
        return paramCol;
    }

    private Map getCurrencyCache(Context ctx, IObjectCollection collection) throws BOSException {
        HashSet<String> currencyIdSet = new HashSet<String>();
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        CurrencyInfo currencyInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurRequestInfo)collection.getObject(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = info.getEntries().get(j);
                currencyInfo = entryInfo.getCurrency();
                if (currencyInfo == null) continue;
                currencyIdSet.add(currencyInfo.getId().toString());
            }
        }
        HashMap<String, CurrencyInfo> currencyMap = new HashMap<String, CurrencyInfo>();
        if (currencyIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", currencyIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("precision"));
            view.setSelector(selector);
            CurrencyCollection materials = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(view);
            for (int k = 0; k < materials.size(); ++k) {
                currencyMap.put(materials.get(k).getId().toString(), materials.get(k));
            }
        }
        return currencyMap;
    }

    private void calcAmount(Context ctx, IObjectCollection collection) {
        for (int i = 0; i < collection.size(); ++i) {
            PurRequestCal.calcAmount(ctx, (PurRequestInfo)collection.getObject(i));
        }
    }
}

