/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.workflow.ProcessInstInfo;
import com.kingdee.bos.workflow.metas.AssignCollection;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.multiapprove.MultiApproveCollection;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.NantionalServiceFacadeFactory;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeFactory;
import com.kingdee.eas.basedata.scm.sm.pur.DemandTypeInfo;
import com.kingdee.eas.basedata.scm.sm.pur.IDemandType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.util.ResourceUtils;
import com.kingdee.eas.scm.sm.pur.PurInvPaymentPlanCollection;
import com.kingdee.eas.scm.sm.pur.PurInvPaymentPlanInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurInvoiceEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurInvoiceInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationInfo;
import com.kingdee.eas.scm.sm.pur.PurQuotationPlanInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;

public abstract class PurUtil {
    public static final int WHFILTER_ISSTARTED = 1;
    public static final int WHFILTER_NOSTARTED = 0;
    public static final int WHFILTER_ALL = -1;
    public static BigDecimal MAXVAL = new BigDecimal("999999999999.0");
    private static final String REGEX_L = "\\{";
    private static final String REGEX_R = "\\}";

    public static String getUIResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key);
    }

    public static String getServerResource(String key, Context ctx) {
        return ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key, (Locale)ctx.getLocale());
    }

    public static String getServerResource(String resClassName, String resName, Context ctx) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
    }

    public static String getServerResource(String resClassName, String resName, String[] parameters, Context ctx) {
        String message = ResourceBase.getString((String)resClassName, (String)resName, (Locale)ctx.getLocale());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < parameters.length; ++i) {
            sb.setLength(0);
            message = message.replaceAll(sb.append(REGEX_L).append(i).append(REGEX_R).toString(), parameters[i]);
        }
        return message;
    }

    public static String getUIResourceParam(String resClassName, String resName, String[] params) {
        return ResourceUtils.getMessage((String)resClassName, (String)resName, (String[])params);
    }

    public static String getPurQuotationResource(String key) {
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurQuotationResource", (String)key);
    }

    public static String getBizResource(String key, Context ctx) {
        if (ctx != null) {
            return ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)key, (Locale)ctx.getOriginLocale());
        }
        return EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)key);
    }

    public static Date getBeginDate(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        return calendar.getTime();
    }

    public static PurInvoiceInfo getNagtiveAmountInfo(PurInvoiceInfo purInvInfo) {
        purInvInfo.setTotalAmount(PurUtil.getNagtiveValue(purInvInfo.getTotalAmount()));
        purInvInfo.setLocalTotalAmount(PurUtil.getNagtiveValue(purInvInfo.getLocalTotalAmount()));
        purInvInfo.setTotalTax(PurUtil.getNagtiveValue(purInvInfo.getTotalTax()));
        purInvInfo.setTotalTaxAmount(PurUtil.getNagtiveValue(purInvInfo.getTotalTaxAmount()));
        purInvInfo.setLocalTotalTaxAmount(PurUtil.getNagtiveValue(purInvInfo.getLocalTotalTaxAmount()));
        PurInvoiceEntryCollection collection = purInvInfo.getEntries();
        PurInvoiceEntryCollection srccollection = purInvInfo.getEntries();
        PurInvoiceEntryInfo entryInfo = null;
        if (collection != null) {
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setQty(PurUtil.getNagtiveValue(entryInfo.getQty()));
                entryInfo.setBaseQty(PurUtil.getNagtiveValue(entryInfo.getBaseQty()));
                entryInfo.setAssistQty(PurUtil.getNagtiveValue(entryInfo.getAssistQty()));
                entryInfo.setWrittenOffQty(PurUtil.getNagtiveValue(entryInfo.getWrittenOffQty()));
                entryInfo.setWittenOffBaseQty(PurUtil.getNagtiveValue(entryInfo.getWittenOffBaseQty()));
                entryInfo.setUnwriteOffQty(PurUtil.getNagtiveValue(entryInfo.getUnwriteOffQty()));
                entryInfo.setUnwriteOffBaseQty(PurUtil.getNagtiveValue(entryInfo.getUnwriteOffBaseQty()));
                entryInfo.setAmount(PurUtil.getNagtiveValue(entryInfo.getAmount()));
                entryInfo.setLocalAmount(PurUtil.getNagtiveValue(entryInfo.getLocalAmount()));
                entryInfo.setTax(PurUtil.getNagtiveValue(entryInfo.getTax()));
                entryInfo.setLocalTax(PurUtil.getNagtiveValue(entryInfo.getLocalTax()));
                entryInfo.setTaxAmount(PurUtil.getNagtiveValue(entryInfo.getTaxAmount()));
                entryInfo.setLocalTaxAmount(PurUtil.getNagtiveValue(entryInfo.getLocalTaxAmount()));
                entryInfo.setWrittenOffAmount(PurUtil.getNagtiveValue(entryInfo.getWrittenOffAmount()));
                entryInfo.setLocalUnwriteOffAmount(PurUtil.getNagtiveValue(entryInfo.getLocalUnwriteOffAmount()));
                entryInfo.setUnWriteOffAmount(PurUtil.getNagtiveValue(entryInfo.getUnWriteOffAmount()));
                entryInfo.setLocalUnwriteOffAmount(PurUtil.getNagtiveValue(entryInfo.getLocalUnwriteOffAmount()));
                entryInfo.setCurrWrittenOffAmount(PurUtil.getNagtiveValue(entryInfo.getCurrWrittenOffAmount()));
                entryInfo.setLocalCurrWrittenOffAmount(PurUtil.getNagtiveValue(entryInfo.getLocalCurrWrittenOffAmount()));
                entryInfo.setCurrWrittenOffQty(PurUtil.getNagtiveValue(entryInfo.getCurrWrittenOffQty()));
            }
        }
        PurInvPaymentPlanCollection payPlanCollection = purInvInfo.getPaymentPlans();
        PurInvPaymentPlanInfo payPlanInfo = null;
        if (payPlanCollection != null) {
            int num = payPlanCollection.size();
            for (int j = 0; j < num; ++j) {
                payPlanInfo = payPlanCollection.get(j);
                payPlanInfo.setPaymentAmount(PurUtil.getNagtiveValue(payPlanInfo.getPaymentAmount()));
                payPlanInfo.setLocalPaymentAmount(PurUtil.getNagtiveValue(payPlanInfo.getLocalPaymentAmount()));
            }
        }
        return purInvInfo;
    }

    public static PurInvoiceInfo getReverseAmountInfo(PurInvoiceInfo purInvInfo) {
        purInvInfo.setTotalAmount(purInvInfo.getTotalAmount().negate());
        purInvInfo.setLocalTotalAmount(purInvInfo.getLocalTotalAmount().negate());
        purInvInfo.setTotalTax(purInvInfo.getTotalTax().negate());
        purInvInfo.setTotalTaxAmount(purInvInfo.getTotalTaxAmount().negate());
        purInvInfo.setLocalTotalTaxAmount(purInvInfo.getLocalTotalTaxAmount().negate());
        PurInvoiceEntryCollection collection = purInvInfo.getEntries();
        PurInvoiceEntryCollection srccollection = purInvInfo.getEntries();
        PurInvoiceEntryInfo entryInfo = null;
        if (collection != null) {
            int num = collection.size();
            for (int j = 0; j < num; ++j) {
                entryInfo = collection.get(j);
                entryInfo.setQty(entryInfo.getQty().negate());
                entryInfo.setBaseQty(entryInfo.getBaseQty().negate());
                entryInfo.setAssistQty(entryInfo.getAssistQty().negate());
                entryInfo.setWrittenOffQty(entryInfo.getWrittenOffQty().negate());
                entryInfo.setUnwriteOffQty(entryInfo.getUnwriteOffQty().negate());
                entryInfo.setAmount(entryInfo.getAmount().negate());
                entryInfo.setLocalAmount(entryInfo.getLocalAmount().negate());
                entryInfo.setTax(entryInfo.getTax().negate());
                entryInfo.setLocalTax(entryInfo.getLocalTax().negate());
                entryInfo.setTaxAmount(entryInfo.getTaxAmount().negate());
                entryInfo.setLocalTaxAmount(entryInfo.getLocalTaxAmount().negate());
                entryInfo.setWrittenOffAmount(entryInfo.getWrittenOffAmount().negate());
                entryInfo.setLocalUnwriteOffAmount(entryInfo.getLocalUnwriteOffAmount().negate());
                entryInfo.setUnWriteOffAmount(entryInfo.getUnWriteOffAmount().negate());
                entryInfo.setLocalUnwriteOffAmount(entryInfo.getLocalUnwriteOffAmount().negate());
            }
        }
        PurInvPaymentPlanCollection payPlanCollection = purInvInfo.getPaymentPlans();
        PurInvPaymentPlanInfo payPlanInfo = null;
        if (payPlanCollection != null) {
            int num = payPlanCollection.size();
            for (int j = 0; j < num; ++j) {
                payPlanInfo = payPlanCollection.get(j);
                payPlanInfo.setPaymentAmount(payPlanInfo.getPaymentAmount().negate());
                payPlanInfo.setLocalPaymentAmount(payPlanInfo.getLocalPaymentAmount().negate());
            }
        }
        return purInvInfo;
    }

    public static boolean isInvoiceCheckOffed(PurInvoiceInfo purInvoiceInfo) {
        boolean isCheckoffed = false;
        BigDecimal zero = new BigDecimal("0.00");
        if (purInvoiceInfo != null) {
            PurInvoiceEntryCollection collection = purInvoiceInfo.getEntries();
            PurInvoiceEntryInfo entryInfo = null;
            int num = collection.size();
            for (int i = 0; i < num; ++i) {
                entryInfo = collection.get(i);
                if (entryInfo.getWrittenOffAmount().compareTo(zero) <= 0) continue;
                isCheckoffed = true;
                break;
            }
        }
        return isCheckoffed;
    }

    public static void refreshEnumList(KDComboBox list, Iterator itor) {
        list.removeAllItems();
        if (itor != null) {
            while (itor.hasNext()) {
                list.addItem(itor.next());
            }
        }
    }

    public static BigDecimal getNagtiveValue(BigDecimal value) {
        if (value == null) {
            return null;
        }
        if (value.compareTo(new BigDecimal("0.00")) <= 0) {
            return value;
        }
        BigDecimal nagtiveValue = new BigDecimal("0.00");
        nagtiveValue = nagtiveValue.subtract(value);
        return nagtiveValue;
    }

    public static void setStandardPrice(MaterialInfo materialInfo, PurchaseOrgUnitInfo po, CompanyOrgUnitInfo mo, ICell priceCell) {
        if (materialInfo == null || priceCell == null) {
            return;
        }
        MaterialPurchasingInfo materialPurchaseInfo = null;
        IMaterial ima = null;
        try {
            ima = MaterialFactory.getRemoteInstance();
            materialPurchaseInfo = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(materialInfo.getId().toString(), po.getId().toString());
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (materialPurchaseInfo != null && materialPurchaseInfo.getPrice() != null) {
            priceCell.setValue((Object)materialPurchaseInfo.getPrice());
        } else if (mo != null) {
            MaterialCompanyInfoInfo materialCompanyInfo = null;
            try {
                materialCompanyInfo = ima.getCompanyInfo(materialInfo.getId().toString(), mo.getId().toString());
            }
            catch (BOSException e) {
                Logger.error((Throwable)e);
            }
            if (materialCompanyInfo != null && materialCompanyInfo.getStandardCost() != null) {
                priceCell.setValue((Object)materialCompanyInfo.getStandardCost());
            }
        }
    }

    public static void setPurPrice(MaterialInfo materialInfo, PurchaseOrgUnitInfo po, CompanyOrgUnitInfo mo, ICell priceCell) {
        if (materialInfo == null || priceCell == null) {
            return;
        }
        MaterialPurchasingInfo materialPurchaseInfo = null;
        IMaterial ima = null;
        try {
            ima = MaterialFactory.getRemoteInstance();
            materialPurchaseInfo = MaterialPurchasingFactory.getRemoteInstance().getPurchasingInfo(materialInfo.getId().toString(), po.getId().toString());
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (materialPurchaseInfo != null && materialPurchaseInfo.getPrice() != null) {
            priceCell.setValue((Object)materialPurchaseInfo.getPrice());
        }
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou) {
        EntityViewInfo viewInfo = null;
        try {
            viewInfo = PurUtil.getWarehouseFilter(sou, -1);
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        return viewInfo;
    }

    public static EntityViewInfo getWarehouseFilter(StorageOrgUnitInfo sou, int isStarted) throws EASBizException, BOSException {
        if (sou != null) {
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("STORAGEORGUNIT.ID", (Object)sou.getId().toString(), CompareType.EQUALS));
            if (isStarted != -1) {
                filterInfo.getFilterItems().add(new FilterItemInfo("SOWH.ISSTARTED", (Object)new Integer(isStarted), CompareType.EQUALS));
            }
            viewInfo.setFilter(filterInfo);
            return viewInfo;
        }
        return null;
    }

    public static void setWarehouseFitler(StorageOrgUnitInfo sou, KDTable kdtEntry, String fieldName, int isStarted) {
        try {
            if (sou != null) {
                KDBizPromptBox kDBizPromptBoxWarehouse = new KDBizPromptBox();
                kDBizPromptBoxWarehouse.setEditable(true);
                kDBizPromptBoxWarehouse.setQueryInfo("com.kingdee.eas.basedata.scm.im.inv.app.F7WarehouseQuery");
                kDBizPromptBoxWarehouse.setDisplayFormat("$name$");
                kDBizPromptBoxWarehouse.setEditFormat("$number$");
                kDBizPromptBoxWarehouse.setCommitFormat("$number$");
                kDBizPromptBoxWarehouse.setEntityViewInfo(PurUtil.getWarehouseFilter(sou, isStarted));
                kdtEntry.getColumn(fieldName).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)kDBizPromptBoxWarehouse));
            } else {
                kdtEntry.getColumn(fieldName).getStyleAttributes().setLocked(true);
            }
        }
        catch (EASBizException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public static IObjectPK[] converStringtoIObjectPK(String[] str) {
        IObjectPK[] pks = new IObjectPK[str.length];
        int c = str.length;
        for (int i = 0; i < c; ++i) {
            pks[i] = new ObjectStringPK(str[i]);
        }
        return pks;
    }

    public static boolean purQuoPriceSecrecyForEditHelper(SCMBillBaseInfo billInfo) throws BOSException, EASBizException {
        SCMBillBaseInfo editData;
        Date serverDate;
        if (billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
            return false;
        }
        String billID = null;
        boolean isSecrecyControl = false;
        String isSecrecyValue = null;
        boolean isSecrecyEnable = false;
        ObjectUuidPK pk = null;
        Date billSecrecyDate = serverDate = SCMClientUtils.getServerDate2();
        if (billInfo.getBillType() == null) {
            return false;
        }
        if ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(billInfo.getBillType().getId().toString())) {
            editData = (PurQuotationInfo)billInfo;
            pk = new ObjectUuidPK(editData.getPurchaseOrgUnit().getId());
            if (billInfo.getDate("secrecyDeadline") != null) {
                billSecrecyDate = billInfo.getDate("secrecyDeadline");
            }
        }
        if ("aErYRJ8ShO3gQKjACw4w8MtHWDQ=".equals(billInfo.getBillType().getId().toString())) {
            editData = (PurQuotationPlanInfo)billInfo;
            pk = new ObjectUuidPK(editData.getPurchaseOrgUnit().getId());
            if (billInfo.getDate("privacyEndDate") != null) {
                billSecrecyDate = billInfo.getDate("privacyEndDate");
            }
        }
        billID = billInfo.getId().toString();
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        isSecrecyValue = ipc.getParamValue((IObjectPK)pk, "PURQUO003");
        if (isSecrecyValue != null && isSecrecyValue.trim().length() != 0 && isSecrecyValue.trim().equalsIgnoreCase("true")) {
            isSecrecyEnable = true;
        }
        if (!isSecrecyEnable) {
            return false;
        }
        String currentPersonID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        if (billSecrecyDate != null && serverDate.after(billSecrecyDate)) {
            return false;
        }
        switch (billInfo.getBaseStatus().getValue()) {
            case 1: {
                if ("510b6503-0105-1000-e000-010bc0a814fd463ED552".equals(billInfo.getBillType().getId().toString())) {
                    if (currentPersonID.endsWith(billInfo.getCreator().getId().toString())) break;
                    isSecrecyControl = true;
                    break;
                }
                isSecrecyControl = false;
                break;
            }
            case 2: {
                boolean isProcessNotFinish = true;
                block10: while (isProcessNotFinish) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Logger.error((Throwable)e);
                    }
                    IEnactmentService enactmentService = EnactmentServiceFactory.createRemoteEnactService();
                    ProcessInstInfo[] processInstInfos = enactmentService.getProcessInstanceByHoldedObjectId(billID);
                    ProcessInstInfo aProcessInstInfo2 = null;
                    for (ProcessInstInfo aProcessInstInfo2 : processInstInfos) {
                        if ("open.running".equals(aProcessInstInfo2.getState())) {
                            isProcessNotFinish = false;
                            continue;
                        }
                        if (!"open.not_running.suspended".equals(aProcessInstInfo2.getState())) continue;
                        isProcessNotFinish = false;
                        continue block10;
                    }
                }
                boolean isNotAssign = true;
                while (isNotAssign) {
                    AssignCollection assignCollection = SCMClientUtils.getBizBillProcessForPerson((String)billID);
                    if (assignCollection == null || assignCollection.size() <= 0) continue;
                    isNotAssign = false;
                    if (SCMClientUtils.getCurrentPersonIsWFPrcessList((AssignCollection)assignCollection)) continue;
                    isSecrecyControl = true;
                }
                break;
            }
            case -2: {
                MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection)) break;
                isSecrecyControl = true;
                break;
            }
            case 4: {
                MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection) || currentPersonID.endsWith(billInfo.getCreator().getId().toString())) break;
                isSecrecyControl = true;
                break;
            }
            case 7: {
                MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection) || currentPersonID.endsWith(billInfo.getCreator().getId().toString())) break;
                isSecrecyControl = true;
                break;
            }
            case 3: {
                isSecrecyControl = false;
                break;
            }
            default: {
                isSecrecyControl = true;
            }
        }
        return isSecrecyControl;
    }

    public static void purQuoPriceSecrecyForListHelper(String billID, BillBaseStatusEnum billStatus, String billPersionID, String purchaseOrgUnitID, Date secrecyEndDate, String[] secrecyStrFields, String[] secrecyNoStrFields, IRowSet rowSet) throws BOSException, SQLException, EASBizException {
        String isSecrecyValue = null;
        boolean isSecrecyEnable = false;
        ObjectUuidPK pk = new ObjectUuidPK(purchaseOrgUnitID);
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        isSecrecyValue = ipc.getParamValue((IObjectPK)pk, "PURQUO003");
        if (isSecrecyValue != null && isSecrecyValue.trim().length() != 0 && isSecrecyValue.trim().equalsIgnoreCase("true")) {
            isSecrecyEnable = true;
        }
        if (!isSecrecyEnable) {
            return;
        }
        boolean isSecrecyControl = false;
        String currentPersonID = SysContext.getSysContext().getCurrentUserInfo().getName();
        Date serverDate = SCMClientUtils.getServerDate2();
        Date billSecrecyDate = secrecyEndDate;
        if (billSecrecyDate == null || billSecrecyDate != null && !serverDate.after(billSecrecyDate)) {
            isSecrecyControl = true;
        }
        if (isSecrecyControl) {
            isSecrecyControl = false;
            switch (billStatus.getValue()) {
                case 1: {
                    if (billPersionID.endsWith(currentPersonID)) break;
                    isSecrecyControl = true;
                    break;
                }
                case 2: {
                    AssignCollection assignCollection = SCMClientUtils.getBizBillProcessForPerson((String)billID);
                    if (SCMClientUtils.getCurrentPersonIsWFPrcessList((AssignCollection)assignCollection)) break;
                    isSecrecyControl = true;
                    break;
                }
                case -2: {
                    MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                    if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection)) break;
                    isSecrecyControl = true;
                    break;
                }
                case 4: {
                    MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                    if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection) || billPersionID.endsWith(currentPersonID)) break;
                    isSecrecyControl = true;
                    break;
                }
                case 7: {
                    MultiApproveCollection multiApproveCollection = SCMClientUtils.getBizBillHstProcessForPerson((String)billID);
                    if (SCMClientUtils.getCurrentPersonIsWFPrcessList((MultiApproveCollection)multiApproveCollection) || billPersionID.endsWith(currentPersonID)) break;
                    isSecrecyControl = true;
                    break;
                }
                default: {
                    isSecrecyControl = true;
                }
            }
        }
        if (isSecrecyControl) {
            SCMClientUtils.SecrecyColumns((String[])secrecyStrFields, (String[])secrecyNoStrFields, (IRowSet)rowSet);
        }
    }

    public static boolean isPurSyn() throws BOSException, EASBizException {
        boolean isPurParam = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strPurParam = ipc.getParamValue(null, "ESC_IS_PURCHASE_COOPERATION");
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("true")) {
            isPurParam = true;
        }
        if (strPurParam != null && strPurParam.trim().length() != 0 && strPurParam.trim().equalsIgnoreCase("false")) {
            isPurParam = false;
        }
        return isPurParam;
    }

    public static String getInStringFromList(List list) {
        if (list == null) {
            return "('null')";
        }
        StringBuffer in = new StringBuffer();
        in.append(" ('null'");
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            in.append(",'").append(iter.next().toString()).append("'");
        }
        in.append(") ");
        return in.toString();
    }

    public static boolean isSupplierPurSyn(String supplierID, String purchaseOrgUnitID) throws BOSException, EASBizException {
        boolean isPurParam = false;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        if (supplierID != null && purchaseOrgUnitID != null) {
            SupplierPurchaseInfoInfo supplierPurchasingInfo;
            filterInfo.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)purchaseOrgUnitID, CompareType.EQUALS));
            filterInfo.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierID, CompareType.EQUALS));
            viewInfo.setFilter(filterInfo);
            SupplierPurchaseInfoCollection supplierPurchasingColl = SupplierPurchaseInfoFactory.getRemoteInstance().getSupplierPurchaseInfoCollection(viewInfo);
            if (supplierPurchasingColl != null && supplierPurchasingColl.size() > 0 && (supplierPurchasingInfo = supplierPurchasingColl.get(0)) != null) {
                isPurParam = supplierPurchasingInfo.isIsPurColl();
            }
        }
        return isPurParam;
    }

    public static SelectorItemCollection getPurRequestSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("totalAmount"));
        sic.add(new SelectorItemInfo("localTotalAmount"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("isUrgent"));
        sic.add(new SelectorItemInfo("isApprovedSupplier"));
        sic.add(new SelectorItemInfo("isMergeBill"));
        sic.add(new SelectorItemInfo("purchaseType"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("companyOrgUnit.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.number"));
        sic.add(new SelectorItemInfo("companyOrgUnit.baseCurrency.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.name"));
        sic.add(new SelectorItemInfo("adminOrgUnit.number"));
        sic.add(new SelectorItemInfo("billType.id"));
        sic.add(new SelectorItemInfo("billType.number"));
        sic.add(new SelectorItemInfo("billType.name"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("bizType.id"));
        sic.add(new SelectorItemInfo("sourceBillType.id"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("modifier.number"));
        sic.add(new SelectorItemInfo("modifier.name"));
        sic.add(new SelectorItemInfo("modificationTime"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("handler.id"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("hasEffected"));
        sic.add(new SelectorItemInfo("auditor.number"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("sourceBillId"));
        sic.add(new SelectorItemInfo("sourceFunction"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.material.id"));
        sic.add(new SelectorItemInfo("entries.material.name"));
        sic.add(new SelectorItemInfo("entries.material.number"));
        sic.add(new SelectorItemInfo("entries.material.materialGroup.id"));
        sic.add(new SelectorItemInfo("entries.material.materialGroup.number"));
        sic.add(new SelectorItemInfo("entries.material.materialGroup.name"));
        sic.add(new SelectorItemInfo("entries.bizDate"));
        sic.add(new SelectorItemInfo("entries.parent.id"));
        sic.add(new SelectorItemInfo("entries.supplier.number"));
        sic.add(new SelectorItemInfo("entries.supplier.name"));
        sic.add(new SelectorItemInfo("entries.currency.number"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.exchangeRate"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.number"));
        sic.add(new SelectorItemInfo("entries.purchaseOrgUnit.name"));
        sic.add(new SelectorItemInfo("entries.materialBaseClass"));
        sic.add(new SelectorItemInfo("entries.requirementDate"));
        sic.add(new SelectorItemInfo("entries.proposeDeliveryDate"));
        sic.add(new SelectorItemInfo("entries.proposePurchaseDate"));
        sic.add(new SelectorItemInfo("entries.purpose"));
        sic.add(new SelectorItemInfo("entries.price"));
        sic.add(new SelectorItemInfo("entries.qty"));
        sic.add(new SelectorItemInfo("entries.assistQty"));
        sic.add(new SelectorItemInfo("entries.amount"));
        sic.add(new SelectorItemInfo("entries.localAmount"));
        sic.add(new SelectorItemInfo("entries.orderedQty"));
        sic.add(new SelectorItemInfo("entries.unOrderedQty"));
        sic.add(new SelectorItemInfo("entries.trackNumber"));
        sic.add(new SelectorItemInfo("entries.baseQty"));
        sic.add(new SelectorItemInfo("entries.orderedBaseQty"));
        sic.add(new SelectorItemInfo("entries.unOrderedBaseQty"));
        sic.add(new SelectorItemInfo("entries.reason"));
        sic.add(new SelectorItemInfo("entries.mergeBillNumber"));
        sic.add(new SelectorItemInfo("entries.useAdminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.rowType.id"));
        sic.add(new SelectorItemInfo("entries.receivedOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.destinationType"));
        sic.add(new SelectorItemInfo("entries.warehosue.id"));
        sic.add(new SelectorItemInfo("entries.deliveryAddress"));
        sic.add(new SelectorItemInfo("entries.storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.sourceType"));
        sic.add(new SelectorItemInfo("entries.sourceStorageOrgUnit.id"));
        sic.add(new SelectorItemInfo("entries.sourceWarehouse.id"));
        sic.add(new SelectorItemInfo("entries.materialName"));
        sic.add(new SelectorItemInfo("entries.mergeBillSeq"));
        sic.add(new SelectorItemInfo("entries.purchasePerson.id"));
        sic.add(new SelectorItemInfo("entries.isQuantityUnCtrl"));
        sic.add(new SelectorItemInfo("entries.totalReqQty"));
        sic.add(new SelectorItemInfo("entries.totalRequQty"));
        sic.add(new SelectorItemInfo("entries.unTotalReqQty"));
        sic.add(new SelectorItemInfo("entries.processRequirement"));
        sic.add(new SelectorItemInfo("entries.operationNo"));
        sic.add(new SelectorItemInfo("entries.planOrderNumber"));
        sic.add(new SelectorItemInfo("entries.saleOrderNumber"));
        sic.add(new SelectorItemInfo("entries.materialGroup1.id"));
        sic.add(new SelectorItemInfo("entries.entries1.id"));
        sic.add(new SelectorItemInfo("entries.dosingType"));
        sic.add(new SelectorItemInfo("entries.bom.id"));
        sic.add(new SelectorItemInfo("entries.quotationTimes"));
        sic.add(new SelectorItemInfo("entries.requestQty"));
        sic.add(new SelectorItemInfo("entries.noNumMaterialModel"));
        sic.add(new SelectorItemInfo("entries.purchaseGroup.id"));
        sic.add(new SelectorItemInfo("entries.project.id"));
        sic.add(new SelectorItemInfo("entries.trackNo.id"));
        sic.add(new SelectorItemInfo("entries.purContractID"));
        sic.add(new SelectorItemInfo("entries.companyOrgUnit"));
        sic.add(new SelectorItemInfo("entries.assistProperty.id"));
        sic.add(new SelectorItemInfo("entries.unit.id"));
        sic.add(new SelectorItemInfo("entries.sourceBillId"));
        sic.add(new SelectorItemInfo("entries.sourceBillNumber"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntrySeq"));
        sic.add(new SelectorItemInfo("entries.assCoefficient"));
        sic.add(new SelectorItemInfo("entries.baseStatus"));
        sic.add(new SelectorItemInfo("entries.associateQty"));
        sic.add(new SelectorItemInfo("entries.sourceBillType.id"));
        sic.add(new SelectorItemInfo("entries.baseUnit.id"));
        sic.add(new SelectorItemInfo("entries.assistUnit.id"));
        sic.add(new SelectorItemInfo("entries.remark"));
        sic.add(new SelectorItemInfo("entries.reasonCode,id"));
        sic.add(new SelectorItemInfo("entries.seq"));
        return sic;
    }

    public static IObjectValue getInfoById(IObjectCollection cols, String id) {
        IObjectValue info = null;
        for (int i = 0; i < cols.size() && !id.equals((info = cols.getObject(i)).getBOSUuid("id").toString()); ++i) {
        }
        return info;
    }

    public static void resetNumberValue(KDTable table, int rowIndex, String[] columns) {
        BigDecimal value = null;
        ICell cell = null;
        for (int i = 0; i < columns.length; ++i) {
            cell = table.getCell(rowIndex, columns[i]);
            if (cell == null || (value = (BigDecimal)cell.getValue()) == null || value.compareTo(MAXVAL) <= 0) continue;
            cell.setValue((Object)MAXVAL);
        }
    }

    public static boolean isUseWarehsRelation(String storageOrgUnitID) throws EASBizException, BOSException {
        ObjectUuidPK pk;
        boolean isUseWarehsRelation = false;
        IParamControl ipc = ParamControlFactory.getRemoteInstance();
        String strUseWarehsRelation = ipc.getParamValue((IObjectPK)(pk = new ObjectUuidPK(storageOrgUnitID)), "INM008");
        if (strUseWarehsRelation != null && strUseWarehsRelation.trim().length() != 0 && strUseWarehsRelation.trim().equalsIgnoreCase("true")) {
            isUseWarehsRelation = true;
        }
        return isUseWarehsRelation;
    }

    public static BigDecimal getValidDecimal(BigDecimal value) {
        if (value == null) {
            return new BigDecimal("0.00");
        }
        return MAXVAL.compareTo(value) < 0 ? MAXVAL : value;
    }

    public static Map getNationalMap(Context ctx) throws EASBizException, BOSException {
        HashMap nationmap = null;
        nationmap = NantionalServiceFacadeFactory.getLocalInstance((Context)ctx).getNationalConfig(ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString(), ctx.getLocale().toString());
        return nationmap;
    }

    public static int getDiscountRatePrecision(Context ctx) throws BOSException, EASBizException {
        int discountRatePrecision = 4;
        IParamControl ipc = null == ctx ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        String paramvalue = ipc.getParamValue(null, "DISCOUNTRATEPRECISION");
        discountRatePrecision = Integer.valueOf(paramvalue);
        return discountRatePrecision;
    }

    public static void setF7RangeChange(Component from, Component to) {
        KDBizPromptBox prmtFrom = null;
        KDBizPromptBox prmtTo = null;
        if (from instanceof KDBizPromptBox) {
            prmtFrom = (KDBizPromptBox)from;
            prmtTo = (KDBizPromptBox)to;
        }
        if (prmtFrom == null || prmtTo == null) {
            return;
        }
        prmtFrom.addDataChangeListener((DataChangeListener)new RangChangeListener(prmtFrom, prmtTo));
    }

    public static String listToString(List ids) {
        StringBuffer idstring = new StringBuffer();
        idstring.append("'");
        for (int i = 0; i < ids.size(); ++i) {
            if (ids.get(i) == null) continue;
            idstring.append(ids.get(i).toString()).append("','");
        }
        idstring.append("'");
        return idstring.toString();
    }

    public static String setToString(Set valueSet) {
        StringBuffer returnValue = new StringBuffer("(");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (PurUtil.isEmptyString(tempValue)) continue;
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append("'");
                returnValue.append(tempValue);
                returnValue.append("'");
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(")");
        return returnValue.toString();
    }

    public static boolean isEmptyString(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static void buttonPressed(AbstractButton button) {
        ButtonModel model = button.getModel();
        model.setPressed(true);
        model.setArmed(true);
        model.setPressed(false);
        model.setArmed(false);
    }

    public static DemandTypeInfo getDemandType(Context ctx, String demandTypeId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)demandTypeId)) {
            return null;
        }
        IDemandType idemandType = null;
        idemandType = ctx == null ? DemandTypeFactory.getRemoteInstance() : DemandTypeFactory.getLocalInstance((Context)ctx);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("purchanseType"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("rowType.requestOrgType"));
        sic.add(new SelectorItemInfo("rowType.destinationType"));
        sic.add(new SelectorItemInfo("rowType.isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("rowType.precision"));
        return (DemandTypeInfo)idemandType.getDataBaseInfo((IObjectPK)new ObjectUuidPK(demandTypeId), sic);
    }

    public static Map getMatPurchasingInfoCollection(Context ctx, String[] materialIDS, String[] OrgIDs) throws BOSException {
        if (null == materialIDS || null == OrgIDs || materialIDS.length != OrgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashMap<String, MaterialPurchasingInfo> matPurchase = new HashMap<String, MaterialPurchasingInfo>();
        String key = "";
        MaterialPurchasingInfo materialPurchasingInfo = null;
        IMaterialPurchasing iMaterialPurchasing = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
        if (materialIDS != null && OrgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || OrgIDs[i] == null) continue;
                filter.appendFilterItem("orgUnit.id", (Object)OrgIDs[i]);
                filter.appendFilterItem("material.id", (Object)materialIDS[i]);
                filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
            }
            StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
            int size2 = filter.getFilterItems().size();
            for (int i = 0; i < size2; i += 3) {
                maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #");
                maskString.append(i + 2).append(") or ");
            }
            int length = maskString.length();
            maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            MaterialPurchasingCollection coll = iMaterialPurchasing.getMaterialPurchasingCollection(viewInfo);
            if (coll != null) {
                for (int j = 0; j < coll.size(); ++j) {
                    materialPurchasingInfo = coll.get(j);
                    if (materialPurchasingInfo == null || materialPurchasingInfo.getMaterial() == null || materialPurchasingInfo.getOrgUnit() == null) continue;
                    key = materialPurchasingInfo.getMaterial().getId().toString() + materialPurchasingInfo.getOrgUnit().getId().toString();
                    matPurchase.put(key, materialPurchasingInfo);
                }
            }
        }
        return matPurchase;
    }

    static class RangChangeListener
    implements DataChangeListener {
        KDBizPromptBox prmtFrom;
        KDBizPromptBox prmtTo;

        public RangChangeListener(KDBizPromptBox from, KDBizPromptBox to) {
            this.prmtFrom = from;
            this.prmtTo = to;
        }

        public void dataChanged(DataChangeEvent eventObj) {
            this.handleRangChanged(eventObj);
        }

        private void handleRangChanged(DataChangeEvent eventObj) {
            if (this.prmtTo.getValue() != null) {
                return;
            }
            Object newValue = eventObj.getNewValue();
            if (newValue != null) {
                this.prmtTo.setValue(newValue);
            }
        }
    }
}

