/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import java.math.BigDecimal;

public class CheckQtyAndBaseqtyVRule
extends AbstractServerVRule {
    public CheckQtyAndBaseqtyVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SCMBillBaseInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkQtyAndBaseQty(bean);
    }

    private void checkQtyAndBaseQty(IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo bill = (SCMBillBaseInfo)model;
        IObjectCollection entrys = bill.getEntries();
        StringBuffer entrySeqStr = new StringBuffer();
        int len = entrys.size();
        for (int j = 0; j < len; ++j) {
            SCMBillEntryBaseInfo entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
            if (entry == null || entry.getUnit() == null || entry.getBaseUnit() == null) continue;
            if (entry.getUnit().getId().toString().equals(entry.getBaseUnit().getId().toString())) {
                if (((BigDecimal)entry.get("qty")).compareTo((BigDecimal)entry.get("baseQty")) == 0) continue;
                entrySeqStr.append(j + 1).append(",");
                continue;
            }
            MeasureUnitInfo unit = entry.getUnit();
            MaterialInfo aMaterialInfo = entry.getMaterial();
            BigDecimal qty = (BigDecimal)entry.get("qty");
            if (entry.getMaterial() == null) continue;
            BigDecimal baseQty = InvServerUtils.getBaseUnitQty((Context)this.getCtx(), (MeasureUnitInfo)unit, (MaterialInfo)aMaterialInfo, (BigDecimal)qty);
            if (baseQty == null) {
                throw new SCMBillException(SCMBillException.BASEUNIT_ERROR, new Object[]{j + 1, aMaterialInfo.getNumber()});
            }
            if (baseQty.compareTo((BigDecimal)entry.get("baseQty")) == 0) continue;
            entrySeqStr.append(j + 1).append(",");
        }
        if (entrySeqStr.length() > 0) {
            throw new PurReqException(PurReqException.BASEQTYNOTMATCH, new Object[]{"", entrySeqStr.substring(0, entrySeqStr.length() - 1)});
        }
    }
}

