/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;

public class CheckPrepayment4SubmitVRule
implements IVRule {
    Context ctx = null;

    public CheckPrepayment4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkPrepayment(bean);
    }

    private void checkPrepayment(IObjectValue bean) throws BOSException, EASBizException {
        PurOrderInfo info = (PurOrderInfo)bean;
        if (BillBaseStatusEnum.ALTERING != info.getBaseStatus()) {
            return;
        }
        CompanyOrgUnitInfo company = info.getCompanyOrgUnit();
        ObjectUuidPK unitID = new ObjectUuidPK(company.getId());
        String isAdvanceGreaterThanBeenPaidPrement = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)unitID, "ORDERPAYMENT");
        if (isAdvanceGreaterThanBeenPaidPrement == null || isAdvanceGreaterThanBeenPaidPrement.trim().length() == 0) {
            return;
        }
        if (!Boolean.valueOf(isAdvanceGreaterThanBeenPaidPrement).booleanValue()) {
            BigDecimal advance = info.getPrepayment();
            BigDecimal beenPaidPrement = info.getPrepaid();
            if (advance == null || beenPaidPrement == null) {
                return;
            }
            if (advance.compareTo(beenPaidPrement) == -1) {
                throw new PurOrderException(PurOrderException.PREPAID_CANNNOT_GREATER_THAN_PREPAYMENT);
            }
        }
    }
}

