/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.util.collection.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;

public class CheckMoveAveMat4SubmitVRule
implements IVRule {
    Context ctx = null;

    public CheckMoveAveMat4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkMoveAveMatForSubmit(bean);
    }

    protected void checkMoveAveMatForSubmit(IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        PurRequestInfo info = (PurRequestInfo)model;
        if (info.getPurchaseType() == null || info.getPurchaseType().getValue() == 0) {
            return;
        }
        PurRequestEntryCollection col = info.getEntries();
        if (CollectionUtil.isEmpty((AbstractObjectCollection)col)) {
            return;
        }
        PurRequestEntryInfo entry = null;
        ArrayList<String> mList = new ArrayList<String>();
        ArrayList<String> cList = new ArrayList<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            if (entry == null || entry.getCompanyOrgUnit() == null || entry.getMaterial() == null) continue;
            String materialId = entry.getMaterial().getId().toString();
            String companyId = entry.getCompanyOrgUnit();
            mList.add(materialId);
            cList.add(companyId);
        }
        if (!CollectionUtil.isEmpty(mList) && !CollectionUtil.isEmpty(cList)) {
            ArrayList<String> matNumList = new ArrayList<String>();
            StringBuffer sb = new StringBuffer();
            sb.append(" select distinct mi.FNumber ");
            sb.append(" from T_BD_MaterialCompanyInfo mc inner join T_BD_Material mi on mc.FMaterialID=mi.fid ");
            sb.append(" where mc.FCompanyID in(" + CollectionUtil.convertList2String(cList) + ")");
            sb.append(" and mc.FMaterialID in(" + CollectionUtil.convertList2String(mList) + ")");
            sb.append(" and mi.FIsOutsourcedPart = 1 ");
            sb.append(" and mc.FAccountType = ").append(1);
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sb.toString());
            try {
                while (rs.next()) {
                    matNumList.add(rs.getString("FNumber"));
                }
            }
            catch (SQLException companyId) {
                // empty catch block
            }
            sb.setLength(0);
            sb.append("\n");
            int count = matNumList.size();
            for (int i = 0; i < count; ++i) {
                sb.append(matNumList.get(i)).append("\r\n");
            }
            if (count > 0) {
                throw new SCMBillException(SCMBillException.CANNOT_BE_MOVEAGEMAT_IN_SUBCONSTRACT, new Object[]{sb.toString()});
            }
        }
    }
}

