/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.im.inv.IPlanOrderEntry;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryCollection;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryFactory;
import com.kingdee.eas.scm.im.inv.PlanOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.util.string.StringUtil;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;

public class CheckQty4SubmitVRule
extends AbstractServerVRule {
    public CheckQty4SubmitVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkQty(bean);
    }

    private void checkQty(IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo bill = (PurRequestInfo)model;
        HashMap<String, BigDecimal> poMap = new HashMap<String, BigDecimal>();
        if (bill.getSourceBillType() != null && "7UcZ6QEUEADgAAYawKg9C0Y+1VI=".equals(bill.getSourceBillType().getId().toString())) {
            IPlanOrderEntry ipoe = PlanOrderEntryFactory.getLocalInstance((Context)this.getCtx());
            PurRequestEntryCollection entries = bill.getEntries();
            HashSet<String> idSet = new HashSet<String>();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                idSet.add(entries.get(i).getSourceBillEntryId());
            }
            EntityViewInfo env = new EntityViewInfo();
            SelectorItemCollection sic = env.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("associateQty"));
            FilterInfo fi = new FilterInfo();
            env.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            PlanOrderEntryCollection poEntries = ipoe.getPlanOrderEntryCollection(env);
            for (PlanOrderEntryInfo info : poEntries) {
                poMap.put(info.getId().toString(), info.getAssociateQty());
            }
            PurRequestEntryCollection col = bill.getEntries();
            PurRequestEntryInfo entry = null;
            int size2 = col.size();
            for (int i = 0; i < size2; ++i) {
                BigDecimal sourceQty;
                String sourceBillEntryID;
                entry = col.get(i);
                String string = sourceBillEntryID = entry.getSourceBillEntryId() != null ? entry.getSourceBillEntryId() : null;
                if (StringUtil.isEmpty((String)sourceBillEntryID)) continue;
                BigDecimal qty = entry.getBaseQty();
                BigDecimal bigDecimal = sourceQty = poMap.get(sourceBillEntryID) != null ? (BigDecimal)poMap.get(sourceBillEntryID) : null;
                if (sourceQty == null || qty.compareTo(sourceQty) <= 0) continue;
                throw new PurReqException(PurReqException.PLANORDER_WBERROR, new Object[]{entry.getSeq()});
            }
        }
        PurRequestEntryCollection entries = bill.getEntries();
        if (null != bill.getId() && SCMBillCommonFacadeFactory.getLocalInstance((Context)super.getCtx()).getIsBillMultiapprove(new String[]{bill.getId().toString()})) {
            PurRequestEntryInfo entry;
            int i;
            Boolean isAllZero = true;
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (null == entries.get(i).getQty() || entries.get(i).getQty().compareTo(new BigDecimal(0)) <= 0) continue;
                isAllZero = false;
                break;
            }
            if (isAllZero.booleanValue()) {
                throw new PurReqException(PurReqException.ENTRY_TOTAL_QTY_NOTNULL);
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (null == entries.get(i).getRequestQty() || entries.get(i).getRequestQty().compareTo(new BigDecimal(0)) <= 0) continue;
                isAllZero = false;
                break;
            }
            if (isAllZero.booleanValue()) {
                throw new PurReqException(PurReqException.ENTRY_TOTAL_REQQTY_NOTNULL);
            }
        } else {
            for (int i = 0; i < entries.size(); ++i) {
                PurRequestEntryInfo entry = entries.get(i);
                if (null != entry.getQty() && entry.getQty().compareTo(new BigDecimal(0)) == 0) {
                    int seq = i + 1;
                    if (entry.getSeq() > 0) {
                        seq = entry.getSeq();
                    }
                    throw new PurReqException(PurReqException.ENTRY_QTY_NOTNULL, new Object[]{seq});
                }
                if (null == entry.getRequestQty() || entry.getRequestQty().compareTo(new BigDecimal(0)) != 0) continue;
                int seq = i + 1;
                if (entry.getSeq() > 0) {
                    seq = entry.getSeq();
                }
                throw new PurReqException(PurReqException.ENTRY_REQQTY_NOTNULL, new Object[]{seq});
            }
        }
    }
}

