/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.nbudget.BgControlCaller;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.EntryProcessServerHelper;
import com.kingdee.eas.scm.sm.pur.util.PurEntryProcessUtils;

public class CheckValidData4AuditVRule
implements IVRule {
    Context ctx;

    public CheckValidData4AuditVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkBeforeAudit(bean);
    }

    private void checkBeforeAudit(IObjectValue bean) throws BOSException, EASBizException {
        PurRequestInfo model = (PurRequestInfo)bean;
        if (model.getBaseStatus() != null) {
            if (model.getBaseStatus().getValue() == 1) {
                throw new PurReqException(PurReqException.AUDIT_ISNOTTEMP);
            }
            if (model.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.AUDIT_ISNOTAUDIT);
            }
            if (model.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.AUDIT_IS_CANCEL);
            }
            if (model.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.PURREQUESTINOTAUDIT);
            }
            if (PurEntryProcessUtils.isEnableEntryProcessForPurRequest(this.ctx)) {
                PurRequestEntryCollection entries = model.getEntries();
                PurRequestEntryInfo entry = null;
                int len = entries.size();
                for (int i = 0; i < len; ++i) {
                    entry = entries.get(i);
                    if (!EntryProcessServerHelper.IsInActiveWorkFlow(this.ctx, entry.getId().toString())) continue;
                    throw new PurReqException(PurReqException.WF_DONOT);
                }
            }
            if (model != null && model.getCompanyOrgUnit() != null && !model.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == model.getPurchaseType() && SCMBizProcessorUtil.isControlBudget((Context)this.ctx, (SCMBillBaseInfo)model, (String)model.getCompanyOrgUnit().getId().toString(), (int)1)) {
                BgControlCaller caller = new BgControlCaller();
                boolean checkPass = caller.checkBizUnitInfo(this.ctx, model.getId(), null);
                if (!checkPass) {
                    return;
                }
            }
        }
    }
}

