/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purreturns;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.util.HashMap;

public class CheckDataValid4SubmitVRule
implements IVRule {
    Context ctx = null;

    public CheckDataValid4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurReturnsInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        PurReturnsInfo purReturnsInfo = (PurReturnsInfo)bean;
        boolean isAddNew = true;
        isAddNew = SCMBizProcessorUtil.isAddNew((Context)this.ctx, (IObjectValue)purReturnsInfo);
        if (!isAddNew) {
            ObjectUuidPK pk = new ObjectUuidPK(purReturnsInfo.getId());
            this.canEditUpdate(this.ctx, (IObjectPK)pk);
        }
        this.checkValid(bean);
        if (purReturnsInfo.getPurchaseOrgUnit() != null) {
            String purOrgId = purReturnsInfo.getPurchaseOrgUnit().getId().toString();
            if (null != purReturnsInfo.getEntries() && purReturnsInfo.getEntries().size() > 0) {
                IParamControl paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx);
                StringBuffer error = new StringBuffer();
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                for (int i = 0; i < purReturnsInfo.getEntries().size(); ++i) {
                    PurReturnsEntryInfo entry = purReturnsInfo.getEntries().get(i);
                    boolean flag = false;
                    if (map.containsKey(purOrgId)) {
                        flag = (Boolean)map.get(purOrgId);
                    } else {
                        ParamItemInfo paramItem = paramValue.getParamItemByNumberAndOrg("PURORDER100", purOrgId);
                        flag = Boolean.parseBoolean(paramItem.getValue());
                        map.put(purOrgId, flag);
                    }
                    if (flag || entry.getMaterial() == null || entry.getMaterial().getAssistAttr() == null) continue;
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)entry.getMaterial().getId().toString(), CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("assistAttr.id"));
                    sic.add(new SelectorItemInfo("assistAttr.name"));
                    sic.add(new SelectorItemInfo("assistAttr.number"));
                    view.setSelector(sic);
                    MaterialCollection materialCol = MaterialFactory.getLocalInstance((Context)this.ctx).getMaterialCollection(view);
                    if (null == materialCol || materialCol.size() <= 0 || materialCol.get(0).getAssistAttr() == null || entry.getAssistProperty() != null) continue;
                    if (error.toString().equals("")) {
                        error.append(i + 1);
                        continue;
                    }
                    error.append(",").append(i + 1);
                }
                if (error != null && !error.toString().equals("")) {
                    throw new PurReqException(PurReqException.ENTRY_ASSIST_NOTNULL, new String[]{error.toString()});
                }
            }
        }
    }

    private void canEditUpdate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReturnsInfo purReturnsInfo = PurReturnsFactory.getLocalInstance(ctx).getPurReturnsInfo(pk, SCMSelectorFactory.getPurReturnsSelector((boolean)true));
        if (purReturnsInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new PurReturnsException(PurReturnsException.AUDITED_CANNOTUPDATE);
        }
        if (purReturnsInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.DELETED)) {
            throw new PurReturnsException(PurReturnsException.DELETED_CANNOTUPDATE);
        }
        if (purReturnsInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            throw new PurReturnsException(PurReturnsException.CLOSED_CANNOTUPDATE);
        }
    }

    protected void checkValid(IObjectValue model) throws PurReturnsException {
        PurReturnsInfo info = (PurReturnsInfo)model;
        if (info.getSupplier() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_SUPPLIER);
        }
        if (info.getPurchaseOrgUnit() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_PURCHASEORGUNIT);
        }
        if (info.getBizType() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_BIZETYPE);
        }
        if (info.getCurrency() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_CURRENCY);
        }
        if (info.getExchangeRate() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_EXCHANGERATE);
        }
        if (info.getBaseStatus() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_BASTSTATE);
        }
        if (info.getEntries() != null) {
            this.checkEntriesValid(info.getEntries());
        } else if (info.getEntries() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ENTRIES);
        }
        String paramValue = null;
        if (info.getPurchaseOrgUnit() != null) {
            try {
                IParamControl ipc = ParamControlFactory.getLocalInstance((Context)this.ctx);
                paramValue = ipc.getParamValue((IObjectPK)new ObjectUuidPK(info.getPurchaseOrgUnit().getId().toString()), "PURORDER100");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void checkEntriesValid(PurReturnsEntryCollection p) throws PurReturnsException {
        int count = p.size();
        if (count <= 0) {
            throw new PurReturnsException(PurReturnsException.NULL_ENTRIES);
        }
        for (int i = 0; i < count; ++i) {
            PurReturnsEntryInfo pEntryInfo = p.get(i);
            if (pEntryInfo.getMaterial() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_MATERIAL);
            }
            if (pEntryInfo.getUnit() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_MEASUREUNIT);
            }
            if (pEntryInfo.getQty() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_RETURNSQTY);
            }
            if (pEntryInfo.getPrice() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_PRICE);
            }
            if (pEntryInfo.getTaxPrice() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_TAXRATE);
            }
            if (pEntryInfo.getReturnsDate() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_RETURNSDATE);
            }
            if (pEntryInfo.getStorageOrgUnit() != null) continue;
            throw new PurReturnsException(PurReturnsException.NULL_ENTRY_STORAGEORGUNIT);
        }
    }
}

