/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMRptUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.InvCommonUtils;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.app.AbstractPurConsumeAnalysisFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurConsumeAnalysisFacadeControllerBean
extends AbstractPurConsumeAnalysisFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurConsumeAnalysisFacadeControllerBean");
    private String leafPurChaseOrgUnitStr;
    private String maxLevelStr = "maxLevelStr";
    private String periodIDStr = "periodID";
    private String periodYearStr = "periodYear";
    private String periodNumberStr = "periodNumber";
    private String periodDateStr = "periodDateStr";
    private List storageList = new ArrayList();
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private String baseCurrency;
    private String baseCurrencyName;
    private int precision;
    static final String[] RECEIVEBILLS = new String[]{"103", "107", "109", "105"};
    static final String[] ISSUEBILLS = new String[]{"102", "104", "106", "108"};

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("StorageORGTempTable"), ctx);
        String tempTable = this.getTempTableName(SCMUtils.getResource((String)resClassName, (String)"purPriceWMRptUI", (Context)ctx) + "_derekee", ctx);
        String storageORGTempTable = this.getTempTableName(ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PURAutoGenerateResource", (String)"18_PurConsumeAnalysisFacadeControllerBean", (Locale)ctx.getOriginLocale()), ctx);
        params.setString("tempTable", tempTable);
        params.setString("StorageORGTempTable", storageORGTempTable);
        if (params.getObject("") == null) {
            // empty if block
        }
        this.buildStorageOrgTable(ctx, storageORGTempTable, params);
        this.putBeginPeriodtoParams(ctx, params);
        this.createTempTableAndInsertData(ctx, tempTable, params, storageORGTempTable);
        this.updateTotal(ctx, tempTable, storageORGTempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rsCount = this.executeQuery(countSql, null, ctx);
        rsCount.next();
        int count = rsCount.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.getHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setString("StorageORGTempTable", storageORGTempTable);
        result.setInt("totalCount", count);
        result.setObject("header", (Object)header);
        result.setString("baseCurrencyName", this.baseCurrencyName);
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params, String storageORGTempTable) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        if (params.getString("Initialed") != null && params.getString("Initialed").equals("false")) {
            return;
        }
        sql = this.getSummarySQL(params, storageORGTempTable);
        this.executeSQL(ctx, sql);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FMaterialID Varchar(44),\r\n");
        sql.append("FStorageOrgUnitID Varchar(44),\r\n");
        sql.append("FBeginQty Decimal(28,10),\r\n");
        sql.append("FPurQty Decimal(28,10),\r\n");
        sql.append("FInWarehsQty Decimal(28,10),\r\n");
        sql.append("FIssueQty Decimal(28,10),\r\n");
        sql.append("FCurrencyID Varchar(44),\r\n");
        sql.append("FPrice Decimal(28," + this.precision + ")\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table " + orgTempTable + " (");
        sql.append("fid varchar(44),");
        sql.append("fname_" + ctx.getLocale().getLanguage() + " varchar(100),");
        sql.append("fparentid varchar(44),");
        sql.append("flevel int,");
        sql.append("fisleaf int");
        sql.append(",CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        this.executeSQL(ctx, sql.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] storageOrg = (Object[])params.getObject("StorageOrg");
        storageOrg = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])storageOrg, (String)"PurConsumeAnalysisUI_wiew");
        String[] sqls = new String[storageOrg.length];
        int n = storageOrg.length;
        for (int i = 0; i < n; ++i) {
            String fid = ((FullOrgUnitInfo)storageOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)storageOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)storageOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)storageOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)storageOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sql = new StringBuffer();
            sql.append("insert into " + orgTempTable + "(");
            sql.append("fid,fname_" + ctx.getLocale().getLanguage());
            sql.append(",fparentid,flevel,fisleaf) ");
            sql.append("values(");
            sql.append("'" + fid + "',");
            if (fname != null) {
                sql.append("'" + fname + "',");
            } else {
                sql.append("null,");
            }
            if (parent != null) {
                sql.append("'" + parent.getId().toString() + "',");
            } else {
                sql.append("null,");
            }
            sql.append(flevel + ",");
            sql.append(fisleaf + ") ");
            sqls[i] = sql.toString();
        }
        this.executeBatchUpdate(ctx, sqls);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
        this.storageList.clear();
        this.storageList.addAll(v);
    }

    private void updateTotal(Context ctx, String tempTable, String orgTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int level = (Integer)params.getObject(this.maxLevelStr);
        if (level == 1) {
            return;
        }
        sql.append("insert into " + tempTable);
        sql.append(" SELECT temp.FMaterialID,org.fparentid ");
        sql.append(",sum(temp.FBeginQty),SUM(temp.FPurQty),sum(FInWarehsQty),sum(temp.FIssueQty),temp.FCurrencyID,");
        sql.append("case when sum(FPurQty)>0 then TO_DECIMAL(sum(temp.FPrice*temp.FPurQty)/sum(FPurQty),17,").append(this.precision).append(") else 0 end");
        sql.append(" from  " + tempTable + " temp");
        sql.append(" inner join ");
        sql.append(orgTable).append("  org on temp.FStorageOrgUnitID = org.fid where org.flevel = ");
        String sqle = "";
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " group by  temp.FMaterialID,org.fparentid,temp.FCurrencyID";
            this.executeSQL(ctx, sqle);
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    protected RptParams _findData(Context ctx, RptParams param, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptRowSet rs;
        String sql = "";
        if (start <= -1 && count <= -1) {
            sql = this.querySql(param, ctx) + " where mat.FID ='" + param.getString("fmaterialid") + "' and org.fparentid='" + param.getString("fparentid") + "'";
            rs = this.executeQuery(sql, null, ctx);
        } else {
            sql = this.querySql(param, ctx) + " where mat.FID='" + param.getString("fmaterialid") + "' and org.fparentid='" + param.getString("fparentid") + "'";
            rs = this.executeQuery(sql, null, start, count, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String querySql(RptParams params, Context ctx) {
        String orgTempTable = params.getString("StorageORGTempTable");
        String tempTable = params.getString("tempTable");
        String baseCurrencyName = params.getString("baseCurrencyName");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String sql = "select mat.FNumber AS MATERIAL_NUMBER,mat.FName_" + ctx.getLocale().getLanguage() + " AS MATERIAL_NAME," + (ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "") + "mat.FModel as Material_FModel,mg.FName_" + ctx.getLocale().getLanguage() + " AS MATERIALGROUP_NAME,org.fname_" + ctx.getLocale().getLanguage() + " as STORAGEORG_NAME,unit.FName_" + ctx.getLocale().getLanguage() + " AS UNIT_NAME,tem.FBeginQty as BEGINQTY,tem.FPurQty AS FPurQty ,tem.FInWarehsQty AS FInWarehsQty,tem.FIssueQty AS ISSUEQTY,tem.FBeginQty+tem.FPurQty-tem.FIssueQty AS fInCurrent,N'" + baseCurrencyName + "' AS CURRENCY, tem.FPrice,tem.FMaterialID as FMaterialID,tem.FStorageOrgUnitID as FStorageOrgUnitID,org.fisleaf as STORAGEORG_ISLEAF,org.flevel as STORAGEORG_LEVEL,org.fparentid AS STORAGEORG_PARENTID from " + tempTable + " tem inner join " + orgTempTable + " org on tem.FStorageOrgUnitID = org.fid  inner join T_BD_Material mat on tem.FMaterialID = mat.FID  LEFT OUTER JOIN T_BD_MaterialGroup mg\tON mat.FMaterialGroupID = mg.FID  INNER JOIN T_BD_MeasureUnit AS UNIT ON mat.FBaseUnit = UNIT.FID";
        return sql.toString();
    }

    private RptTableHeader getHead(RptTableHeader header, RptParams params, Context ctx) {
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String materialGroup = this.getServerResource("MaterialGroup", ctx);
        String storageORGName = this.getServerResource("StorageOrg", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String intStoreQTY = this.getServerResource("IntStoreQTY", ctx);
        String periodPurQTY = this.getServerResource("PeriodPurQTY", ctx);
        String inWarehsQty = this.getServerResource("InWarehsQty", ctx);
        String periodUseQTY = this.getServerResource("PeriodUseQTY", ctx);
        String periodStoreQTY = this.getServerResource("PeriodStoreQTY", ctx);
        String currency = this.getServerResource("Currency", ctx);
        String Price = this.getServerResource("PurPrice", ctx);
        String materialFID = "FID";
        String storageORGFID = "STORAGEORGUNITID";
        String storageORGIsleaf = "ISLEAF";
        String storageORGLevel = "FLEVEL";
        String storageORGParentID = "FPRARENTID";
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String[] cols = new String[18];
        if (ckBxShowMShortName) {
            cols = new String[19];
        }
        int m = 2;
        cols[0] = "MATERIAL_NUMBER";
        cols[1] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        cols[m++] = "MATERIALGROUP_NAME";
        cols[m++] = "STORAGEORG_NAME";
        cols[m++] = "BASEUNIT_NAME";
        cols[m++] = "INITSTORE_QTY";
        cols[m++] = "PERIODPUR_QTY";
        cols[m++] = "INWAREHS_QTY";
        cols[m++] = "PERIODUSE_QTY";
        cols[m++] = "PERIODSTORE_QTY";
        cols[m++] = "CURRENCY";
        cols[m++] = "PRICE";
        cols[m++] = "MATERIAL_FID";
        cols[m++] = "STORAGEORG_FID";
        cols[m++] = "STORAGEORG_ISLEAF";
        cols[m++] = "STORAGEORG_LEVEL";
        cols[m++] = "STORAGEORG_PATENTID";
        Object[][] labels = new String[1][18];
        if (ckBxShowMShortName) {
            labels = new String[1][19];
        }
        m = 2;
        labels[0][0] = materialNum;
        labels[0][1] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        labels[0][m++] = materialGroup;
        labels[0][m++] = storageORGName;
        labels[0][m++] = baseUnit;
        labels[0][m++] = intStoreQTY;
        labels[0][m++] = periodPurQTY;
        labels[0][m++] = inWarehsQty;
        labels[0][m++] = periodUseQTY;
        labels[0][m++] = periodStoreQTY;
        labels[0][m++] = currency;
        labels[0][m++] = Price;
        labels[0][m++] = materialFID;
        labels[0][m++] = storageORGFID;
        labels[0][m++] = storageORGIsleaf;
        labels[0][m++] = storageORGLevel;
        labels[0][m++] = storageORGParentID;
        ArrayList<String> hideCols = new ArrayList<String>();
        hideCols.add("MATERIAL_FID");
        hideCols.add("STORAGEORG_FID");
        hideCols.add("STORAGEORG_ISLEAF");
        hideCols.add("STORAGEORG_LEVEL");
        hideCols.add("STORAGEORG_PATENTID");
        hideCols.add("FID");
        hideCols.add("STORAGEORGUNITID");
        hideCols.add("ISLEAF");
        hideCols.add("FLEVEL");
        hideCols.add("FPRARENTID");
        this.setHeaderColumns(header, cols, params, hideCols);
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params, List hideCols) {
        String prcFormat = this.getFormatPattern(4);
        RptTableColumn col = null;
        for (int i = 0; i < columns.length; ++i) {
            col = new RptTableColumn(columns[i]);
            if (params.getBoolean("ckBxShowMShortName")) {
                if (i >= 7 && i <= 11 || i == 13) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
                if (i == 12 || i >= 14) {
                    col.setHided(true);
                }
            } else {
                if (i >= 6 && i <= 10 || i == 12) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
                if (i == 11 || i >= 13) {
                    col.setHided(true);
                }
            }
            if (hideCols.contains(columns[i])) {
                col.setWidth(-1);
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    private void putBeginPeriodtoParams(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptRowSet rs;
        int i;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String bd = params.getString("dateStart");
        String ed = params.getString("dateEnd");
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)), new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(bd.substring(5, 7)), new Integer(bd.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        Calendar calendar = Calendar.getInstance();
        if (beginDate != null) {
            sb2.append("select p.fid, p.FPeriodYear, p.FPeriodNumber,").append("p.FBeginDate, p.FEndDate, o.FAccountPeriodID ").append("from T_ORG_Storage s,T_ORG_UnitRelation r,T_ORG_TypeRelation t,").append("T_ORG_Company o, T_BD_Period p ").append("where s.FID=r.FFromUnitID and r.FTypeRelationID=t.FID and o.FID=r.FToUnitID ").append("and p.FTypeID=o.FAccountPeriodID ").append("and t.FFromType=4 and t.FToType=1 ").append("and p.FBeginDate <={").append(SCMRptUtils.getFmtDate((Date)beginDate)).append("} and s.FID in (");
            if (this.storageList.size() > 0) {
                for (i = 0; i < this.storageList.size(); ++i) {
                    sb2.append("'").append(this.storageList.get(i));
                    sb2.append("',");
                }
                sb2.deleteCharAt(sb2.length() - 1);
            } else {
                sb2.append("'xxx_xx'");
            }
            sb2.append(")");
            sb2.append(" order by s.fid, p.FPeriodYear desc, p.FPeriodNumber desc");
            rs = this.executeQuery(sb2.toString(), null, ctx);
            if (rs.next()) {
                params.setObject(this.periodIDStr, (Object)rs.getString("fid"));
                params.setInt(this.periodYearStr, rs.getInt("fperiodyear"));
                params.setInt(this.periodNumberStr, rs.getInt("fperiodnumber"));
                params.setObject(this.periodDateStr, rs.getObject("FBeginDate"));
            } else {
                params.setObject(this.periodIDStr, null);
                try {
                    params.setObject(this.periodDateStr, (Object)df.parse(df.format(beginDate)));
                }
                catch (ParseException e) {
                    logger.error((Object)e);
                }
            }
        }
        sb.append("select s.FID,r.FToUnitID,p.FPeriodYear,p.FPeriodNumber,");
        sb.append("p.FBeginDate,o.FBaseCurrencyID,c.FName_" + ctx.getLocale().getLanguage());
        sb.append(",c.FPrecision from T_ORG_Storage s,T_ORG_UnitRelation r,T_ORG_TypeRelation t,");
        sb.append(" T_BD_SystemStatus ss,T_BD_SystemStatusCtrol sc,");
        sb.append("t_bd_period p, T_ORG_Company o, T_BD_Currency c");
        sb.append(" where s.FID=r.FFromUnitID and r.FTypeRelationID=t.FID and");
        sb.append(" ss.FID=sc.FSystemStatusID ");
        sb.append("and sc.FStartPeriodID=p.FID and sc.FCompanyID=r.FToUnitID and");
        sb.append(" o.FID=r.FToUnitID and o.FBaseCurrencyID=c.FID and");
        sb.append("  t.FFromType=4 and t.FToType=1 and sc.FIsStart=1 and FName=2 and s.FID in (");
        if (this.storageList.size() > 0) {
            for (i = 0; i < this.storageList.size(); ++i) {
                sb.append("'").append(this.storageList.get(i));
                sb.append("',");
            }
            sb.deleteCharAt(sb.length() - 1);
        } else {
            sb.append("'xxx_xx'");
        }
        sb.append(")");
        String sql = sb.toString();
        rs = this.executeQuery(sql, null, ctx);
        this.baseCurrency = null;
        while (rs.next()) {
            if (this.baseCurrency == null) {
                this.baseCurrency = rs.getString("FBaseCurrencyID");
                this.baseCurrencyName = rs.getString("FName_" + ctx.getLocale().getLanguage());
                this.precision = rs.getInt("FPrecision");
                continue;
            }
            if (this.baseCurrency.equals(rs.getString("FBaseCurrencyID"))) continue;
            throw new SMReportException(SMReportException.BASE_CURRENCY_NOT_SAME);
        }
        if (this.storageList.size() == 0) {
            params.setString("Initialed", "false");
            return;
        }
    }

    private String getPeriodBeginSQL(RptParams params, String storageORGTempTable) {
        StringBuffer sb = new StringBuffer();
        String pid = params.getString(this.periodIDStr);
        if (pid == null) {
            return null;
        }
        int year = params.getInt(this.periodYearStr);
        Integer period = (Integer)params.getObject(this.periodNumberStr);
        StringBuffer sql = new StringBuffer();
        sql.append(" select m.FMaterialID,m.FStorageOrgUnitID,sum(m.FPeriodBeginQty) as FBeginQty,");
        sql.append("0 as FPurQty,0 as FInWarehsQty,0 as FIssueQty,0 as FTaxAmount from T_IM_InventoryBalance m ");
        sql.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sql.append(" on m.FStorageOrgUnitID = storage.fid ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sql.append(" inner join T_BD_Material mat  on m.FMaterialID=mat.FID ");
            sql.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sql.append(" inner join T_BD_Material mat  on m.FMaterialID=mat.FID ");
        }
        sql.append(" where ");
        sb.append(sql.toString());
        sb.append(" FYear=").append(year);
        sb.append(" and FPeriod=").append(period);
        sb.append(this.getWhere(params));
        sb.append(" group by m.FMaterialID,m.FStorageOrgUnitID");
        return sb.toString();
    }

    private String getUpdateBeginSQL(RptParams params, String billType, String storageORGTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        Date pDate = (Date)params.getObject(this.periodDateStr);
        if (pDate != null) {
            String billTable = InvCommonUtils.getBillTableName((String)billType);
            String billTableEntry = InvCommonUtils.getBillEntryTableName((String)billType);
            sb.append("select d.FMaterialID,m.FStorageOrgUnitID,sum(d.FBaseQty) as FBeginQty");
            sb.append(",0 as FPurQty,0 as FInWarehsQty,0 as FIssueQty,0 as FTaxAmount from ");
            sb.append(billTableEntry);
            sb.append(" d inner join ");
            sb.append(billTable);
            sb.append(" m on m.FID=d.FParentID ");
            if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
                sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
                sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
            } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
                sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            }
            sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
            sb.append(" on m.FStorageOrgUnitID = storage.fid ");
            sb.append(" where 1=1 ");
            sb.append(this.getWhere(params));
            sb.append(" and ");
            sb.append(this.getPeriodWhere(params)).append(" group by d.FMaterialID,m.FStorageOrgUnitID");
        }
        return sb.toString();
    }

    private String getInWarehsSQL(RptParams params, String storageORGTempTable) {
        String sb = this.getWhere(params);
        String bd = params.getString("dateStart");
        String ed = params.getString("dateEnd");
        StringBuffer sbSql = new StringBuffer();
        sbSql.append(" select d.FMaterialID,d.FStorageOrgUnitID");
        sbSql.append(",0 as FBeginQty,0 as FPurQty,sum(d.FInWarehsQty) FInWarehsQty,0 as FIssueQty,0 as FTaxAmount");
        sbSql.append(" from (");
        sbSql.append("select entry.FMaterialID FMaterialID,entry.FStorageOrgUnitID FStorageOrgUnitID");
        sbSql.append(",entry.FBaseQty FInWarehsQty");
        sbSql.append(" from T_im_PurInWarehsBill inwrehsBill  ");
        sbSql.append(" inner join t_im_PurInWarehsEntry entry on inwrehsBill.fid = entry.fparentid ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
            sbSql.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
        }
        sbSql.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sbSql.append(" on entry.FStorageOrgUnitID = storage.fid ");
        sbSql.append(" where ");
        sbSql.append(" inwrehsBill.Fbizdate >={" + bd + "}");
        sbSql.append(" and inwrehsBill.Fbizdate <={" + ed + "}");
        sbSql.append(" and inwrehsBill.FBaseStatus =4 ");
        sbSql.append(sb);
        sbSql.append(" union all ");
        sbSql.append("select entry.FMaterialID,entry.FStorageOrgUnitID,entry.FBaseQty FInWarehsQty");
        sbSql.append(" from T_im_OtherInWarehsBill OtherInWarehsBill  ");
        sbSql.append(" inner join t_im_OtherInWarehsBillEntry entry on OtherInWarehsBill.fid = entry.fparentid ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
            sbSql.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
        }
        sbSql.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sbSql.append(" on entry.FStorageOrgUnitID = storage.fid ");
        sbSql.append(" where ");
        sbSql.append(" OtherInWarehsBill.Fbizdate >={" + bd + "}");
        sbSql.append(" and OtherInWarehsBill.Fbizdate <={" + ed + "}");
        sbSql.append(" and OtherInWarehsBill.FBaseStatus =4 ");
        sbSql.append(sb.toString());
        sbSql.append(" union all ");
        sbSql.append("select entry.FMaterialID,entry.FStorageOrgUnitID,entry.FBaseQty FInWarehsQty");
        sbSql.append(" from T_IM_ManufactureRecBill ManufactureRecBill  ");
        sbSql.append(" inner join T_IM_ManufactureRecBillEntry entry on ManufactureRecBill.fid = entry.fparentid ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
            sbSql.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sbSql.append(" inner join T_BD_Material mat  on entry.FMaterialID=mat.FID ");
        }
        sbSql.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sbSql.append(" on entry.FStorageOrgUnitID = storage.fid ");
        sbSql.append(" where ");
        sbSql.append(" ManufactureRecBill.Fbizdate >={" + bd + "}");
        sbSql.append(" and ManufactureRecBill.Fbizdate <={" + ed + "}");
        sbSql.append(" and ManufactureRecBill.FBaseStatus =4 ");
        sbSql.append(sb.toString());
        sbSql.append(" ) d");
        sbSql.append(" group by d.FMaterialID,d.FStorageOrgUnitID");
        return sbSql.toString();
    }

    private String getPurchaseSQL(RptParams params, String storageORGTempTable) {
        StringBuffer sb = new StringBuffer();
        String bd = params.getString("dateStart");
        String ed = params.getString("dateEnd");
        String rate = "(CASE WHEN m.FConvertMode=0 THEN m.FExchangeRate ELSE 1/m.FExchangeRate END) ";
        String expense = "(TO_DECIMAL(ISNULL(exp.FUnitExpense,0)*d.FTotalReceiptBaseQty,17," + this.precision + "))";
        sb.append("select d.FMaterialID,d.FStorageOrgUnitID");
        sb.append(",0 as FBeginQty,sum(d.FBaseQty) as FPurQty");
        sb.append(",0 as FInWarehsQty,0 as FIssueQty");
        sb.append(",TO_DECIMAL(sum(TO_DECIMAL(d.FLocalTaxAmount + d.FTotalExpense,17,4)),17,4) as FTaxAmount");
        sb.append(" from T_SM_PurOrderEntry d inner join T_SM_PurOrder m on m.FID=d.FParentID ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
        }
        sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sb.append(" on d.FStorageOrgUnitID = storage.fid ");
        sb.append(" where 1=1  ");
        sb.append(this.getBizWhere(params));
        sb.append(" and (d.FBaseStatus<6 ").append(" or d.FCloseDate>{");
        sb.append(ed).append("}) ").append(" and d.FIsQuantityUnCtrl=0 and m.fbasestatus <> -3");
        sb.append(" group by d.FMaterialID,d.FStorageOrgUnitID");
        sb.append(" union all ");
        sb.append("select d.FMaterialID,d.FStorageOrgUnitID,0 as FBeginQty");
        sb.append(",TO_DECIMAL(sum(TO_DECIMAL(d.FTotalReceiptBaseQty,17,4)),17,4) as FPurQty,0 as FInWarehsQty,0 as FIssueQty,");
        sb.append("sum(TO_DECIMAL(TO_DECIMAL(TO_DECIMAL(d.FTotalReceiptQty*");
        sb.append("d.FActualPrice,17,4)*(1+d.FTaxRate/100),17,4)*");
        sb.append(rate).append(",17,").append(this.precision).append(")+");
        sb.append(expense);
        sb.append(") as FTaxAmount");
        sb.append(" from T_SM_PurOrderEntry d");
        sb.append(" inner join T_SM_PurOrder m on m.FID=d.FParentID");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
        }
        sb.append(" LEFT OUTER JOIN T_SM_PurOrderExpenseEntry exp ON d.fid=exp.fpurorderentryid ");
        sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sb.append(" on d.FStorageOrgUnitID = storage.fid ");
        sb.append(" where 1=1 ");
        sb.append(this.getBizWhere(params));
        sb.append(" and d.FCloseDate>={").append(bd).append("}");
        sb.append("  and d.FCloseDate<={").append(ed).append("} and m.fbasestatus <> -3");
        sb.append(" group by d.FMaterialID,d.FStorageOrgUnitID");
        sb.append(" union all ");
        sb.append("select d.FMaterialID,d.FStorageOrgUnitID,0 as FBeginQty,");
        sb.append(" sum(case when d.FBaseQty>d.FTotalReceiptBaseQty then ");
        sb.append("d.FBaseQty else d.FTotalReceiptBaseQty end) as FPurQty");
        sb.append(",0 as FInWarehsQty,0 as FIssueQty,");
        sb.append("sum(case when d.FBaseQty>d.FTotalReceiptBaseQty then (TO_DECIMAL(d.FTaxAmount*");
        sb.append(rate).append(",17,").append(this.precision);
        sb.append(")+d.FTotalExpense)");
        sb.append(" else (TO_DECIMAL(TO_DECIMAL(TO_DECIMAL(d.FTotalReceiptBaseQty*d.FActualPrice,17,4)*(1+d.FTaxRate/100),17,4)*");
        sb.append(rate).append(",17,").append(this.precision);
        sb.append(")+");
        sb.append(expense);
        sb.append(")").append(" end) as FTaxAmount");
        sb.append(" from T_SM_PurOrderEntry d");
        sb.append(" inner join T_SM_PurOrder m on m.FID=d.FParentID");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
        }
        sb.append(" LEFT OUTER JOIN T_SM_PurOrderExpenseEntry exp ON d.fid=exp.fpurorderentryid ");
        sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sb.append(" on d.FStorageOrgUnitID = storage.fid ");
        sb.append(" where 1=1 ");
        sb.append(this.getBizWhere(params));
        sb.append(" and (d.FBaseStatus<6 ").append(" or d.FCloseDate>{");
        sb.append(ed).append("}) ").append(" and d.FIsQuantityUnCtrl=1 and m.fbasestatus <> -3");
        sb.append(" group by d.FMaterialID,d.FStorageOrgUnitID");
        return sb.toString();
    }

    private String getIssueSQL(RptParams params, String billType, String storageORGTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        String billTable = InvCommonUtils.getBillTableName((String)billType);
        String billTableEntry = InvCommonUtils.getBillEntryTableName((String)billType);
        sb.append("select d.FMaterialID,m.FStorageOrgUnitID,0 as FBeginQty,0 as FPurQty");
        sb.append(",0 as FInWarehsQty,sum(d.FBaseQty) as FIssueQty,0 as FTaxAmount from ");
        sb.append(billTableEntry);
        sb.append(" d inner join ");
        sb.append(billTable);
        sb.append(" m on m.FID=d.FParentID ");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
        }
        sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sb.append(" on m.FStorageOrgUnitID = storage.fid ");
        sb.append(" where 1=1 ");
        sb.append(this.getBizWhere(params));
        sb.append(" group by d.FMaterialID,m.FStorageOrgUnitID");
        return sb.toString();
    }

    private String getSummarySQL(RptParams params, String storageORGTempTable) throws EASBizException, BOSException {
        String sql;
        int i;
        StringBuffer sb = new StringBuffer();
        StringBuffer sbTemp = new StringBuffer();
        sbTemp.append(" insert into ");
        sbTemp.append(params.getString("tempTable"));
        sbTemp.append(" select s.FMaterialID,s.FStorageOrgUnitID, sum(FBeginQty)");
        sbTemp.append(", sum(FPurQty),sum(FInWarehsQty), sum(FIssueQty),");
        sbTemp.append("'");
        sbTemp.append(this.baseCurrencyName);
        sbTemp.append("',case when sum(FPurQty)>0 then DECIMAL(sum(FTaxAmount),17,4)/DECIMAL(sum(FPurQty),21,8)");
        sbTemp.append(" else 0 end ");
        sbTemp.append(" from (");
        sb.append(sbTemp.toString());
        sbTemp.setLength(0);
        String periodBeginSQL = this.getPeriodBeginSQL(params, storageORGTempTable);
        if (periodBeginSQL != null && !"".equals(periodBeginSQL)) {
            sbTemp.append(periodBeginSQL).append(" union all ");
        }
        String initInvSQL = this.getInitInvSQL(params, storageORGTempTable);
        sbTemp.append(initInvSQL).append(" union all ");
        for (i = 0; i < RECEIVEBILLS.length; ++i) {
            sql = this.getUpdateBeginSQL(params, RECEIVEBILLS[i], storageORGTempTable);
            if (sql == null || "".equals(sql)) continue;
            sbTemp.append(sql).append(" union all ");
        }
        sb.append(sbTemp.toString());
        sbTemp.setLength(0);
        sbTemp.append(this.getInWarehsSQL(params, storageORGTempTable)).append(" union all ");
        for (i = 0; i < ISSUEBILLS.length; ++i) {
            sql = this.getUpdateBeginSQL(params, ISSUEBILLS[i], storageORGTempTable);
            if (sql == null || "".equals(sql)) continue;
            sbTemp.append(sql).append(" union all ");
        }
        sb.append(sbTemp.toString());
        sbTemp.setLength(0);
        String onhandSQL = this.getOnhandSQL(params, storageORGTempTable);
        sbTemp.append(onhandSQL).append(" union all ");
        for (int i2 = 0; i2 < ISSUEBILLS.length; ++i2) {
            sbTemp.append(this.getIssueSQL(params, ISSUEBILLS[i2], storageORGTempTable)).append(" union all ");
        }
        String purchaseSQL = this.getPurchaseSQL(params, storageORGTempTable);
        sbTemp.append(purchaseSQL);
        sb.append(sbTemp.toString());
        sbTemp.setLength(0);
        sbTemp.append(" ) s ");
        sbTemp.append(" inner join T_BD_Material m on m.FID=s.FMaterialID");
        sbTemp.append(" group by s.FMaterialID,m.FNumber,s.FStorageOrgUnitID");
        sbTemp.append(" order by m.FNumber");
        sb.append(sbTemp.toString());
        return sb.toString();
    }

    private String getWhere(RptParams params) {
        String materialTo = params.getString("MaterialTo") == null ? null : params.getString("MaterialTo");
        String mgFrom = params.getString("MaterialGroupFrom") == null ? null : params.getString("MaterialGroupFrom");
        String mgTo = params.getObject("MaterialGroupTo") == null ? null : params.getString("MaterialGroupTo");
        StringBuffer sb = new StringBuffer();
        if (params.getObject("MaterialFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("MaterialFrom"));
            if (numArray[0] != null) {
                sb.append(" and mat.FNumber >='").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                sb.append(" and mat.FNumber in (").append(numArray[1]).append(")");
            }
        }
        if (materialTo != null) {
            sb.append(" and mat.FNumber <='").append(materialTo).append("'");
        }
        if (mgFrom != null) {
            sb.append(" and mg.FNumber >='").append(mgFrom).append("'");
        }
        if (mgTo != null) {
            sb.append(" and mg.FNumber <='").append(mgTo).append("'");
        }
        return sb.toString();
    }

    private String getBizWhere(RptParams params) {
        StringBuffer sb = new StringBuffer();
        String bd = params.getString("dateStart");
        String ed = params.getString("dateEnd");
        sb.append(this.getWhere(params));
        sb.append(" and m.FAuditTime >= {").append(bd).append("} and m.FAuditTime <={").append(ed).append("} ");
        return sb.toString();
    }

    private String getPeriodWhere(RptParams params) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String bd = params.getString("dateStart");
        String pd = df.format((Date)params.getObject(this.periodDateStr));
        sb.append(" m.FAuditTime >= {").append(pd).append("} and m.FAuditTime <{").append(bd).append("} ");
        return sb.toString();
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, null, true);
    }

    private String getOnhandSQL(RptParams params, String storageORGTempTable) {
        StringBuffer sb = new StringBuffer();
        String bd = params.getString("dateStart");
        sb.append("select d.FMaterialID,d.FStorageOrgUnitID,").append("sum(case when d.FBaseQty-isnull(d.FtotalReceiptBaseQty,0)>0 then d.FBaseQty-isnull(d.FtotalReceiptBaseQty,0) else 0 end) as FBeginQty,").append("0 as FPurQty,0 as FInWarehsQty,0 as FIssueQty,0 as FTaxAmount").append(" from T_SM_PurOrderEntry d").append(" inner join T_SM_PurOrder m on m.FID=d.FParentID").append(" inner join T_BD_Material mat on mat.FID=d.FMaterialID").append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ").append(" inner join ").append(storageORGTempTable).append(" storage ").append(" on d.FStorageOrgUnitID = storage.fid ").append(" where ").append(" m.FAuditTime <{").append(bd).append("} ").append(" and m.fbasestatus <>-3").append(this.getWhere(params)).append(" and (d.FBaseStatus in (4,-2) or d.FCloseDate>={").append(bd).append("})").append(" group by d.FMaterialID,d.FStorageOrgUnitID");
        return sb.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  fid from " + param.getString("tempTable") + " s inner join T_BD_Material m on s.FMaterialID=m.FID where flevel=1 order by m.FNumber";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    protected RptParams _getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String orgTempTable = params.getString("StorageORGTempTable");
        String TempTable = params.getString("tempTable");
        String baseCurrencyName = params.getString("baseCurrencyName");
        String subWhere = "";
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        boolean ckExpendByStorageOrgUnit = params.getBoolean("ckExpendByStorageOrgUnit");
        if (first) {
            subWhere = ckExpendByStorageOrgUnit ? " 1 = 1 " : " org.flevel = 1 ";
        } else {
            StringBuffer fid = new StringBuffer("tem.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                subWhere = subWhere + " \r\n and mat.FShortName >='" + shortNameFrom.trim() + "' ";
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                subWhere = subWhere + " \r\n and mat.FShortName <='" + shortNameTo.trim() + "' ";
            }
        }
        String sql = "select mat.FNumber AS MATERIAL_NUMBER,mat.FName_" + ctx.getLocale().getLanguage() + " AS MATERIAL_NAME,";
        if (ckBxShowMShortName) {
            sql = sql + " mat.FShortName AS MATERIAL_SHORTNAME,";
        }
        sql = sql + "mat.FModel as Material_FModel,mg.FName_" + ctx.getLocale().getLanguage() + " AS MATERIALGROUP_NAME,org.fname_" + ctx.getLocale().getLanguage() + " as STORAGEORG_NAME,unit.FName_" + ctx.getLocale().getLanguage() + " AS UNIT_NAME,tem.FBeginQty as BEGINQTY,tem.FPurQty AS FPurQty ,tem.FInWarehsQty AS FInWarehsQty,tem.FIssueQty AS ISSUEQTY,tem.FBeginQty+tem.FPurQty-tem.FIssueQty AS fInCurrent,N'" + baseCurrencyName + "' AS CURRENCY,tem.FPrice,tem.FMaterialID as FMaterialID,tem.FStorageOrgUnitID as FStorageOrgUnitID,org.fisleaf as STORAGEORG_ISLEAF,org.flevel as STORAGEORG_LEVEL,org.fparentid AS STORAGEORG_PARENTID from " + TempTable + " tem inner join " + orgTempTable + " org on tem.FStorageOrgUnitID = org.fid  inner join T_BD_Material mat on tem.FMaterialID = mat.FID  LEFT OUTER JOIN T_BD_MaterialGroup mg   ON mat.FMaterialGroupID = mg.FID  INNER JOIN T_BD_MeasureUnit AS UNIT ON mat.FBaseUnit = UNIT.FID where " + subWhere + " order by mat.FNumber,org.flevel,org.fisleaf ";
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    @Override
    protected int _check_Currency_unique(Context ctx, RptParams params) throws BOSException, EASBizException {
        Object[] storageOrg = (Object[])params.getObject("StorageOrg");
        String[] fid = new String[storageOrg.length];
        int n = storageOrg.length;
        for (int i = 0; i < n; ++i) {
            fid[i] = ((FullOrgUnitInfo)storageOrg[i]).get("id").toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select o.FBaseCurrencyID ").append(" from t_org_storage storage ").append(" inner join T_ORG_UnitRelation r on storage.FID=r.FFromUnitID ").append(" inner join T_ORG_TypeRelation t on r.FTypeRelationID=t.FID ").append(" inner join T_ORG_Company o on r.FToUnitID=o.FID ").append(" where  t.FFromType=4 and t.FToType=1 ").append(" and storage.FID in ( ");
        int n2 = fid.length;
        for (int i = 0; i < n2; ++i) {
            if (i == n2 - 1) {
                sql.append("'").append(fid[i].toString()).append("'");
                continue;
            }
            sql.append("'").append(fid[i].toString()).append("',");
        }
        sql.append(")").append(" group by o.FBaseCurrencyID ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        if (rs.getRowCount() > 1) {
            return -1;
        }
        sql = new StringBuffer();
        sql.append(" select o.FAccountPeriodID ").append(" from t_org_storage storage ").append(" inner join T_ORG_UnitRelation r on storage.FID=r.FFromUnitID ").append(" inner join T_ORG_TypeRelation t on r.FTypeRelationID=t.FID ").append(" inner join T_ORG_Company o on r.FToUnitID=o.FID ").append(" where  t.FFromType=4 and t.FToType=1 ").append(" and storage.FID in ( ");
        int n3 = fid.length;
        for (int i = 0; i < n3; ++i) {
            if (i == n3 - 1) {
                sql.append("'").append(fid[i].toString()).append("'");
                continue;
            }
            sql.append("'").append(fid[i].toString()).append("',");
        }
        sql.append(")").append(" group by o.FAccountPeriodID ");
        rs = this.executeQuery(sql.toString(), null, ctx);
        if (rs.getRowCount() > 1) {
            return -2;
        }
        return 0;
    }

    private String getInitInvSQL(RptParams params, String storageORGTempTable) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String ed = params.getString("dateEnd");
        Date pDate = (Date)params.getObject(this.periodDateStr);
        String pd = df.format(pDate) + " 00:00:00";
        sb.append("select d.FMaterialID,m.FStorageOrgUnitID,sum(d.FBaseQty) as FBeginQty");
        sb.append(", 0 as FPurQty,0 as FInWarehsQty,0 as FIssueQty,0 as FTaxAmount from ");
        sb.append("T_IM_InventoryInitBill m ");
        sb.append("inner join T_IM_InventoryInitEntry d on m.FID=d.FParentID ");
        sb.append("inner join t_db_soaccreditwh wh ");
        sb.append("on wh.FStorageOrgID=m.FStorageOrgUnitID and wh.FWarehouseID=d.FWarehouseID");
        if (params.getObject("MaterialGroupFrom") != null || params.getObject("MaterialGroupTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
            sb.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mg.FID=mat.FMaterialGroupID ");
        } else if (params.getObject("MaterialFrom") != null || params.getObject("MaterialTo") != null) {
            sb.append(" inner join T_BD_Material mat  on d.FMaterialID=mat.FID ");
        }
        sb.append(" inner join ").append(storageORGTempTable).append(" storage ");
        sb.append(" on m.FStorageOrgUnitID = storage.fid ");
        sb.append(" where m.FBizDate>={");
        sb.append(pd);
        sb.append("} ");
        sb.append("and m.FBizDate<{");
        sb.append(ed);
        sb.append("} ");
        sb.append("and wh.FIsStarted=1 ");
        sb.append(this.getWhere(params));
        sb.append(" group by d.FMaterialID,m.FStorageOrgUnitID");
        return sb.toString();
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";" + pattern + ";";
        return pattern;
    }
}

