/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.app.AbstractPurContractTrackRptFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class PurContractTrackRptFacadeControllerBean
extends AbstractPurContractTrackRptFacadeControllerBean {
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private static final List<String> DATE_COLUMN = Arrays.asList("ContractBizDate", "PayDate", "ContractDeliveryDate");
    private static final List<String> NUMBER_COLUMN = Arrays.asList("PayAmount", "ContractQty", "ContractEntryTaxAmount", "ContractTotalReceiveAmount", "OrderEntryQty", "OrderEntryQtyUnit", "OrderEntryTaxAmount", "TotalPurReceivalQty", "TotalInWarehsQty", "OrderUnrecQty", "TotalOtherBillQty", "TotalOtherBillAmount", "TotalReqPayAmt", "TotalPaymentBillQty", "ContractTotalReqPayAmt");
    private static final List<String> HIDE_COLUMN = Arrays.asList("MaterialGroupNum", "MaterialGroupName");
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String tempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        this.buildOrgTempTable(ctx, orgUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + params.getString("TempTableName");
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("TempTableName", params.getString("TempTableName"));
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("OrgTempTable", params.getString("OrgTempTable"));
        return result;
    }

    private void buildOrgTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        String locLan = ctx.getLocale().getLanguage();
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table orgTempTable(");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("OrgTempTable");
            params.setString("OrgTempTable", tableName);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] orgs = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[orgs.length];
        String tempOrgTable = params.getString("OrgTempTable");
        int n = orgs.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)orgs[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)orgs[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)orgs[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)orgs[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)orgs[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + tempOrgTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sql);
            params.remove("TempTableName");
            params.setString("TempTableName", tableName);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, true);
        String link = sbLink.toString();
        String sumTempTbName = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        sql = this.getCreatSumTempTbSql(sumTempTbName);
        try {
            String tempSumTempTbName = pool.createTempTable(sql);
            params.remove("SumTempTbName");
            params.setString("SumTempTbName", tempSumTempTbName);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        String inserSumTempTbSql = this.getInsertSumTempTb(params, params.getString("SumTempTbName"), whereCls, link);
        this.executeUpdate(inserSumTempTbSql, null, ctx);
        sql = this.getAllSQL(params, params.getString("TempTableName"), params.getString("SumTempTbName"));
        this.executeUpdate(sql, null, ctx);
        sql = this.getAllSQL2(params, params.getString("TempTableName"), params.getString("SumTempTbName"));
        this.executeUpdate(sql, null, ctx);
        sql = this.getAllSQL3(params, params.getString("TempTableName"), params.getString("SumTempTbName"));
        this.executeUpdate(sql, null, ctx);
        sql = this.insertPayment(params.getString("TempTableName"));
        this.executeUpdate(sql, null, ctx);
        sql = this.getAddSmallSumRowSQL(params, params.getString("TempTableName"), params.getString("SumTempTbName"));
        String sql2 = sql.substring(0, sql.indexOf("UPDATE"));
        this.executeUpdate(sql2, null, ctx);
        sql2 = sql.substring(sql.indexOf("UPDATE"));
        this.executeUpdate(sql2, null, ctx);
        sql = this.getAddSumRowSQL(params, params.getString("TempTableName"), params.getString("SumTempTbName"));
        this.executeUpdate(sql, null, ctx);
    }

    private String insertPayment(String tempTable) {
        StringBuffer selectSQL = new StringBuffer();
        selectSQL.append("(select FParentID FContractID,sum(FPayAmount) FPayAmount,max(FPayDate) FPayDate").append("\r\n").append(" from T_SM_PurContractPayment").append(" where FParentID in (").append("\r\n").append(" select FContractID from ").append(tempTable).append(")").append(" group by FParentID)");
        StringBuffer updateSQL = new StringBuffer();
        updateSQL.append("update ").append(tempTable).append(" t1 set(FPayDate,FPayAmount) = ").append("\r\n").append("(select FPayDate,FPayAmount from ").append("\r\n").append(selectSQL.toString()).append(" t2").append("\r\n").append("where t1.fContractID = t2.fContractID)");
        return updateSQL.toString();
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TEMPNAME_TT(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FContractID Varchar(44) \r\n");
        sql.append(",FContractNumber Varchar(80) \r\n");
        sql.append(",FContractEntryId Varchar(44) \r\n");
        sql.append(",FBizDate DateTime \r\n");
        sql.append(",FPayDate DateTime \r\n");
        sql.append(",FPayAmount Decimal(17,4) \r\n");
        sql.append(",FSeq INT \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FBaseStatus int \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FPurOrgUnitID Varchar(44)\r\n");
        sql.append(",FCurrencyID Varchar(44)\r\n");
        sql.append(",FExchangeRate  Decimal(28,10)\r\n");
        sql.append(",FMaterialGroupID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FContractQty  Decimal(28,10)\r\n");
        sql.append(",FContractTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FContractTotalReqPayAmt  Decimal(17,4)\r\n");
        sql.append(",FContractTotalReceiveAmount  Decimal(17,4)\r\n");
        sql.append(",FOrderNumber Varchar(80) \r\n");
        sql.append(",FOrderStatus int \r\n");
        sql.append(",FOrderUnitID Varchar(44)\r\n");
        sql.append(",FOrderQty  Decimal(28,10)\r\n");
        sql.append(",FOrderTaxAmount  Decimal(17,4)\r\n");
        sql.append(",FTotalPurReceivalQty  Decimal(28,10)\r\n");
        sql.append(",TotalInWarehsQty  Decimal(28,10)\r\n");
        sql.append(",FOrderUnRecQty  Decimal(28,10)\r\n");
        sql.append(",TotalOtherBillQty  Decimal(28,10)\r\n");
        sql.append(",TotalOtherBillAmount  Decimal(28,10)\r\n");
        sql.append(",TotalReqPayAmt  Decimal(28,10)\r\n");
        sql.append(",TotalPaymentBillQty  Decimal(17,4)\r\n");
        sql.append(",Flag  int \r\n");
        sql.append(",FSortField varchar(84) \r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getCreatSumTempTbSql(String tempTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table ");
        sb.append(" TEMPNAME_TT");
        sb.append(" (fid varchar(44),");
        sb.append("fentryid varchar(44),");
        sb.append("ftotalPurqty decimal (28, 10),");
        sb.append("ftotalissueqty decimal (28, 10),");
        sb.append("ftotalotherqty decimal (28, 10),");
        sb.append("ftotalotherAmount decimal (28, 10),");
        sb.append("ftotalamount decimal (28, 10))");
        return sb.toString();
    }

    private String getWhereCls(RptParams params, StringBuffer purBuffer, Boolean hasOrder) throws EASBizException, BOSException {
        String[] numArray;
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append(" PurContract.FBizDate").append("  >= {").append(bd).append("} and ").append("PurContract.FBizDate").append(" <= {").append(ed).append("}");
        queryStr.append(" and PurContract.fbasestatus IN (-2,4,6,7,10)");
        if (hasOrder.booleanValue()) {
            queryStr.append(" and (OrderEntry.fbasestatus is null or (OrderEntry.fbasestatus is not null and OrderEntry.fbasestatus IN (");
            String orderStatus = this.splitByComma((String[])params.getObject("baseStatus"));
            if (orderStatus != null && orderStatus.indexOf("4") > -1) {
                orderStatus = orderStatus + ",7,-2,6 ";
            }
            queryStr.append(orderStatus).append("))) ");
        }
        String deliveryDate1 = params.getString("deliveryDateStart");
        String deliveryDate2 = params.getString("deliveryDateEnd");
        if (deliveryDate1 != null) {
            queryStr.append("\r\n and ");
            queryStr.append("entry.FDeliveryDate  >= {" + deliveryDate1 + "} ");
        }
        if (deliveryDate2 != null) {
            queryStr.append(" and entry.FDeliveryDate <= {" + deliveryDate2 + " }");
        }
        if (params.getString("PurContractFrom") != null) {
            queryStr.append(" and PurContract.FNumber >= '");
            queryStr.append(params.getString("PurContractFrom"));
            queryStr.append("'");
        }
        if (params.getString("PurContractTo") != null) {
            queryStr.append(" and PurContract.FNumber <= '");
            queryStr.append(params.getString("PurContractTo"));
            queryStr.append("'");
        }
        if (params.getObject("SupplierFrom") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("SupplierFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and Supplier.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and Supplier.FNumber in (").append(numArray[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_SUPPLIER") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = Purcontract.FSupplierID ");
            }
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and Supplier.FNumber <= '");
            queryStr.append(params.getString("SupplierTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = Purcontract.FSupplierID ");
            }
        }
        if (params.getObject("MaterialFrom") != null) {
            numArray = SCMUtil.getF7Numbers((Object)params.getObject("MaterialFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and material.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and material.FNumber in (").append(numArray[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_Material ") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = entry.FMATERIALID ");
            }
        }
        if (params.getString("MaterialTo") != null) {
            queryStr.append(" and material.FNumber <= '");
            queryStr.append(params.getString("MaterialTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Material ") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = entry.FMATERIALID ");
            }
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                if (purBuffer.toString().indexOf("T_BD_Material ") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = entry.FMATERIALID ");
                }
            }
            if (shortNameFrom == null && shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                queryStr.append(" and ( material.FShortName <= '").append(shortNameTo.trim()).append("' or material.FShortName is null ) ");
                if (purBuffer.toString().indexOf("T_BD_Material ") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = entry.FMATERIALID ");
                }
            }
            if (shortNameFrom != null && shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName <= '").append(shortNameTo.trim()).append("' ");
                if (purBuffer.toString().indexOf("T_BD_Material ") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = entry.FMATERIALID ");
                }
            }
        }
        if (params.getObject("MaterialGroupFrom") != null) {
            String[] numArray2 = SCMUtil.getF7Numbers((Object)params.getObject("MaterialGroupFrom"));
            if (numArray2[0] != null) {
                queryStr.append(" and matGroup.FNumber >= '").append(numArray2[0]).append("'");
            } else if (numArray2[1] != null) {
                queryStr.append(" and matGroup.FNumber in (").append(numArray2[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_MaterialGroup") == -1) {
                purBuffer.append("\r\n inner join T_BD_MaterialGroup matGroup ");
                purBuffer.append(" on matGroup.fid = entry.FMATERIALGROUPID ");
            }
        }
        if (params.getString("MaterialGroupTo") != null) {
            queryStr.append(" and matGroup.FNumber <= '");
            queryStr.append(params.getString("MaterialGroupTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_MaterialGroup") == -1) {
                purBuffer.append("\r\n inner join T_BD_MaterialGroup matGroup ");
                purBuffer.append(" on matGroup.fid = entry.FMATERIALGROUPID ");
            }
        }
        if (params.getString("bizTypeFrom") != null) {
            queryStr.append(" and BIZTYPE.FNumber >= '");
            queryStr.append(params.getString("bizTypeFrom"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PurContract.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getString("bizTypeTo") != null) {
            queryStr.append(" and BIZTYPE.FNumber <= '");
            queryStr.append(params.getString("bizTypeTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PurContract.FBizTypeID = BIZTYPE.FID ");
            }
        }
        return queryStr.toString();
    }

    private String getInsertSumTempTb(RptParams params, String tempTable, String whereCls, String link) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tempTable).append("\r\n");
        sb.append(" SELECT fid,fentryid,").append("\r\n");
        sb.append("        Sum(ftotalPurqty) ftotalPurqty,").append("\r\n");
        sb.append("        Sum(ftotalissueqty) ftotalissueqty,").append("\r\n");
        sb.append("        Sum(ftotalotherqty) ftotalotherqty,").append("\r\n");
        sb.append("        Sum(ftotalotherAmount) ftotalotherAmount,").append("\r\n");
        sb.append("        Sum(ftotalamount) ftotalamount").append("\r\n");
        sb.append("FROM (").append("\r\n");
        sb.append(this.getSQLOnShiping(params, whereCls, link)).append("\r\n");
        sb.append(" UNION ALL ").append("\r\n");
        sb.append(this.getSQLOnIssuing(params, whereCls, link)).append("\r\n");
        sb.append(" UNION ALL ").append("\r\n");
        sb.append(this.getSQLOtherBillQty(params, whereCls, link)).append("\r\n");
        sb.append(" UNION ALL ").append("\r\n");
        sb.append(this.getSQLOtherBillAmount(params, whereCls, link)).append("\r\n");
        sb.append(" UNION ALL ").append("\r\n");
        sb.append(this.getSQLOnReceiving(params, whereCls, link)).append("\r\n");
        sb.append(" ) src ").append("GROUP BY fid,").append("\r\n");
        sb.append("         fentryid");
        return sb.toString();
    }

    private String getSQLOnShiping(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        ISNULL(CASE ").append("                              WHEN OrderEntry.funitid = ReceivalEntry.funitid THEN (CASE WHEN PurReceivalBill.fbasestatus = 4 THEN ReceivalEntry.fqty ELSE (ReceivalEntry.fqty - ReceivalEntry.FReverseQty) END) ").append("\r\n").append("                              ELSE ((CASE WHEN PurReceivalBill.fbasestatus = 4 THEN  ReceivalEntry.fbaseqty ELSE (ReceivalEntry.fbaseqty - ReceivalEntry.FReverseBaseQty) END) / unit.fbaseconvsrate) ").append("\r\n").append("                            END,0) ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        0 ftotalotherqty,").append("\r\n").append("                        0 ftotalotherAmount,").append("\r\n").append("                        0 ftotalamount ").append("\r\n").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                        ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n").append("                        ON PurContract.FPurorgunitid = org.fid").append("\r\n").append("                        LEFT OUTER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                        ON (OrderEntry.fsourcebillid = PurContract.fid").append("\r\n").append("                        AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                        ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        LEFT OUTER JOIN T_IM_PurReceivalEntry ReceivalEntry").append("\r\n").append("                        ON (OrderEntry.fparentid = ReceivalEntry.FPurOrderid").append("\r\n").append("                        AND ReceivalEntry.FPurOrderentryid = OrderEntry.fid)").append("\r\n").append("                        INNER JOIN T_IM_PurReceivalBill PurReceivalBill").append("\r\n").append("                        ON PurReceivalBill.fid = ReceivalEntry.fparentid").append("\r\n").append("                        LEFT OUTER JOIN t_bd_multimeasureunit unit ").append("\r\n").append("                        ON (ReceivalEntry.fmaterialid = unit.fmaterialid ").append("\r\n").append("                        AND OrderEntry.funitid = unit.fmeasureunitid) ").append("\r\n").append(link).append("\r\n").append(" WHERE    PurReceivalBill.fbasestatus IN (").append(this.splitByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        return sb.toString();
    }

    private String getSQLOnIssuing(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("SELECT   PurOrder.fid,").append("\r\n").append(" OrderEntry.fid fentryid,").append("\r\n").append(" 0 ftotalPurqty,").append("\r\n").append("ISNULL(CASE ").append("\r\n").append(" WHEN OrderEntry.funitid = InWarehsEntry.funitid THEN InWarehsEntry.fqty ").append("\r\n").append(" ELSE (InWarehsEntry.fbaseqty / unit.fbaseconvsrate) ").append("\r\n").append("END,0) ftotalissueqty,").append("\r\n").append(" 0 ftotalotherqty,").append("\r\n").append(" 0 ftotalotherAmount,").append("\r\n").append(" 0 ftotalamount ").append("\r\n").append(" FROM T_SM_PurContract PurContract").append("\r\n").append(" INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append(" ON PurContract.fid = entry.fparentid").append("\r\n").append(" INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n").append(" ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append(" LEFT OUTER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append(" ON (OrderEntry.fsourcebillid = PurContract.fid").append("\r\n").append(" AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append(" INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append(" ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append(" LEFT OUTER JOIN T_IM_PurInWarehsEntry InWarehsEntry").append("\r\n").append(" ON (OrderEntry.fparentid = InWarehsEntry.FPurOrderid").append("\r\n").append(" AND InWarehsEntry.FPurOrderentryid = OrderEntry.fid)").append("\r\n").append(" INNER JOIN T_IM_PurInWarehsBill PurInWarehsBill").append("\r\n").append(" ON PurInWarehsBill.fid = InWarehsEntry.fparentid").append("\r\n").append(" AND PurInWarehsBill.FIsSysBill = 0 ").append("\r\n").append(" LEFT OUTER JOIN t_bd_multimeasureunit unit").append("\r\n").append(" ON (InWarehsEntry.fmaterialid = unit.fmaterialid").append("\r\n").append(" AND OrderEntry.funitid = unit.fmeasureunitid)").append("\r\n").append(link).append("\r\n").append(" WHERE PurInWarehsBill.fbasestatus IN (").append(this.splitByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        return sb.toString();
    }

    private String getSQLOtherBillQty(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        0 ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        ISNULL(CASE ").append("\r\n").append("                              WHEN OrderEntry.funitid = OtherBillEntry.fmeasureunitid THEN OtherBillEntry.fquantity").append("\r\n").append("                              ELSE (OtherBillEntry.fbaseqty / unit.fbaseconvsrate)").append("\r\n").append("                            END,0) ftotalotherqty,").append("\r\n").append("                        0 ftotalotherAmount,0 ftotalamount").append("\r\n").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                                ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n").append("                        ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append("                        LEFT OUTER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                        ON (OrderEntry.fsourcebillid = PurContract.fid").append("\r\n").append("                        AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                        ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        LEFT OUTER JOIN T_AP_OtherBillEntry OtherBillEntry").append("\r\n").append("                        ON (OrderEntry.fparentid = OtherBillEntry.fcorebillid").append("\r\n").append("                        AND OtherBillEntry.fcorebillentryid = OrderEntry.fid)").append("\r\n").append("                        INNER JOIN T_AP_OtherBill OtherBill").append("\r\n").append("                        ON OtherBill.fid = OtherBillEntry.fparentid").append("\r\n").append("                        LEFT OUTER JOIN t_bd_multimeasureunit unit").append("\r\n").append("                        ON (OtherBillEntry.fmaterialid = unit.fmaterialid").append("\r\n").append("                         AND OtherBillEntry.fmeasureunitid = unit.fmeasureunitid)").append("\r\n").append(link).append("\r\n").append("               WHERE    OtherBill.fbillstatus IN (").append(this.transformByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        sb.append(" and (").append("(PurOrder.fIsCentralBalance = 1 and OtherBill.FAsstActID = PurContract.FSupplierID").append(" and OtherBill.FCompanyID = PurContract.FCompanyOrgUnitID)").append(" or PurOrder.fIsCentralBalance = 0").append(")");
        return sb.toString();
    }

    private String getSQLOtherBillAmount(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        0 ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        0 ftotalotherqty,").append("\r\n").append("                        ISNULL(CASE").append("\r\n").append("                              WHEN PurOrder.fcurrencyid = OtherBill.fcurrencyid THEN OtherBillEntry.FRecievePayAmount").append("\r\n").append("                              ELSE (OtherBillEntry.FRecievePayAmountLocal * er.fconvertrate)").append("\r\n").append("                            END,0) ftotalotherAmount,").append("                        0 ftotalamount").append("\r\n").append("\r\n").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                                ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append("\r\n").append("                                ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append("                        LEFT OUTER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                                ON (OrderEntry.fsourcebillid = PurContract.fid").append("\r\n").append("                                    AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                                ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        INNER JOIN T_AP_OtherBillEntry OtherBillEntry ").append("\r\n").append("                                ON (OtherBillEntry.fcorebillentryid = OrderEntry.fid").append("\r\n").append("                                OR OtherBillEntry.fsourcebillentryid = OrderEntry.fid)").append("\r\n").append("                        INNER JOIN T_AP_OtherBill OtherBill ").append("\r\n").append("                                ON OtherBill.fid = OtherBillEntry.FParentID").append("\r\n").append("                        LEFT JOIN t_bd_exchangeaux ea").append("\r\n").append("                                ON (ea.fsourcecurrencyid = OtherBill.fcurrencyid").append("\r\n").append("                                    AND ea.ftargetcurrencyid = PurOrder.fcurrencyid)").append("\r\n").append("                        LEFT JOIN t_bd_exchangerate er").append("\r\n").append("                                ON ea.fexchangetableid = er.fid").append("\r\n").append(link).append("\r\n").append("               WHERE    OtherBill.fbillstatus IN (").append(this.transformByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        sb.append(" and (").append("(PurOrder.fIsCentralBalance = 1 and OtherBill.FAsstActID = PurContract.FSupplierID").append(" and OtherBill.FCompanyID = PurContract.FCompanyOrgUnitID)").append(" or PurOrder.fIsCentralBalance = 0").append(")");
        return sb.toString();
    }

    private String getSQLOnReceiving(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        0 ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        0 ftotalotherqty,").append("\r\n").append("                        0 ftotalotherAmount,").append("\r\n").append("                         ISNULL(ISNULL(CASE").append("\r\n").append("                              WHEN PurOrder.fcurrencyid = PaymentBill.fcurrencyid THEN PaymentBillEntry.factualamt").append("\r\n").append("                              ELSE (PaymentBillEntry.factuallocamt * er.fconvertrate)").append("\r\n").append("                            END, OrderEntry.FTotalPaidAmount),0) ftotalamount").append("\r\n").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                                ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append("\r\n").append("                                ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append("                        LEFT OUTER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                                ON (OrderEntry.fsourcebillid = PurContract.fid").append("\r\n").append("                                    AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                                ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        LEFT JOIN T_CAS_PaymentBillentry PaymentBillEntry").append("\r\n").append("                                ON (PaymentBillEntry.fcorebillentryid = OrderEntry.fid").append("\r\n").append("                                OR PaymentBillEntry.fsourcebillentryid = OrderEntry.fid)").append("\r\n").append("                        LEFT JOIN T_CAS_PaymentBill PaymentBill").append("\r\n").append("                                ON PaymentBill.fid = PaymentBillEntry.FPaymentBillID and PaymentBill.FBillStatus IN (").append(this.transformByComma2((String[])params.getObject("baseStatus"))).append(") ").append("\r\n").append("                        LEFT JOIN t_bd_exchangeaux ea").append("\r\n").append("                                ON (ea.fsourcecurrencyid = PaymentBill.fcurrencyid").append("\r\n").append("                                    AND ea.ftargetcurrencyid = PurOrder.fcurrencyid)").append("\r\n").append("                        LEFT JOIN t_bd_exchangerate er").append("\r\n").append("                                ON ea.fexchangetableid = er.fid").append("\r\n").append(link).append("\r\n").append("               WHERE  ").append("\r\n").append(whereCls);
        sb.append(" and (").append("(PurOrder.fIsCentralBalance = 1 and PaymentBill.FPayeeId = PurContract.FSupplierID").append(" and PaymentBill.FCompanyID = PurContract.FCompanyOrgUnitID)").append(" or PurOrder.fIsCentralBalance = 0").append(")");
        return sb.toString();
    }

    private String getSQLOnReceiving2(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurContract.fid,").append("\r\n").append("                        entry.fid fentryid,").append("\r\n").append("                        0 ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        0 ftotalotherqty,").append("\r\n").append("                        0 ftotalotherAmount,").append("\r\n").append("                        ISNULL(PaymentBillEntry.factualamt,0) ftotalamount").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                                ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append("\r\n").append("                                ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append("                        INNER JOIN T_CAS_PaymentBillentry PaymentBillEntry").append("\r\n").append("                                ON PaymentBillEntry.fsourcebillentryid = entry.fid").append("\r\n").append("                        INNER JOIN T_CAS_PaymentBill PaymentBill").append("\r\n").append("                                ON PaymentBill.fid = PaymentBillEntry.FPaymentBillID").append("\r\n").append(link).append("\r\n").append("               WHERE    PaymentBill.fbillstatus IN (").append(this.transformByComma2((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        sb.append(" and (").append("(PaymentBill.FPayeeId = PurContract.FSupplierID").append(" and PaymentBill.FCompanyID = PurContract.FCompanyOrgUnitID)").append(")");
        return sb.toString();
    }

    private String getSQLOnReceiving3(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurContract.fid,").append("\r\n").append("                        entry.fid fentryid,").append("\r\n").append("                        0 ftotalPurqty,").append("\r\n").append("                        0 ftotalissueqty,").append("\r\n").append("                        0 ftotalotherqty,").append("\r\n").append("                        0 ftotalotherAmount,").append("\r\n").append("                        ISNULL(PaymentBillEntry.factualamt,0) ftotalamount").append("\r\n").append("               FROM     T_SM_PurContract PurContract").append("\r\n").append("                        INNER JOIN T_SM_PurContractEntry entry").append("\r\n").append("                                ON PurContract.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append("                        org ").append("\r\n").append("                                ON PurContract.FPurOrgUnitID = org.fid").append("\r\n").append("                        LEFT OUTER JOIN t_ap_payrequestbillEntry payReqEntry").append("\r\n").append("                                ON (payReqEntry.fsourcebillid = PurContract.fid").append("\r\n").append("                                    AND payReqEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        LEFT JOIN t_ap_payrequestbill payReq").append("\r\n").append("                                ON payReqEntry.fparentid = payReq.fid").append("\r\n").append("                        left JOIN T_CAS_PaymentBillentry PaymentBillEntry").append("\r\n").append("                                ON PaymentBillEntry.fsourcebillentryid = payReqEntry.fid").append("                        LEFT JOIN T_CAS_PaymentBill PaymentBill").append("\r\n").append("                                ON PaymentBill.fid = PaymentBillEntry.FPaymentBillID").append("\r\n").append(link).append("\r\n").append("               WHERE    ").append("\r\n").append(whereCls);
        sb.append(" and (").append("( PaymentBill.fbillstatus IN (").append(this.transformByComma2((String[])params.getObject("baseStatus"))).append(") and ").append("PaymentBill.FPayeeId = PurContract.FSupplierID").append(" and PaymentBill.FCompanyID = PurContract.FCompanyOrgUnitID)").append(" or payReq.fbillstatus IN (").append(this.transformByComma((String[])params.getObject("baseStatus"))).append(") ").append(")");
        return sb.toString();
    }

    public String splitByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (sb.length() > 0) {
                    sb.append(",");
                }
                if (status[i].equals("4")) {
                    sb.append("4,7");
                    continue;
                }
                sb.append(status[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 1 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 2 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 3 ");
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma2(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 10 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 11 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 12 ");
            }
            sb.append(", 15 ");
            return sb.toString();
        }
        return null;
    }

    private String getAllSQL(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, true);
        String link = sbLink.toString();
        sb.append("INSERT INTO ").append(tempTable).append("\r\n");
        sb.append("SELECT Newbosid('88888888'), ").append("\r\n");
        sb.append("Purcontract.fid, ");
        sb.append("Purcontract.fnumber, ");
        sb.append("Entry.fid,");
        sb.append("Purcontract.FBizDate, ");
        sb.append("null, ").append("0, ").append("\r\n");
        sb.append("Entry.fseq, ").append("\r\n");
        sb.append("Entry.fdeliverydate, ").append("\r\n");
        sb.append("Purcontract.fbasestatus, ").append("\r\n");
        sb.append("Purcontract.fbiztypeid, ").append("\r\n");
        sb.append("Purcontract.FSupplierid, ").append("\r\n");
        sb.append("org.fid, ").append("\r\n");
        sb.append("Purcontract.fcurrencyid, ").append("\r\n");
        sb.append("Purcontract.fexchangerate, ").append("\r\n");
        sb.append("Entry.fmaterialGroupid, ").append("\r\n");
        sb.append("Entry.fmaterialid, ").append("\r\n");
        sb.append("Entry.funitid, ").append("\r\n");
        sb.append("Entry.fqty, ").append("\r\n");
        sb.append("Entry.ftaxamount, ").append("\r\n");
        sb.append("ISNULL(Entry.ftotalReqPayAmt,0), ").append("\r\n");
        sb.append("ISNULL(Entry.ftotalPaidAmount,0), ").append("\r\n");
        sb.append("PurOrder.fnumber, ").append("\r\n");
        sb.append("PurOrder.fbasestatus, ").append("\r\n");
        sb.append("OrderEntry.funitid, ").append("\r\n");
        sb.append("OrderEntry.fqty ftotalqty, ").append("\r\n");
        sb.append("OrderEntry.ftaxamount ftaxamount, ").append("\r\n");
        sb.append("ISNULL(datafrom.ftotalPurqty,0), ").append("\r\n");
        sb.append("ISNULL(datafrom.ftotalissueqty,0), ").append("\r\n");
        sb.append("( OrderEntry.fqty - ISNULL(datafrom.ftotalPurqty,0) ), ");
        sb.append("ISNULL(datafrom.ftotalotherqty,0), ");
        sb.append("ISNULL(datafrom.ftotalotherAmount,0), ");
        sb.append("ISNULL(OrderEntry.ftotalReqPayAmt,0), ");
        sb.append("ISNULL(OrderEntry.ftotalPaidAmount,0), ");
        sb.append("100 ,").append("\r\n");
        sb.append("Purcontract.fnumber ").append("\r\n");
        sb.append("FROM   T_SM_Purcontract Purcontract ").append("\r\n");
        sb.append("INNER JOIN T_SM_Purcontractentry Entry ").append("\r\n");
        sb.append("ON Purcontract.fid = Entry.fparentid ").append("\r\n");
        sb.append("INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n");
        sb.append("ON Purcontract.FPurOrgUnitID = org.fid ").append("\r\n");
        sb.append("INNER JOIN T_SM_Purorderentry OrderEntry ").append("\r\n");
        sb.append("ON (OrderEntry.fsourcebillid = Purcontract.fid ");
        sb.append("AND OrderEntry.fsourcebillentryid = Entry.fid) ").append("\r\n");
        sb.append("INNER JOIN T_SM_Purorder PurOrder ").append("\r\n");
        sb.append("ON OrderEntry.fparentid = PurOrder.fid ").append(link).append("\r\n");
        sb.append("LEFT OUTER JOIN ").append(sumTempTable).append(" ").append("datafrom ").append("\r\n");
        sb.append("ON datafrom.fid = PurOrder.fid ");
        sb.append("AND datafrom.fentryid = OrderEntry.fid ").append("\r\n");
        sb.append("WHERE ").append(whereCls);
        return sb.toString();
    }

    private String getAllSQL2(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, false);
        String link = sbLink.toString();
        sb.append("INSERT INTO ").append(tempTable).append("\r\n").append(" SELECT Newbosid('88888888'),").append("\r\n").append("\tPurcontract.fid, ").append("   Purcontract.fnumber,").append("   Entry.fid,").append(" \tPurcontract.FBizDate,").append("null, ").append("0, ").append("\r\n").append("   Entry.fseq,").append("\r\n").append("   Entry.fdeliverydate,").append("\r\n").append("   Purcontract.fbasestatus,").append("\r\n").append("   Purcontract.fbiztypeid,").append("\r\n").append("   Purcontract.FSupplierid,").append("\r\n").append("   org.fid,").append("\r\n").append("   Purcontract.fcurrencyid,").append("\r\n").append("   Purcontract.fexchangerate,").append("\r\n").append("   Entry.fmaterialGroupId,").append("\r\n").append("   Entry.fmaterialid,").append("\r\n").append("   Entry.funitid,").append("\r\n").append("   Entry.fqty,").append("\r\n").append("   Entry.ftaxamount,").append("ISNULL(Entry.ftotalReqPayAmt,0), ").append("\r\n").append("ISNULL(Entry.ftotalPaidAmount,0), ").append("\r\n").append("\r\n").append("   null,").append("\r\n").append("   15,").append("\r\n").append("   null,").append("\r\n").append("   0 ftotalqty,").append("\r\n").append("   0 ftaxamount,").append("\r\n").append("   ISNULL(datafrom.ftotalPurqty,0),").append("\r\n").append("   ISNULL(datafrom.ftotalissueqty,0),").append("\r\n").append("   0 ,").append("   ISNULL(datafrom.ftotalotherqty,0),").append("   ISNULL(datafrom.ftotalotherAmount,0),").append("\tISNULL(Entry.ftotalReqPayAmt,0), ").append("   ISNULL(datafrom.ftotalamount,0), ").append("   100, ").append("Purcontract.fnumber ").append("\r\n").append("FROM   T_SM_Purcontract Purcontract ").append("   INNER JOIN T_SM_Purcontractentry Entry ").append("       ON Purcontract.fid = Entry.fparentid ").append("   INNER JOIN ").append(params.getString("OrgTempTable")).append("   org ").append("       ON Purcontract.FPurOrgUnitID = org.fid ").append(link).append("   inner JOIN ").append(sumTempTable).append(" datafrom ").append("   \tON (datafrom.fid = Purcontract.fid ").append("   \tAND datafrom.fentryid = Entry.fid) ").append("WHERE ").append(whereCls);
        return sb.toString();
    }

    private String getAllSQL3(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink, false);
        String link = sbLink.toString();
        sb.append("INSERT INTO ").append(tempTable).append("\r\n").append(" SELECT Newbosid('88888888'),").append("\r\n").append("\tPurcontract.fid, ").append("   Purcontract.fnumber,").append("   Entry.fid,").append(" \tPurcontract.FBizDate,").append("null, ").append("0, ").append("\r\n").append("   Entry.fseq,").append("\r\n").append("   Entry.fdeliverydate,").append("\r\n").append("   Purcontract.fbasestatus,").append("\r\n").append("   Purcontract.fbiztypeid,").append("\r\n").append("   Purcontract.FSupplierid,").append("\r\n").append("   org.fid,").append("\r\n").append("   Purcontract.fcurrencyid,").append("\r\n").append("   Purcontract.fexchangerate,").append("\r\n").append("   Entry.fmaterialGroupId,").append("\r\n").append("   Entry.fmaterialid,").append("\r\n").append("   Entry.funitid,").append("\r\n").append("   Entry.fqty,").append("\r\n").append("   Entry.ftaxamount,").append("ISNULL(Entry.ftotalReqPayAmt,0), ").append("\r\n").append("ISNULL(Entry.ftotalPaidAmount,0), ").append("\r\n").append("\r\n").append("   null,").append("\r\n").append("   15,").append("\r\n").append("   null,").append("\r\n").append("   0 ftotalqty,").append("\r\n").append("   0 ftaxamount,").append("\r\n").append("   0,").append("\r\n").append("   0,").append("\r\n").append("   0 ,").append("   0 ,").append("   0 ,").append("\t0 ,").append("   0 , ").append("   100, ").append("Purcontract.fnumber ").append("\r\n").append("FROM  ").append("  T_SM_Purcontract Purcontract ").append("   INNER JOIN T_SM_Purcontractentry Entry ").append("       ON Purcontract.fid = Entry.fparentid ").append("   INNER JOIN ").append(params.getString("OrgTempTable")).append("   org ").append("       ON Purcontract.FPurOrgUnitID = org.fid ").append("   LEFT OUTER JOIN T_SM_Purorderentry OrderEntry ").append("       ON OrderEntry.fsourcebillentryid = Entry.fid ").append("   LEFT OUTER JOIN T_SM_Purorder PurOrder ").append("       ON OrderEntry.fparentid = PurOrder.fid").append("   LEFT OUTER JOIN ").append(sumTempTable).append(" datafrom1 ").append("   \tON datafrom1.fid = Purcontract.fid ").append("   LEFT OUTER JOIN ").append(sumTempTable).append(" datafrom2 ").append("   \tON datafrom2.fentryid = OrderEntry.fid ").append(link).append("WHERE ").append(whereCls).append("   And datafrom1.fid is null and datafrom2.fid is null  ").append(" and (purorder.fid is null ").append(" or (OrderEntry.fbasestatus is not null and OrderEntry.fbasestatus not in ( ");
        String orderStatus = this.splitByComma((String[])params.getObject("baseStatus"));
        if (orderStatus != null && (orderStatus = orderStatus + ",-3").indexOf("4") > -1) {
            orderStatus = orderStatus + ",7,-2,6";
        }
        sb.append(orderStatus).append("))) ");
        return sb.toString();
    }

    private String getAddSmallSumRowSQL(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tempTable).append("\r\n (").append(" FID");
        sb.append(",FContractNumber");
        sb.append(",FPayAmount");
        sb.append(",FOrderQty");
        sb.append(",FOrderTaxAmount");
        sb.append(",FTotalPurReceivalQty ");
        sb.append(",TotalInWarehsQty");
        sb.append(",FOrderUnRecQty");
        sb.append(",TotalOtherBillQty");
        sb.append(",TotalOtherBillAmount");
        sb.append(",TotalReqPayAmt ");
        sb.append(",TotalPaymentBillQty ");
        sb.append(",Flag ");
        sb.append(",FSortField ");
        sb.append(") ");
        sb.append("\r\n");
        sb.append(" SELECT Newbosid('88888888')");
        sb.append("\r\n");
        sb.append(",FContractNumber");
        sb.append(",FPayAmount");
        sb.append(",sum(FOrderQty)");
        sb.append(",sum(FOrderTaxAmount)");
        sb.append(",sum(FTotalPurReceivalQty )");
        sb.append(",sum(TotalInWarehsQty)");
        sb.append(",sum(FOrderUnRecQty)");
        sb.append(",sum(TotalOtherBillQty)");
        sb.append(",sum(TotalOtherBillAmount)");
        sb.append(",sum(TotalReqPayAmt) ");
        sb.append(",sum(TotalPaymentBillQty)");
        sb.append(",101");
        sb.append(",FSortField");
        sb.append(" FROM    " + tempTable + " group by FContractNumber,FPayAmount,FSortField;");
        sb.append("\r\n");
        sb.append("UPDATE  ");
        sb.append(tempTable).append("\r\n set (").append("FContractQty,FContractTaxAmount,FContractTotalReqPayAmt,FContractTotalReceiveAmount )=");
        sb.append("\r\n");
        sb.append("(");
        sb.append("\t\t\tSelect FContractQty,FContractTaxAmount,FContractTotalReqPayAmt,FContractTotalReceiveAmount from ");
        sb.append("\t\t\t(");
        sb.append("\t\t\t\tselect FContractNumber,sum(FContractQty) FContractQty,sum(FContractTaxAmount) FContractTaxAmount,");
        sb.append("sum(FContractTotalReqPayAmt) FContractTotalReqPayAmt,sum(FContractTotalReceiveAmount) FContractTotalReceiveAmount From ");
        sb.append("\t\t\t\t(    ");
        sb.append("\t\t\t\t  SELECT Distinct FContractNumber,FSeq,FContractQty,FContractTaxAmount,FContractTotalReqPayAmt,FContractTotalReceiveAmount FROM " + tempTable + " ");
        sb.append("\t\t\t\t) temp__2 ");
        sb.append("\t\t\t\tgroup by temp__2.FContractNumber");
        sb.append("\t\t\t)  temp__3 where temp__3.FContractNumber=" + tempTable + ".FContractNumber and " + tempTable + ".Flag=101 ");
        sb.append("\t)");
        return sb.toString();
    }

    private String getAddSumRowSQL(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tempTable).append("\r\n (").append(" FID");
        sb.append(",FPayAmount");
        sb.append(",FContractQty");
        sb.append(",FContractTaxAmount");
        sb.append(",FContractTotalReqPayAmt");
        sb.append(",FContractTotalReceiveAmount");
        sb.append(",FOrderQty");
        sb.append(",FOrderTaxAmount");
        sb.append(",FTotalPurReceivalQty ");
        sb.append(",TotalInWarehsQty");
        sb.append(",FOrderUnRecQty");
        sb.append(",TotalOtherBillQty");
        sb.append(",TotalOtherBillAmount");
        sb.append(",TotalReqPayAmt ");
        sb.append(",TotalPaymentBillQty ");
        sb.append(",flag ");
        sb.append(",FSortField ");
        sb.append(") ");
        sb.append("\r\n");
        sb.append(" SELECT Newbosid('88888888')");
        sb.append("\r\n");
        sb.append(",sum(FPayAmount)");
        sb.append(",sum(FContractQty)");
        sb.append(",sum(FContractTaxAmount)");
        sb.append(",sum(FContractTotalReqPayAmt)");
        sb.append(",sum(FContractTotalReceiveAmount)");
        sb.append(",sum(FOrderQty)");
        sb.append(",sum(FOrderTaxAmount)");
        sb.append(",sum(FTotalPurReceivalQty )");
        sb.append(",sum(TotalInWarehsQty)");
        sb.append(",sum(FOrderUnRecQty)");
        sb.append(",sum(TotalOtherBillQty)");
        sb.append(",sum(TotalOtherBillAmount)");
        sb.append(",sum(TotalReqPayAmt) ");
        sb.append(",sum(TotalPaymentBillQty)");
        sb.append(",102 ");
        sb.append(",MAX(FContractNumber) ");
        sb.append(" FROM    " + tempTable + " where flag = 101");
        return sb.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("PurContractFrom") != null) {
            sqlParams.setString(count++, params.getString("PurContractFrom"));
        }
        if (params.getString("PurContractTo") != null) {
            sqlParams.setString(count++, params.getString("PurContractFrom"));
        }
        if (params.getString("SupplierTo") != null) {
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
        if (params.getString("MaterialTo") != null) {
            sqlParams.setString(count++, params.getString("MaterialTo"));
        }
        if (params.getString("bizTypeFrom") != null) {
            sqlParams.setString(count++, params.getString("bizTypeFrom"));
        }
        if (params.getString("bizTypeTo") != null) {
            sqlParams.setString(count++, params.getString("bizTypeTo"));
        }
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("ContractNumber", ctx);
        String seq = this.getServerResource("Seq", ctx);
        String deliverydate = this.getServerResource("ContractDeliveryDate", ctx);
        String billStatus = this.getServerResource("BillStatus", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String PurOrgName = this.getServerResource("PurchaseUnit", ctx);
        String currency = this.getServerResource("Currency", ctx);
        String materialGroupNum = this.getServerResource("MaterialGroupNumber", ctx);
        String materialGroupName = this.getServerResource("MaterialGroupName", ctx);
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String baseUnit = this.getServerResource("Unit_PurPricRecord", ctx);
        String qty = this.getServerResource("ContractQty", ctx);
        String contractEntryTaxAmount = this.getServerResource("ContractEntryTaxAmount", ctx);
        String contractTotalReqPayAmt = this.getServerResource("ContractTotalReceiveAmount", ctx);
        String contractTotalReceiveAmount = this.getServerResource("ContractTotalReqPayAmt", ctx);
        String orderNumber = this.getServerResource("OrderNumber", ctx);
        String orderQtyUnit = this.getServerResource("OrderEntryQtyUnit", ctx);
        String orderQty = this.getServerResource("OrderEntryQty", ctx);
        String orderEntryTaxAmount = this.getServerResource("OrderEntryTaxAmount", ctx);
        String totalPurReceivalQty = this.getServerResource("TotalShippingQty", ctx);
        String totalInWarehsQty = this.getServerResource("TotalPostRequisitionQty", ctx);
        String totalReceiveQty = this.getServerResource("TotalInvoicedQty", ctx);
        String totalOtherBillAmount = this.getServerResource("TotalInvoicedAmount", ctx);
        String totalReqPayAmt = this.getServerResource("TotalReqPayAmt", ctx);
        String totalPaymentBillQty = this.getServerResource("TotalReceiveAmount", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        int colNum = ckBxShowMShortName ? 32 : 31;
        Object[][] labels = new Object[1][colNum];
        String[] cols = new String[colNum];
        int m = 0;
        cols[m++] = "ContractNumber";
        cols[m++] = "ContractBizDate";
        cols[m++] = "PayDate";
        cols[m++] = "PayAmount";
        cols[m++] = "ContractDeliveryDate";
        cols[m++] = "BillStatus";
        cols[m++] = "SupplierName";
        cols[m++] = "PurOrg";
        cols[m++] = "Seq";
        cols[m++] = "MaterialGroupNum";
        cols[m++] = "MaterialGroupName";
        cols[m++] = "MaterialNum";
        cols[m++] = "MaterialName";
        if (ckBxShowMShortName) {
            cols[m++] = "MaterialShortName";
        }
        cols[m++] = "MaterialMod";
        cols[m++] = "Unit";
        cols[m++] = "ContractQty";
        cols[m++] = "Currency";
        cols[m++] = "ContractEntryTaxAmount";
        cols[m++] = "ContractTotalReqPayAmt";
        cols[m++] = "ContractTotalReceiveAmount";
        cols[m++] = "OrderNumber";
        cols[m++] = "OrderEntryQty";
        cols[m++] = "OrderEntryQtyUnit";
        cols[m++] = "OrderEntryTaxAmount";
        cols[m++] = "TotalPurReceivalQty";
        cols[m++] = "TotalInWarehsQty";
        cols[m++] = "OrderUnrecQty";
        cols[m++] = "TotalOtherBillQty";
        cols[m++] = "TotalOtherBillAmount";
        cols[m++] = "TotalReqPayAmt";
        cols[m++] = "TotalPaymentBillQty";
        this.setHeaderColumns(header, cols, params);
        m = 0;
        labels[0][m++] = billNum;
        labels[0][m++] = this.getServerResource("ContractBizDate", ctx);
        labels[0][m++] = this.getServerResource("PayDate", ctx);
        labels[0][m++] = this.getServerResource("PayAmount", ctx);
        labels[0][m++] = deliverydate;
        labels[0][m++] = billStatus;
        labels[0][m++] = supplierName;
        labels[0][m++] = PurOrgName;
        labels[0][m++] = seq;
        labels[0][m++] = materialGroupNum;
        labels[0][m++] = materialGroupName;
        labels[0][m++] = materialNum;
        labels[0][m++] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        labels[0][m++] = baseUnit;
        labels[0][m++] = qty;
        labels[0][m++] = currency;
        labels[0][m++] = contractEntryTaxAmount;
        labels[0][m++] = contractTotalReqPayAmt;
        labels[0][m++] = contractTotalReceiveAmount;
        labels[0][m++] = orderNumber;
        labels[0][m++] = orderQty;
        labels[0][m++] = orderQtyUnit;
        labels[0][m++] = orderEntryTaxAmount;
        labels[0][m++] = totalPurReceivalQty;
        labels[0][m++] = totalInWarehsQty;
        labels[0][m++] = this.getServerResource("OrderUnrecQty", ctx);
        labels[0][m++] = totalReceiveQty;
        labels[0][m++] = totalOtherBillAmount;
        labels[0][m++] = totalReqPayAmt;
        labels[0][m++] = totalPaymentBillQty;
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String qtyFormat = RptCellFormatter.getNumberFormat((int)4, (boolean)false);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        for (int i = 0; i < columns.length; ++i) {
            col = new RptTableColumn(columns[i]);
            if (DATE_COLUMN.contains(columns[i])) {
                col.setFormatPattern(dateFormat);
            } else if (NUMBER_COLUMN.contains(columns[i])) {
                col.setFormatPattern(qtyFormat);
                col.setAligment(2);
            } else if (HIDE_COLUMN.contains(columns[i])) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String orderSql = " order by temp.FSortField, temp.Flag, temp.FSeq,temp.FSupplierID,temp.FPurOrgUnitID,temp.FMaterialID";
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + orderSql, null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String querySql(RptParams params, Context ctx) {
        String locLan = ctx.getLocale().getLanguage();
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("TempTableName");
        String orgUnitTempTable = params.getString("OrgTempTable");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        sql.append(" SELECT temp.FcontractNumber,temp.FBizDate,temp.FPayDate,temp.FPayAmount,");
        sql.append("temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",Supplier.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURORG_NAME");
        sql.append(",temp.FSeq,matGroup.fnumber as MATGROUP_NUMBER,matGroup.fname_" + locLan + " as MATGROUP_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER");
        sql.append(",CASE WHEN temp.FMaterialID is NULL THEN").append(" purContractEntry.FMaterialName").append(" ELSE mat.FName_").append(locLan).append(" END").append(" AS MATERIAL_NAME,");
        sql.append(ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "");
        sql.append("CASE WHEN temp.FMaterialID is NULL THEN").append(" purContractEntry.FNoNumMaterialModel").append(" ELSE mat.FModel").append(" END").append(" AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME");
        sql.append("\r\n ,temp.FcontractQty QTY");
        sql.append("\r\n ,CURRENCY.FName_").append(locLan).append(" AS CURRENCY_NAME");
        sql.append("\r\n ,temp.FcontractTaxAmount TaxAmount");
        sql.append("\r\n ,temp.FContractTotalReqPayAmt ContractTotalReqPayAmt");
        sql.append("\r\n ,temp.FContractTotalReceiveAmount ContractTotalReceiveAmount");
        sql.append("\r\n ,FOrderNumber OrderNumber");
        sql.append("\r\n ,temp.ForderQty orderQTY");
        sql.append("\r\n ,UNIT2.FName_").append(locLan).append(" ORDERUNITNAME").append(",temp.ForderTaxAmount").append(",temp.FTotalPurReceivalQty").append(",temp.TotalInWarehsQty").append(",temp.ForderQty-temp.TotalInWarehsQty as  FOrderUnRecQty").append(",temp.TotalOtherBillQty").append(",temp.TotalOtherBillAmount").append(",temp.TotalReqPayAmt").append(",temp.TotalPaymentBillQty").append(" FROM  ").append(tempTable).append(" temp ").append("\r\n LEFT OUTER JOIN ").append(orgUnitTempTable).append(" org ON temp.FPurOrgUnitID = org.FID ").append("\r\n LEFT OUTER JOIN T_SM_PurContractEntry purContractEntry ON temp.FContractEntryId = purContractEntry.fid ").append("\r\n LEFT OUTER JOIN T_BD_Currency CURRENCY on temp.FCurrencyID = CURRENCY.FID ").append("\r\n LEFT OUTER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append("\r\n LEFT OUTER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ").append("\r\n LEFT OUTER JOIN T_BD_MaterialGroup AS matGroup ON temp.FMaterialGroupID = matGroup.FID ").append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit AS UNIT2 ON temp.ForderUnitID = UNIT2.FID ");
        return sql.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        StringBuffer rsList = new StringBuffer();
        rsList.append("select  temp.fid from " + param.getString("TempTableName"));
        rsList.append(" temp LEFT OUTER JOIN " + param.getString("OrgTempTable"));
        rsList.append(" org ON temp.FPurOrgUnitID = org.FID  ");
        rsList.append("\r\n order by temp.FSortField, temp.Flag, temp.FSeq,temp.FSupplierID,temp.FPurOrgUnitID,temp.FMaterialID");
        rsList.append(" asc ");
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere = " ";
        if (!first) {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
            subWhere = subWhere + " order by temp.FSortField, temp.Flag, temp.FSeq,temp.FSupplierID,temp.FPurOrgUnitID,temp.FMaterialID";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.querySql(params, ctx));
        sql.append(subWhere);
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected String getOrgListId(Object[] infos) throws EASBizException {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Integer fisleaf = (Integer)((FullOrgUnitInfo)infos[i]).get("isleaf");
            if (fisleaf != 1) continue;
            OrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        String orgunitListId = new String();
        if (OrgunitId.toString().length() <= 1) {
            throw new SMReportException(SMReportException.NO_ENTITY_STORAGEID);
        }
        orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }
}

