/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.assistant.Currency;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractPurOrderScoutRptFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurOrderScoutRptFacadeControllerBean
extends AbstractPurOrderScoutRptFacadeControllerBean {
    private static final long serialVersionUID = -2439701437142051371L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurOrderScoutRptFacadeControllerBean");
    private static final Currency currency = null;
    private String purChaseUnitTempTableStr = "PurChaseUnitTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    boolean isReceivale = true;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("PurChaseUnitTempTable"), ctx);
        if (params.getBoolean("IsInWarehs")) {
            this.isReceivale = false;
        }
        String tempTable = "tempTable";
        String purChaseUnitTempTable = "purChaseUnitTempTable";
        purChaseUnitTempTable = this.buildStorageOrgTable(ctx, purChaseUnitTempTable, params);
        params.setString("PurChaseUnitTempTable", purChaseUnitTempTable);
        tempTable = this.createTempTableAndInsertData(ctx, tempTable, params);
        params.setString("tempTable", tempTable);
        String countSql = "select count(1) cc from ( " + this.querySql(params, ctx) + ") ttt";
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setPurOrderRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.purChaseUnitTempTableStr, purChaseUnitTempTable);
        return result;
    }

    private String buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        String locLan = ctx.getLocale().getLanguage();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" nvarchar(255),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        orgTempTable = this.createTempTable(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        purChaseOrg = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])purChaseOrg, (String)"PurOrderScoutRptUI_view");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null && parent.getId() != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
        return orgTempTable;
    }

    private String createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        tempTable = this.createTempTable(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        sql = this.getPurOrderRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
        this.executeUpdate(ctx, "delete from " + tempTable + " where FNonWarehsQty <= 0", null);
        return tempTable;
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FPurorderNumber Varchar(88) \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FBaseStatus int \r\n");
        sql.append(",FBIZTYPEID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FPurChaseUnitID Varchar(44)\r\n");
        sql.append(",FStorageOrgUnit nvarchar(255)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FQty  Decimal(28,10)\r\n");
        sql.append(",FTotalReceiveQty  Decimal(28,10)\r\n");
        sql.append(",FNonWarehsQty  Decimal(28,10)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("SupplierTo") != null) {
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
        if (params.getString("BiztypeFrom") != null) {
            sqlParams.setString(count++, params.getString("BiztypeFrom"));
        }
        if (params.getString("BiztypeTo") != null) {
            sqlParams.setString(count++, params.getString("BiztypeTo"));
        }
    }

    private String getPurOrderRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        String locLan = ctx.getLocale().getLanguage();
        StringBuffer purOrderBuffer = new StringBuffer();
        StringBuffer selectStr = new StringBuffer();
        selectStr.append("insert into ").append(tableName);
        selectStr.append("  SELECT newbosid('88888888'),PURORDER.FNumber,entries.FDeliveryDate");
        selectStr.append(" \r\n ,PURORDER.FBaseStatus,PURORDER.FBizTypeID,PURORDER.FSupplierID,ORG.FID");
        selectStr.append(" \r\n ,storage.Fname_").append(locLan);
        selectStr.append(" \r\n ,ENTRIES.FMaterialID,ENTRIES.FUnitID");
        selectStr.append("\r\n ,TO_DECIMAL(ENTRIES.FQty,21,8)");
        selectStr.append("\r\n ,case when DataFrom.FtotalReceiveQty is null then 0 ");
        selectStr.append(" else round(decimal(DataFrom.FtotalReceiveQty/mmunit.FBaseConvsRate,21,8),mmunit.FQtyPrecision) end ");
        selectStr.append("\r\n ,case when DataFrom.FtotalReceiveQty is null then TO_DECIMAL(ENTRIES.FQty,21,8) ");
        selectStr.append("\r\n else  round(TO_DECIMAL(ENTRIES.FQty -  (decimal(DataFrom.FtotalReceiveQty/mmunit.FBaseConvsRate,21,8)) ,21,8),mmunit.FQtyPrecision) end");
        purOrderBuffer.append(selectStr.toString());
        purOrderBuffer.append("\r\n FROM T_SM_PurOrder AS PURORDER");
        purOrderBuffer.append("\r\n  INNER JOIN T_SM_PurOrderEntry AS ENTRIES");
        purOrderBuffer.append(" ON PURORDER.FID = ENTRIES.FParentID");
        purOrderBuffer.append("\r\n left outer join T_BD_MultiMeasureUnit mmunit ");
        purOrderBuffer.append("\r\n on ENTRIES.FMaterialID = mmunit.FmaterialID and ENTRIES.funitid=mmunit.FMeasureUnitID");
        purOrderBuffer.append("\r\n  INNER JOIN T_ORG_STORAGE AS storage");
        purOrderBuffer.append(" ON storage.FID = ENTRIES.FstorageorgunitID");
        purOrderBuffer.append("\r\n  INNER JOIN ");
        purOrderBuffer.append(params.getString("PurChaseUnitTempTable"));
        purOrderBuffer.append(" ORG");
        purOrderBuffer.append("  ON PURORDER.FPurchaseOrgUnitID = ORG.FID");
        if (this.isReceivale) {
            purOrderBuffer.append(this.getQueryFromReceival(params));
        } else {
            purOrderBuffer.append(this.getQueryFromInwarehs(params));
        }
        String purOrderStr = this.getQueryStr(params, "ENTRIES", purOrderBuffer, ctx);
        sql = purOrderBuffer + purOrderStr;
        return sql;
    }

    private String getQueryFromReceival(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromReceivale = new StringBuffer();
        tatolFromReceivale.append("\r\n left outer join (");
        tatolFromReceivale.append("\r\n  select receival.FPurOrderID FPurOrderID");
        tatolFromReceivale.append(",o.FID FPurOrderEntryID ");
        tatolFromReceivale.append("\r\n ,decimal(round(sum(receival.FbaseQty ),8),21,8) as FtotalReceiveQty ");
        tatolFromReceivale.append("\r\n from T_IM_PurReceivalBill xx ");
        tatolFromReceivale.append("\r\n inner join T_IM_PurReceivalentry receival on xx.fid=receival.FParentID");
        tatolFromReceivale.append("\r\n inner join T_SM_PurOrderEntry o on o.fparentid=receival.fpurorderid ");
        tatolFromReceivale.append(" and receival.FPURORDERENTRYID=o.fid");
        tatolFromReceivale.append(" and receival.FStorageOrgUnitID=o.FStorageOrgUnitID");
        tatolFromReceivale.append("\r\n where ");
        tatolFromReceivale.append("(xx.Fbasestatus = ").append(4);
        tatolFromReceivale.append(" or xx.Fbasestatus = ").append(7);
        if (params.getBoolean("IsSave")) {
            tatolFromReceivale.append(" or xx.Fbasestatus = ").append(1);
        }
        if (params.getBoolean("IsSubmit")) {
            tatolFromReceivale.append(" or xx.Fbasestatus = ").append(2);
        }
        tatolFromReceivale.append(" )");
        tatolFromReceivale.append("\r\n group by receival.FPurOrderID,o.FID ");
        tatolFromReceivale.append("\r\n )  DataFrom on PURORDER.FID = DataFrom.FPurOrderID and ENTRIES.FID= DataFrom.FPurOrderEntryID");
        return tatolFromReceivale.toString();
    }

    private String getQueryFromInwarehs(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromInwarehs = new StringBuffer();
        tatolFromInwarehs.append("\r\n left outer join (");
        tatolFromInwarehs.append("\r\n  select InWarehs.FPurOrderID FPurOrderID");
        tatolFromInwarehs.append(",o.FID FPurOrderEntryID ");
        tatolFromInwarehs.append("\r\n ,decimal(round(sum(InWarehs.FbaseQty ),8),21,8) as FtotalReceiveQty ");
        tatolFromInwarehs.append("\r\n from T_IM_PurInWarehsBill xx ");
        tatolFromInwarehs.append("\r\n inner join T_IM_PurInWarehsEntry InWarehs on xx.FID = InWarehs.FParentID");
        tatolFromInwarehs.append("\r\n inner join T_SM_PurOrderEntry o on o.fparentid=InWarehs.fpurorderid ");
        tatolFromInwarehs.append(" and InWarehs.FPURORDERENTRYID=o.fid");
        tatolFromInwarehs.append(" and InWarehs.FStorageOrgUnitID=o.FStorageOrgUnitID");
        tatolFromInwarehs.append("\r\n where ");
        tatolFromInwarehs.append("(xx.Fbasestatus = ").append(4);
        tatolFromInwarehs.append(" or xx.Fbasestatus = ").append(7);
        if (params.getBoolean("IsSave")) {
            tatolFromInwarehs.append(" or xx.Fbasestatus = ").append(1);
        }
        if (params.getBoolean("IsSubmit")) {
            tatolFromInwarehs.append(" or xx.Fbasestatus = ").append(2);
        }
        tatolFromInwarehs.append(" )");
        tatolFromInwarehs.append("\r\n group by InWarehs.FPurOrderID,o.FID ");
        tatolFromInwarehs.append("\r\n )  DataFrom on PURORDER.FID = DataFrom.FPurOrderID and ENTRIES.FID= DataFrom.FPurOrderEntryID");
        return tatolFromInwarehs.toString();
    }

    private String getQueryStr(RptParams params, String purOrderEntryName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd").substring(0, 10) + " 23:59:59";
        queryStr.append("\r\n where ");
        queryStr.append(" ENTRIES.Fbasestatus =4  and ").append(purOrderEntryName + ".FDeliveryDate  >= {" + bd + "} and " + purOrderEntryName + ".FDeliveryDate <= {" + ed + "}");
        if (params.getObject("StorageOrg") != null) {
            String storageNum = params.getObject("StorageOrg").toString();
            String[] storages = storageNum.split(";");
            StringBuffer nums = new StringBuffer();
            for (int i = 0; i < storages.length; ++i) {
                if (i > 0) {
                    nums.append(",");
                }
                nums.append("'");
                nums.append(storages[i].trim());
                nums.append("'");
            }
            if (nums.length() > 0) {
                queryStr.append(" and storage.Fnumber in (");
                queryStr.append(nums.toString());
                queryStr.append(")");
            }
        }
        if (params.getObject("materialFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and material.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and material.FNumber in (").append(numArray[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName >= '").append(shortNameFrom.trim()).append("' ");
                if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
                }
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                queryStr.append(" and material.FShortName <= '").append(shortNameTo.trim()).append("' ");
                if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                    purBuffer.append("\r\n inner join T_BD_Material material ");
                    purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
                }
            }
        }
        if (params.getObject("SupplierFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("SupplierFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and Supplier.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and Supplier.FNumber in (").append(numArray[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = PURORDER.FSupplierID ");
            }
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and Supplier.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = PURORDER.FSupplierID ");
            }
        }
        if (params.getString("BiztypeFrom") != null) {
            queryStr.append(" and BIZTYPE.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PURORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getString("BiztypeTo") != null) {
            queryStr.append(" and BIZTYPE.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PURORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setPurOrderRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("BillNumber", ctx);
        String deliverydate = this.getServerResource("DeliveryDate", ctx);
        String billStatus = this.getServerResource("BillStatus", ctx);
        String bizType = this.getServerResource("BizType", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String purChaseUnitName = this.getServerResource("PurchaseUnit", ctx);
        String storageOrg = this.getServerResource("storageOrgUnit", ctx);
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String quatity = this.getServerResource("qty", ctx);
        String totalReceiveQty = this.getServerResource("TotalReceiveQty", ctx);
        String totalInwarehsQty = this.getServerResource("TotalInWarehsQty", ctx);
        String noInWarehsQty = this.getServerResource("NoInWarehsQty", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        Object[][] labels = new Object[1][16];
        String[] cols = new String[16];
        if (ckBxShowMShortName) {
            labels = new Object[1][17];
            cols = new String[17];
        }
        int m = 9;
        cols[0] = "ORDER_NUM";
        cols[1] = "DELIVERYDATE";
        cols[2] = "BASESTATUS";
        cols[3] = "BIZTYPE_NAME";
        cols[4] = "SUPPLIER_NAME";
        cols[5] = "PURCHASEORG_NAME";
        cols[6] = "storageOrg";
        cols[7] = "MATERIAL_NUMBER";
        cols[8] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        cols[m++] = "UNIT_NAME";
        cols[m++] = "ORDER_QTY";
        cols[m++] = "TOTALRECEIVE_QTY";
        cols[m++] = "NOINWAREHS_QTY";
        cols[m++] = "PURCHASEORG_FID";
        cols[m++] = "MATERIAL_FID";
        m = 9;
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNum;
        labels[0][1] = deliverydate;
        labels[0][2] = billStatus;
        labels[0][3] = bizType;
        labels[0][4] = supplierName;
        labels[0][5] = purChaseUnitName;
        labels[0][6] = storageOrg;
        labels[0][7] = materialNum;
        labels[0][8] = materialName;
        if (ckBxShowMShortName) {
            labels[0][m++] = materilShortName;
        }
        labels[0][m++] = materialModel;
        labels[0][m++] = baseUnit;
        labels[0][m++] = quatity;
        labels[0][m++] = this.isReceivale ? totalReceiveQty : totalInwarehsQty;
        labels[0][m++] = noInWarehsQty;
        labels[0][m++] = "PURCHASEORG_FID";
        labels[0][m++] = "MATERIAL_FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (col.getName().equals("DELIVERYDATE")) {
                col.setFormatPattern(dateFormat);
            }
            if (col.getName().equals("ORDER_QTY") || col.getName().equals("TOTALRECEIVE_QTY") || col.getName().equals("NOINWAREHS_QTY")) {
                col.setWidth(120);
                col.setAligment(2);
            }
            if (col.getName().equals("PURCHASEORG_FID") || col.getName().equals("MATERIAL_FID")) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";" + pattern + ";";
        return pattern;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String sort = params.getString("sort");
        if (sort == null || sort.equals("")) {
            sort = " order by temp.FPurorderNumber,temp.FSupplierID,temp.FPurChaseUnitID,temp.FMaterialID";
        }
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + sort, null, from, len, ctx);
        RptParams pp = new RptParams();
        String countSql = "select count(1) cc from ( " + this.querySql(params, ctx) + ") ttt";
        RptRowSet rstol = this.executeQuery(countSql, null, ctx);
        rstol.next();
        int count = rstol.getInt(0);
        pp.setObject("rowset", (Object)rs);
        pp.setObject("verticalCount", (Object)count);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String locLan = ctx.getLocale().getLanguage();
        String tempTable = params.getString("tempTable");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        String purChaseUnitTempTable = params.getString(this.purChaseUnitTempTableStr);
        sql.append(" SELECT temp.FPurorderNumber,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(locLan).append(" as BIZTYPE_NAME,SUPPLIER.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURCHASEORG_NAME");
        sql.append(",temp.FStorageOrgUnit").append(" AS storageOrgUnit");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(locLan).append(" AS MATERIAL_NAME,");
        sql.append(ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "");
        sql.append("mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty as QTY,").append("\r\n temp.FTotalReceiveQty as TOTALRECEIVE_QTY,").append("\r\n temp.FNonWarehsQty as NONWAREHS_QTY").append(",temp.FPurChaseUnitID as PURCHASEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(" from  " + tempTable + " temp INNER JOIN ").append(purChaseUnitTempTable).append(" org ON temp.FPurChaseUnitID = org.FID ").append(" INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ");
        return sql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  s.fid from " + param.getString("tempTable") + " s inner join T_BD_Material m on s.FMaterialID=m.FID  inner join " + param.getString("PurChaseUnitTempTable") + " org  on s.FPurChaseUnitID = org.FID  where s.FNonWarehsQty > 0 order by s.FPurorderNumber,s.FSupplierID,s.FPurChaseUnitID,s.FMaterialID";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String tempTable = params.getString("tempTable");
        String locLan = ctx.getLocale().getLanguage();
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT temp.FPurorderNumber,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(locLan).append(",SUPPLIER.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURCHASEORG_NAME");
        sql.append(",temp.FStorageOrgUnit").append(" AS storageOrgUnit");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(locLan).append(" AS MATERIAL_NAME,");
        sql.append(ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "");
        sql.append("mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty as QTY,temp.FTotalReceiveQty as TOTALRECEIVE_QTY,temp.FNonWarehsQty  as NONWAREHS_QTY").append(",temp.FPurChaseUnitID as PURCHASEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(" from  " + tempTable + " temp INNER JOIN ").append(orgTempTable).append(" org ON temp.FPurChaseUnitID = org.FID ").append(" INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append(subWhere).append(" order by temp.FPurorderNumber,temp.FSupplierID,temp.FPurChaseUnitID,temp.FMaterialID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

