/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.constants.EntityObjectInfoConstants;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractPurPerformInstanceFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurPerformInstanceFacadeControllerBean
extends AbstractPurPerformInstanceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurPerformInstanceFacadeControllerBean");
    private static String purReceivalBOSType = "15F2BD83";
    private static String purInWarehsBOSType = "783061E3";
    private static String purReturnsBOSType = "256D05E2";
    private static String apOtherBillBOSType = "48DA3A71";
    private static String paymentBillBOSType = "40284E81";
    private static String apInvoiceBillBOSType = "355EB738";
    private static String purOrderBillBOSType = "3171BFAD";
    private static String postRequisitionBillBOSType = "9CA9D08F";
    private static String saleIssueBillBillBOSType = "CC3E933B";
    private static String arOtherBillBOSType = "FC910EF3";
    private static String receivingBillBillBOSType = "FA44FD5B";
    private static String saleReturnsBillBOSType = "546F192F";
    private static String arInvoiceBillBOSType = "B8D7E578";
    private static String scmStatusEnum = "com.kingdee.eas.scm.common.BillBaseStatusEnum";
    private static String arapStatusEnum = "com.kingdee.eas.fi.ar.BillStatusEnum";
    private static String casStatusEnum = "com.kingdee.eas.fi.cas.BillStatusEnum";
    private static String arapInvoiceStatusEnum = "com.kingdee.eas.fi.ar.BillStatusEnum";
    private String queryType = "pur";
    protected ArrayList entryIdList = null;
    protected ArrayList idList = null;
    private int times = 0;
    private boolean isExecute = false;
    private ArrayList sqlList = new ArrayList();

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setString("title", params.getString(""));
        return pp;
    }

    private void buildTable(Context ctx, String tempTable) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + tempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("FBillName varchar(120),");
        sqlbf.append("FNumber varchar(100),");
        sqlbf.append("FBillStatus int,");
        sqlbf.append("FBizDate DateTime,");
        sqlbf.append("ftotalamount NUMERIC(21,8),");
        sqlbf.append("FBillEditUI varchar(80),");
        sqlbf.append("FOrder int,");
        sqlbf.append("FSourceid varchar(44),");
        sqlbf.append("FEntryid varchar(44),");
        sqlbf.append("FCreateTime DateTime,");
        sqlbf.append("FStatusEnum varchar(80),");
        sqlbf.append("FAuditDate DateTime,");
        sqlbf.append("FCloseDate DateTime");
        sqlbf.append(")");
        this.executeUpdate(sqlbf.toString(), null, ctx);
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.entryIdList = new ArrayList();
        this.entryIdList = (ArrayList)params.getObject("entryIdList");
        this.queryType = params.getString("queryType");
        String tempTable = this.getTempTableName("PurPerformInstance", ctx);
        this.buildTable(ctx, tempTable);
        this.idList = new ArrayList();
        this.idList = (ArrayList)params.getObject("idList");
        Map<Integer, List<String>> billTypeByLevels = this.getBillTypesByLevel(ctx, this.idList);
        this.insertOrderData(ctx, tempTable, this.entryIdList);
        int size = billTypeByLevels.size();
        for (int i = 0; i < size; ++i) {
            this.getLinkBill(ctx, tempTable, billTypeByLevels.get(i + 1), i + 1);
        }
        this.deleteOrderData(ctx, tempTable);
        this.afterUpdateData(ctx, tempTable);
        int count = 0;
        if (this.isExecute) {
            String countSql = "select count(1) cc from " + tempTable;
            RptRowSet rs = this.executeQuery(countSql, null, ctx);
            rs.next();
            count = rs.getInt(0);
        }
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FID");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        col = new RptTableColumn("FBillName");
        col.setWidth(120);
        header.addColumn(col);
        col = new RptTableColumn("FBillNumber");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FBaseStatus");
        col.setWidth(80);
        header.addColumn(col);
        col = new RptTableColumn("FBizDate");
        col.setWidth(90);
        col.setFormatPattern(RptCellFormatter.getDateFormat((String)"yyyy-MM-dd"));
        header.addColumn(col);
        col = new RptTableColumn("FTotalAmount");
        col.setWidth(100);
        col.setAligment(2);
        col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
        header.addColumn(col);
        col = new RptTableColumn("FBillEditUI");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        col = new RptTableColumn("FCreateTime");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        col = new RptTableColumn("FStatusEnum");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        col = new RptTableColumn("FAuditDate");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        col = new RptTableColumn("FCloseDate");
        col.setWidth(-1);
        header.addColumn(col);
        col.setHided(true);
        header.setLabels((Object[][])new Object[][]{{"FID", this.getHeaderResource("BillName", ctx), this.getHeaderResource("BillNumber", ctx), this.getHeaderResource("BillStatus", ctx), this.getHeaderResource("BizDate", ctx), this.getHeaderResource("Amount", ctx), "FEditUI", "CreateTime", "FStatusEnum", "FAuditDate", "FCloseDate"}}, true);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    public String getHeaderResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)key, (Context)ctx);
    }

    protected void afterUpdateData(Context ctx, String tempTable) throws BOSException {
        if (this.isExecute) {
            StringBuffer sqlStr = new StringBuffer();
            sqlStr.append("delete from ").append(tempTable);
            sqlStr.append(" where FBillEditUI in (");
            sqlStr.append("'").append(this.getEntityObjectInfoEditUIName(ctx, apInvoiceBillBOSType)).append("')");
            sqlStr.append(" and FBillStatus=4");
            this.executeUpdate(sqlStr.toString(), null, ctx);
        }
    }

    protected void getLinkBill(Context ctx, String tempTable, List billTypeList, int level) throws BOSException {
        if (billTypeList == null || billTypeList.size() <= 0) {
            return;
        }
        if (this.queryType.equals("pur")) {
            if (billTypeList.contains(purReturnsBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FTaxAmount", "t1.FBaseStatus", level, "FParentID", "T_SM_PurReturnsEntry", scmStatusEnum, purReturnsBOSType, "FAuditTime", ",t1.FClosedDate");
            }
            if (billTypeList.contains(purReceivalBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FAmount", "t2.FBaseStatus", level, "FParentID", "T_IM_PurReceivalEntry", scmStatusEnum, purReceivalBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(purInWarehsBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualCost", "t2.FBaseStatus", level, "FParentID", "T_IM_PurInWarehsEntry", scmStatusEnum, purInWarehsBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(apOtherBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FRecievePayAmount", "t2.FBillStatus", level, "FParentID", "T_AP_OtherBillentry", arapStatusEnum, apOtherBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(paymentBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualAmt", "t2.FBillStatus", level, "FPaymentBillID", "T_CAS_PaymentBillEntry", casStatusEnum, paymentBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(apInvoiceBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualAmount", "t2.FBillStatus ", level, "FParentId", "T_AP_ApInvoiceEntry", arapInvoiceStatusEnum, apInvoiceBillBOSType, "FBillDate", "");
            }
        }
        if (this.queryType.equals("sale")) {
            if (billTypeList.contains(purReturnsBOSType)) {
                this.insertBillData(ctx, tempTable, "0.00", "t1.FBaseStatus", level, "FParentID", "T_SM_PurReturnsEntry", scmStatusEnum, purReturnsBOSType, "FAuditTime", ",t1.FClosedDate");
            }
            if (billTypeList.contains(purOrderBillBOSType)) {
                this.insertBillData(ctx, tempTable, "0.00", "t1.FBaseStatus", level, "FParentID", "T_SM_PurOrderEntry", scmStatusEnum, purOrderBillBOSType, "FAuditTime", ",t1.FCloseDate");
            }
            if (billTypeList.contains(purInWarehsBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FTaxAmount", "t2.FBaseStatus", level, "FParentID", "T_IM_PurInWarehsEntry", scmStatusEnum, purInWarehsBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(apOtherBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FRecievePayAmount", "t2.FBillStatus", level, "FParentID", "T_AP_OtherBillentry", arapStatusEnum, apOtherBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(paymentBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualAmt", "t2.FBillStatus", level, "FPaymentBillID", "T_CAS_PaymentBillEntry", casStatusEnum, paymentBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(postRequisitionBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FAmount", "t2.FBaseStatus", level, "FParentID", "T_SD_PostRequisitionEntry", scmStatusEnum, postRequisitionBillBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(saleIssueBillBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FAmount", "t2.FBaseStatus", level, "FParentID", "T_IM_SaleIssueEntry", scmStatusEnum, saleIssueBillBillBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(saleReturnsBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FTaxAmount", "t1.FBaseStatus", level, "FParentID", "T_SD_SaleReturnsEntry", scmStatusEnum, saleReturnsBillBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(arOtherBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FRecievePayAmount", "t2.FBillStatus", level, "FParentID", "T_AR_OtherBillentry", arapStatusEnum, arOtherBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(receivingBillBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualAmt", "t2.FBillStatus", level, "FReceivingBillID", "T_CAS_ReceivingBillEntry", casStatusEnum, receivingBillBillBOSType, "FAuditDate", "");
            }
            if (billTypeList.contains(purReceivalBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FAmount", "t2.FBaseStatus", level, "FParentID", "T_IM_PurReceivalEntry", scmStatusEnum, purReceivalBOSType, "FAuditTime", "");
            }
            if (billTypeList.contains(arInvoiceBillBOSType)) {
                this.insertBillData(ctx, tempTable, "t1.FActualAmount", "t2.FBillStatus ", level, "FParentId", "T_Ar_ArInvoiceEntry", arapInvoiceStatusEnum, arInvoiceBillBOSType, "FBillDate", "");
            }
        }
    }

    protected void insertOrderData(Context ctx, String tempTable, List<String> ids) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert ").append(tempTable);
        sql.append(" (FEntryid ,FOrder) values ");
        sql.append(" (?,?)");
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            paramsList.add(new Object[]{ids.get(i), 0});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramsList);
    }

    protected void deleteOrderData(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" delete from ").append(tempTable);
        sql.append(" where FOrder = 0 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void insertBillData(Context ctx, String tempTable, String amountName, String statusName, int level, String parentName, String entryTableName, String enumName, String billBosType, String auditDate, String closeDate) throws BOSException {
        String closeStr = closeDate;
        if (closeDate.length() == 0) {
            closeStr = ",null";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ").append(tempTable);
        sql.append(" select t2.fid as FID,'");
        sql.append(this.getEntityObjectInfoDisplayName(ctx, billBosType)).append("' as FBillName,");
        sql.append("t2.FNumber as FNumber,").append(statusName).append(" as FBillStatus,t2.FBizDate,sum(").append(amountName).append(") as ftotalamount,'");
        sql.append(this.getEntityObjectInfoEditUIName(ctx, billBosType)).append("' as FBillEditUI,");
        sql.append(level).append(" as FOrder, t1.FSourceBillEntryId  as FSourceid,t1.fid as FEntryid,t2.FCreateTime,'");
        sql.append(enumName).append("' as FStatusEnum,t2.").append(auditDate).append(" as FAuditDate ").append(closeStr).append(" as FCloseDate");
        sql.append(" from ");
        sql.append(entryTableName);
        sql.append(" t1  inner join ").append(this.getEntityObjectInfoTableName(ctx, billBosType));
        sql.append(" t2 on t1.").append(parentName).append("=t2.fid ");
        sql.append(" inner join ").append(tempTable).append(" as tmp ");
        sql.append(" on tmp.FEntryid = t1.FSourceBillEntryId ");
        sql.append(" where tmp.FOrder = ").append(level - 1);
        if (enumName.equals(scmStatusEnum)) {
            sql.append(" and ").append(statusName).append("<>3");
        }
        sql.append(" group by t1.FSourceBillEntryId,t2.fid,t1.fid,t2.fnumber,t2.fbizdate,t2.FCreateTime");
        if (!statusName.equals("1 ")) {
            sql.append(",").append(statusName);
        }
        sql.append(",t2.").append(auditDate).append(closeDate);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected String getEntityObjectInfoEditUIName(Context ctx, String BOSTypeString) throws BOSException {
        return EntityObjectInfoConstants.getEntityObjectInfoEditUIName((String)BOSTypeString);
    }

    protected String getEntityObjectInfoTableName(Context ctx, String BOSTypeString) throws BOSException {
        return EntityObjectInfoConstants.getEntityObjectInfoTableName((String)BOSTypeString);
    }

    protected String getEntityObjectInfoDisplayName(Context ctx, String BOSTypeString) throws BOSException {
        return EntityObjectInfoConstants.getEntityObjectInfoDisplayName((String)BOSTypeString);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        try {
            RptRowSet rs = this.executeQuery("select FID,FBillName,FNumber,FBillStatus,FBizDate,sum(FTotalAmount) as FTotalAmount,FBillEditUI,FCreateTime,FStatusEnum,FAuditDate,FCloseDate from " + params.getString("tempTable") + " group by FID,FBillName,FNumber,FBillStatus,FBizDate,FCreateTime,FBillEditUI,FStatusEnum,FAuditDate,FCloseDate  order by FCreateTime", null, ctx);
            RptParams pp = new RptParams();
            pp.setObject("rowset", (Object)rs);
            return pp;
        }
        catch (BOSException e) {
            return null;
        }
    }

    private Map<Integer, List<String>> insertLevelTable(Context ctx, List<String> ids, String levelTable) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        int level = 1;
        boolean flag = false;
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        ArrayList<String> typeList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        StringBuffer idsSql = null;
        try {
            idsSql = this.convertArrayListToSqlString(ids);
            sql.append(" insert into ").append(levelTable);
            sql.append(" (flevel,fsrcbillid,fsrcbilltype,fdecbillid,fdecbilltype ) values ");
            sql.append(" (select 1,FsrcObjectID,FsrcEntityID ,FdestObjectID,FdestEntityID from T_BOT_Relation where FsrcObjectID in (").append(idsSql).append("))");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            sql.setLength(0);
            sql = sql.append("select fdecbilltype from  ").append(levelTable).append(" where flevel=1 ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                typeList.add(rs.getString("FdestEntityID"));
                flag = true;
            }
            if (flag) {
                map.put(level, typeList);
                ++level;
            }
            while (flag) {
                flag = false;
                sql.setLength(0);
                sql.append(" insert into ").append(levelTable);
                sql.append(" (flevel,fsrcbillid,fsrcbilltype,fdecbilltype,fdecbillid ) values ");
                sql.append(" (select ").append(level).append(" ,FsrcObjectID,FsrcEntityID ,FdestObjectID,FdestEntityID ");
                sql.append(" from T_BOT_Relation as r ");
                sql.append(" inner join ").append(levelTable).append(" as level on level.fdecbillid = r.FsrcObjectID ");
                sql.append(" where level.flevel= ").append(level - 1).append(" )");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                sql.setLength(0);
                sql = sql.append("select fdecbillid,fdecbilltype from  ").append(levelTable).append(" where flevel= ").append(level);
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    typeList.add(rs.getString("FdestEntityID"));
                    flag = true;
                }
                if (!flag) continue;
                map.put(level, typeList);
                ++level;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private Map<Integer, List<String>> getBillTypesByLevel(Context ctx, List<String> ids) throws BOSException, EASBizException {
        if (ids == null || ids.size() <= 0) {
            return null;
        }
        int level = 1;
        boolean flag = true;
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        ArrayList<String> idlist = null;
        ArrayList<String> typeList = null;
        List<String> idCol = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer idsSql = null;
        idCol = ids;
        try {
            do {
                idsSql = this.convertArrayListToSqlString(idCol);
                idlist = new ArrayList<String>();
                typeList = new ArrayList<String>();
                sql.setLength(0);
                sql = sql.append("select FdestObjectID,FdestEntityID from T_BOT_Relation where FsrcObjectID in (").append(idsSql).append(")");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    idlist.add(rs.getString("FdestObjectID"));
                    typeList.add(rs.getString("FdestEntityID"));
                }
                if (idlist.size() <= 0) {
                    flag = false;
                } else {
                    map.put(level, typeList);
                    idCol = idlist;
                }
                ++level;
            } while (flag);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private StringBuffer convertArrayListToSqlString(List<String> ids) {
        StringBuffer idsSql = new StringBuffer();
        int size = ids.size();
        for (int i = 0; i < size; ++i) {
            idsSql.append("'").append(ids.get(i)).append("'");
            if (i == size - 1) continue;
            idsSql.append(",");
        }
        return idsSql;
    }
}

